; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd,nf -verify-machineinstrs --show-mc-encoding | FileCheck --check-prefix=NF %s

define i8 @shr8m1(ptr %ptr) {
; CHECK-LABEL: shr8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrb (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd0,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8m1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrb (%rdi), %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd0,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shr = lshr i8 %a, 1
  ret i8 %shr
}

define i16 @shr16m1(ptr %ptr) {
; CHECK-LABEL: shr16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrw (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd1,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16m1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrw (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xd1,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shr = lshr i16 %a, 1
  ret i16 %shr
}

define i32 @shr32m1(ptr %ptr) {
; CHECK-LABEL: shr32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrl (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd1,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32m1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrl (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd1,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shr = lshr i32 %a, 1
  ret i32 %shr
}

define i64 @shr64m1(ptr %ptr) {
; CHECK-LABEL: shr64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrq (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd1,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64m1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrq (%rdi), %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xd1,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shr = lshr i64 %a, 1
  ret i64 %shr
}

define i8 @shr8mcl(ptr %ptr, i8 %cl) {
; CHECK-LABEL: shr8mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8mcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrb %cl, (%rdi), %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd2,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shr = lshr i8 %a, %cl
  ret i8 %shr
}

define i8 @shr8mcl_mask(ptr %ptr, i8 %cl) {
; CHECK-LABEL: shr8mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8mcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrb %cl, (%rdi), %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd2,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shamt = and i8 %cl, 31
  %shr = lshr i8 %a, %shamt
  ret i8 %shr
}

define i16 @shr16mcl(ptr %ptr, i16 %cl) {
; CHECK-LABEL: shr16mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrw %cl, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16mcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrw %cl, (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shr = lshr i16 %a, %cl
  ret i16 %shr
}

define i16 @shr16mcl_mask(ptr %ptr, i16 %cl) {
; CHECK-LABEL: shr16mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrw %cl, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16mcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrw %cl, (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shamt = and i16 %cl, 31
  %shr = lshr i16 %a, %shamt
  ret i16 %shr
}

define i32 @shr32mcl(ptr %ptr, i32 %cl) {
; CHECK-LABEL: shr32mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrl %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32mcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrl %cl, (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shr = lshr i32 %a, %cl
  ret i32 %shr
}

define i32 @shr32mcl_mask(ptr %ptr, i32 %cl) {
; CHECK-LABEL: shr32mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrl %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32mcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrl %cl, (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shamt = and i32 %cl, 31
  %shr = lshr i32 %a, %shamt
  ret i32 %shr
}

define i64 @shr64mcl(ptr %ptr, i64 %cl) {
; CHECK-LABEL: shr64mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shrq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64mcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $rcx
; NF-NEXT:    {nf} shrq %cl, (%rdi), %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shr = lshr i64 %a, %cl
  ret i64 %shr
}

define i64 @shr64mcl_mask(ptr %ptr, i64 %cl) {
; CHECK-LABEL: shr64mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shrq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64mcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $rcx
; NF-NEXT:    {nf} shrq %cl, (%rdi), %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shamt = and i64 %cl, 63
  %shr = lshr i64 %a, %shamt
  ret i64 %shr
}

define i8 @shr8mi(ptr %ptr) {
; CHECK-LABEL: shr8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrb $4, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrb $4, (%rdi), %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xc0,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shr = lshr i8 %a, 4
  ret i8 %shr
}

define i16 @shr16mi(ptr %ptr) {
; CHECK-LABEL: shr16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrw $4, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xc1,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrw $4, (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xc1,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shr = lshr i16 %a, 4
  ret i16 %shr
}

define i32 @shr32mi(ptr %ptr) {
; CHECK-LABEL: shr32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrl $4, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrl $4, (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xc1,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shr = lshr i32 %a, 4
  ret i32 %shr
}

define i64 @shr64mi(ptr %ptr) {
; CHECK-LABEL: shr64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrq $4, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrq $4, (%rdi), %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xc1,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shr = lshr i64 %a, 4
  ret i64 %shr
}

define i8 @shr8r1(i8 noundef %a) {
; CHECK-LABEL: shr8r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrb %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd0,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8r1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrb %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd0,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i8 %a, 1
  ret i8 %shr
}

define i16 @shr16r1(i16 noundef %a) {
; CHECK-LABEL: shr16r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrw %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd1,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16r1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrw %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xd1,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i16 %a, 1
  ret i16 %shr
}

define i32 @shr32r1(i32 noundef %a) {
; CHECK-LABEL: shr32r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrl %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd1,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32r1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrl %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd1,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i32 %a, 1
  ret i32 %shr
}

define i64 @shr64r1(i64 noundef %a) {
; CHECK-LABEL: shr64r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrq %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd1,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64r1:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrq %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xd1,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i64 %a, 1
  ret i64 %shr
}

define i8 @shr8rcl(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: shr8rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8rcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrb %cl, %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd2,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i8 %a, %cl
  ret i8 %shr
}

define i8 @shr8rcl_mask(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: shr8rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8rcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrb %cl, %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd2,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i8 %cl, 31
  %shr = lshr i8 %a, %shamt
  ret i8 %shr
}

define i16 @shr16rcl(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: shr16rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrw %cl, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16rcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrw %cl, %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xd3,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i16 %a, %cl
  ret i16 %shr
}

define i16 @shr16rcl_mask(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: shr16rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrw %cl, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16rcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrw %cl, %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xd3,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i16 %cl, 31
  %shr = lshr i16 %a, %shamt
  ret i16 %shr
}

define i32 @shr32rcl(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: shr32rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrl %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32rcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrl %cl, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd3,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i32 %a, %cl
  ret i32 %shr
}

define i32 @shr32rcl_mask(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: shr32rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrl %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32rcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    {nf} shrl %cl, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xd3,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i32 %cl, 31
  %shr = lshr i32 %a, %shamt
  ret i32 %shr
}

define i64 @shr64rcl(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: shr64rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shrq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64rcl:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $rcx
; NF-NEXT:    {nf} shrq %cl, %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xd3,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i64 %a, %cl
  ret i64 %shr
}

define i64 @shr64rcl_mask(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: shr64rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shrq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xef]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64rcl_mask:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $rcx
; NF-NEXT:    {nf} shrq %cl, %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xd3,0xef]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i64 %cl, 63
  %shr = lshr i64 %a, %shamt
  ret i64 %shr
}

define i8 @shr8ri(i8 noundef %a) {
; CHECK-LABEL: shr8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrb $4, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0xef,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrb $4, %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xc0,0xef,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i8 %a, 4
  ret i8 %shr
}

define i16 @shr16ri(i16 noundef %a) {
; CHECK-LABEL: shr16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrw $4, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xc1,0xef,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrw $4, %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0xc1,0xef,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i16 %a, 4
  ret i16 %shr
}

define i32 @shr32ri(i32 noundef %a) {
; CHECK-LABEL: shr32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrl $4, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0xef,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrl $4, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0xc1,0xef,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i32 %a, 4
  ret i32 %shr
}

define i64 @shr64ri(i64 noundef %a) {
; CHECK-LABEL: shr64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrq $4, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0xef,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} shrq $4, %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0xc1,0xef,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %shr = lshr i64 %a, 4
  ret i64 %shr
}

define void @shr8m1_legacy(ptr %ptr) {
; CHECK-LABEL: shr8m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrb (%rdi) # encoding: [0xd0,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8m1_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrb (%rdi) # encoding: [0xd0,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shr = lshr i8 %a, 1
  store i8 %shr, ptr %ptr
  ret void
}

define void @shr16m1_legacy(ptr %ptr) {
; CHECK-LABEL: shr16m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrw (%rdi) # encoding: [0x66,0xd1,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16m1_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrw (%rdi) # encoding: [0x66,0xd1,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shr = lshr i16 %a, 1
  store i16 %shr, ptr %ptr
  ret void
}

define void @shr32m1_legacy(ptr %ptr) {
; CHECK-LABEL: shr32m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrl (%rdi) # encoding: [0xd1,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32m1_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrl (%rdi) # encoding: [0xd1,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shr = lshr i32 %a, 1
  store i32 %shr, ptr %ptr
  ret void
}

define void @shr64m1_legacy(ptr %ptr) {
; CHECK-LABEL: shr64m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrq (%rdi) # encoding: [0x48,0xd1,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64m1_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrq (%rdi) # encoding: [0x48,0xd1,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shr = lshr i64 %a, 1
  store i64 %shr, ptr %ptr
  ret void
}

define void @shr8mi_legacy(ptr %ptr) {
; CHECK-LABEL: shr8mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrb $4, (%rdi) # encoding: [0xc0,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrb $4, (%rdi) # encoding: [0xc0,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shr = lshr i8 %a, 4
  store i8 %shr, ptr %ptr
  ret void
}

define void @shr16mi_legacy(ptr %ptr) {
; CHECK-LABEL: shr16mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrw $4, (%rdi) # encoding: [0x66,0xc1,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrw $4, (%rdi) # encoding: [0x66,0xc1,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shr = lshr i16 %a, 4
  store i16 %shr, ptr %ptr
  ret void
}

define void @shr32mi_legacy(ptr %ptr) {
; CHECK-LABEL: shr32mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrl $4, (%rdi) # encoding: [0xc1,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrl $4, (%rdi) # encoding: [0xc1,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shr = lshr i32 %a, 4
  store i32 %shr, ptr %ptr
  ret void
}

define void @shr64mi_legacy(ptr %ptr) {
; CHECK-LABEL: shr64mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrq $4, (%rdi) # encoding: [0x48,0xc1,0x2f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    shrq $4, (%rdi) # encoding: [0x48,0xc1,0x2f,0x04]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shr = lshr i64 %a, 4
  store i64 %shr, ptr %ptr
  ret void
}

define void @shr8mcl_legacy(ptr %ptr, i8 %cl) {
; CHECK-LABEL: shr8mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrb %cl, (%rdi) # encoding: [0xd2,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr8mcl_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    shrb %cl, (%rdi) # encoding: [0xd2,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shr = lshr i8 %a, %cl
  store i8 %shr, ptr %ptr
  ret void
}

define void @shr16mcl_legacy(ptr %ptr, i16 %cl) {
; CHECK-LABEL: shr16mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrw %cl, (%rdi) # encoding: [0x66,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr16mcl_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    shrw %cl, (%rdi) # encoding: [0x66,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shr = lshr i16 %a, %cl
  store i16 %shr, ptr %ptr
  ret void
}

define void @shr32mcl_legacy(ptr %ptr, i32 %cl) {
; CHECK-LABEL: shr32mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrl %cl, (%rdi) # encoding: [0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr32mcl_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $ecx
; NF-NEXT:    shrl %cl, (%rdi) # encoding: [0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shr = lshr i32 %a, %cl
  store i32 %shr, ptr %ptr
  ret void
}

define void @shr64mcl_legacy(ptr %ptr, i64 %cl) {
; CHECK-LABEL: shr64mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shrq %cl, (%rdi) # encoding: [0x48,0xd3,0x2f]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: shr64mcl_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; NF-NEXT:    # kill: def $cl killed $cl killed $rcx
; NF-NEXT:    shrq %cl, (%rdi) # encoding: [0x48,0xd3,0x2f]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shr = lshr i64 %a, %cl
  store i64 %shr, ptr %ptr
  ret void
}
