#!/bin/sh
#
# Updates list of icon files and outputs to $1.
#
set -e

output=$1
if [ -z "$output" ] ; then echo "Output .cmake file required"; exit 1; fi
script=$(basename $0)

function content()
{
    echo "# List of project's own icon files"
    echo "# This file is generated by $script"
    echo "# WARNING! All changes made in this file will be lost!"
    echo
    echo "set(_PNG_FILES"
    find . -name \*png | sed "s/\.\///g" | sort
    echo ")"
    echo

    echo "set(_SVG_OBJECT_FILES"
    find . -regex ".*/\(table\|query\|form\|report\|macro\|script\)\.svg$" \
        | sed "s/\.\///g" | sort
    echo ")"
    echo

    echo "set(_SVG_FILES"
    find . -name \*svg | grep -v -F "table.svg
query.svg
form.svg
report.svg
macro.svg
script.svg" \
        | sed "s/\.\///g" | sort
    echo ")"
    echo

    echo "set(_FILES \${_PNG_FILES} \${_SVG_OBJECT_FILES} \${_SVG_FILES})"
}

content > $output
