/* DuplicityJob.c generated by valac 0.30.0, the Vala compiler
 * generated from DuplicityJob.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>


#define TYPE_DUPLICITY_JOB (duplicity_job_get_type ())
#define DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_JOB, DuplicityJob))
#define DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_JOB, DuplicityJobClass))
#define IS_DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_JOB))
#define IS_DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_JOB))
#define DUPLICITY_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_JOB, DuplicityJobClass))

typedef struct _DuplicityJob DuplicityJob;
typedef struct _DuplicityJobClass DuplicityJobClass;
typedef struct _DuplicityJobPrivate DuplicityJobPrivate;

#define DUPLICITY_JOB_TYPE_STATE (duplicity_job_state_get_type ())

#define TYPE_DUPLICITY_INSTANCE (duplicity_instance_get_type ())
#define DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_INSTANCE, DuplicityInstance))
#define DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_INSTANCE, DuplicityInstanceClass))
#define IS_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_INSTANCE))
#define IS_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_INSTANCE))
#define DUPLICITY_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_INSTANCE, DuplicityInstanceClass))

typedef struct _DuplicityInstance DuplicityInstance;
typedef struct _DuplicityInstanceClass DuplicityInstanceClass;

#define DUPLICITY_JOB_TYPE_DATE_INFO (duplicity_job_date_info_get_type ())
typedef struct _DuplicityJobDateInfo DuplicityJobDateInfo;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __g_list_free__duplicity_job_date_info_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__duplicity_job_date_info_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DuplicityJobAsyncSetupData DuplicityJobAsyncSetupData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _DuplicityJobCheckBackupSpaceData DuplicityJobCheckBackupSpaceData;

struct _DuplicityJob {
	DejaDupToolJob parent_instance;
	DuplicityJobPrivate * priv;
};

struct _DuplicityJobClass {
	DejaDupToolJobClass parent_class;
	void (*process_error) (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in);
	void (*process_info) (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
	void (*process_warning) (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
};

typedef enum  {
	DUPLICITY_JOB_STATE_NORMAL,
	DUPLICITY_JOB_STATE_DRY_RUN,
	DUPLICITY_JOB_STATE_STATUS,
	DUPLICITY_JOB_STATE_CHECK_CONTENTS,
	DUPLICITY_JOB_STATE_CLEANUP,
	DUPLICITY_JOB_STATE_DELETE
} DuplicityJobState;

struct _DuplicityJobDateInfo {
	gboolean full;
	GTimeVal time;
};

struct _DuplicityJobPrivate {
	DejaDupToolJobMode _original_mode;
	gboolean _error_issued;
	gboolean _was_stopped;
	DuplicityJobState _state;
	DuplicityInstance* inst;
	GList* backend_argv;
	GList* saved_argv;
	GList* saved_envp;
	gboolean is_full_backup;
	gboolean cleaned_up_once;
	gboolean needs_root;
	gboolean detected_encryption;
	gboolean existing_encrypted;
	gchar* last_bad_volume;
	guint bad_volume_count;
	gboolean has_progress_total;
	guint64 progress_total;
	guint64 progress_count;
	gboolean has_checked_contents;
	gboolean has_non_home_contents;
	GList* homes;
	GList* local_error_files;
	gboolean checked_collection_info;
	gboolean got_collection_info;
	GList* collection_info;
	gboolean checked_backup_space;
	gboolean deleted_files;
	gint delete_age;
	GFile* last_touched_file;
	gchar* forced_cache_dir;
	gchar* saved_status;
	GFile* saved_status_file;
	gboolean saved_status_file_action;
	gboolean restarted_without_cache;
};

struct _DuplicityJobAsyncSetupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DuplicityJob* self;
	DejaDupToolJobFlags _tmp0_;
	DejaDupToolJobFlags _tmp1_;
	gchar* template;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	DejaDupBackend* _tmp9_;
	DejaDupBackend* _tmp10_;
	DejaDupBackend* _tmp11_;
	DejaDupBackend* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _DuplicityJobCheckBackupSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DuplicityJob* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	guint64 free;
	DejaDupBackend* _tmp2_;
	DejaDupBackend* _tmp3_;
	guint64 _tmp4_;
	guint64 total;
	DejaDupBackend* _tmp5_;
	DejaDupBackend* _tmp6_;
	guint64 _tmp7_;
	guint64 _tmp8_;
	guint64 _tmp9_;
	const gchar* _tmp10_;
	guint64 _tmp11_;
	guint64 _tmp12_;
	gboolean _tmp13_;
	gint full_dates;
	GList* _tmp14_;
	GList* info_collection;
	GList* info_it;
	DuplicityJobDateInfo info;
	DuplicityJobDateInfo _tmp15_;
	gboolean _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
};


static gpointer duplicity_job_parent_class = NULL;
static GFile* duplicity_job_slash;
static GFile* duplicity_job_slash = NULL;
static GFile* duplicity_job_slash_root;
static GFile* duplicity_job_slash_root = NULL;
static GFile* duplicity_job_slash_home;
static GFile* duplicity_job_slash_home = NULL;
static GFile* duplicity_job_slash_home_me;
static GFile* duplicity_job_slash_home_me = NULL;
static GType duplicity_job_type_id = 0;

GType duplicity_job_get_type (void) G_GNUC_CONST;
GType duplicity_job_register_type (GTypeModule * module);
GType duplicity_job_state_get_type (void) G_GNUC_CONST;
GType duplicity_instance_get_type (void) G_GNUC_CONST;
GType duplicity_instance_register_type (GTypeModule * module);
static GType duplicity_job_date_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static DuplicityJobDateInfo* duplicity_job_date_info_dup (const DuplicityJobDateInfo* self);
static void duplicity_job_date_info_free (DuplicityJobDateInfo* self);
#define DUPLICITY_JOB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DUPLICITY_JOB, DuplicityJobPrivate))
enum  {
	DUPLICITY_JOB_DUMMY_PROPERTY,
	DUPLICITY_JOB_STATE
};
static void duplicity_job_network_changed (DuplicityJob* self);
static void _duplicity_job_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _duplicity_job_date_info_free0_ (gpointer var);
static void _g_list_free__duplicity_job_date_info_free0_ (GList* self);
#define DUPLICITY_JOB_MINIMUM_FULL 2
#define DUPLICITY_JOB_ERROR_GENERIC 1
#define DUPLICITY_JOB_ERROR_HOSTNAME_CHANGED 3
#define DUPLICITY_JOB_ERROR_RESTORE_DIR_NOT_FOUND 19
#define DUPLICITY_JOB_ERROR_EXCEPTION 30
#define DUPLICITY_JOB_ERROR_GPG 31
#define DUPLICITY_JOB_ERROR_BAD_VOLUME 44
#define DUPLICITY_JOB_ERROR_BACKEND 50
#define DUPLICITY_JOB_ERROR_BACKEND_PERMISSION_DENIED 51
#define DUPLICITY_JOB_ERROR_BACKEND_NOT_FOUND 52
#define DUPLICITY_JOB_ERROR_BACKEND_NO_SPACE 53
#define DUPLICITY_JOB_INFO_PROGRESS 2
#define DUPLICITY_JOB_INFO_COLLECTION_STATUS 3
#define DUPLICITY_JOB_INFO_DIFF_FILE_NEW 4
#define DUPLICITY_JOB_INFO_DIFF_FILE_CHANGED 5
#define DUPLICITY_JOB_INFO_DIFF_FILE_DELETED 6
#define DUPLICITY_JOB_INFO_PATCH_FILE_WRITING 7
#define DUPLICITY_JOB_INFO_PATCH_FILE_PATCHING 8
#define DUPLICITY_JOB_INFO_FILE_STAT 10
#define DUPLICITY_JOB_INFO_SYNCHRONOUS_UPLOAD_BEGIN 11
#define DUPLICITY_JOB_INFO_ASYNCHRONOUS_UPLOAD_BEGIN 12
#define DUPLICITY_JOB_INFO_SYNCHRONOUS_UPLOAD_DONE 13
#define DUPLICITY_JOB_INFO_ASYNCHRONOUS_UPLOAD_DONE 14
#define DUPLICITY_JOB_WARNING_ORPHANED_SIG 2
#define DUPLICITY_JOB_WARNING_UNNECESSARY_SIG 3
#define DUPLICITY_JOB_WARNING_UNMATCHED_SIG 4
#define DUPLICITY_JOB_WARNING_INCOMPLETE_BACKUP 5
#define DUPLICITY_JOB_WARNING_ORPHANED_BACKUP 6
#define DUPLICITY_JOB_WARNING_CANNOT_READ 10
#define DUPLICITY_JOB_WARNING_CANNOT_PROCESS 12
#define DUPLICITY_JOB_DEBUG_GENERIC 1
static void duplicity_job_real_start (DejaDupToolJob* base);
static DejaDupToolJobMode duplicity_job_get_original_mode (DuplicityJob* self);
static void duplicity_job_set_original_mode (DuplicityJob* self, DejaDupToolJobMode value);
static void duplicity_job_process_include_excludes (DuplicityJob* self);
static void duplicity_job_async_setup (DuplicityJob* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void duplicity_job_async_setup_finish (DuplicityJob* self, GAsyncResult* _res_);
static void duplicity_job_async_setup_data_free (gpointer _data);
static gboolean duplicity_job_async_setup_co (DuplicityJobAsyncSetupData* _data_);
static void duplicity_job_async_setup_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void duplicity_job_continue_with_envp (DuplicityJob* self, DejaDupBackend* b, gboolean success, GList* envp, const gchar* _error_);
static void _duplicity_job_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, const gchar* _error_, gpointer self);
static gboolean duplicity_job_restart (DuplicityJob* self);
static gint duplicity_job_cmp_prefix (DuplicityJob* self, GFile* a, GFile* b);
static gchar* duplicity_job_get_remote (DuplicityJob* self);
static void duplicity_job_expand_links_in_file (DuplicityJob* self, GFile* file, GList** all, gboolean include, GList* seen);
static gint ______lambda6_ (GFile* a, GFile* b);
static gint _______lambda6__gcompare_func (gconstpointer a, gconstpointer b);
static void duplicity_job_expand_links_in_list (DuplicityJob* self, GList** all, gboolean include);
static gchar* duplicity_job_escape_duplicity_path (DuplicityJob* self, const gchar* path);
static void duplicity_job_real_cancel (DejaDupToolJob* base);
DuplicityJobState duplicity_job_get_state (DuplicityJob* self);
static gboolean duplicity_job_cleanup (DuplicityJob* self);
static void duplicity_job_cancel_inst (DuplicityJob* self);
static void duplicity_job_real_stop (DejaDupToolJob* base);
static void duplicity_job_set_was_stopped (DuplicityJob* self, gboolean value);
static void duplicity_job_real_pause (DejaDupToolJob* base, const gchar* reason);
void duplicity_instance_pause (DuplicityInstance* self);
static void duplicity_job_set_status (DuplicityJob* self, const gchar* msg, gboolean save);
static void duplicity_job_real_resume (DejaDupToolJob* base);
void duplicity_instance_resume (DuplicityInstance* self);
static void duplicity_job_set_saved_status (DuplicityJob* self);
static void duplicity_job_disconnect_inst (DuplicityJob* self);
static void duplicity_job_handle_done (DuplicityJob* self, DuplicityInstance* inst, gboolean success, gboolean cancelled);
void duplicity_job_set_state (DuplicityJob* self, DuplicityJobState value);
static void duplicity_job_check_backup_space (DuplicityJob* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void duplicity_job_check_backup_space_finish (DuplicityJob* self, GAsyncResult* _res_);
static GFile* duplicity_job_make_local_rel_path (DuplicityJob* self, GFile* file);
static void duplicity_job_show_error (DuplicityJob* self, const gchar* errorstr, const gchar* detail);
static void duplicity_job_connect_and_start (DuplicityJob* self, GList* argv_extra, GList* envp_extra, GList* argv_entire, GFile* custom_local);
static void duplicity_job_check_backup_space_data_free (gpointer _data);
static gboolean duplicity_job_check_backup_space_co (DuplicityJobCheckBackupSpaceData* _data_);
static void duplicity_job_check_backup_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void duplicity_job_delete_excess (DuplicityJob* self, gint cutoff);
static gboolean duplicity_job_can_ignore_error (DuplicityJob* self);
static gboolean duplicity_job_delete_files_if_needed (DuplicityJob* self);
static gboolean duplicity_job_get_was_stopped (DuplicityJob* self);
static gboolean duplicity_job_get_error_issued (DuplicityJob* self);
static void duplicity_job_set_status_file (DuplicityJob* self, GFile* file, gboolean action, gboolean save);
static void duplicity_job_delete_cache (DuplicityJob* self);
static gboolean duplicity_job_restart_without_cache (DuplicityJob* self);
static void duplicity_job_handle_exit (DuplicityJob* self, gint code);
static void duplicity_job_handle_message (DuplicityJob* self, DuplicityInstance* inst, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text);
void duplicity_job_process_error (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in);
void duplicity_job_process_info (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
void duplicity_job_process_warning (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
static gboolean duplicity_job_ask_question (DuplicityJob* self, const gchar* t, const gchar* m);
static gchar* duplicity_job_parse_duplicity_file (DuplicityJob* self, const gchar* file, gint skip_bits);
static void duplicity_job_real_process_error (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in);
static void duplicity_job_process_exception (DuplicityJob* self, const gchar* exception, const gchar* text);
static GFile* duplicity_job_make_file_obj (DuplicityJob* self, const gchar* file);
static void duplicity_job_real_process_info (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
static void duplicity_job_process_diff_file (DuplicityJob* self, const gchar* file);
static void duplicity_job_process_patch_file (DuplicityJob* self, const gchar* file);
static void duplicity_job_process_progress (DuplicityJob* self, gchar** firstline, int firstline_length1);
static void duplicity_job_process_collection_status (DuplicityJob* self, GList* lines);
static void duplicity_job_process_file_stat (DuplicityJob* self, const gchar* date, const gchar* file, GList* data, const gchar* text);
static void duplicity_job_real_process_warning (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
static void duplicity_job_set_error_issued (DuplicityJob* self, gboolean value);
static gint duplicity_job_get_volsize (DuplicityJob* self);
static void _duplicity_job_handle_done_duplicity_instance_done (DuplicityInstance* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _duplicity_job_handle_message_duplicity_instance_message (DuplicityInstance* _sender, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text, gpointer self);
static void _duplicity_job_handle_exit_duplicity_instance_exited (DuplicityInstance* _sender, gint code, gpointer self);
void duplicity_instance_cancel (DuplicityInstance* self);
DuplicityInstance* duplicity_instance_new (void);
DuplicityInstance* duplicity_instance_construct (GType object_type);
void duplicity_instance_set_forced_cache_dir (DuplicityInstance* self, const gchar* value);
void duplicity_instance_start (DuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GAsyncReadyCallback _callback_, gpointer _user_data_);
void duplicity_instance_start_finish (DuplicityInstance* self, GAsyncResult* _res_);
DuplicityJob* duplicity_job_new (void);
DuplicityJob* duplicity_job_construct (GType object_type);
static GObject * duplicity_job_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void duplicity_job_finalize (GObject* obj);
static void _vala_duplicity_job_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_duplicity_job_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _duplicity_job_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	duplicity_job_network_changed ((DuplicityJob*) self);
}


GType duplicity_job_state_get_type (void) {
	static volatile gsize duplicity_job_state_type_id__volatile = 0;
	if (g_once_init_enter (&duplicity_job_state_type_id__volatile)) {
		static const GEnumValue values[] = {{DUPLICITY_JOB_STATE_NORMAL, "DUPLICITY_JOB_STATE_NORMAL", "normal"}, {DUPLICITY_JOB_STATE_DRY_RUN, "DUPLICITY_JOB_STATE_DRY_RUN", "dry-run"}, {DUPLICITY_JOB_STATE_STATUS, "DUPLICITY_JOB_STATE_STATUS", "status"}, {DUPLICITY_JOB_STATE_CHECK_CONTENTS, "DUPLICITY_JOB_STATE_CHECK_CONTENTS", "check-contents"}, {DUPLICITY_JOB_STATE_CLEANUP, "DUPLICITY_JOB_STATE_CLEANUP", "cleanup"}, {DUPLICITY_JOB_STATE_DELETE, "DUPLICITY_JOB_STATE_DELETE", "delete"}, {0, NULL, NULL}};
		GType duplicity_job_state_type_id;
		duplicity_job_state_type_id = g_enum_register_static ("DuplicityJobState", values);
		g_once_init_leave (&duplicity_job_state_type_id__volatile, duplicity_job_state_type_id);
	}
	return duplicity_job_state_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _duplicity_job_date_info_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (duplicity_job_date_info_free (var), NULL));
}


static void _g_list_free__duplicity_job_date_info_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _duplicity_job_date_info_free0_, NULL);
	g_list_free (self);
}


static void duplicity_job_network_changed (DuplicityJob* self) {
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		deja_dup_tool_job_resume ((DejaDupToolJob*) self);
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = _ ("Paused (no network)");
		deja_dup_tool_job_pause ((DejaDupToolJob*) self, _tmp5_);
	}
}


static void duplicity_job_real_start (DejaDupToolJob* base) {
	DuplicityJob * self;
	DejaDupToolJobMode _tmp0_ = 0;
	DejaDupToolJobMode _tmp3_ = 0;
	DejaDupBackend* _tmp4_ = NULL;
	DejaDupBackend* _tmp5_ = NULL;
	DejaDupBackend* _tmp6_ = NULL;
	DejaDupBackend* _tmp7_ = NULL;
	DejaDupToolJobMode _tmp8_ = 0;
	DejaDupToolJobMode _tmp9_ = 0;
	DejaDupToolJobMode _tmp10_ = 0;
	DejaDupToolJobMode _tmp11_ = 0;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	self = (DuplicityJob*) base;
	_tmp0_ = self->priv->_original_mode;
	if (_tmp0_ == DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		DejaDupToolJobMode _tmp1_ = 0;
		DejaDupToolJobMode _tmp2_ = 0;
		_tmp1_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
		_tmp2_ = _tmp1_;
		duplicity_job_set_original_mode (self, _tmp2_);
	}
	_tmp3_ = self->priv->_original_mode;
	deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, _tmp3_);
	__g_list_free__g_free0_0 (self->priv->saved_argv);
	self->priv->saved_argv = NULL;
	__g_list_free__g_free0_0 (self->priv->saved_envp);
	self->priv->saved_envp = NULL;
	__g_list_free__g_free0_0 (self->priv->backend_argv);
	self->priv->backend_argv = NULL;
	_tmp4_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp5_ = _tmp4_;
	deja_dup_backend_add_argv (_tmp5_, DEJA_DUP_TOOL_JOB_MODE_INVALID, &self->priv->backend_argv);
	_tmp6_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp9_ = _tmp8_;
	deja_dup_backend_add_argv (_tmp7_, _tmp9_, &self->priv->saved_argv);
	_tmp10_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		duplicity_job_process_include_excludes (self);
	}
	_tmp12_ = deja_dup_get_settings (NULL);
	settings = _tmp12_;
	_tmp13_ = g_settings_get_int ((GSettings*) settings, DEJA_DUP_DELETE_AFTER_KEY);
	self->priv->delete_age = _tmp13_;
	duplicity_job_async_setup (self, NULL, NULL);
	_g_object_unref0 (settings);
}


static void duplicity_job_async_setup_data_free (gpointer _data) {
	DuplicityJobAsyncSetupData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DuplicityJobAsyncSetupData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void duplicity_job_async_setup (DuplicityJob* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DuplicityJobAsyncSetupData* _data_;
	DuplicityJob* _tmp0_ = NULL;
	_data_ = g_slice_new0 (DuplicityJobAsyncSetupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, duplicity_job_async_setup);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, duplicity_job_async_setup_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	duplicity_job_async_setup_co (_data_);
}


static void duplicity_job_async_setup_finish (DuplicityJob* self, GAsyncResult* _res_) {
	DuplicityJobAsyncSetupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void duplicity_job_async_setup_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DuplicityJobAsyncSetupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	duplicity_job_async_setup_co (_data_);
}


static void _duplicity_job_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, const gchar* _error_, gpointer self) {
	duplicity_job_continue_with_envp ((DuplicityJob*) self, _sender, success, envp, _error_);
}


static gboolean duplicity_job_async_setup_co (DuplicityJobAsyncSetupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = deja_dup_tool_job_get_flags ((DejaDupToolJob*) _data_->self);
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->_tmp0_;
	if ((_data_->_tmp1_ & DEJA_DUP_TOOL_JOB_FLAGS_NO_CACHE) != 0) {
		_data_->_state_ = 1;
		deja_dup_get_tempdir (duplicity_job_async_setup_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = deja_dup_get_tempdir_finish (_data_->_res_);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_build_filename (_data_->_tmp3_, "duplicity-XXXXXX", NULL);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_free0 (_data_->_tmp3_);
		_data_->template = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->template;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = mkdtemp (_data_->_tmp7_);
		_g_free0 (_data_->self->priv->forced_cache_dir);
		_data_->self->priv->forced_cache_dir = _data_->_tmp8_;
		_g_free0 (_data_->template);
	}
	{
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		g_signal_connect_object (_data_->_tmp10_, "envp-ready", (GCallback) _duplicity_job_continue_with_envp_deja_dup_backend_envp_ready, _data_->self, 0);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_state_ = 2;
		deja_dup_backend_get_envp (_data_->_tmp12_, duplicity_job_async_setup_ready, _data_);
		return FALSE;
		_state_2:
		deja_dup_backend_get_envp_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "raise-error", _data_->_tmp14_, NULL);
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE, NULL);
		_g_error_free0 (_data_->e);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void duplicity_job_continue_with_envp (DuplicityJob* self, DejaDupBackend* b, gboolean success, GList* envp, const gchar* _error_) {
	DejaDupBackend* _tmp0_ = NULL;
	DejaDupBackend* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	GList* _tmp6_ = NULL;
	gboolean _tmp10_ = FALSE;
	DejaDupBackend* _tmp11_ = NULL;
	DejaDupBackend* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("envp-ready", DEJA_DUP_TYPE_BACKEND, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _duplicity_job_continue_with_envp_deja_dup_backend_envp_ready, self);
	_tmp3_ = success;
	if (!_tmp3_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = _error_;
		if (_tmp4_ != NULL) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = _error_;
			g_signal_emit_by_name ((DejaDupToolJob*) self, "raise-error", _tmp5_, NULL);
		}
		g_signal_emit_by_name ((DejaDupToolJob*) self, "done", FALSE, FALSE, NULL);
		return;
	}
	_tmp6_ = envp;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp6_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp7_ = NULL;
			gchar* s = NULL;
			_tmp7_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp7_;
			{
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				_tmp8_ = s;
				_tmp9_ = g_strdup (_tmp8_);
				self->priv->saved_envp = g_list_append (self->priv->saved_envp, _tmp9_);
				_g_free0 (s);
			}
		}
	}
	_tmp10_ = duplicity_job_restart (self);
	if (!_tmp10_) {
		g_signal_emit_by_name ((DejaDupToolJob*) self, "done", FALSE, FALSE, NULL);
	}
	_tmp11_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = deja_dup_backend_is_native (_tmp12_);
	if (!_tmp13_) {
		DejaDupNetwork* _tmp14_ = NULL;
		DejaDupNetwork* _tmp15_ = NULL;
		DejaDupNetwork* _tmp16_ = NULL;
		DejaDupNetwork* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		_tmp14_ = deja_dup_network_get ();
		_tmp15_ = _tmp14_;
		g_signal_connect_object ((GObject*) _tmp15_, "notify::connected", (GCallback) _duplicity_job_network_changed_g_object_notify, self, 0);
		_g_object_unref0 (_tmp15_);
		_tmp16_ = deja_dup_network_get ();
		_tmp17_ = _tmp16_;
		_tmp18_ = deja_dup_network_get_connected (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = !_tmp19_;
		_g_object_unref0 (_tmp17_);
		if (_tmp20_) {
			const gchar* _tmp21_ = NULL;
			g_debug ("DuplicityJob.vala:171: No connection found. Postponing the backup.");
			_tmp21_ = _ ("Paused (no network)");
			deja_dup_tool_job_pause ((DejaDupToolJob*) self, _tmp21_);
		}
	}
}


static gint duplicity_job_cmp_prefix (DuplicityJob* self, GFile* a, GFile* b) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		GFile* _tmp2_ = NULL;
		_tmp2_ = b;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		GFile* _tmp4_ = NULL;
		_tmp4_ = b;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			GFile* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			_tmp5_ = a;
			_tmp6_ = b;
			_tmp7_ = g_file_has_prefix (_tmp5_, _tmp6_);
			_tmp3_ = _tmp7_;
		}
		if (_tmp3_) {
			result = -1;
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			GFile* _tmp9_ = NULL;
			_tmp9_ = a;
			if (_tmp9_ == NULL) {
				_tmp8_ = TRUE;
			} else {
				GFile* _tmp10_ = NULL;
				GFile* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				_tmp10_ = b;
				_tmp11_ = a;
				_tmp12_ = g_file_has_prefix (_tmp10_, _tmp11_);
				_tmp8_ = _tmp12_;
			}
			if (_tmp8_) {
				result = 1;
				return result;
			} else {
				result = 0;
				return result;
			}
		}
	}
}


static gchar* duplicity_job_get_remote (DuplicityJob* self) {
	gchar* result = NULL;
	DejaDupBackend* _tmp0_ = NULL;
	DejaDupBackend* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_backend_get_location (_tmp1_, &self->priv->needs_root);
	result = _tmp2_;
	return result;
}


static gint ______lambda6_ (GFile* a, GFile* b) {
	gint result = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		GFile* _tmp4_ = NULL;
		_tmp4_ = b;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = a;
		_tmp6_ = b;
		_tmp7_ = g_file_equal (_tmp5_, _tmp6_);
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	result = _tmp0_;
	return result;
}


static gint _______lambda6__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ______lambda6_ ((GFile*) a, (GFile*) b);
	return result;
}


static void duplicity_job_expand_links_in_file (DuplicityJob* self, GFile* file, GList** all, gboolean include, GList* seen) {
	GList* pieces = NULL;
	GFile* iter = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* parent = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	pieces = NULL;
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = g_file_get_parent (_tmp2_);
		_g_object_unref0 (parent);
		parent = _tmp3_;
		_tmp4_ = parent;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = parent;
		_tmp6_ = iter;
		_tmp7_ = g_file_get_relative_path (_tmp5_, _tmp6_);
		pieces = g_list_prepend (pieces, _tmp7_);
		_tmp8_ = parent;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (iter);
		iter = _tmp9_;
	}
	{
		GFile* so_far = NULL;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		GList* _tmp12_ = NULL;
		GList* _tmp52_ = NULL;
		_tmp10_ = duplicity_job_slash;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		so_far = _tmp11_;
		_tmp12_ = pieces;
		{
			GList* piece_collection = NULL;
			GList* piece_it = NULL;
			piece_collection = _tmp12_;
			for (piece_it = piece_collection; piece_it != NULL; piece_it = piece_it->next) {
				const gchar* piece = NULL;
				piece = (const gchar*) piece_it->data;
				{
					GFile* _tmp13_ = NULL;
					GFile* _tmp14_ = NULL;
					GFile* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					GFile* _tmp17_ = NULL;
					GFileInfo* info = NULL;
					GFile* _tmp18_ = NULL;
					GFileInfo* _tmp19_ = NULL;
					GFileInfo* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					_tmp13_ = so_far;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_g_object_unref0 (parent);
					parent = _tmp14_;
					_tmp15_ = parent;
					_tmp16_ = piece;
					_tmp17_ = g_file_resolve_relative_path (_tmp15_, _tmp16_);
					_g_object_unref0 (so_far);
					so_far = _tmp17_;
					_tmp18_ = so_far;
					_tmp19_ = g_file_query_info (_tmp18_, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
					info = _tmp19_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (so_far);
						if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
							goto __catch6_g_io_error_not_found;
						}
						goto __catch6_g_error;
					}
					_tmp20_ = info;
					_tmp21_ = g_file_info_get_is_symlink (_tmp20_);
					if (_tmp21_) {
						GList* _tmp22_ = NULL;
						GFile* _tmp23_ = NULL;
						GList* _tmp24_ = NULL;
						gboolean _tmp25_ = FALSE;
						gchar* symlink_target = NULL;
						GFileInfo* _tmp28_ = NULL;
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						GFile* full_target = NULL;
						const gchar* _tmp31_ = NULL;
						gboolean _tmp32_ = FALSE;
						gchar* remaining = NULL;
						GFile* _tmp38_ = NULL;
						GFile* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						const gchar* _tmp41_ = NULL;
						gboolean _tmp45_ = FALSE;
						GFile* _tmp47_ = NULL;
						GFile* _tmp48_ = NULL;
						GFile* _tmp49_ = NULL;
						gboolean _tmp50_ = FALSE;
						GList* _tmp51_ = NULL;
						_tmp22_ = seen;
						_tmp23_ = so_far;
						_tmp24_ = g_list_find_custom (_tmp22_, _tmp23_, _______lambda6__gcompare_func);
						if (_tmp24_ != NULL) {
							_g_object_unref0 (info);
							_g_object_unref0 (so_far);
							_g_object_unref0 (parent);
							_g_object_unref0 (iter);
							__g_list_free__g_free0_0 (pieces);
							return;
						}
						_tmp25_ = include;
						if (_tmp25_) {
							GFile* _tmp26_ = NULL;
							GFile* _tmp27_ = NULL;
							_tmp26_ = so_far;
							_tmp27_ = _g_object_ref0 (_tmp26_);
							*all = g_list_append (*all, _tmp27_);
						}
						_tmp28_ = info;
						_tmp29_ = g_file_info_get_symlink_target (_tmp28_);
						_tmp30_ = g_strdup (_tmp29_);
						symlink_target = _tmp30_;
						_tmp31_ = symlink_target;
						_tmp32_ = g_path_is_absolute (_tmp31_);
						if (_tmp32_) {
							const gchar* _tmp33_ = NULL;
							GFile* _tmp34_ = NULL;
							_tmp33_ = symlink_target;
							_tmp34_ = g_file_new_for_path (_tmp33_);
							_g_object_unref0 (full_target);
							full_target = _tmp34_;
						} else {
							GFile* _tmp35_ = NULL;
							const gchar* _tmp36_ = NULL;
							GFile* _tmp37_ = NULL;
							_tmp35_ = parent;
							_tmp36_ = symlink_target;
							_tmp37_ = g_file_resolve_relative_path (_tmp35_, _tmp36_);
							_g_object_unref0 (full_target);
							full_target = _tmp37_;
						}
						_tmp38_ = so_far;
						_tmp39_ = file;
						_tmp40_ = g_file_get_relative_path (_tmp38_, _tmp39_);
						remaining = _tmp40_;
						_tmp41_ = remaining;
						if (_tmp41_ != NULL) {
							GFile* _tmp42_ = NULL;
							const gchar* _tmp43_ = NULL;
							GFile* _tmp44_ = NULL;
							_tmp42_ = full_target;
							_tmp43_ = remaining;
							_tmp44_ = g_file_resolve_relative_path (_tmp42_, _tmp43_);
							_g_object_unref0 (full_target);
							full_target = _tmp44_;
						}
						_tmp45_ = include;
						if (_tmp45_) {
							GFile* _tmp46_ = NULL;
							_tmp46_ = file;
							*all = g_list_remove (*all, _tmp46_);
						}
						_tmp47_ = so_far;
						_tmp48_ = _g_object_ref0 (_tmp47_);
						seen = g_list_prepend (seen, _tmp48_);
						_tmp49_ = full_target;
						_tmp50_ = include;
						_tmp51_ = seen;
						duplicity_job_expand_links_in_file (self, _tmp49_, all, _tmp50_, _tmp51_);
						_g_free0 (remaining);
						_g_object_unref0 (full_target);
						_g_free0 (symlink_target);
						_g_object_unref0 (info);
						_g_object_unref0 (so_far);
						_g_object_unref0 (parent);
						_g_object_unref0 (iter);
						__g_list_free__g_free0_0 (pieces);
						return;
					}
					_g_object_unref0 (info);
				}
			}
		}
		_tmp52_ = seen;
		if (_tmp52_ != NULL) {
			GFile* _tmp53_ = NULL;
			GFile* _tmp54_ = NULL;
			_tmp53_ = file;
			_tmp54_ = _g_object_ref0 (_tmp53_);
			*all = g_list_append (*all, _tmp54_);
		}
		_g_object_unref0 (so_far);
	}
	goto __finally6;
	__catch6_g_io_error_not_found:
	{
		GError* e = NULL;
		GFile* _tmp55_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp55_ = file;
		*all = g_list_remove (*all, _tmp55_);
		_g_error_free0 (e);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp56_ = e;
		_tmp57_ = _tmp56_->message;
		g_warning ("DuplicityJob.vala:269: %s\n", _tmp57_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parent);
		_g_object_unref0 (iter);
		__g_list_free__g_free0_0 (pieces);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (iter);
	__g_list_free__g_free0_0 (pieces);
}


static void duplicity_job_expand_links_in_list (DuplicityJob* self, GList** all, gboolean include) {
	GList* all2 = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = *all;
	_tmp1_ = g_list_copy (_tmp0_);
	all2 = _tmp1_;
	_tmp2_ = all2;
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp2_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp3_ = NULL;
			GFile* file = NULL;
			_tmp3_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp3_;
			{
				GFile* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				_tmp4_ = file;
				_tmp5_ = include;
				duplicity_job_expand_links_in_file (self, _tmp4_, all, _tmp5_, NULL);
				_g_object_unref0 (file);
			}
		}
	}
	_g_list_free0 (all2);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* duplicity_job_escape_duplicity_path (DuplicityJob* self, const gchar* path) {
	gchar* result = NULL;
	gchar* rv = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = string_replace (_tmp0_, "[", "[[]");
	_g_free0 (rv);
	rv = _tmp1_;
	_tmp2_ = rv;
	_tmp3_ = string_replace (_tmp2_, "?", "[?]");
	_g_free0 (rv);
	rv = _tmp3_;
	_tmp4_ = rv;
	_tmp5_ = string_replace (_tmp4_, "*", "[*]");
	_g_free0 (rv);
	rv = _tmp5_;
	result = rv;
	return result;
}


static void duplicity_job_process_include_excludes (DuplicityJob* self) {
	GList* _tmp0_ = NULL;
	GList* _tmp22_ = NULL;
	gchar* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	duplicity_job_expand_links_in_list (self, &((DejaDupToolJob*) self)->includes, TRUE);
	duplicity_job_expand_links_in_list (self, &((DejaDupToolJob*) self)->excludes, FALSE);
	((DejaDupToolJob*) self)->includes = g_list_sort (((DejaDupToolJob*) self)->includes, (GCompareFunc) duplicity_job_cmp_prefix);
	((DejaDupToolJob*) self)->excludes = g_list_sort (((DejaDupToolJob*) self)->excludes, (GCompareFunc) duplicity_job_cmp_prefix);
	_tmp0_ = ((DejaDupToolJob*) self)->includes;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp0_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GFile* _tmp1_ = NULL;
			GFile* i = NULL;
			_tmp1_ = _g_object_ref0 ((GFile*) i_it->data);
			i = _tmp1_;
			{
				GList* excludes2 = NULL;
				GList* _tmp2_ = NULL;
				GList* _tmp3_ = NULL;
				GList* _tmp4_ = NULL;
				GFile* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				_tmp2_ = ((DejaDupToolJob*) self)->excludes;
				_tmp3_ = g_list_copy (_tmp2_);
				excludes2 = _tmp3_;
				_tmp4_ = excludes2;
				{
					GList* e_collection = NULL;
					GList* e_it = NULL;
					e_collection = _tmp4_;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						GFile* _tmp5_ = NULL;
						GFile* e = NULL;
						_tmp5_ = _g_object_ref0 ((GFile*) e_it->data);
						e = _tmp5_;
						{
							GFile* _tmp6_ = NULL;
							GFile* _tmp7_ = NULL;
							gboolean _tmp8_ = FALSE;
							_tmp6_ = e;
							_tmp7_ = i;
							_tmp8_ = g_file_has_prefix (_tmp6_, _tmp7_);
							if (_tmp8_) {
								GFile* _tmp9_ = NULL;
								gchar* _tmp10_ = NULL;
								gchar* _tmp11_ = NULL;
								gchar* _tmp12_ = NULL;
								gchar* _tmp13_ = NULL;
								gchar* _tmp14_ = NULL;
								GFile* _tmp15_ = NULL;
								_tmp9_ = e;
								_tmp10_ = g_file_get_path (_tmp9_);
								_tmp11_ = _tmp10_;
								_tmp12_ = duplicity_job_escape_duplicity_path (self, _tmp11_);
								_tmp13_ = _tmp12_;
								_tmp14_ = g_strconcat ("--exclude=", _tmp13_, NULL);
								self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp14_);
								_g_free0 (_tmp13_);
								_g_free0 (_tmp11_);
								_tmp15_ = e;
								((DejaDupToolJob*) self)->excludes = g_list_remove (((DejaDupToolJob*) self)->excludes, _tmp15_);
							}
							_g_object_unref0 (e);
						}
					}
				}
				_tmp16_ = i;
				_tmp17_ = g_file_get_path (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = duplicity_job_escape_duplicity_path (self, _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat ("--include=", _tmp20_, NULL);
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp21_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_g_list_free0 (excludes2);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp22_ = ((DejaDupToolJob*) self)->excludes;
	{
		GList* e_collection = NULL;
		GList* e_it = NULL;
		e_collection = _tmp22_;
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
			GFile* _tmp23_ = NULL;
			GFile* e = NULL;
			_tmp23_ = _g_object_ref0 ((GFile*) e_it->data);
			e = _tmp23_;
			{
				GFile* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				_tmp24_ = e;
				_tmp25_ = g_file_get_path (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = duplicity_job_escape_duplicity_path (self, _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat ("--exclude=", _tmp28_, NULL);
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp29_);
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
				_g_object_unref0 (e);
			}
		}
	}
	_tmp30_ = g_strdup ("--exclude=**");
	self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp30_);
}


static void duplicity_job_real_cancel (DejaDupToolJob* base) {
	DuplicityJob * self;
	DejaDupToolJobMode prev_mode = 0;
	DejaDupToolJobMode _tmp0_ = 0;
	DejaDupToolJobMode _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	DejaDupToolJobMode _tmp3_ = 0;
	self = (DuplicityJob*) base;
	_tmp0_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	prev_mode = _tmp1_;
	deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_INVALID);
	_tmp3_ = prev_mode;
	if (_tmp3_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		DuplicityJobState _tmp4_ = 0;
		_tmp4_ = self->priv->_state;
		_tmp2_ = _tmp4_ == DUPLICITY_JOB_STATE_NORMAL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = duplicity_job_cleanup (self);
		if (_tmp5_) {
			return;
		}
	}
	duplicity_job_cancel_inst (self);
}


static void duplicity_job_real_stop (DejaDupToolJob* base) {
	DuplicityJob * self;
	self = (DuplicityJob*) base;
	duplicity_job_set_was_stopped (self, TRUE);
	deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_INVALID);
	duplicity_job_cancel_inst (self);
}


static void duplicity_job_real_pause (DejaDupToolJob* base, const gchar* reason) {
	DuplicityJob * self;
	DuplicityInstance* _tmp0_ = NULL;
	self = (DuplicityJob*) base;
	_tmp0_ = self->priv->inst;
	if (_tmp0_ != NULL) {
		DuplicityInstance* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->inst;
		duplicity_instance_pause (_tmp1_);
		_tmp2_ = reason;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_ = NULL;
			_tmp3_ = reason;
			duplicity_job_set_status (self, _tmp3_, FALSE);
		}
	}
}


static void duplicity_job_real_resume (DejaDupToolJob* base) {
	DuplicityJob * self;
	DuplicityInstance* _tmp0_ = NULL;
	self = (DuplicityJob*) base;
	_tmp0_ = self->priv->inst;
	if (_tmp0_ != NULL) {
		DuplicityInstance* _tmp1_ = NULL;
		_tmp1_ = self->priv->inst;
		duplicity_instance_resume (_tmp1_);
		duplicity_job_set_saved_status (self);
	}
}


static void duplicity_job_cancel_inst (DuplicityJob* self) {
	g_return_if_fail (self != NULL);
	duplicity_job_disconnect_inst (self);
	duplicity_job_handle_done (self, NULL, FALSE, TRUE);
}


static gboolean duplicity_job_restart (DuplicityJob* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	DejaDupToolJobMode _tmp2_ = 0;
	DejaDupToolJobMode _tmp3_ = 0;
	GList* extra_argv = NULL;
	gchar* action_desc = NULL;
	GFile* custom_local = NULL;
	DejaDupToolJobMode _tmp4_ = 0;
	const gchar* _tmp87_ = NULL;
	const gchar* _tmp91_ = NULL;
	GList* _tmp92_ = NULL;
	GFile* _tmp93_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	duplicity_job_set_state (self, DUPLICITY_JOB_STATE_NORMAL);
	_tmp0_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		__g_list_free__g_object_unref0_0 (self->priv->local_error_files);
		self->priv->local_error_files = NULL;
	}
	_tmp2_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		result = FALSE;
		return result;
	}
	extra_argv = NULL;
	action_desc = NULL;
	custom_local = NULL;
	_tmp4_ = self->priv->_original_mode;
	switch (_tmp4_) {
		case DEJA_DUP_TOOL_JOB_MODE_BACKUP:
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = self->priv->checked_collection_info;
			if (!_tmp5_) {
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_STATUS);
				duplicity_job_set_state (self, DUPLICITY_JOB_STATE_STATUS);
				_tmp6_ = _ ("Preparing…");
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (action_desc);
				action_desc = _tmp7_;
			} else {
				gboolean _tmp8_ = FALSE;
				DejaDupToolJobFlags _tmp9_ = 0;
				DejaDupToolJobFlags _tmp10_ = 0;
				_tmp9_ = deja_dup_tool_job_get_flags ((DejaDupToolJob*) self);
				_tmp10_ = _tmp9_;
				if ((_tmp10_ & DEJA_DUP_TOOL_JOB_FLAGS_NO_PROGRESS) == 0) {
					gboolean _tmp11_ = FALSE;
					_tmp11_ = self->priv->has_progress_total;
					_tmp8_ = !_tmp11_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					duplicity_job_set_state (self, DUPLICITY_JOB_STATE_DRY_RUN);
					_tmp12_ = _ ("Preparing…");
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (action_desc);
					action_desc = _tmp13_;
					_tmp14_ = g_strdup ("--dry-run");
					extra_argv = g_list_append (extra_argv, _tmp14_);
				} else {
					gboolean _tmp15_ = FALSE;
					_tmp15_ = self->priv->checked_backup_space;
					if (!_tmp15_) {
						duplicity_job_check_backup_space (self, NULL, NULL);
						result = TRUE;
						_g_object_unref0 (custom_local);
						_g_free0 (action_desc);
						__g_list_free__g_free0_0 (extra_argv);
						return result;
					} else {
						gboolean _tmp16_ = FALSE;
						_tmp16_ = self->priv->has_progress_total;
						if (_tmp16_) {
							g_signal_emit_by_name ((DejaDupToolJob*) self, "progress", (gdouble) 0.f);
						}
					}
				}
			}
			break;
		}
		case DEJA_DUP_TOOL_JOB_MODE_RESTORE:
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = self->priv->checked_collection_info;
			if (!_tmp17_) {
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_STATUS);
				duplicity_job_set_state (self, DUPLICITY_JOB_STATE_STATUS);
				_tmp18_ = _ ("Preparing…");
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (action_desc);
				action_desc = _tmp19_;
			} else {
				gboolean _tmp20_ = FALSE;
				_tmp20_ = self->priv->has_checked_contents;
				if (!_tmp20_) {
					const gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_LIST);
					duplicity_job_set_state (self, DUPLICITY_JOB_STATE_CHECK_CONTENTS);
					_tmp21_ = _ ("Preparing…");
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (action_desc);
					action_desc = _tmp22_;
				} else {
					GList* _tmp23_ = NULL;
					guint _tmp24_ = 0U;
					GList* _tmp42_ = NULL;
					GList* _tmp43_ = NULL;
					_tmp23_ = self->priv->homes;
					_tmp24_ = g_list_length (_tmp23_);
					if (_tmp24_ > ((guint) 1)) {
						self->priv->has_non_home_contents = TRUE;
					} else {
						GList* _tmp25_ = NULL;
						guint _tmp26_ = 0U;
						_tmp25_ = self->priv->homes;
						_tmp26_ = g_list_length (_tmp25_);
						if (_tmp26_ == ((guint) 1)) {
							GFile* old_home = NULL;
							GList* _tmp27_ = NULL;
							gconstpointer _tmp28_ = NULL;
							GFile* _tmp29_ = NULL;
							GFile* new_home = NULL;
							GFile* _tmp30_ = NULL;
							GFile* _tmp31_ = NULL;
							GFile* _tmp32_ = NULL;
							GFile* _tmp33_ = NULL;
							gboolean _tmp34_ = FALSE;
							_tmp27_ = self->priv->homes;
							_tmp28_ = _tmp27_->data;
							_tmp29_ = _g_object_ref0 ((GFile*) _tmp28_);
							old_home = _tmp29_;
							_tmp30_ = duplicity_job_slash_home_me;
							_tmp31_ = _g_object_ref0 (_tmp30_);
							new_home = _tmp31_;
							_tmp32_ = old_home;
							_tmp33_ = new_home;
							_tmp34_ = g_file_equal (_tmp32_, _tmp33_);
							if (!_tmp34_) {
								gchar* _tmp35_ = NULL;
								GFile* _tmp36_ = NULL;
								GFile* _tmp37_ = NULL;
								gchar* _tmp38_ = NULL;
								GFile* _tmp39_ = NULL;
								GFile* _tmp40_ = NULL;
								gchar* _tmp41_ = NULL;
								_tmp35_ = g_strdup ("--rename");
								extra_argv = g_list_append (extra_argv, _tmp35_);
								_tmp36_ = duplicity_job_slash;
								_tmp37_ = old_home;
								_tmp38_ = g_file_get_relative_path (_tmp36_, _tmp37_);
								extra_argv = g_list_append (extra_argv, _tmp38_);
								_tmp39_ = duplicity_job_slash;
								_tmp40_ = new_home;
								_tmp41_ = g_file_get_relative_path (_tmp39_, _tmp40_);
								extra_argv = g_list_append (extra_argv, _tmp41_);
							}
							_g_object_unref0 (new_home);
							_g_object_unref0 (old_home);
						}
					}
					_tmp42_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp43_ = _tmp42_;
					if (_tmp43_ != NULL) {
						GFile* local_file = NULL;
						GList* _tmp44_ = NULL;
						GList* _tmp45_ = NULL;
						gconstpointer _tmp46_ = NULL;
						GFile* _tmp47_ = NULL;
						GFile* _tmp48_ = NULL;
						gboolean _tmp58_ = FALSE;
						GFile* _tmp59_ = NULL;
						GFile* _tmp60_ = NULL;
						gboolean _tmp61_ = FALSE;
						GFile* _tmp72_ = NULL;
						GFile* _tmp73_ = NULL;
						gchar* rel_file_path = NULL;
						GFile* _tmp74_ = NULL;
						GList* _tmp75_ = NULL;
						GList* _tmp76_ = NULL;
						gconstpointer _tmp77_ = NULL;
						gchar* _tmp78_ = NULL;
						const gchar* _tmp79_ = NULL;
						gchar* _tmp80_ = NULL;
						_tmp44_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
						_tmp45_ = _tmp44_;
						_tmp46_ = _tmp45_->data;
						_tmp47_ = duplicity_job_make_local_rel_path (self, (GFile*) _tmp46_);
						local_file = _tmp47_;
						_tmp48_ = local_file;
						if (_tmp48_ == NULL) {
							const gchar* _tmp49_ = NULL;
							GList* _tmp50_ = NULL;
							GList* _tmp51_ = NULL;
							gconstpointer _tmp52_ = NULL;
							GFile* _tmp53_ = NULL;
							gchar* _tmp54_ = NULL;
							gchar* _tmp55_ = NULL;
							gchar* _tmp56_ = NULL;
							gchar* _tmp57_ = NULL;
							_tmp49_ = _ ("Could not restore ‘%s’: Not a valid file location");
							_tmp50_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
							_tmp51_ = _tmp50_;
							_tmp52_ = _tmp51_->data;
							_tmp53_ = (GFile*) _tmp52_;
							_tmp54_ = g_file_get_parse_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, G_TYPE_FILE) ? ((GFile*) _tmp53_) : NULL);
							_tmp55_ = _tmp54_;
							_tmp56_ = g_strdup_printf (_tmp49_, _tmp55_);
							_tmp57_ = _tmp56_;
							duplicity_job_show_error (self, _tmp57_, NULL);
							_g_free0 (_tmp57_);
							_g_free0 (_tmp55_);
							result = FALSE;
							_g_object_unref0 (local_file);
							_g_object_unref0 (custom_local);
							_g_free0 (action_desc);
							__g_list_free__g_free0_0 (extra_argv);
							return result;
						}
						_tmp59_ = local_file;
						_tmp60_ = duplicity_job_slash_home_me;
						_tmp61_ = g_file_has_prefix (_tmp59_, _tmp60_);
						if (!_tmp61_) {
							gboolean _tmp62_ = FALSE;
							gboolean _tmp63_ = FALSE;
							_tmp63_ = deja_dup_in_testing_mode ();
							if (_tmp63_) {
								GFile* _tmp64_ = NULL;
								gchar* _tmp65_ = NULL;
								gchar* _tmp66_ = NULL;
								const gchar* _tmp67_ = NULL;
								gboolean _tmp68_ = FALSE;
								_tmp64_ = local_file;
								_tmp65_ = g_file_get_path (_tmp64_);
								_tmp66_ = _tmp65_;
								_tmp67_ = g_get_tmp_dir ();
								_tmp68_ = g_str_has_prefix (_tmp66_, _tmp67_);
								_tmp62_ = _tmp68_;
								_g_free0 (_tmp66_);
							} else {
								_tmp62_ = FALSE;
							}
							_tmp58_ = !_tmp62_;
						} else {
							_tmp58_ = FALSE;
						}
						if (_tmp58_) {
							self->priv->needs_root = TRUE;
						}
						{
							GFile* _tmp69_ = NULL;
							_tmp69_ = local_file;
							g_file_make_directory_with_parents (_tmp69_, NULL, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
									goto __catch8_g_io_error_exists;
								}
								goto __catch8_g_error;
							}
						}
						goto __finally8;
						__catch8_g_io_error_exists:
						{
							GError* e = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (e);
						}
						goto __finally8;
						__catch8_g_error:
						{
							GError* e = NULL;
							GError* _tmp70_ = NULL;
							const gchar* _tmp71_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp70_ = e;
							_tmp71_ = _tmp70_->message;
							duplicity_job_show_error (self, _tmp71_, NULL);
							result = FALSE;
							_g_error_free0 (e);
							_g_object_unref0 (local_file);
							_g_object_unref0 (custom_local);
							_g_free0 (action_desc);
							__g_list_free__g_free0_0 (extra_argv);
							return result;
						}
						__finally8:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_object_unref0 (local_file);
							_g_object_unref0 (custom_local);
							_g_free0 (action_desc);
							__g_list_free__g_free0_0 (extra_argv);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp72_ = local_file;
						_tmp73_ = _g_object_ref0 (_tmp72_);
						_g_object_unref0 (custom_local);
						custom_local = _tmp73_;
						_tmp74_ = duplicity_job_slash;
						_tmp75_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
						_tmp76_ = _tmp75_;
						_tmp77_ = _tmp76_->data;
						_tmp78_ = g_file_get_relative_path (_tmp74_, (GFile*) _tmp77_);
						rel_file_path = _tmp78_;
						_tmp79_ = rel_file_path;
						_tmp80_ = g_strdup_printf ("--file-to-restore=%s", _tmp79_);
						extra_argv = g_list_append (extra_argv, _tmp80_);
						_g_free0 (rel_file_path);
						_g_object_unref0 (local_file);
					} else {
						gboolean _tmp81_ = FALSE;
						gboolean _tmp82_ = FALSE;
						_tmp82_ = self->priv->has_non_home_contents;
						if (_tmp82_) {
							GFile* _tmp83_ = NULL;
							GFile* _tmp84_ = NULL;
							GFile* _tmp85_ = NULL;
							gboolean _tmp86_ = FALSE;
							_tmp83_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
							_tmp84_ = _tmp83_;
							_tmp85_ = duplicity_job_slash_home_me;
							_tmp86_ = g_file_has_prefix (_tmp84_, _tmp85_);
							_tmp81_ = !_tmp86_;
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							self->priv->needs_root = TRUE;
						}
					}
					g_signal_emit_by_name ((DejaDupToolJob*) self, "progress", (gdouble) 0.f);
				}
			}
			break;
		}
		default:
		break;
	}
	_tmp87_ = action_desc;
	if (_tmp87_ == NULL) {
		DejaDupToolJobMode _tmp88_ = 0;
		DejaDupToolJobMode _tmp89_ = 0;
		gchar* _tmp90_ = NULL;
		_tmp88_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = deja_dup_operation_mode_to_string (_tmp89_);
		_g_free0 (action_desc);
		action_desc = _tmp90_;
	}
	_tmp91_ = action_desc;
	duplicity_job_set_status (self, _tmp91_, TRUE);
	_tmp92_ = extra_argv;
	_tmp93_ = custom_local;
	duplicity_job_connect_and_start (self, _tmp92_, NULL, NULL, _tmp93_);
	result = TRUE;
	_g_object_unref0 (custom_local);
	_g_free0 (action_desc);
	__g_list_free__g_free0_0 (extra_argv);
	return result;
}


static GFile* duplicity_job_make_local_rel_path (DuplicityJob* self, GFile* file) {
	GFile* result = NULL;
	gchar* rel_file_path = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = duplicity_job_slash;
	_tmp1_ = file;
	_tmp2_ = g_file_get_relative_path (_tmp0_, _tmp1_);
	rel_file_path = _tmp2_;
	_tmp3_ = rel_file_path;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_free0 (rel_file_path);
		return result;
	}
	_tmp4_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = rel_file_path;
	_tmp7_ = g_file_resolve_relative_path (_tmp5_, _tmp6_);
	result = _tmp7_;
	_g_free0 (rel_file_path);
	return result;
}


static void duplicity_job_check_backup_space_data_free (gpointer _data) {
	DuplicityJobCheckBackupSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DuplicityJobCheckBackupSpaceData, _data_);
}


static void duplicity_job_check_backup_space (DuplicityJob* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DuplicityJobCheckBackupSpaceData* _data_;
	DuplicityJob* _tmp0_ = NULL;
	_data_ = g_slice_new0 (DuplicityJobCheckBackupSpaceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, duplicity_job_check_backup_space);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, duplicity_job_check_backup_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	duplicity_job_check_backup_space_co (_data_);
}


static void duplicity_job_check_backup_space_finish (DuplicityJob* self, GAsyncResult* _res_) {
	DuplicityJobCheckBackupSpaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void duplicity_job_check_backup_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DuplicityJobCheckBackupSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	duplicity_job_check_backup_space_co (_data_);
}


static gboolean duplicity_job_check_backup_space_co (DuplicityJobCheckBackupSpaceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->checked_backup_space = TRUE;
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->has_progress_total;
	if (!_data_->_tmp0_) {
		_data_->_tmp1_ = FALSE;
		_data_->_tmp1_ = duplicity_job_restart (_data_->self);
		if (!_data_->_tmp1_) {
			g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE, NULL);
		}
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	deja_dup_backend_get_space (_data_->_tmp3_, TRUE, duplicity_job_check_backup_space_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = 0ULL;
	_data_->_tmp4_ = deja_dup_backend_get_space_finish (_data_->_tmp3_, _data_->_res_);
	_data_->free = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_state_ = 2;
	deja_dup_backend_get_space (_data_->_tmp6_, FALSE, duplicity_job_check_backup_space_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp7_ = 0ULL;
	_data_->_tmp7_ = deja_dup_backend_get_space_finish (_data_->_tmp6_, _data_->_res_);
	_data_->total = _data_->_tmp7_;
	_data_->_tmp8_ = 0ULL;
	_data_->_tmp8_ = _data_->total;
	_data_->_tmp9_ = 0ULL;
	_data_->_tmp9_ = _data_->self->priv->progress_total;
	if (_data_->_tmp8_ < _data_->_tmp9_) {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _ ("Backup location is too small.  Try using one with more space.");
		duplicity_job_show_error (_data_->self, _data_->_tmp10_, NULL);
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE, NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = 0ULL;
	_data_->_tmp11_ = _data_->free;
	_data_->_tmp12_ = 0ULL;
	_data_->_tmp12_ = _data_->self->priv->progress_total;
	if (_data_->_tmp11_ < _data_->_tmp12_) {
		_data_->_tmp13_ = FALSE;
		_data_->_tmp13_ = _data_->self->priv->got_collection_info;
		if (_data_->_tmp13_) {
			_data_->full_dates = 0;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->self->priv->collection_info;
			{
				_data_->info_collection = _data_->_tmp14_;
				for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
					_data_->info = *((DuplicityJobDateInfo*) _data_->info_it->data);
					{
						memset (&_data_->_tmp15_, 0, sizeof (DuplicityJobDateInfo));
						_data_->_tmp15_ = _data_->info;
						_data_->_tmp16_ = FALSE;
						_data_->_tmp16_ = _data_->_tmp15_.full;
						if (_data_->_tmp16_) {
							_data_->_tmp17_ = 0;
							_data_->_tmp17_ = _data_->full_dates;
							_data_->full_dates = _data_->_tmp17_ + 1;
						}
					}
				}
			}
			_data_->_tmp18_ = 0;
			_data_->_tmp18_ = _data_->full_dates;
			if (_data_->_tmp18_ > 1) {
				_data_->_tmp19_ = 0;
				_data_->_tmp19_ = _data_->full_dates;
				duplicity_job_delete_excess (_data_->self, _data_->_tmp19_ - 1);
				_data_->self->priv->checked_backup_space = FALSE;
				_data_->self->priv->checked_collection_info = FALSE;
				_data_->self->priv->got_collection_info = FALSE;
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		} else {
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _ ("Backup location does not have enough free space.");
			duplicity_job_show_error (_data_->self, _data_->_tmp20_, NULL);
			g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE, NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp21_ = FALSE;
	_data_->_tmp21_ = duplicity_job_restart (_data_->self);
	if (!_data_->_tmp21_) {
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE, NULL);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean duplicity_job_cleanup (DuplicityJob* self) {
	gboolean result = FALSE;
	DuplicityJobState _tmp0_ = 0;
	GList* cleanup_argv = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == DUPLICITY_JOB_STATE_CLEANUP) {
		result = FALSE;
		return result;
	}
	duplicity_job_set_state (self, DUPLICITY_JOB_STATE_CLEANUP);
	cleanup_argv = NULL;
	_tmp1_ = g_strdup ("cleanup");
	cleanup_argv = g_list_append (cleanup_argv, _tmp1_);
	_tmp2_ = g_strdup ("--force");
	cleanup_argv = g_list_append (cleanup_argv, _tmp2_);
	_tmp3_ = duplicity_job_get_remote (self);
	cleanup_argv = g_list_append (cleanup_argv, _tmp3_);
	_tmp4_ = _ ("Cleaning up…");
	duplicity_job_set_status (self, _tmp4_, TRUE);
	_tmp5_ = cleanup_argv;
	duplicity_job_connect_and_start (self, NULL, NULL, _tmp5_, NULL);
	result = TRUE;
	__g_list_free__g_free0_0 (cleanup_argv);
	return result;
}


static void duplicity_job_delete_excess (DuplicityJob* self, gint cutoff) {
	GList* argv = NULL;
	gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	duplicity_job_set_state (self, DUPLICITY_JOB_STATE_DELETE);
	argv = NULL;
	_tmp0_ = g_strdup ("remove-all-but-n-full");
	argv = g_list_append (argv, _tmp0_);
	_tmp1_ = cutoff;
	_tmp2_ = g_strdup_printf ("%d", _tmp1_);
	argv = g_list_append (argv, _tmp2_);
	_tmp3_ = g_strdup ("--force");
	argv = g_list_append (argv, _tmp3_);
	_tmp4_ = duplicity_job_get_remote (self);
	argv = g_list_append (argv, _tmp4_);
	_tmp5_ = _ ("Cleaning up…");
	duplicity_job_set_status (self, _tmp5_, TRUE);
	duplicity_job_connect_and_start (self, NULL, NULL, argv, NULL);
	__g_list_free__g_free0_0 (argv);
	return;
}


static gboolean duplicity_job_can_ignore_error (DuplicityJob* self) {
	gboolean result = FALSE;
	DuplicityJobState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == DUPLICITY_JOB_STATE_CLEANUP;
	return result;
}


static void duplicity_job_handle_done (DuplicityJob* self, DuplicityInstance* inst, gboolean success, gboolean cancelled) {
	gchar* detail = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	const gchar* _tmp84_ = NULL;
	g_return_if_fail (self != NULL);
	detail = NULL;
	_tmp0_ = duplicity_job_can_ignore_error (self);
	if (_tmp0_) {
		success = TRUE;
	}
	_tmp2_ = cancelled;
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = success;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		DuplicityJobState _tmp4_ = 0;
		_tmp4_ = self->priv->_state;
		switch (_tmp4_) {
			case DUPLICITY_JOB_STATE_DRY_RUN:
			{
				guint64 _tmp5_ = 0ULL;
				gboolean _tmp6_ = FALSE;
				self->priv->has_progress_total = TRUE;
				_tmp5_ = self->priv->progress_count;
				self->priv->progress_total = _tmp5_;
				_tmp6_ = duplicity_job_restart (self);
				if (_tmp6_) {
					_g_free0 (detail);
					return;
				}
				break;
			}
			case DUPLICITY_JOB_STATE_DELETE:
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = duplicity_job_restart (self);
				if (_tmp7_) {
					_g_free0 (detail);
					return;
				}
				break;
			}
			case DUPLICITY_JOB_STATE_CLEANUP:
			{
				gboolean _tmp8_ = FALSE;
				self->priv->cleaned_up_once = TRUE;
				_tmp8_ = duplicity_job_restart (self);
				if (_tmp8_) {
					_g_free0 (detail);
					return;
				}
				success = FALSE;
				cancelled = TRUE;
				break;
			}
			case DUPLICITY_JOB_STATE_STATUS:
			{
				gboolean should_restart = FALSE;
				DejaDupToolJobMode _tmp9_ = 0;
				DejaDupToolJobMode _tmp10_ = 0;
				DejaDupToolJobMode _tmp11_ = 0;
				DejaDupToolJobMode _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				DejaDupToolJobMode _tmp14_ = 0;
				DejaDupToolJobMode _tmp15_ = 0;
				gboolean _tmp28_ = FALSE;
				self->priv->checked_collection_info = TRUE;
				_tmp9_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp10_ = _tmp9_;
				_tmp11_ = self->priv->_original_mode;
				should_restart = _tmp10_ != _tmp11_;
				_tmp12_ = self->priv->_original_mode;
				deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, _tmp12_);
				_tmp14_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					gboolean _tmp16_ = FALSE;
					_tmp16_ = self->priv->got_collection_info;
					_tmp13_ = _tmp16_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					GDate threshold = {0};
					GDate _tmp17_ = {0};
					GDate full_backup = {0};
					GList* _tmp18_ = NULL;
					gboolean _tmp23_ = FALSE;
					gboolean _tmp24_ = FALSE;
					deja_dup_get_full_backup_threshold_date (&_tmp17_);
					threshold = _tmp17_;
					memset (&full_backup, 0, sizeof (GDate));
					_tmp18_ = self->priv->collection_info;
					{
						GList* info_collection = NULL;
						GList* info_it = NULL;
						info_collection = _tmp18_;
						for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
							DuplicityJobDateInfo info = {0};
							info = *((DuplicityJobDateInfo*) info_it->data);
							{
								DuplicityJobDateInfo _tmp19_ = {0};
								gboolean _tmp20_ = FALSE;
								_tmp19_ = info;
								_tmp20_ = _tmp19_.full;
								if (_tmp20_) {
									DuplicityJobDateInfo _tmp21_ = {0};
									GTimeVal _tmp22_ = {0};
									_tmp21_ = info;
									_tmp22_ = _tmp21_.time;
									g_date_set_time_val (&full_backup, &_tmp22_);
								}
							}
						}
					}
					_tmp24_ = g_date_valid (&full_backup);
					if (!_tmp24_) {
						_tmp23_ = TRUE;
					} else {
						GDate _tmp25_ = {0};
						gint _tmp26_ = 0;
						_tmp25_ = full_backup;
						_tmp26_ = g_date_compare (&threshold, &_tmp25_);
						_tmp23_ = _tmp26_ > 0;
					}
					if (_tmp23_) {
						gboolean _tmp27_ = FALSE;
						self->priv->is_full_backup = TRUE;
						_tmp27_ = g_date_valid (&full_backup);
						g_signal_emit_by_name ((DejaDupToolJob*) self, "is-full", !_tmp27_);
					}
				}
				_tmp28_ = should_restart;
				if (_tmp28_) {
					gboolean _tmp29_ = FALSE;
					_tmp29_ = duplicity_job_restart (self);
					if (_tmp29_) {
						_g_free0 (detail);
						return;
					}
				}
				break;
			}
			case DUPLICITY_JOB_STATE_CHECK_CONTENTS:
			{
				DejaDupToolJobMode _tmp30_ = 0;
				gboolean _tmp31_ = FALSE;
				self->priv->has_checked_contents = TRUE;
				_tmp30_ = self->priv->_original_mode;
				deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, _tmp30_);
				_tmp31_ = duplicity_job_restart (self);
				if (_tmp31_) {
					_g_free0 (detail);
					return;
				}
				break;
			}
			case DUPLICITY_JOB_STATE_NORMAL:
			{
				gboolean _tmp32_ = FALSE;
				DejaDupToolJobMode _tmp33_ = 0;
				DejaDupToolJobMode _tmp34_ = 0;
				DejaDupToolJobMode _tmp41_ = 0;
				DejaDupToolJobMode _tmp42_ = 0;
				_tmp33_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp34_ = _tmp33_;
				if (_tmp34_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
					GList* _tmp35_ = NULL;
					GList* _tmp36_ = NULL;
					_tmp35_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp36_ = _tmp35_;
					_tmp32_ = _tmp36_ != NULL;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					GList* _tmp37_ = NULL;
					GList* _tmp38_ = NULL;
					GList* _tmp39_ = NULL;
					_tmp37_ = ((DejaDupToolJob*) self)->_restore_files;
					((DejaDupToolJob*) self)->_restore_files = g_list_delete_link (((DejaDupToolJob*) self)->_restore_files, _tmp37_);
					_tmp38_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp39_ = _tmp38_;
					if (_tmp39_ != NULL) {
						gboolean _tmp40_ = FALSE;
						_tmp40_ = duplicity_job_restart (self);
						if (_tmp40_) {
							_g_free0 (detail);
							return;
						}
					}
				}
				_tmp41_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp42_ = _tmp41_;
				if (_tmp42_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					GList* _tmp43_ = NULL;
					gboolean _tmp57_ = FALSE;
					_tmp43_ = self->priv->local_error_files;
					if (_tmp43_ != NULL) {
						const gchar* _tmp44_ = NULL;
						gchar* _tmp45_ = NULL;
						const gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
						GList* _tmp48_ = NULL;
						_tmp44_ = _ ("Could not back up the following files.  Please make sure you are able " \
"to open them.");
						_tmp45_ = g_strdup (_tmp44_);
						_g_free0 (detail);
						detail = _tmp45_;
						_tmp46_ = detail;
						_tmp47_ = g_strconcat (_tmp46_, "\n", NULL);
						_g_free0 (detail);
						detail = _tmp47_;
						_tmp48_ = self->priv->local_error_files;
						{
							GList* f_collection = NULL;
							GList* f_it = NULL;
							f_collection = _tmp48_;
							for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
								GFile* _tmp49_ = NULL;
								GFile* f = NULL;
								_tmp49_ = _g_object_ref0 ((GFile*) f_it->data);
								f = _tmp49_;
								{
									const gchar* _tmp50_ = NULL;
									GFile* _tmp51_ = NULL;
									gchar* _tmp52_ = NULL;
									gchar* _tmp53_ = NULL;
									gchar* _tmp54_ = NULL;
									gchar* _tmp55_ = NULL;
									gchar* _tmp56_ = NULL;
									_tmp50_ = detail;
									_tmp51_ = f;
									_tmp52_ = g_file_get_parse_name (_tmp51_);
									_tmp53_ = _tmp52_;
									_tmp54_ = g_strdup_printf ("\n%s", _tmp53_);
									_tmp55_ = _tmp54_;
									_tmp56_ = g_strconcat (_tmp50_, _tmp55_, NULL);
									_g_free0 (detail);
									detail = _tmp56_;
									_g_free0 (_tmp55_);
									_g_free0 (_tmp53_);
									_g_object_unref0 (f);
								}
							}
						}
					}
					deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_INVALID);
					_tmp57_ = duplicity_job_delete_files_if_needed (self);
					if (_tmp57_) {
						_g_free0 (detail);
						return;
					}
				} else {
					DejaDupToolJobMode _tmp58_ = 0;
					DejaDupToolJobMode _tmp59_ = 0;
					_tmp58_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
					_tmp59_ = _tmp58_;
					if (_tmp59_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
						GList* _tmp60_ = NULL;
						_tmp60_ = self->priv->local_error_files;
						if (_tmp60_ != NULL) {
							const gchar* _tmp61_ = NULL;
							gchar* _tmp62_ = NULL;
							const gchar* _tmp63_ = NULL;
							gchar* _tmp64_ = NULL;
							GList* _tmp65_ = NULL;
							_tmp61_ = _ ("Could not restore the following files.  Please make sure you are able " \
"to write to them.");
							_tmp62_ = g_strdup (_tmp61_);
							_g_free0 (detail);
							detail = _tmp62_;
							_tmp63_ = detail;
							_tmp64_ = g_strconcat (_tmp63_, "\n", NULL);
							_g_free0 (detail);
							detail = _tmp64_;
							_tmp65_ = self->priv->local_error_files;
							{
								GList* f_collection = NULL;
								GList* f_it = NULL;
								f_collection = _tmp65_;
								for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
									GFile* _tmp66_ = NULL;
									GFile* f = NULL;
									_tmp66_ = _g_object_ref0 ((GFile*) f_it->data);
									f = _tmp66_;
									{
										const gchar* _tmp67_ = NULL;
										GFile* _tmp68_ = NULL;
										gchar* _tmp69_ = NULL;
										gchar* _tmp70_ = NULL;
										gchar* _tmp71_ = NULL;
										gchar* _tmp72_ = NULL;
										gchar* _tmp73_ = NULL;
										_tmp67_ = detail;
										_tmp68_ = f;
										_tmp69_ = g_file_get_parse_name (_tmp68_);
										_tmp70_ = _tmp69_;
										_tmp71_ = g_strdup_printf ("\n%s", _tmp70_);
										_tmp72_ = _tmp71_;
										_tmp73_ = g_strconcat (_tmp67_, _tmp72_, NULL);
										_g_free0 (detail);
										detail = _tmp73_;
										_g_free0 (_tmp72_);
										_g_free0 (_tmp70_);
										_g_object_unref0 (f);
									}
								}
							}
						}
					}
				}
				break;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp74_ = FALSE;
		_tmp74_ = self->priv->_was_stopped;
		if (_tmp74_) {
			success = TRUE;
		}
	}
	_tmp75_ = self->priv->_error_issued;
	if (_tmp75_) {
		success = FALSE;
	}
	_tmp78_ = success;
	if (!_tmp78_) {
		gboolean _tmp79_ = FALSE;
		_tmp79_ = cancelled;
		_tmp77_ = !_tmp79_;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		gboolean _tmp80_ = FALSE;
		_tmp80_ = self->priv->_error_issued;
		_tmp76_ = !_tmp80_;
	} else {
		_tmp76_ = FALSE;
	}
	if (_tmp76_) {
		const gchar* _tmp81_ = NULL;
		_tmp81_ = _ ("Failed with an unknown error.");
		duplicity_job_show_error (self, _tmp81_, NULL);
	}
	inst = NULL;
	_tmp82_ = success;
	_tmp83_ = cancelled;
	_tmp84_ = detail;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "done", _tmp82_, _tmp83_, _tmp84_);
	_g_free0 (detail);
}


static void duplicity_job_set_status (DuplicityJob* self, const gchar* msg, gboolean save) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = save;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = msg;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->saved_status);
		self->priv->saved_status = _tmp2_;
		_g_object_unref0 (self->priv->saved_status_file);
		self->priv->saved_status_file = NULL;
	}
	_tmp3_ = msg;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "action-desc-changed", _tmp3_);
}


static void duplicity_job_set_status_file (DuplicityJob* self, GFile* file, gboolean action, gboolean save) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = save;
	if (_tmp0_) {
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_g_free0 (self->priv->saved_status);
		self->priv->saved_status = NULL;
		_tmp1_ = file;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (self->priv->saved_status_file);
		self->priv->saved_status_file = _tmp2_;
		_tmp3_ = action;
		self->priv->saved_status_file_action = _tmp3_;
	}
	_tmp4_ = file;
	_tmp5_ = action;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "action-file-changed", _tmp4_, _tmp5_);
}


static void duplicity_job_set_saved_status (DuplicityJob* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->saved_status;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = self->priv->saved_status;
		duplicity_job_set_status (self, _tmp1_, FALSE);
	} else {
		GFile* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->saved_status_file;
		_tmp3_ = self->priv->saved_status_file_action;
		duplicity_job_set_status_file (self, _tmp2_, _tmp3_, FALSE);
	}
}


static gboolean duplicity_job_delete_files_if_needed (DuplicityJob* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->delete_age;
	if (_tmp0_ == 0) {
		self->priv->deleted_files = TRUE;
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->got_collection_info;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->deleted_files;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint full_dates = 0;
		GTimeVal prev_time = {0};
		GDate prev_date = {0};
		gint too_old = 0;
		GTimeVal now = {0};
		GDate today = {0};
		GTimeVal _tmp4_ = {0};
		GList* _tmp5_ = NULL;
		GTimeVal _tmp17_ = {0};
		GDate _tmp18_ = {0};
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gint _tmp25_ = 0;
		full_dates = 0;
		g_get_current_time (&prev_time);
		memset (&prev_date, 0, sizeof (GDate));
		too_old = 0;
		g_get_current_time (&now);
		g_get_current_time (&now);
		memset (&today, 0, sizeof (GDate));
		_tmp4_ = now;
		g_date_set_time_val (&today, &_tmp4_);
		_tmp5_ = self->priv->collection_info;
		{
			GList* info_collection = NULL;
			GList* info_it = NULL;
			info_collection = _tmp5_;
			for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
				DuplicityJobDateInfo info = {0};
				info = *((DuplicityJobDateInfo*) info_it->data);
				{
					DuplicityJobDateInfo _tmp6_ = {0};
					gboolean _tmp7_ = FALSE;
					DuplicityJobDateInfo _tmp15_ = {0};
					GTimeVal _tmp16_ = {0};
					_tmp6_ = info;
					_tmp7_ = _tmp6_.full;
					if (_tmp7_) {
						gint _tmp8_ = 0;
						gint _tmp14_ = 0;
						_tmp8_ = full_dates;
						if (_tmp8_ > 0) {
							GTimeVal _tmp9_ = {0};
							GDate _tmp10_ = {0};
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							_tmp9_ = prev_time;
							g_date_set_time_val (&prev_date, &_tmp9_);
							_tmp10_ = today;
							_tmp11_ = g_date_days_between (&prev_date, &_tmp10_);
							_tmp12_ = self->priv->delete_age;
							if (_tmp11_ > _tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = too_old;
								too_old = _tmp13_ + 1;
							}
						}
						_tmp14_ = full_dates;
						full_dates = _tmp14_ + 1;
					}
					_tmp15_ = info;
					_tmp16_ = _tmp15_.time;
					prev_time = _tmp16_;
				}
			}
		}
		_tmp17_ = prev_time;
		g_date_set_time_val (&prev_date, &_tmp17_);
		_tmp18_ = today;
		_tmp19_ = g_date_days_between (&prev_date, &_tmp18_);
		_tmp20_ = self->priv->delete_age;
		if (_tmp19_ > _tmp20_) {
			gint _tmp21_ = 0;
			_tmp21_ = too_old;
			too_old = _tmp21_ + 1;
		}
		_tmp22_ = self->priv->is_full_backup;
		if (_tmp22_) {
			gint _tmp23_ = 0;
			_tmp23_ = full_dates;
			full_dates = _tmp23_ + 1;
		}
		_tmp25_ = too_old;
		if (_tmp25_ > 0) {
			gint _tmp26_ = 0;
			_tmp26_ = full_dates;
			_tmp24_ = _tmp26_ > DUPLICITY_JOB_MINIMUM_FULL;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gint cutoff = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			_tmp27_ = full_dates;
			_tmp28_ = too_old;
			_tmp29_ = MAX (DUPLICITY_JOB_MINIMUM_FULL, _tmp27_ - _tmp28_);
			cutoff = _tmp29_;
			_tmp30_ = cutoff;
			duplicity_job_delete_excess (self, _tmp30_);
			result = TRUE;
			return result;
		}
		self->priv->deleted_files = TRUE;
		result = FALSE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void duplicity_job_delete_cache (DuplicityJob* self) {
	gchar* dir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* cachedir = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	DejaDupRecursiveDelete* del = NULL;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	DejaDupRecursiveDelete* _tmp8_ = NULL;
	DejaDupRecursiveDelete* _tmp9_ = NULL;
	DejaDupRecursiveDelete* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	dir = _tmp1_;
	_tmp2_ = dir;
	if (_tmp2_ == NULL) {
		_g_free0 (dir);
		return;
	}
	_tmp3_ = dir;
	_tmp4_ = g_build_filename (_tmp3_, PACKAGE, NULL);
	cachedir = _tmp4_;
	_tmp5_ = cachedir;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = deja_dup_recursive_delete_new (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	del = _tmp9_;
	_tmp10_ = del;
	deja_dup_recursive_op_start ((DejaDupRecursiveOp*) _tmp10_);
	_g_object_unref0 (del);
	_g_free0 (cachedir);
	_g_free0 (dir);
}


static gboolean duplicity_job_restart_without_cache (DuplicityJob* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->restarted_without_cache;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->restarted_without_cache = TRUE;
	duplicity_job_delete_cache (self);
	_tmp1_ = duplicity_job_restart (self);
	result = _tmp1_;
	return result;
}


static void duplicity_job_handle_exit (DuplicityJob* self, gint code) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = code;
	if (_tmp1_ == DUPLICITY_JOB_ERROR_GENERIC) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->_error_issued;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		duplicity_job_restart_without_cache (self);
	}
}


static void duplicity_job_handle_message (DuplicityJob* self, DuplicityInstance* inst, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* keyword = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inst != NULL);
	g_return_if_fail (user_text != NULL);
	_tmp0_ = control_line;
	_tmp0__length1 = control_line_length1;
	if (_tmp0__length1 == 0) {
		return;
	}
	_tmp1_ = control_line;
	_tmp1__length1 = control_line_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_strdup (_tmp2_);
	keyword = _tmp3_;
	_tmp4_ = keyword;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("ERROR")))) {
		switch (0) {
			default:
			{
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				GList* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				_tmp8_ = control_line;
				_tmp8__length1 = control_line_length1;
				_tmp9_ = data_lines;
				_tmp10_ = user_text;
				duplicity_job_process_error (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp10_);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("INFO")))) {
		switch (0) {
			default:
			{
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				GList* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				_tmp11_ = control_line;
				_tmp11__length1 = control_line_length1;
				_tmp12_ = data_lines;
				_tmp13_ = user_text;
				duplicity_job_process_info (self, _tmp11_, _tmp11__length1, _tmp12_, _tmp13_);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("WARNING")))) {
		switch (0) {
			default:
			{
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				GList* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				_tmp14_ = control_line;
				_tmp14__length1 = control_line_length1;
				_tmp15_ = data_lines;
				_tmp16_ = user_text;
				duplicity_job_process_warning (self, _tmp14_, _tmp14__length1, _tmp15_, _tmp16_);
				break;
			}
		}
	}
	_g_free0 (keyword);
}


static gboolean duplicity_job_ask_question (DuplicityJob* self, const gchar* t, const gchar* m) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean rv = FALSE;
	DejaDupToolJobMode _tmp2_ = 0;
	DejaDupToolJobMode _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	duplicity_job_disconnect_inst (self);
	_tmp0_ = t;
	_tmp1_ = m;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "question", _tmp0_, _tmp1_);
	_tmp2_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp3_ = _tmp2_;
	rv = _tmp3_ != DEJA_DUP_TOOL_JOB_MODE_INVALID;
	_tmp4_ = rv;
	if (!_tmp4_) {
		duplicity_job_handle_done (self, NULL, FALSE, TRUE);
	}
	result = rv;
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* duplicity_job_parse_duplicity_file (DuplicityJob* self, const gchar* file, gint skip_bits) {
	gchar* result = NULL;
	gint next = 0;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	next = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_ = 0;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp1_ = skip_bits;
		skip_bits = _tmp1_ - 1;
		if (_tmp1_ > 0) {
			gint _tmp2_ = 0;
			_tmp2_ = next;
			_tmp0_ = _tmp2_ >= 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = file;
		_tmp4_ = next;
		_tmp5_ = string_index_of_char (_tmp3_, (gunichar) '.', _tmp4_);
		next = _tmp5_ + 1;
	}
	_tmp6_ = next;
	if (_tmp6_ < 0) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		return result;
	} else {
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		_tmp8_ = file;
		_tmp9_ = next;
		_tmp10_ = string_substring (_tmp8_, (glong) _tmp9_, (glong) -1);
		result = _tmp10_;
		return result;
	}
}


static void duplicity_job_real_process_error (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in) {
	gchar* text = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp113_ = NULL;
	g_return_if_fail (text_in != NULL);
	_tmp0_ = text_in;
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	_tmp2_ = duplicity_job_can_ignore_error (self);
	if (_tmp2_) {
		_g_free0 (text);
		return;
	}
	_tmp3_ = firstline;
	_tmp3__length1 = firstline_length1;
	if (_tmp3__length1 > 1) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp4_ = firstline;
		_tmp4__length1 = firstline_length1;
		_tmp5_ = _tmp4_[1];
		_tmp6_ = atoi (_tmp5_);
		switch (_tmp6_) {
			case DUPLICITY_JOB_ERROR_EXCEPTION:
			{
				const gchar* _tmp7_ = NULL;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				const gchar* _tmp11_ = NULL;
				_tmp8_ = firstline;
				_tmp8__length1 = firstline_length1;
				if (_tmp8__length1 > 2) {
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					const gchar* _tmp10_ = NULL;
					_tmp9_ = firstline;
					_tmp9__length1 = firstline_length1;
					_tmp10_ = _tmp9_[2];
					_tmp7_ = _tmp10_;
				} else {
					_tmp7_ = "";
				}
				_tmp11_ = text;
				duplicity_job_process_exception (self, _tmp7_, _tmp11_);
				_g_free0 (text);
				return;
			}
			case DUPLICITY_JOB_ERROR_RESTORE_DIR_NOT_FOUND:
			{
				GList* _tmp12_ = NULL;
				GList* _tmp13_ = NULL;
				_tmp12_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
				_tmp13_ = _tmp12_;
				if (_tmp13_ != NULL) {
					const gchar* _tmp14_ = NULL;
					GList* _tmp15_ = NULL;
					GList* _tmp16_ = NULL;
					gconstpointer _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp14_ = _ ("Could not restore ‘%s’: File not found in backup");
					_tmp15_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp16_ = _tmp15_;
					_tmp17_ = _tmp16_->data;
					_tmp18_ = g_file_get_parse_name ((GFile*) _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = g_strdup_printf (_tmp14_, _tmp19_);
					_g_free0 (text);
					text = _tmp20_;
					_g_free0 (_tmp19_);
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_GPG:
			{
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				g_signal_emit_by_name ((DejaDupToolJob*) self, "bad-encryption-password");
				_tmp21_ = _ ("Bad encryption password.");
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (text);
				text = _tmp22_;
				break;
			}
			case DUPLICITY_JOB_ERROR_HOSTNAME_CHANGED:
			{
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gchar* _tmp34_ = NULL;
				gboolean _tmp35_ = FALSE;
				_tmp23_ = firstline;
				_tmp23__length1 = firstline_length1;
				if (_tmp23__length1 >= 4) {
					const gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					const gchar* _tmp27_ = NULL;
					gchar** _tmp28_ = NULL;
					gint _tmp28__length1 = 0;
					const gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					_tmp24_ = _ ("Computer name changed");
					_tmp25_ = _ ("The existing backup is of a computer named %s, but the current compute" \
"r’s name is %s.  If this is unexpected, you should back up to a differ" \
"ent location.");
					_tmp26_ = firstline;
					_tmp26__length1 = firstline_length1;
					_tmp27_ = _tmp26_[3];
					_tmp28_ = firstline;
					_tmp28__length1 = firstline_length1;
					_tmp29_ = _tmp28_[2];
					_tmp30_ = g_strdup_printf (_tmp25_, _tmp27_, _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = duplicity_job_ask_question (self, _tmp24_, _tmp31_);
					_tmp33_ = !_tmp32_;
					_g_free0 (_tmp31_);
					if (_tmp33_) {
						_g_free0 (text);
						return;
					}
				}
				_tmp34_ = g_strdup ("--allow-source-mismatch");
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp34_);
				_tmp35_ = duplicity_job_restart (self);
				if (_tmp35_) {
					_g_free0 (text);
					return;
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BAD_VOLUME:
			{
				DejaDupToolJobMode _tmp36_ = 0;
				DejaDupToolJobMode _tmp37_ = 0;
				_tmp36_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp37_ = _tmp36_;
				if (_tmp37_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					gchar* this_volume = NULL;
					gchar** _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gboolean _tmp45_ = FALSE;
					gboolean _tmp46_ = FALSE;
					guint _tmp47_ = 0U;
					_tmp38_ = firstline;
					_tmp38__length1 = firstline_length1;
					_tmp39_ = _tmp38_[2];
					_tmp40_ = duplicity_job_parse_duplicity_file (self, _tmp39_, 2);
					this_volume = _tmp40_;
					_tmp41_ = self->priv->last_bad_volume;
					_tmp42_ = this_volume;
					if (g_strcmp0 (_tmp41_, _tmp42_) != 0) {
						const gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						self->priv->bad_volume_count = (guint) 0;
						_tmp43_ = this_volume;
						_tmp44_ = g_strdup (_tmp43_);
						_g_free0 (self->priv->last_bad_volume);
						self->priv->last_bad_volume = _tmp44_;
					}
					_tmp47_ = self->priv->bad_volume_count;
					if (_tmp47_ == ((guint) 0)) {
						gboolean _tmp48_ = FALSE;
						_tmp48_ = duplicity_job_restart (self);
						_tmp46_ = _tmp48_;
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						_tmp45_ = TRUE;
					} else {
						gboolean _tmp49_ = FALSE;
						guint _tmp50_ = 0U;
						_tmp50_ = self->priv->bad_volume_count;
						if (_tmp50_ == ((guint) 1)) {
							gboolean _tmp51_ = FALSE;
							_tmp51_ = duplicity_job_cleanup (self);
							_tmp49_ = _tmp51_;
						} else {
							_tmp49_ = FALSE;
						}
						_tmp45_ = _tmp49_;
					}
					if (_tmp45_) {
						guint _tmp52_ = 0U;
						_tmp52_ = self->priv->bad_volume_count;
						self->priv->bad_volume_count = _tmp52_ + 1;
						_g_free0 (this_volume);
						_g_free0 (text);
						return;
					}
					_g_free0 (this_volume);
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BACKEND_PERMISSION_DENIED:
			{
				gboolean _tmp53_ = FALSE;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gboolean _tmp65_ = FALSE;
				gchar** _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				_tmp54_ = firstline;
				_tmp54__length1 = firstline_length1;
				if (_tmp54__length1 >= 5) {
					gchar** _tmp55_ = NULL;
					gint _tmp55__length1 = 0;
					const gchar* _tmp56_ = NULL;
					_tmp55_ = firstline;
					_tmp55__length1 = firstline_length1;
					_tmp56_ = _tmp55_[2];
					_tmp53_ = g_strcmp0 (_tmp56_, "put") == 0;
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					GFile* file = NULL;
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					const gchar* _tmp58_ = NULL;
					GFile* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					GFile* _tmp61_ = NULL;
					gchar* _tmp62_ = NULL;
					gchar* _tmp63_ = NULL;
					gchar* _tmp64_ = NULL;
					_tmp57_ = firstline;
					_tmp57__length1 = firstline_length1;
					_tmp58_ = _tmp57_[4];
					_tmp59_ = duplicity_job_make_file_obj (self, _tmp58_);
					file = _tmp59_;
					_tmp60_ = _ ("Permission denied when trying to create ‘%s’.");
					_tmp61_ = file;
					_tmp62_ = g_file_get_parse_name (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = g_strdup_printf (_tmp60_, _tmp63_);
					_g_free0 (text);
					text = _tmp64_;
					_g_free0 (_tmp63_);
					_g_object_unref0 (file);
				}
				_tmp66_ = firstline;
				_tmp66__length1 = firstline_length1;
				if (_tmp66__length1 >= 5) {
					gchar** _tmp67_ = NULL;
					gint _tmp67__length1 = 0;
					const gchar* _tmp68_ = NULL;
					_tmp67_ = firstline;
					_tmp67__length1 = firstline_length1;
					_tmp68_ = _tmp67_[2];
					_tmp65_ = g_strcmp0 (_tmp68_, "get") == 0;
				} else {
					_tmp65_ = FALSE;
				}
				if (_tmp65_) {
					GFile* file = NULL;
					gchar** _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					const gchar* _tmp70_ = NULL;
					GFile* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					GFile* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
					gchar* _tmp75_ = NULL;
					gchar* _tmp76_ = NULL;
					_tmp69_ = firstline;
					_tmp69__length1 = firstline_length1;
					_tmp70_ = _tmp69_[3];
					_tmp71_ = duplicity_job_make_file_obj (self, _tmp70_);
					file = _tmp71_;
					_tmp72_ = _ ("Permission denied when trying to read ‘%s’.");
					_tmp73_ = file;
					_tmp74_ = g_file_get_parse_name (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strdup_printf (_tmp72_, _tmp75_);
					_g_free0 (text);
					text = _tmp76_;
					_g_free0 (_tmp75_);
					_g_object_unref0 (file);
				} else {
					gboolean _tmp77_ = FALSE;
					gchar** _tmp78_ = NULL;
					gint _tmp78__length1 = 0;
					_tmp78_ = firstline;
					_tmp78__length1 = firstline_length1;
					if (_tmp78__length1 >= 4) {
						gchar** _tmp79_ = NULL;
						gint _tmp79__length1 = 0;
						const gchar* _tmp80_ = NULL;
						_tmp79_ = firstline;
						_tmp79__length1 = firstline_length1;
						_tmp80_ = _tmp79_[2];
						_tmp77_ = g_strcmp0 (_tmp80_, "list") == 0;
					} else {
						_tmp77_ = FALSE;
					}
					if (_tmp77_) {
						GFile* file = NULL;
						gchar** _tmp81_ = NULL;
						gint _tmp81__length1 = 0;
						const gchar* _tmp82_ = NULL;
						GFile* _tmp83_ = NULL;
						const gchar* _tmp84_ = NULL;
						GFile* _tmp85_ = NULL;
						gchar* _tmp86_ = NULL;
						gchar* _tmp87_ = NULL;
						gchar* _tmp88_ = NULL;
						_tmp81_ = firstline;
						_tmp81__length1 = firstline_length1;
						_tmp82_ = _tmp81_[3];
						_tmp83_ = duplicity_job_make_file_obj (self, _tmp82_);
						file = _tmp83_;
						_tmp84_ = _ ("Permission denied when trying to read ‘%s’.");
						_tmp85_ = file;
						_tmp86_ = g_file_get_parse_name (_tmp85_);
						_tmp87_ = _tmp86_;
						_tmp88_ = g_strdup_printf (_tmp84_, _tmp87_);
						_g_free0 (text);
						text = _tmp88_;
						_g_free0 (_tmp87_);
						_g_object_unref0 (file);
					} else {
						gboolean _tmp89_ = FALSE;
						gchar** _tmp90_ = NULL;
						gint _tmp90__length1 = 0;
						_tmp90_ = firstline;
						_tmp90__length1 = firstline_length1;
						if (_tmp90__length1 >= 4) {
							gchar** _tmp91_ = NULL;
							gint _tmp91__length1 = 0;
							const gchar* _tmp92_ = NULL;
							_tmp91_ = firstline;
							_tmp91__length1 = firstline_length1;
							_tmp92_ = _tmp91_[2];
							_tmp89_ = g_strcmp0 (_tmp92_, "delete") == 0;
						} else {
							_tmp89_ = FALSE;
						}
						if (_tmp89_) {
							GFile* file = NULL;
							gchar** _tmp93_ = NULL;
							gint _tmp93__length1 = 0;
							const gchar* _tmp94_ = NULL;
							GFile* _tmp95_ = NULL;
							const gchar* _tmp96_ = NULL;
							GFile* _tmp97_ = NULL;
							gchar* _tmp98_ = NULL;
							gchar* _tmp99_ = NULL;
							gchar* _tmp100_ = NULL;
							_tmp93_ = firstline;
							_tmp93__length1 = firstline_length1;
							_tmp94_ = _tmp93_[3];
							_tmp95_ = duplicity_job_make_file_obj (self, _tmp94_);
							file = _tmp95_;
							_tmp96_ = _ ("Permission denied when trying to delete ‘%s’.");
							_tmp97_ = file;
							_tmp98_ = g_file_get_parse_name (_tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = g_strdup_printf (_tmp96_, _tmp99_);
							_g_free0 (text);
							text = _tmp100_;
							_g_free0 (_tmp99_);
							_g_object_unref0 (file);
						}
					}
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BACKEND_NOT_FOUND:
			{
				gchar** _tmp101_ = NULL;
				gint _tmp101__length1 = 0;
				_tmp101_ = firstline;
				_tmp101__length1 = firstline_length1;
				if (_tmp101__length1 >= 4) {
					GFile* file = NULL;
					gchar** _tmp102_ = NULL;
					gint _tmp102__length1 = 0;
					const gchar* _tmp103_ = NULL;
					GFile* _tmp104_ = NULL;
					const gchar* _tmp105_ = NULL;
					GFile* _tmp106_ = NULL;
					gchar* _tmp107_ = NULL;
					gchar* _tmp108_ = NULL;
					gchar* _tmp109_ = NULL;
					_tmp102_ = firstline;
					_tmp102__length1 = firstline_length1;
					_tmp103_ = _tmp102_[3];
					_tmp104_ = duplicity_job_make_file_obj (self, _tmp103_);
					file = _tmp104_;
					_tmp105_ = _ ("Backup location ‘%s’ does not exist.");
					_tmp106_ = file;
					_tmp107_ = g_file_get_parse_name (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = g_strdup_printf (_tmp105_, _tmp108_);
					_g_free0 (text);
					text = _tmp109_;
					_g_free0 (_tmp108_);
					_g_object_unref0 (file);
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BACKEND_NO_SPACE:
			{
				gchar** _tmp110_ = NULL;
				gint _tmp110__length1 = 0;
				_tmp110_ = firstline;
				_tmp110__length1 = firstline_length1;
				if (_tmp110__length1 >= 5) {
					const gchar* _tmp111_ = NULL;
					gchar* _tmp112_ = NULL;
					_tmp111_ = _ ("No space left.");
					_tmp112_ = g_strdup (_tmp111_);
					_g_free0 (text);
					text = _tmp112_;
				}
				break;
			}
			default:
			break;
		}
	}
	_tmp113_ = text;
	duplicity_job_show_error (self, _tmp113_, NULL);
	_g_free0 (text);
}


void duplicity_job_process_error (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in) {
	g_return_if_fail (self != NULL);
	DUPLICITY_JOB_GET_CLASS (self)->process_error (self, firstline, firstline_length1, data, text_in);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void duplicity_job_process_exception (DuplicityJob* self, const gchar* exception, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (exception != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = exception;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("S3ResponseError")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				_tmp4_ = text;
				_tmp5_ = string_contains (_tmp4_, "<Code>InvalidAccessKeyId</Code>");
				if (_tmp5_) {
					const gchar* _tmp6_ = NULL;
					_tmp6_ = _ ("Invalid ID.");
					duplicity_job_show_error (self, _tmp6_, NULL);
				} else {
					const gchar* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					_tmp7_ = text;
					_tmp8_ = string_contains (_tmp7_, "<Code>SignatureDoesNotMatch</Code>");
					if (_tmp8_) {
						const gchar* _tmp9_ = NULL;
						_tmp9_ = _ ("Invalid secret key.");
						duplicity_job_show_error (self, _tmp9_, NULL);
					} else {
						const gchar* _tmp10_ = NULL;
						gboolean _tmp11_ = FALSE;
						_tmp10_ = text;
						_tmp11_ = string_contains (_tmp10_, "<Code>NotSignedUp</Code>");
						if (_tmp11_) {
							const gchar* _tmp12_ = NULL;
							_tmp12_ = _ ("Your Amazon Web Services account is not signed up for the S3 service.");
							duplicity_job_show_error (self, _tmp12_, NULL);
						}
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("S3CreateError")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = text;
				_tmp14_ = string_contains (_tmp13_, "<Code>BucketAlreadyExists</Code>");
				if (_tmp14_) {
					DejaDupBackend* _tmp15_ = NULL;
					DejaDupBackend* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
					const gchar* _tmp19_ = NULL;
					_tmp15_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
					_tmp16_ = _tmp15_;
					_tmp17_ = deja_dup_backend_s3_bump_bucket (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3));
					if (_tmp17_) {
						gboolean _tmp18_ = FALSE;
						_tmp18_ = duplicity_job_restart (self);
						if (_tmp18_) {
							return;
						}
					}
					_tmp19_ = _ ("S3 bucket name is not available.");
					duplicity_job_show_error (self, _tmp19_, NULL);
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("EOFError")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp20_ = NULL;
				g_signal_emit_by_name ((DejaDupToolJob*) self, "bad-encryption-password");
				_tmp20_ = _ ("Bad encryption password.");
				duplicity_job_show_error (self, _tmp20_, NULL);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("IOError")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				_tmp21_ = text;
				_tmp22_ = string_contains (_tmp21_, "GnuPG");
				if (_tmp22_) {
					const gchar* _tmp23_ = NULL;
					_tmp23_ = _ ("Bad encryption password.");
					duplicity_job_show_error (self, _tmp23_, NULL);
				} else {
					gboolean _tmp24_ = FALSE;
					const gchar* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
					_tmp25_ = text;
					_tmp26_ = string_contains (_tmp25_, "[Errno 5]");
					if (_tmp26_) {
						GFile* _tmp27_ = NULL;
						_tmp27_ = self->priv->last_touched_file;
						_tmp24_ = _tmp27_ != NULL;
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						DejaDupToolJobMode _tmp28_ = 0;
						DejaDupToolJobMode _tmp29_ = 0;
						_tmp28_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
						_tmp29_ = _tmp28_;
						if (_tmp29_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
							const gchar* _tmp30_ = NULL;
							GFile* _tmp31_ = NULL;
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_ = NULL;
							gchar* _tmp34_ = NULL;
							gchar* _tmp35_ = NULL;
							_tmp30_ = _ ("Error reading file ‘%s’.");
							_tmp31_ = self->priv->last_touched_file;
							_tmp32_ = g_file_get_parse_name (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = g_strdup_printf (_tmp30_, _tmp33_);
							_tmp35_ = _tmp34_;
							duplicity_job_show_error (self, _tmp35_, NULL);
							_g_free0 (_tmp35_);
							_g_free0 (_tmp33_);
						} else {
							const gchar* _tmp36_ = NULL;
							GFile* _tmp37_ = NULL;
							gchar* _tmp38_ = NULL;
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_ = NULL;
							gchar* _tmp41_ = NULL;
							_tmp36_ = _ ("Error writing file ‘%s’.");
							_tmp37_ = self->priv->last_touched_file;
							_tmp38_ = g_file_get_parse_name (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_strdup_printf (_tmp36_, _tmp39_);
							_tmp41_ = _tmp40_;
							duplicity_job_show_error (self, _tmp41_, NULL);
							_g_free0 (_tmp41_);
							_g_free0 (_tmp39_);
						}
					} else {
						const gchar* _tmp42_ = NULL;
						gboolean _tmp43_ = FALSE;
						_tmp42_ = text;
						_tmp43_ = string_contains (_tmp42_, "[Errno 28]");
						if (_tmp43_) {
							gchar* where = NULL;
							DejaDupToolJobMode _tmp44_ = 0;
							DejaDupToolJobMode _tmp45_ = 0;
							const gchar* _tmp52_ = NULL;
							where = NULL;
							_tmp44_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
							_tmp45_ = _tmp44_;
							if (_tmp45_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
								DejaDupBackend* _tmp46_ = NULL;
								DejaDupBackend* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								_tmp46_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
								_tmp47_ = _tmp46_;
								_tmp48_ = deja_dup_backend_get_location_pretty (_tmp47_);
								_g_free0 (where);
								where = _tmp48_;
							} else {
								GFile* _tmp49_ = NULL;
								GFile* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								_tmp49_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
								_tmp50_ = _tmp49_;
								_tmp51_ = g_file_get_path (_tmp50_);
								_g_free0 (where);
								where = _tmp51_;
							}
							_tmp52_ = where;
							if (_tmp52_ == NULL) {
								const gchar* _tmp53_ = NULL;
								_tmp53_ = _ ("No space left.");
								duplicity_job_show_error (self, _tmp53_, NULL);
							} else {
								const gchar* _tmp54_ = NULL;
								const gchar* _tmp55_ = NULL;
								gchar* _tmp56_ = NULL;
								gchar* _tmp57_ = NULL;
								_tmp54_ = _ ("No space left in ‘%s’.");
								_tmp55_ = where;
								_tmp56_ = g_strdup_printf (_tmp54_, _tmp55_);
								_tmp57_ = _tmp56_;
								duplicity_job_show_error (self, _tmp57_, NULL);
								_g_free0 (_tmp57_);
							}
							_g_free0 (where);
						} else {
							const gchar* _tmp58_ = NULL;
							gboolean _tmp59_ = FALSE;
							_tmp58_ = text;
							_tmp59_ = string_contains (_tmp58_, "CRC check failed");
							if (_tmp59_) {
								gboolean _tmp60_ = FALSE;
								_tmp60_ = duplicity_job_restart_without_cache (self);
								if (_tmp60_) {
									return;
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("CollectionsError")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp61_ = NULL;
				_tmp61_ = _ ("No backup files found");
				duplicity_job_show_error (self, _tmp61_, NULL);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("AssertionError")))) {
		switch (0) {
			default:
			{
				gboolean _tmp62_ = FALSE;
				_tmp62_ = duplicity_job_restart_without_cache (self);
				if (_tmp62_) {
					return;
				}
				break;
			}
		}
	}
	_tmp64_ = self->priv->_error_issued;
	if (!_tmp64_) {
		gboolean _tmp65_ = FALSE;
		_tmp65_ = duplicity_job_restart_without_cache (self);
		_tmp63_ = !_tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		const gchar* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		_tmp66_ = _ ("Failed with an unknown error.");
		_tmp67_ = text;
		duplicity_job_show_error (self, _tmp66_, _tmp67_);
	}
}


static void duplicity_job_real_process_info (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (text != NULL);
	_tmp0_ = firstline;
	_tmp0__length1 = firstline_length1;
	if (_tmp0__length1 > 1) {
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		const gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = firstline;
		_tmp1__length1 = firstline_length1;
		_tmp2_ = _tmp1_[1];
		_tmp3_ = atoi (_tmp2_);
		switch (_tmp3_) {
			case DUPLICITY_JOB_INFO_DIFF_FILE_NEW:
			case DUPLICITY_JOB_INFO_DIFF_FILE_CHANGED:
			case DUPLICITY_JOB_INFO_DIFF_FILE_DELETED:
			{
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				_tmp4_ = firstline;
				_tmp4__length1 = firstline_length1;
				if (_tmp4__length1 > 2) {
					gchar** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					const gchar* _tmp6_ = NULL;
					_tmp5_ = firstline;
					_tmp5__length1 = firstline_length1;
					_tmp6_ = _tmp5_[2];
					duplicity_job_process_diff_file (self, _tmp6_);
				}
				break;
			}
			case DUPLICITY_JOB_INFO_PATCH_FILE_WRITING:
			case DUPLICITY_JOB_INFO_PATCH_FILE_PATCHING:
			{
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				_tmp7_ = firstline;
				_tmp7__length1 = firstline_length1;
				if (_tmp7__length1 > 2) {
					gchar** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					const gchar* _tmp9_ = NULL;
					_tmp8_ = firstline;
					_tmp8__length1 = firstline_length1;
					_tmp9_ = _tmp8_[2];
					duplicity_job_process_patch_file (self, _tmp9_);
				}
				break;
			}
			case DUPLICITY_JOB_INFO_PROGRESS:
			{
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				_tmp10_ = firstline;
				_tmp10__length1 = firstline_length1;
				duplicity_job_process_progress (self, _tmp10_, _tmp10__length1);
				break;
			}
			case DUPLICITY_JOB_INFO_COLLECTION_STATUS:
			{
				GList* _tmp11_ = NULL;
				_tmp11_ = data;
				duplicity_job_process_collection_status (self, _tmp11_);
				break;
			}
			case DUPLICITY_JOB_INFO_SYNCHRONOUS_UPLOAD_BEGIN:
			case DUPLICITY_JOB_INFO_ASYNCHRONOUS_UPLOAD_BEGIN:
			{
				DejaDupBackend* _tmp12_ = NULL;
				DejaDupBackend* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp12_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
				_tmp13_ = _tmp12_;
				_tmp14_ = deja_dup_backend_is_native (_tmp13_);
				if (!_tmp14_) {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = _ ("Uploading…");
					duplicity_job_set_status (self, _tmp15_, TRUE);
				}
				break;
			}
			case DUPLICITY_JOB_INFO_FILE_STAT:
			{
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				const gchar* _tmp17_ = NULL;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				const gchar* _tmp19_ = NULL;
				GList* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				_tmp16_ = firstline;
				_tmp16__length1 = firstline_length1;
				_tmp17_ = _tmp16_[2];
				_tmp18_ = firstline;
				_tmp18__length1 = firstline_length1;
				_tmp19_ = _tmp18_[3];
				_tmp20_ = data;
				_tmp21_ = text;
				duplicity_job_process_file_stat (self, _tmp17_, _tmp19_, _tmp20_, _tmp21_);
				break;
			}
			default:
			break;
		}
	}
}


void duplicity_job_process_info (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	g_return_if_fail (self != NULL);
	DUPLICITY_JOB_GET_CLASS (self)->process_info (self, firstline, firstline_length1, data, text);
}


static void duplicity_job_process_file_stat (DuplicityJob* self, const gchar* date, const gchar* file, GList* data, const gchar* text) {
	DejaDupToolJobMode _tmp0_ = 0;
	DejaDupToolJobMode _tmp1_ = 0;
	DuplicityJobState _tmp2_ = 0;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != DEJA_DUP_TOOL_JOB_MODE_LIST) {
		return;
	}
	_tmp2_ = self->priv->_state;
	if (_tmp2_ == DUPLICITY_JOB_STATE_CHECK_CONTENTS) {
		GFile* gfile = NULL;
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		_tmp3_ = file;
		_tmp4_ = duplicity_job_make_file_obj (self, _tmp3_);
		gfile = _tmp4_;
		_tmp6_ = gfile;
		_tmp7_ = duplicity_job_slash_root;
		_tmp8_ = g_file_equal (_tmp6_, _tmp7_);
		if (_tmp8_) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp9_ = FALSE;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp10_ = gfile;
			_tmp11_ = g_file_get_parent (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_ != NULL;
			_g_object_unref0 (_tmp12_);
			if (_tmp13_) {
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				GFile* _tmp16_ = NULL;
				GFile* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				_tmp14_ = gfile;
				_tmp15_ = g_file_get_parent (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = duplicity_job_slash_home;
				_tmp18_ = g_file_equal (_tmp16_, _tmp17_);
				_tmp9_ = _tmp18_;
				_g_object_unref0 (_tmp16_);
			} else {
				_tmp9_ = FALSE;
			}
			_tmp5_ = _tmp9_;
		}
		if (_tmp5_) {
			GFile* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
			_tmp19_ = gfile;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			self->priv->homes = g_list_append (self->priv->homes, _tmp20_);
		}
		_tmp24_ = self->priv->has_non_home_contents;
		if (!_tmp24_) {
			GFile* _tmp25_ = NULL;
			GFile* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			_tmp25_ = gfile;
			_tmp26_ = duplicity_job_slash;
			_tmp27_ = g_file_equal (_tmp25_, _tmp26_);
			_tmp23_ = !_tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			GFile* _tmp28_ = NULL;
			GFile* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			_tmp28_ = gfile;
			_tmp29_ = duplicity_job_slash_home;
			_tmp30_ = g_file_equal (_tmp28_, _tmp29_);
			_tmp22_ = !_tmp30_;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			GFile* _tmp31_ = NULL;
			GFile* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			_tmp31_ = gfile;
			_tmp32_ = duplicity_job_slash_home;
			_tmp33_ = g_file_has_prefix (_tmp31_, _tmp32_);
			_tmp21_ = !_tmp33_;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			self->priv->has_non_home_contents = TRUE;
		}
		_g_object_unref0 (gfile);
	}
	_tmp34_ = date;
	_tmp35_ = file;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "listed-current-files", _tmp34_, _tmp35_);
}


static void duplicity_job_process_diff_file (DuplicityJob* self, const gchar* file) {
	GFile* gfile = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFileType _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = duplicity_job_make_file_obj (self, _tmp0_);
	gfile = _tmp1_;
	_tmp2_ = gfile;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->last_touched_file);
	self->priv->last_touched_file = _tmp3_;
	_tmp4_ = gfile;
	_tmp5_ = g_file_query_file_type (_tmp4_, G_FILE_QUERY_INFO_NONE, NULL);
	if (_tmp5_ != G_FILE_TYPE_DIRECTORY) {
		GFile* _tmp6_ = NULL;
		DuplicityJobState _tmp7_ = 0;
		_tmp6_ = gfile;
		_tmp7_ = self->priv->_state;
		duplicity_job_set_status_file (self, _tmp6_, _tmp7_ != DUPLICITY_JOB_STATE_DRY_RUN, TRUE);
	}
	_g_object_unref0 (gfile);
}


static void duplicity_job_process_patch_file (DuplicityJob* self, const gchar* file) {
	GFile* gfile = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFileType _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = duplicity_job_make_file_obj (self, _tmp0_);
	gfile = _tmp1_;
	_tmp2_ = gfile;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->last_touched_file);
	self->priv->last_touched_file = _tmp3_;
	_tmp4_ = gfile;
	_tmp5_ = g_file_query_file_type (_tmp4_, G_FILE_QUERY_INFO_NONE, NULL);
	if (_tmp5_ != G_FILE_TYPE_DIRECTORY) {
		GFile* _tmp6_ = NULL;
		DuplicityJobState _tmp7_ = 0;
		_tmp6_ = gfile;
		_tmp7_ = self->priv->_state;
		duplicity_job_set_status_file (self, _tmp6_, _tmp7_ != DUPLICITY_JOB_STATE_DRY_RUN, TRUE);
	}
	_g_object_unref0 (gfile);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static void duplicity_job_process_progress (DuplicityJob* self, gchar** firstline, int firstline_length1) {
	gdouble total = 0.0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gdouble percent = 0.0;
	guint64 _tmp10_ = 0ULL;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = firstline;
	_tmp0__length1 = firstline_length1;
	if (_tmp0__length1 > 2) {
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		const gchar* _tmp2_ = NULL;
		guint64 _tmp3_ = 0ULL;
		_tmp1_ = firstline;
		_tmp1__length1 = firstline_length1;
		_tmp2_ = _tmp1_[2];
		_tmp3_ = uint64_parse (_tmp2_);
		self->priv->progress_count = _tmp3_;
	} else {
		return;
	}
	_tmp4_ = firstline;
	_tmp4__length1 = firstline_length1;
	if (_tmp4__length1 > 3) {
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		_tmp5_ = firstline;
		_tmp5__length1 = firstline_length1;
		_tmp6_ = _tmp5_[3];
		_tmp7_ = double_parse (_tmp6_);
		total = _tmp7_;
	} else {
		guint64 _tmp8_ = 0ULL;
		_tmp8_ = self->priv->progress_total;
		if (_tmp8_ > ((guint64) 0)) {
			guint64 _tmp9_ = 0ULL;
			_tmp9_ = self->priv->progress_total;
			total = (gdouble) _tmp9_;
		} else {
			return;
		}
	}
	_tmp10_ = self->priv->progress_count;
	_tmp11_ = total;
	percent = ((gdouble) _tmp10_) / _tmp11_;
	_tmp12_ = percent;
	if (_tmp12_ > ((gdouble) 1)) {
		percent = (gdouble) 1;
	}
	_tmp13_ = percent;
	if (_tmp13_ < ((gdouble) 0)) {
		percent = (gdouble) 0;
	}
	_tmp14_ = percent;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "progress", _tmp14_);
}


static GFile* duplicity_job_make_file_obj (DuplicityJob* self, const gchar* file) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = duplicity_job_slash;
	_tmp1_ = file;
	_tmp2_ = g_file_resolve_relative_path (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _duplicity_job_date_info_dup0 (gpointer self) {
	return self ? duplicity_job_date_info_dup (self) : NULL;
}


static void duplicity_job_process_collection_status (DuplicityJob* self, GList* lines) {
	gboolean _tmp0_ = FALSE;
	DejaDupToolJobMode _tmp1_ = 0;
	DejaDupToolJobMode _tmp2_ = 0;
	GTimeVal timeval = {0};
	GList* dates = NULL;
	GList* infos = NULL;
	gboolean in_chain = FALSE;
	GList* _tmp4_ = NULL;
	GList* _tmp40_ = NULL;
	GList* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != DEJA_DUP_TOOL_JOB_MODE_STATUS) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->got_collection_info;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	g_get_current_time (&timeval);
	dates = NULL;
	infos = NULL;
	in_chain = FALSE;
	_tmp4_ = lines;
	{
		GList* line_collection = NULL;
		GList* line_it = NULL;
		line_collection = _tmp4_;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp5_ = NULL;
			gchar* line = NULL;
			_tmp5_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_ = NULL;
				_tmp7_ = line;
				if (g_strcmp0 (_tmp7_, "chain-complete") == 0) {
					_tmp6_ = TRUE;
				} else {
					const gchar* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					_tmp8_ = line;
					_tmp9_ = string_index_of (_tmp8_, "chain-no-sig", 0);
					_tmp6_ = _tmp9_ == 0;
				}
				if (_tmp6_) {
					in_chain = TRUE;
				} else {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					_tmp12_ = in_chain;
					if (_tmp12_) {
						const gchar* _tmp13_ = NULL;
						gint _tmp14_ = 0;
						gint _tmp15_ = 0;
						_tmp13_ = line;
						_tmp14_ = strlen (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp11_ = _tmp15_ > 0;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						const gchar* _tmp16_ = NULL;
						gchar _tmp17_ = '\0';
						_tmp16_ = line;
						_tmp17_ = string_get (_tmp16_, (glong) 0);
						_tmp10_ = _tmp17_ == ' ';
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						gchar** tokens = NULL;
						const gchar* _tmp18_ = NULL;
						gchar** _tmp19_ = NULL;
						gchar** _tmp20_ = NULL;
						gint tokens_length1 = 0;
						gint _tokens_size_ = 0;
						gboolean _tmp21_ = FALSE;
						gchar** _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						_tmp18_ = line;
						_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, " ", 0);
						tokens = _tmp20_;
						tokens_length1 = _vala_array_length (_tmp19_);
						_tokens_size_ = tokens_length1;
						_tmp22_ = tokens;
						_tmp22__length1 = tokens_length1;
						if (_tmp22__length1 > 2) {
							gchar** _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							const gchar* _tmp24_ = NULL;
							gboolean _tmp25_ = FALSE;
							_tmp23_ = tokens;
							_tmp23__length1 = tokens_length1;
							_tmp24_ = _tmp23_[2];
							_tmp25_ = g_time_val_from_iso8601 (_tmp24_, &timeval);
							_tmp21_ = _tmp25_;
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							gchar** _tmp26_ = NULL;
							gint _tmp26__length1 = 0;
							const gchar* _tmp27_ = NULL;
							gchar* _tmp28_ = NULL;
							DuplicityJobDateInfo info = {0};
							GTimeVal _tmp29_ = {0};
							gchar** _tmp30_ = NULL;
							gint _tmp30__length1 = 0;
							const gchar* _tmp31_ = NULL;
							DuplicityJobDateInfo _tmp32_ = {0};
							DuplicityJobDateInfo* _tmp33_ = NULL;
							gboolean _tmp34_ = FALSE;
							gboolean _tmp35_ = FALSE;
							_tmp26_ = tokens;
							_tmp26__length1 = tokens_length1;
							_tmp27_ = _tmp26_[2];
							_tmp28_ = g_strdup (_tmp27_);
							dates = g_list_append (dates, _tmp28_);
							memset (&info, 0, sizeof (DuplicityJobDateInfo));
							_tmp29_ = timeval;
							info.time = _tmp29_;
							_tmp30_ = tokens;
							_tmp30__length1 = tokens_length1;
							_tmp31_ = _tmp30_[1];
							info.full = g_strcmp0 (_tmp31_, "full") == 0;
							_tmp32_ = info;
							_tmp33_ = _duplicity_job_date_info_dup0 (&_tmp32_);
							infos = g_list_append (infos, _tmp33_);
							_tmp35_ = self->priv->detected_encryption;
							if (!_tmp35_) {
								gchar** _tmp36_ = NULL;
								gint _tmp36__length1 = 0;
								_tmp36_ = tokens;
								_tmp36__length1 = tokens_length1;
								_tmp34_ = _tmp36__length1 > 4;
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								gchar** _tmp37_ = NULL;
								gint _tmp37__length1 = 0;
								const gchar* _tmp38_ = NULL;
								self->priv->detected_encryption = TRUE;
								_tmp37_ = tokens;
								_tmp37__length1 = tokens_length1;
								_tmp38_ = _tmp37_[4];
								self->priv->existing_encrypted = g_strcmp0 (_tmp38_, "enc") == 0;
							}
						}
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					} else {
						gboolean _tmp39_ = FALSE;
						_tmp39_ = in_chain;
						if (_tmp39_) {
							in_chain = FALSE;
						}
					}
				}
				_g_free0 (line);
			}
		}
	}
	self->priv->got_collection_info = TRUE;
	__g_list_free__duplicity_job_date_info_free0_0 (self->priv->collection_info);
	self->priv->collection_info = NULL;
	_tmp40_ = infos;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp40_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			DuplicityJobDateInfo s = {0};
			s = *((DuplicityJobDateInfo*) s_it->data);
			{
				DuplicityJobDateInfo _tmp41_ = {0};
				DuplicityJobDateInfo* _tmp42_ = NULL;
				_tmp41_ = s;
				_tmp42_ = _duplicity_job_date_info_dup0 (&_tmp41_);
				self->priv->collection_info = g_list_append (self->priv->collection_info, _tmp42_);
			}
		}
	}
	_tmp43_ = dates;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "collection-dates", _tmp43_);
	__g_list_free__duplicity_job_date_info_free0_0 (infos);
	__g_list_free__g_free0_0 (dates);
}


static void duplicity_job_real_process_warning (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (text != NULL);
	_tmp0_ = firstline;
	_tmp0__length1 = firstline_length1;
	if (_tmp0__length1 > 1) {
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		const gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = firstline;
		_tmp1__length1 = firstline_length1;
		_tmp2_ = _tmp1_[1];
		_tmp3_ = atoi (_tmp2_);
		switch (_tmp3_) {
			case DUPLICITY_JOB_WARNING_ORPHANED_SIG:
			case DUPLICITY_JOB_WARNING_UNNECESSARY_SIG:
			case DUPLICITY_JOB_WARNING_UNMATCHED_SIG:
			case DUPLICITY_JOB_WARNING_INCOMPLETE_BACKUP:
			case DUPLICITY_JOB_WARNING_ORPHANED_BACKUP:
			{
				gboolean _tmp4_ = FALSE;
				DejaDupToolJobMode _tmp5_ = 0;
				DejaDupToolJobMode _tmp6_ = 0;
				_tmp5_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp6_ = _tmp5_;
				if (_tmp6_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					gboolean _tmp7_ = FALSE;
					_tmp7_ = self->priv->cleaned_up_once;
					_tmp4_ = !_tmp7_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					duplicity_job_cleanup (self);
				}
				break;
			}
			case DUPLICITY_JOB_WARNING_CANNOT_READ:
			{
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				_tmp8_ = firstline;
				_tmp8__length1 = firstline_length1;
				if (_tmp8__length1 > 2) {
					GFile* error_file = NULL;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					const gchar* _tmp10_ = NULL;
					GFile* _tmp11_ = NULL;
					GList* _tmp12_ = NULL;
					_tmp9_ = firstline;
					_tmp9__length1 = firstline_length1;
					_tmp10_ = _tmp9_[2];
					_tmp11_ = duplicity_job_make_file_obj (self, _tmp10_);
					error_file = _tmp11_;
					_tmp12_ = ((DejaDupToolJob*) self)->includes;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp12_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							GFile* _tmp13_ = NULL;
							GFile* f = NULL;
							_tmp13_ = _g_object_ref0 ((GFile*) f_it->data);
							f = _tmp13_;
							{
								gboolean _tmp14_ = FALSE;
								GFile* _tmp15_ = NULL;
								GFile* _tmp16_ = NULL;
								gboolean _tmp17_ = FALSE;
								_tmp15_ = error_file;
								_tmp16_ = f;
								_tmp17_ = g_file_equal (_tmp15_, _tmp16_);
								if (_tmp17_) {
									_tmp14_ = TRUE;
								} else {
									GFile* _tmp18_ = NULL;
									GFile* _tmp19_ = NULL;
									gboolean _tmp20_ = FALSE;
									_tmp18_ = error_file;
									_tmp19_ = f;
									_tmp20_ = g_file_has_prefix (_tmp18_, _tmp19_);
									_tmp14_ = _tmp20_;
								}
								if (_tmp14_) {
									GFile* _tmp21_ = NULL;
									GFile* _tmp22_ = NULL;
									_tmp21_ = error_file;
									_tmp22_ = _g_object_ref0 (_tmp21_);
									self->priv->local_error_files = g_list_append (self->priv->local_error_files, _tmp22_);
								}
								_g_object_unref0 (f);
							}
						}
					}
					_g_object_unref0 (error_file);
				}
				break;
			}
			case DUPLICITY_JOB_WARNING_CANNOT_PROCESS:
			{
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				_tmp23_ = firstline;
				_tmp23__length1 = firstline_length1;
				if (_tmp23__length1 > 2) {
					GFile* error_file = NULL;
					gchar** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					const gchar* _tmp25_ = NULL;
					GFile* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					GFile* _tmp28_ = NULL;
					GFile* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					_tmp24_ = firstline;
					_tmp24__length1 = firstline_length1;
					_tmp25_ = _tmp24_[2];
					_tmp26_ = duplicity_job_make_file_obj (self, _tmp25_);
					error_file = _tmp26_;
					_tmp28_ = error_file;
					_tmp29_ = duplicity_job_slash;
					_tmp30_ = g_file_equal (_tmp28_, _tmp29_);
					if (!_tmp30_) {
						const gchar* _tmp31_ = NULL;
						gboolean _tmp32_ = FALSE;
						_tmp31_ = text;
						_tmp32_ = string_contains (_tmp31_, "[Errno 1]");
						_tmp27_ = !_tmp32_;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						GFile* _tmp33_ = NULL;
						GFile* _tmp34_ = NULL;
						_tmp33_ = error_file;
						_tmp34_ = _g_object_ref0 (_tmp33_);
						self->priv->local_error_files = g_list_append (self->priv->local_error_files, _tmp34_);
					}
					_g_object_unref0 (error_file);
				}
				break;
			}
			default:
			break;
		}
	}
}


void duplicity_job_process_warning (DuplicityJob* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	g_return_if_fail (self != NULL);
	DUPLICITY_JOB_GET_CLASS (self)->process_warning (self, firstline, firstline_length1, data, text);
}


static void duplicity_job_show_error (DuplicityJob* self, const gchar* errorstr, const gchar* detail) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (errorstr != NULL);
	_tmp0_ = self->priv->_error_issued;
	if (_tmp0_ == FALSE) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		duplicity_job_set_error_issued (self, TRUE);
		_tmp1_ = errorstr;
		_tmp2_ = detail;
		g_signal_emit_by_name ((DejaDupToolJob*) self, "raise-error", _tmp1_, _tmp2_);
	}
}


static gint duplicity_job_get_volsize (DuplicityJob* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = deja_dup_in_testing_mode ();
	if (_tmp0_) {
		result = 1;
		return result;
	} else {
		DejaDupBackend* _tmp1_ = NULL;
		DejaDupBackend* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = deja_dup_backend_is_native (_tmp2_);
		if (_tmp3_) {
			result = 50;
			return result;
		} else {
			result = 25;
			return result;
		}
	}
}


static void _duplicity_job_handle_done_duplicity_instance_done (DuplicityInstance* _sender, gboolean success, gboolean cancelled, gpointer self) {
	duplicity_job_handle_done ((DuplicityJob*) self, _sender, success, cancelled);
}


static void _duplicity_job_handle_message_duplicity_instance_message (DuplicityInstance* _sender, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text, gpointer self) {
	duplicity_job_handle_message ((DuplicityJob*) self, _sender, control_line, control_line_length1, data_lines, user_text);
}


static void _duplicity_job_handle_exit_duplicity_instance_exited (DuplicityInstance* _sender, gint code, gpointer self) {
	duplicity_job_handle_exit ((DuplicityJob*) self, code);
}


static void duplicity_job_disconnect_inst (DuplicityJob* self) {
	DuplicityInstance* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->inst;
	if (_tmp0_ != NULL) {
		DuplicityInstance* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		DuplicityInstance* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		DuplicityInstance* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		DuplicityInstance* _tmp7_ = NULL;
		_tmp1_ = self->priv->inst;
		g_signal_parse_name ("done", TYPE_DUPLICITY_INSTANCE, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _duplicity_job_handle_done_duplicity_instance_done, self);
		_tmp3_ = self->priv->inst;
		g_signal_parse_name ("message", TYPE_DUPLICITY_INSTANCE, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _duplicity_job_handle_message_duplicity_instance_message, self);
		_tmp5_ = self->priv->inst;
		g_signal_parse_name ("exited", TYPE_DUPLICITY_INSTANCE, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _duplicity_job_handle_exit_duplicity_instance_exited, self);
		_tmp7_ = self->priv->inst;
		duplicity_instance_cancel (_tmp7_);
		_g_object_unref0 (self->priv->inst);
		self->priv->inst = NULL;
	}
}


static void duplicity_job_connect_and_start (DuplicityJob* self, GList* argv_extra, GList* envp_extra, GList* argv_entire, GFile* custom_local) {
	DuplicityInstance* _tmp0_ = NULL;
	DuplicityInstance* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	DuplicityInstance* _tmp5_ = NULL;
	DuplicityInstance* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* master_argv = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFile* local_arg = NULL;
	GList* argv = NULL;
	GList* _tmp16_ = NULL;
	GList* _tmp20_ = NULL;
	GList* _tmp24_ = NULL;
	GList* _tmp28_ = NULL;
	GList* envp = NULL;
	GList* _tmp52_ = NULL;
	GList* _tmp56_ = NULL;
	gboolean use_encryption = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp66_ = FALSE;
	DuplicityInstance* _tmp77_ = NULL;
	GList* _tmp78_ = NULL;
	GList* _tmp79_ = NULL;
	gboolean _tmp80_ = FALSE;
	g_return_if_fail (self != NULL);
	duplicity_job_disconnect_inst (self);
	_tmp0_ = duplicity_instance_new ();
	_g_object_unref0 (self->priv->inst);
	self->priv->inst = _tmp0_;
	_tmp1_ = self->priv->inst;
	g_signal_connect_object (_tmp1_, "done", (GCallback) _duplicity_job_handle_done_duplicity_instance_done, self, 0);
	_tmp2_ = self->priv->forced_cache_dir;
	if (_tmp2_ != NULL) {
		DuplicityInstance* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->inst;
		_tmp4_ = self->priv->forced_cache_dir;
		duplicity_instance_set_forced_cache_dir (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->inst;
	g_signal_connect_object (_tmp5_, "message", (GCallback) _duplicity_job_handle_message_duplicity_instance_message, self, 0);
	_tmp6_ = self->priv->inst;
	g_signal_connect_object (_tmp6_, "exited", (GCallback) _duplicity_job_handle_exit_duplicity_instance_exited, self, 0);
	_tmp8_ = argv_entire;
	if (_tmp8_ == NULL) {
		GList* _tmp9_ = NULL;
		_tmp9_ = self->priv->saved_argv;
		_tmp7_ = _tmp9_;
	} else {
		GList* _tmp10_ = NULL;
		_tmp10_ = argv_entire;
		_tmp7_ = _tmp10_;
	}
	master_argv = _tmp7_;
	_tmp12_ = custom_local;
	if (_tmp12_ == NULL) {
		GFile* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		_tmp13_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
		_tmp14_ = _tmp13_;
		_tmp11_ = _tmp14_;
	} else {
		GFile* _tmp15_ = NULL;
		_tmp15_ = custom_local;
		_tmp11_ = _tmp15_;
	}
	local_arg = _tmp11_;
	argv = NULL;
	_tmp16_ = master_argv;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp16_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp17_ = NULL;
			gchar* s = NULL;
			_tmp17_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp17_;
			{
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				_tmp18_ = s;
				_tmp19_ = g_strdup (_tmp18_);
				argv = g_list_append (argv, _tmp19_);
				_g_free0 (s);
			}
		}
	}
	_tmp20_ = self->priv->backend_argv;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp20_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp21_ = NULL;
			gchar* s = NULL;
			_tmp21_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp21_;
			{
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				_tmp22_ = s;
				_tmp23_ = g_strdup (_tmp22_);
				argv = g_list_append (argv, _tmp23_);
				_g_free0 (s);
			}
		}
	}
	_tmp24_ = argv_extra;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp24_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp25_ = NULL;
			gchar* s = NULL;
			_tmp25_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp25_;
			{
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				_tmp26_ = s;
				_tmp27_ = g_strdup (_tmp26_);
				argv = g_list_append (argv, _tmp27_);
				_g_free0 (s);
			}
		}
	}
	_tmp28_ = argv_entire;
	if (_tmp28_ == NULL) {
		DejaDupToolJobMode _tmp29_ = 0;
		DejaDupToolJobMode _tmp30_ = 0;
		_tmp29_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
		_tmp30_ = _tmp29_;
		switch (_tmp30_) {
			case DEJA_DUP_TOOL_JOB_MODE_BACKUP:
			{
				gboolean _tmp31_ = FALSE;
				gint _tmp33_ = 0;
				gchar* _tmp34_ = NULL;
				GFile* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				_tmp31_ = self->priv->is_full_backup;
				if (_tmp31_) {
					gchar* _tmp32_ = NULL;
					_tmp32_ = g_strdup ("full");
					argv = g_list_prepend (argv, _tmp32_);
				}
				_tmp33_ = duplicity_job_get_volsize (self);
				_tmp34_ = g_strdup_printf ("--volsize=%d", _tmp33_);
				argv = g_list_append (argv, _tmp34_);
				_tmp35_ = local_arg;
				_tmp36_ = g_file_get_path (_tmp35_);
				argv = g_list_append (argv, _tmp36_);
				_tmp37_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp37_);
				break;
			}
			case DEJA_DUP_TOOL_JOB_MODE_RESTORE:
			{
				gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				GFile* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				_tmp38_ = g_strdup ("restore");
				argv = g_list_prepend (argv, _tmp38_);
				_tmp39_ = deja_dup_tool_job_get_time ((DejaDupToolJob*) self);
				_tmp40_ = _tmp39_;
				if (_tmp40_ != NULL) {
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					_tmp41_ = deja_dup_tool_job_get_time ((DejaDupToolJob*) self);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strdup_printf ("--time=%s", _tmp42_);
					argv = g_list_append (argv, _tmp43_);
				}
				_tmp44_ = g_strdup ("--force");
				argv = g_list_append (argv, _tmp44_);
				_tmp45_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp45_);
				_tmp46_ = local_arg;
				_tmp47_ = g_file_get_path (_tmp46_);
				argv = g_list_append (argv, _tmp47_);
				break;
			}
			case DEJA_DUP_TOOL_JOB_MODE_STATUS:
			{
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				_tmp48_ = g_strdup ("collection-status");
				argv = g_list_prepend (argv, _tmp48_);
				_tmp49_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp49_);
				break;
			}
			case DEJA_DUP_TOOL_JOB_MODE_LIST:
			{
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				_tmp50_ = g_strdup ("list-current-files");
				argv = g_list_prepend (argv, _tmp50_);
				_tmp51_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp51_);
				break;
			}
			default:
			break;
		}
	}
	envp = NULL;
	_tmp52_ = self->priv->saved_envp;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp52_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp53_ = NULL;
			gchar* s = NULL;
			_tmp53_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp53_;
			{
				const gchar* _tmp54_ = NULL;
				gchar* _tmp55_ = NULL;
				_tmp54_ = s;
				_tmp55_ = g_strdup (_tmp54_);
				envp = g_list_append (envp, _tmp55_);
				_g_free0 (s);
			}
		}
	}
	_tmp56_ = envp_extra;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp56_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp57_ = NULL;
			gchar* s = NULL;
			_tmp57_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp57_;
			{
				const gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				_tmp58_ = s;
				_tmp59_ = g_strdup (_tmp58_);
				envp = g_list_append (envp, _tmp59_);
				_g_free0 (s);
			}
		}
	}
	use_encryption = FALSE;
	_tmp60_ = self->priv->detected_encryption;
	if (_tmp60_) {
		gboolean _tmp61_ = FALSE;
		_tmp61_ = self->priv->existing_encrypted;
		use_encryption = _tmp61_;
	} else {
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		_tmp62_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
		_tmp63_ = _tmp62_;
		if (_tmp63_ != NULL) {
			const gchar* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			_tmp64_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
			_tmp65_ = _tmp64_;
			use_encryption = g_strcmp0 (_tmp65_, "") != 0;
		}
	}
	_tmp66_ = use_encryption;
	if (_tmp66_) {
		gboolean _tmp67_ = FALSE;
		const gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		_tmp68_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
		_tmp69_ = _tmp68_;
		if (_tmp69_ != NULL) {
			const gchar* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			_tmp70_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
			_tmp71_ = _tmp70_;
			_tmp67_ = g_strcmp0 (_tmp71_, "") != 0;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			const gchar* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			gchar* _tmp74_ = NULL;
			_tmp72_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strdup_printf ("PASSPHRASE=%s", _tmp73_);
			envp = g_list_append (envp, _tmp74_);
		}
	} else {
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		_tmp75_ = g_strdup ("--no-encryption");
		argv = g_list_append (argv, _tmp75_);
		_tmp76_ = g_strdup ("PASSPHRASE=");
		envp = g_list_append (envp, _tmp76_);
	}
	_tmp77_ = self->priv->inst;
	_tmp78_ = argv;
	_tmp79_ = envp;
	_tmp80_ = self->priv->needs_root;
	duplicity_instance_start (_tmp77_, _tmp78_, _tmp79_, _tmp80_, NULL, NULL);
	__g_list_free__g_free0_0 (envp);
	__g_list_free__g_free0_0 (argv);
}


DuplicityJob* duplicity_job_construct (GType object_type) {
	DuplicityJob * self = NULL;
	self = (DuplicityJob*) deja_dup_tool_job_construct (object_type);
	return self;
}


DuplicityJob* duplicity_job_new (void) {
	return duplicity_job_construct (TYPE_DUPLICITY_JOB);
}


static DejaDupToolJobMode duplicity_job_get_original_mode (DuplicityJob* self) {
	DejaDupToolJobMode result;
	DejaDupToolJobMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_original_mode;
	result = _tmp0_;
	return result;
}


static void duplicity_job_set_original_mode (DuplicityJob* self, DejaDupToolJobMode value) {
	DejaDupToolJobMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_original_mode = _tmp0_;
}


static gboolean duplicity_job_get_error_issued (DuplicityJob* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_error_issued;
	result = _tmp0_;
	return result;
}


static void duplicity_job_set_error_issued (DuplicityJob* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_error_issued = _tmp0_;
}


static gboolean duplicity_job_get_was_stopped (DuplicityJob* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_was_stopped;
	result = _tmp0_;
	return result;
}


static void duplicity_job_set_was_stopped (DuplicityJob* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_was_stopped = _tmp0_;
}


DuplicityJobState duplicity_job_get_state (DuplicityJob* self) {
	DuplicityJobState result;
	DuplicityJobState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


void duplicity_job_set_state (DuplicityJob* self, DuplicityJobState value) {
	DuplicityJobState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


static GObject * duplicity_job_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DuplicityJob * self;
	GFile* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (duplicity_job_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_JOB, DuplicityJob);
	_tmp0_ = duplicity_job_slash;
	if (_tmp0_ == NULL) {
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		_tmp1_ = g_file_new_for_path ("/");
		_g_object_unref0 (duplicity_job_slash);
		duplicity_job_slash = _tmp1_;
		_tmp2_ = g_file_new_for_path ("/root");
		_g_object_unref0 (duplicity_job_slash_root);
		duplicity_job_slash_root = _tmp2_;
		_tmp3_ = g_file_new_for_path ("/home");
		_g_object_unref0 (duplicity_job_slash_home);
		duplicity_job_slash_home = _tmp3_;
		_tmp4_ = g_get_home_dir ();
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_g_object_unref0 (duplicity_job_slash_home_me);
		duplicity_job_slash_home_me = _tmp5_;
	}
	return obj;
}


static DuplicityJobDateInfo* duplicity_job_date_info_dup (const DuplicityJobDateInfo* self) {
	DuplicityJobDateInfo* dup;
	dup = g_new0 (DuplicityJobDateInfo, 1);
	memcpy (dup, self, sizeof (DuplicityJobDateInfo));
	return dup;
}


static void duplicity_job_date_info_free (DuplicityJobDateInfo* self) {
	g_free (self);
}


static GType duplicity_job_date_info_get_type (void) {
	static volatile gsize duplicity_job_date_info_type_id__volatile = 0;
	if (g_once_init_enter (&duplicity_job_date_info_type_id__volatile)) {
		GType duplicity_job_date_info_type_id;
		duplicity_job_date_info_type_id = g_boxed_type_register_static ("DuplicityJobDateInfo", (GBoxedCopyFunc) duplicity_job_date_info_dup, (GBoxedFreeFunc) duplicity_job_date_info_free);
		g_once_init_leave (&duplicity_job_date_info_type_id__volatile, duplicity_job_date_info_type_id);
	}
	return duplicity_job_date_info_type_id__volatile;
}


static void duplicity_job_class_init (DuplicityJobClass * klass) {
	duplicity_job_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DuplicityJobPrivate));
	((DejaDupToolJobClass *) klass)->start = duplicity_job_real_start;
	((DejaDupToolJobClass *) klass)->cancel = duplicity_job_real_cancel;
	((DejaDupToolJobClass *) klass)->stop = duplicity_job_real_stop;
	((DejaDupToolJobClass *) klass)->pause = duplicity_job_real_pause;
	((DejaDupToolJobClass *) klass)->resume = duplicity_job_real_resume;
	((DuplicityJobClass *) klass)->process_error = duplicity_job_real_process_error;
	((DuplicityJobClass *) klass)->process_info = duplicity_job_real_process_info;
	((DuplicityJobClass *) klass)->process_warning = duplicity_job_real_process_warning;
	G_OBJECT_CLASS (klass)->get_property = _vala_duplicity_job_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_duplicity_job_set_property;
	G_OBJECT_CLASS (klass)->constructor = duplicity_job_constructor;
	G_OBJECT_CLASS (klass)->finalize = duplicity_job_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DUPLICITY_JOB_STATE, g_param_spec_enum ("state", "state", "state", DUPLICITY_JOB_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void duplicity_job_instance_init (DuplicityJob * self) {
	self->priv = DUPLICITY_JOB_GET_PRIVATE (self);
	self->priv->_error_issued = FALSE;
	self->priv->_was_stopped = FALSE;
	self->priv->is_full_backup = FALSE;
	self->priv->cleaned_up_once = FALSE;
	self->priv->needs_root = FALSE;
	self->priv->detected_encryption = FALSE;
	self->priv->existing_encrypted = FALSE;
	self->priv->has_progress_total = FALSE;
	self->priv->has_checked_contents = FALSE;
	self->priv->has_non_home_contents = FALSE;
	self->priv->homes = NULL;
	self->priv->local_error_files = NULL;
	self->priv->checked_collection_info = FALSE;
	self->priv->got_collection_info = FALSE;
	self->priv->collection_info = NULL;
	self->priv->checked_backup_space = FALSE;
	self->priv->deleted_files = FALSE;
	self->priv->delete_age = 0;
	self->priv->last_touched_file = NULL;
	self->priv->forced_cache_dir = NULL;
	self->priv->restarted_without_cache = FALSE;
}


static void duplicity_job_finalize (GObject* obj) {
	DuplicityJob * self;
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GQuark _tmp3_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_JOB, DuplicityJob);
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("notify::connected", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _duplicity_job_network_changed_g_object_notify, self);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (self->priv->inst);
	__g_list_free__g_free0_0 (self->priv->backend_argv);
	__g_list_free__g_free0_0 (self->priv->saved_argv);
	__g_list_free__g_free0_0 (self->priv->saved_envp);
	_g_free0 (self->priv->last_bad_volume);
	__g_list_free__g_object_unref0_0 (self->priv->homes);
	__g_list_free__g_object_unref0_0 (self->priv->local_error_files);
	__g_list_free__duplicity_job_date_info_free0_0 (self->priv->collection_info);
	_g_object_unref0 (self->priv->last_touched_file);
	_g_free0 (self->priv->forced_cache_dir);
	_g_free0 (self->priv->saved_status);
	_g_object_unref0 (self->priv->saved_status_file);
	G_OBJECT_CLASS (duplicity_job_parent_class)->finalize (obj);
}


GType duplicity_job_get_type (void) {
	return duplicity_job_type_id;
}


GType duplicity_job_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (DuplicityJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicity_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicityJob), 0, (GInstanceInitFunc) duplicity_job_instance_init, NULL };
	duplicity_job_type_id = g_type_module_register_type (module, DEJA_DUP_TYPE_TOOL_JOB, "DuplicityJob", &g_define_type_info, 0);
	return duplicity_job_type_id;
}


static void _vala_duplicity_job_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DuplicityJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DUPLICITY_JOB, DuplicityJob);
	switch (property_id) {
		case DUPLICITY_JOB_STATE:
		g_value_set_enum (value, duplicity_job_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_duplicity_job_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DuplicityJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DUPLICITY_JOB, DuplicityJob);
	switch (property_id) {
		case DUPLICITY_JOB_STATE:
		duplicity_job_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



