; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=slp-vectorizer -mtriple=-x86_64-grtev4-linux-gnu -S -mcpu=corei7-avx -pass-remarks-output=%t < %s | FileCheck %s
; RUN: FileCheck --input-file=%t --check-prefix=YAML %s

; Building a vector of a float (lane 0) and an extract from lane 1 (lane 1)
; should have a cost of +1 because we need an extra instruction to combine
; both into a single vector.
; So this code should not be vectorized.

; YAML: --- !Missed
; YAML: Pass:            slp-vectorizer
; YAML: Name:            NotBeneficial
; YAML: Function:        test
; YAML: Args:
; YAML:   - String:          'List vectorization was possible but not beneficial with cost '
; YAML:   - Cost:            '0'
; YAML:   - String:          ' >= '
; YAML:   - Treshold:        '0'
; YAML: ...
define void @test(<4 x float> %vec, float %a, float %b, ptr %ptr) {
; CHECK-LABEL: define void @test
; CHECK-SAME: (<4 x float> [[VEC:%.*]], float [[A:%.*]], float [[B:%.*]], ptr [[PTR:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[FADD:%.*]] = fadd float [[A]], [[B]]
; CHECK-NEXT:    [[EXTR1:%.*]] = extractelement <4 x float> [[VEC]], i64 1
; CHECK-NEXT:    [[FSUB0:%.*]] = fsub float [[FADD]], [[FADD]]
; CHECK-NEXT:    [[FSUB1:%.*]] = fsub float [[EXTR1]], [[EXTR1]]
; CHECK-NEXT:    [[ROOT:%.*]] = fadd float [[FSUB0]], [[FSUB1]]
; CHECK-NEXT:    store float [[ROOT]], ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
  %fadd = fadd float %a, %b
  %extr1 = extractelement <4 x float> %vec, i64 1

  %fsub0 = fsub float %fadd, %fadd
  %fsub1 = fsub float %extr1, %extr1

  %root = fadd float %fsub0, %fsub1
  store float %root, ptr %ptr
  ret void
}
