#include <stdio.h>
#include <ustr.h>
#include "lib/confdata.h"
#include "lib/util.h"

static void __attribute__((unused))
dumplist (cdsl_dlist_t *list, const char *label)
{
  cdsl_dlist_node_t *p;
  int i = 0;
  for (p = cdsl_dlist_begin (list); p != cdsl_dlist_end (list); p = cdsl_dlist_next (p))
    {
      printf ("%s (%d): '%s'\n", label, i++, (const char *)cdsl_dlist_value (p));
    }
}

run2_confdata_t * populate (void)
{
  run2_confdata_t * confdata;
  run2_selfoptions_t * selfopt;
  run2_global_t * global;
  run2_env_t * env;
  run2_env_spec_t * envspec;
  run2_tgtopts_t * tgtopts;
  run2_tgt_spec_t * tgtspec;

  confdata = run2_confdata_create ();

  selfopt = run2_confdata_get_selfoptions (confdata);
  run2_selfoptions_add_arg (selfopt, USTR1 (\x9, "--debug=2"));
  run2_selfoptions_add_arg (selfopt, USTR1 (\x6, "--wait"));

  global = run2_confdata_get_global (confdata);
  env = run2_global_get_env (global);
  envspec = run2_env_get_var (env, USTR1 (\5, "RUN2a"));
  run2_env_spec_set (envspec, USTR1 (\3, "yes"));
  envspec = run2_env_get_var (env, USTR1 (\5, "RUN2b"));
  run2_env_spec_set (envspec, USTR1 (\5, "value"));
  run2_env_spec_prepend (envspec, USTR1 (\2, "a|"));
  run2_env_spec_prepend (envspec, USTR1 (\2, "b|"));
  run2_env_spec_append (envspec, USTR1 (\2, "|c"));
  run2_env_spec_append (envspec, USTR1 (\2, "|d"));
  envspec = run2_env_get_var (env, USTR1 (\4, "PATH"));
  run2_env_spec_set (envspec, USTR1 (\4, "/bin"));
  run2_env_spec_prepend (envspec, USTR1 (\xE, "/usr/local/bin"));
  run2_env_spec_prepend (envspec, USTR1 (\xE, "/home/user/bin"));
  run2_env_spec_append (envspec, USTR1 (\x9, "/usr/sbin"));
  run2_env_spec_append (envspec, USTR1 (\xC, "/usr/libexec"));

  tgtopts = run2_confdata_get_gdi (confdata);
  env = run2_tgtopts_get_env (tgtopts);
  envspec = run2_env_get_var (env, USTR1 (\4, "TERM"));
  run2_env_spec_prepend (envspec, USTR1 (\x12, "rxvt-cygwin-native"));
  tgtspec = run2_tgtopts_get_tgt (tgtopts);
  run2_tgt_spec_set_filename (tgtspec, USTR1 (\x11, "/usr/bin/rxvt.exe"));
  run2_tgt_spec_set_startin  (tgtspec, USTR1 (\1, "~"));
  run2_tgt_spec_add_arg (tgtspec, USTR1 (\xB, "-display :0"));
  run2_tgt_spec_add_arg (tgtspec, USTR1 (\x1C, "-fn \"DejaVu LGC Sans Mono\""));
  run2_tgt_spec_add_arg (tgtspec, USTR1 (\x16, "-tn rxvt-cygwin-native"));
  run2_tgt_spec_add_arg (tgtspec, USTR1 (\x14, "-e /bin/bash --login"));

  tgtopts = run2_confdata_get_x11 (confdata);
  env = run2_tgtopts_get_env (tgtopts);
  envspec = run2_env_get_var (env, USTR1 (\x4, "TERM"));
  run2_env_spec_prepend (envspec, USTR1 (\xC, "rxvt-unicode"));
  tgtspec = run2_tgtopts_get_tgt (tgtopts);
  run2_tgt_spec_set_filename (tgtspec, USTR1 (\x15, "/usr/bin/urxvtc-X.exe"));
  run2_tgt_spec_set_startin  (tgtspec, USTR1 (\1, "~"));
  run2_tgt_spec_add_arg (tgtspec, USTR1 (\x16, "-display 127.0.0.1:0.0"));
  run2_tgt_spec_add_arg (tgtspec, USTR1 (\3, "-ls"));
  run2_tgt_spec_add_arg (tgtspec, USTR1 (\x14, "-e /bin/bash --login"));

  return confdata;
}

void cleanup (run2_confdata_t * d)
{
  run2_confdata_delete (d);
}

int main (int argc, char * argv[])
{
  run2_set_program_name (argv[0]);
  run2_confdata_t * confdata;
  confdata = populate();
  run2_confdata_print (stderr, 0, USTR1 (\xA, "Run2Config"), confdata);
  cleanup (confdata);
  return 0;
}
