/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBKeyRange.h"

#include "ExceptionCode.h"
#include "IDBKeyRange.h"
#include "JSDOMBinding.h"
#include "JSIDBKeyRange.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSIDBKeyRangeTableValues[] =
{
    { "lower", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLower), (intptr_t)0, NoIntrinsic },
    { "upper", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeUpper), (intptr_t)0, NoIntrinsic },
    { "lowerOpen", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLowerOpen), (intptr_t)0, NoIntrinsic },
    { "upperOpen", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeUpperOpen), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBKeyRangeTable = { 16, 15, JSIDBKeyRangeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSIDBKeyRangeConstructorTableValues[] =
{
    { "only", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionOnly), (intptr_t)1, NoIntrinsic },
    { "lowerBound", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionLowerBound), (intptr_t)1, NoIntrinsic },
    { "upperBound", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionUpperBound), (intptr_t)1, NoIntrinsic },
    { "bound", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionBound), (intptr_t)2, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBKeyRangeConstructorTable = { 4, 0, JSIDBKeyRangeConstructorTableValues, 0 };
static const HashTable* getJSIDBKeyRangeConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBKeyRangeConstructorTable);
}

const ClassInfo JSIDBKeyRangeConstructor::s_info = { "IDBKeyRangeConstructor", &Base::s_info, 0, getJSIDBKeyRangeConstructorTable, CREATE_METHOD_TABLE(JSIDBKeyRangeConstructor) };

JSIDBKeyRangeConstructor::JSIDBKeyRangeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBKeyRangeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSIDBKeyRangePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSIDBKeyRangeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSIDBKeyRangeConstructor, JSDOMWrapper>(exec, getJSIDBKeyRangeConstructorTable(exec), jsCast<JSIDBKeyRangeConstructor*>(cell), propertyName, slot);
}

bool JSIDBKeyRangeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSIDBKeyRangeConstructor, JSDOMWrapper>(exec, getJSIDBKeyRangeConstructorTable(exec), jsCast<JSIDBKeyRangeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSIDBKeyRangePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBKeyRangePrototypeTable = { 8, 7, JSIDBKeyRangePrototypeTableValues, 0 };
static const HashTable* getJSIDBKeyRangePrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBKeyRangePrototypeTable);
}

const ClassInfo JSIDBKeyRangePrototype::s_info = { "IDBKeyRangePrototype", &Base::s_info, 0, getJSIDBKeyRangePrototypeTable, CREATE_METHOD_TABLE(JSIDBKeyRangePrototype) };

JSObject* JSIDBKeyRangePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBKeyRange>(exec, globalObject);
}

bool JSIDBKeyRangePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBKeyRangePrototype* thisObject = jsCast<JSIDBKeyRangePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSIDBKeyRangePrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSIDBKeyRangePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBKeyRangePrototype* thisObject = jsCast<JSIDBKeyRangePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSIDBKeyRangePrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSIDBKeyRangeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBKeyRangeTable);
}

const ClassInfo JSIDBKeyRange::s_info = { "IDBKeyRange", &Base::s_info, 0, getJSIDBKeyRangeTable , CREATE_METHOD_TABLE(JSIDBKeyRange) };

JSIDBKeyRange::JSIDBKeyRange(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBKeyRange> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSIDBKeyRange::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBKeyRange::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBKeyRangePrototype::create(exec->vm(), globalObject, JSIDBKeyRangePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSIDBKeyRange::destroy(JSC::JSCell* cell)
{
    JSIDBKeyRange* thisObject = static_cast<JSIDBKeyRange*>(cell);
    thisObject->JSIDBKeyRange::~JSIDBKeyRange();
}

JSIDBKeyRange::~JSIDBKeyRange()
{
    releaseImplIfNotNull();
}

bool JSIDBKeyRange::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBKeyRange* thisObject = jsCast<JSIDBKeyRange*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSIDBKeyRange, Base>(exec, getJSIDBKeyRangeTable(exec), thisObject, propertyName, slot);
}

bool JSIDBKeyRange::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBKeyRange* thisObject = jsCast<JSIDBKeyRange*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSIDBKeyRange, Base>(exec, getJSIDBKeyRangeTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsIDBKeyRangeLower(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBKeyRange* castedThis = jsCast<JSIDBKeyRange*>(asObject(slotBase));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return jsUndefined();
    IDBKeyRange* impl = static_cast<IDBKeyRange*>(castedThis->impl());
    JSValue result = (impl->lowerValue(scriptContext).hasNoValue() ? jsNull() : impl->lowerValue(scriptContext).jsValue());
    return result;
}


JSValue jsIDBKeyRangeUpper(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBKeyRange* castedThis = jsCast<JSIDBKeyRange*>(asObject(slotBase));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return jsUndefined();
    IDBKeyRange* impl = static_cast<IDBKeyRange*>(castedThis->impl());
    JSValue result = (impl->upperValue(scriptContext).hasNoValue() ? jsNull() : impl->upperValue(scriptContext).jsValue());
    return result;
}


JSValue jsIDBKeyRangeLowerOpen(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBKeyRange* castedThis = jsCast<JSIDBKeyRange*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBKeyRange* impl = static_cast<IDBKeyRange*>(castedThis->impl());
    JSValue result = jsBoolean(impl->lowerOpen());
    return result;
}


JSValue jsIDBKeyRangeUpperOpen(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBKeyRange* castedThis = jsCast<JSIDBKeyRange*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBKeyRange* impl = static_cast<IDBKeyRange*>(castedThis->impl());
    JSValue result = jsBoolean(impl->upperOpen());
    return result;
}


JSValue jsIDBKeyRangeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBKeyRange* domObject = jsCast<JSIDBKeyRange*>(asObject(slotBase));
    return JSIDBKeyRange::getConstructor(exec, domObject->globalObject());
}

JSValue JSIDBKeyRange::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBKeyRangeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionOnly(ExecState* exec)
{
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue value(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::only(scriptContext, value, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionLowerBound(ExecState* exec)
{
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue bound(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::lowerBound(scriptContext, bound, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool open(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::lowerBound(scriptContext, bound, open, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionUpperBound(ExecState* exec)
{
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue bound(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::upperBound(scriptContext, bound, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool open(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::upperBound(scriptContext, bound, open, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionBound(ExecState* exec)
{
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue lower(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    ScriptValue upper(exec->vm(), exec->argument(1));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {

        JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::bound(scriptContext, lower, upper, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool lowerOpen(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 3) {

        JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::bound(scriptContext, lower, upper, lowerOpen, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool upperOpen(exec->argument(3).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::bound(scriptContext, lower, upper, lowerOpen, upperOpen, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSIDBKeyRange* jsIDBKeyRange)
{
    if (jsIDBKeyRange->hasCustomProperties())
        return true;
    return false;
}

bool JSIDBKeyRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSIDBKeyRange* jsIDBKeyRange = jsCast<JSIDBKeyRange*>(handle.get().asCell());
    if (!isObservable(jsIDBKeyRange))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBKeyRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSIDBKeyRange* jsIDBKeyRange = jsCast<JSIDBKeyRange*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBKeyRange->impl(), jsIDBKeyRange);
    jsIDBKeyRange->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBKeyRange* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBKeyRange>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to IDBKeyRange.
    COMPILE_ASSERT(!__is_polymorphic(IDBKeyRange), IDBKeyRange_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<IDBKeyRange>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSIDBKeyRange>(exec, globalObject, impl);
}

IDBKeyRange* toIDBKeyRange(JSC::JSValue value)
{
    return value.inherits(&JSIDBKeyRange::s_info) ? jsCast<JSIDBKeyRange*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
