/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCounter.h"

#include "Counter.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCounterTableValues[] =
{
    { "identifier", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterIdentifier), (intptr_t)0, NoIntrinsic },
    { "listStyle", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterListStyle), (intptr_t)0, NoIntrinsic },
    { "separator", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterSeparator), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCounterTable = { 9, 7, JSCounterTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCounterConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCounterConstructorTable = { 1, 0, JSCounterConstructorTableValues, 0 };
const ClassInfo JSCounterConstructor::s_info = { "CounterConstructor", &Base::s_info, &JSCounterConstructorTable, 0, CREATE_METHOD_TABLE(JSCounterConstructor) };

JSCounterConstructor::JSCounterConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCounterConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSCounterPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSCounterConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCounterConstructor, JSDOMWrapper>(exec, &JSCounterConstructorTable, jsCast<JSCounterConstructor*>(cell), propertyName, slot);
}

bool JSCounterConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCounterConstructor, JSDOMWrapper>(exec, &JSCounterConstructorTable, jsCast<JSCounterConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCounterPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCounterPrototypeTable = { 1, 0, JSCounterPrototypeTableValues, 0 };
const ClassInfo JSCounterPrototype::s_info = { "CounterPrototype", &Base::s_info, &JSCounterPrototypeTable, 0, CREATE_METHOD_TABLE(JSCounterPrototype) };

JSObject* JSCounterPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCounter>(exec, globalObject);
}

const ClassInfo JSCounter::s_info = { "Counter", &Base::s_info, &JSCounterTable, 0 , CREATE_METHOD_TABLE(JSCounter) };

JSCounter::JSCounter(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Counter> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCounter::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCounter::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCounterPrototype::create(exec->vm(), globalObject, JSCounterPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSCounter::destroy(JSC::JSCell* cell)
{
    JSCounter* thisObject = static_cast<JSCounter*>(cell);
    thisObject->JSCounter::~JSCounter();
}

JSCounter::~JSCounter()
{
    releaseImplIfNotNull();
}

bool JSCounter::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCounter* thisObject = jsCast<JSCounter*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCounter, Base>(exec, &JSCounterTable, thisObject, propertyName, slot);
}

bool JSCounter::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCounter* thisObject = jsCast<JSCounter*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCounter, Base>(exec, &JSCounterTable, thisObject, propertyName, descriptor);
}

JSValue jsCounterIdentifier(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCounter* castedThis = jsCast<JSCounter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Counter* impl = static_cast<Counter*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->identifier());
    return result;
}


JSValue jsCounterListStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCounter* castedThis = jsCast<JSCounter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Counter* impl = static_cast<Counter*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->listStyle());
    return result;
}


JSValue jsCounterSeparator(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCounter* castedThis = jsCast<JSCounter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Counter* impl = static_cast<Counter*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->separator());
    return result;
}


JSValue jsCounterConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCounter* domObject = jsCast<JSCounter*>(asObject(slotBase));
    return JSCounter::getConstructor(exec, domObject->globalObject());
}

JSValue JSCounter::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCounterConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSCounter* jsCounter)
{
    if (jsCounter->hasCustomProperties())
        return true;
    return false;
}

bool JSCounterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSCounter* jsCounter = jsCast<JSCounter*>(handle.get().asCell());
    if (!isObservable(jsCounter))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSCounterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCounter* jsCounter = jsCast<JSCounter*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCounter->impl(), jsCounter);
    jsCounter->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Counter* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCounter>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Counter.
    COMPILE_ASSERT(!__is_polymorphic(Counter), Counter_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<Counter>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSCounter>(exec, globalObject, impl);
}

Counter* toCounter(JSC::JSValue value)
{
    return value.inherits(&JSCounter::s_info) ? jsCast<JSCounter*>(asObject(value))->impl() : 0;
}

}
