/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SHARED_WORKERS)

#include "JSSharedWorker.h"

#include "EventListener.h"
#include "JSEventListener.h"
#include "JSMessagePort.h"
#include "MessagePort.h"
#include "SharedWorker.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSharedWorkerTableValues[] =
{
    { "port", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSharedWorkerPort), (intptr_t)0, NoIntrinsic },
#if ENABLE(WORKERS)
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSharedWorkerOnerror), (intptr_t)setJSSharedWorkerOnerror, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSharedWorkerConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerTable = { 8, 7, JSSharedWorkerTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSharedWorkerConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerConstructorTable = { 1, 0, JSSharedWorkerConstructorTableValues, 0 };
const ClassInfo JSSharedWorkerConstructor::s_info = { "SharedWorkerConstructor", &Base::s_info, &JSSharedWorkerConstructorTable, 0, CREATE_METHOD_TABLE(JSSharedWorkerConstructor) };

JSSharedWorkerConstructor::JSSharedWorkerConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSharedWorkerConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSharedWorkerPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSSharedWorkerConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSharedWorkerConstructor, JSDOMWrapper>(exec, &JSSharedWorkerConstructorTable, jsCast<JSSharedWorkerConstructor*>(cell), propertyName, slot);
}

bool JSSharedWorkerConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSharedWorkerConstructor, JSDOMWrapper>(exec, &JSSharedWorkerConstructorTable, jsCast<JSSharedWorkerConstructor*>(object), propertyName, descriptor);
}

ConstructType JSSharedWorkerConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSSharedWorker;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSSharedWorkerPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerPrototypeTable = { 1, 0, JSSharedWorkerPrototypeTableValues, 0 };
const ClassInfo JSSharedWorkerPrototype::s_info = { "SharedWorkerPrototype", &Base::s_info, &JSSharedWorkerPrototypeTable, 0, CREATE_METHOD_TABLE(JSSharedWorkerPrototype) };

JSObject* JSSharedWorkerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSharedWorker>(exec, globalObject);
}

const ClassInfo JSSharedWorker::s_info = { "SharedWorker", &Base::s_info, &JSSharedWorkerTable, 0 , CREATE_METHOD_TABLE(JSSharedWorker) };

JSSharedWorker::JSSharedWorker(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SharedWorker> impl)
    : JSEventTarget(structure, globalObject, impl)
{
}

void JSSharedWorker::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSharedWorker::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSharedWorkerPrototype::create(exec->vm(), globalObject, JSSharedWorkerPrototype::createStructure(exec->vm(), globalObject, JSEventTargetPrototype::self(exec, globalObject)));
}

bool JSSharedWorker::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSharedWorker* thisObject = jsCast<JSSharedWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSharedWorker, Base>(exec, &JSSharedWorkerTable, thisObject, propertyName, slot);
}

bool JSSharedWorker::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSharedWorker* thisObject = jsCast<JSSharedWorker*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSharedWorker, Base>(exec, &JSSharedWorkerTable, thisObject, propertyName, descriptor);
}

JSValue jsSharedWorkerPort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSharedWorker* castedThis = jsCast<JSSharedWorker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SharedWorker* impl = static_cast<SharedWorker*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->port()));
    return result;
}


#if ENABLE(WORKERS)
JSValue jsSharedWorkerOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSharedWorker* castedThis = jsCast<JSSharedWorker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SharedWorker* impl = static_cast<SharedWorker*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

JSValue jsSharedWorkerConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSharedWorker* domObject = jsCast<JSSharedWorker*>(asObject(slotBase));
    return JSSharedWorker::getConstructor(exec, domObject->globalObject());
}

void JSSharedWorker::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSharedWorker* thisObject = jsCast<JSSharedWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSharedWorker, Base>(exec, propertyName, value, &JSSharedWorkerTable, thisObject, slot);
}

#if ENABLE(WORKERS)
void setJSSharedWorkerOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSharedWorker* castedThis = jsCast<JSSharedWorker*>(thisObject);
    SharedWorker* impl = static_cast<SharedWorker*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

JSValue JSSharedWorker::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSharedWorkerConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSharedWorker* jsSharedWorker)
{
    if (jsSharedWorker->hasCustomProperties())
        return true;
    if (jsSharedWorker->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSSharedWorkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSharedWorker* jsSharedWorker = jsCast<JSSharedWorker*>(handle.get().asCell());
    if (jsSharedWorker->impl()->hasPendingActivity())
        return true;
    if (jsSharedWorker->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsSharedWorker))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSharedWorkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSharedWorker* jsSharedWorker = jsCast<JSSharedWorker*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSharedWorker->impl(), jsSharedWorker);
    jsSharedWorker->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SharedWorker@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12SharedWorkerE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SharedWorker* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSharedWorker>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SharedWorker@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12SharedWorkerE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails SharedWorker does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SharedWorker), SharedWorker_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SharedWorker has subclasses. If SharedWorker has subclasses that get passed
    // to toJS() we currently require SharedWorker you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SharedWorker>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSharedWorker>(exec, globalObject, impl);
}

SharedWorker* toSharedWorker(JSC::JSValue value)
{
    return value.inherits(&JSSharedWorker::s_info) ? jsCast<JSSharedWorker*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SHARED_WORKERS)
