/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathSegMovetoAbs.h"

#include "SVGPathSegMovetoAbs.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPathSegMovetoAbsTableValues[] =
{
    { "x", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoAbsX), (intptr_t)setJSSVGPathSegMovetoAbsX, NoIntrinsic },
    { "y", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoAbsY), (intptr_t)setJSSVGPathSegMovetoAbsY, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoAbsConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegMovetoAbsTable = { 9, 7, JSSVGPathSegMovetoAbsTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPathSegMovetoAbsConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegMovetoAbsConstructorTable = { 1, 0, JSSVGPathSegMovetoAbsConstructorTableValues, 0 };
const ClassInfo JSSVGPathSegMovetoAbsConstructor::s_info = { "SVGPathSegMovetoAbsConstructor", &Base::s_info, &JSSVGPathSegMovetoAbsConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegMovetoAbsConstructor) };

JSSVGPathSegMovetoAbsConstructor::JSSVGPathSegMovetoAbsConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPathSegMovetoAbsConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPathSegMovetoAbsPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPathSegMovetoAbsConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegMovetoAbsConstructor, JSDOMWrapper>(exec, &JSSVGPathSegMovetoAbsConstructorTable, jsCast<JSSVGPathSegMovetoAbsConstructor*>(cell), propertyName, slot);
}

bool JSSVGPathSegMovetoAbsConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegMovetoAbsConstructor, JSDOMWrapper>(exec, &JSSVGPathSegMovetoAbsConstructorTable, jsCast<JSSVGPathSegMovetoAbsConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegMovetoAbsPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegMovetoAbsPrototypeTable = { 1, 0, JSSVGPathSegMovetoAbsPrototypeTableValues, 0 };
const ClassInfo JSSVGPathSegMovetoAbsPrototype::s_info = { "SVGPathSegMovetoAbsPrototype", &Base::s_info, &JSSVGPathSegMovetoAbsPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegMovetoAbsPrototype) };

JSObject* JSSVGPathSegMovetoAbsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegMovetoAbs>(exec, globalObject);
}

const ClassInfo JSSVGPathSegMovetoAbs::s_info = { "SVGPathSegMovetoAbs", &Base::s_info, &JSSVGPathSegMovetoAbsTable, 0 , CREATE_METHOD_TABLE(JSSVGPathSegMovetoAbs) };

JSSVGPathSegMovetoAbs::JSSVGPathSegMovetoAbs(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathSegMovetoAbs> impl)
    : JSSVGPathSeg(structure, globalObject, impl)
{
}

void JSSVGPathSegMovetoAbs::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPathSegMovetoAbs::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPathSegMovetoAbsPrototype::create(exec->vm(), globalObject, JSSVGPathSegMovetoAbsPrototype::createStructure(exec->vm(), globalObject, JSSVGPathSegPrototype::self(exec, globalObject)));
}

bool JSSVGPathSegMovetoAbs::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathSegMovetoAbs* thisObject = jsCast<JSSVGPathSegMovetoAbs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPathSegMovetoAbs, Base>(exec, &JSSVGPathSegMovetoAbsTable, thisObject, propertyName, slot);
}

bool JSSVGPathSegMovetoAbs::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathSegMovetoAbs* thisObject = jsCast<JSSVGPathSegMovetoAbs*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPathSegMovetoAbs, Base>(exec, &JSSVGPathSegMovetoAbsTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPathSegMovetoAbsX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegMovetoAbs* castedThis = jsCast<JSSVGPathSegMovetoAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegMovetoAbs* impl = static_cast<SVGPathSegMovetoAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->x());
    return result;
}


JSValue jsSVGPathSegMovetoAbsY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegMovetoAbs* castedThis = jsCast<JSSVGPathSegMovetoAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegMovetoAbs* impl = static_cast<SVGPathSegMovetoAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->y());
    return result;
}


JSValue jsSVGPathSegMovetoAbsConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegMovetoAbs* domObject = jsCast<JSSVGPathSegMovetoAbs*>(asObject(slotBase));
    return JSSVGPathSegMovetoAbs::getConstructor(exec, domObject->globalObject());
}

void JSSVGPathSegMovetoAbs::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPathSegMovetoAbs* thisObject = jsCast<JSSVGPathSegMovetoAbs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPathSegMovetoAbs, Base>(exec, propertyName, value, &JSSVGPathSegMovetoAbsTable, thisObject, slot);
}

void setJSSVGPathSegMovetoAbsX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegMovetoAbs* castedThis = jsCast<JSSVGPathSegMovetoAbs*>(thisObject);
    SVGPathSegMovetoAbs* impl = static_cast<SVGPathSegMovetoAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setX(nativeValue);
}


void setJSSVGPathSegMovetoAbsY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegMovetoAbs* castedThis = jsCast<JSSVGPathSegMovetoAbs*>(thisObject);
    SVGPathSegMovetoAbs* impl = static_cast<SVGPathSegMovetoAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setY(nativeValue);
}


JSValue JSSVGPathSegMovetoAbs::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegMovetoAbsConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
