/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGElementInstanceList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGElementInstance.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGElementInstanceListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementInstanceListTable = { 5, 3, JSSVGElementInstanceListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGElementInstanceListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementInstanceListConstructorTable = { 1, 0, JSSVGElementInstanceListConstructorTableValues, 0 };
const ClassInfo JSSVGElementInstanceListConstructor::s_info = { "SVGElementInstanceListConstructor", &Base::s_info, &JSSVGElementInstanceListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGElementInstanceListConstructor) };

JSSVGElementInstanceListConstructor::JSSVGElementInstanceListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGElementInstanceListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGElementInstanceListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGElementInstanceListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstanceListConstructor, JSDOMWrapper>(exec, &JSSVGElementInstanceListConstructorTable, jsCast<JSSVGElementInstanceListConstructor*>(cell), propertyName, slot);
}

bool JSSVGElementInstanceListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementInstanceListConstructor, JSDOMWrapper>(exec, &JSSVGElementInstanceListConstructorTable, jsCast<JSSVGElementInstanceListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGElementInstanceListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGElementInstanceListPrototypeFunctionItem), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementInstanceListPrototypeTable = { 2, 1, JSSVGElementInstanceListPrototypeTableValues, 0 };
const ClassInfo JSSVGElementInstanceListPrototype::s_info = { "SVGElementInstanceListPrototype", &Base::s_info, &JSSVGElementInstanceListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGElementInstanceListPrototype) };

JSObject* JSSVGElementInstanceListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElementInstanceList>(exec, globalObject);
}

bool JSSVGElementInstanceListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGElementInstanceListPrototype* thisObject = jsCast<JSSVGElementInstanceListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGElementInstanceListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGElementInstanceListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGElementInstanceListPrototype* thisObject = jsCast<JSSVGElementInstanceListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGElementInstanceListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGElementInstanceList::s_info = { "SVGElementInstanceList", &Base::s_info, &JSSVGElementInstanceListTable, 0 , CREATE_METHOD_TABLE(JSSVGElementInstanceList) };

JSSVGElementInstanceList::JSSVGElementInstanceList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGElementInstanceList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGElementInstanceList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGElementInstanceList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGElementInstanceListPrototype::create(exec->vm(), globalObject, JSSVGElementInstanceListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGElementInstanceList::destroy(JSC::JSCell* cell)
{
    JSSVGElementInstanceList* thisObject = static_cast<JSSVGElementInstanceList*>(cell);
    thisObject->JSSVGElementInstanceList::~JSSVGElementInstanceList();
}

JSSVGElementInstanceList::~JSSVGElementInstanceList()
{
    releaseImplIfNotNull();
}

bool JSSVGElementInstanceList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGElementInstanceList* thisObject = jsCast<JSSVGElementInstanceList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGElementInstanceList, Base>(exec, &JSSVGElementInstanceListTable, thisObject, propertyName, slot);
}

bool JSSVGElementInstanceList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGElementInstanceList* thisObject = jsCast<JSSVGElementInstanceList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGElementInstanceList, Base>(exec, &JSSVGElementInstanceListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGElementInstanceListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstanceList* castedThis = jsCast<JSSVGElementInstanceList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstanceList* impl = static_cast<SVGElementInstanceList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsSVGElementInstanceListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstanceList* domObject = jsCast<JSSVGElementInstanceList*>(asObject(slotBase));
    return JSSVGElementInstanceList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGElementInstanceList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGElementInstanceListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGElementInstanceListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGElementInstanceList::s_info))
        return throwVMTypeError(exec);
    JSSVGElementInstanceList* castedThis = jsCast<JSSVGElementInstanceList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGElementInstanceList::s_info);
    SVGElementInstanceList* impl = static_cast<SVGElementInstanceList*>(castedThis->impl());
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGElementInstanceList* jsSVGElementInstanceList)
{
    if (jsSVGElementInstanceList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGElementInstanceListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGElementInstanceList* jsSVGElementInstanceList = jsCast<JSSVGElementInstanceList*>(handle.get().asCell());
    if (!isObservable(jsSVGElementInstanceList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGElementInstanceListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGElementInstanceList* jsSVGElementInstanceList = jsCast<JSSVGElementInstanceList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGElementInstanceList->impl(), jsSVGElementInstanceList);
    jsSVGElementInstanceList->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGElementInstanceList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22SVGElementInstanceListE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGElementInstanceList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGElementInstanceList>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SVGElementInstanceList@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22SVGElementInstanceListE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails SVGElementInstanceList does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SVGElementInstanceList), SVGElementInstanceList_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SVGElementInstanceList has subclasses. If SVGElementInstanceList has subclasses that get passed
    // to toJS() we currently require SVGElementInstanceList you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SVGElementInstanceList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGElementInstanceList>(exec, globalObject, impl);
}

SVGElementInstanceList* toSVGElementInstanceList(JSC::JSValue value)
{
    return value.inherits(&JSSVGElementInstanceList::s_info) ? jsCast<JSSVGElementInstanceList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
