/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext.h"

#include "CanvasRenderingContext.h"
#include "HTMLCanvasElement.h"
#include "JSHTMLCanvasElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCanvasRenderingContextTableValues[] =
{
    { "canvas", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContextCanvas), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCanvasRenderingContextTable = { 2, 1, JSCanvasRenderingContextTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContextPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCanvasRenderingContextPrototypeTable = { 1, 0, JSCanvasRenderingContextPrototypeTableValues, 0 };
const ClassInfo JSCanvasRenderingContextPrototype::s_info = { "CanvasRenderingContextPrototype", &Base::s_info, &JSCanvasRenderingContextPrototypeTable, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContextPrototype) };

JSObject* JSCanvasRenderingContextPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext>(exec, globalObject);
}

const ClassInfo JSCanvasRenderingContext::s_info = { "CanvasRenderingContext", &Base::s_info, &JSCanvasRenderingContextTable, 0 , CREATE_METHOD_TABLE(JSCanvasRenderingContext) };

JSCanvasRenderingContext::JSCanvasRenderingContext(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasRenderingContext> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCanvasRenderingContext::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCanvasRenderingContext::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCanvasRenderingContextPrototype::create(exec->vm(), globalObject, JSCanvasRenderingContextPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSCanvasRenderingContext::destroy(JSC::JSCell* cell)
{
    JSCanvasRenderingContext* thisObject = static_cast<JSCanvasRenderingContext*>(cell);
    thisObject->JSCanvasRenderingContext::~JSCanvasRenderingContext();
}

JSCanvasRenderingContext::~JSCanvasRenderingContext()
{
    releaseImplIfNotNull();
}

bool JSCanvasRenderingContext::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCanvasRenderingContext* thisObject = jsCast<JSCanvasRenderingContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCanvasRenderingContext, Base>(exec, &JSCanvasRenderingContextTable, thisObject, propertyName, slot);
}

bool JSCanvasRenderingContext::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCanvasRenderingContext* thisObject = jsCast<JSCanvasRenderingContext*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCanvasRenderingContext, Base>(exec, &JSCanvasRenderingContextTable, thisObject, propertyName, descriptor);
}

JSValue jsCanvasRenderingContextCanvas(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext* castedThis = jsCast<JSCanvasRenderingContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext* impl = static_cast<CanvasRenderingContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->canvas()));
    return result;
}


static inline bool isObservable(JSCanvasRenderingContext* jsCanvasRenderingContext)
{
    if (jsCanvasRenderingContext->hasCustomProperties())
        return true;
    return false;
}

bool JSCanvasRenderingContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSCanvasRenderingContext* jsCanvasRenderingContext = jsCast<JSCanvasRenderingContext*>(handle.get().asCell());
    if (!isObservable(jsCanvasRenderingContext))
        return false;
    void* root = WebCore::root(jsCanvasRenderingContext->impl()->canvas());
    return visitor.containsOpaqueRoot(root);
}

void JSCanvasRenderingContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCanvasRenderingContext* jsCanvasRenderingContext = jsCast<JSCanvasRenderingContext*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCanvasRenderingContext->impl(), jsCanvasRenderingContext);
    jsCanvasRenderingContext->releaseImpl();
}

CanvasRenderingContext* toCanvasRenderingContext(JSC::JSValue value)
{
    return value.inherits(&JSCanvasRenderingContext::s_info) ? jsCast<JSCanvasRenderingContext*>(asObject(value))->impl() : 0;
}

}
