/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTextPathElement.h"

#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "SVGTextPathElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedString.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTextPathElementTableValues[] =
{
    { "startOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementStartOffset), (intptr_t)0, NoIntrinsic },
    { "method", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementMethod), (intptr_t)0, NoIntrinsic },
    { "spacing", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementSpacing), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementHref), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextPathElementTable = { 16, 15, JSSVGTextPathElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGTextPathElementConstructorTableValues[] =
{
    { "TEXTPATH_METHODTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_METHODTYPE_ALIGN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_METHODTYPE_STRETCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_SPACINGTYPE_AUTO", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_SPACINGTYPE_EXACT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextPathElementConstructorTable = { 18, 15, JSSVGTextPathElementConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGTextPathElement::TEXTPATH_METHODTYPE_UNKNOWN, SVGTextPathElementEnumTEXTPATH_METHODTYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGTextPathElement::TEXTPATH_METHODTYPE_ALIGN, SVGTextPathElementEnumTEXTPATH_METHODTYPE_ALIGNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGTextPathElement::TEXTPATH_METHODTYPE_STRETCH, SVGTextPathElementEnumTEXTPATH_METHODTYPE_STRETCHIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == SVGTextPathElement::TEXTPATH_SPACINGTYPE_UNKNOWN, SVGTextPathElementEnumTEXTPATH_SPACINGTYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGTextPathElement::TEXTPATH_SPACINGTYPE_AUTO, SVGTextPathElementEnumTEXTPATH_SPACINGTYPE_AUTOIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGTextPathElement::TEXTPATH_SPACINGTYPE_EXACT, SVGTextPathElementEnumTEXTPATH_SPACINGTYPE_EXACTIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGTextPathElementConstructor::s_info = { "SVGTextPathElementConstructor", &Base::s_info, &JSSVGTextPathElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGTextPathElementConstructor) };

JSSVGTextPathElementConstructor::JSSVGTextPathElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTextPathElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGTextPathElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGTextPathElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextPathElementConstructor, JSDOMWrapper>(exec, &JSSVGTextPathElementConstructorTable, jsCast<JSSVGTextPathElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGTextPathElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextPathElementConstructor, JSDOMWrapper>(exec, &JSSVGTextPathElementConstructorTable, jsCast<JSSVGTextPathElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTextPathElementPrototypeTableValues[] =
{
    { "TEXTPATH_METHODTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_METHODTYPE_ALIGN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_METHODTYPE_STRETCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_SPACINGTYPE_AUTO", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO), (intptr_t)0, NoIntrinsic },
    { "TEXTPATH_SPACINGTYPE_EXACT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextPathElementPrototypeTable = { 18, 15, JSSVGTextPathElementPrototypeTableValues, 0 };
const ClassInfo JSSVGTextPathElementPrototype::s_info = { "SVGTextPathElementPrototype", &Base::s_info, &JSSVGTextPathElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTextPathElementPrototype) };

JSObject* JSSVGTextPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTextPathElement>(exec, globalObject);
}

bool JSSVGTextPathElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTextPathElementPrototype* thisObject = jsCast<JSSVGTextPathElementPrototype*>(cell);
    return getStaticValueSlot<JSSVGTextPathElementPrototype, JSObject>(exec, &JSSVGTextPathElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGTextPathElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTextPathElementPrototype* thisObject = jsCast<JSSVGTextPathElementPrototype*>(object);
    return getStaticValueDescriptor<JSSVGTextPathElementPrototype, JSObject>(exec, &JSSVGTextPathElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGTextPathElement::s_info = { "SVGTextPathElement", &Base::s_info, &JSSVGTextPathElementTable, 0 , CREATE_METHOD_TABLE(JSSVGTextPathElement) };

JSSVGTextPathElement::JSSVGTextPathElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTextPathElement> impl)
    : JSSVGTextContentElement(structure, globalObject, impl)
{
}

void JSSVGTextPathElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTextPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTextPathElementPrototype::create(exec->vm(), globalObject, JSSVGTextPathElementPrototype::createStructure(exec->vm(), globalObject, JSSVGTextContentElementPrototype::self(exec, globalObject)));
}

bool JSSVGTextPathElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTextPathElement* thisObject = jsCast<JSSVGTextPathElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTextPathElement, Base>(exec, &JSSVGTextPathElementTable, thisObject, propertyName, slot);
}

bool JSSVGTextPathElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTextPathElement* thisObject = jsCast<JSSVGTextPathElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTextPathElement, Base>(exec, &JSSVGTextPathElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTextPathElementStartOffset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPathElement* castedThis = jsCast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* impl = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->startOffsetAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPathElementMethod(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPathElement* castedThis = jsCast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* impl = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->methodAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPathElementSpacing(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPathElement* castedThis = jsCast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* impl = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->spacingAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGTextPathElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPathElement* castedThis = jsCast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* impl = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGTextPathElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPathElement* domObject = jsCast<JSSVGTextPathElement*>(asObject(slotBase));
    return JSSVGTextPathElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGTextPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextPathElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}


}

#endif // ENABLE(SVG)
