/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGDefsElement.h"

#include "SVGDefsElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGDefsElementTableValues[] =
{
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDefsElementTable = { 5, 3, JSSVGDefsElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGDefsElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDefsElementConstructorTable = { 1, 0, JSSVGDefsElementConstructorTableValues, 0 };
const ClassInfo JSSVGDefsElementConstructor::s_info = { "SVGDefsElementConstructor", &Base::s_info, &JSSVGDefsElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGDefsElementConstructor) };

JSSVGDefsElementConstructor::JSSVGDefsElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGDefsElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGDefsElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGDefsElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGDefsElementConstructor, JSDOMWrapper>(exec, &JSSVGDefsElementConstructorTable, jsCast<JSSVGDefsElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGDefsElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGDefsElementConstructor, JSDOMWrapper>(exec, &JSSVGDefsElementConstructorTable, jsCast<JSSVGDefsElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGDefsElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDefsElementPrototypeTable = { 1, 0, JSSVGDefsElementPrototypeTableValues, 0 };
const ClassInfo JSSVGDefsElementPrototype::s_info = { "SVGDefsElementPrototype", &Base::s_info, &JSSVGDefsElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGDefsElementPrototype) };

JSObject* JSSVGDefsElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGDefsElement>(exec, globalObject);
}

const ClassInfo JSSVGDefsElement::s_info = { "SVGDefsElement", &Base::s_info, &JSSVGDefsElementTable, 0 , CREATE_METHOD_TABLE(JSSVGDefsElement) };

JSSVGDefsElement::JSSVGDefsElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGDefsElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGDefsElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGDefsElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGDefsElementPrototype::create(exec->vm(), globalObject, JSSVGDefsElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGDefsElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGDefsElement* thisObject = jsCast<JSSVGDefsElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGDefsElement, Base>(exec, &JSSVGDefsElementTable, thisObject, propertyName, slot);
}

bool JSSVGDefsElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGDefsElement* thisObject = jsCast<JSSVGDefsElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGDefsElement, Base>(exec, &JSSVGDefsElementTable, thisObject, propertyName, descriptor);
}

#if ENABLE(SVG)
JSValue jsSVGDefsElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGDefsElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* domObject = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    return JSSVGDefsElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGDefsElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGDefsElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
