/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/mousestate.h>

        #include <wx/gdicmn.h>


PyDoc_STRVAR(doc_wxMouseState_GetPosition, "GetPosition() -> Point\n"
"\n"
"Returns the physical mouse position.");

extern "C" {static PyObject *meth_wxMouseState_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint(sipCpp->GetPosition());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_GetX, "GetX() -> Coord\n"
"\n"
"Returns X coordinate of the physical mouse event position.");

extern "C" {static PyObject *meth_wxMouseState_GetX(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_GetX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_GetX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_GetY, "GetY() -> Coord\n"
"\n"
"Returns Y coordinate of the physical mouse event position.");

extern "C" {static PyObject *meth_wxMouseState_GetY(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_GetY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_GetY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_LeftIsDown, "LeftIsDown() -> bool\n"
"\n"
"Returns true if the left mouse button is currently down.");

extern "C" {static PyObject *meth_wxMouseState_LeftIsDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_LeftIsDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LeftIsDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_LeftIsDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_MiddleIsDown, "MiddleIsDown() -> bool\n"
"\n"
"Returns true if the middle mouse button is currently down.");

extern "C" {static PyObject *meth_wxMouseState_MiddleIsDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_MiddleIsDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MiddleIsDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_MiddleIsDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_RightIsDown, "RightIsDown() -> bool\n"
"\n"
"Returns true if the right mouse button is currently down.");

extern "C" {static PyObject *meth_wxMouseState_RightIsDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_RightIsDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RightIsDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_RightIsDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_Aux1IsDown, "Aux1IsDown() -> bool\n"
"\n"
"Returns true if the first extra button mouse button is currently down.");

extern "C" {static PyObject *meth_wxMouseState_Aux1IsDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_Aux1IsDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux1IsDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_Aux1IsDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_Aux2IsDown, "Aux2IsDown() -> bool\n"
"\n"
"Returns true if the second extra button mouse button is currently\n"
"down.");

extern "C" {static PyObject *meth_wxMouseState_Aux2IsDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_Aux2IsDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux2IsDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_Aux2IsDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetX, "SetX(x)");

extern "C" {static PyObject *meth_wxMouseState_SetX(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetX(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCoord x;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxMouseState, &sipCpp, &x))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetX(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetY, "SetY(y)");

extern "C" {static PyObject *meth_wxMouseState_SetY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetY(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCoord y;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxMouseState, &sipCpp, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetY(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetPosition, "SetPosition(pos)");

extern "C" {static PyObject *meth_wxMouseState_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPoint* pos;
        int posState = 0;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMouseState, &sipCpp, sipType_wxPoint, &pos, &posState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetLeftDown, "SetLeftDown(down)");

extern "C" {static PyObject *meth_wxMouseState_SetLeftDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetLeftDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxMouseState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLeftDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetLeftDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetMiddleDown, "SetMiddleDown(down)");

extern "C" {static PyObject *meth_wxMouseState_SetMiddleDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetMiddleDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxMouseState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMiddleDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetMiddleDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetRightDown, "SetRightDown(down)");

extern "C" {static PyObject *meth_wxMouseState_SetRightDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetRightDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxMouseState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRightDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetRightDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetAux1Down, "SetAux1Down(down)");

extern "C" {static PyObject *meth_wxMouseState_SetAux1Down(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetAux1Down(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxMouseState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAux1Down(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetAux1Down, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetAux2Down, "SetAux2Down(down)");

extern "C" {static PyObject *meth_wxMouseState_SetAux2Down(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetAux2Down(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxMouseState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAux2Down(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetAux2Down, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseState_SetState, "SetState(state)");

extern "C" {static PyObject *meth_wxMouseState_SetState(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseState_SetState(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseState* state;
         ::wxMouseState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_state,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxMouseState, &sipCpp, sipType_wxMouseState, &state))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetState(*state);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MouseState, sipName_SetState, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxMouseState(void *, const sipTypeDef *);}
static void *cast_wxMouseState(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxMouseState *sipCpp = reinterpret_cast< ::wxMouseState *>(sipCppV);

    if (targetType == sipType_wxKeyboardState)
        return static_cast< ::wxKeyboardState *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxMouseState(void *, int);}
static void release_wxMouseState(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxMouseState *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxMouseState(Py_ssize_t);}
static void *array_wxMouseState(Py_ssize_t sipNrElem)
{
    return new  ::wxMouseState[sipNrElem];
}


extern "C" {static void assign_wxMouseState(void *, SIP_SSIZE_T, void *);}
static void assign_wxMouseState(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxMouseState *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxMouseState *>(sipSrc);
}


extern "C" {static void *copy_wxMouseState(const void *, SIP_SSIZE_T);}
static void *copy_wxMouseState(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxMouseState(reinterpret_cast<const  ::wxMouseState *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxMouseState(sipSimpleWrapper *);}
static void dealloc_wxMouseState(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxMouseState(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxMouseState(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxMouseState(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxMouseState *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxMouseState();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxMouseState* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxMouseState, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxMouseState(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxMouseState[] = {{290, 255, 1}};


static PyMethodDef methods_wxMouseState[] = {
    {SIP_MLNAME_CAST(sipName_Aux1IsDown), meth_wxMouseState_Aux1IsDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_Aux1IsDown)},
    {SIP_MLNAME_CAST(sipName_Aux2IsDown), meth_wxMouseState_Aux2IsDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_Aux2IsDown)},
    {SIP_MLNAME_CAST(sipName_GetPosition), meth_wxMouseState_GetPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_GetPosition)},
    {SIP_MLNAME_CAST(sipName_GetX), meth_wxMouseState_GetX, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_GetX)},
    {SIP_MLNAME_CAST(sipName_GetY), meth_wxMouseState_GetY, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_GetY)},
    {SIP_MLNAME_CAST(sipName_LeftIsDown), meth_wxMouseState_LeftIsDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_LeftIsDown)},
    {SIP_MLNAME_CAST(sipName_MiddleIsDown), meth_wxMouseState_MiddleIsDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_MiddleIsDown)},
    {SIP_MLNAME_CAST(sipName_RightIsDown), meth_wxMouseState_RightIsDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseState_RightIsDown)},
    {SIP_MLNAME_CAST(sipName_SetAux1Down), SIP_MLMETH_CAST(meth_wxMouseState_SetAux1Down), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetAux1Down)},
    {SIP_MLNAME_CAST(sipName_SetAux2Down), SIP_MLMETH_CAST(meth_wxMouseState_SetAux2Down), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetAux2Down)},
    {SIP_MLNAME_CAST(sipName_SetLeftDown), SIP_MLMETH_CAST(meth_wxMouseState_SetLeftDown), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetLeftDown)},
    {SIP_MLNAME_CAST(sipName_SetMiddleDown), SIP_MLMETH_CAST(meth_wxMouseState_SetMiddleDown), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetMiddleDown)},
    {SIP_MLNAME_CAST(sipName_SetPosition), SIP_MLMETH_CAST(meth_wxMouseState_SetPosition), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetPosition)},
    {SIP_MLNAME_CAST(sipName_SetRightDown), SIP_MLMETH_CAST(meth_wxMouseState_SetRightDown), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetRightDown)},
    {SIP_MLNAME_CAST(sipName_SetState), SIP_MLMETH_CAST(meth_wxMouseState_SetState), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetState)},
    {SIP_MLNAME_CAST(sipName_SetX), SIP_MLMETH_CAST(meth_wxMouseState_SetX), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetX)},
    {SIP_MLNAME_CAST(sipName_SetY), SIP_MLMETH_CAST(meth_wxMouseState_SetY), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseState_SetY)}
};

sipVariableDef variables_wxMouseState[] = {
    {PropertyVariable, sipName_Position, &methods_wxMouseState[2], &methods_wxMouseState[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_aux2IsDown, &methods_wxMouseState[1], &methods_wxMouseState[9], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_aux1IsDown, &methods_wxMouseState[0], &methods_wxMouseState[8], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_rightIsDown, &methods_wxMouseState[7], &methods_wxMouseState[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_middleIsDown, &methods_wxMouseState[6], &methods_wxMouseState[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_leftIsDown, &methods_wxMouseState[5], &methods_wxMouseState[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Y, &methods_wxMouseState[4], &methods_wxMouseState[16], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_X, &methods_wxMouseState[3], &methods_wxMouseState[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_y, &methods_wxMouseState[4], &methods_wxMouseState[16], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_x, &methods_wxMouseState[3], &methods_wxMouseState[15], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxMouseState, "MouseState()\n"
"\n"
"Represents the mouse state.");


sipClassTypeDef sipTypeDef__core_wxMouseState = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxMouseState,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_MouseState,
        {0, 0, 1},
        17, methods_wxMouseState,
        0, SIP_NULLPTR,
        10, variables_wxMouseState,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxMouseState,
    -1,
    -1,
    supers_wxMouseState,
    SIP_NULLPTR,
    init_type_wxMouseState,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxMouseState,
    assign_wxMouseState,
    array_wxMouseState,
    copy_wxMouseState,
    release_wxMouseState,
    cast_wxMouseState,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
