/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* DAG Instruction Selector for the NVPTX target                              *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// *** NOTE: This file is #included into the middle of the target
// *** instruction selector class.  These functions are really methods.

// The main instruction selector code.
void SelectCode(SDNode *N) {
  // Some target values are emitted as 2 bytes, TARGET_VAL handles
  // this.
  #define TARGET_VAL(X) X & 255, unsigned(X) >> 8
  static const unsigned char MatcherTable[] = {
/*0*/       OPC_SwitchOpcode /*112 cases */, 27|128,49/*6299*/, TARGET_VAL(ISD::INTRINSIC_WO_CHAIN),// ->6304
/*5*/         OPC_Scope, 97, /*->104*/ // 335 children in Scope
/*7*/           OPC_CheckChild0Integer, 82|128,25/*3282*/, 
/*10*/          OPC_Scope, 39, /*->51*/ // 2 children in Scope
/*12*/            OPC_MoveChild1,
/*13*/            OPC_CheckOpcode, TARGET_VAL(ISD::INTRINSIC_WO_CHAIN),
/*16*/            OPC_CheckChild0Integer, 86|128,25/*3286*/, 
/*19*/            OPC_MoveChild1,
/*20*/            OPC_CheckOpcode, TARGET_VAL(NVPTXISD::MoveParam),
/*23*/            OPC_RecordChild0, // #0 = $src
/*24*/            OPC_MoveChild0,
/*25*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*28*/            OPC_MoveParent,
/*29*/            OPC_MoveParent,
/*30*/            OPC_MoveParent,
/*31*/            OPC_SwitchType /*2 cases */, 7, MVT::i64,// ->41
/*34*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_ptr64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3282:iPTR, (intrinsic_wo_chain:iPTRAny 3286:iPTR, (MoveParam:iPTRAny (texternalsym:iPTR):$src))) - Complexity = 22
                    // Dst: (nvvm_move_ptr64:i64 (texternalsym:i64):$src)
/*41*/            /*SwitchType*/ 7, MVT::i32,// ->50
/*43*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_ptr32), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3282:iPTR, (intrinsic_wo_chain:iPTRAny 3286:iPTR, (MoveParam:iPTRAny (texternalsym:iPTR):$src))) - Complexity = 22
                    // Dst: (nvvm_move_ptr32:i32 (texternalsym:i32):$src)
/*50*/            0, // EndSwitchType
/*51*/          /*Scope*/ 51, /*->103*/
/*52*/            OPC_RecordChild1, // #0 = $src
/*53*/            OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->78
/*56*/              OPC_CheckChild1Type, MVT::i32,
/*58*/              OPC_Scope, 9, /*->69*/ // 2 children in Scope
/*60*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*62*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_local_yes), 0,
                          MVT::i32, 1/*#Ops*/, 0, 
                      // Src: (intrinsic_wo_chain:i32 3282:iPTR, Int32Regs:i32:$src) - Complexity = 8
                      // Dst: (cvta_to_local_yes:i32 Int32Regs:i32:$src)
/*69*/              /*Scope*/ 7, /*->77*/
/*70*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_local_no), 0,
                          MVT::i32, 1/*#Ops*/, 0, 
                      // Src: (intrinsic_wo_chain:i32 3282:iPTR, Int32Regs:i32:$src) - Complexity = 8
                      // Dst: (cvta_to_local_no:i32 Int32Regs:i32:$src)
/*77*/              0, /*End of Scope*/
/*78*/            /*SwitchType*/ 22, MVT::i64,// ->102
/*80*/              OPC_CheckChild1Type, MVT::i64,
/*82*/              OPC_Scope, 9, /*->93*/ // 2 children in Scope
/*84*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*86*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_local_yes_64), 0,
                          MVT::i64, 1/*#Ops*/, 0, 
                      // Src: (intrinsic_wo_chain:i64 3282:iPTR, Int64Regs:i64:$src) - Complexity = 8
                      // Dst: (cvta_to_local_yes_64:i64 Int64Regs:i64:$src)
/*93*/              /*Scope*/ 7, /*->101*/
/*94*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_local_no_64), 0,
                          MVT::i64, 1/*#Ops*/, 0, 
                      // Src: (intrinsic_wo_chain:i64 3282:iPTR, Int64Regs:i64:$src) - Complexity = 8
                      // Dst: (cvta_to_local_no_64:i64 Int64Regs:i64:$src)
/*101*/             0, /*End of Scope*/
/*102*/           0, // EndSwitchType
/*103*/         0, /*End of Scope*/
/*104*/       /*Scope*/ 78, /*->183*/
/*105*/         OPC_CheckChild0Integer, 57|128,26/*3385*/, 
/*108*/         OPC_RecordChild1, // #0 = $src
/*109*/         OPC_RecordChild2, // #1 = $offset
/*110*/         OPC_Scope, 39, /*->151*/ // 2 children in Scope
/*112*/           OPC_MoveChild2,
/*113*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*116*/           OPC_MoveParent,
/*117*/           OPC_RecordChild3, // #2 = $mask
/*118*/           OPC_Scope, 18, /*->138*/ // 2 children in Scope
/*120*/             OPC_MoveChild3,
/*121*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*124*/             OPC_MoveParent,
/*125*/             OPC_EmitConvertToTarget, 1,
/*127*/             OPC_EmitConvertToTarget, 2,
/*129*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_I32imm3), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:i32 3385:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_DOWN_I32imm3:i32 Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*138*/           /*Scope*/ 11, /*->150*/
/*139*/             OPC_EmitConvertToTarget, 1,
/*141*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_I32imm1), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:i32 3385:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_DOWN_I32imm1:i32 Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*150*/           0, /*End of Scope*/
/*151*/         /*Scope*/ 30, /*->182*/
/*152*/           OPC_RecordChild3, // #2 = $mask
/*153*/           OPC_Scope, 16, /*->171*/ // 2 children in Scope
/*155*/             OPC_MoveChild3,
/*156*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*159*/             OPC_MoveParent,
/*160*/             OPC_EmitConvertToTarget, 2,
/*162*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_I32imm2), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:i32 3385:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_DOWN_I32imm2:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*171*/           /*Scope*/ 9, /*->181*/
/*172*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_I32reg), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:i32 3385:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_DOWN_I32reg:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*181*/           0, /*End of Scope*/
/*182*/         0, /*End of Scope*/
/*183*/       /*Scope*/ 78, /*->262*/
/*184*/         OPC_CheckChild0Integer, 61|128,26/*3389*/, 
/*187*/         OPC_RecordChild1, // #0 = $src
/*188*/         OPC_RecordChild2, // #1 = $offset
/*189*/         OPC_Scope, 39, /*->230*/ // 2 children in Scope
/*191*/           OPC_MoveChild2,
/*192*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*195*/           OPC_MoveParent,
/*196*/           OPC_RecordChild3, // #2 = $mask
/*197*/           OPC_Scope, 18, /*->217*/ // 2 children in Scope
/*199*/             OPC_MoveChild3,
/*200*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*203*/             OPC_MoveParent,
/*204*/             OPC_EmitConvertToTarget, 1,
/*206*/             OPC_EmitConvertToTarget, 2,
/*208*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_I32imm3), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:i32 3389:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_UP_I32imm3:i32 Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*217*/           /*Scope*/ 11, /*->229*/
/*218*/             OPC_EmitConvertToTarget, 1,
/*220*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_I32imm1), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:i32 3389:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_UP_I32imm1:i32 Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*229*/           0, /*End of Scope*/
/*230*/         /*Scope*/ 30, /*->261*/
/*231*/           OPC_RecordChild3, // #2 = $mask
/*232*/           OPC_Scope, 16, /*->250*/ // 2 children in Scope
/*234*/             OPC_MoveChild3,
/*235*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*238*/             OPC_MoveParent,
/*239*/             OPC_EmitConvertToTarget, 2,
/*241*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_I32imm2), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:i32 3389:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_UP_I32imm2:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*250*/           /*Scope*/ 9, /*->260*/
/*251*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_I32reg), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:i32 3389:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_UP_I32reg:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*260*/           0, /*End of Scope*/
/*261*/         0, /*End of Scope*/
/*262*/       /*Scope*/ 78, /*->341*/
/*263*/         OPC_CheckChild0Integer, 55|128,26/*3383*/, 
/*266*/         OPC_RecordChild1, // #0 = $src
/*267*/         OPC_RecordChild2, // #1 = $offset
/*268*/         OPC_Scope, 39, /*->309*/ // 2 children in Scope
/*270*/           OPC_MoveChild2,
/*271*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*274*/           OPC_MoveParent,
/*275*/           OPC_RecordChild3, // #2 = $mask
/*276*/           OPC_Scope, 18, /*->296*/ // 2 children in Scope
/*278*/             OPC_MoveChild3,
/*279*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*282*/             OPC_MoveParent,
/*283*/             OPC_EmitConvertToTarget, 1,
/*285*/             OPC_EmitConvertToTarget, 2,
/*287*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_I32imm3), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:i32 3383:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_BFLY_I32imm3:i32 Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*296*/           /*Scope*/ 11, /*->308*/
/*297*/             OPC_EmitConvertToTarget, 1,
/*299*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_I32imm1), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:i32 3383:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_BFLY_I32imm1:i32 Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*308*/           0, /*End of Scope*/
/*309*/         /*Scope*/ 30, /*->340*/
/*310*/           OPC_RecordChild3, // #2 = $mask
/*311*/           OPC_Scope, 16, /*->329*/ // 2 children in Scope
/*313*/             OPC_MoveChild3,
/*314*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*317*/             OPC_MoveParent,
/*318*/             OPC_EmitConvertToTarget, 2,
/*320*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_I32imm2), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:i32 3383:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_BFLY_I32imm2:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*329*/           /*Scope*/ 9, /*->339*/
/*330*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_I32reg), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:i32 3383:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_BFLY_I32reg:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*339*/           0, /*End of Scope*/
/*340*/         0, /*End of Scope*/
/*341*/       /*Scope*/ 78, /*->420*/
/*342*/         OPC_CheckChild0Integer, 59|128,26/*3387*/, 
/*345*/         OPC_RecordChild1, // #0 = $src
/*346*/         OPC_RecordChild2, // #1 = $offset
/*347*/         OPC_Scope, 39, /*->388*/ // 2 children in Scope
/*349*/           OPC_MoveChild2,
/*350*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*353*/           OPC_MoveParent,
/*354*/           OPC_RecordChild3, // #2 = $mask
/*355*/           OPC_Scope, 18, /*->375*/ // 2 children in Scope
/*357*/             OPC_MoveChild3,
/*358*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*361*/             OPC_MoveParent,
/*362*/             OPC_EmitConvertToTarget, 1,
/*364*/             OPC_EmitConvertToTarget, 2,
/*366*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_I32imm3), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:i32 3387:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_IDX_I32imm3:i32 Int32Regs:i32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*375*/           /*Scope*/ 11, /*->387*/
/*376*/             OPC_EmitConvertToTarget, 1,
/*378*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_I32imm1), 0,
                        MVT::i32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:i32 3387:iPTR, Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_IDX_I32imm1:i32 Int32Regs:i32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*387*/           0, /*End of Scope*/
/*388*/         /*Scope*/ 30, /*->419*/
/*389*/           OPC_RecordChild3, // #2 = $mask
/*390*/           OPC_Scope, 16, /*->408*/ // 2 children in Scope
/*392*/             OPC_MoveChild3,
/*393*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*396*/             OPC_MoveParent,
/*397*/             OPC_EmitConvertToTarget, 2,
/*399*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_I32imm2), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:i32 3387:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_IDX_I32imm2:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*408*/           /*Scope*/ 9, /*->418*/
/*409*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_I32reg), 0,
                        MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:i32 3387:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_IDX_I32reg:i32 Int32Regs:i32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*418*/           0, /*End of Scope*/
/*419*/         0, /*End of Scope*/
/*420*/       /*Scope*/ 67, /*->488*/
/*421*/         OPC_CheckChild0Integer, 40|128,26/*3368*/, 
/*424*/         OPC_RecordChild1, // #0 = $src
/*425*/         OPC_RecordChild2, // #1 = $amt
/*426*/         OPC_Scope, 37, /*->465*/ // 3 children in Scope
/*428*/           OPC_MoveChild2,
/*429*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*432*/           OPC_MoveParent,
/*433*/           OPC_Scope, 12, /*->447*/ // 2 children in Scope
/*435*/             OPC_CheckPatternPredicate, 1, // (Subtarget->hasHWROT32())
/*437*/             OPC_EmitConvertToTarget, 1,
/*439*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROTATE_B32_HW_IMM), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (intrinsic_wo_chain:i32 3368:iPTR, Int32Regs:i32:$src, (imm:i32):$amt) - Complexity = 11
                    // Dst: (ROTATE_B32_HW_IMM:i32 Int32Regs:i32:$src, (imm:i32):$amt)
/*447*/           /*Scope*/ 16, /*->464*/
/*448*/             OPC_CheckPatternPredicate, 2, // (!Subtarget->hasHWROT32())
/*450*/             OPC_EmitConvertToTarget, 1,
/*452*/             OPC_EmitNodeXForm, 0, 1, // SUB_FRM_32
/*455*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROT32imm_sw), 0,
                        MVT::i32, 3/*#Ops*/, 0, 2, 3, 
                    // Src: (intrinsic_wo_chain:i32 3368:iPTR, Int32Regs:i32:$src, (imm:i32):$amt) - Complexity = 11
                    // Dst: (ROT32imm_sw:i32 Int32Regs:i32:$src, (imm:i32):$amt, (SUB_FRM_32:i32 node:i32:$amt))
/*464*/           0, /*End of Scope*/
/*465*/         /*Scope*/ 10, /*->476*/
/*466*/           OPC_CheckPatternPredicate, 1, // (Subtarget->hasHWROT32())
/*468*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROTATE_B32_HW_REG), 0,
                      MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (intrinsic_wo_chain:i32 3368:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$amt) - Complexity = 8
                  // Dst: (ROTATE_B32_HW_REG:i32 Int32Regs:i32:$src, Int32Regs:i32:$amt)
/*476*/         /*Scope*/ 10, /*->487*/
/*477*/           OPC_CheckPatternPredicate, 2, // (!Subtarget->hasHWROT32())
/*479*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROTL32reg_sw), 0,
                      MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (intrinsic_wo_chain:i32 3368:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$amt) - Complexity = 8
                  // Dst: (ROTL32reg_sw:i32 Int32Regs:i32:$src, Int32Regs:i32:$amt)
/*487*/         0, /*End of Scope*/
/*488*/       /*Scope*/ 33|128,1/*161*/, /*->651*/
/*490*/         OPC_CheckChild0Integer, 41|128,26/*3369*/, 
/*493*/         OPC_RecordChild1, // #0 = $src
/*494*/         OPC_RecordChild2, // #1 = $amt
/*495*/         OPC_Scope, 85, /*->582*/ // 3 children in Scope
/*497*/           OPC_MoveChild2,
/*498*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*501*/           OPC_MoveParent,
/*502*/           OPC_Scope, 16, /*->520*/ // 2 children in Scope
/*504*/             OPC_CheckPatternPredicate, 2, // (!Subtarget->hasHWROT32())
/*506*/             OPC_EmitConvertToTarget, 1,
/*508*/             OPC_EmitNodeXForm, 0, 1, // SUB_FRM_32
/*511*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROT64imm_sw), 0,
                        MVT::i64, 3/*#Ops*/, 0, 2, 3, 
                    // Src: (intrinsic_wo_chain:i64 3369:iPTR, Int64Regs:i64:$src, (imm:i32):$amt) - Complexity = 11
                    // Dst: (ROT64imm_sw:i64 Int64Regs:i64:$src, (imm:i32):$amt, (SUB_FRM_32:i32 node:i32:$amt))
/*520*/           /*Scope*/ 60, /*->581*/
/*521*/             OPC_CheckPatternPredicate, 1, // (Subtarget->hasHWROT32())
/*523*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #2
/*530*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #3
/*537*/             OPC_EmitConvertToTarget, 1,
/*539*/             OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_L_WRAP_B32_IMM), 0,
                        MVT::i32, 3/*#Ops*/, 2, 3, 4,  // Results = #5
/*548*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #6
/*555*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #7
/*562*/             OPC_EmitConvertToTarget, 1,
/*564*/             OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_L_WRAP_B32_IMM), 0,
                        MVT::i32, 3/*#Ops*/, 6, 7, 8,  // Results = #9
/*573*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::PACK_TWO_INT32), 0,
                        MVT::i64, 2/*#Ops*/, 5, 9, 
                    // Src: (intrinsic_wo_chain:i64 3369:iPTR, Int64Regs:i64:$src, (imm:i32):$amt) - Complexity = 11
                    // Dst: (PACK_TWO_INT32:i64 (SHF_L_WRAP_B32_IMM:i32 (GET_HI_INT64:i32 Int64Regs:i64:$src), (GET_LO_INT64:i32 Int64Regs:i64:$src), (imm:i32):$amt), (SHF_L_WRAP_B32_IMM:i32 (GET_LO_INT64:i32 Int64Regs:i64:$src), (GET_HI_INT64:i32 Int64Regs:i64:$src), (imm:i32):$amt))
/*581*/           0, /*End of Scope*/
/*582*/         /*Scope*/ 10, /*->593*/
/*583*/           OPC_CheckPatternPredicate, 2, // (!Subtarget->hasHWROT32())
/*585*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROTL64reg_sw), 0,
                      MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (intrinsic_wo_chain:i64 3369:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$amt) - Complexity = 8
                  // Dst: (ROTL64reg_sw:i64 Int64Regs:i64:$src, Int32Regs:i32:$amt)
/*593*/         /*Scope*/ 56, /*->650*/
/*594*/           OPC_CheckPatternPredicate, 1, // (Subtarget->hasHWROT32())
/*596*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #2
/*603*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #3
/*610*/           OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_L_WRAP_B32_REG), 0,
                      MVT::i32, 3/*#Ops*/, 2, 3, 1,  // Results = #4
/*619*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #5
/*626*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #6
/*633*/           OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_L_WRAP_B32_REG), 0,
                      MVT::i32, 3/*#Ops*/, 5, 6, 1,  // Results = #7
/*642*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::PACK_TWO_INT32), 0,
                      MVT::i64, 2/*#Ops*/, 4, 7, 
                  // Src: (intrinsic_wo_chain:i64 3369:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$amt) - Complexity = 8
                  // Dst: (PACK_TWO_INT32:i64 (SHF_L_WRAP_B32_REG:i32 (GET_HI_INT64:i32 Int64Regs:i64:$src), (GET_LO_INT64:i32 Int64Regs:i64:$src), Int32Regs:i32:$amt), (SHF_L_WRAP_B32_REG:i32 (GET_LO_INT64:i32 Int64Regs:i64:$src), (GET_HI_INT64:i32 Int64Regs:i64:$src), Int32Regs:i32:$amt))
/*650*/         0, /*End of Scope*/
/*651*/       /*Scope*/ 33|128,1/*161*/, /*->814*/
/*653*/         OPC_CheckChild0Integer, 42|128,26/*3370*/, 
/*656*/         OPC_RecordChild1, // #0 = $src
/*657*/         OPC_RecordChild2, // #1 = $amt
/*658*/         OPC_Scope, 85, /*->745*/ // 3 children in Scope
/*660*/           OPC_MoveChild2,
/*661*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*664*/           OPC_MoveParent,
/*665*/           OPC_Scope, 16, /*->683*/ // 2 children in Scope
/*667*/             OPC_CheckPatternPredicate, 2, // (!Subtarget->hasHWROT32())
/*669*/             OPC_EmitNodeXForm, 1, 1, // SUB_FRM_64
/*672*/             OPC_EmitConvertToTarget, 1,
/*674*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROT64imm_sw), 0,
                        MVT::i64, 3/*#Ops*/, 0, 2, 3, 
                    // Src: (intrinsic_wo_chain:i64 3370:iPTR, Int64Regs:i64:$src, (imm:i32):$amt) - Complexity = 11
                    // Dst: (ROT64imm_sw:i64 Int64Regs:i64:$src, (SUB_FRM_64:i32 node:i32:$amt), (imm:i32):$amt)
/*683*/           /*Scope*/ 60, /*->744*/
/*684*/             OPC_CheckPatternPredicate, 1, // (Subtarget->hasHWROT32())
/*686*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #2
/*693*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #3
/*700*/             OPC_EmitConvertToTarget, 1,
/*702*/             OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_R_WRAP_B32_IMM), 0,
                        MVT::i32, 3/*#Ops*/, 2, 3, 4,  // Results = #5
/*711*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #6
/*718*/             OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                        MVT::i32, 1/*#Ops*/, 0,  // Results = #7
/*725*/             OPC_EmitConvertToTarget, 1,
/*727*/             OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_R_WRAP_B32_IMM), 0,
                        MVT::i32, 3/*#Ops*/, 6, 7, 8,  // Results = #9
/*736*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::PACK_TWO_INT32), 0,
                        MVT::i64, 2/*#Ops*/, 5, 9, 
                    // Src: (intrinsic_wo_chain:i64 3370:iPTR, Int64Regs:i64:$src, (imm:i32):$amt) - Complexity = 11
                    // Dst: (PACK_TWO_INT32:i64 (SHF_R_WRAP_B32_IMM:i32 (GET_LO_INT64:i32 Int64Regs:i64:$src), (GET_HI_INT64:i32 Int64Regs:i64:$src), (imm:i32):$amt), (SHF_R_WRAP_B32_IMM:i32 (GET_HI_INT64:i32 Int64Regs:i64:$src), (GET_LO_INT64:i32 Int64Regs:i64:$src), (imm:i32):$amt))
/*744*/           0, /*End of Scope*/
/*745*/         /*Scope*/ 10, /*->756*/
/*746*/           OPC_CheckPatternPredicate, 2, // (!Subtarget->hasHWROT32())
/*748*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ROTR64reg_sw), 0,
                      MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (intrinsic_wo_chain:i64 3370:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$amt) - Complexity = 8
                  // Dst: (ROTR64reg_sw:i64 Int64Regs:i64:$src, Int32Regs:i32:$amt)
/*756*/         /*Scope*/ 56, /*->813*/
/*757*/           OPC_CheckPatternPredicate, 1, // (Subtarget->hasHWROT32())
/*759*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #2
/*766*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #3
/*773*/           OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_R_WRAP_B32_REG), 0,
                      MVT::i32, 3/*#Ops*/, 2, 3, 1,  // Results = #4
/*782*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #5
/*789*/           OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                      MVT::i32, 1/*#Ops*/, 0,  // Results = #6
/*796*/           OPC_EmitNode1, TARGET_VAL(NVPTX::SHF_R_WRAP_B32_REG), 0,
                      MVT::i32, 3/*#Ops*/, 5, 6, 1,  // Results = #7
/*805*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::PACK_TWO_INT32), 0,
                      MVT::i64, 2/*#Ops*/, 4, 7, 
                  // Src: (intrinsic_wo_chain:i64 3370:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$amt) - Complexity = 8
                  // Dst: (PACK_TWO_INT32:i64 (SHF_R_WRAP_B32_REG:i32 (GET_LO_INT64:i32 Int64Regs:i64:$src), (GET_HI_INT64:i32 Int64Regs:i64:$src), Int32Regs:i32:$amt), (SHF_R_WRAP_B32_REG:i32 (GET_HI_INT64:i32 Int64Regs:i64:$src), (GET_LO_INT64:i32 Int64Regs:i64:$src), Int32Regs:i32:$amt))
/*813*/         0, /*End of Scope*/
/*814*/       /*Scope*/ 15, /*->830*/
/*815*/         OPC_CheckChild0Integer, 78|128,25/*3278*/, 
/*818*/         OPC_RecordChild1, // #0 = $src0
/*819*/         OPC_RecordChild2, // #1 = $src1
/*820*/         OPC_RecordChild3, // #2 = $src2
/*821*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_PRMT), 0,
                    MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:i32 3278:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1, Int32Regs:i32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_PRMT:i32 Int32Regs:i32:$src0, Int32Regs:i32:$src1, Int32Regs:i32:$src2)
/*830*/       /*Scope*/ 13, /*->844*/
/*831*/         OPC_CheckChild0Integer, 74|128,25/*3274*/, 
/*834*/         OPC_RecordChild1, // #0 = $src0
/*835*/         OPC_RecordChild2, // #1 = $src1
/*836*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MULHI_I), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3274:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MULHI_I:i32 Int32Regs:i32:$src0, Int32Regs:i32:$src1)
/*844*/       /*Scope*/ 13, /*->858*/
/*845*/         OPC_CheckChild0Integer, 76|128,25/*3276*/, 
/*848*/         OPC_RecordChild1, // #0 = $src0
/*849*/         OPC_RecordChild2, // #1 = $src1
/*850*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MULHI_UI), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3276:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MULHI_UI:i32 Int32Regs:i32:$src0, Int32Regs:i32:$src1)
/*858*/       /*Scope*/ 13, /*->872*/
/*859*/         OPC_CheckChild0Integer, 75|128,25/*3275*/, 
/*862*/         OPC_RecordChild1, // #0 = $src0
/*863*/         OPC_RecordChild2, // #1 = $src1
/*864*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MULHI_LL), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3275:iPTR, Int64Regs:i64:$src0, Int64Regs:i64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MULHI_LL:i64 Int64Regs:i64:$src0, Int64Regs:i64:$src1)
/*872*/       /*Scope*/ 13, /*->886*/
/*873*/         OPC_CheckChild0Integer, 77|128,25/*3277*/, 
/*876*/         OPC_RecordChild1, // #0 = $src0
/*877*/         OPC_RecordChild2, // #1 = $src1
/*878*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MULHI_ULL), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3277:iPTR, Int64Regs:i64:$src0, Int64Regs:i64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MULHI_ULL:i64 Int64Regs:i64:$src0, Int64Regs:i64:$src1)
/*886*/       /*Scope*/ 13, /*->900*/
/*887*/         OPC_CheckChild0Integer, 72|128,25/*3272*/, 
/*890*/         OPC_RecordChild1, // #0 = $src0
/*891*/         OPC_RecordChild2, // #1 = $src1
/*892*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL24_I), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3272:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL24_I:i32 Int32Regs:i32:$src0, Int32Regs:i32:$src1)
/*900*/       /*Scope*/ 13, /*->914*/
/*901*/         OPC_CheckChild0Integer, 73|128,25/*3273*/, 
/*904*/         OPC_RecordChild1, // #0 = $src0
/*905*/         OPC_RecordChild2, // #1 = $src1
/*906*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL24_UI), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3273:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL24_UI:i32 Int32Regs:i32:$src0, Int32Regs:i32:$src1)
/*914*/       /*Scope*/ 15, /*->930*/
/*915*/         OPC_CheckChild0Integer, 49|128,26/*3377*/, 
/*918*/         OPC_RecordChild1, // #0 = $src0
/*919*/         OPC_RecordChild2, // #1 = $src1
/*920*/         OPC_RecordChild3, // #2 = $src2
/*921*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SAD_I), 0,
                    MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:i32 3377:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1, Int32Regs:i32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_SAD_I:i32 Int32Regs:i32:$src0, Int32Regs:i32:$src1, Int32Regs:i32:$src2)
/*930*/       /*Scope*/ 15, /*->946*/
/*931*/         OPC_CheckChild0Integer, 50|128,26/*3378*/, 
/*934*/         OPC_RecordChild1, // #0 = $src0
/*935*/         OPC_RecordChild2, // #1 = $src1
/*936*/         OPC_RecordChild3, // #2 = $src2
/*937*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SAD_UI), 0,
                    MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:i32 3378:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1, Int32Regs:i32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_SAD_UI:i32 Int32Regs:i32:$src0, Int32Regs:i32:$src1, Int32Regs:i32:$src2)
/*946*/       /*Scope*/ 15, /*->962*/
/*947*/         OPC_CheckChild0Integer, 56|128,24/*3128*/, 
/*950*/         OPC_RecordChild1, // #0 = $a
/*951*/         OPC_EmitInteger, MVT::i32, 1, 
/*954*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3128:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s32_f64:i32 Float64Regs:f64:$a, 1:i32)
/*962*/       /*Scope*/ 15, /*->978*/
/*963*/         OPC_CheckChild0Integer, 58|128,24/*3130*/, 
/*966*/         OPC_RecordChild1, // #0 = $a
/*967*/         OPC_EmitInteger, MVT::i32, 2, 
/*970*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3130:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s32_f64:i32 Float64Regs:f64:$a, 2:i32)
/*978*/       /*Scope*/ 15, /*->994*/
/*979*/         OPC_CheckChild0Integer, 55|128,24/*3127*/, 
/*982*/         OPC_RecordChild1, // #0 = $a
/*983*/         OPC_EmitInteger, MVT::i32, 3, 
/*986*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3127:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s32_f64:i32 Float64Regs:f64:$a, 3:i32)
/*994*/       /*Scope*/ 15, /*->1010*/
/*995*/         OPC_CheckChild0Integer, 57|128,24/*3129*/, 
/*998*/         OPC_RecordChild1, // #0 = $a
/*999*/         OPC_EmitInteger, MVT::i32, 4, 
/*1002*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3129:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s32_f64:i32 Float64Regs:f64:$a, 4:i32)
/*1010*/      /*Scope*/ 15, /*->1026*/
/*1011*/        OPC_CheckChild0Integer, 64|128,24/*3136*/, 
/*1014*/        OPC_RecordChild1, // #0 = $a
/*1015*/        OPC_EmitInteger, MVT::i32, 1, 
/*1018*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3136:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u32_f64:i32 Float64Regs:f64:$a, 1:i32)
/*1026*/      /*Scope*/ 15, /*->1042*/
/*1027*/        OPC_CheckChild0Integer, 66|128,24/*3138*/, 
/*1030*/        OPC_RecordChild1, // #0 = $a
/*1031*/        OPC_EmitInteger, MVT::i32, 2, 
/*1034*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3138:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u32_f64:i32 Float64Regs:f64:$a, 2:i32)
/*1042*/      /*Scope*/ 15, /*->1058*/
/*1043*/        OPC_CheckChild0Integer, 63|128,24/*3135*/, 
/*1046*/        OPC_RecordChild1, // #0 = $a
/*1047*/        OPC_EmitInteger, MVT::i32, 3, 
/*1050*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3135:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u32_f64:i32 Float64Regs:f64:$a, 3:i32)
/*1058*/      /*Scope*/ 15, /*->1074*/
/*1059*/        OPC_CheckChild0Integer, 65|128,24/*3137*/, 
/*1062*/        OPC_RecordChild1, // #0 = $a
/*1063*/        OPC_EmitInteger, MVT::i32, 4, 
/*1066*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f64), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3137:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u32_f64:i32 Float64Regs:f64:$a, 4:i32)
/*1074*/      /*Scope*/ 15, /*->1090*/
/*1075*/        OPC_CheckChild0Integer, 93|128,24/*3165*/, 
/*1078*/        OPC_RecordChild1, // #0 = $a
/*1079*/        OPC_EmitInteger, MVT::i32, 17, 
/*1082*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3165:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 17:i32)
/*1090*/      /*Scope*/ 15, /*->1106*/
/*1091*/        OPC_CheckChild0Integer, 92|128,24/*3164*/, 
/*1094*/        OPC_RecordChild1, // #0 = $a
/*1095*/        OPC_EmitInteger, MVT::i32, 1, 
/*1098*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3164:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 1:i32)
/*1106*/      /*Scope*/ 15, /*->1122*/
/*1107*/        OPC_CheckChild0Integer, 97|128,24/*3169*/, 
/*1110*/        OPC_RecordChild1, // #0 = $a
/*1111*/        OPC_EmitInteger, MVT::i32, 18, 
/*1114*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3169:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 18:i32)
/*1122*/      /*Scope*/ 15, /*->1138*/
/*1123*/        OPC_CheckChild0Integer, 96|128,24/*3168*/, 
/*1126*/        OPC_RecordChild1, // #0 = $a
/*1127*/        OPC_EmitInteger, MVT::i32, 2, 
/*1130*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3168:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 2:i32)
/*1138*/      /*Scope*/ 15, /*->1154*/
/*1139*/        OPC_CheckChild0Integer, 91|128,24/*3163*/, 
/*1142*/        OPC_RecordChild1, // #0 = $a
/*1143*/        OPC_EmitInteger, MVT::i32, 19, 
/*1146*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3163:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 19:i32)
/*1154*/      /*Scope*/ 15, /*->1170*/
/*1155*/        OPC_CheckChild0Integer, 90|128,24/*3162*/, 
/*1158*/        OPC_RecordChild1, // #0 = $a
/*1159*/        OPC_EmitInteger, MVT::i32, 3, 
/*1162*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3162:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 3:i32)
/*1170*/      /*Scope*/ 15, /*->1186*/
/*1171*/        OPC_CheckChild0Integer, 95|128,24/*3167*/, 
/*1174*/        OPC_RecordChild1, // #0 = $a
/*1175*/        OPC_EmitInteger, MVT::i32, 20, 
/*1178*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3167:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 20:i32)
/*1186*/      /*Scope*/ 15, /*->1202*/
/*1187*/        OPC_CheckChild0Integer, 94|128,24/*3166*/, 
/*1190*/        OPC_RecordChild1, // #0 = $a
/*1191*/        OPC_EmitInteger, MVT::i32, 4, 
/*1194*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3166:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s32_f32:i32 Float32Regs:f32:$a, 4:i32)
/*1202*/      /*Scope*/ 15, /*->1218*/
/*1203*/        OPC_CheckChild0Integer, 109|128,24/*3181*/, 
/*1206*/        OPC_RecordChild1, // #0 = $a
/*1207*/        OPC_EmitInteger, MVT::i32, 17, 
/*1210*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3181:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 17:i32)
/*1218*/      /*Scope*/ 15, /*->1234*/
/*1219*/        OPC_CheckChild0Integer, 108|128,24/*3180*/, 
/*1222*/        OPC_RecordChild1, // #0 = $a
/*1223*/        OPC_EmitInteger, MVT::i32, 1, 
/*1226*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3180:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 1:i32)
/*1234*/      /*Scope*/ 15, /*->1250*/
/*1235*/        OPC_CheckChild0Integer, 113|128,24/*3185*/, 
/*1238*/        OPC_RecordChild1, // #0 = $a
/*1239*/        OPC_EmitInteger, MVT::i32, 18, 
/*1242*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3185:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 18:i32)
/*1250*/      /*Scope*/ 15, /*->1266*/
/*1251*/        OPC_CheckChild0Integer, 112|128,24/*3184*/, 
/*1254*/        OPC_RecordChild1, // #0 = $a
/*1255*/        OPC_EmitInteger, MVT::i32, 2, 
/*1258*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3184:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 2:i32)
/*1266*/      /*Scope*/ 15, /*->1282*/
/*1267*/        OPC_CheckChild0Integer, 107|128,24/*3179*/, 
/*1270*/        OPC_RecordChild1, // #0 = $a
/*1271*/        OPC_EmitInteger, MVT::i32, 19, 
/*1274*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3179:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 19:i32)
/*1282*/      /*Scope*/ 15, /*->1298*/
/*1283*/        OPC_CheckChild0Integer, 106|128,24/*3178*/, 
/*1286*/        OPC_RecordChild1, // #0 = $a
/*1287*/        OPC_EmitInteger, MVT::i32, 3, 
/*1290*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3178:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 3:i32)
/*1298*/      /*Scope*/ 15, /*->1314*/
/*1299*/        OPC_CheckChild0Integer, 111|128,24/*3183*/, 
/*1302*/        OPC_RecordChild1, // #0 = $a
/*1303*/        OPC_EmitInteger, MVT::i32, 20, 
/*1306*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3183:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 20:i32)
/*1314*/      /*Scope*/ 15, /*->1330*/
/*1315*/        OPC_CheckChild0Integer, 110|128,24/*3182*/, 
/*1318*/        OPC_RecordChild1, // #0 = $a
/*1319*/        OPC_EmitInteger, MVT::i32, 4, 
/*1322*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u32_f32), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i32 3182:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u32_f32:i32 Float32Regs:f32:$a, 4:i32)
/*1330*/      /*Scope*/ 11, /*->1342*/
/*1331*/        OPC_CheckChild0Integer, 54|128,24/*3126*/, 
/*1334*/        OPC_RecordChild1, // #0 = $src0
/*1335*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_D2I_LO), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3126:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_D2I_LO:i32 Float64Regs:f64:$src0)
/*1342*/      /*Scope*/ 11, /*->1354*/
/*1343*/        OPC_CheckChild0Integer, 53|128,24/*3125*/, 
/*1346*/        OPC_RecordChild1, // #0 = $src0
/*1347*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_D2I_HI), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3125:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_D2I_HI:i32 Float64Regs:f64:$src0)
/*1354*/      /*Scope*/ 15, /*->1370*/
/*1355*/        OPC_CheckChild0Integer, 101|128,24/*3173*/, 
/*1358*/        OPC_RecordChild1, // #0 = $a
/*1359*/        OPC_EmitInteger, MVT::i32, 17, 
/*1362*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3173:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 17:i32)
/*1370*/      /*Scope*/ 15, /*->1386*/
/*1371*/        OPC_CheckChild0Integer, 100|128,24/*3172*/, 
/*1374*/        OPC_RecordChild1, // #0 = $a
/*1375*/        OPC_EmitInteger, MVT::i32, 1, 
/*1378*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3172:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 1:i32)
/*1386*/      /*Scope*/ 15, /*->1402*/
/*1387*/        OPC_CheckChild0Integer, 105|128,24/*3177*/, 
/*1390*/        OPC_RecordChild1, // #0 = $a
/*1391*/        OPC_EmitInteger, MVT::i32, 18, 
/*1394*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3177:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 18:i32)
/*1402*/      /*Scope*/ 15, /*->1418*/
/*1403*/        OPC_CheckChild0Integer, 104|128,24/*3176*/, 
/*1406*/        OPC_RecordChild1, // #0 = $a
/*1407*/        OPC_EmitInteger, MVT::i32, 2, 
/*1410*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3176:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 2:i32)
/*1418*/      /*Scope*/ 15, /*->1434*/
/*1419*/        OPC_CheckChild0Integer, 99|128,24/*3171*/, 
/*1422*/        OPC_RecordChild1, // #0 = $a
/*1423*/        OPC_EmitInteger, MVT::i32, 19, 
/*1426*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3171:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 19:i32)
/*1434*/      /*Scope*/ 15, /*->1450*/
/*1435*/        OPC_CheckChild0Integer, 98|128,24/*3170*/, 
/*1438*/        OPC_RecordChild1, // #0 = $a
/*1439*/        OPC_EmitInteger, MVT::i32, 3, 
/*1442*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3170:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 3:i32)
/*1450*/      /*Scope*/ 15, /*->1466*/
/*1451*/        OPC_CheckChild0Integer, 103|128,24/*3175*/, 
/*1454*/        OPC_RecordChild1, // #0 = $a
/*1455*/        OPC_EmitInteger, MVT::i32, 20, 
/*1458*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3175:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 20:i32)
/*1466*/      /*Scope*/ 15, /*->1482*/
/*1467*/        OPC_CheckChild0Integer, 102|128,24/*3174*/, 
/*1470*/        OPC_RecordChild1, // #0 = $a
/*1471*/        OPC_EmitInteger, MVT::i32, 4, 
/*1474*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3174:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_s64_f32:i64 Float32Regs:f32:$a, 4:i32)
/*1482*/      /*Scope*/ 15, /*->1498*/
/*1483*/        OPC_CheckChild0Integer, 117|128,24/*3189*/, 
/*1486*/        OPC_RecordChild1, // #0 = $a
/*1487*/        OPC_EmitInteger, MVT::i32, 17, 
/*1490*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3189:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 17:i32)
/*1498*/      /*Scope*/ 15, /*->1514*/
/*1499*/        OPC_CheckChild0Integer, 116|128,24/*3188*/, 
/*1502*/        OPC_RecordChild1, // #0 = $a
/*1503*/        OPC_EmitInteger, MVT::i32, 1, 
/*1506*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3188:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 1:i32)
/*1514*/      /*Scope*/ 15, /*->1530*/
/*1515*/        OPC_CheckChild0Integer, 121|128,24/*3193*/, 
/*1518*/        OPC_RecordChild1, // #0 = $a
/*1519*/        OPC_EmitInteger, MVT::i32, 18, 
/*1522*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3193:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 18:i32)
/*1530*/      /*Scope*/ 15, /*->1546*/
/*1531*/        OPC_CheckChild0Integer, 120|128,24/*3192*/, 
/*1534*/        OPC_RecordChild1, // #0 = $a
/*1535*/        OPC_EmitInteger, MVT::i32, 2, 
/*1538*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3192:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 2:i32)
/*1546*/      /*Scope*/ 15, /*->1562*/
/*1547*/        OPC_CheckChild0Integer, 115|128,24/*3187*/, 
/*1550*/        OPC_RecordChild1, // #0 = $a
/*1551*/        OPC_EmitInteger, MVT::i32, 19, 
/*1554*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3187:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 19:i32)
/*1562*/      /*Scope*/ 15, /*->1578*/
/*1563*/        OPC_CheckChild0Integer, 114|128,24/*3186*/, 
/*1566*/        OPC_RecordChild1, // #0 = $a
/*1567*/        OPC_EmitInteger, MVT::i32, 3, 
/*1570*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3186:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 3:i32)
/*1578*/      /*Scope*/ 15, /*->1594*/
/*1579*/        OPC_CheckChild0Integer, 119|128,24/*3191*/, 
/*1582*/        OPC_RecordChild1, // #0 = $a
/*1583*/        OPC_EmitInteger, MVT::i32, 20, 
/*1586*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3191:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 20:i32)
/*1594*/      /*Scope*/ 15, /*->1610*/
/*1595*/        OPC_CheckChild0Integer, 118|128,24/*3190*/, 
/*1598*/        OPC_RecordChild1, // #0 = $a
/*1599*/        OPC_EmitInteger, MVT::i32, 4, 
/*1602*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f32), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3190:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_u64_f32:i64 Float32Regs:f32:$a, 4:i32)
/*1610*/      /*Scope*/ 15, /*->1626*/
/*1611*/        OPC_CheckChild0Integer, 60|128,24/*3132*/, 
/*1614*/        OPC_RecordChild1, // #0 = $a
/*1615*/        OPC_EmitInteger, MVT::i32, 1, 
/*1618*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3132:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s64_f64:i64 Float64Regs:f64:$a, 1:i32)
/*1626*/      /*Scope*/ 15, /*->1642*/
/*1627*/        OPC_CheckChild0Integer, 62|128,24/*3134*/, 
/*1630*/        OPC_RecordChild1, // #0 = $a
/*1631*/        OPC_EmitInteger, MVT::i32, 2, 
/*1634*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3134:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s64_f64:i64 Float64Regs:f64:$a, 2:i32)
/*1642*/      /*Scope*/ 15, /*->1658*/
/*1643*/        OPC_CheckChild0Integer, 59|128,24/*3131*/, 
/*1646*/        OPC_RecordChild1, // #0 = $a
/*1647*/        OPC_EmitInteger, MVT::i32, 3, 
/*1650*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3131:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s64_f64:i64 Float64Regs:f64:$a, 3:i32)
/*1658*/      /*Scope*/ 15, /*->1674*/
/*1659*/        OPC_CheckChild0Integer, 61|128,24/*3133*/, 
/*1662*/        OPC_RecordChild1, // #0 = $a
/*1663*/        OPC_EmitInteger, MVT::i32, 4, 
/*1666*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_s64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3133:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_s64_f64:i64 Float64Regs:f64:$a, 4:i32)
/*1674*/      /*Scope*/ 15, /*->1690*/
/*1675*/        OPC_CheckChild0Integer, 68|128,24/*3140*/, 
/*1678*/        OPC_RecordChild1, // #0 = $a
/*1679*/        OPC_EmitInteger, MVT::i32, 1, 
/*1682*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3140:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u64_f64:i64 Float64Regs:f64:$a, 1:i32)
/*1690*/      /*Scope*/ 15, /*->1706*/
/*1691*/        OPC_CheckChild0Integer, 70|128,24/*3142*/, 
/*1694*/        OPC_RecordChild1, // #0 = $a
/*1695*/        OPC_EmitInteger, MVT::i32, 2, 
/*1698*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3142:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u64_f64:i64 Float64Regs:f64:$a, 2:i32)
/*1706*/      /*Scope*/ 15, /*->1722*/
/*1707*/        OPC_CheckChild0Integer, 67|128,24/*3139*/, 
/*1710*/        OPC_RecordChild1, // #0 = $a
/*1711*/        OPC_EmitInteger, MVT::i32, 3, 
/*1714*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3139:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u64_f64:i64 Float64Regs:f64:$a, 3:i32)
/*1722*/      /*Scope*/ 15, /*->1738*/
/*1723*/        OPC_CheckChild0Integer, 69|128,24/*3141*/, 
/*1726*/        OPC_RecordChild1, // #0 = $a
/*1727*/        OPC_EmitInteger, MVT::i32, 4, 
/*1730*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_u64_f64), 0,
                    MVT::i64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:i64 3141:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_u64_f64:i64 Float64Regs:f64:$a, 4:i32)
/*1738*/      /*Scope*/ 11, /*->1750*/
/*1739*/        OPC_CheckChild0Integer, 35|128,24/*3107*/, 
/*1742*/        OPC_RecordChild1, // #0 = $src0
/*1743*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_BITCAST_F2I), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3107:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_BITCAST_F2I:i32 Float32Regs:f32:$src0)
/*1750*/      /*Scope*/ 11, /*->1762*/
/*1751*/        OPC_CheckChild0Integer, 34|128,24/*3106*/, 
/*1754*/        OPC_RecordChild1, // #0 = $src0
/*1755*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_BITCAST_D2LL), 0,
                    MVT::i64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i64 3106:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_BITCAST_D2LL:i64 Float64Regs:f64:$src0)
/*1762*/      /*Scope*/ 54, /*->1817*/
/*1763*/        OPC_CheckChild0Integer, 86|128,25/*3286*/, 
/*1766*/        OPC_RecordChild1, // #0 = $src
/*1767*/        OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->1792
/*1770*/          OPC_CheckChild1Type, MVT::i32,
/*1772*/          OPC_Scope, 9, /*->1783*/ // 2 children in Scope
/*1774*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1776*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_local_yes), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3286:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_local_yes:i32 Int32Regs:i32:$src)
/*1783*/          /*Scope*/ 7, /*->1791*/
/*1784*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_local_no), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3286:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_local_no:i32 Int32Regs:i32:$src)
/*1791*/          0, /*End of Scope*/
/*1792*/        /*SwitchType*/ 22, MVT::i64,// ->1816
/*1794*/          OPC_CheckChild1Type, MVT::i64,
/*1796*/          OPC_Scope, 9, /*->1807*/ // 2 children in Scope
/*1798*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1800*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_local_yes_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3286:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_local_yes_64:i64 Int64Regs:i64:$src)
/*1807*/          /*Scope*/ 7, /*->1815*/
/*1808*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_local_no_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3286:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_local_no_64:i64 Int64Regs:i64:$src)
/*1815*/          0, /*End of Scope*/
/*1816*/        0, // EndSwitchType
/*1817*/      /*Scope*/ 54, /*->1872*/
/*1818*/        OPC_CheckChild0Integer, 87|128,25/*3287*/, 
/*1821*/        OPC_RecordChild1, // #0 = $src
/*1822*/        OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->1847
/*1825*/          OPC_CheckChild1Type, MVT::i32,
/*1827*/          OPC_Scope, 9, /*->1838*/ // 2 children in Scope
/*1829*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1831*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_shared_yes), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3287:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_shared_yes:i32 Int32Regs:i32:$src)
/*1838*/          /*Scope*/ 7, /*->1846*/
/*1839*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_shared_no), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3287:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_shared_no:i32 Int32Regs:i32:$src)
/*1846*/          0, /*End of Scope*/
/*1847*/        /*SwitchType*/ 22, MVT::i64,// ->1871
/*1849*/          OPC_CheckChild1Type, MVT::i64,
/*1851*/          OPC_Scope, 9, /*->1862*/ // 2 children in Scope
/*1853*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1855*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_shared_yes_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3287:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_shared_yes_64:i64 Int64Regs:i64:$src)
/*1862*/          /*Scope*/ 7, /*->1870*/
/*1863*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_shared_no_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3287:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_shared_no_64:i64 Int64Regs:i64:$src)
/*1870*/          0, /*End of Scope*/
/*1871*/        0, // EndSwitchType
/*1872*/      /*Scope*/ 54, /*->1927*/
/*1873*/        OPC_CheckChild0Integer, 85|128,25/*3285*/, 
/*1876*/        OPC_RecordChild1, // #0 = $src
/*1877*/        OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->1902
/*1880*/          OPC_CheckChild1Type, MVT::i32,
/*1882*/          OPC_Scope, 9, /*->1893*/ // 2 children in Scope
/*1884*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1886*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_global_yes), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3285:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_global_yes:i32 Int32Regs:i32:$src)
/*1893*/          /*Scope*/ 7, /*->1901*/
/*1894*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_global_no), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3285:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_global_no:i32 Int32Regs:i32:$src)
/*1901*/          0, /*End of Scope*/
/*1902*/        /*SwitchType*/ 22, MVT::i64,// ->1926
/*1904*/          OPC_CheckChild1Type, MVT::i64,
/*1906*/          OPC_Scope, 9, /*->1917*/ // 2 children in Scope
/*1908*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1910*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_global_yes_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3285:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_global_yes_64:i64 Int64Regs:i64:$src)
/*1917*/          /*Scope*/ 7, /*->1925*/
/*1918*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_global_no_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3285:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_global_no_64:i64 Int64Regs:i64:$src)
/*1925*/          0, /*End of Scope*/
/*1926*/        0, // EndSwitchType
/*1927*/      /*Scope*/ 54, /*->1982*/
/*1928*/        OPC_CheckChild0Integer, 79|128,25/*3279*/, 
/*1931*/        OPC_RecordChild1, // #0 = $src
/*1932*/        OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->1957
/*1935*/          OPC_CheckChild1Type, MVT::i32,
/*1937*/          OPC_Scope, 9, /*->1948*/ // 2 children in Scope
/*1939*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1941*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_const_yes), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3279:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_const_yes:i32 Int32Regs:i32:$src)
/*1948*/          /*Scope*/ 7, /*->1956*/
/*1949*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_const_no), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3279:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_const_no:i32 Int32Regs:i32:$src)
/*1956*/          0, /*End of Scope*/
/*1957*/        /*SwitchType*/ 22, MVT::i64,// ->1981
/*1959*/          OPC_CheckChild1Type, MVT::i64,
/*1961*/          OPC_Scope, 9, /*->1972*/ // 2 children in Scope
/*1963*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1965*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_const_yes_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3279:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_const_yes_64:i64 Int64Regs:i64:$src)
/*1972*/          /*Scope*/ 7, /*->1980*/
/*1973*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_const_no_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3279:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_const_no_64:i64 Int64Regs:i64:$src)
/*1980*/          0, /*End of Scope*/
/*1981*/        0, // EndSwitchType
/*1982*/      /*Scope*/ 54, /*->2037*/
/*1983*/        OPC_CheckChild0Integer, 84|128,25/*3284*/, 
/*1986*/        OPC_RecordChild1, // #0 = $src
/*1987*/        OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->2012
/*1990*/          OPC_CheckChild1Type, MVT::i32,
/*1992*/          OPC_Scope, 9, /*->2003*/ // 2 children in Scope
/*1994*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*1996*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_shared_yes), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3284:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_to_shared_yes:i32 Int32Regs:i32:$src)
/*2003*/          /*Scope*/ 7, /*->2011*/
/*2004*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_shared_no), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3284:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_to_shared_no:i32 Int32Regs:i32:$src)
/*2011*/          0, /*End of Scope*/
/*2012*/        /*SwitchType*/ 22, MVT::i64,// ->2036
/*2014*/          OPC_CheckChild1Type, MVT::i64,
/*2016*/          OPC_Scope, 9, /*->2027*/ // 2 children in Scope
/*2018*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*2020*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_shared_yes_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3284:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_to_shared_yes_64:i64 Int64Regs:i64:$src)
/*2027*/          /*Scope*/ 7, /*->2035*/
/*2028*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_shared_no_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3284:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_to_shared_no_64:i64 Int64Regs:i64:$src)
/*2035*/          0, /*End of Scope*/
/*2036*/        0, // EndSwitchType
/*2037*/      /*Scope*/ 54, /*->2092*/
/*2038*/        OPC_CheckChild0Integer, 81|128,25/*3281*/, 
/*2041*/        OPC_RecordChild1, // #0 = $src
/*2042*/        OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->2067
/*2045*/          OPC_CheckChild1Type, MVT::i32,
/*2047*/          OPC_Scope, 9, /*->2058*/ // 2 children in Scope
/*2049*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*2051*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_global_yes), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3281:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_to_global_yes:i32 Int32Regs:i32:$src)
/*2058*/          /*Scope*/ 7, /*->2066*/
/*2059*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_global_no), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3281:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_to_global_no:i32 Int32Regs:i32:$src)
/*2066*/          0, /*End of Scope*/
/*2067*/        /*SwitchType*/ 22, MVT::i64,// ->2091
/*2069*/          OPC_CheckChild1Type, MVT::i64,
/*2071*/          OPC_Scope, 9, /*->2082*/ // 2 children in Scope
/*2073*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*2075*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_global_yes_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3281:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_to_global_yes_64:i64 Int64Regs:i64:$src)
/*2082*/          /*Scope*/ 7, /*->2090*/
/*2083*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_global_no_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3281:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_to_global_no_64:i64 Int64Regs:i64:$src)
/*2090*/          0, /*End of Scope*/
/*2091*/        0, // EndSwitchType
/*2092*/      /*Scope*/ 54, /*->2147*/
/*2093*/        OPC_CheckChild0Integer, 80|128,25/*3280*/, 
/*2096*/        OPC_RecordChild1, // #0 = $src
/*2097*/        OPC_SwitchType /*2 cases */, 22, MVT::i32,// ->2122
/*2100*/          OPC_CheckChild1Type, MVT::i32,
/*2102*/          OPC_Scope, 9, /*->2113*/ // 2 children in Scope
/*2104*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*2106*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_const_yes), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3280:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_to_const_yes:i32 Int32Regs:i32:$src)
/*2113*/          /*Scope*/ 7, /*->2121*/
/*2114*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_const_no), 0,
                        MVT::i32, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i32 3280:iPTR, Int32Regs:i32:$src) - Complexity = 8
                    // Dst: (cvta_to_const_no:i32 Int32Regs:i32:$src)
/*2121*/          0, /*End of Scope*/
/*2122*/        /*SwitchType*/ 22, MVT::i64,// ->2146
/*2124*/          OPC_CheckChild1Type, MVT::i64,
/*2126*/          OPC_Scope, 9, /*->2137*/ // 2 children in Scope
/*2128*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasGenericLdSt())
/*2130*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_const_yes_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3280:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_to_const_yes_64:i64 Int64Regs:i64:$src)
/*2137*/          /*Scope*/ 7, /*->2145*/
/*2138*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::cvta_to_const_no_64), 0,
                        MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (intrinsic_wo_chain:i64 3280:iPTR, Int64Regs:i64:$src) - Complexity = 8
                    // Dst: (cvta_to_const_no_64:i64 Int64Regs:i64:$src)
/*2145*/          0, /*End of Scope*/
/*2146*/        0, // EndSwitchType
/*2147*/      /*Scope*/ 28, /*->2176*/
/*2148*/        OPC_CheckChild0Integer, 83|128,25/*3283*/, 
/*2151*/        OPC_RecordChild1, // #0 = $src
/*2152*/        OPC_SwitchType /*2 cases */, 9, MVT::i32,// ->2164
/*2155*/          OPC_CheckChild1Type, MVT::i32,
/*2157*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_ptr_gen_to_param), 0,
                      MVT::i32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i32 3283:iPTR, Int32Regs:i32:$src) - Complexity = 8
                  // Dst: (nvvm_ptr_gen_to_param:i32 Int32Regs:i32:$src)
/*2164*/        /*SwitchType*/ 9, MVT::i64,// ->2175
/*2166*/          OPC_CheckChild1Type, MVT::i64,
/*2168*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_ptr_gen_to_param_64), 0,
                      MVT::i64, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i64 3283:iPTR, Int64Regs:i64:$src) - Complexity = 8
                  // Dst: (nvvm_ptr_gen_to_param_64:i64 Int64Regs:i64:$src)
/*2175*/        0, // EndSwitchType
/*2176*/      /*Scope*/ 11, /*->2188*/
/*2177*/        OPC_CheckChild0Integer, 56|128,25/*3256*/, 
/*2180*/        OPC_RecordChild1, // #0 = $s
/*2181*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_i16), 0,
                    MVT::i16, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i16 3256:iPTR, Int16Regs:i16:$s) - Complexity = 8
                // Dst: (nvvm_move_i16:i16 Int16Regs:i16:$s)
/*2188*/      /*Scope*/ 11, /*->2200*/
/*2189*/        OPC_CheckChild0Integer, 57|128,25/*3257*/, 
/*2192*/        OPC_RecordChild1, // #0 = $s
/*2193*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_i32), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3257:iPTR, Int32Regs:i32:$s) - Complexity = 8
                // Dst: (nvvm_move_i32:i32 Int32Regs:i32:$s)
/*2200*/      /*Scope*/ 11, /*->2212*/
/*2201*/        OPC_CheckChild0Integer, 58|128,25/*3258*/, 
/*2204*/        OPC_RecordChild1, // #0 = $s
/*2205*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_i64), 0,
                    MVT::i64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i64 3258:iPTR, Int64Regs:i64:$s) - Complexity = 8
                // Dst: (nvvm_move_i64:i64 Int64Regs:i64:$s)
/*2212*/      /*Scope*/ 28, /*->2241*/
/*2213*/        OPC_CheckChild0Integer, 59|128,25/*3259*/, 
/*2216*/        OPC_RecordChild1, // #0 = $s
/*2217*/        OPC_SwitchType /*2 cases */, 9, MVT::i32,// ->2229
/*2220*/          OPC_CheckChild1Type, MVT::i32,
/*2222*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_ptr32), 0,
                      MVT::i32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i32 3259:iPTR, Int32Regs:i32:$s) - Complexity = 8
                  // Dst: (nvvm_move_ptr32:i32 Int32Regs:i32:$s)
/*2229*/        /*SwitchType*/ 9, MVT::i64,// ->2240
/*2231*/          OPC_CheckChild1Type, MVT::i64,
/*2233*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_ptr64), 0,
                      MVT::i64, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i64 3259:iPTR, Int64Regs:i64:$s) - Complexity = 8
                  // Dst: (nvvm_move_ptr64:i64 Int64Regs:i64:$s)
/*2240*/        0, // EndSwitchType
/*2241*/      /*Scope*/ 30, /*->2272*/
/*2242*/        OPC_CheckChild0Integer, 26|128,25/*3226*/, 
/*2245*/        OPC_RecordChild1, // #0 = $a
/*2246*/        OPC_Scope, 11, /*->2259*/ // 2 children in Scope
/*2248*/          OPC_CheckChild1Type, MVT::i32,
/*2250*/          OPC_CheckPatternPredicate, 3, // (Subtarget->getPTXVersion() >= 31)
/*2252*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_CONST_32), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3226:iPTR, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (ISSPACEP_CONST_32:i1 Int32Regs:i32:$a)
/*2259*/        /*Scope*/ 11, /*->2271*/
/*2260*/          OPC_CheckChild1Type, MVT::i64,
/*2262*/          OPC_CheckPatternPredicate, 3, // (Subtarget->getPTXVersion() >= 31)
/*2264*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_CONST_64), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3226:iPTR, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (ISSPACEP_CONST_64:i1 Int64Regs:i64:$a)
/*2271*/        0, /*End of Scope*/
/*2272*/      /*Scope*/ 26, /*->2299*/
/*2273*/        OPC_CheckChild0Integer, 27|128,25/*3227*/, 
/*2276*/        OPC_RecordChild1, // #0 = $a
/*2277*/        OPC_Scope, 9, /*->2288*/ // 2 children in Scope
/*2279*/          OPC_CheckChild1Type, MVT::i32,
/*2281*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_GLOBAL_32), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3227:iPTR, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (ISSPACEP_GLOBAL_32:i1 Int32Regs:i32:$a)
/*2288*/        /*Scope*/ 9, /*->2298*/
/*2289*/          OPC_CheckChild1Type, MVT::i64,
/*2291*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_GLOBAL_64), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3227:iPTR, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (ISSPACEP_GLOBAL_64:i1 Int64Regs:i64:$a)
/*2298*/        0, /*End of Scope*/
/*2299*/      /*Scope*/ 26, /*->2326*/
/*2300*/        OPC_CheckChild0Integer, 28|128,25/*3228*/, 
/*2303*/        OPC_RecordChild1, // #0 = $a
/*2304*/        OPC_Scope, 9, /*->2315*/ // 2 children in Scope
/*2306*/          OPC_CheckChild1Type, MVT::i32,
/*2308*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_LOCAL_32), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3228:iPTR, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (ISSPACEP_LOCAL_32:i1 Int32Regs:i32:$a)
/*2315*/        /*Scope*/ 9, /*->2325*/
/*2316*/          OPC_CheckChild1Type, MVT::i64,
/*2318*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_LOCAL_64), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3228:iPTR, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (ISSPACEP_LOCAL_64:i1 Int64Regs:i64:$a)
/*2325*/        0, /*End of Scope*/
/*2326*/      /*Scope*/ 26, /*->2353*/
/*2327*/        OPC_CheckChild0Integer, 29|128,25/*3229*/, 
/*2330*/        OPC_RecordChild1, // #0 = $a
/*2331*/        OPC_Scope, 9, /*->2342*/ // 2 children in Scope
/*2333*/          OPC_CheckChild1Type, MVT::i32,
/*2335*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_SHARED_32), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3229:iPTR, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (ISSPACEP_SHARED_32:i1 Int32Regs:i32:$a)
/*2342*/        /*Scope*/ 9, /*->2352*/
/*2343*/          OPC_CheckChild1Type, MVT::i64,
/*2345*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISSPACEP_SHARED_64), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:i1 3229:iPTR, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (ISSPACEP_SHARED_64:i1 Int64Regs:i64:$a)
/*2352*/        0, /*End of Scope*/
/*2353*/      /*Scope*/ 13, /*->2367*/
/*2354*/        OPC_CheckChild0Integer, 107|128,25/*3307*/, 
/*2357*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG0,
/*2360*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3307:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG0:i32)
/*2367*/      /*Scope*/ 13, /*->2381*/
/*2368*/        OPC_CheckChild0Integer, 108|128,25/*3308*/, 
/*2371*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG1,
/*2374*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3308:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG1:i32)
/*2381*/      /*Scope*/ 13, /*->2395*/
/*2382*/        OPC_CheckChild0Integer, 119|128,25/*3319*/, 
/*2385*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG2,
/*2388*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3319:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG2:i32)
/*2395*/      /*Scope*/ 13, /*->2409*/
/*2396*/        OPC_CheckChild0Integer, 2|128,26/*3330*/, 
/*2399*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG3,
/*2402*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3330:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG3:i32)
/*2409*/      /*Scope*/ 13, /*->2423*/
/*2410*/        OPC_CheckChild0Integer, 5|128,26/*3333*/, 
/*2413*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG4,
/*2416*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3333:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG4:i32)
/*2423*/      /*Scope*/ 13, /*->2437*/
/*2424*/        OPC_CheckChild0Integer, 6|128,26/*3334*/, 
/*2427*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG5,
/*2430*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3334:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG5:i32)
/*2437*/      /*Scope*/ 13, /*->2451*/
/*2438*/        OPC_CheckChild0Integer, 7|128,26/*3335*/, 
/*2441*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG6,
/*2444*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3335:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG6:i32)
/*2451*/      /*Scope*/ 13, /*->2465*/
/*2452*/        OPC_CheckChild0Integer, 8|128,26/*3336*/, 
/*2455*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG7,
/*2458*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3336:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG7:i32)
/*2465*/      /*Scope*/ 13, /*->2479*/
/*2466*/        OPC_CheckChild0Integer, 9|128,26/*3337*/, 
/*2469*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG8,
/*2472*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3337:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG8:i32)
/*2479*/      /*Scope*/ 13, /*->2493*/
/*2480*/        OPC_CheckChild0Integer, 10|128,26/*3338*/, 
/*2483*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG9,
/*2486*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3338:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG9:i32)
/*2493*/      /*Scope*/ 13, /*->2507*/
/*2494*/        OPC_CheckChild0Integer, 109|128,25/*3309*/, 
/*2497*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG10,
/*2500*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3309:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG10:i32)
/*2507*/      /*Scope*/ 13, /*->2521*/
/*2508*/        OPC_CheckChild0Integer, 110|128,25/*3310*/, 
/*2511*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG11,
/*2514*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3310:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG11:i32)
/*2521*/      /*Scope*/ 13, /*->2535*/
/*2522*/        OPC_CheckChild0Integer, 111|128,25/*3311*/, 
/*2525*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG12,
/*2528*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3311:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG12:i32)
/*2535*/      /*Scope*/ 13, /*->2549*/
/*2536*/        OPC_CheckChild0Integer, 112|128,25/*3312*/, 
/*2539*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG13,
/*2542*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3312:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG13:i32)
/*2549*/      /*Scope*/ 13, /*->2563*/
/*2550*/        OPC_CheckChild0Integer, 113|128,25/*3313*/, 
/*2553*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG14,
/*2556*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3313:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG14:i32)
/*2563*/      /*Scope*/ 13, /*->2577*/
/*2564*/        OPC_CheckChild0Integer, 114|128,25/*3314*/, 
/*2567*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG15,
/*2570*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3314:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG15:i32)
/*2577*/      /*Scope*/ 13, /*->2591*/
/*2578*/        OPC_CheckChild0Integer, 115|128,25/*3315*/, 
/*2581*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG16,
/*2584*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3315:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG16:i32)
/*2591*/      /*Scope*/ 13, /*->2605*/
/*2592*/        OPC_CheckChild0Integer, 116|128,25/*3316*/, 
/*2595*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG17,
/*2598*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3316:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG17:i32)
/*2605*/      /*Scope*/ 13, /*->2619*/
/*2606*/        OPC_CheckChild0Integer, 117|128,25/*3317*/, 
/*2609*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG18,
/*2612*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3317:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG18:i32)
/*2619*/      /*Scope*/ 13, /*->2633*/
/*2620*/        OPC_CheckChild0Integer, 118|128,25/*3318*/, 
/*2623*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG19,
/*2626*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3318:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG19:i32)
/*2633*/      /*Scope*/ 13, /*->2647*/
/*2634*/        OPC_CheckChild0Integer, 120|128,25/*3320*/, 
/*2637*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG20,
/*2640*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3320:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG20:i32)
/*2647*/      /*Scope*/ 13, /*->2661*/
/*2648*/        OPC_CheckChild0Integer, 121|128,25/*3321*/, 
/*2651*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG21,
/*2654*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3321:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG21:i32)
/*2661*/      /*Scope*/ 13, /*->2675*/
/*2662*/        OPC_CheckChild0Integer, 122|128,25/*3322*/, 
/*2665*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG22,
/*2668*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3322:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG22:i32)
/*2675*/      /*Scope*/ 13, /*->2689*/
/*2676*/        OPC_CheckChild0Integer, 123|128,25/*3323*/, 
/*2679*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG23,
/*2682*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3323:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG23:i32)
/*2689*/      /*Scope*/ 13, /*->2703*/
/*2690*/        OPC_CheckChild0Integer, 124|128,25/*3324*/, 
/*2693*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG24,
/*2696*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3324:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG24:i32)
/*2703*/      /*Scope*/ 13, /*->2717*/
/*2704*/        OPC_CheckChild0Integer, 125|128,25/*3325*/, 
/*2707*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG25,
/*2710*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3325:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG25:i32)
/*2717*/      /*Scope*/ 13, /*->2731*/
/*2718*/        OPC_CheckChild0Integer, 126|128,25/*3326*/, 
/*2721*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG26,
/*2724*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3326:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG26:i32)
/*2731*/      /*Scope*/ 13, /*->2745*/
/*2732*/        OPC_CheckChild0Integer, 127|128,25/*3327*/, 
/*2735*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG27,
/*2738*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3327:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG27:i32)
/*2745*/      /*Scope*/ 13, /*->2759*/
/*2746*/        OPC_CheckChild0Integer, 0|128,26/*3328*/, 
/*2749*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG28,
/*2752*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3328:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG28:i32)
/*2759*/      /*Scope*/ 13, /*->2773*/
/*2760*/        OPC_CheckChild0Integer, 1|128,26/*3329*/, 
/*2763*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG29,
/*2766*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3329:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG29:i32)
/*2773*/      /*Scope*/ 13, /*->2787*/
/*2774*/        OPC_CheckChild0Integer, 3|128,26/*3331*/, 
/*2777*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG30,
/*2780*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3331:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG30:i32)
/*2787*/      /*Scope*/ 13, /*->2801*/
/*2788*/        OPC_CheckChild0Integer, 4|128,26/*3332*/, 
/*2791*/        OPC_EmitRegister, MVT::i32, NVPTX::ENVREG31,
/*2794*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MOV_SPECIAL), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3332:iPTR) - Complexity = 8
                // Dst: (MOV_SPECIAL:i32 ENVREG31:i32)
/*2801*/      /*Scope*/ 11, /*->2813*/
/*2802*/        OPC_CheckChild0Integer, 124|128,30/*3964*/, 
/*2805*/        OPC_RecordChild1, // #0 = $a
/*2806*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_CHANNEL_ORDER), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3964:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_CHANNEL_ORDER:i32 Int64Regs:i64:$a)
/*2813*/      /*Scope*/ 11, /*->2825*/
/*2814*/        OPC_CheckChild0Integer, 123|128,30/*3963*/, 
/*2817*/        OPC_RecordChild1, // #0 = $a
/*2818*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_CHANNEL_DATA_TYPE), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3963:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_CHANNEL_DATA_TYPE:i32 Int64Regs:i64:$a)
/*2825*/      /*Scope*/ 11, /*->2837*/
/*2826*/        OPC_CheckChild0Integer, 1|128,31/*3969*/, 
/*2829*/        OPC_RecordChild1, // #0 = $a
/*2830*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_WIDTH), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3969:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_WIDTH:i32 Int64Regs:i64:$a)
/*2837*/      /*Scope*/ 11, /*->2849*/
/*2838*/        OPC_CheckChild0Integer, 126|128,30/*3966*/, 
/*2841*/        OPC_RecordChild1, // #0 = $a
/*2842*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_HEIGHT), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3966:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_HEIGHT:i32 Int64Regs:i64:$a)
/*2849*/      /*Scope*/ 11, /*->2861*/
/*2850*/        OPC_CheckChild0Integer, 125|128,30/*3965*/, 
/*2853*/        OPC_RecordChild1, // #0 = $a
/*2854*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_DEPTH), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3965:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_DEPTH:i32 Int64Regs:i64:$a)
/*2861*/      /*Scope*/ 11, /*->2873*/
/*2862*/        OPC_CheckChild0Integer, 122|128,30/*3962*/, 
/*2865*/        OPC_RecordChild1, // #0 = $a
/*2866*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_ARRAY_SIZE), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3962:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_ARRAY_SIZE:i32 Int64Regs:i64:$a)
/*2873*/      /*Scope*/ 11, /*->2885*/
/*2874*/        OPC_CheckChild0Integer, 0|128,31/*3968*/, 
/*2877*/        OPC_RecordChild1, // #0 = $a
/*2878*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_NUM_SAMPLES), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3968:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_NUM_SAMPLES:i32 Int64Regs:i64:$a)
/*2885*/      /*Scope*/ 11, /*->2897*/
/*2886*/        OPC_CheckChild0Integer, 127|128,30/*3967*/, 
/*2889*/        OPC_RecordChild1, // #0 = $a
/*2890*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::TXQ_NUM_MIPMAP_LEVELS), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3967:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (TXQ_NUM_MIPMAP_LEVELS:i32 Int64Regs:i64:$a)
/*2897*/      /*Scope*/ 11, /*->2909*/
/*2898*/        OPC_CheckChild0Integer, 118|128,27/*3574*/, 
/*2901*/        OPC_RecordChild1, // #0 = $a
/*2902*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUQ_CHANNEL_ORDER), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3574:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (SUQ_CHANNEL_ORDER:i32 Int64Regs:i64:$a)
/*2909*/      /*Scope*/ 11, /*->2921*/
/*2910*/        OPC_CheckChild0Integer, 117|128,27/*3573*/, 
/*2913*/        OPC_RecordChild1, // #0 = $a
/*2914*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUQ_CHANNEL_DATA_TYPE), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3573:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (SUQ_CHANNEL_DATA_TYPE:i32 Int64Regs:i64:$a)
/*2921*/      /*Scope*/ 11, /*->2933*/
/*2922*/        OPC_CheckChild0Integer, 121|128,27/*3577*/, 
/*2925*/        OPC_RecordChild1, // #0 = $a
/*2926*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUQ_WIDTH), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3577:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (SUQ_WIDTH:i32 Int64Regs:i64:$a)
/*2933*/      /*Scope*/ 11, /*->2945*/
/*2934*/        OPC_CheckChild0Integer, 120|128,27/*3576*/, 
/*2937*/        OPC_RecordChild1, // #0 = $a
/*2938*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUQ_HEIGHT), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3576:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (SUQ_HEIGHT:i32 Int64Regs:i64:$a)
/*2945*/      /*Scope*/ 11, /*->2957*/
/*2946*/        OPC_CheckChild0Integer, 119|128,27/*3575*/, 
/*2949*/        OPC_RecordChild1, // #0 = $a
/*2950*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUQ_DEPTH), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3575:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (SUQ_DEPTH:i32 Int64Regs:i64:$a)
/*2957*/      /*Scope*/ 11, /*->2969*/
/*2958*/        OPC_CheckChild0Integer, 116|128,27/*3572*/, 
/*2961*/        OPC_RecordChild1, // #0 = $a
/*2962*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUQ_ARRAY_SIZE), 0,
                    MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 3572:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (SUQ_ARRAY_SIZE:i32 Int64Regs:i64:$a)
/*2969*/      /*Scope*/ 11, /*->2981*/
/*2970*/        OPC_CheckChild0Integer, 30|128,25/*3230*/, 
/*2973*/        OPC_RecordChild1, // #0 = $a
/*2974*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISTYPEP_SAMPLER), 0,
                    MVT::i1, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i1 3230:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (ISTYPEP_SAMPLER:i1 Int64Regs:i64:$a)
/*2981*/      /*Scope*/ 11, /*->2993*/
/*2982*/        OPC_CheckChild0Integer, 31|128,25/*3231*/, 
/*2985*/        OPC_RecordChild1, // #0 = $a
/*2986*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISTYPEP_SURFACE), 0,
                    MVT::i1, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i1 3231:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (ISTYPEP_SURFACE:i1 Int64Regs:i64:$a)
/*2993*/      /*Scope*/ 11, /*->3005*/
/*2994*/        OPC_CheckChild0Integer, 32|128,25/*3232*/, 
/*2997*/        OPC_RecordChild1, // #0 = $a
/*2998*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::ISTYPEP_TEXTURE), 0,
                    MVT::i1, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i1 3232:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (ISTYPEP_TEXTURE:i1 Int64Regs:i64:$a)
/*3005*/      /*Scope*/ 9, /*->3015*/
/*3006*/        OPC_CheckChild0Integer, 34|128,26/*3362*/, 
/*3009*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_TID_X), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3362:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_TID_X:i32)
/*3015*/      /*Scope*/ 9, /*->3025*/
/*3016*/        OPC_CheckChild0Integer, 35|128,26/*3363*/, 
/*3019*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_TID_Y), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3363:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_TID_Y:i32)
/*3025*/      /*Scope*/ 9, /*->3035*/
/*3026*/        OPC_CheckChild0Integer, 36|128,26/*3364*/, 
/*3029*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_TID_Z), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3364:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_TID_Z:i32)
/*3035*/      /*Scope*/ 9, /*->3045*/
/*3036*/        OPC_CheckChild0Integer, 33|128,26/*3361*/, 
/*3039*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_TID_W), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3361:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_TID_W:i32)
/*3045*/      /*Scope*/ 9, /*->3055*/
/*3046*/        OPC_CheckChild0Integer, 24|128,26/*3352*/, 
/*3049*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NTID_X), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3352:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NTID_X:i32)
/*3055*/      /*Scope*/ 9, /*->3065*/
/*3056*/        OPC_CheckChild0Integer, 25|128,26/*3353*/, 
/*3059*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NTID_Y), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3353:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NTID_Y:i32)
/*3065*/      /*Scope*/ 9, /*->3075*/
/*3066*/        OPC_CheckChild0Integer, 26|128,26/*3354*/, 
/*3069*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NTID_Z), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3354:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NTID_Z:i32)
/*3075*/      /*Scope*/ 9, /*->3085*/
/*3076*/        OPC_CheckChild0Integer, 23|128,26/*3351*/, 
/*3079*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NTID_W), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3351:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NTID_W:i32)
/*3085*/      /*Scope*/ 9, /*->3095*/
/*3086*/        OPC_CheckChild0Integer, 12|128,26/*3340*/, 
/*3089*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_LANEID), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3340:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_LANEID:i32)
/*3095*/      /*Scope*/ 9, /*->3105*/
/*3096*/        OPC_CheckChild0Integer, 37|128,26/*3365*/, 
/*3099*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_WARPID), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3365:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_WARPID:i32)
/*3105*/      /*Scope*/ 9, /*->3115*/
/*3106*/        OPC_CheckChild0Integer, 27|128,26/*3355*/, 
/*3109*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NWARPID), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3355:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NWARPID:i32)
/*3115*/      /*Scope*/ 9, /*->3125*/
/*3116*/        OPC_CheckChild0Integer, 104|128,25/*3304*/, 
/*3119*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_CTAID_X), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3304:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_CTAID_X:i32)
/*3125*/      /*Scope*/ 9, /*->3135*/
/*3126*/        OPC_CheckChild0Integer, 105|128,25/*3305*/, 
/*3129*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_CTAID_Y), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3305:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_CTAID_Y:i32)
/*3135*/      /*Scope*/ 9, /*->3145*/
/*3136*/        OPC_CheckChild0Integer, 106|128,25/*3306*/, 
/*3139*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_CTAID_Z), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3306:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_CTAID_Z:i32)
/*3145*/      /*Scope*/ 9, /*->3155*/
/*3146*/        OPC_CheckChild0Integer, 103|128,25/*3303*/, 
/*3149*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_CTAID_W), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3303:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_CTAID_W:i32)
/*3155*/      /*Scope*/ 9, /*->3165*/
/*3156*/        OPC_CheckChild0Integer, 19|128,26/*3347*/, 
/*3159*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NCTAID_X), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3347:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NCTAID_X:i32)
/*3165*/      /*Scope*/ 9, /*->3175*/
/*3166*/        OPC_CheckChild0Integer, 20|128,26/*3348*/, 
/*3169*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NCTAID_Y), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3348:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NCTAID_Y:i32)
/*3175*/      /*Scope*/ 9, /*->3185*/
/*3176*/        OPC_CheckChild0Integer, 21|128,26/*3349*/, 
/*3179*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NCTAID_Z), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3349:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NCTAID_Z:i32)
/*3185*/      /*Scope*/ 9, /*->3195*/
/*3186*/        OPC_CheckChild0Integer, 18|128,26/*3346*/, 
/*3189*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NCTAID_W), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3346:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NCTAID_W:i32)
/*3195*/      /*Scope*/ 9, /*->3205*/
/*3196*/        OPC_CheckChild0Integer, 32|128,26/*3360*/, 
/*3199*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_SMID), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3360:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_SMID:i32)
/*3205*/      /*Scope*/ 9, /*->3215*/
/*3206*/        OPC_CheckChild0Integer, 22|128,26/*3350*/, 
/*3209*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_NSMID), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3350:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_NSMID:i32)
/*3215*/      /*Scope*/ 9, /*->3225*/
/*3216*/        OPC_CheckChild0Integer, 11|128,26/*3339*/, 
/*3219*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_GRIDID), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3339:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_GRIDID:i32)
/*3225*/      /*Scope*/ 9, /*->3235*/
/*3226*/        OPC_CheckChild0Integer, 13|128,26/*3341*/, 
/*3229*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_LANEMASK_EQ), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3341:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_LANEMASK_EQ:i32)
/*3235*/      /*Scope*/ 9, /*->3245*/
/*3236*/        OPC_CheckChild0Integer, 16|128,26/*3344*/, 
/*3239*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_LANEMASK_LE), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3344:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_LANEMASK_LE:i32)
/*3245*/      /*Scope*/ 9, /*->3255*/
/*3246*/        OPC_CheckChild0Integer, 17|128,26/*3345*/, 
/*3249*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_LANEMASK_LT), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3345:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_LANEMASK_LT:i32)
/*3255*/      /*Scope*/ 9, /*->3265*/
/*3256*/        OPC_CheckChild0Integer, 14|128,26/*3342*/, 
/*3259*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_LANEMASK_GE), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3342:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_LANEMASK_GE:i32)
/*3265*/      /*Scope*/ 9, /*->3275*/
/*3266*/        OPC_CheckChild0Integer, 15|128,26/*3343*/, 
/*3269*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_LANEMASK_GT), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3343:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_LANEMASK_GT:i32)
/*3275*/      /*Scope*/ 9, /*->3285*/
/*3276*/        OPC_CheckChild0Integer, 101|128,25/*3301*/, 
/*3279*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_CLOCK), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3301:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_CLOCK:i32)
/*3285*/      /*Scope*/ 9, /*->3295*/
/*3286*/        OPC_CheckChild0Integer, 102|128,25/*3302*/, 
/*3289*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_CLOCK64), 0,
                    MVT::i64, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i64 3302:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_CLOCK64:i64)
/*3295*/      /*Scope*/ 9, /*->3305*/
/*3296*/        OPC_CheckChild0Integer, 28|128,26/*3356*/, 
/*3299*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_PM0), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3356:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_PM0:i32)
/*3305*/      /*Scope*/ 9, /*->3315*/
/*3306*/        OPC_CheckChild0Integer, 29|128,26/*3357*/, 
/*3309*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_PM1), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3357:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_PM1:i32)
/*3315*/      /*Scope*/ 9, /*->3325*/
/*3316*/        OPC_CheckChild0Integer, 30|128,26/*3358*/, 
/*3319*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_PM2), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3358:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_PM2:i32)
/*3325*/      /*Scope*/ 9, /*->3335*/
/*3326*/        OPC_CheckChild0Integer, 31|128,26/*3359*/, 
/*3329*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_PM3), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3359:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_PM3:i32)
/*3335*/      /*Scope*/ 9, /*->3345*/
/*3336*/        OPC_CheckChild0Integer, 38|128,26/*3366*/, 
/*3339*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SREG_WARPSIZE), 0,
                    MVT::i32, 0/*#Ops*/, 
                // Src: (intrinsic_wo_chain:i32 3366:iPTR) - Complexity = 8
                // Dst: (INT_PTX_SREG_WARPSIZE:i32)
/*3345*/      /*Scope*/ 22, /*->3368*/
/*3346*/        OPC_CheckChild0Integer, 89|128,24/*3161*/, 
/*3349*/        OPC_RecordChild1, // #0 = $a
/*3350*/        OPC_EmitInteger, MVT::i32, 21, 
/*3353*/        OPC_EmitNode1, TARGET_VAL(NVPTX::CVT_f16_f32), 0,
                    MVT::f16, 2/*#Ops*/, 0, 1,  // Results = #2
/*3361*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::BITCONVERT_16_F2I), 0,
                    MVT::i16, 1/*#Ops*/, 2, 
                // Src: (intrinsic_wo_chain:i16 3161:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (BITCONVERT_16_F2I:i16 (CVT_f16_f32:f16 Float32Regs:f32:$a, 21:i32))
/*3368*/      /*Scope*/ 22, /*->3391*/
/*3369*/        OPC_CheckChild0Integer, 88|128,24/*3160*/, 
/*3372*/        OPC_RecordChild1, // #0 = $a
/*3373*/        OPC_EmitInteger, MVT::i32, 5, 
/*3376*/        OPC_EmitNode1, TARGET_VAL(NVPTX::CVT_f16_f32), 0,
                    MVT::f16, 2/*#Ops*/, 0, 1,  // Results = #2
/*3384*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::BITCONVERT_16_F2I), 0,
                    MVT::i16, 1/*#Ops*/, 2, 
                // Src: (intrinsic_wo_chain:i16 3160:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (BITCONVERT_16_F2I:i16 (CVT_f16_f32:f16 Float32Regs:f32:$a, 5:i32))
/*3391*/      /*Scope*/ 26, /*->3418*/
/*3392*/        OPC_CheckChild0Integer, 76|128,29/*3788*/, 
/*3395*/        OPC_RecordChild1, // #0 = $src
/*3396*/        OPC_EmitNode1, TARGET_VAL(NVPTX::GET_HI_INT64), 0,
                    MVT::i32, 1/*#Ops*/, 0,  // Results = #1
/*3403*/        OPC_EmitNode1, TARGET_VAL(NVPTX::GET_LO_INT64), 0,
                    MVT::i32, 1/*#Ops*/, 0,  // Results = #2
/*3410*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::PACK_TWO_INT32), 0,
                    MVT::i64, 2/*#Ops*/, 1, 2, 
                // Src: (intrinsic_wo_chain:i64 3788:iPTR, Int64Regs:i64:$src) - Complexity = 8
                // Dst: (PACK_TWO_INT32:i64 (GET_HI_INT64:i32 Int64Regs:i64:$src), (GET_LO_INT64:i32 Int64Regs:i64:$src))
/*3418*/      /*Scope*/ 13|128,1/*141*/, /*->3561*/
/*3420*/        OPC_CheckChild0Integer, 16|128,25/*3216*/, 
/*3423*/        OPC_Scope, 124, /*->3549*/ // 2 children in Scope
/*3425*/          OPC_MoveChild1,
/*3426*/          OPC_SwitchOpcode /*2 cases */, 54, TARGET_VAL(ISD::ConstantFP),// ->3484
/*3430*/            OPC_CheckPredicate, 0, // Predicate_immFloat1
/*3432*/            OPC_MoveParent,
/*3433*/            OPC_MoveChild2,
/*3434*/            OPC_CheckOpcode, TARGET_VAL(ISD::INTRINSIC_WO_CHAIN),
/*3437*/            OPC_CheckChild0Integer, 13|128,25/*3213*/, 
/*3440*/            OPC_Scope, 20, /*->3462*/ // 2 children in Scope
/*3442*/              OPC_MoveChild1,
/*3443*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3446*/              OPC_CheckPredicate, 1, // Predicate_immFloat0
/*3448*/              OPC_MoveParent,
/*3449*/              OPC_RecordChild2, // #0 = $a
/*3450*/              OPC_MoveParent,
/*3451*/              OPC_EmitInteger, MVT::i32, 32, 
/*3454*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                          MVT::f32, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f32 3216:iPTR, (fpimm:f32)<<P:Predicate_immFloat1>>, (intrinsic_wo_chain:f32 3213:iPTR, (fpimm:f32)<<P:Predicate_immFloat0>>, Float32Regs:f32:$a)) - Complexity = 24
                      // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 32:i32)
/*3462*/            /*Scope*/ 20, /*->3483*/
/*3463*/              OPC_RecordChild1, // #0 = $a
/*3464*/              OPC_MoveChild2,
/*3465*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3468*/              OPC_CheckPredicate, 1, // Predicate_immFloat0
/*3470*/              OPC_MoveParent,
/*3471*/              OPC_MoveParent,
/*3472*/              OPC_EmitInteger, MVT::i32, 32, 
/*3475*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                          MVT::f32, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f32 3216:iPTR, (fpimm:f32)<<P:Predicate_immFloat1>>, (intrinsic_wo_chain:f32 3213:iPTR, Float32Regs:f32:$a, (fpimm:f32)<<P:Predicate_immFloat0>>)) - Complexity = 24
                      // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 32:i32)
/*3483*/            0, /*End of Scope*/
/*3484*/          /*SwitchOpcode*/ 61, TARGET_VAL(ISD::INTRINSIC_WO_CHAIN),// ->3548
/*3487*/            OPC_CheckChild0Integer, 13|128,25/*3213*/, 
/*3490*/            OPC_Scope, 27, /*->3519*/ // 2 children in Scope
/*3492*/              OPC_MoveChild1,
/*3493*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3496*/              OPC_CheckPredicate, 1, // Predicate_immFloat0
/*3498*/              OPC_MoveParent,
/*3499*/              OPC_RecordChild2, // #0 = $a
/*3500*/              OPC_MoveParent,
/*3501*/              OPC_MoveChild2,
/*3502*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3505*/              OPC_CheckPredicate, 0, // Predicate_immFloat1
/*3507*/              OPC_MoveParent,
/*3508*/              OPC_EmitInteger, MVT::i32, 32, 
/*3511*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                          MVT::f32, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f32 3216:iPTR, (intrinsic_wo_chain:f32 3213:iPTR, (fpimm:f32)<<P:Predicate_immFloat0>>, Float32Regs:f32:$a), (fpimm:f32)<<P:Predicate_immFloat1>>) - Complexity = 24
                      // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 32:i32)
/*3519*/            /*Scope*/ 27, /*->3547*/
/*3520*/              OPC_RecordChild1, // #0 = $a
/*3521*/              OPC_MoveChild2,
/*3522*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3525*/              OPC_CheckPredicate, 1, // Predicate_immFloat0
/*3527*/              OPC_MoveParent,
/*3528*/              OPC_MoveParent,
/*3529*/              OPC_MoveChild2,
/*3530*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3533*/              OPC_CheckPredicate, 0, // Predicate_immFloat1
/*3535*/              OPC_MoveParent,
/*3536*/              OPC_EmitInteger, MVT::i32, 32, 
/*3539*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                          MVT::f32, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f32 3216:iPTR, (intrinsic_wo_chain:f32 3213:iPTR, Float32Regs:f32:$a, (fpimm:f32)<<P:Predicate_immFloat0>>), (fpimm:f32)<<P:Predicate_immFloat1>>) - Complexity = 24
                      // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 32:i32)
/*3547*/            0, /*End of Scope*/
/*3548*/          0, // EndSwitchOpcode
/*3549*/        /*Scope*/ 10, /*->3560*/
/*3550*/          OPC_RecordChild1, // #0 = $src0
/*3551*/          OPC_RecordChild2, // #1 = $src1
/*3552*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMIN_F), 0,
                      MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (intrinsic_wo_chain:f32 3216:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                  // Dst: (INT_NVVM_FMIN_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*3560*/        0, /*End of Scope*/
/*3561*/      /*Scope*/ 13|128,1/*141*/, /*->3704*/
/*3563*/        OPC_CheckChild0Integer, 15|128,25/*3215*/, 
/*3566*/        OPC_Scope, 124, /*->3692*/ // 2 children in Scope
/*3568*/          OPC_MoveChild1,
/*3569*/          OPC_SwitchOpcode /*2 cases */, 54, TARGET_VAL(ISD::ConstantFP),// ->3627
/*3573*/            OPC_CheckPredicate, 2, // Predicate_immDouble1
/*3575*/            OPC_MoveParent,
/*3576*/            OPC_MoveChild2,
/*3577*/            OPC_CheckOpcode, TARGET_VAL(ISD::INTRINSIC_WO_CHAIN),
/*3580*/            OPC_CheckChild0Integer, 12|128,25/*3212*/, 
/*3583*/            OPC_Scope, 20, /*->3605*/ // 2 children in Scope
/*3585*/              OPC_MoveChild1,
/*3586*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3589*/              OPC_CheckPredicate, 3, // Predicate_immDouble0
/*3591*/              OPC_MoveParent,
/*3592*/              OPC_RecordChild2, // #0 = $a
/*3593*/              OPC_MoveParent,
/*3594*/              OPC_EmitInteger, MVT::i32, 32, 
/*3597*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                          MVT::f64, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f64 3215:iPTR, (fpimm:f64)<<P:Predicate_immDouble1>>, (intrinsic_wo_chain:f64 3212:iPTR, (fpimm:f64)<<P:Predicate_immDouble0>>, Float64Regs:f64:$a)) - Complexity = 24
                      // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 32:i32)
/*3605*/            /*Scope*/ 20, /*->3626*/
/*3606*/              OPC_RecordChild1, // #0 = $a
/*3607*/              OPC_MoveChild2,
/*3608*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3611*/              OPC_CheckPredicate, 3, // Predicate_immDouble0
/*3613*/              OPC_MoveParent,
/*3614*/              OPC_MoveParent,
/*3615*/              OPC_EmitInteger, MVT::i32, 32, 
/*3618*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                          MVT::f64, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f64 3215:iPTR, (fpimm:f64)<<P:Predicate_immDouble1>>, (intrinsic_wo_chain:f64 3212:iPTR, Float64Regs:f64:$a, (fpimm:f64)<<P:Predicate_immDouble0>>)) - Complexity = 24
                      // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 32:i32)
/*3626*/            0, /*End of Scope*/
/*3627*/          /*SwitchOpcode*/ 61, TARGET_VAL(ISD::INTRINSIC_WO_CHAIN),// ->3691
/*3630*/            OPC_CheckChild0Integer, 12|128,25/*3212*/, 
/*3633*/            OPC_Scope, 27, /*->3662*/ // 2 children in Scope
/*3635*/              OPC_MoveChild1,
/*3636*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3639*/              OPC_CheckPredicate, 3, // Predicate_immDouble0
/*3641*/              OPC_MoveParent,
/*3642*/              OPC_RecordChild2, // #0 = $a
/*3643*/              OPC_MoveParent,
/*3644*/              OPC_MoveChild2,
/*3645*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3648*/              OPC_CheckPredicate, 2, // Predicate_immDouble1
/*3650*/              OPC_MoveParent,
/*3651*/              OPC_EmitInteger, MVT::i32, 32, 
/*3654*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                          MVT::f64, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f64 3215:iPTR, (intrinsic_wo_chain:f64 3212:iPTR, (fpimm:f64)<<P:Predicate_immDouble0>>, Float64Regs:f64:$a), (fpimm:f64)<<P:Predicate_immDouble1>>) - Complexity = 24
                      // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 32:i32)
/*3662*/            /*Scope*/ 27, /*->3690*/
/*3663*/              OPC_RecordChild1, // #0 = $a
/*3664*/              OPC_MoveChild2,
/*3665*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3668*/              OPC_CheckPredicate, 3, // Predicate_immDouble0
/*3670*/              OPC_MoveParent,
/*3671*/              OPC_MoveParent,
/*3672*/              OPC_MoveChild2,
/*3673*/              OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*3676*/              OPC_CheckPredicate, 2, // Predicate_immDouble1
/*3678*/              OPC_MoveParent,
/*3679*/              OPC_EmitInteger, MVT::i32, 32, 
/*3682*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                          MVT::f64, 2/*#Ops*/, 0, 1, 
                      // Src: (intrinsic_wo_chain:f64 3215:iPTR, (intrinsic_wo_chain:f64 3212:iPTR, Float64Regs:f64:$a, (fpimm:f64)<<P:Predicate_immDouble0>>), (fpimm:f64)<<P:Predicate_immDouble1>>) - Complexity = 24
                      // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 32:i32)
/*3690*/            0, /*End of Scope*/
/*3691*/          0, // EndSwitchOpcode
/*3692*/        /*Scope*/ 10, /*->3703*/
/*3693*/          OPC_RecordChild1, // #0 = $src0
/*3694*/          OPC_RecordChild2, // #1 = $src1
/*3695*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMIN_D), 0,
                      MVT::f64, 2/*#Ops*/, 0, 1, 
                  // Src: (intrinsic_wo_chain:f64 3215:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                  // Dst: (INT_NVVM_FMIN_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*3703*/        0, /*End of Scope*/
/*3704*/      /*Scope*/ 78, /*->3783*/
/*3705*/        OPC_CheckChild0Integer, 56|128,26/*3384*/, 
/*3708*/        OPC_RecordChild1, // #0 = $src
/*3709*/        OPC_RecordChild2, // #1 = $offset
/*3710*/        OPC_Scope, 39, /*->3751*/ // 2 children in Scope
/*3712*/          OPC_MoveChild2,
/*3713*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3716*/          OPC_MoveParent,
/*3717*/          OPC_RecordChild3, // #2 = $mask
/*3718*/          OPC_Scope, 18, /*->3738*/ // 2 children in Scope
/*3720*/            OPC_MoveChild3,
/*3721*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3724*/            OPC_MoveParent,
/*3725*/            OPC_EmitConvertToTarget, 1,
/*3727*/            OPC_EmitConvertToTarget, 2,
/*3729*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_F32imm3), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:f32 3384:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_DOWN_F32imm3:f32 Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*3738*/          /*Scope*/ 11, /*->3750*/
/*3739*/            OPC_EmitConvertToTarget, 1,
/*3741*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_F32imm1), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:f32 3384:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_DOWN_F32imm1:f32 Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*3750*/          0, /*End of Scope*/
/*3751*/        /*Scope*/ 30, /*->3782*/
/*3752*/          OPC_RecordChild3, // #2 = $mask
/*3753*/          OPC_Scope, 16, /*->3771*/ // 2 children in Scope
/*3755*/            OPC_MoveChild3,
/*3756*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3759*/            OPC_MoveParent,
/*3760*/            OPC_EmitConvertToTarget, 2,
/*3762*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_F32imm2), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:f32 3384:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_DOWN_F32imm2:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*3771*/          /*Scope*/ 9, /*->3781*/
/*3772*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_DOWN_F32reg), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:f32 3384:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_DOWN_F32reg:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*3781*/          0, /*End of Scope*/
/*3782*/        0, /*End of Scope*/
/*3783*/      /*Scope*/ 78, /*->3862*/
/*3784*/        OPC_CheckChild0Integer, 60|128,26/*3388*/, 
/*3787*/        OPC_RecordChild1, // #0 = $src
/*3788*/        OPC_RecordChild2, // #1 = $offset
/*3789*/        OPC_Scope, 39, /*->3830*/ // 2 children in Scope
/*3791*/          OPC_MoveChild2,
/*3792*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3795*/          OPC_MoveParent,
/*3796*/          OPC_RecordChild3, // #2 = $mask
/*3797*/          OPC_Scope, 18, /*->3817*/ // 2 children in Scope
/*3799*/            OPC_MoveChild3,
/*3800*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3803*/            OPC_MoveParent,
/*3804*/            OPC_EmitConvertToTarget, 1,
/*3806*/            OPC_EmitConvertToTarget, 2,
/*3808*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_F32imm3), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:f32 3388:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_UP_F32imm3:f32 Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*3817*/          /*Scope*/ 11, /*->3829*/
/*3818*/            OPC_EmitConvertToTarget, 1,
/*3820*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_F32imm1), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:f32 3388:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_UP_F32imm1:f32 Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*3829*/          0, /*End of Scope*/
/*3830*/        /*Scope*/ 30, /*->3861*/
/*3831*/          OPC_RecordChild3, // #2 = $mask
/*3832*/          OPC_Scope, 16, /*->3850*/ // 2 children in Scope
/*3834*/            OPC_MoveChild3,
/*3835*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3838*/            OPC_MoveParent,
/*3839*/            OPC_EmitConvertToTarget, 2,
/*3841*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_F32imm2), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:f32 3388:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_UP_F32imm2:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*3850*/          /*Scope*/ 9, /*->3860*/
/*3851*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_UP_F32reg), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:f32 3388:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_UP_F32reg:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*3860*/          0, /*End of Scope*/
/*3861*/        0, /*End of Scope*/
/*3862*/      /*Scope*/ 78, /*->3941*/
/*3863*/        OPC_CheckChild0Integer, 54|128,26/*3382*/, 
/*3866*/        OPC_RecordChild1, // #0 = $src
/*3867*/        OPC_RecordChild2, // #1 = $offset
/*3868*/        OPC_Scope, 39, /*->3909*/ // 2 children in Scope
/*3870*/          OPC_MoveChild2,
/*3871*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3874*/          OPC_MoveParent,
/*3875*/          OPC_RecordChild3, // #2 = $mask
/*3876*/          OPC_Scope, 18, /*->3896*/ // 2 children in Scope
/*3878*/            OPC_MoveChild3,
/*3879*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3882*/            OPC_MoveParent,
/*3883*/            OPC_EmitConvertToTarget, 1,
/*3885*/            OPC_EmitConvertToTarget, 2,
/*3887*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_F32imm3), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:f32 3382:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_BFLY_F32imm3:f32 Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*3896*/          /*Scope*/ 11, /*->3908*/
/*3897*/            OPC_EmitConvertToTarget, 1,
/*3899*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_F32imm1), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:f32 3382:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_BFLY_F32imm1:f32 Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*3908*/          0, /*End of Scope*/
/*3909*/        /*Scope*/ 30, /*->3940*/
/*3910*/          OPC_RecordChild3, // #2 = $mask
/*3911*/          OPC_Scope, 16, /*->3929*/ // 2 children in Scope
/*3913*/            OPC_MoveChild3,
/*3914*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3917*/            OPC_MoveParent,
/*3918*/            OPC_EmitConvertToTarget, 2,
/*3920*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_F32imm2), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:f32 3382:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_BFLY_F32imm2:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*3929*/          /*Scope*/ 9, /*->3939*/
/*3930*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_BFLY_F32reg), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:f32 3382:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_BFLY_F32reg:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*3939*/          0, /*End of Scope*/
/*3940*/        0, /*End of Scope*/
/*3941*/      /*Scope*/ 78, /*->4020*/
/*3942*/        OPC_CheckChild0Integer, 58|128,26/*3386*/, 
/*3945*/        OPC_RecordChild1, // #0 = $src
/*3946*/        OPC_RecordChild2, // #1 = $offset
/*3947*/        OPC_Scope, 39, /*->3988*/ // 2 children in Scope
/*3949*/          OPC_MoveChild2,
/*3950*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3953*/          OPC_MoveParent,
/*3954*/          OPC_RecordChild3, // #2 = $mask
/*3955*/          OPC_Scope, 18, /*->3975*/ // 2 children in Scope
/*3957*/            OPC_MoveChild3,
/*3958*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3961*/            OPC_MoveParent,
/*3962*/            OPC_EmitConvertToTarget, 1,
/*3964*/            OPC_EmitConvertToTarget, 2,
/*3966*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_F32imm3), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 4, 
                    // Src: (intrinsic_wo_chain:f32 3386:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask) - Complexity = 14
                    // Dst: (INT_SHFL_IDX_F32imm3:f32 Float32Regs:f32:$src, (imm:i32):$offset, (imm:i32):$mask)
/*3975*/          /*Scope*/ 11, /*->3987*/
/*3976*/            OPC_EmitConvertToTarget, 1,
/*3978*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_F32imm1), 0,
                        MVT::f32, 3/*#Ops*/, 0, 3, 2, 
                    // Src: (intrinsic_wo_chain:f32 3386:iPTR, Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask) - Complexity = 11
                    // Dst: (INT_SHFL_IDX_F32imm1:f32 Float32Regs:f32:$src, (imm:i32):$offset, Int32Regs:i32:$mask)
/*3987*/          0, /*End of Scope*/
/*3988*/        /*Scope*/ 30, /*->4019*/
/*3989*/          OPC_RecordChild3, // #2 = $mask
/*3990*/          OPC_Scope, 16, /*->4008*/ // 2 children in Scope
/*3992*/            OPC_MoveChild3,
/*3993*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3996*/            OPC_MoveParent,
/*3997*/            OPC_EmitConvertToTarget, 2,
/*3999*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_F32imm2), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 3, 
                    // Src: (intrinsic_wo_chain:f32 3386:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask) - Complexity = 11
                    // Dst: (INT_SHFL_IDX_F32imm2:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, (imm:i32):$mask)
/*4008*/          /*Scope*/ 9, /*->4018*/
/*4009*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_SHFL_IDX_F32reg), 0,
                        MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (intrinsic_wo_chain:f32 3386:iPTR, Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask) - Complexity = 8
                    // Dst: (INT_SHFL_IDX_F32reg:f32 Float32Regs:f32:$src, Int32Regs:i32:$offset, Int32Regs:i32:$mask)
/*4018*/          0, /*End of Scope*/
/*4019*/        0, /*End of Scope*/
/*4020*/      /*Scope*/ 13, /*->4034*/
/*4021*/        OPC_CheckChild0Integer, 17|128,25/*3217*/, 
/*4024*/        OPC_RecordChild1, // #0 = $src0
/*4025*/        OPC_RecordChild2, // #1 = $src1
/*4026*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMIN_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3217:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_FMIN_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4034*/      /*Scope*/ 13, /*->4048*/
/*4035*/        OPC_CheckChild0Integer, 13|128,25/*3213*/, 
/*4038*/        OPC_RecordChild1, // #0 = $src0
/*4039*/        OPC_RecordChild2, // #1 = $src1
/*4040*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMAX_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3213:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_FMAX_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4048*/      /*Scope*/ 13, /*->4062*/
/*4049*/        OPC_CheckChild0Integer, 14|128,25/*3214*/, 
/*4052*/        OPC_RecordChild1, // #0 = $src0
/*4053*/        OPC_RecordChild2, // #1 = $src1
/*4054*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMAX_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3214:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_FMAX_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4062*/      /*Scope*/ 13, /*->4076*/
/*4063*/        OPC_CheckChild0Integer, 12|128,25/*3212*/, 
/*4066*/        OPC_RecordChild1, // #0 = $src0
/*4067*/        OPC_RecordChild2, // #1 = $src1
/*4068*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMAX_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3212:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_FMAX_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4076*/      /*Scope*/ 13, /*->4090*/
/*4077*/        OPC_CheckChild0Integer, 65|128,25/*3265*/, 
/*4080*/        OPC_RecordChild1, // #0 = $src0
/*4081*/        OPC_RecordChild2, // #1 = $src1
/*4082*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RN_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3265:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RN_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4090*/      /*Scope*/ 13, /*->4104*/
/*4091*/        OPC_CheckChild0Integer, 64|128,25/*3264*/, 
/*4094*/        OPC_RecordChild1, // #0 = $src0
/*4095*/        OPC_RecordChild2, // #1 = $src1
/*4096*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RN_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3264:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RN_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4104*/      /*Scope*/ 13, /*->4118*/
/*4105*/        OPC_CheckChild0Integer, 71|128,25/*3271*/, 
/*4108*/        OPC_RecordChild1, // #0 = $src0
/*4109*/        OPC_RecordChild2, // #1 = $src1
/*4110*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RZ_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3271:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RZ_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4118*/      /*Scope*/ 13, /*->4132*/
/*4119*/        OPC_CheckChild0Integer, 70|128,25/*3270*/, 
/*4122*/        OPC_RecordChild1, // #0 = $src0
/*4123*/        OPC_RecordChild2, // #1 = $src1
/*4124*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3270:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4132*/      /*Scope*/ 13, /*->4146*/
/*4133*/        OPC_CheckChild0Integer, 62|128,25/*3262*/, 
/*4136*/        OPC_RecordChild1, // #0 = $src0
/*4137*/        OPC_RecordChild2, // #1 = $src1
/*4138*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RM_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3262:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RM_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4146*/      /*Scope*/ 13, /*->4160*/
/*4147*/        OPC_CheckChild0Integer, 61|128,25/*3261*/, 
/*4150*/        OPC_RecordChild1, // #0 = $src0
/*4151*/        OPC_RecordChild2, // #1 = $src1
/*4152*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RM_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3261:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RM_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4160*/      /*Scope*/ 13, /*->4174*/
/*4161*/        OPC_CheckChild0Integer, 68|128,25/*3268*/, 
/*4164*/        OPC_RecordChild1, // #0 = $src0
/*4165*/        OPC_RecordChild2, // #1 = $src1
/*4166*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RP_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3268:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RP_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4174*/      /*Scope*/ 13, /*->4188*/
/*4175*/        OPC_CheckChild0Integer, 67|128,25/*3267*/, 
/*4178*/        OPC_RecordChild1, // #0 = $src0
/*4179*/        OPC_RecordChild2, // #1 = $src1
/*4180*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RP_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3267:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RP_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4188*/      /*Scope*/ 13, /*->4202*/
/*4189*/        OPC_CheckChild0Integer, 63|128,25/*3263*/, 
/*4192*/        OPC_RecordChild1, // #0 = $src0
/*4193*/        OPC_RecordChild2, // #1 = $src1
/*4194*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RN_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3263:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RN_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4202*/      /*Scope*/ 13, /*->4216*/
/*4203*/        OPC_CheckChild0Integer, 69|128,25/*3269*/, 
/*4206*/        OPC_RecordChild1, // #0 = $src0
/*4207*/        OPC_RecordChild2, // #1 = $src1
/*4208*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RZ_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3269:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RZ_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4216*/      /*Scope*/ 13, /*->4230*/
/*4217*/        OPC_CheckChild0Integer, 60|128,25/*3260*/, 
/*4220*/        OPC_RecordChild1, // #0 = $src0
/*4221*/        OPC_RecordChild2, // #1 = $src1
/*4222*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RM_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3260:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RM_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4230*/      /*Scope*/ 13, /*->4244*/
/*4231*/        OPC_CheckChild0Integer, 66|128,25/*3266*/, 
/*4234*/        OPC_RecordChild1, // #0 = $src0
/*4235*/        OPC_RecordChild2, // #1 = $src1
/*4236*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_MUL_RP_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3266:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_MUL_RP_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4244*/      /*Scope*/ 13, /*->4258*/
/*4245*/        OPC_CheckChild0Integer, 72|128,24/*3144*/, 
/*4248*/        OPC_RecordChild1, // #0 = $src0
/*4249*/        OPC_RecordChild2, // #1 = $src1
/*4250*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_APPROX_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3144:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_APPROX_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4258*/      /*Scope*/ 13, /*->4272*/
/*4259*/        OPC_CheckChild0Integer, 71|128,24/*3143*/, 
/*4262*/        OPC_RecordChild1, // #0 = $src0
/*4263*/        OPC_RecordChild2, // #1 = $src1
/*4264*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_APPROX_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3143:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_APPROX_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4272*/      /*Scope*/ 13, /*->4286*/
/*4273*/        OPC_CheckChild0Integer, 78|128,24/*3150*/, 
/*4276*/        OPC_RecordChild1, // #0 = $src0
/*4277*/        OPC_RecordChild2, // #1 = $src1
/*4278*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RN_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3150:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RN_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4286*/      /*Scope*/ 13, /*->4300*/
/*4287*/        OPC_CheckChild0Integer, 77|128,24/*3149*/, 
/*4290*/        OPC_RecordChild1, // #0 = $src0
/*4291*/        OPC_RecordChild2, // #1 = $src1
/*4292*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RN_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3149:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RN_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4300*/      /*Scope*/ 13, /*->4314*/
/*4301*/        OPC_CheckChild0Integer, 84|128,24/*3156*/, 
/*4304*/        OPC_RecordChild1, // #0 = $src0
/*4305*/        OPC_RecordChild2, // #1 = $src1
/*4306*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RZ_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3156:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RZ_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4314*/      /*Scope*/ 13, /*->4328*/
/*4315*/        OPC_CheckChild0Integer, 83|128,24/*3155*/, 
/*4318*/        OPC_RecordChild1, // #0 = $src0
/*4319*/        OPC_RecordChild2, // #1 = $src1
/*4320*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3155:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4328*/      /*Scope*/ 13, /*->4342*/
/*4329*/        OPC_CheckChild0Integer, 75|128,24/*3147*/, 
/*4332*/        OPC_RecordChild1, // #0 = $src0
/*4333*/        OPC_RecordChild2, // #1 = $src1
/*4334*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RM_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3147:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RM_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4342*/      /*Scope*/ 13, /*->4356*/
/*4343*/        OPC_CheckChild0Integer, 74|128,24/*3146*/, 
/*4346*/        OPC_RecordChild1, // #0 = $src0
/*4347*/        OPC_RecordChild2, // #1 = $src1
/*4348*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RM_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3146:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RM_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4356*/      /*Scope*/ 13, /*->4370*/
/*4357*/        OPC_CheckChild0Integer, 81|128,24/*3153*/, 
/*4360*/        OPC_RecordChild1, // #0 = $src0
/*4361*/        OPC_RecordChild2, // #1 = $src1
/*4362*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RP_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3153:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RP_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4370*/      /*Scope*/ 13, /*->4384*/
/*4371*/        OPC_CheckChild0Integer, 80|128,24/*3152*/, 
/*4374*/        OPC_RecordChild1, // #0 = $src0
/*4375*/        OPC_RecordChild2, // #1 = $src1
/*4376*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RP_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3152:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RP_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*4384*/      /*Scope*/ 13, /*->4398*/
/*4385*/        OPC_CheckChild0Integer, 76|128,24/*3148*/, 
/*4388*/        OPC_RecordChild1, // #0 = $src0
/*4389*/        OPC_RecordChild2, // #1 = $src1
/*4390*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RN_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3148:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RN_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4398*/      /*Scope*/ 13, /*->4412*/
/*4399*/        OPC_CheckChild0Integer, 82|128,24/*3154*/, 
/*4402*/        OPC_RecordChild1, // #0 = $src0
/*4403*/        OPC_RecordChild2, // #1 = $src1
/*4404*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RZ_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3154:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RZ_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4412*/      /*Scope*/ 13, /*->4426*/
/*4413*/        OPC_CheckChild0Integer, 73|128,24/*3145*/, 
/*4416*/        OPC_RecordChild1, // #0 = $src0
/*4417*/        OPC_RecordChild2, // #1 = $src1
/*4418*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RM_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3145:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RM_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4426*/      /*Scope*/ 13, /*->4440*/
/*4427*/        OPC_CheckChild0Integer, 79|128,24/*3151*/, 
/*4430*/        OPC_RecordChild1, // #0 = $src0
/*4431*/        OPC_RecordChild2, // #1 = $src1
/*4432*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_DIV_RP_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3151:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_DIV_RP_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*4440*/      /*Scope*/ 15, /*->4456*/
/*4441*/        OPC_CheckChild0Integer, 127|128,24/*3199*/, 
/*4444*/        OPC_RecordChild1, // #0 = $a
/*4445*/        OPC_EmitInteger, MVT::i32, 19, 
/*4448*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3199:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 19:i32)
/*4456*/      /*Scope*/ 15, /*->4472*/
/*4457*/        OPC_CheckChild0Integer, 126|128,24/*3198*/, 
/*4460*/        OPC_RecordChild1, // #0 = $a
/*4461*/        OPC_EmitInteger, MVT::i32, 3, 
/*4464*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3198:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 3:i32)
/*4472*/      /*Scope*/ 15, /*->4488*/
/*4473*/        OPC_CheckChild0Integer, 125|128,24/*3197*/, 
/*4476*/        OPC_RecordChild1, // #0 = $a
/*4477*/        OPC_EmitInteger, MVT::i32, 3, 
/*4480*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3197:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 3:i32)
/*4488*/      /*Scope*/ 15, /*->4504*/
/*4489*/        OPC_CheckChild0Integer, 40|128,24/*3112*/, 
/*4492*/        OPC_RecordChild1, // #0 = $a
/*4493*/        OPC_EmitInteger, MVT::i32, 20, 
/*4496*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3112:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 20:i32)
/*4504*/      /*Scope*/ 15, /*->4520*/
/*4505*/        OPC_CheckChild0Integer, 39|128,24/*3111*/, 
/*4508*/        OPC_RecordChild1, // #0 = $a
/*4509*/        OPC_EmitInteger, MVT::i32, 4, 
/*4512*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3111:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 4:i32)
/*4520*/      /*Scope*/ 15, /*->4536*/
/*4521*/        OPC_CheckChild0Integer, 38|128,24/*3110*/, 
/*4524*/        OPC_RecordChild1, // #0 = $a
/*4525*/        OPC_EmitInteger, MVT::i32, 4, 
/*4528*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3110:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 4:i32)
/*4536*/      /*Scope*/ 11, /*->4548*/
/*4537*/        OPC_CheckChild0Integer, 124|128,24/*3196*/, 
/*4540*/        OPC_RecordChild1, // #0 = $src0
/*4541*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FABS_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3196:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_FABS_FTZ_F:f32 Float32Regs:f32:$src0)
/*4548*/      /*Scope*/ 11, /*->4560*/
/*4549*/        OPC_CheckChild0Integer, 123|128,24/*3195*/, 
/*4552*/        OPC_RecordChild1, // #0 = $src0
/*4553*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FABS_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3195:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_FABS_F:f32 Float32Regs:f32:$src0)
/*4560*/      /*Scope*/ 11, /*->4572*/
/*4561*/        OPC_CheckChild0Integer, 122|128,24/*3194*/, 
/*4564*/        OPC_RecordChild1, // #0 = $src0
/*4565*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FABS_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3194:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_FABS_D:f64 Float64Regs:f64:$src0)
/*4572*/      /*Scope*/ 15, /*->4588*/
/*4573*/        OPC_CheckChild0Integer, 45|128,26/*3373*/, 
/*4576*/        OPC_RecordChild1, // #0 = $a
/*4577*/        OPC_EmitInteger, MVT::i32, 17, 
/*4580*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3373:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 17:i32)
/*4588*/      /*Scope*/ 15, /*->4604*/
/*4589*/        OPC_CheckChild0Integer, 44|128,26/*3372*/, 
/*4592*/        OPC_RecordChild1, // #0 = $a
/*4593*/        OPC_EmitInteger, MVT::i32, 1, 
/*4596*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3372:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 1:i32)
/*4604*/      /*Scope*/ 15, /*->4620*/
/*4605*/        OPC_CheckChild0Integer, 43|128,26/*3371*/, 
/*4608*/        OPC_RecordChild1, // #0 = $a
/*4609*/        OPC_EmitInteger, MVT::i32, 1, 
/*4612*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3371:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 1:i32)
/*4620*/      /*Scope*/ 15, /*->4636*/
/*4621*/        OPC_CheckChild0Integer, 121|128,30/*3961*/, 
/*4624*/        OPC_RecordChild1, // #0 = $a
/*4625*/        OPC_EmitInteger, MVT::i32, 18, 
/*4628*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3961:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 18:i32)
/*4636*/      /*Scope*/ 15, /*->4652*/
/*4637*/        OPC_CheckChild0Integer, 120|128,30/*3960*/, 
/*4640*/        OPC_RecordChild1, // #0 = $a
/*4641*/        OPC_EmitInteger, MVT::i32, 2, 
/*4644*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3960:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 2:i32)
/*4652*/      /*Scope*/ 15, /*->4668*/
/*4653*/        OPC_CheckChild0Integer, 119|128,30/*3959*/, 
/*4656*/        OPC_RecordChild1, // #0 = $a
/*4657*/        OPC_EmitInteger, MVT::i32, 2, 
/*4660*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3959:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 2:i32)
/*4668*/      /*Scope*/ 15, /*->4684*/
/*4669*/        OPC_CheckChild0Integer, 53|128,26/*3381*/, 
/*4672*/        OPC_RecordChild1, // #0 = $a
/*4673*/        OPC_EmitInteger, MVT::i32, 48, 
/*4676*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3381:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 48:i32)
/*4684*/      /*Scope*/ 15, /*->4700*/
/*4685*/        OPC_CheckChild0Integer, 52|128,26/*3380*/, 
/*4688*/        OPC_RecordChild1, // #0 = $a
/*4689*/        OPC_EmitInteger, MVT::i32, 32, 
/*4692*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3380:iPTR, Float32Regs:f32:$a) - Complexity = 8
                // Dst: (CVT_f32_f32:f32 Float32Regs:f32:$a, 32:i32)
/*4700*/      /*Scope*/ 15, /*->4716*/
/*4701*/        OPC_CheckChild0Integer, 51|128,26/*3379*/, 
/*4704*/        OPC_RecordChild1, // #0 = $a
/*4705*/        OPC_EmitInteger, MVT::i32, 32, 
/*4708*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_f64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3379:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f64_f64:f64 Float64Regs:f64:$a, 32:i32)
/*4716*/      /*Scope*/ 11, /*->4728*/
/*4717*/        OPC_CheckChild0Integer, 87|128,24/*3159*/, 
/*4720*/        OPC_RecordChild1, // #0 = $src0
/*4721*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_EX2_APPROX_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3159:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_EX2_APPROX_FTZ_F:f32 Float32Regs:f32:$src0)
/*4728*/      /*Scope*/ 11, /*->4740*/
/*4729*/        OPC_CheckChild0Integer, 86|128,24/*3158*/, 
/*4732*/        OPC_RecordChild1, // #0 = $src0
/*4733*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_EX2_APPROX_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3158:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_EX2_APPROX_F:f32 Float32Regs:f32:$src0)
/*4740*/      /*Scope*/ 11, /*->4752*/
/*4741*/        OPC_CheckChild0Integer, 85|128,24/*3157*/, 
/*4744*/        OPC_RecordChild1, // #0 = $src0
/*4745*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_EX2_APPROX_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3157:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_EX2_APPROX_D:f64 Float64Regs:f64:$src0)
/*4752*/      /*Scope*/ 11, /*->4764*/
/*4753*/        OPC_CheckChild0Integer, 41|128,25/*3241*/, 
/*4756*/        OPC_RecordChild1, // #0 = $src0
/*4757*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_LG2_APPROX_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3241:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_LG2_APPROX_FTZ_F:f32 Float32Regs:f32:$src0)
/*4764*/      /*Scope*/ 11, /*->4776*/
/*4765*/        OPC_CheckChild0Integer, 40|128,25/*3240*/, 
/*4768*/        OPC_RecordChild1, // #0 = $src0
/*4769*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_LG2_APPROX_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3240:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_LG2_APPROX_F:f32 Float32Regs:f32:$src0)
/*4776*/      /*Scope*/ 11, /*->4788*/
/*4777*/        OPC_CheckChild0Integer, 39|128,25/*3239*/, 
/*4780*/        OPC_RecordChild1, // #0 = $src0
/*4781*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_LG2_APPROX_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3239:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_LG2_APPROX_D:f64 Float64Regs:f64:$src0)
/*4788*/      /*Scope*/ 11, /*->4800*/
/*4789*/        OPC_CheckChild0Integer, 63|128,26/*3391*/, 
/*4792*/        OPC_RecordChild1, // #0 = $src0
/*4793*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SIN_APPROX_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3391:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SIN_APPROX_FTZ_F:f32 Float32Regs:f32:$src0)
/*4800*/      /*Scope*/ 11, /*->4812*/
/*4801*/        OPC_CheckChild0Integer, 62|128,26/*3390*/, 
/*4804*/        OPC_RecordChild1, // #0 = $src0
/*4805*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SIN_APPROX_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3390:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SIN_APPROX_F:f32 Float32Regs:f32:$src0)
/*4812*/      /*Scope*/ 11, /*->4824*/
/*4813*/        OPC_CheckChild0Integer, 44|128,24/*3116*/, 
/*4816*/        OPC_RecordChild1, // #0 = $src0
/*4817*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_COS_APPROX_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3116:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_COS_APPROX_FTZ_F:f32 Float32Regs:f32:$src0)
/*4824*/      /*Scope*/ 11, /*->4836*/
/*4825*/        OPC_CheckChild0Integer, 43|128,24/*3115*/, 
/*4828*/        OPC_RecordChild1, // #0 = $src0
/*4829*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_COS_APPROX_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3115:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_COS_APPROX_F:f32 Float32Regs:f32:$src0)
/*4836*/      /*Scope*/ 15, /*->4852*/
/*4837*/        OPC_CheckChild0Integer, 5|128,25/*3205*/, 
/*4840*/        OPC_RecordChild1, // #0 = $src0
/*4841*/        OPC_RecordChild2, // #1 = $src1
/*4842*/        OPC_RecordChild3, // #2 = $src2
/*4843*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RN_FTZ_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3205:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RN_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4852*/      /*Scope*/ 15, /*->4868*/
/*4853*/        OPC_CheckChild0Integer, 4|128,25/*3204*/, 
/*4856*/        OPC_RecordChild1, // #0 = $src0
/*4857*/        OPC_RecordChild2, // #1 = $src1
/*4858*/        OPC_RecordChild3, // #2 = $src2
/*4859*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RN_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3204:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RN_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4868*/      /*Scope*/ 15, /*->4884*/
/*4869*/        OPC_CheckChild0Integer, 11|128,25/*3211*/, 
/*4872*/        OPC_RecordChild1, // #0 = $src0
/*4873*/        OPC_RecordChild2, // #1 = $src1
/*4874*/        OPC_RecordChild3, // #2 = $src2
/*4875*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RZ_FTZ_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3211:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RZ_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4884*/      /*Scope*/ 15, /*->4900*/
/*4885*/        OPC_CheckChild0Integer, 10|128,25/*3210*/, 
/*4888*/        OPC_RecordChild1, // #0 = $src0
/*4889*/        OPC_RecordChild2, // #1 = $src1
/*4890*/        OPC_RecordChild3, // #2 = $src2
/*4891*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RZ_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3210:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4900*/      /*Scope*/ 15, /*->4916*/
/*4901*/        OPC_CheckChild0Integer, 2|128,25/*3202*/, 
/*4904*/        OPC_RecordChild1, // #0 = $src0
/*4905*/        OPC_RecordChild2, // #1 = $src1
/*4906*/        OPC_RecordChild3, // #2 = $src2
/*4907*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RM_FTZ_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3202:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RM_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4916*/      /*Scope*/ 15, /*->4932*/
/*4917*/        OPC_CheckChild0Integer, 1|128,25/*3201*/, 
/*4920*/        OPC_RecordChild1, // #0 = $src0
/*4921*/        OPC_RecordChild2, // #1 = $src1
/*4922*/        OPC_RecordChild3, // #2 = $src2
/*4923*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RM_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3201:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RM_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4932*/      /*Scope*/ 15, /*->4948*/
/*4933*/        OPC_CheckChild0Integer, 8|128,25/*3208*/, 
/*4936*/        OPC_RecordChild1, // #0 = $src0
/*4937*/        OPC_RecordChild2, // #1 = $src1
/*4938*/        OPC_RecordChild3, // #2 = $src2
/*4939*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RP_FTZ_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3208:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RP_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4948*/      /*Scope*/ 15, /*->4964*/
/*4949*/        OPC_CheckChild0Integer, 7|128,25/*3207*/, 
/*4952*/        OPC_RecordChild1, // #0 = $src0
/*4953*/        OPC_RecordChild2, // #1 = $src1
/*4954*/        OPC_RecordChild3, // #2 = $src2
/*4955*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RP_F), 0,
                    MVT::f32, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f32 3207:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RP_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1, Float32Regs:f32:$src2)
/*4964*/      /*Scope*/ 15, /*->4980*/
/*4965*/        OPC_CheckChild0Integer, 3|128,25/*3203*/, 
/*4968*/        OPC_RecordChild1, // #0 = $src0
/*4969*/        OPC_RecordChild2, // #1 = $src1
/*4970*/        OPC_RecordChild3, // #2 = $src2
/*4971*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RN_D), 0,
                    MVT::f64, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f64 3203:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RN_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2)
/*4980*/      /*Scope*/ 15, /*->4996*/
/*4981*/        OPC_CheckChild0Integer, 9|128,25/*3209*/, 
/*4984*/        OPC_RecordChild1, // #0 = $src0
/*4985*/        OPC_RecordChild2, // #1 = $src1
/*4986*/        OPC_RecordChild3, // #2 = $src2
/*4987*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RZ_D), 0,
                    MVT::f64, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f64 3209:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RZ_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2)
/*4996*/      /*Scope*/ 15, /*->5012*/
/*4997*/        OPC_CheckChild0Integer, 0|128,25/*3200*/, 
/*5000*/        OPC_RecordChild1, // #0 = $src0
/*5001*/        OPC_RecordChild2, // #1 = $src1
/*5002*/        OPC_RecordChild3, // #2 = $src2
/*5003*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RM_D), 0,
                    MVT::f64, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f64 3200:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RM_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2)
/*5012*/      /*Scope*/ 15, /*->5028*/
/*5013*/        OPC_CheckChild0Integer, 6|128,25/*3206*/, 
/*5016*/        OPC_RecordChild1, // #0 = $src0
/*5017*/        OPC_RecordChild2, // #1 = $src1
/*5018*/        OPC_RecordChild3, // #2 = $src2
/*5019*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_FMA_RP_D), 0,
                    MVT::f64, 3/*#Ops*/, 0, 1, 2, 
                // Src: (intrinsic_wo_chain:f64 3206:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2) - Complexity = 8
                // Dst: (INT_NVVM_FMA_RP_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1, Float64Regs:f64:$src2)
/*5028*/      /*Scope*/ 11, /*->5040*/
/*5029*/        OPC_CheckChild0Integer, 94|128,25/*3294*/, 
/*5032*/        OPC_RecordChild1, // #0 = $src0
/*5033*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RN_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3294:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RN_FTZ_F:f32 Float32Regs:f32:$src0)
/*5040*/      /*Scope*/ 11, /*->5052*/
/*5041*/        OPC_CheckChild0Integer, 93|128,25/*3293*/, 
/*5044*/        OPC_RecordChild1, // #0 = $src0
/*5045*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RN_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3293:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RN_F:f32 Float32Regs:f32:$src0)
/*5052*/      /*Scope*/ 11, /*->5064*/
/*5053*/        OPC_CheckChild0Integer, 100|128,25/*3300*/, 
/*5056*/        OPC_RecordChild1, // #0 = $src0
/*5057*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RZ_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3300:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RZ_FTZ_F:f32 Float32Regs:f32:$src0)
/*5064*/      /*Scope*/ 11, /*->5076*/
/*5065*/        OPC_CheckChild0Integer, 99|128,25/*3299*/, 
/*5068*/        OPC_RecordChild1, // #0 = $src0
/*5069*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3299:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RZ_F:f32 Float32Regs:f32:$src0)
/*5076*/      /*Scope*/ 11, /*->5088*/
/*5077*/        OPC_CheckChild0Integer, 91|128,25/*3291*/, 
/*5080*/        OPC_RecordChild1, // #0 = $src0
/*5081*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RM_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3291:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RM_FTZ_F:f32 Float32Regs:f32:$src0)
/*5088*/      /*Scope*/ 11, /*->5100*/
/*5089*/        OPC_CheckChild0Integer, 90|128,25/*3290*/, 
/*5092*/        OPC_RecordChild1, // #0 = $src0
/*5093*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RM_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3290:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RM_F:f32 Float32Regs:f32:$src0)
/*5100*/      /*Scope*/ 11, /*->5112*/
/*5101*/        OPC_CheckChild0Integer, 97|128,25/*3297*/, 
/*5104*/        OPC_RecordChild1, // #0 = $src0
/*5105*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RP_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3297:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RP_FTZ_F:f32 Float32Regs:f32:$src0)
/*5112*/      /*Scope*/ 11, /*->5124*/
/*5113*/        OPC_CheckChild0Integer, 96|128,25/*3296*/, 
/*5116*/        OPC_RecordChild1, // #0 = $src0
/*5117*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RP_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3296:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RP_F:f32 Float32Regs:f32:$src0)
/*5124*/      /*Scope*/ 11, /*->5136*/
/*5125*/        OPC_CheckChild0Integer, 92|128,25/*3292*/, 
/*5128*/        OPC_RecordChild1, // #0 = $src0
/*5129*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RN_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3292:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RN_D:f64 Float64Regs:f64:$src0)
/*5136*/      /*Scope*/ 11, /*->5148*/
/*5137*/        OPC_CheckChild0Integer, 98|128,25/*3298*/, 
/*5140*/        OPC_RecordChild1, // #0 = $src0
/*5141*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RZ_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3298:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RZ_D:f64 Float64Regs:f64:$src0)
/*5148*/      /*Scope*/ 11, /*->5160*/
/*5149*/        OPC_CheckChild0Integer, 89|128,25/*3289*/, 
/*5152*/        OPC_RecordChild1, // #0 = $src0
/*5153*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RM_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3289:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RM_D:f64 Float64Regs:f64:$src0)
/*5160*/      /*Scope*/ 11, /*->5172*/
/*5161*/        OPC_CheckChild0Integer, 95|128,25/*3295*/, 
/*5164*/        OPC_RecordChild1, // #0 = $src0
/*5165*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_RP_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3295:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_RP_D:f64 Float64Regs:f64:$src0)
/*5172*/      /*Scope*/ 11, /*->5184*/
/*5173*/        OPC_CheckChild0Integer, 88|128,25/*3288*/, 
/*5176*/        OPC_RecordChild1, // #0 = $src0
/*5177*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RCP_APPROX_FTZ_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3288:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RCP_APPROX_FTZ_D:f64 Float64Regs:f64:$src0)
/*5184*/      /*Scope*/ 11, /*->5196*/
/*5185*/        OPC_CheckChild0Integer, 72|128,26/*3400*/, 
/*5188*/        OPC_RecordChild1, // #0 = $src0
/*5189*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RN_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3400:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RN_FTZ_F:f32 Float32Regs:f32:$src0)
/*5196*/      /*Scope*/ 11, /*->5208*/
/*5197*/        OPC_CheckChild0Integer, 71|128,26/*3399*/, 
/*5200*/        OPC_RecordChild1, // #0 = $src0
/*5201*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RN_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3399:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RN_F:f32 Float32Regs:f32:$src0)
/*5208*/      /*Scope*/ 11, /*->5220*/
/*5209*/        OPC_CheckChild0Integer, 78|128,26/*3406*/, 
/*5212*/        OPC_RecordChild1, // #0 = $src0
/*5213*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RZ_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3406:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RZ_FTZ_F:f32 Float32Regs:f32:$src0)
/*5220*/      /*Scope*/ 11, /*->5232*/
/*5221*/        OPC_CheckChild0Integer, 77|128,26/*3405*/, 
/*5224*/        OPC_RecordChild1, // #0 = $src0
/*5225*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3405:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RZ_F:f32 Float32Regs:f32:$src0)
/*5232*/      /*Scope*/ 11, /*->5244*/
/*5233*/        OPC_CheckChild0Integer, 69|128,26/*3397*/, 
/*5236*/        OPC_RecordChild1, // #0 = $src0
/*5237*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RM_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3397:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RM_FTZ_F:f32 Float32Regs:f32:$src0)
/*5244*/      /*Scope*/ 11, /*->5256*/
/*5245*/        OPC_CheckChild0Integer, 68|128,26/*3396*/, 
/*5248*/        OPC_RecordChild1, // #0 = $src0
/*5249*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RM_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3396:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RM_F:f32 Float32Regs:f32:$src0)
/*5256*/      /*Scope*/ 11, /*->5268*/
/*5257*/        OPC_CheckChild0Integer, 75|128,26/*3403*/, 
/*5260*/        OPC_RecordChild1, // #0 = $src0
/*5261*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RP_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3403:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RP_FTZ_F:f32 Float32Regs:f32:$src0)
/*5268*/      /*Scope*/ 11, /*->5280*/
/*5269*/        OPC_CheckChild0Integer, 74|128,26/*3402*/, 
/*5272*/        OPC_RecordChild1, // #0 = $src0
/*5273*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RP_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3402:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RP_F:f32 Float32Regs:f32:$src0)
/*5280*/      /*Scope*/ 11, /*->5292*/
/*5281*/        OPC_CheckChild0Integer, 65|128,26/*3393*/, 
/*5284*/        OPC_RecordChild1, // #0 = $src0
/*5285*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_APPROX_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3393:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_APPROX_FTZ_F:f32 Float32Regs:f32:$src0)
/*5292*/      /*Scope*/ 11, /*->5304*/
/*5293*/        OPC_CheckChild0Integer, 64|128,26/*3392*/, 
/*5296*/        OPC_RecordChild1, // #0 = $src0
/*5297*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_APPROX_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3392:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_APPROX_F:f32 Float32Regs:f32:$src0)
/*5304*/      /*Scope*/ 11, /*->5316*/
/*5305*/        OPC_CheckChild0Integer, 70|128,26/*3398*/, 
/*5308*/        OPC_RecordChild1, // #0 = $src0
/*5309*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RN_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3398:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RN_D:f64 Float64Regs:f64:$src0)
/*5316*/      /*Scope*/ 11, /*->5328*/
/*5317*/        OPC_CheckChild0Integer, 76|128,26/*3404*/, 
/*5320*/        OPC_RecordChild1, // #0 = $src0
/*5321*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RZ_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3404:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RZ_D:f64 Float64Regs:f64:$src0)
/*5328*/      /*Scope*/ 11, /*->5340*/
/*5329*/        OPC_CheckChild0Integer, 67|128,26/*3395*/, 
/*5332*/        OPC_RecordChild1, // #0 = $src0
/*5333*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RM_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3395:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RM_D:f64 Float64Regs:f64:$src0)
/*5340*/      /*Scope*/ 11, /*->5352*/
/*5341*/        OPC_CheckChild0Integer, 73|128,26/*3401*/, 
/*5344*/        OPC_RecordChild1, // #0 = $src0
/*5345*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RP_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3401:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_SQRT_RP_D:f64 Float64Regs:f64:$src0)
/*5352*/      /*Scope*/ 44, /*->5397*/
/*5353*/        OPC_CheckChild0Integer, 66|128,26/*3394*/, 
/*5356*/        OPC_RecordChild1, // #0 = $a
/*5357*/        OPC_Scope, 9, /*->5368*/ // 4 children in Scope
/*5359*/          OPC_CheckPatternPredicate, 4, // (useF32FTZ()) && (usePrecSqrtF32())
/*5361*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RN_FTZ_F), 0,
                      MVT::f32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:f32 3394:iPTR, Float32Regs:f32:$a) - Complexity = 8
                  // Dst: (INT_NVVM_SQRT_RN_FTZ_F:f32 Float32Regs:f32:$a)
/*5368*/        /*Scope*/ 9, /*->5378*/
/*5369*/          OPC_CheckPatternPredicate, 5, // (usePrecSqrtF32())
/*5371*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_RN_F), 0,
                      MVT::f32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:f32 3394:iPTR, Float32Regs:f32:$a) - Complexity = 8
                  // Dst: (INT_NVVM_SQRT_RN_F:f32 Float32Regs:f32:$a)
/*5378*/        /*Scope*/ 9, /*->5388*/
/*5379*/          OPC_CheckPatternPredicate, 6, // (useF32FTZ())
/*5381*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_APPROX_FTZ_F), 0,
                      MVT::f32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:f32 3394:iPTR, Float32Regs:f32:$a) - Complexity = 8
                  // Dst: (INT_NVVM_SQRT_APPROX_FTZ_F:f32 Float32Regs:f32:$a)
/*5388*/        /*Scope*/ 7, /*->5396*/
/*5389*/          OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_SQRT_APPROX_F), 0,
                      MVT::f32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:f32 3394:iPTR, Float32Regs:f32:$a) - Complexity = 8
                  // Dst: (INT_NVVM_SQRT_APPROX_F:f32 Float32Regs:f32:$a)
/*5396*/        0, /*End of Scope*/
/*5397*/      /*Scope*/ 11, /*->5409*/
/*5398*/        OPC_CheckChild0Integer, 48|128,26/*3376*/, 
/*5401*/        OPC_RecordChild1, // #0 = $src0
/*5402*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RSQRT_APPROX_FTZ_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3376:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RSQRT_APPROX_FTZ_F:f32 Float32Regs:f32:$src0)
/*5409*/      /*Scope*/ 11, /*->5421*/
/*5410*/        OPC_CheckChild0Integer, 47|128,26/*3375*/, 
/*5413*/        OPC_RecordChild1, // #0 = $src0
/*5414*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RSQRT_APPROX_F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3375:iPTR, Float32Regs:f32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RSQRT_APPROX_F:f32 Float32Regs:f32:$src0)
/*5421*/      /*Scope*/ 11, /*->5433*/
/*5422*/        OPC_CheckChild0Integer, 46|128,26/*3374*/, 
/*5425*/        OPC_RecordChild1, // #0 = $src0
/*5426*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_RSQRT_APPROX_D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3374:iPTR, Float64Regs:f64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_RSQRT_APPROX_D:f64 Float64Regs:f64:$src0)
/*5433*/      /*Scope*/ 13, /*->5447*/
/*5434*/        OPC_CheckChild0Integer, 123|128,23/*3067*/, 
/*5437*/        OPC_RecordChild1, // #0 = $src0
/*5438*/        OPC_RecordChild2, // #1 = $src1
/*5439*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RN_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3067:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RN_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5447*/      /*Scope*/ 13, /*->5461*/
/*5448*/        OPC_CheckChild0Integer, 122|128,23/*3066*/, 
/*5451*/        OPC_RecordChild1, // #0 = $src0
/*5452*/        OPC_RecordChild2, // #1 = $src1
/*5453*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RN_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3066:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RN_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5461*/      /*Scope*/ 13, /*->5475*/
/*5462*/        OPC_CheckChild0Integer, 1|128,24/*3073*/, 
/*5465*/        OPC_RecordChild1, // #0 = $src0
/*5466*/        OPC_RecordChild2, // #1 = $src1
/*5467*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RZ_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3073:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RZ_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5475*/      /*Scope*/ 13, /*->5489*/
/*5476*/        OPC_CheckChild0Integer, 0|128,24/*3072*/, 
/*5479*/        OPC_RecordChild1, // #0 = $src0
/*5480*/        OPC_RecordChild2, // #1 = $src1
/*5481*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3072:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5489*/      /*Scope*/ 13, /*->5503*/
/*5490*/        OPC_CheckChild0Integer, 120|128,23/*3064*/, 
/*5493*/        OPC_RecordChild1, // #0 = $src0
/*5494*/        OPC_RecordChild2, // #1 = $src1
/*5495*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RM_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3064:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RM_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5503*/      /*Scope*/ 13, /*->5517*/
/*5504*/        OPC_CheckChild0Integer, 119|128,23/*3063*/, 
/*5507*/        OPC_RecordChild1, // #0 = $src0
/*5508*/        OPC_RecordChild2, // #1 = $src1
/*5509*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RM_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3063:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RM_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5517*/      /*Scope*/ 13, /*->5531*/
/*5518*/        OPC_CheckChild0Integer, 126|128,23/*3070*/, 
/*5521*/        OPC_RecordChild1, // #0 = $src0
/*5522*/        OPC_RecordChild2, // #1 = $src1
/*5523*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RP_FTZ_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3070:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RP_FTZ_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5531*/      /*Scope*/ 13, /*->5545*/
/*5532*/        OPC_CheckChild0Integer, 125|128,23/*3069*/, 
/*5535*/        OPC_RecordChild1, // #0 = $src0
/*5536*/        OPC_RecordChild2, // #1 = $src1
/*5537*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RP_F), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3069:iPTR, Float32Regs:f32:$src0, Float32Regs:f32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RP_F:f32 Float32Regs:f32:$src0, Float32Regs:f32:$src1)
/*5545*/      /*Scope*/ 13, /*->5559*/
/*5546*/        OPC_CheckChild0Integer, 121|128,23/*3065*/, 
/*5549*/        OPC_RecordChild1, // #0 = $src0
/*5550*/        OPC_RecordChild2, // #1 = $src1
/*5551*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RN_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3065:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RN_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*5559*/      /*Scope*/ 13, /*->5573*/
/*5560*/        OPC_CheckChild0Integer, 127|128,23/*3071*/, 
/*5563*/        OPC_RecordChild1, // #0 = $src0
/*5564*/        OPC_RecordChild2, // #1 = $src1
/*5565*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RZ_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3071:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RZ_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*5573*/      /*Scope*/ 13, /*->5587*/
/*5574*/        OPC_CheckChild0Integer, 118|128,23/*3062*/, 
/*5577*/        OPC_RecordChild1, // #0 = $src0
/*5578*/        OPC_RecordChild2, // #1 = $src1
/*5579*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RM_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3062:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RM_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*5587*/      /*Scope*/ 13, /*->5601*/
/*5588*/        OPC_CheckChild0Integer, 124|128,23/*3068*/, 
/*5591*/        OPC_RecordChild1, // #0 = $src0
/*5592*/        OPC_RecordChild2, // #1 = $src1
/*5593*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_ADD_RP_D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3068:iPTR, Float64Regs:f64:$src0, Float64Regs:f64:$src1) - Complexity = 8
                // Dst: (INT_NVVM_ADD_RP_D:f64 Float64Regs:f64:$src0, Float64Regs:f64:$src1)
/*5601*/      /*Scope*/ 15, /*->5617*/
/*5602*/        OPC_CheckChild0Integer, 48|128,24/*3120*/, 
/*5605*/        OPC_RecordChild1, // #0 = $a
/*5606*/        OPC_EmitInteger, MVT::i32, 21, 
/*5609*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3120:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 21:i32)
/*5617*/      /*Scope*/ 15, /*->5633*/
/*5618*/        OPC_CheckChild0Integer, 47|128,24/*3119*/, 
/*5621*/        OPC_RecordChild1, // #0 = $a
/*5622*/        OPC_EmitInteger, MVT::i32, 5, 
/*5625*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3119:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 5:i32)
/*5633*/      /*Scope*/ 15, /*->5649*/
/*5634*/        OPC_CheckChild0Integer, 52|128,24/*3124*/, 
/*5637*/        OPC_RecordChild1, // #0 = $a
/*5638*/        OPC_EmitInteger, MVT::i32, 22, 
/*5641*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3124:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 22:i32)
/*5649*/      /*Scope*/ 15, /*->5665*/
/*5650*/        OPC_CheckChild0Integer, 51|128,24/*3123*/, 
/*5653*/        OPC_RecordChild1, // #0 = $a
/*5654*/        OPC_EmitInteger, MVT::i32, 6, 
/*5657*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3123:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 6:i32)
/*5665*/      /*Scope*/ 15, /*->5681*/
/*5666*/        OPC_CheckChild0Integer, 46|128,24/*3118*/, 
/*5669*/        OPC_RecordChild1, // #0 = $a
/*5670*/        OPC_EmitInteger, MVT::i32, 23, 
/*5673*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3118:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 23:i32)
/*5681*/      /*Scope*/ 15, /*->5697*/
/*5682*/        OPC_CheckChild0Integer, 45|128,24/*3117*/, 
/*5685*/        OPC_RecordChild1, // #0 = $a
/*5686*/        OPC_EmitInteger, MVT::i32, 7, 
/*5689*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3117:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 7:i32)
/*5697*/      /*Scope*/ 15, /*->5713*/
/*5698*/        OPC_CheckChild0Integer, 50|128,24/*3122*/, 
/*5701*/        OPC_RecordChild1, // #0 = $a
/*5702*/        OPC_EmitInteger, MVT::i32, 24, 
/*5705*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3122:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 24:i32)
/*5713*/      /*Scope*/ 15, /*->5729*/
/*5714*/        OPC_CheckChild0Integer, 49|128,24/*3121*/, 
/*5717*/        OPC_RecordChild1, // #0 = $a
/*5718*/        OPC_EmitInteger, MVT::i32, 8, 
/*5721*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_f64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3121:iPTR, Float64Regs:f64:$a) - Complexity = 8
                // Dst: (CVT_f32_f64:f32 Float64Regs:f64:$a, 8:i32)
/*5729*/      /*Scope*/ 15, /*->5745*/
/*5730*/        OPC_CheckChild0Integer, 19|128,25/*3219*/, 
/*5733*/        OPC_RecordChild1, // #0 = $a
/*5734*/        OPC_EmitInteger, MVT::i32, 5, 
/*5737*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3219:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_s32:f64 Int32Regs:i32:$a, 5:i32)
/*5745*/      /*Scope*/ 15, /*->5761*/
/*5746*/        OPC_CheckChild0Integer, 21|128,25/*3221*/, 
/*5749*/        OPC_RecordChild1, // #0 = $a
/*5750*/        OPC_EmitInteger, MVT::i32, 6, 
/*5753*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3221:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_s32:f64 Int32Regs:i32:$a, 6:i32)
/*5761*/      /*Scope*/ 15, /*->5777*/
/*5762*/        OPC_CheckChild0Integer, 18|128,25/*3218*/, 
/*5765*/        OPC_RecordChild1, // #0 = $a
/*5766*/        OPC_EmitInteger, MVT::i32, 7, 
/*5769*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3218:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_s32:f64 Int32Regs:i32:$a, 7:i32)
/*5777*/      /*Scope*/ 15, /*->5793*/
/*5778*/        OPC_CheckChild0Integer, 20|128,25/*3220*/, 
/*5781*/        OPC_RecordChild1, // #0 = $a
/*5782*/        OPC_EmitInteger, MVT::i32, 8, 
/*5785*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3220:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_s32:f64 Int32Regs:i32:$a, 8:i32)
/*5793*/      /*Scope*/ 15, /*->5809*/
/*5794*/        OPC_CheckChild0Integer, 3|128,31/*3971*/, 
/*5797*/        OPC_RecordChild1, // #0 = $a
/*5798*/        OPC_EmitInteger, MVT::i32, 5, 
/*5801*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3971:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_u32:f64 Int32Regs:i32:$a, 5:i32)
/*5809*/      /*Scope*/ 15, /*->5825*/
/*5810*/        OPC_CheckChild0Integer, 5|128,31/*3973*/, 
/*5813*/        OPC_RecordChild1, // #0 = $a
/*5814*/        OPC_EmitInteger, MVT::i32, 6, 
/*5817*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3973:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_u32:f64 Int32Regs:i32:$a, 6:i32)
/*5825*/      /*Scope*/ 15, /*->5841*/
/*5826*/        OPC_CheckChild0Integer, 2|128,31/*3970*/, 
/*5829*/        OPC_RecordChild1, // #0 = $a
/*5830*/        OPC_EmitInteger, MVT::i32, 7, 
/*5833*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3970:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_u32:f64 Int32Regs:i32:$a, 7:i32)
/*5841*/      /*Scope*/ 15, /*->5857*/
/*5842*/        OPC_CheckChild0Integer, 4|128,31/*3972*/, 
/*5845*/        OPC_RecordChild1, // #0 = $a
/*5846*/        OPC_EmitInteger, MVT::i32, 8, 
/*5849*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u32), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3972:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f64_u32:f64 Int32Regs:i32:$a, 8:i32)
/*5857*/      /*Scope*/ 15, /*->5873*/
/*5858*/        OPC_CheckChild0Integer, 23|128,25/*3223*/, 
/*5861*/        OPC_RecordChild1, // #0 = $a
/*5862*/        OPC_EmitInteger, MVT::i32, 5, 
/*5865*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3223:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_s32:f32 Int32Regs:i32:$a, 5:i32)
/*5873*/      /*Scope*/ 15, /*->5889*/
/*5874*/        OPC_CheckChild0Integer, 25|128,25/*3225*/, 
/*5877*/        OPC_RecordChild1, // #0 = $a
/*5878*/        OPC_EmitInteger, MVT::i32, 6, 
/*5881*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3225:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_s32:f32 Int32Regs:i32:$a, 6:i32)
/*5889*/      /*Scope*/ 15, /*->5905*/
/*5890*/        OPC_CheckChild0Integer, 22|128,25/*3222*/, 
/*5893*/        OPC_RecordChild1, // #0 = $a
/*5894*/        OPC_EmitInteger, MVT::i32, 7, 
/*5897*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3222:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_s32:f32 Int32Regs:i32:$a, 7:i32)
/*5905*/      /*Scope*/ 15, /*->5921*/
/*5906*/        OPC_CheckChild0Integer, 24|128,25/*3224*/, 
/*5909*/        OPC_RecordChild1, // #0 = $a
/*5910*/        OPC_EmitInteger, MVT::i32, 8, 
/*5913*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3224:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_s32:f32 Int32Regs:i32:$a, 8:i32)
/*5921*/      /*Scope*/ 15, /*->5937*/
/*5922*/        OPC_CheckChild0Integer, 7|128,31/*3975*/, 
/*5925*/        OPC_RecordChild1, // #0 = $a
/*5926*/        OPC_EmitInteger, MVT::i32, 5, 
/*5929*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3975:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_u32:f32 Int32Regs:i32:$a, 5:i32)
/*5937*/      /*Scope*/ 15, /*->5953*/
/*5938*/        OPC_CheckChild0Integer, 9|128,31/*3977*/, 
/*5941*/        OPC_RecordChild1, // #0 = $a
/*5942*/        OPC_EmitInteger, MVT::i32, 6, 
/*5945*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3977:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_u32:f32 Int32Regs:i32:$a, 6:i32)
/*5953*/      /*Scope*/ 15, /*->5969*/
/*5954*/        OPC_CheckChild0Integer, 6|128,31/*3974*/, 
/*5957*/        OPC_RecordChild1, // #0 = $a
/*5958*/        OPC_EmitInteger, MVT::i32, 7, 
/*5961*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3974:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_u32:f32 Int32Regs:i32:$a, 7:i32)
/*5969*/      /*Scope*/ 15, /*->5985*/
/*5970*/        OPC_CheckChild0Integer, 8|128,31/*3976*/, 
/*5973*/        OPC_RecordChild1, // #0 = $a
/*5974*/        OPC_EmitInteger, MVT::i32, 8, 
/*5977*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u32), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3976:iPTR, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (CVT_f32_u32:f32 Int32Regs:i32:$a, 8:i32)
/*5985*/      /*Scope*/ 13, /*->5999*/
/*5986*/        OPC_CheckChild0Integer, 50|128,25/*3250*/, 
/*5989*/        OPC_RecordChild1, // #0 = $src0
/*5990*/        OPC_RecordChild2, // #1 = $src1
/*5991*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_LOHI_I2D), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3250:iPTR, Int32Regs:i32:$src0, Int32Regs:i32:$src1) - Complexity = 8
                // Dst: (INT_NVVM_LOHI_I2D:f64 Int32Regs:i32:$src0, Int32Regs:i32:$src1)
/*5999*/      /*Scope*/ 15, /*->6015*/
/*6000*/        OPC_CheckChild0Integer, 47|128,25/*3247*/, 
/*6003*/        OPC_RecordChild1, // #0 = $a
/*6004*/        OPC_EmitInteger, MVT::i32, 5, 
/*6007*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3247:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_s64:f32 Int64Regs:i64:$a, 5:i32)
/*6015*/      /*Scope*/ 15, /*->6031*/
/*6016*/        OPC_CheckChild0Integer, 49|128,25/*3249*/, 
/*6019*/        OPC_RecordChild1, // #0 = $a
/*6020*/        OPC_EmitInteger, MVT::i32, 6, 
/*6023*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3249:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_s64:f32 Int64Regs:i64:$a, 6:i32)
/*6031*/      /*Scope*/ 15, /*->6047*/
/*6032*/        OPC_CheckChild0Integer, 46|128,25/*3246*/, 
/*6035*/        OPC_RecordChild1, // #0 = $a
/*6036*/        OPC_EmitInteger, MVT::i32, 7, 
/*6039*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3246:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_s64:f32 Int64Regs:i64:$a, 7:i32)
/*6047*/      /*Scope*/ 15, /*->6063*/
/*6048*/        OPC_CheckChild0Integer, 48|128,25/*3248*/, 
/*6051*/        OPC_RecordChild1, // #0 = $a
/*6052*/        OPC_EmitInteger, MVT::i32, 8, 
/*6055*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_s64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3248:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_s64:f32 Int64Regs:i64:$a, 8:i32)
/*6063*/      /*Scope*/ 15, /*->6079*/
/*6064*/        OPC_CheckChild0Integer, 15|128,31/*3983*/, 
/*6067*/        OPC_RecordChild1, // #0 = $a
/*6068*/        OPC_EmitInteger, MVT::i32, 5, 
/*6071*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3983:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_u64:f32 Int64Regs:i64:$a, 5:i32)
/*6079*/      /*Scope*/ 15, /*->6095*/
/*6080*/        OPC_CheckChild0Integer, 17|128,31/*3985*/, 
/*6083*/        OPC_RecordChild1, // #0 = $a
/*6084*/        OPC_EmitInteger, MVT::i32, 6, 
/*6087*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3985:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_u64:f32 Int64Regs:i64:$a, 6:i32)
/*6095*/      /*Scope*/ 15, /*->6111*/
/*6096*/        OPC_CheckChild0Integer, 14|128,31/*3982*/, 
/*6099*/        OPC_RecordChild1, // #0 = $a
/*6100*/        OPC_EmitInteger, MVT::i32, 7, 
/*6103*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3982:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_u64:f32 Int64Regs:i64:$a, 7:i32)
/*6111*/      /*Scope*/ 15, /*->6127*/
/*6112*/        OPC_CheckChild0Integer, 16|128,31/*3984*/, 
/*6115*/        OPC_RecordChild1, // #0 = $a
/*6116*/        OPC_EmitInteger, MVT::i32, 8, 
/*6119*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f32_u64), 0,
                    MVT::f32, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f32 3984:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f32_u64:f32 Int64Regs:i64:$a, 8:i32)
/*6127*/      /*Scope*/ 15, /*->6143*/
/*6128*/        OPC_CheckChild0Integer, 43|128,25/*3243*/, 
/*6131*/        OPC_RecordChild1, // #0 = $a
/*6132*/        OPC_EmitInteger, MVT::i32, 5, 
/*6135*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3243:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_s64:f64 Int64Regs:i64:$a, 5:i32)
/*6143*/      /*Scope*/ 15, /*->6159*/
/*6144*/        OPC_CheckChild0Integer, 45|128,25/*3245*/, 
/*6147*/        OPC_RecordChild1, // #0 = $a
/*6148*/        OPC_EmitInteger, MVT::i32, 6, 
/*6151*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3245:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_s64:f64 Int64Regs:i64:$a, 6:i32)
/*6159*/      /*Scope*/ 15, /*->6175*/
/*6160*/        OPC_CheckChild0Integer, 42|128,25/*3242*/, 
/*6163*/        OPC_RecordChild1, // #0 = $a
/*6164*/        OPC_EmitInteger, MVT::i32, 7, 
/*6167*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3242:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_s64:f64 Int64Regs:i64:$a, 7:i32)
/*6175*/      /*Scope*/ 15, /*->6191*/
/*6176*/        OPC_CheckChild0Integer, 44|128,25/*3244*/, 
/*6179*/        OPC_RecordChild1, // #0 = $a
/*6180*/        OPC_EmitInteger, MVT::i32, 8, 
/*6183*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_s64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3244:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_s64:f64 Int64Regs:i64:$a, 8:i32)
/*6191*/      /*Scope*/ 15, /*->6207*/
/*6192*/        OPC_CheckChild0Integer, 11|128,31/*3979*/, 
/*6195*/        OPC_RecordChild1, // #0 = $a
/*6196*/        OPC_EmitInteger, MVT::i32, 5, 
/*6199*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3979:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_u64:f64 Int64Regs:i64:$a, 5:i32)
/*6207*/      /*Scope*/ 15, /*->6223*/
/*6208*/        OPC_CheckChild0Integer, 13|128,31/*3981*/, 
/*6211*/        OPC_RecordChild1, // #0 = $a
/*6212*/        OPC_EmitInteger, MVT::i32, 6, 
/*6215*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3981:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_u64:f64 Int64Regs:i64:$a, 6:i32)
/*6223*/      /*Scope*/ 15, /*->6239*/
/*6224*/        OPC_CheckChild0Integer, 10|128,31/*3978*/, 
/*6227*/        OPC_RecordChild1, // #0 = $a
/*6228*/        OPC_EmitInteger, MVT::i32, 7, 
/*6231*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3978:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_u64:f64 Int64Regs:i64:$a, 7:i32)
/*6239*/      /*Scope*/ 15, /*->6255*/
/*6240*/        OPC_CheckChild0Integer, 12|128,31/*3980*/, 
/*6243*/        OPC_RecordChild1, // #0 = $a
/*6244*/        OPC_EmitInteger, MVT::i32, 8, 
/*6247*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::CVT_f64_u64), 0,
                    MVT::f64, 2/*#Ops*/, 0, 1, 
                // Src: (intrinsic_wo_chain:f64 3980:iPTR, Int64Regs:i64:$a) - Complexity = 8
                // Dst: (CVT_f64_u64:f64 Int64Regs:i64:$a, 8:i32)
/*6255*/      /*Scope*/ 11, /*->6267*/
/*6256*/        OPC_CheckChild0Integer, 36|128,24/*3108*/, 
/*6259*/        OPC_RecordChild1, // #0 = $src0
/*6260*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_BITCAST_I2F), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3108:iPTR, Int32Regs:i32:$src0) - Complexity = 8
                // Dst: (INT_NVVM_BITCAST_I2F:f32 Int32Regs:i32:$src0)
/*6267*/      /*Scope*/ 11, /*->6279*/
/*6268*/        OPC_CheckChild0Integer, 37|128,24/*3109*/, 
/*6271*/        OPC_RecordChild1, // #0 = $src0
/*6272*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_NVVM_BITCAST_LL2D), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3109:iPTR, Int64Regs:i64:$src0) - Complexity = 8
                // Dst: (INT_NVVM_BITCAST_LL2D:f64 Int64Regs:i64:$src0)
/*6279*/      /*Scope*/ 11, /*->6291*/
/*6280*/        OPC_CheckChild0Integer, 55|128,25/*3255*/, 
/*6283*/        OPC_RecordChild1, // #0 = $s
/*6284*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_float), 0,
                    MVT::f32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f32 3255:iPTR, Float32Regs:f32:$s) - Complexity = 8
                // Dst: (nvvm_move_float:f32 Float32Regs:f32:$s)
/*6291*/      /*Scope*/ 11, /*->6303*/
/*6292*/        OPC_CheckChild0Integer, 54|128,25/*3254*/, 
/*6295*/        OPC_RecordChild1, // #0 = $s
/*6296*/        OPC_MorphNodeTo1, TARGET_VAL(NVPTX::nvvm_move_double), 0,
                    MVT::f64, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:f64 3254:iPTR, Float64Regs:f64:$s) - Complexity = 8
                // Dst: (nvvm_move_double:f64 Float64Regs:f64:$s)
/*6303*/      0, /*End of Scope*/
/*6304*/    /*SwitchOpcode*/ 70, TARGET_VAL(NVPTXISD::DeclareRet),// ->6377
/*6307*/      OPC_RecordNode, // #0 = 'DeclareRet' chained node
/*6308*/      OPC_CaptureGlueInput,
/*6309*/      OPC_Scope, 32, /*->6343*/ // 2 children in Scope
/*6311*/        OPC_CheckChild1Integer, 1, 
/*6313*/        OPC_CheckChild1Type, MVT::i32,
/*6315*/        OPC_RecordChild2, // #1 = $size
/*6316*/        OPC_MoveChild2,
/*6317*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6320*/        OPC_CheckType, MVT::i32,
/*6322*/        OPC_MoveParent,
/*6323*/        OPC_RecordChild3, // #2 = $num
/*6324*/        OPC_MoveChild3,
/*6325*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6328*/        OPC_CheckType, MVT::i32,
/*6330*/        OPC_MoveParent,
/*6331*/        OPC_EmitMergeInputChains1_0,
/*6332*/        OPC_EmitConvertToTarget, 1,
/*6334*/        OPC_EmitConvertToTarget, 2,
/*6336*/        OPC_MorphNodeTo0, TARGET_VAL(NVPTX::DeclareRetScalarInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    2/*#Ops*/, 3, 4, 
                // Src: (DeclareRet 1:i32, (imm:i32):$size, (imm:i32):$num) - Complexity = 14
                // Dst: (DeclareRetScalarInst (imm:i32):$size, (imm:i32):$num)
/*6343*/      /*Scope*/ 32, /*->6376*/
/*6344*/        OPC_CheckChild1Integer, 2, 
/*6346*/        OPC_CheckChild1Type, MVT::i32,
/*6348*/        OPC_RecordChild2, // #1 = $size
/*6349*/        OPC_MoveChild2,
/*6350*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6353*/        OPC_CheckType, MVT::i32,
/*6355*/        OPC_MoveParent,
/*6356*/        OPC_RecordChild3, // #2 = $num
/*6357*/        OPC_MoveChild3,
/*6358*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6361*/        OPC_CheckType, MVT::i32,
/*6363*/        OPC_MoveParent,
/*6364*/        OPC_EmitMergeInputChains1_0,
/*6365*/        OPC_EmitConvertToTarget, 1,
/*6367*/        OPC_EmitConvertToTarget, 2,
/*6369*/        OPC_MorphNodeTo0, TARGET_VAL(NVPTX::DeclareRetRegInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    2/*#Ops*/, 3, 4, 
                // Src: (DeclareRet 2:i32, (imm:i32):$size, (imm:i32):$num) - Complexity = 14
                // Dst: (DeclareRetRegInst (imm:i32):$size, (imm:i32):$num)
/*6376*/      0, /*End of Scope*/
/*6377*/    /*SwitchOpcode*/ 54, TARGET_VAL(NVPTXISD::DeclareScalarParam),// ->6434
/*6380*/      OPC_RecordNode, // #0 = 'DeclareScalarParam' chained node
/*6381*/      OPC_CaptureGlueInput,
/*6382*/      OPC_RecordChild1, // #1 = $a
/*6383*/      OPC_MoveChild1,
/*6384*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6387*/      OPC_CheckType, MVT::i32,
/*6389*/      OPC_MoveParent,
/*6390*/      OPC_RecordChild2, // #2 = $size
/*6391*/      OPC_MoveChild2,
/*6392*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6395*/      OPC_CheckType, MVT::i32,
/*6397*/      OPC_MoveParent,
/*6398*/      OPC_Scope, 16, /*->6416*/ // 2 children in Scope
/*6400*/        OPC_CheckChild3Integer, 0, 
/*6402*/        OPC_CheckChild3Type, MVT::i32,
/*6404*/        OPC_EmitMergeInputChains1_0,
/*6405*/        OPC_EmitConvertToTarget, 1,
/*6407*/        OPC_EmitConvertToTarget, 2,
/*6409*/        OPC_MorphNodeTo0, TARGET_VAL(NVPTX::DeclareScalarParamInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    2/*#Ops*/, 3, 4, 
                // Src: (DeclareScalarParam (imm:i32):$a, (imm:i32):$size, 0:i32) - Complexity = 14
                // Dst: (DeclareScalarParamInst (imm:i32):$a, (imm:i32):$size)
/*6416*/      /*Scope*/ 16, /*->6433*/
/*6417*/        OPC_CheckChild3Integer, 1, 
/*6419*/        OPC_CheckChild3Type, MVT::i32,
/*6421*/        OPC_EmitMergeInputChains1_0,
/*6422*/        OPC_EmitConvertToTarget, 1,
/*6424*/        OPC_EmitConvertToTarget, 2,
/*6426*/        OPC_MorphNodeTo0, TARGET_VAL(NVPTX::DeclareScalarRegInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    2/*#Ops*/, 3, 4, 
                // Src: (DeclareScalarParam (imm:i32):$a, (imm:i32):$size, 1:i32) - Complexity = 14
                // Dst: (DeclareScalarRegInst (imm:i32):$a, (imm:i32):$size)
/*6433*/      0, /*End of Scope*/
/*6434*/    /*SwitchOpcode*/ 46|128,41/*5294*/, TARGET_VAL(ISD::INTRINSIC_W_CHAIN),// ->11732
/*6438*/      OPC_RecordNode, // #0 = 'intrinsic_w_chain' chained node
/*6439*/      OPC_Scope, 52|128,3/*436*/, /*->6878*/ // 28 children in Scope
/*6442*/        OPC_CheckChild1Integer, 8|128,24/*3080*/, 
/*6445*/        OPC_RecordChild2, // #1 = $src
/*6446*/        OPC_Scope, 85|128,1/*213*/, /*->6662*/ // 2 children in Scope
/*6449*/          OPC_CheckChild2Type, MVT::i32,
/*6451*/          OPC_RecordChild3, // #2 = $b
/*6452*/          OPC_Scope, 86, /*->6540*/ // 5 children in Scope
/*6454*/            OPC_MoveChild3,
/*6455*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6458*/            OPC_SwitchType /*2 cases */, 49, MVT::i32,// ->6510
/*6461*/              OPC_MoveParent,
/*6462*/              OPC_RecordChild4, // #3 = $c
/*6463*/              OPC_Scope, 25, /*->6490*/ // 2 children in Scope
/*6465*/                OPC_MoveChild4,
/*6466*/                OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6469*/                OPC_CheckType, MVT::i32,
/*6471*/                OPC_MoveParent,
/*6472*/                OPC_CheckType, MVT::i32,
/*6474*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6476*/                OPC_EmitMergeInputChains1_0,
/*6477*/                OPC_EmitConvertToTarget, 2,
/*6479*/                OPC_EmitConvertToTarget, 3,
/*6481*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1050), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (intrinsic_w_chain:i32 3080:iPTR, Int32Regs:i32:$src, (imm:i32):$b, (imm:i32):$c) - Complexity = 14
                        // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1050:i32 Int32Regs:i32:$src, (imm:i32):$b, (imm:i32):$c)
/*6490*/              /*Scope*/ 18, /*->6509*/
/*6491*/                OPC_CheckChild4Type, MVT::i32,
/*6493*/                OPC_CheckType, MVT::i32,
/*6495*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6497*/                OPC_EmitMergeInputChains1_0,
/*6498*/                OPC_EmitConvertToTarget, 2,
/*6500*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1046), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                        // Src: (intrinsic_w_chain:i32 3080:iPTR, Int32Regs:i32:$src, (imm:i32):$b, Int32Regs:i32:$c) - Complexity = 12
                        // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1046:i32 Int32Regs:i32:$src, (imm:i32):$b, Int32Regs:i32:$c)
/*6509*/              0, /*End of Scope*/
/*6510*/            /*SwitchType*/ 27, MVT::i64,// ->6539
/*6512*/              OPC_MoveParent,
/*6513*/              OPC_RecordChild4, // #3 = $c
/*6514*/              OPC_MoveChild4,
/*6515*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6518*/              OPC_CheckType, MVT::i64,
/*6520*/              OPC_MoveParent,
/*6521*/              OPC_CheckType, MVT::i64,
/*6523*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6525*/              OPC_EmitMergeInputChains1_0,
/*6526*/              OPC_EmitConvertToTarget, 2,
/*6528*/              OPC_EmitConvertToTarget, 3,
/*6530*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1050), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                      // Src: (intrinsic_w_chain:i64 3080:iPTR, Int32Regs:i32:$src, (imm:i64):$b, (imm:i64):$c) - Complexity = 14
                      // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1050:i64 Int32Regs:i32:$src, (imm:i64):$b, (imm:i64):$c)
/*6539*/            0, // EndSwitchType
/*6540*/          /*Scope*/ 26, /*->6567*/
/*6541*/            OPC_CheckChild3Type, MVT::i32,
/*6543*/            OPC_RecordChild4, // #3 = $c
/*6544*/            OPC_MoveChild4,
/*6545*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6548*/            OPC_CheckType, MVT::i32,
/*6550*/            OPC_MoveParent,
/*6551*/            OPC_CheckType, MVT::i32,
/*6553*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6555*/            OPC_EmitMergeInputChains1_0,
/*6556*/            OPC_EmitConvertToTarget, 3,
/*6558*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1048), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                    // Src: (intrinsic_w_chain:i32 3080:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b, (imm:i32):$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1048:i32 Int32Regs:i32:$src, Int32Regs:i32:$b, (imm:i32):$c)
/*6567*/          /*Scope*/ 26, /*->6594*/
/*6568*/            OPC_MoveChild3,
/*6569*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6572*/            OPC_CheckType, MVT::i64,
/*6574*/            OPC_MoveParent,
/*6575*/            OPC_RecordChild4, // #3 = $c
/*6576*/            OPC_CheckChild4Type, MVT::i64,
/*6578*/            OPC_CheckType, MVT::i64,
/*6580*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6582*/            OPC_EmitMergeInputChains1_0,
/*6583*/            OPC_EmitConvertToTarget, 2,
/*6585*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1046), 0|OPFL_Chain,
                        MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                    // Src: (intrinsic_w_chain:i64 3080:iPTR, Int32Regs:i32:$src, (imm:i64):$b, Int64Regs:i64:$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1046:i64 Int32Regs:i32:$src, (imm:i64):$b, Int64Regs:i64:$c)
/*6594*/          /*Scope*/ 46, /*->6641*/
/*6595*/            OPC_CheckChild3Type, MVT::i64,
/*6597*/            OPC_RecordChild4, // #3 = $c
/*6598*/            OPC_Scope, 23, /*->6623*/ // 2 children in Scope
/*6600*/              OPC_MoveChild4,
/*6601*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6604*/              OPC_CheckType, MVT::i64,
/*6606*/              OPC_MoveParent,
/*6607*/              OPC_CheckType, MVT::i64,
/*6609*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6611*/              OPC_EmitMergeInputChains1_0,
/*6612*/              OPC_EmitConvertToTarget, 3,
/*6614*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1048), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                      // Src: (intrinsic_w_chain:i64 3080:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b, (imm:i64):$c) - Complexity = 12
                      // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1048:i64 Int32Regs:i32:$src, Int64Regs:i64:$b, (imm:i64):$c)
/*6623*/            /*Scope*/ 16, /*->6640*/
/*6624*/              OPC_CheckChild4Type, MVT::i64,
/*6626*/              OPC_CheckType, MVT::i64,
/*6628*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6630*/              OPC_EmitMergeInputChains1_0,
/*6631*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1044), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (intrinsic_w_chain:i64 3080:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b, Int64Regs:i64:$c) - Complexity = 10
                      // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1044:i64 Int32Regs:i32:$src, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*6640*/            0, /*End of Scope*/
/*6641*/          /*Scope*/ 19, /*->6661*/
/*6642*/            OPC_CheckChild3Type, MVT::i32,
/*6644*/            OPC_RecordChild4, // #3 = $c
/*6645*/            OPC_CheckChild4Type, MVT::i32,
/*6647*/            OPC_CheckType, MVT::i32,
/*6649*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6651*/            OPC_EmitMergeInputChains1_0,
/*6652*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1044), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                    // Src: (intrinsic_w_chain:i32 3080:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b, Int32Regs:i32:$c) - Complexity = 10
                    // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1044:i32 Int32Regs:i32:$src, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*6661*/          0, /*End of Scope*/
/*6662*/        /*Scope*/ 85|128,1/*213*/, /*->6877*/
/*6664*/          OPC_CheckChild2Type, MVT::i64,
/*6666*/          OPC_RecordChild3, // #2 = $b
/*6667*/          OPC_Scope, 86, /*->6755*/ // 5 children in Scope
/*6669*/            OPC_MoveChild3,
/*6670*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6673*/            OPC_SwitchType /*2 cases */, 49, MVT::i32,// ->6725
/*6676*/              OPC_MoveParent,
/*6677*/              OPC_RecordChild4, // #3 = $c
/*6678*/              OPC_Scope, 25, /*->6705*/ // 2 children in Scope
/*6680*/                OPC_MoveChild4,
/*6681*/                OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6684*/                OPC_CheckType, MVT::i32,
/*6686*/                OPC_MoveParent,
/*6687*/                OPC_CheckType, MVT::i32,
/*6689*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6691*/                OPC_EmitMergeInputChains1_0,
/*6692*/                OPC_EmitConvertToTarget, 2,
/*6694*/                OPC_EmitConvertToTarget, 3,
/*6696*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1051), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (intrinsic_w_chain:i32 3080:iPTR, Int64Regs:i64:$src, (imm:i32):$b, (imm:i32):$c) - Complexity = 14
                        // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1051:i32 Int64Regs:i64:$src, (imm:i32):$b, (imm:i32):$c)
/*6705*/              /*Scope*/ 18, /*->6724*/
/*6706*/                OPC_CheckChild4Type, MVT::i32,
/*6708*/                OPC_CheckType, MVT::i32,
/*6710*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6712*/                OPC_EmitMergeInputChains1_0,
/*6713*/                OPC_EmitConvertToTarget, 2,
/*6715*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1047), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                        // Src: (intrinsic_w_chain:i32 3080:iPTR, Int64Regs:i64:$src, (imm:i32):$b, Int32Regs:i32:$c) - Complexity = 12
                        // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1047:i32 Int64Regs:i64:$src, (imm:i32):$b, Int32Regs:i32:$c)
/*6724*/              0, /*End of Scope*/
/*6725*/            /*SwitchType*/ 27, MVT::i64,// ->6754
/*6727*/              OPC_MoveParent,
/*6728*/              OPC_RecordChild4, // #3 = $c
/*6729*/              OPC_MoveChild4,
/*6730*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6733*/              OPC_CheckType, MVT::i64,
/*6735*/              OPC_MoveParent,
/*6736*/              OPC_CheckType, MVT::i64,
/*6738*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6740*/              OPC_EmitMergeInputChains1_0,
/*6741*/              OPC_EmitConvertToTarget, 2,
/*6743*/              OPC_EmitConvertToTarget, 3,
/*6745*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1051), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                      // Src: (intrinsic_w_chain:i64 3080:iPTR, Int64Regs:i64:$src, (imm:i64):$b, (imm:i64):$c) - Complexity = 14
                      // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1051:i64 Int64Regs:i64:$src, (imm:i64):$b, (imm:i64):$c)
/*6754*/            0, // EndSwitchType
/*6755*/          /*Scope*/ 26, /*->6782*/
/*6756*/            OPC_CheckChild3Type, MVT::i32,
/*6758*/            OPC_RecordChild4, // #3 = $c
/*6759*/            OPC_MoveChild4,
/*6760*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6763*/            OPC_CheckType, MVT::i32,
/*6765*/            OPC_MoveParent,
/*6766*/            OPC_CheckType, MVT::i32,
/*6768*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6770*/            OPC_EmitMergeInputChains1_0,
/*6771*/            OPC_EmitConvertToTarget, 3,
/*6773*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1049), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                    // Src: (intrinsic_w_chain:i32 3080:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b, (imm:i32):$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1049:i32 Int64Regs:i64:$src, Int32Regs:i32:$b, (imm:i32):$c)
/*6782*/          /*Scope*/ 26, /*->6809*/
/*6783*/            OPC_MoveChild3,
/*6784*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6787*/            OPC_CheckType, MVT::i64,
/*6789*/            OPC_MoveParent,
/*6790*/            OPC_RecordChild4, // #3 = $c
/*6791*/            OPC_CheckChild4Type, MVT::i64,
/*6793*/            OPC_CheckType, MVT::i64,
/*6795*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6797*/            OPC_EmitMergeInputChains1_0,
/*6798*/            OPC_EmitConvertToTarget, 2,
/*6800*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1047), 0|OPFL_Chain,
                        MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                    // Src: (intrinsic_w_chain:i64 3080:iPTR, Int64Regs:i64:$src, (imm:i64):$b, Int64Regs:i64:$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1047:i64 Int64Regs:i64:$src, (imm:i64):$b, Int64Regs:i64:$c)
/*6809*/          /*Scope*/ 46, /*->6856*/
/*6810*/            OPC_CheckChild3Type, MVT::i64,
/*6812*/            OPC_RecordChild4, // #3 = $c
/*6813*/            OPC_Scope, 23, /*->6838*/ // 2 children in Scope
/*6815*/              OPC_MoveChild4,
/*6816*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6819*/              OPC_CheckType, MVT::i64,
/*6821*/              OPC_MoveParent,
/*6822*/              OPC_CheckType, MVT::i64,
/*6824*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6826*/              OPC_EmitMergeInputChains1_0,
/*6827*/              OPC_EmitConvertToTarget, 3,
/*6829*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1049), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                      // Src: (intrinsic_w_chain:i64 3080:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b, (imm:i64):$c) - Complexity = 12
                      // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1049:i64 Int64Regs:i64:$src, Int64Regs:i64:$b, (imm:i64):$c)
/*6838*/            /*Scope*/ 16, /*->6855*/
/*6839*/              OPC_CheckChild4Type, MVT::i64,
/*6841*/              OPC_CheckType, MVT::i64,
/*6843*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6845*/              OPC_EmitMergeInputChains1_0,
/*6846*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1045), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (intrinsic_w_chain:i64 3080:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b, Int64Regs:i64:$c) - Complexity = 10
                      // Dst: (INT_PTX_SATOM_CAS_b64_cta_gen_anonymous_1053anonymous_1045:i64 Int64Regs:i64:$src, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*6855*/            0, /*End of Scope*/
/*6856*/          /*Scope*/ 19, /*->6876*/
/*6857*/            OPC_CheckChild3Type, MVT::i32,
/*6859*/            OPC_RecordChild4, // #3 = $c
/*6860*/            OPC_CheckChild4Type, MVT::i32,
/*6862*/            OPC_CheckType, MVT::i32,
/*6864*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6866*/            OPC_EmitMergeInputChains1_0,
/*6867*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1045), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                    // Src: (intrinsic_w_chain:i32 3080:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b, Int32Regs:i32:$c) - Complexity = 10
                    // Dst: (INT_PTX_SATOM_CAS_b32_cta_gen_anonymous_1053anonymous_1045:i32 Int64Regs:i64:$src, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*6876*/          0, /*End of Scope*/
/*6877*/        0, /*End of Scope*/
/*6878*/      /*Scope*/ 52|128,3/*436*/, /*->7316*/
/*6880*/        OPC_CheckChild1Integer, 9|128,24/*3081*/, 
/*6883*/        OPC_RecordChild2, // #1 = $src
/*6884*/        OPC_Scope, 85|128,1/*213*/, /*->7100*/ // 2 children in Scope
/*6887*/          OPC_CheckChild2Type, MVT::i32,
/*6889*/          OPC_RecordChild3, // #2 = $b
/*6890*/          OPC_Scope, 86, /*->6978*/ // 5 children in Scope
/*6892*/            OPC_MoveChild3,
/*6893*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6896*/            OPC_SwitchType /*2 cases */, 49, MVT::i32,// ->6948
/*6899*/              OPC_MoveParent,
/*6900*/              OPC_RecordChild4, // #3 = $c
/*6901*/              OPC_Scope, 25, /*->6928*/ // 2 children in Scope
/*6903*/                OPC_MoveChild4,
/*6904*/                OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6907*/                OPC_CheckType, MVT::i32,
/*6909*/                OPC_MoveParent,
/*6910*/                OPC_CheckType, MVT::i32,
/*6912*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6914*/                OPC_EmitMergeInputChains1_0,
/*6915*/                OPC_EmitConvertToTarget, 2,
/*6917*/                OPC_EmitConvertToTarget, 3,
/*6919*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1050), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (intrinsic_w_chain:i32 3081:iPTR, Int32Regs:i32:$src, (imm:i32):$b, (imm:i32):$c) - Complexity = 14
                        // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1050:i32 Int32Regs:i32:$src, (imm:i32):$b, (imm:i32):$c)
/*6928*/              /*Scope*/ 18, /*->6947*/
/*6929*/                OPC_CheckChild4Type, MVT::i32,
/*6931*/                OPC_CheckType, MVT::i32,
/*6933*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6935*/                OPC_EmitMergeInputChains1_0,
/*6936*/                OPC_EmitConvertToTarget, 2,
/*6938*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1046), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                        // Src: (intrinsic_w_chain:i32 3081:iPTR, Int32Regs:i32:$src, (imm:i32):$b, Int32Regs:i32:$c) - Complexity = 12
                        // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1046:i32 Int32Regs:i32:$src, (imm:i32):$b, Int32Regs:i32:$c)
/*6947*/              0, /*End of Scope*/
/*6948*/            /*SwitchType*/ 27, MVT::i64,// ->6977
/*6950*/              OPC_MoveParent,
/*6951*/              OPC_RecordChild4, // #3 = $c
/*6952*/              OPC_MoveChild4,
/*6953*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6956*/              OPC_CheckType, MVT::i64,
/*6958*/              OPC_MoveParent,
/*6959*/              OPC_CheckType, MVT::i64,
/*6961*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6963*/              OPC_EmitMergeInputChains1_0,
/*6964*/              OPC_EmitConvertToTarget, 2,
/*6966*/              OPC_EmitConvertToTarget, 3,
/*6968*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1050), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                      // Src: (intrinsic_w_chain:i64 3081:iPTR, Int32Regs:i32:$src, (imm:i64):$b, (imm:i64):$c) - Complexity = 14
                      // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1050:i64 Int32Regs:i32:$src, (imm:i64):$b, (imm:i64):$c)
/*6977*/            0, // EndSwitchType
/*6978*/          /*Scope*/ 26, /*->7005*/
/*6979*/            OPC_CheckChild3Type, MVT::i32,
/*6981*/            OPC_RecordChild4, // #3 = $c
/*6982*/            OPC_MoveChild4,
/*6983*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6986*/            OPC_CheckType, MVT::i32,
/*6988*/            OPC_MoveParent,
/*6989*/            OPC_CheckType, MVT::i32,
/*6991*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*6993*/            OPC_EmitMergeInputChains1_0,
/*6994*/            OPC_EmitConvertToTarget, 3,
/*6996*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1048), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                    // Src: (intrinsic_w_chain:i32 3081:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b, (imm:i32):$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1048:i32 Int32Regs:i32:$src, Int32Regs:i32:$b, (imm:i32):$c)
/*7005*/          /*Scope*/ 26, /*->7032*/
/*7006*/            OPC_MoveChild3,
/*7007*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7010*/            OPC_CheckType, MVT::i64,
/*7012*/            OPC_MoveParent,
/*7013*/            OPC_RecordChild4, // #3 = $c
/*7014*/            OPC_CheckChild4Type, MVT::i64,
/*7016*/            OPC_CheckType, MVT::i64,
/*7018*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7020*/            OPC_EmitMergeInputChains1_0,
/*7021*/            OPC_EmitConvertToTarget, 2,
/*7023*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1046), 0|OPFL_Chain,
                        MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                    // Src: (intrinsic_w_chain:i64 3081:iPTR, Int32Regs:i32:$src, (imm:i64):$b, Int64Regs:i64:$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1046:i64 Int32Regs:i32:$src, (imm:i64):$b, Int64Regs:i64:$c)
/*7032*/          /*Scope*/ 46, /*->7079*/
/*7033*/            OPC_CheckChild3Type, MVT::i64,
/*7035*/            OPC_RecordChild4, // #3 = $c
/*7036*/            OPC_Scope, 23, /*->7061*/ // 2 children in Scope
/*7038*/              OPC_MoveChild4,
/*7039*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7042*/              OPC_CheckType, MVT::i64,
/*7044*/              OPC_MoveParent,
/*7045*/              OPC_CheckType, MVT::i64,
/*7047*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7049*/              OPC_EmitMergeInputChains1_0,
/*7050*/              OPC_EmitConvertToTarget, 3,
/*7052*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1048), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                      // Src: (intrinsic_w_chain:i64 3081:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b, (imm:i64):$c) - Complexity = 12
                      // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1048:i64 Int32Regs:i32:$src, Int64Regs:i64:$b, (imm:i64):$c)
/*7061*/            /*Scope*/ 16, /*->7078*/
/*7062*/              OPC_CheckChild4Type, MVT::i64,
/*7064*/              OPC_CheckType, MVT::i64,
/*7066*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7068*/              OPC_EmitMergeInputChains1_0,
/*7069*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1044), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (intrinsic_w_chain:i64 3081:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b, Int64Regs:i64:$c) - Complexity = 10
                      // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1044:i64 Int32Regs:i32:$src, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*7078*/            0, /*End of Scope*/
/*7079*/          /*Scope*/ 19, /*->7099*/
/*7080*/            OPC_CheckChild3Type, MVT::i32,
/*7082*/            OPC_RecordChild4, // #3 = $c
/*7083*/            OPC_CheckChild4Type, MVT::i32,
/*7085*/            OPC_CheckType, MVT::i32,
/*7087*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7089*/            OPC_EmitMergeInputChains1_0,
/*7090*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1044), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                    // Src: (intrinsic_w_chain:i32 3081:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b, Int32Regs:i32:$c) - Complexity = 10
                    // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1044:i32 Int32Regs:i32:$src, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*7099*/          0, /*End of Scope*/
/*7100*/        /*Scope*/ 85|128,1/*213*/, /*->7315*/
/*7102*/          OPC_CheckChild2Type, MVT::i64,
/*7104*/          OPC_RecordChild3, // #2 = $b
/*7105*/          OPC_Scope, 86, /*->7193*/ // 5 children in Scope
/*7107*/            OPC_MoveChild3,
/*7108*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7111*/            OPC_SwitchType /*2 cases */, 49, MVT::i32,// ->7163
/*7114*/              OPC_MoveParent,
/*7115*/              OPC_RecordChild4, // #3 = $c
/*7116*/              OPC_Scope, 25, /*->7143*/ // 2 children in Scope
/*7118*/                OPC_MoveChild4,
/*7119*/                OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7122*/                OPC_CheckType, MVT::i32,
/*7124*/                OPC_MoveParent,
/*7125*/                OPC_CheckType, MVT::i32,
/*7127*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7129*/                OPC_EmitMergeInputChains1_0,
/*7130*/                OPC_EmitConvertToTarget, 2,
/*7132*/                OPC_EmitConvertToTarget, 3,
/*7134*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1051), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (intrinsic_w_chain:i32 3081:iPTR, Int64Regs:i64:$src, (imm:i32):$b, (imm:i32):$c) - Complexity = 14
                        // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1051:i32 Int64Regs:i64:$src, (imm:i32):$b, (imm:i32):$c)
/*7143*/              /*Scope*/ 18, /*->7162*/
/*7144*/                OPC_CheckChild4Type, MVT::i32,
/*7146*/                OPC_CheckType, MVT::i32,
/*7148*/                OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7150*/                OPC_EmitMergeInputChains1_0,
/*7151*/                OPC_EmitConvertToTarget, 2,
/*7153*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1047), 0|OPFL_Chain,
                            MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                        // Src: (intrinsic_w_chain:i32 3081:iPTR, Int64Regs:i64:$src, (imm:i32):$b, Int32Regs:i32:$c) - Complexity = 12
                        // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1047:i32 Int64Regs:i64:$src, (imm:i32):$b, Int32Regs:i32:$c)
/*7162*/              0, /*End of Scope*/
/*7163*/            /*SwitchType*/ 27, MVT::i64,// ->7192
/*7165*/              OPC_MoveParent,
/*7166*/              OPC_RecordChild4, // #3 = $c
/*7167*/              OPC_MoveChild4,
/*7168*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7171*/              OPC_CheckType, MVT::i64,
/*7173*/              OPC_MoveParent,
/*7174*/              OPC_CheckType, MVT::i64,
/*7176*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7178*/              OPC_EmitMergeInputChains1_0,
/*7179*/              OPC_EmitConvertToTarget, 2,
/*7181*/              OPC_EmitConvertToTarget, 3,
/*7183*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1051), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                      // Src: (intrinsic_w_chain:i64 3081:iPTR, Int64Regs:i64:$src, (imm:i64):$b, (imm:i64):$c) - Complexity = 14
                      // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1051:i64 Int64Regs:i64:$src, (imm:i64):$b, (imm:i64):$c)
/*7192*/            0, // EndSwitchType
/*7193*/          /*Scope*/ 26, /*->7220*/
/*7194*/            OPC_CheckChild3Type, MVT::i32,
/*7196*/            OPC_RecordChild4, // #3 = $c
/*7197*/            OPC_MoveChild4,
/*7198*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7201*/            OPC_CheckType, MVT::i32,
/*7203*/            OPC_MoveParent,
/*7204*/            OPC_CheckType, MVT::i32,
/*7206*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7208*/            OPC_EmitMergeInputChains1_0,
/*7209*/            OPC_EmitConvertToTarget, 3,
/*7211*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1049), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                    // Src: (intrinsic_w_chain:i32 3081:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b, (imm:i32):$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1049:i32 Int64Regs:i64:$src, Int32Regs:i32:$b, (imm:i32):$c)
/*7220*/          /*Scope*/ 26, /*->7247*/
/*7221*/            OPC_MoveChild3,
/*7222*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7225*/            OPC_CheckType, MVT::i64,
/*7227*/            OPC_MoveParent,
/*7228*/            OPC_RecordChild4, // #3 = $c
/*7229*/            OPC_CheckChild4Type, MVT::i64,
/*7231*/            OPC_CheckType, MVT::i64,
/*7233*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7235*/            OPC_EmitMergeInputChains1_0,
/*7236*/            OPC_EmitConvertToTarget, 2,
/*7238*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1047), 0|OPFL_Chain,
                        MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                    // Src: (intrinsic_w_chain:i64 3081:iPTR, Int64Regs:i64:$src, (imm:i64):$b, Int64Regs:i64:$c) - Complexity = 12
                    // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1047:i64 Int64Regs:i64:$src, (imm:i64):$b, Int64Regs:i64:$c)
/*7247*/          /*Scope*/ 46, /*->7294*/
/*7248*/            OPC_CheckChild3Type, MVT::i64,
/*7250*/            OPC_RecordChild4, // #3 = $c
/*7251*/            OPC_Scope, 23, /*->7276*/ // 2 children in Scope
/*7253*/              OPC_MoveChild4,
/*7254*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7257*/              OPC_CheckType, MVT::i64,
/*7259*/              OPC_MoveParent,
/*7260*/              OPC_CheckType, MVT::i64,
/*7262*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7264*/              OPC_EmitMergeInputChains1_0,
/*7265*/              OPC_EmitConvertToTarget, 3,
/*7267*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1049), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                      // Src: (intrinsic_w_chain:i64 3081:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b, (imm:i64):$c) - Complexity = 12
                      // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1049:i64 Int64Regs:i64:$src, Int64Regs:i64:$b, (imm:i64):$c)
/*7276*/            /*Scope*/ 16, /*->7293*/
/*7277*/              OPC_CheckChild4Type, MVT::i64,
/*7279*/              OPC_CheckType, MVT::i64,
/*7281*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7283*/              OPC_EmitMergeInputChains1_0,
/*7284*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1045), 0|OPFL_Chain,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (intrinsic_w_chain:i64 3081:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b, Int64Regs:i64:$c) - Complexity = 10
                      // Dst: (INT_PTX_SATOM_CAS_b64_sys_gen_anonymous_1053anonymous_1045:i64 Int64Regs:i64:$src, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*7293*/            0, /*End of Scope*/
/*7294*/          /*Scope*/ 19, /*->7314*/
/*7295*/            OPC_CheckChild3Type, MVT::i32,
/*7297*/            OPC_RecordChild4, // #3 = $c
/*7298*/            OPC_CheckChild4Type, MVT::i32,
/*7300*/            OPC_CheckType, MVT::i32,
/*7302*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7304*/            OPC_EmitMergeInputChains1_0,
/*7305*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1045), 0|OPFL_Chain,
                        MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                    // Src: (intrinsic_w_chain:i32 3081:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b, Int32Regs:i32:$c) - Complexity = 10
                    // Dst: (INT_PTX_SATOM_CAS_b32_sys_gen_anonymous_1053anonymous_1045:i32 Int64Regs:i64:$src, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*7314*/          0, /*End of Scope*/
/*7315*/        0, /*End of Scope*/
/*7316*/      /*Scope*/ 24|128,2/*280*/, /*->7598*/
/*7318*/        OPC_CheckChild1Integer, 18|128,24/*3090*/, 
/*7321*/        OPC_RecordChild2, // #1 = $addr
/*7322*/        OPC_Scope, 7|128,1/*135*/, /*->7460*/ // 2 children in Scope
/*7325*/          OPC_CheckChild2Type, MVT::i32,
/*7327*/          OPC_RecordChild3, // #2 = $b
/*7328*/          OPC_Scope, 72, /*->7402*/ // 4 children in Scope
/*7330*/            OPC_MoveChild3,
/*7331*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7334*/            OPC_MoveParent,
/*7335*/            OPC_Scope, 15, /*->7352*/ // 3 children in Scope
/*7337*/              OPC_CheckPredicate, 4, // Predicate_atomic_load_inc_32_g
/*7339*/              OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7341*/              OPC_EmitMergeInputChains1_0,
/*7342*/              OPC_EmitConvertToTarget, 2,
/*7344*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_G_32p32imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_g>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_INC_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7352*/            /*Scope*/ 15, /*->7368*/
/*7353*/              OPC_CheckPredicate, 5, // Predicate_atomic_load_inc_32_s
/*7355*/              OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7357*/              OPC_EmitMergeInputChains1_0,
/*7358*/              OPC_EmitConvertToTarget, 2,
/*7360*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_S_32p32imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_s>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_INC_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7368*/            /*Scope*/ 32, /*->7401*/
/*7369*/              OPC_CheckPredicate, 6, // Predicate_atomic_load_inc_32_gen
/*7371*/              OPC_Scope, 13, /*->7386*/ // 2 children in Scope
/*7373*/                OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7375*/                OPC_EmitMergeInputChains1_0,
/*7376*/                OPC_EmitConvertToTarget, 2,
/*7378*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32p32imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_INC_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7386*/              /*Scope*/ 13, /*->7400*/
/*7387*/                OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7389*/                OPC_EmitMergeInputChains1_0,
/*7390*/                OPC_EmitConvertToTarget, 2,
/*7392*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32_USE_Gp32imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_INC_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7400*/              0, /*End of Scope*/
/*7401*/            0, /*End of Scope*/
/*7402*/          /*Scope*/ 13, /*->7416*/
/*7403*/            OPC_CheckPredicate, 4, // Predicate_atomic_load_inc_32_g
/*7405*/            OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7407*/            OPC_EmitMergeInputChains1_0,
/*7408*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_G_32p32reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_g>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_INC_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7416*/          /*Scope*/ 13, /*->7430*/
/*7417*/            OPC_CheckPredicate, 5, // Predicate_atomic_load_inc_32_s
/*7419*/            OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7421*/            OPC_EmitMergeInputChains1_0,
/*7422*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_S_32p32reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_s>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_INC_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7430*/          /*Scope*/ 28, /*->7459*/
/*7431*/            OPC_CheckPredicate, 6, // Predicate_atomic_load_inc_32_gen
/*7433*/            OPC_Scope, 11, /*->7446*/ // 2 children in Scope
/*7435*/              OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7437*/              OPC_EmitMergeInputChains1_0,
/*7438*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32p32reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_INC_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7446*/            /*Scope*/ 11, /*->7458*/
/*7447*/              OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7449*/              OPC_EmitMergeInputChains1_0,
/*7450*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32_USE_Gp32reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_INC_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7458*/            0, /*End of Scope*/
/*7459*/          0, /*End of Scope*/
/*7460*/        /*Scope*/ 7|128,1/*135*/, /*->7597*/
/*7462*/          OPC_CheckChild2Type, MVT::i64,
/*7464*/          OPC_RecordChild3, // #2 = $b
/*7465*/          OPC_Scope, 72, /*->7539*/ // 4 children in Scope
/*7467*/            OPC_MoveChild3,
/*7468*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7471*/            OPC_MoveParent,
/*7472*/            OPC_Scope, 15, /*->7489*/ // 3 children in Scope
/*7474*/              OPC_CheckPredicate, 4, // Predicate_atomic_load_inc_32_g
/*7476*/              OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7478*/              OPC_EmitMergeInputChains1_0,
/*7479*/              OPC_EmitConvertToTarget, 2,
/*7481*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_G_32p64imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_g>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_INC_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7489*/            /*Scope*/ 15, /*->7505*/
/*7490*/              OPC_CheckPredicate, 5, // Predicate_atomic_load_inc_32_s
/*7492*/              OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7494*/              OPC_EmitMergeInputChains1_0,
/*7495*/              OPC_EmitConvertToTarget, 2,
/*7497*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_S_32p64imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_s>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_INC_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7505*/            /*Scope*/ 32, /*->7538*/
/*7506*/              OPC_CheckPredicate, 6, // Predicate_atomic_load_inc_32_gen
/*7508*/              OPC_Scope, 13, /*->7523*/ // 2 children in Scope
/*7510*/                OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7512*/                OPC_EmitMergeInputChains1_0,
/*7513*/                OPC_EmitConvertToTarget, 2,
/*7515*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32p64imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_INC_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7523*/              /*Scope*/ 13, /*->7537*/
/*7524*/                OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7526*/                OPC_EmitMergeInputChains1_0,
/*7527*/                OPC_EmitConvertToTarget, 2,
/*7529*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32_USE_Gp64imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_INC_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7537*/              0, /*End of Scope*/
/*7538*/            0, /*End of Scope*/
/*7539*/          /*Scope*/ 13, /*->7553*/
/*7540*/            OPC_CheckPredicate, 4, // Predicate_atomic_load_inc_32_g
/*7542*/            OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7544*/            OPC_EmitMergeInputChains1_0,
/*7545*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_G_32p64reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_g>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_INC_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7553*/          /*Scope*/ 13, /*->7567*/
/*7554*/            OPC_CheckPredicate, 5, // Predicate_atomic_load_inc_32_s
/*7556*/            OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7558*/            OPC_EmitMergeInputChains1_0,
/*7559*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_S_32p64reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_s>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_INC_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7567*/          /*Scope*/ 28, /*->7596*/
/*7568*/            OPC_CheckPredicate, 6, // Predicate_atomic_load_inc_32_gen
/*7570*/            OPC_Scope, 11, /*->7583*/ // 2 children in Scope
/*7572*/              OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7574*/              OPC_EmitMergeInputChains1_0,
/*7575*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32p64reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_INC_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7583*/            /*Scope*/ 11, /*->7595*/
/*7584*/              OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7586*/              OPC_EmitMergeInputChains1_0,
/*7587*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_INC_GEN_32_USE_Gp64reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3090:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_inc_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_INC_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7595*/            0, /*End of Scope*/
/*7596*/          0, /*End of Scope*/
/*7597*/        0, /*End of Scope*/
/*7598*/      /*Scope*/ 24|128,2/*280*/, /*->7880*/
/*7600*/        OPC_CheckChild1Integer, 17|128,24/*3089*/, 
/*7603*/        OPC_RecordChild2, // #1 = $addr
/*7604*/        OPC_Scope, 7|128,1/*135*/, /*->7742*/ // 2 children in Scope
/*7607*/          OPC_CheckChild2Type, MVT::i32,
/*7609*/          OPC_RecordChild3, // #2 = $b
/*7610*/          OPC_Scope, 72, /*->7684*/ // 4 children in Scope
/*7612*/            OPC_MoveChild3,
/*7613*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7616*/            OPC_MoveParent,
/*7617*/            OPC_Scope, 15, /*->7634*/ // 3 children in Scope
/*7619*/              OPC_CheckPredicate, 4, // Predicate_atomic_load_dec_32_g
/*7621*/              OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7623*/              OPC_EmitMergeInputChains1_0,
/*7624*/              OPC_EmitConvertToTarget, 2,
/*7626*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_G_32p32imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_g>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_DEC_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7634*/            /*Scope*/ 15, /*->7650*/
/*7635*/              OPC_CheckPredicate, 5, // Predicate_atomic_load_dec_32_s
/*7637*/              OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7639*/              OPC_EmitMergeInputChains1_0,
/*7640*/              OPC_EmitConvertToTarget, 2,
/*7642*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_S_32p32imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_s>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_DEC_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7650*/            /*Scope*/ 32, /*->7683*/
/*7651*/              OPC_CheckPredicate, 6, // Predicate_atomic_load_dec_32_gen
/*7653*/              OPC_Scope, 13, /*->7668*/ // 2 children in Scope
/*7655*/                OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7657*/                OPC_EmitMergeInputChains1_0,
/*7658*/                OPC_EmitConvertToTarget, 2,
/*7660*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32p32imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_DEC_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7668*/              /*Scope*/ 13, /*->7682*/
/*7669*/                OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7671*/                OPC_EmitMergeInputChains1_0,
/*7672*/                OPC_EmitConvertToTarget, 2,
/*7674*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32_USE_Gp32imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_DEC_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*7682*/              0, /*End of Scope*/
/*7683*/            0, /*End of Scope*/
/*7684*/          /*Scope*/ 13, /*->7698*/
/*7685*/            OPC_CheckPredicate, 4, // Predicate_atomic_load_dec_32_g
/*7687*/            OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7689*/            OPC_EmitMergeInputChains1_0,
/*7690*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_G_32p32reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_g>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_DEC_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7698*/          /*Scope*/ 13, /*->7712*/
/*7699*/            OPC_CheckPredicate, 5, // Predicate_atomic_load_dec_32_s
/*7701*/            OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7703*/            OPC_EmitMergeInputChains1_0,
/*7704*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_S_32p32reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_s>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_DEC_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7712*/          /*Scope*/ 28, /*->7741*/
/*7713*/            OPC_CheckPredicate, 6, // Predicate_atomic_load_dec_32_gen
/*7715*/            OPC_Scope, 11, /*->7728*/ // 2 children in Scope
/*7717*/              OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7719*/              OPC_EmitMergeInputChains1_0,
/*7720*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32p32reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_DEC_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7728*/            /*Scope*/ 11, /*->7740*/
/*7729*/              OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7731*/              OPC_EmitMergeInputChains1_0,
/*7732*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32_USE_Gp32reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_DEC_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*7740*/            0, /*End of Scope*/
/*7741*/          0, /*End of Scope*/
/*7742*/        /*Scope*/ 7|128,1/*135*/, /*->7879*/
/*7744*/          OPC_CheckChild2Type, MVT::i64,
/*7746*/          OPC_RecordChild3, // #2 = $b
/*7747*/          OPC_Scope, 72, /*->7821*/ // 4 children in Scope
/*7749*/            OPC_MoveChild3,
/*7750*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7753*/            OPC_MoveParent,
/*7754*/            OPC_Scope, 15, /*->7771*/ // 3 children in Scope
/*7756*/              OPC_CheckPredicate, 4, // Predicate_atomic_load_dec_32_g
/*7758*/              OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7760*/              OPC_EmitMergeInputChains1_0,
/*7761*/              OPC_EmitConvertToTarget, 2,
/*7763*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_G_32p64imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_g>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_DEC_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7771*/            /*Scope*/ 15, /*->7787*/
/*7772*/              OPC_CheckPredicate, 5, // Predicate_atomic_load_dec_32_s
/*7774*/              OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7776*/              OPC_EmitMergeInputChains1_0,
/*7777*/              OPC_EmitConvertToTarget, 2,
/*7779*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_S_32p64imm), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_s>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_DEC_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7787*/            /*Scope*/ 32, /*->7820*/
/*7788*/              OPC_CheckPredicate, 6, // Predicate_atomic_load_dec_32_gen
/*7790*/              OPC_Scope, 13, /*->7805*/ // 2 children in Scope
/*7792*/                OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7794*/                OPC_EmitMergeInputChains1_0,
/*7795*/                OPC_EmitConvertToTarget, 2,
/*7797*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32p64imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_DEC_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7805*/              /*Scope*/ 13, /*->7819*/
/*7806*/                OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7808*/                OPC_EmitMergeInputChains1_0,
/*7809*/                OPC_EmitConvertToTarget, 2,
/*7811*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32_USE_Gp64imm), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 12
                        // Dst: (INT_PTX_ATOM_DEC_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*7819*/              0, /*End of Scope*/
/*7820*/            0, /*End of Scope*/
/*7821*/          /*Scope*/ 13, /*->7835*/
/*7822*/            OPC_CheckPredicate, 4, // Predicate_atomic_load_dec_32_g
/*7824*/            OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*7826*/            OPC_EmitMergeInputChains1_0,
/*7827*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_G_32p64reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_g>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_DEC_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7835*/          /*Scope*/ 13, /*->7849*/
/*7836*/            OPC_CheckPredicate, 5, // Predicate_atomic_load_dec_32_s
/*7838*/            OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*7840*/            OPC_EmitMergeInputChains1_0,
/*7841*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_S_32p64reg), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_s>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_DEC_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7849*/          /*Scope*/ 28, /*->7878*/
/*7850*/            OPC_CheckPredicate, 6, // Predicate_atomic_load_dec_32_gen
/*7852*/            OPC_Scope, 11, /*->7865*/ // 2 children in Scope
/*7854*/              OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*7856*/              OPC_EmitMergeInputChains1_0,
/*7857*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32p64reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_DEC_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7865*/            /*Scope*/ 11, /*->7877*/
/*7866*/              OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*7868*/              OPC_EmitMergeInputChains1_0,
/*7869*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_DEC_GEN_32_USE_Gp64reg), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3089:iPTR, Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_dec_32_gen>> - Complexity = 9
                      // Dst: (INT_PTX_ATOM_DEC_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*7877*/            0, /*End of Scope*/
/*7878*/          0, /*End of Scope*/
/*7879*/        0, /*End of Scope*/
/*7880*/      /*Scope*/ 88|128,1/*216*/, /*->8098*/
/*7882*/        OPC_CheckChild1Integer, 4|128,24/*3076*/, 
/*7885*/        OPC_RecordChild2, // #1 = $src
/*7886*/        OPC_Scope, 104, /*->7992*/ // 2 children in Scope
/*7888*/          OPC_CheckChild2Type, MVT::i32,
/*7890*/          OPC_RecordChild3, // #2 = $b
/*7891*/          OPC_Scope, 54, /*->7947*/ // 3 children in Scope
/*7893*/            OPC_MoveChild3,
/*7894*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*7897*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->7928
/*7900*/              OPC_MoveParent,
/*7901*/              OPC_CheckType, MVT::i32,
/*7903*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7905*/              OPC_EmitMergeInputChains1_0,
/*7906*/              OPC_EmitConvertToTarget, 2,
/*7908*/              OPC_Scope, 8, /*->7918*/ // 2 children in Scope
/*7910*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3076:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*7918*/              /*Scope*/ 8, /*->7927*/
/*7919*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3076:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*7927*/              0, /*End of Scope*/
/*7928*/            /*SwitchType*/ 16, MVT::i64,// ->7946
/*7930*/              OPC_MoveParent,
/*7931*/              OPC_CheckType, MVT::i64,
/*7933*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7935*/              OPC_EmitMergeInputChains1_0,
/*7936*/              OPC_EmitConvertToTarget, 2,
/*7938*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3076:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*7946*/            0, // EndSwitchType
/*7947*/          /*Scope*/ 27, /*->7975*/
/*7948*/            OPC_CheckChild3Type, MVT::i32,
/*7950*/            OPC_CheckType, MVT::i32,
/*7952*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7954*/            OPC_EmitMergeInputChains1_0,
/*7955*/            OPC_Scope, 8, /*->7965*/ // 2 children in Scope
/*7957*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3076:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*7965*/            /*Scope*/ 8, /*->7974*/
/*7966*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3076:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*7974*/            0, /*End of Scope*/
/*7975*/          /*Scope*/ 15, /*->7991*/
/*7976*/            OPC_CheckChild3Type, MVT::i64,
/*7978*/            OPC_CheckType, MVT::i64,
/*7980*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*7982*/            OPC_EmitMergeInputChains1_0,
/*7983*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3076:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*7991*/          0, /*End of Scope*/
/*7992*/        /*Scope*/ 104, /*->8097*/
/*7993*/          OPC_CheckChild2Type, MVT::i64,
/*7995*/          OPC_RecordChild3, // #2 = $b
/*7996*/          OPC_Scope, 54, /*->8052*/ // 3 children in Scope
/*7998*/            OPC_MoveChild3,
/*7999*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8002*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->8033
/*8005*/              OPC_MoveParent,
/*8006*/              OPC_CheckType, MVT::i32,
/*8008*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8010*/              OPC_EmitMergeInputChains1_0,
/*8011*/              OPC_EmitConvertToTarget, 2,
/*8013*/              OPC_Scope, 8, /*->8023*/ // 2 children in Scope
/*8015*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3076:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8023*/              /*Scope*/ 8, /*->8032*/
/*8024*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3076:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8032*/              0, /*End of Scope*/
/*8033*/            /*SwitchType*/ 16, MVT::i64,// ->8051
/*8035*/              OPC_MoveParent,
/*8036*/              OPC_CheckType, MVT::i64,
/*8038*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8040*/              OPC_EmitMergeInputChains1_0,
/*8041*/              OPC_EmitConvertToTarget, 2,
/*8043*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3076:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*8051*/            0, // EndSwitchType
/*8052*/          /*Scope*/ 27, /*->8080*/
/*8053*/            OPC_CheckChild3Type, MVT::i32,
/*8055*/            OPC_CheckType, MVT::i32,
/*8057*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8059*/            OPC_EmitMergeInputChains1_0,
/*8060*/            OPC_Scope, 8, /*->8070*/ // 2 children in Scope
/*8062*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3076:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_s32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8070*/            /*Scope*/ 8, /*->8079*/
/*8071*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3076:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_u32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8079*/            0, /*End of Scope*/
/*8080*/          /*Scope*/ 15, /*->8096*/
/*8081*/            OPC_CheckChild3Type, MVT::i64,
/*8083*/            OPC_CheckType, MVT::i64,
/*8085*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8087*/            OPC_EmitMergeInputChains1_0,
/*8088*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3076:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_u64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*8096*/          0, /*End of Scope*/
/*8097*/        0, /*End of Scope*/
/*8098*/      /*Scope*/ 88|128,1/*216*/, /*->8316*/
/*8100*/        OPC_CheckChild1Integer, 5|128,24/*3077*/, 
/*8103*/        OPC_RecordChild2, // #1 = $src
/*8104*/        OPC_Scope, 104, /*->8210*/ // 2 children in Scope
/*8106*/          OPC_CheckChild2Type, MVT::i32,
/*8108*/          OPC_RecordChild3, // #2 = $b
/*8109*/          OPC_Scope, 54, /*->8165*/ // 3 children in Scope
/*8111*/            OPC_MoveChild3,
/*8112*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8115*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->8146
/*8118*/              OPC_MoveParent,
/*8119*/              OPC_CheckType, MVT::i32,
/*8121*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8123*/              OPC_EmitMergeInputChains1_0,
/*8124*/              OPC_EmitConvertToTarget, 2,
/*8126*/              OPC_Scope, 8, /*->8136*/ // 2 children in Scope
/*8128*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3077:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*8136*/              /*Scope*/ 8, /*->8145*/
/*8137*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3077:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*8145*/              0, /*End of Scope*/
/*8146*/            /*SwitchType*/ 16, MVT::i64,// ->8164
/*8148*/              OPC_MoveParent,
/*8149*/              OPC_CheckType, MVT::i64,
/*8151*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8153*/              OPC_EmitMergeInputChains1_0,
/*8154*/              OPC_EmitConvertToTarget, 2,
/*8156*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3077:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*8164*/            0, // EndSwitchType
/*8165*/          /*Scope*/ 27, /*->8193*/
/*8166*/            OPC_CheckChild3Type, MVT::i32,
/*8168*/            OPC_CheckType, MVT::i32,
/*8170*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8172*/            OPC_EmitMergeInputChains1_0,
/*8173*/            OPC_Scope, 8, /*->8183*/ // 2 children in Scope
/*8175*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3077:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*8183*/            /*Scope*/ 8, /*->8192*/
/*8184*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3077:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*8192*/            0, /*End of Scope*/
/*8193*/          /*Scope*/ 15, /*->8209*/
/*8194*/            OPC_CheckChild3Type, MVT::i64,
/*8196*/            OPC_CheckType, MVT::i64,
/*8198*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8200*/            OPC_EmitMergeInputChains1_0,
/*8201*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3077:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*8209*/          0, /*End of Scope*/
/*8210*/        /*Scope*/ 104, /*->8315*/
/*8211*/          OPC_CheckChild2Type, MVT::i64,
/*8213*/          OPC_RecordChild3, // #2 = $b
/*8214*/          OPC_Scope, 54, /*->8270*/ // 3 children in Scope
/*8216*/            OPC_MoveChild3,
/*8217*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8220*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->8251
/*8223*/              OPC_MoveParent,
/*8224*/              OPC_CheckType, MVT::i32,
/*8226*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8228*/              OPC_EmitMergeInputChains1_0,
/*8229*/              OPC_EmitConvertToTarget, 2,
/*8231*/              OPC_Scope, 8, /*->8241*/ // 2 children in Scope
/*8233*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3077:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8241*/              /*Scope*/ 8, /*->8250*/
/*8242*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3077:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8250*/              0, /*End of Scope*/
/*8251*/            /*SwitchType*/ 16, MVT::i64,// ->8269
/*8253*/              OPC_MoveParent,
/*8254*/              OPC_CheckType, MVT::i64,
/*8256*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8258*/              OPC_EmitMergeInputChains1_0,
/*8259*/              OPC_EmitConvertToTarget, 2,
/*8261*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3077:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*8269*/            0, // EndSwitchType
/*8270*/          /*Scope*/ 27, /*->8298*/
/*8271*/            OPC_CheckChild3Type, MVT::i32,
/*8273*/            OPC_CheckType, MVT::i32,
/*8275*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8277*/            OPC_EmitMergeInputChains1_0,
/*8278*/            OPC_Scope, 8, /*->8288*/ // 2 children in Scope
/*8280*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3077:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_s32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8288*/            /*Scope*/ 8, /*->8297*/
/*8289*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3077:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_ADD_u32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8297*/            0, /*End of Scope*/
/*8298*/          /*Scope*/ 15, /*->8314*/
/*8299*/            OPC_CheckChild3Type, MVT::i64,
/*8301*/            OPC_CheckType, MVT::i64,
/*8303*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8305*/            OPC_EmitMergeInputChains1_0,
/*8306*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3077:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_u64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*8314*/          0, /*End of Scope*/
/*8315*/        0, /*End of Scope*/
/*8316*/      /*Scope*/ 40|128,1/*168*/, /*->8486*/
/*8318*/        OPC_CheckChild1Integer, 6|128,24/*3078*/, 
/*8321*/        OPC_RecordChild2, // #1 = $src
/*8322*/        OPC_Scope, 80, /*->8404*/ // 2 children in Scope
/*8324*/          OPC_CheckChild2Type, MVT::i32,
/*8326*/          OPC_RecordChild3, // #2 = $b
/*8327*/          OPC_Scope, 42, /*->8371*/ // 3 children in Scope
/*8329*/            OPC_MoveChild3,
/*8330*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8333*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->8352
/*8336*/              OPC_MoveParent,
/*8337*/              OPC_CheckType, MVT::i32,
/*8339*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8341*/              OPC_EmitMergeInputChains1_0,
/*8342*/              OPC_EmitConvertToTarget, 2,
/*8344*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3078:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*8352*/            /*SwitchType*/ 16, MVT::i64,// ->8370
/*8354*/              OPC_MoveParent,
/*8355*/              OPC_CheckType, MVT::i64,
/*8357*/              OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8359*/              OPC_EmitMergeInputChains1_0,
/*8360*/              OPC_EmitConvertToTarget, 2,
/*8362*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3078:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*8370*/            0, // EndSwitchType
/*8371*/          /*Scope*/ 15, /*->8387*/
/*8372*/            OPC_CheckChild3Type, MVT::i32,
/*8374*/            OPC_CheckType, MVT::i32,
/*8376*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8378*/            OPC_EmitMergeInputChains1_0,
/*8379*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3078:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*8387*/          /*Scope*/ 15, /*->8403*/
/*8388*/            OPC_CheckChild3Type, MVT::i64,
/*8390*/            OPC_CheckType, MVT::i64,
/*8392*/            OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8394*/            OPC_EmitMergeInputChains1_0,
/*8395*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3078:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*8403*/          0, /*End of Scope*/
/*8404*/        /*Scope*/ 80, /*->8485*/
/*8405*/          OPC_CheckChild2Type, MVT::i64,
/*8407*/          OPC_RecordChild3, // #2 = $b
/*8408*/          OPC_Scope, 42, /*->8452*/ // 3 children in Scope
/*8410*/            OPC_MoveChild3,
/*8411*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8414*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->8433
/*8417*/              OPC_MoveParent,
/*8418*/              OPC_CheckType, MVT::i32,
/*8420*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8422*/              OPC_EmitMergeInputChains1_0,
/*8423*/              OPC_EmitConvertToTarget, 2,
/*8425*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3078:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8433*/            /*SwitchType*/ 16, MVT::i64,// ->8451
/*8435*/              OPC_MoveParent,
/*8436*/              OPC_CheckType, MVT::i64,
/*8438*/              OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8440*/              OPC_EmitMergeInputChains1_0,
/*8441*/              OPC_EmitConvertToTarget, 2,
/*8443*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3078:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*8451*/            0, // EndSwitchType
/*8452*/          /*Scope*/ 15, /*->8468*/
/*8453*/            OPC_CheckChild3Type, MVT::i32,
/*8455*/            OPC_CheckType, MVT::i32,
/*8457*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8459*/            OPC_EmitMergeInputChains1_0,
/*8460*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3078:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8468*/          /*Scope*/ 15, /*->8484*/
/*8469*/            OPC_CheckChild3Type, MVT::i64,
/*8471*/            OPC_CheckType, MVT::i64,
/*8473*/            OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8475*/            OPC_EmitMergeInputChains1_0,
/*8476*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3078:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*8484*/          0, /*End of Scope*/
/*8485*/        0, /*End of Scope*/
/*8486*/      /*Scope*/ 40|128,1/*168*/, /*->8656*/
/*8488*/        OPC_CheckChild1Integer, 7|128,24/*3079*/, 
/*8491*/        OPC_RecordChild2, // #1 = $src
/*8492*/        OPC_Scope, 80, /*->8574*/ // 2 children in Scope
/*8494*/          OPC_CheckChild2Type, MVT::i32,
/*8496*/          OPC_RecordChild3, // #2 = $b
/*8497*/          OPC_Scope, 42, /*->8541*/ // 3 children in Scope
/*8499*/            OPC_MoveChild3,
/*8500*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8503*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->8522
/*8506*/              OPC_MoveParent,
/*8507*/              OPC_CheckType, MVT::i32,
/*8509*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8511*/              OPC_EmitMergeInputChains1_0,
/*8512*/              OPC_EmitConvertToTarget, 2,
/*8514*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3079:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*8522*/            /*SwitchType*/ 16, MVT::i64,// ->8540
/*8524*/              OPC_MoveParent,
/*8525*/              OPC_CheckType, MVT::i64,
/*8527*/              OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8529*/              OPC_EmitMergeInputChains1_0,
/*8530*/              OPC_EmitConvertToTarget, 2,
/*8532*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3079:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*8540*/            0, // EndSwitchType
/*8541*/          /*Scope*/ 15, /*->8557*/
/*8542*/            OPC_CheckChild3Type, MVT::i32,
/*8544*/            OPC_CheckType, MVT::i32,
/*8546*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8548*/            OPC_EmitMergeInputChains1_0,
/*8549*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3079:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*8557*/          /*Scope*/ 15, /*->8573*/
/*8558*/            OPC_CheckChild3Type, MVT::i64,
/*8560*/            OPC_CheckType, MVT::i64,
/*8562*/            OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8564*/            OPC_EmitMergeInputChains1_0,
/*8565*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3079:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*8573*/          0, /*End of Scope*/
/*8574*/        /*Scope*/ 80, /*->8655*/
/*8575*/          OPC_CheckChild2Type, MVT::i64,
/*8577*/          OPC_RecordChild3, // #2 = $b
/*8578*/          OPC_Scope, 42, /*->8622*/ // 3 children in Scope
/*8580*/            OPC_MoveChild3,
/*8581*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8584*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->8603
/*8587*/              OPC_MoveParent,
/*8588*/              OPC_CheckType, MVT::i32,
/*8590*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8592*/              OPC_EmitMergeInputChains1_0,
/*8593*/              OPC_EmitConvertToTarget, 2,
/*8595*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3079:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8603*/            /*SwitchType*/ 16, MVT::i64,// ->8621
/*8605*/              OPC_MoveParent,
/*8606*/              OPC_CheckType, MVT::i64,
/*8608*/              OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8610*/              OPC_EmitMergeInputChains1_0,
/*8611*/              OPC_EmitConvertToTarget, 2,
/*8613*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3079:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*8621*/            0, // EndSwitchType
/*8622*/          /*Scope*/ 15, /*->8638*/
/*8623*/            OPC_CheckChild3Type, MVT::i32,
/*8625*/            OPC_CheckType, MVT::i32,
/*8627*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8629*/            OPC_EmitMergeInputChains1_0,
/*8630*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3079:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8638*/          /*Scope*/ 15, /*->8654*/
/*8639*/            OPC_CheckChild3Type, MVT::i64,
/*8641*/            OPC_CheckType, MVT::i64,
/*8643*/            OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*8645*/            OPC_EmitMergeInputChains1_0,
/*8646*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3079:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_AND_b64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*8654*/          0, /*End of Scope*/
/*8655*/        0, /*End of Scope*/
/*8656*/      /*Scope*/ 96, /*->8753*/
/*8657*/        OPC_CheckChild1Integer, 10|128,24/*3082*/, 
/*8660*/        OPC_RecordChild2, // #1 = $src
/*8661*/        OPC_Scope, 44, /*->8707*/ // 2 children in Scope
/*8663*/          OPC_CheckChild2Type, MVT::i32,
/*8665*/          OPC_RecordChild3, // #2 = $b
/*8666*/          OPC_Scope, 22, /*->8690*/ // 2 children in Scope
/*8668*/            OPC_MoveChild3,
/*8669*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8672*/            OPC_CheckType, MVT::i32,
/*8674*/            OPC_MoveParent,
/*8675*/            OPC_CheckType, MVT::i32,
/*8677*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8679*/            OPC_EmitMergeInputChains1_0,
/*8680*/            OPC_EmitConvertToTarget, 2,
/*8682*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3082:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*8690*/          /*Scope*/ 15, /*->8706*/
/*8691*/            OPC_CheckChild3Type, MVT::i32,
/*8693*/            OPC_CheckType, MVT::i32,
/*8695*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8697*/            OPC_EmitMergeInputChains1_0,
/*8698*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3082:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*8706*/          0, /*End of Scope*/
/*8707*/        /*Scope*/ 44, /*->8752*/
/*8708*/          OPC_CheckChild2Type, MVT::i64,
/*8710*/          OPC_RecordChild3, // #2 = $b
/*8711*/          OPC_Scope, 22, /*->8735*/ // 2 children in Scope
/*8713*/            OPC_MoveChild3,
/*8714*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8717*/            OPC_CheckType, MVT::i32,
/*8719*/            OPC_MoveParent,
/*8720*/            OPC_CheckType, MVT::i32,
/*8722*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8724*/            OPC_EmitMergeInputChains1_0,
/*8725*/            OPC_EmitConvertToTarget, 2,
/*8727*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3082:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8735*/          /*Scope*/ 15, /*->8751*/
/*8736*/            OPC_CheckChild3Type, MVT::i32,
/*8738*/            OPC_CheckType, MVT::i32,
/*8740*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8742*/            OPC_EmitMergeInputChains1_0,
/*8743*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3082:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_DEC_u32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8751*/          0, /*End of Scope*/
/*8752*/        0, /*End of Scope*/
/*8753*/      /*Scope*/ 96, /*->8850*/
/*8754*/        OPC_CheckChild1Integer, 11|128,24/*3083*/, 
/*8757*/        OPC_RecordChild2, // #1 = $src
/*8758*/        OPC_Scope, 44, /*->8804*/ // 2 children in Scope
/*8760*/          OPC_CheckChild2Type, MVT::i32,
/*8762*/          OPC_RecordChild3, // #2 = $b
/*8763*/          OPC_Scope, 22, /*->8787*/ // 2 children in Scope
/*8765*/            OPC_MoveChild3,
/*8766*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8769*/            OPC_CheckType, MVT::i32,
/*8771*/            OPC_MoveParent,
/*8772*/            OPC_CheckType, MVT::i32,
/*8774*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8776*/            OPC_EmitMergeInputChains1_0,
/*8777*/            OPC_EmitConvertToTarget, 2,
/*8779*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3083:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*8787*/          /*Scope*/ 15, /*->8803*/
/*8788*/            OPC_CheckChild3Type, MVT::i32,
/*8790*/            OPC_CheckType, MVT::i32,
/*8792*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8794*/            OPC_EmitMergeInputChains1_0,
/*8795*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3083:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*8803*/          0, /*End of Scope*/
/*8804*/        /*Scope*/ 44, /*->8849*/
/*8805*/          OPC_CheckChild2Type, MVT::i64,
/*8807*/          OPC_RecordChild3, // #2 = $b
/*8808*/          OPC_Scope, 22, /*->8832*/ // 2 children in Scope
/*8810*/            OPC_MoveChild3,
/*8811*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8814*/            OPC_CheckType, MVT::i32,
/*8816*/            OPC_MoveParent,
/*8817*/            OPC_CheckType, MVT::i32,
/*8819*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8821*/            OPC_EmitMergeInputChains1_0,
/*8822*/            OPC_EmitConvertToTarget, 2,
/*8824*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3083:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8832*/          /*Scope*/ 15, /*->8848*/
/*8833*/            OPC_CheckChild3Type, MVT::i32,
/*8835*/            OPC_CheckType, MVT::i32,
/*8837*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8839*/            OPC_EmitMergeInputChains1_0,
/*8840*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3083:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_DEC_u32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*8848*/          0, /*End of Scope*/
/*8849*/        0, /*End of Scope*/
/*8850*/      /*Scope*/ 40|128,1/*168*/, /*->9020*/
/*8852*/        OPC_CheckChild1Integer, 12|128,24/*3084*/, 
/*8855*/        OPC_RecordChild2, // #1 = $src
/*8856*/        OPC_Scope, 80, /*->8938*/ // 2 children in Scope
/*8858*/          OPC_CheckChild2Type, MVT::i32,
/*8860*/          OPC_RecordChild3, // #2 = $b
/*8861*/          OPC_Scope, 42, /*->8905*/ // 3 children in Scope
/*8863*/            OPC_MoveChild3,
/*8864*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8867*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->8886
/*8870*/              OPC_MoveParent,
/*8871*/              OPC_CheckType, MVT::i32,
/*8873*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8875*/              OPC_EmitMergeInputChains1_0,
/*8876*/              OPC_EmitConvertToTarget, 2,
/*8878*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3084:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*8886*/            /*SwitchType*/ 16, MVT::i64,// ->8904
/*8888*/              OPC_MoveParent,
/*8889*/              OPC_CheckType, MVT::i64,
/*8891*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8893*/              OPC_EmitMergeInputChains1_0,
/*8894*/              OPC_EmitConvertToTarget, 2,
/*8896*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3084:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*8904*/            0, // EndSwitchType
/*8905*/          /*Scope*/ 15, /*->8921*/
/*8906*/            OPC_CheckChild3Type, MVT::i32,
/*8908*/            OPC_CheckType, MVT::i32,
/*8910*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8912*/            OPC_EmitMergeInputChains1_0,
/*8913*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3084:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*8921*/          /*Scope*/ 15, /*->8937*/
/*8922*/            OPC_CheckChild3Type, MVT::i64,
/*8924*/            OPC_CheckType, MVT::i64,
/*8926*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8928*/            OPC_EmitMergeInputChains1_0,
/*8929*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3084:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*8937*/          0, /*End of Scope*/
/*8938*/        /*Scope*/ 80, /*->9019*/
/*8939*/          OPC_CheckChild2Type, MVT::i64,
/*8941*/          OPC_RecordChild3, // #2 = $b
/*8942*/          OPC_Scope, 42, /*->8986*/ // 3 children in Scope
/*8944*/            OPC_MoveChild3,
/*8945*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*8948*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->8967
/*8951*/              OPC_MoveParent,
/*8952*/              OPC_CheckType, MVT::i32,
/*8954*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8956*/              OPC_EmitMergeInputChains1_0,
/*8957*/              OPC_EmitConvertToTarget, 2,
/*8959*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3084:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*8967*/            /*SwitchType*/ 16, MVT::i64,// ->8985
/*8969*/              OPC_MoveParent,
/*8970*/              OPC_CheckType, MVT::i64,
/*8972*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8974*/              OPC_EmitMergeInputChains1_0,
/*8975*/              OPC_EmitConvertToTarget, 2,
/*8977*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3084:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*8985*/            0, // EndSwitchType
/*8986*/          /*Scope*/ 15, /*->9002*/
/*8987*/            OPC_CheckChild3Type, MVT::i32,
/*8989*/            OPC_CheckType, MVT::i32,
/*8991*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*8993*/            OPC_EmitMergeInputChains1_0,
/*8994*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3084:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9002*/          /*Scope*/ 15, /*->9018*/
/*9003*/            OPC_CheckChild3Type, MVT::i64,
/*9005*/            OPC_CheckType, MVT::i64,
/*9007*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9009*/            OPC_EmitMergeInputChains1_0,
/*9010*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3084:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*9018*/          0, /*End of Scope*/
/*9019*/        0, /*End of Scope*/
/*9020*/      /*Scope*/ 40|128,1/*168*/, /*->9190*/
/*9022*/        OPC_CheckChild1Integer, 13|128,24/*3085*/, 
/*9025*/        OPC_RecordChild2, // #1 = $src
/*9026*/        OPC_Scope, 80, /*->9108*/ // 2 children in Scope
/*9028*/          OPC_CheckChild2Type, MVT::i32,
/*9030*/          OPC_RecordChild3, // #2 = $b
/*9031*/          OPC_Scope, 42, /*->9075*/ // 3 children in Scope
/*9033*/            OPC_MoveChild3,
/*9034*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9037*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->9056
/*9040*/              OPC_MoveParent,
/*9041*/              OPC_CheckType, MVT::i32,
/*9043*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9045*/              OPC_EmitMergeInputChains1_0,
/*9046*/              OPC_EmitConvertToTarget, 2,
/*9048*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3085:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9056*/            /*SwitchType*/ 16, MVT::i64,// ->9074
/*9058*/              OPC_MoveParent,
/*9059*/              OPC_CheckType, MVT::i64,
/*9061*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9063*/              OPC_EmitMergeInputChains1_0,
/*9064*/              OPC_EmitConvertToTarget, 2,
/*9066*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3085:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*9074*/            0, // EndSwitchType
/*9075*/          /*Scope*/ 15, /*->9091*/
/*9076*/            OPC_CheckChild3Type, MVT::i32,
/*9078*/            OPC_CheckType, MVT::i32,
/*9080*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9082*/            OPC_EmitMergeInputChains1_0,
/*9083*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3085:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*9091*/          /*Scope*/ 15, /*->9107*/
/*9092*/            OPC_CheckChild3Type, MVT::i64,
/*9094*/            OPC_CheckType, MVT::i64,
/*9096*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9098*/            OPC_EmitMergeInputChains1_0,
/*9099*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3085:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*9107*/          0, /*End of Scope*/
/*9108*/        /*Scope*/ 80, /*->9189*/
/*9109*/          OPC_CheckChild2Type, MVT::i64,
/*9111*/          OPC_RecordChild3, // #2 = $b
/*9112*/          OPC_Scope, 42, /*->9156*/ // 3 children in Scope
/*9114*/            OPC_MoveChild3,
/*9115*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9118*/            OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->9137
/*9121*/              OPC_MoveParent,
/*9122*/              OPC_CheckType, MVT::i32,
/*9124*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9126*/              OPC_EmitMergeInputChains1_0,
/*9127*/              OPC_EmitConvertToTarget, 2,
/*9129*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3085:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*9137*/            /*SwitchType*/ 16, MVT::i64,// ->9155
/*9139*/              OPC_MoveParent,
/*9140*/              OPC_CheckType, MVT::i64,
/*9142*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9144*/              OPC_EmitMergeInputChains1_0,
/*9145*/              OPC_EmitConvertToTarget, 2,
/*9147*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3085:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*9155*/            0, // EndSwitchType
/*9156*/          /*Scope*/ 15, /*->9172*/
/*9157*/            OPC_CheckChild3Type, MVT::i32,
/*9159*/            OPC_CheckType, MVT::i32,
/*9161*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9163*/            OPC_EmitMergeInputChains1_0,
/*9164*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3085:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9172*/          /*Scope*/ 15, /*->9188*/
/*9173*/            OPC_CheckChild3Type, MVT::i64,
/*9175*/            OPC_CheckType, MVT::i64,
/*9177*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9179*/            OPC_EmitMergeInputChains1_0,
/*9180*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3085:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_EXCH_b64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*9188*/          0, /*End of Scope*/
/*9189*/        0, /*End of Scope*/
/*9190*/      /*Scope*/ 96, /*->9287*/
/*9191*/        OPC_CheckChild1Integer, 14|128,24/*3086*/, 
/*9194*/        OPC_RecordChild2, // #1 = $src
/*9195*/        OPC_Scope, 44, /*->9241*/ // 2 children in Scope
/*9197*/          OPC_CheckChild2Type, MVT::i32,
/*9199*/          OPC_RecordChild3, // #2 = $b
/*9200*/          OPC_Scope, 22, /*->9224*/ // 2 children in Scope
/*9202*/            OPC_MoveChild3,
/*9203*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9206*/            OPC_CheckType, MVT::i32,
/*9208*/            OPC_MoveParent,
/*9209*/            OPC_CheckType, MVT::i32,
/*9211*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9213*/            OPC_EmitMergeInputChains1_0,
/*9214*/            OPC_EmitConvertToTarget, 2,
/*9216*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3086:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9224*/          /*Scope*/ 15, /*->9240*/
/*9225*/            OPC_CheckChild3Type, MVT::i32,
/*9227*/            OPC_CheckType, MVT::i32,
/*9229*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9231*/            OPC_EmitMergeInputChains1_0,
/*9232*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3086:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*9240*/          0, /*End of Scope*/
/*9241*/        /*Scope*/ 44, /*->9286*/
/*9242*/          OPC_CheckChild2Type, MVT::i64,
/*9244*/          OPC_RecordChild3, // #2 = $b
/*9245*/          OPC_Scope, 22, /*->9269*/ // 2 children in Scope
/*9247*/            OPC_MoveChild3,
/*9248*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9251*/            OPC_CheckType, MVT::i32,
/*9253*/            OPC_MoveParent,
/*9254*/            OPC_CheckType, MVT::i32,
/*9256*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9258*/            OPC_EmitMergeInputChains1_0,
/*9259*/            OPC_EmitConvertToTarget, 2,
/*9261*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3086:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*9269*/          /*Scope*/ 15, /*->9285*/
/*9270*/            OPC_CheckChild3Type, MVT::i32,
/*9272*/            OPC_CheckType, MVT::i32,
/*9274*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9276*/            OPC_EmitMergeInputChains1_0,
/*9277*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3086:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_INC_u32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9285*/          0, /*End of Scope*/
/*9286*/        0, /*End of Scope*/
/*9287*/      /*Scope*/ 96, /*->9384*/
/*9288*/        OPC_CheckChild1Integer, 15|128,24/*3087*/, 
/*9291*/        OPC_RecordChild2, // #1 = $src
/*9292*/        OPC_Scope, 44, /*->9338*/ // 2 children in Scope
/*9294*/          OPC_CheckChild2Type, MVT::i32,
/*9296*/          OPC_RecordChild3, // #2 = $b
/*9297*/          OPC_Scope, 22, /*->9321*/ // 2 children in Scope
/*9299*/            OPC_MoveChild3,
/*9300*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9303*/            OPC_CheckType, MVT::i32,
/*9305*/            OPC_MoveParent,
/*9306*/            OPC_CheckType, MVT::i32,
/*9308*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9310*/            OPC_EmitMergeInputChains1_0,
/*9311*/            OPC_EmitConvertToTarget, 2,
/*9313*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3087:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9321*/          /*Scope*/ 15, /*->9337*/
/*9322*/            OPC_CheckChild3Type, MVT::i32,
/*9324*/            OPC_CheckType, MVT::i32,
/*9326*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9328*/            OPC_EmitMergeInputChains1_0,
/*9329*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3087:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*9337*/          0, /*End of Scope*/
/*9338*/        /*Scope*/ 44, /*->9383*/
/*9339*/          OPC_CheckChild2Type, MVT::i64,
/*9341*/          OPC_RecordChild3, // #2 = $b
/*9342*/          OPC_Scope, 22, /*->9366*/ // 2 children in Scope
/*9344*/            OPC_MoveChild3,
/*9345*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9348*/            OPC_CheckType, MVT::i32,
/*9350*/            OPC_MoveParent,
/*9351*/            OPC_CheckType, MVT::i32,
/*9353*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9355*/            OPC_EmitMergeInputChains1_0,
/*9356*/            OPC_EmitConvertToTarget, 2,
/*9358*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 3, 
                    // Src: (intrinsic_w_chain:i32 3087:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                    // Dst: (INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*9366*/          /*Scope*/ 15, /*->9382*/
/*9367*/            OPC_CheckChild3Type, MVT::i32,
/*9369*/            OPC_CheckType, MVT::i32,
/*9371*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9373*/            OPC_EmitMergeInputChains1_0,
/*9374*/            OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3087:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_INC_u32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9382*/          0, /*End of Scope*/
/*9383*/        0, /*End of Scope*/
/*9384*/      /*Scope*/ 10|128,2/*266*/, /*->9652*/
/*9386*/        OPC_CheckChild1Integer, 19|128,24/*3091*/, 
/*9389*/        OPC_RecordChild2, // #1 = $src
/*9390*/        OPC_Scope, 0|128,1/*128*/, /*->9521*/ // 2 children in Scope
/*9393*/          OPC_CheckChild2Type, MVT::i32,
/*9395*/          OPC_RecordChild3, // #2 = $b
/*9396*/          OPC_Scope, 66, /*->9464*/ // 3 children in Scope
/*9398*/            OPC_MoveChild3,
/*9399*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9402*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->9433
/*9405*/              OPC_MoveParent,
/*9406*/              OPC_CheckType, MVT::i32,
/*9408*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9410*/              OPC_EmitMergeInputChains1_0,
/*9411*/              OPC_EmitConvertToTarget, 2,
/*9413*/              OPC_Scope, 8, /*->9423*/ // 2 children in Scope
/*9415*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3091:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9423*/              /*Scope*/ 8, /*->9432*/
/*9424*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3091:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9432*/              0, /*End of Scope*/
/*9433*/            /*SwitchType*/ 28, MVT::i64,// ->9463
/*9435*/              OPC_MoveParent,
/*9436*/              OPC_CheckType, MVT::i64,
/*9438*/              OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9440*/              OPC_EmitMergeInputChains1_0,
/*9441*/              OPC_EmitConvertToTarget, 2,
/*9443*/              OPC_Scope, 8, /*->9453*/ // 2 children in Scope
/*9445*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3091:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*9453*/              /*Scope*/ 8, /*->9462*/
/*9454*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3091:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*9462*/              0, /*End of Scope*/
/*9463*/            0, // EndSwitchType
/*9464*/          /*Scope*/ 27, /*->9492*/
/*9465*/            OPC_CheckChild3Type, MVT::i32,
/*9467*/            OPC_CheckType, MVT::i32,
/*9469*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9471*/            OPC_EmitMergeInputChains1_0,
/*9472*/            OPC_Scope, 8, /*->9482*/ // 2 children in Scope
/*9474*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3091:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*9482*/            /*Scope*/ 8, /*->9491*/
/*9483*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3091:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*9491*/            0, /*End of Scope*/
/*9492*/          /*Scope*/ 27, /*->9520*/
/*9493*/            OPC_CheckChild3Type, MVT::i64,
/*9495*/            OPC_CheckType, MVT::i64,
/*9497*/            OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9499*/            OPC_EmitMergeInputChains1_0,
/*9500*/            OPC_Scope, 8, /*->9510*/ // 2 children in Scope
/*9502*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3091:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*9510*/            /*Scope*/ 8, /*->9519*/
/*9511*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3091:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*9519*/            0, /*End of Scope*/
/*9520*/          0, /*End of Scope*/
/*9521*/        /*Scope*/ 0|128,1/*128*/, /*->9651*/
/*9523*/          OPC_CheckChild2Type, MVT::i64,
/*9525*/          OPC_RecordChild3, // #2 = $b
/*9526*/          OPC_Scope, 66, /*->9594*/ // 3 children in Scope
/*9528*/            OPC_MoveChild3,
/*9529*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9532*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->9563
/*9535*/              OPC_MoveParent,
/*9536*/              OPC_CheckType, MVT::i32,
/*9538*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9540*/              OPC_EmitMergeInputChains1_0,
/*9541*/              OPC_EmitConvertToTarget, 2,
/*9543*/              OPC_Scope, 8, /*->9553*/ // 2 children in Scope
/*9545*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3091:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*9553*/              /*Scope*/ 8, /*->9562*/
/*9554*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3091:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*9562*/              0, /*End of Scope*/
/*9563*/            /*SwitchType*/ 28, MVT::i64,// ->9593
/*9565*/              OPC_MoveParent,
/*9566*/              OPC_CheckType, MVT::i64,
/*9568*/              OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9570*/              OPC_EmitMergeInputChains1_0,
/*9571*/              OPC_EmitConvertToTarget, 2,
/*9573*/              OPC_Scope, 8, /*->9583*/ // 2 children in Scope
/*9575*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3091:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*9583*/              /*Scope*/ 8, /*->9592*/
/*9584*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3091:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*9592*/              0, /*End of Scope*/
/*9593*/            0, // EndSwitchType
/*9594*/          /*Scope*/ 27, /*->9622*/
/*9595*/            OPC_CheckChild3Type, MVT::i32,
/*9597*/            OPC_CheckType, MVT::i32,
/*9599*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9601*/            OPC_EmitMergeInputChains1_0,
/*9602*/            OPC_Scope, 8, /*->9612*/ // 2 children in Scope
/*9604*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3091:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9612*/            /*Scope*/ 8, /*->9621*/
/*9613*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3091:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9621*/            0, /*End of Scope*/
/*9622*/          /*Scope*/ 27, /*->9650*/
/*9623*/            OPC_CheckChild3Type, MVT::i64,
/*9625*/            OPC_CheckType, MVT::i64,
/*9627*/            OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9629*/            OPC_EmitMergeInputChains1_0,
/*9630*/            OPC_Scope, 8, /*->9640*/ // 2 children in Scope
/*9632*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3091:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*9640*/            /*Scope*/ 8, /*->9649*/
/*9641*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3091:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*9649*/            0, /*End of Scope*/
/*9650*/          0, /*End of Scope*/
/*9651*/        0, /*End of Scope*/
/*9652*/      /*Scope*/ 10|128,2/*266*/, /*->9920*/
/*9654*/        OPC_CheckChild1Integer, 20|128,24/*3092*/, 
/*9657*/        OPC_RecordChild2, // #1 = $src
/*9658*/        OPC_Scope, 0|128,1/*128*/, /*->9789*/ // 2 children in Scope
/*9661*/          OPC_CheckChild2Type, MVT::i32,
/*9663*/          OPC_RecordChild3, // #2 = $b
/*9664*/          OPC_Scope, 66, /*->9732*/ // 3 children in Scope
/*9666*/            OPC_MoveChild3,
/*9667*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9670*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->9701
/*9673*/              OPC_MoveParent,
/*9674*/              OPC_CheckType, MVT::i32,
/*9676*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9678*/              OPC_EmitMergeInputChains1_0,
/*9679*/              OPC_EmitConvertToTarget, 2,
/*9681*/              OPC_Scope, 8, /*->9691*/ // 2 children in Scope
/*9683*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3092:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9691*/              /*Scope*/ 8, /*->9700*/
/*9692*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3092:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9700*/              0, /*End of Scope*/
/*9701*/            /*SwitchType*/ 28, MVT::i64,// ->9731
/*9703*/              OPC_MoveParent,
/*9704*/              OPC_CheckType, MVT::i64,
/*9706*/              OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9708*/              OPC_EmitMergeInputChains1_0,
/*9709*/              OPC_EmitConvertToTarget, 2,
/*9711*/              OPC_Scope, 8, /*->9721*/ // 2 children in Scope
/*9713*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3092:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*9721*/              /*Scope*/ 8, /*->9730*/
/*9722*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3092:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*9730*/              0, /*End of Scope*/
/*9731*/            0, // EndSwitchType
/*9732*/          /*Scope*/ 27, /*->9760*/
/*9733*/            OPC_CheckChild3Type, MVT::i32,
/*9735*/            OPC_CheckType, MVT::i32,
/*9737*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9739*/            OPC_EmitMergeInputChains1_0,
/*9740*/            OPC_Scope, 8, /*->9750*/ // 2 children in Scope
/*9742*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3092:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*9750*/            /*Scope*/ 8, /*->9759*/
/*9751*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3092:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*9759*/            0, /*End of Scope*/
/*9760*/          /*Scope*/ 27, /*->9788*/
/*9761*/            OPC_CheckChild3Type, MVT::i64,
/*9763*/            OPC_CheckType, MVT::i64,
/*9765*/            OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9767*/            OPC_EmitMergeInputChains1_0,
/*9768*/            OPC_Scope, 8, /*->9778*/ // 2 children in Scope
/*9770*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3092:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*9778*/            /*Scope*/ 8, /*->9787*/
/*9779*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3092:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*9787*/            0, /*End of Scope*/
/*9788*/          0, /*End of Scope*/
/*9789*/        /*Scope*/ 0|128,1/*128*/, /*->9919*/
/*9791*/          OPC_CheckChild2Type, MVT::i64,
/*9793*/          OPC_RecordChild3, // #2 = $b
/*9794*/          OPC_Scope, 66, /*->9862*/ // 3 children in Scope
/*9796*/            OPC_MoveChild3,
/*9797*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9800*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->9831
/*9803*/              OPC_MoveParent,
/*9804*/              OPC_CheckType, MVT::i32,
/*9806*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9808*/              OPC_EmitMergeInputChains1_0,
/*9809*/              OPC_EmitConvertToTarget, 2,
/*9811*/              OPC_Scope, 8, /*->9821*/ // 2 children in Scope
/*9813*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3092:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*9821*/              /*Scope*/ 8, /*->9830*/
/*9822*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3092:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*9830*/              0, /*End of Scope*/
/*9831*/            /*SwitchType*/ 28, MVT::i64,// ->9861
/*9833*/              OPC_MoveParent,
/*9834*/              OPC_CheckType, MVT::i64,
/*9836*/              OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9838*/              OPC_EmitMergeInputChains1_0,
/*9839*/              OPC_EmitConvertToTarget, 2,
/*9841*/              OPC_Scope, 8, /*->9851*/ // 2 children in Scope
/*9843*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3092:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*9851*/              /*Scope*/ 8, /*->9860*/
/*9852*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3092:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*9860*/              0, /*End of Scope*/
/*9861*/            0, // EndSwitchType
/*9862*/          /*Scope*/ 27, /*->9890*/
/*9863*/            OPC_CheckChild3Type, MVT::i32,
/*9865*/            OPC_CheckType, MVT::i32,
/*9867*/            OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9869*/            OPC_EmitMergeInputChains1_0,
/*9870*/            OPC_Scope, 8, /*->9880*/ // 2 children in Scope
/*9872*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3092:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9880*/            /*Scope*/ 8, /*->9889*/
/*9881*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3092:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*9889*/            0, /*End of Scope*/
/*9890*/          /*Scope*/ 27, /*->9918*/
/*9891*/            OPC_CheckChild3Type, MVT::i64,
/*9893*/            OPC_CheckType, MVT::i64,
/*9895*/            OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9897*/            OPC_EmitMergeInputChains1_0,
/*9898*/            OPC_Scope, 8, /*->9908*/ // 2 children in Scope
/*9900*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3092:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_s64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*9908*/            /*Scope*/ 8, /*->9917*/
/*9909*/              OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3092:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MAX_u64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*9917*/            0, /*End of Scope*/
/*9918*/          0, /*End of Scope*/
/*9919*/        0, /*End of Scope*/
/*9920*/      /*Scope*/ 10|128,2/*266*/, /*->10188*/
/*9922*/        OPC_CheckChild1Integer, 21|128,24/*3093*/, 
/*9925*/        OPC_RecordChild2, // #1 = $src
/*9926*/        OPC_Scope, 0|128,1/*128*/, /*->10057*/ // 2 children in Scope
/*9929*/          OPC_CheckChild2Type, MVT::i32,
/*9931*/          OPC_RecordChild3, // #2 = $b
/*9932*/          OPC_Scope, 66, /*->10000*/ // 3 children in Scope
/*9934*/            OPC_MoveChild3,
/*9935*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9938*/            OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->9969
/*9941*/              OPC_MoveParent,
/*9942*/              OPC_CheckType, MVT::i32,
/*9944*/              OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*9946*/              OPC_EmitMergeInputChains1_0,
/*9947*/              OPC_EmitConvertToTarget, 2,
/*9949*/              OPC_Scope, 8, /*->9959*/ // 2 children in Scope
/*9951*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3093:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9959*/              /*Scope*/ 8, /*->9968*/
/*9960*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3093:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*9968*/              0, /*End of Scope*/
/*9969*/            /*SwitchType*/ 28, MVT::i64,// ->9999
/*9971*/              OPC_MoveParent,
/*9972*/              OPC_CheckType, MVT::i64,
/*9974*/              OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*9976*/              OPC_EmitMergeInputChains1_0,
/*9977*/              OPC_EmitConvertToTarget, 2,
/*9979*/              OPC_Scope, 8, /*->9989*/ // 2 children in Scope
/*9981*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3093:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*9989*/              /*Scope*/ 8, /*->9998*/
/*9990*/                OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3093:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*9998*/              0, /*End of Scope*/
/*9999*/            0, // EndSwitchType
/*10000*/         /*Scope*/ 27, /*->10028*/
/*10001*/           OPC_CheckChild3Type, MVT::i32,
/*10003*/           OPC_CheckType, MVT::i32,
/*10005*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10007*/           OPC_EmitMergeInputChains1_0,
/*10008*/           OPC_Scope, 8, /*->10018*/ // 2 children in Scope
/*10010*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3093:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*10018*/           /*Scope*/ 8, /*->10027*/
/*10019*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3093:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*10027*/           0, /*End of Scope*/
/*10028*/         /*Scope*/ 27, /*->10056*/
/*10029*/           OPC_CheckChild3Type, MVT::i64,
/*10031*/           OPC_CheckType, MVT::i64,
/*10033*/           OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*10035*/           OPC_EmitMergeInputChains1_0,
/*10036*/           OPC_Scope, 8, /*->10046*/ // 2 children in Scope
/*10038*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3093:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*10046*/           /*Scope*/ 8, /*->10055*/
/*10047*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3093:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*10055*/           0, /*End of Scope*/
/*10056*/         0, /*End of Scope*/
/*10057*/       /*Scope*/ 0|128,1/*128*/, /*->10187*/
/*10059*/         OPC_CheckChild2Type, MVT::i64,
/*10061*/         OPC_RecordChild3, // #2 = $b
/*10062*/         OPC_Scope, 66, /*->10130*/ // 3 children in Scope
/*10064*/           OPC_MoveChild3,
/*10065*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10068*/           OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->10099
/*10071*/             OPC_MoveParent,
/*10072*/             OPC_CheckType, MVT::i32,
/*10074*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10076*/             OPC_EmitMergeInputChains1_0,
/*10077*/             OPC_EmitConvertToTarget, 2,
/*10079*/             OPC_Scope, 8, /*->10089*/ // 2 children in Scope
/*10081*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3093:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*10089*/             /*Scope*/ 8, /*->10098*/
/*10090*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3093:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*10098*/             0, /*End of Scope*/
/*10099*/           /*SwitchType*/ 28, MVT::i64,// ->10129
/*10101*/             OPC_MoveParent,
/*10102*/             OPC_CheckType, MVT::i64,
/*10104*/             OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*10106*/             OPC_EmitMergeInputChains1_0,
/*10107*/             OPC_EmitConvertToTarget, 2,
/*10109*/             OPC_Scope, 8, /*->10119*/ // 2 children in Scope
/*10111*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3093:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*10119*/             /*Scope*/ 8, /*->10128*/
/*10120*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3093:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*10128*/             0, /*End of Scope*/
/*10129*/           0, // EndSwitchType
/*10130*/         /*Scope*/ 27, /*->10158*/
/*10131*/           OPC_CheckChild3Type, MVT::i32,
/*10133*/           OPC_CheckType, MVT::i32,
/*10135*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10137*/           OPC_EmitMergeInputChains1_0,
/*10138*/           OPC_Scope, 8, /*->10148*/ // 2 children in Scope
/*10140*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3093:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*10148*/           /*Scope*/ 8, /*->10157*/
/*10149*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3093:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*10157*/           0, /*End of Scope*/
/*10158*/         /*Scope*/ 27, /*->10186*/
/*10159*/           OPC_CheckChild3Type, MVT::i64,
/*10161*/           OPC_CheckType, MVT::i64,
/*10163*/           OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*10165*/           OPC_EmitMergeInputChains1_0,
/*10166*/           OPC_Scope, 8, /*->10176*/ // 2 children in Scope
/*10168*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3093:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*10176*/           /*Scope*/ 8, /*->10185*/
/*10177*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3093:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*10185*/           0, /*End of Scope*/
/*10186*/         0, /*End of Scope*/
/*10187*/       0, /*End of Scope*/
/*10188*/     /*Scope*/ 10|128,2/*266*/, /*->10456*/
/*10190*/       OPC_CheckChild1Integer, 22|128,24/*3094*/, 
/*10193*/       OPC_RecordChild2, // #1 = $src
/*10194*/       OPC_Scope, 0|128,1/*128*/, /*->10325*/ // 2 children in Scope
/*10197*/         OPC_CheckChild2Type, MVT::i32,
/*10199*/         OPC_RecordChild3, // #2 = $b
/*10200*/         OPC_Scope, 66, /*->10268*/ // 3 children in Scope
/*10202*/           OPC_MoveChild3,
/*10203*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10206*/           OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->10237
/*10209*/             OPC_MoveParent,
/*10210*/             OPC_CheckType, MVT::i32,
/*10212*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10214*/             OPC_EmitMergeInputChains1_0,
/*10215*/             OPC_EmitConvertToTarget, 2,
/*10217*/             OPC_Scope, 8, /*->10227*/ // 2 children in Scope
/*10219*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3094:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*10227*/             /*Scope*/ 8, /*->10236*/
/*10228*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3094:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*10236*/             0, /*End of Scope*/
/*10237*/           /*SwitchType*/ 28, MVT::i64,// ->10267
/*10239*/             OPC_MoveParent,
/*10240*/             OPC_CheckType, MVT::i64,
/*10242*/             OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*10244*/             OPC_EmitMergeInputChains1_0,
/*10245*/             OPC_EmitConvertToTarget, 2,
/*10247*/             OPC_Scope, 8, /*->10257*/ // 2 children in Scope
/*10249*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3094:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*10257*/             /*Scope*/ 8, /*->10266*/
/*10258*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3094:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*10266*/             0, /*End of Scope*/
/*10267*/           0, // EndSwitchType
/*10268*/         /*Scope*/ 27, /*->10296*/
/*10269*/           OPC_CheckChild3Type, MVT::i32,
/*10271*/           OPC_CheckType, MVT::i32,
/*10273*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10275*/           OPC_EmitMergeInputChains1_0,
/*10276*/           OPC_Scope, 8, /*->10286*/ // 2 children in Scope
/*10278*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3094:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*10286*/           /*Scope*/ 8, /*->10295*/
/*10287*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3094:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*10295*/           0, /*End of Scope*/
/*10296*/         /*Scope*/ 27, /*->10324*/
/*10297*/           OPC_CheckChild3Type, MVT::i64,
/*10299*/           OPC_CheckType, MVT::i64,
/*10301*/           OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*10303*/           OPC_EmitMergeInputChains1_0,
/*10304*/           OPC_Scope, 8, /*->10314*/ // 2 children in Scope
/*10306*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3094:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*10314*/           /*Scope*/ 8, /*->10323*/
/*10315*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3094:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*10323*/           0, /*End of Scope*/
/*10324*/         0, /*End of Scope*/
/*10325*/       /*Scope*/ 0|128,1/*128*/, /*->10455*/
/*10327*/         OPC_CheckChild2Type, MVT::i64,
/*10329*/         OPC_RecordChild3, // #2 = $b
/*10330*/         OPC_Scope, 66, /*->10398*/ // 3 children in Scope
/*10332*/           OPC_MoveChild3,
/*10333*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10336*/           OPC_SwitchType /*2 cases */, 28, MVT::i32,// ->10367
/*10339*/             OPC_MoveParent,
/*10340*/             OPC_CheckType, MVT::i32,
/*10342*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10344*/             OPC_EmitMergeInputChains1_0,
/*10345*/             OPC_EmitConvertToTarget, 2,
/*10347*/             OPC_Scope, 8, /*->10357*/ // 2 children in Scope
/*10349*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3094:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*10357*/             /*Scope*/ 8, /*->10366*/
/*10358*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i32 3094:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*10366*/             0, /*End of Scope*/
/*10367*/           /*SwitchType*/ 28, MVT::i64,// ->10397
/*10369*/             OPC_MoveParent,
/*10370*/             OPC_CheckType, MVT::i64,
/*10372*/             OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*10374*/             OPC_EmitMergeInputChains1_0,
/*10375*/             OPC_EmitConvertToTarget, 2,
/*10377*/             OPC_Scope, 8, /*->10387*/ // 2 children in Scope
/*10379*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3094:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*10387*/             /*Scope*/ 8, /*->10396*/
/*10388*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (intrinsic_w_chain:i64 3094:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                        // Dst: (INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*10396*/             0, /*End of Scope*/
/*10397*/           0, // EndSwitchType
/*10398*/         /*Scope*/ 27, /*->10426*/
/*10399*/           OPC_CheckChild3Type, MVT::i32,
/*10401*/           OPC_CheckType, MVT::i32,
/*10403*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10405*/           OPC_EmitMergeInputChains1_0,
/*10406*/           OPC_Scope, 8, /*->10416*/ // 2 children in Scope
/*10408*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3094:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*10416*/           /*Scope*/ 8, /*->10425*/
/*10417*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i32 3094:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*10425*/           0, /*End of Scope*/
/*10426*/         /*Scope*/ 27, /*->10454*/
/*10427*/           OPC_CheckChild3Type, MVT::i64,
/*10429*/           OPC_CheckType, MVT::i64,
/*10431*/           OPC_CheckPatternPredicate, 13, // (Subtarget->hasAtomMinMax64()) && (Subtarget->hasAtomScope())
/*10433*/           OPC_EmitMergeInputChains1_0,
/*10434*/           OPC_Scope, 8, /*->10444*/ // 2 children in Scope
/*10436*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3094:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_s64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*10444*/           /*Scope*/ 8, /*->10453*/
/*10445*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (intrinsic_w_chain:i64 3094:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                      // Dst: (INT_PTX_SATOM_MIN_u64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*10453*/           0, /*End of Scope*/
/*10454*/         0, /*End of Scope*/
/*10455*/       0, /*End of Scope*/
/*10456*/     /*Scope*/ 40|128,1/*168*/, /*->10626*/
/*10458*/       OPC_CheckChild1Integer, 23|128,24/*3095*/, 
/*10461*/       OPC_RecordChild2, // #1 = $src
/*10462*/       OPC_Scope, 80, /*->10544*/ // 2 children in Scope
/*10464*/         OPC_CheckChild2Type, MVT::i32,
/*10466*/         OPC_RecordChild3, // #2 = $b
/*10467*/         OPC_Scope, 42, /*->10511*/ // 3 children in Scope
/*10469*/           OPC_MoveChild3,
/*10470*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10473*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->10492
/*10476*/             OPC_MoveParent,
/*10477*/             OPC_CheckType, MVT::i32,
/*10479*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10481*/             OPC_EmitMergeInputChains1_0,
/*10482*/             OPC_EmitConvertToTarget, 2,
/*10484*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3095:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*10492*/           /*SwitchType*/ 16, MVT::i64,// ->10510
/*10494*/             OPC_MoveParent,
/*10495*/             OPC_CheckType, MVT::i64,
/*10497*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10499*/             OPC_EmitMergeInputChains1_0,
/*10500*/             OPC_EmitConvertToTarget, 2,
/*10502*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3095:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*10510*/           0, // EndSwitchType
/*10511*/         /*Scope*/ 15, /*->10527*/
/*10512*/           OPC_CheckChild3Type, MVT::i32,
/*10514*/           OPC_CheckType, MVT::i32,
/*10516*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10518*/           OPC_EmitMergeInputChains1_0,
/*10519*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3095:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*10527*/         /*Scope*/ 15, /*->10543*/
/*10528*/           OPC_CheckChild3Type, MVT::i64,
/*10530*/           OPC_CheckType, MVT::i64,
/*10532*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10534*/           OPC_EmitMergeInputChains1_0,
/*10535*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3095:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*10543*/         0, /*End of Scope*/
/*10544*/       /*Scope*/ 80, /*->10625*/
/*10545*/         OPC_CheckChild2Type, MVT::i64,
/*10547*/         OPC_RecordChild3, // #2 = $b
/*10548*/         OPC_Scope, 42, /*->10592*/ // 3 children in Scope
/*10550*/           OPC_MoveChild3,
/*10551*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10554*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->10573
/*10557*/             OPC_MoveParent,
/*10558*/             OPC_CheckType, MVT::i32,
/*10560*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10562*/             OPC_EmitMergeInputChains1_0,
/*10563*/             OPC_EmitConvertToTarget, 2,
/*10565*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3095:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*10573*/           /*SwitchType*/ 16, MVT::i64,// ->10591
/*10575*/             OPC_MoveParent,
/*10576*/             OPC_CheckType, MVT::i64,
/*10578*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10580*/             OPC_EmitMergeInputChains1_0,
/*10581*/             OPC_EmitConvertToTarget, 2,
/*10583*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3095:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*10591*/           0, // EndSwitchType
/*10592*/         /*Scope*/ 15, /*->10608*/
/*10593*/           OPC_CheckChild3Type, MVT::i32,
/*10595*/           OPC_CheckType, MVT::i32,
/*10597*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10599*/           OPC_EmitMergeInputChains1_0,
/*10600*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3095:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*10608*/         /*Scope*/ 15, /*->10624*/
/*10609*/           OPC_CheckChild3Type, MVT::i64,
/*10611*/           OPC_CheckType, MVT::i64,
/*10613*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10615*/           OPC_EmitMergeInputChains1_0,
/*10616*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3095:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*10624*/         0, /*End of Scope*/
/*10625*/       0, /*End of Scope*/
/*10626*/     /*Scope*/ 40|128,1/*168*/, /*->10796*/
/*10628*/       OPC_CheckChild1Integer, 24|128,24/*3096*/, 
/*10631*/       OPC_RecordChild2, // #1 = $src
/*10632*/       OPC_Scope, 80, /*->10714*/ // 2 children in Scope
/*10634*/         OPC_CheckChild2Type, MVT::i32,
/*10636*/         OPC_RecordChild3, // #2 = $b
/*10637*/         OPC_Scope, 42, /*->10681*/ // 3 children in Scope
/*10639*/           OPC_MoveChild3,
/*10640*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10643*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->10662
/*10646*/             OPC_MoveParent,
/*10647*/             OPC_CheckType, MVT::i32,
/*10649*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10651*/             OPC_EmitMergeInputChains1_0,
/*10652*/             OPC_EmitConvertToTarget, 2,
/*10654*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3096:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*10662*/           /*SwitchType*/ 16, MVT::i64,// ->10680
/*10664*/             OPC_MoveParent,
/*10665*/             OPC_CheckType, MVT::i64,
/*10667*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10669*/             OPC_EmitMergeInputChains1_0,
/*10670*/             OPC_EmitConvertToTarget, 2,
/*10672*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3096:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*10680*/           0, // EndSwitchType
/*10681*/         /*Scope*/ 15, /*->10697*/
/*10682*/           OPC_CheckChild3Type, MVT::i32,
/*10684*/           OPC_CheckType, MVT::i32,
/*10686*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10688*/           OPC_EmitMergeInputChains1_0,
/*10689*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3096:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*10697*/         /*Scope*/ 15, /*->10713*/
/*10698*/           OPC_CheckChild3Type, MVT::i64,
/*10700*/           OPC_CheckType, MVT::i64,
/*10702*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10704*/           OPC_EmitMergeInputChains1_0,
/*10705*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3096:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*10713*/         0, /*End of Scope*/
/*10714*/       /*Scope*/ 80, /*->10795*/
/*10715*/         OPC_CheckChild2Type, MVT::i64,
/*10717*/         OPC_RecordChild3, // #2 = $b
/*10718*/         OPC_Scope, 42, /*->10762*/ // 3 children in Scope
/*10720*/           OPC_MoveChild3,
/*10721*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10724*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->10743
/*10727*/             OPC_MoveParent,
/*10728*/             OPC_CheckType, MVT::i32,
/*10730*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10732*/             OPC_EmitMergeInputChains1_0,
/*10733*/             OPC_EmitConvertToTarget, 2,
/*10735*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3096:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*10743*/           /*SwitchType*/ 16, MVT::i64,// ->10761
/*10745*/             OPC_MoveParent,
/*10746*/             OPC_CheckType, MVT::i64,
/*10748*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10750*/             OPC_EmitMergeInputChains1_0,
/*10751*/             OPC_EmitConvertToTarget, 2,
/*10753*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3096:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*10761*/           0, // EndSwitchType
/*10762*/         /*Scope*/ 15, /*->10778*/
/*10763*/           OPC_CheckChild3Type, MVT::i32,
/*10765*/           OPC_CheckType, MVT::i32,
/*10767*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10769*/           OPC_EmitMergeInputChains1_0,
/*10770*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3096:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*10778*/         /*Scope*/ 15, /*->10794*/
/*10779*/           OPC_CheckChild3Type, MVT::i64,
/*10781*/           OPC_CheckType, MVT::i64,
/*10783*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10785*/           OPC_EmitMergeInputChains1_0,
/*10786*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3096:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_OR_b64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*10794*/         0, /*End of Scope*/
/*10795*/       0, /*End of Scope*/
/*10796*/     /*Scope*/ 40|128,1/*168*/, /*->10966*/
/*10798*/       OPC_CheckChild1Integer, 25|128,24/*3097*/, 
/*10801*/       OPC_RecordChild2, // #1 = $src
/*10802*/       OPC_Scope, 80, /*->10884*/ // 2 children in Scope
/*10804*/         OPC_CheckChild2Type, MVT::i32,
/*10806*/         OPC_RecordChild3, // #2 = $b
/*10807*/         OPC_Scope, 42, /*->10851*/ // 3 children in Scope
/*10809*/           OPC_MoveChild3,
/*10810*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10813*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->10832
/*10816*/             OPC_MoveParent,
/*10817*/             OPC_CheckType, MVT::i32,
/*10819*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10821*/             OPC_EmitMergeInputChains1_0,
/*10822*/             OPC_EmitConvertToTarget, 2,
/*10824*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3097:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*10832*/           /*SwitchType*/ 16, MVT::i64,// ->10850
/*10834*/             OPC_MoveParent,
/*10835*/             OPC_CheckType, MVT::i64,
/*10837*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10839*/             OPC_EmitMergeInputChains1_0,
/*10840*/             OPC_EmitConvertToTarget, 2,
/*10842*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3097:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*10850*/           0, // EndSwitchType
/*10851*/         /*Scope*/ 15, /*->10867*/
/*10852*/           OPC_CheckChild3Type, MVT::i32,
/*10854*/           OPC_CheckType, MVT::i32,
/*10856*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10858*/           OPC_EmitMergeInputChains1_0,
/*10859*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3097:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*10867*/         /*Scope*/ 15, /*->10883*/
/*10868*/           OPC_CheckChild3Type, MVT::i64,
/*10870*/           OPC_CheckType, MVT::i64,
/*10872*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10874*/           OPC_EmitMergeInputChains1_0,
/*10875*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3097:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*10883*/         0, /*End of Scope*/
/*10884*/       /*Scope*/ 80, /*->10965*/
/*10885*/         OPC_CheckChild2Type, MVT::i64,
/*10887*/         OPC_RecordChild3, // #2 = $b
/*10888*/         OPC_Scope, 42, /*->10932*/ // 3 children in Scope
/*10890*/           OPC_MoveChild3,
/*10891*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10894*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->10913
/*10897*/             OPC_MoveParent,
/*10898*/             OPC_CheckType, MVT::i32,
/*10900*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10902*/             OPC_EmitMergeInputChains1_0,
/*10903*/             OPC_EmitConvertToTarget, 2,
/*10905*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3097:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*10913*/           /*SwitchType*/ 16, MVT::i64,// ->10931
/*10915*/             OPC_MoveParent,
/*10916*/             OPC_CheckType, MVT::i64,
/*10918*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10920*/             OPC_EmitMergeInputChains1_0,
/*10921*/             OPC_EmitConvertToTarget, 2,
/*10923*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3097:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*10931*/           0, // EndSwitchType
/*10932*/         /*Scope*/ 15, /*->10948*/
/*10933*/           OPC_CheckChild3Type, MVT::i32,
/*10935*/           OPC_CheckType, MVT::i32,
/*10937*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10939*/           OPC_EmitMergeInputChains1_0,
/*10940*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3097:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b32_cta_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*10948*/         /*Scope*/ 15, /*->10964*/
/*10949*/           OPC_CheckChild3Type, MVT::i64,
/*10951*/           OPC_CheckType, MVT::i64,
/*10953*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*10955*/           OPC_EmitMergeInputChains1_0,
/*10956*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3097:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b64_cta_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*10964*/         0, /*End of Scope*/
/*10965*/       0, /*End of Scope*/
/*10966*/     /*Scope*/ 40|128,1/*168*/, /*->11136*/
/*10968*/       OPC_CheckChild1Integer, 26|128,24/*3098*/, 
/*10971*/       OPC_RecordChild2, // #1 = $src
/*10972*/       OPC_Scope, 80, /*->11054*/ // 2 children in Scope
/*10974*/         OPC_CheckChild2Type, MVT::i32,
/*10976*/         OPC_RecordChild3, // #2 = $b
/*10977*/         OPC_Scope, 42, /*->11021*/ // 3 children in Scope
/*10979*/           OPC_MoveChild3,
/*10980*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*10983*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->11002
/*10986*/             OPC_MoveParent,
/*10987*/             OPC_CheckType, MVT::i32,
/*10989*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*10991*/             OPC_EmitMergeInputChains1_0,
/*10992*/             OPC_EmitConvertToTarget, 2,
/*10994*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3098:iPTR, Int32Regs:i32:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1042:i32 Int32Regs:i32:$src, (imm:i32):$b)
/*11002*/           /*SwitchType*/ 16, MVT::i64,// ->11020
/*11004*/             OPC_MoveParent,
/*11005*/             OPC_CheckType, MVT::i64,
/*11007*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*11009*/             OPC_EmitMergeInputChains1_0,
/*11010*/             OPC_EmitConvertToTarget, 2,
/*11012*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3098:iPTR, Int32Regs:i32:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1042:i64 Int32Regs:i32:$src, (imm:i64):$b)
/*11020*/           0, // EndSwitchType
/*11021*/         /*Scope*/ 15, /*->11037*/
/*11022*/           OPC_CheckChild3Type, MVT::i32,
/*11024*/           OPC_CheckType, MVT::i32,
/*11026*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*11028*/           OPC_EmitMergeInputChains1_0,
/*11029*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3098:iPTR, Int32Regs:i32:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1040:i32 Int32Regs:i32:$src, Int32Regs:i32:$b)
/*11037*/         /*Scope*/ 15, /*->11053*/
/*11038*/           OPC_CheckChild3Type, MVT::i64,
/*11040*/           OPC_CheckType, MVT::i64,
/*11042*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*11044*/           OPC_EmitMergeInputChains1_0,
/*11045*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3098:iPTR, Int32Regs:i32:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1040:i64 Int32Regs:i32:$src, Int64Regs:i64:$b)
/*11053*/         0, /*End of Scope*/
/*11054*/       /*Scope*/ 80, /*->11135*/
/*11055*/         OPC_CheckChild2Type, MVT::i64,
/*11057*/         OPC_RecordChild3, // #2 = $b
/*11058*/         OPC_Scope, 42, /*->11102*/ // 3 children in Scope
/*11060*/           OPC_MoveChild3,
/*11061*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11064*/           OPC_SwitchType /*2 cases */, 16, MVT::i32,// ->11083
/*11067*/             OPC_MoveParent,
/*11068*/             OPC_CheckType, MVT::i32,
/*11070*/             OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*11072*/             OPC_EmitMergeInputChains1_0,
/*11073*/             OPC_EmitConvertToTarget, 2,
/*11075*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i32 3098:iPTR, Int64Regs:i64:$src, (imm:i32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1043:i32 Int64Regs:i64:$src, (imm:i32):$b)
/*11083*/           /*SwitchType*/ 16, MVT::i64,// ->11101
/*11085*/             OPC_MoveParent,
/*11086*/             OPC_CheckType, MVT::i64,
/*11088*/             OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*11090*/             OPC_EmitMergeInputChains1_0,
/*11091*/             OPC_EmitConvertToTarget, 2,
/*11093*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:i64 3098:iPTR, Int64Regs:i64:$src, (imm:i64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1043:i64 Int64Regs:i64:$src, (imm:i64):$b)
/*11101*/           0, // EndSwitchType
/*11102*/         /*Scope*/ 15, /*->11118*/
/*11103*/           OPC_CheckChild3Type, MVT::i32,
/*11105*/           OPC_CheckType, MVT::i32,
/*11107*/           OPC_CheckPatternPredicate, 7, // (Subtarget->hasAtomScope())
/*11109*/           OPC_EmitMergeInputChains1_0,
/*11110*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i32 3098:iPTR, Int64Regs:i64:$src, Int32Regs:i32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b32_sys_gen_anonymous_1052anonymous_1041:i32 Int64Regs:i64:$src, Int32Regs:i32:$b)
/*11118*/         /*Scope*/ 15, /*->11134*/
/*11119*/           OPC_CheckChild3Type, MVT::i64,
/*11121*/           OPC_CheckType, MVT::i64,
/*11123*/           OPC_CheckPatternPredicate, 12, // (Subtarget->hasAtomBitwise64()) && (Subtarget->hasAtomScope())
/*11125*/           OPC_EmitMergeInputChains1_0,
/*11126*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:i64 3098:iPTR, Int64Regs:i64:$src, Int64Regs:i64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_XOR_b64_sys_gen_anonymous_1052anonymous_1041:i64 Int64Regs:i64:$src, Int64Regs:i64:$b)
/*11134*/         0, /*End of Scope*/
/*11135*/       0, /*End of Scope*/
/*11136*/     /*Scope*/ 12, /*->11149*/
/*11137*/       OPC_CheckChild1Integer, 33|128,24/*3105*/, 
/*11140*/       OPC_RecordChild2, // #1 = $pred
/*11141*/       OPC_EmitMergeInputChains1_0,
/*11142*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_BARRIER0_POPC), 0|OPFL_Chain,
                    MVT::i32, 1/*#Ops*/, 1, 
                // Src: (intrinsic_w_chain:i32 3105:iPTR, Int32Regs:i32:$pred) - Complexity = 8
                // Dst: (INT_BARRIER0_POPC:i32 Int32Regs:i32:$pred)
/*11149*/     /*Scope*/ 12, /*->11162*/
/*11150*/       OPC_CheckChild1Integer, 31|128,24/*3103*/, 
/*11153*/       OPC_RecordChild2, // #1 = $pred
/*11154*/       OPC_EmitMergeInputChains1_0,
/*11155*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_BARRIER0_AND), 0|OPFL_Chain,
                    MVT::i32, 1/*#Ops*/, 1, 
                // Src: (intrinsic_w_chain:i32 3103:iPTR, Int32Regs:i32:$pred) - Complexity = 8
                // Dst: (INT_BARRIER0_AND:i32 Int32Regs:i32:$pred)
/*11162*/     /*Scope*/ 12, /*->11175*/
/*11163*/       OPC_CheckChild1Integer, 32|128,24/*3104*/, 
/*11166*/       OPC_RecordChild2, // #1 = $pred
/*11167*/       OPC_EmitMergeInputChains1_0,
/*11168*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_BARRIER0_OR), 0|OPFL_Chain,
                    MVT::i32, 1/*#Ops*/, 1, 
                // Src: (intrinsic_w_chain:i32 3104:iPTR, Int32Regs:i32:$pred) - Complexity = 8
                // Dst: (INT_BARRIER0_OR:i32 Int32Regs:i32:$pred)
/*11175*/     /*Scope*/ 86|128,1/*214*/, /*->11391*/
/*11177*/       OPC_CheckChild1Integer, 16|128,24/*3088*/, 
/*11180*/       OPC_RecordChild2, // #1 = $addr
/*11181*/       OPC_Scope, 103, /*->11286*/ // 2 children in Scope
/*11183*/         OPC_CheckChild2Type, MVT::i32,
/*11185*/         OPC_RecordChild3, // #2 = $b
/*11186*/         OPC_Scope, 55, /*->11243*/ // 4 children in Scope
/*11188*/           OPC_MoveChild3,
/*11189*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*11192*/           OPC_MoveParent,
/*11193*/           OPC_Scope, 15, /*->11210*/ // 3 children in Scope
/*11195*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_add_f32_g
/*11197*/             OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11199*/             OPC_EmitMergeInputChains1_0,
/*11200*/             OPC_EmitConvertToTarget, 2,
/*11202*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_F32p32imm), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3088:iPTR, Int32Regs:i32:$addr, (fpimm:f32):$b)<<P:Predicate_atomic_load_add_f32_g>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_ADD_G_F32p32imm:f32 Int32Regs:i32:$addr, (fpimm:f32):$b)
/*11210*/           /*Scope*/ 15, /*->11226*/
/*11211*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_add_f32_s
/*11213*/             OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11215*/             OPC_EmitMergeInputChains1_0,
/*11216*/             OPC_EmitConvertToTarget, 2,
/*11218*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_F32p32imm), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3088:iPTR, Int32Regs:i32:$addr, (fpimm:f32):$b)<<P:Predicate_atomic_load_add_f32_s>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_ADD_S_F32p32imm:f32 Int32Regs:i32:$addr, (fpimm:f32):$b)
/*11226*/           /*Scope*/ 15, /*->11242*/
/*11227*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_add_f32_gen
/*11229*/             OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11231*/             OPC_EmitMergeInputChains1_0,
/*11232*/             OPC_EmitConvertToTarget, 2,
/*11234*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_F32p32imm), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3088:iPTR, Int32Regs:i32:$addr, (fpimm:f32):$b)<<P:Predicate_atomic_load_add_f32_gen>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_ADD_GEN_F32p32imm:f32 Int32Regs:i32:$addr, (fpimm:f32):$b)
/*11242*/           0, /*End of Scope*/
/*11243*/         /*Scope*/ 13, /*->11257*/
/*11244*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_add_f32_g
/*11246*/           OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11248*/           OPC_EmitMergeInputChains1_0,
/*11249*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_F32p32reg), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3088:iPTR, Int32Regs:i32:$addr, Float32Regs:f32:$b)<<P:Predicate_atomic_load_add_f32_g>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_ADD_G_F32p32reg:f32 Int32Regs:i32:$addr, Float32Regs:f32:$b)
/*11257*/         /*Scope*/ 13, /*->11271*/
/*11258*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_add_f32_s
/*11260*/           OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11262*/           OPC_EmitMergeInputChains1_0,
/*11263*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_F32p32reg), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3088:iPTR, Int32Regs:i32:$addr, Float32Regs:f32:$b)<<P:Predicate_atomic_load_add_f32_s>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_ADD_S_F32p32reg:f32 Int32Regs:i32:$addr, Float32Regs:f32:$b)
/*11271*/         /*Scope*/ 13, /*->11285*/
/*11272*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_add_f32_gen
/*11274*/           OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11276*/           OPC_EmitMergeInputChains1_0,
/*11277*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_F32p32reg), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3088:iPTR, Int32Regs:i32:$addr, Float32Regs:f32:$b)<<P:Predicate_atomic_load_add_f32_gen>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_ADD_GEN_F32p32reg:f32 Int32Regs:i32:$addr, Float32Regs:f32:$b)
/*11285*/         0, /*End of Scope*/
/*11286*/       /*Scope*/ 103, /*->11390*/
/*11287*/         OPC_CheckChild2Type, MVT::i64,
/*11289*/         OPC_RecordChild3, // #2 = $b
/*11290*/         OPC_Scope, 55, /*->11347*/ // 4 children in Scope
/*11292*/           OPC_MoveChild3,
/*11293*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*11296*/           OPC_MoveParent,
/*11297*/           OPC_Scope, 15, /*->11314*/ // 3 children in Scope
/*11299*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_add_f32_g
/*11301*/             OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11303*/             OPC_EmitMergeInputChains1_0,
/*11304*/             OPC_EmitConvertToTarget, 2,
/*11306*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_F32p64imm), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3088:iPTR, Int64Regs:i64:$addr, (fpimm:f32):$b)<<P:Predicate_atomic_load_add_f32_g>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_ADD_G_F32p64imm:f32 Int64Regs:i64:$addr, (fpimm:f32):$b)
/*11314*/           /*Scope*/ 15, /*->11330*/
/*11315*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_add_f32_s
/*11317*/             OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11319*/             OPC_EmitMergeInputChains1_0,
/*11320*/             OPC_EmitConvertToTarget, 2,
/*11322*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_F32p64imm), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3088:iPTR, Int64Regs:i64:$addr, (fpimm:f32):$b)<<P:Predicate_atomic_load_add_f32_s>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_ADD_S_F32p64imm:f32 Int64Regs:i64:$addr, (fpimm:f32):$b)
/*11330*/           /*Scope*/ 15, /*->11346*/
/*11331*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_add_f32_gen
/*11333*/             OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11335*/             OPC_EmitMergeInputChains1_0,
/*11336*/             OPC_EmitConvertToTarget, 2,
/*11338*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_F32p64imm), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3088:iPTR, Int64Regs:i64:$addr, (fpimm:f32):$b)<<P:Predicate_atomic_load_add_f32_gen>> - Complexity = 12
                      // Dst: (INT_PTX_ATOM_ADD_GEN_F32p64imm:f32 Int64Regs:i64:$addr, (fpimm:f32):$b)
/*11346*/           0, /*End of Scope*/
/*11347*/         /*Scope*/ 13, /*->11361*/
/*11348*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_add_f32_g
/*11350*/           OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11352*/           OPC_EmitMergeInputChains1_0,
/*11353*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_F32p64reg), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3088:iPTR, Int64Regs:i64:$addr, Float32Regs:f32:$b)<<P:Predicate_atomic_load_add_f32_g>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_ADD_G_F32p64reg:f32 Int64Regs:i64:$addr, Float32Regs:f32:$b)
/*11361*/         /*Scope*/ 13, /*->11375*/
/*11362*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_add_f32_s
/*11364*/           OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11366*/           OPC_EmitMergeInputChains1_0,
/*11367*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_F32p64reg), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3088:iPTR, Int64Regs:i64:$addr, Float32Regs:f32:$b)<<P:Predicate_atomic_load_add_f32_s>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_ADD_S_F32p64reg:f32 Int64Regs:i64:$addr, Float32Regs:f32:$b)
/*11375*/         /*Scope*/ 13, /*->11389*/
/*11376*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_add_f32_gen
/*11378*/           OPC_CheckPatternPredicate, 14, // (Subtarget->hasAtomAddF32())
/*11380*/           OPC_EmitMergeInputChains1_0,
/*11381*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_F32p64reg), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3088:iPTR, Int64Regs:i64:$addr, Float32Regs:f32:$b)<<P:Predicate_atomic_load_add_f32_gen>> - Complexity = 9
                    // Dst: (INT_PTX_ATOM_ADD_GEN_F32p64reg:f32 Int64Regs:i64:$addr, Float32Regs:f32:$b)
/*11389*/         0, /*End of Scope*/
/*11390*/       0, /*End of Scope*/
/*11391*/     /*Scope*/ 40|128,1/*168*/, /*->11561*/
/*11393*/       OPC_CheckChild1Integer, 2|128,24/*3074*/, 
/*11396*/       OPC_RecordChild2, // #1 = $src
/*11397*/       OPC_Scope, 80, /*->11479*/ // 2 children in Scope
/*11399*/         OPC_CheckChild2Type, MVT::i32,
/*11401*/         OPC_RecordChild3, // #2 = $b
/*11402*/         OPC_Scope, 42, /*->11446*/ // 3 children in Scope
/*11404*/           OPC_MoveChild3,
/*11405*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*11408*/           OPC_SwitchType /*2 cases */, 16, MVT::f32,// ->11427
/*11411*/             OPC_MoveParent,
/*11412*/             OPC_CheckType, MVT::f32,
/*11414*/             OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11416*/             OPC_EmitMergeInputChains1_0,
/*11417*/             OPC_EmitConvertToTarget, 2,
/*11419*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3074:iPTR, Int32Regs:i32:$src, (fpimm:f32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1042:f32 Int32Regs:i32:$src, (fpimm:f32):$b)
/*11427*/           /*SwitchType*/ 16, MVT::f64,// ->11445
/*11429*/             OPC_MoveParent,
/*11430*/             OPC_CheckType, MVT::f64,
/*11432*/             OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11434*/             OPC_EmitMergeInputChains1_0,
/*11435*/             OPC_EmitConvertToTarget, 2,
/*11437*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::f64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f64 3074:iPTR, Int32Regs:i32:$src, (fpimm:f64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1042:f64 Int32Regs:i32:$src, (fpimm:f64):$b)
/*11445*/           0, // EndSwitchType
/*11446*/         /*Scope*/ 15, /*->11462*/
/*11447*/           OPC_CheckChild3Type, MVT::f32,
/*11449*/           OPC_CheckType, MVT::f32,
/*11451*/           OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11453*/           OPC_EmitMergeInputChains1_0,
/*11454*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3074:iPTR, Int32Regs:i32:$src, Float32Regs:f32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1040:f32 Int32Regs:i32:$src, Float32Regs:f32:$b)
/*11462*/         /*Scope*/ 15, /*->11478*/
/*11463*/           OPC_CheckChild3Type, MVT::f64,
/*11465*/           OPC_CheckType, MVT::f64,
/*11467*/           OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11469*/           OPC_EmitMergeInputChains1_0,
/*11470*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::f64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f64 3074:iPTR, Int32Regs:i32:$src, Float64Regs:f64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1040:f64 Int32Regs:i32:$src, Float64Regs:f64:$b)
/*11478*/         0, /*End of Scope*/
/*11479*/       /*Scope*/ 80, /*->11560*/
/*11480*/         OPC_CheckChild2Type, MVT::i64,
/*11482*/         OPC_RecordChild3, // #2 = $b
/*11483*/         OPC_Scope, 42, /*->11527*/ // 3 children in Scope
/*11485*/           OPC_MoveChild3,
/*11486*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*11489*/           OPC_SwitchType /*2 cases */, 16, MVT::f32,// ->11508
/*11492*/             OPC_MoveParent,
/*11493*/             OPC_CheckType, MVT::f32,
/*11495*/             OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11497*/             OPC_EmitMergeInputChains1_0,
/*11498*/             OPC_EmitConvertToTarget, 2,
/*11500*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3074:iPTR, Int64Regs:i64:$src, (fpimm:f32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1043:f32 Int64Regs:i64:$src, (fpimm:f32):$b)
/*11508*/           /*SwitchType*/ 16, MVT::f64,// ->11526
/*11510*/             OPC_MoveParent,
/*11511*/             OPC_CheckType, MVT::f64,
/*11513*/             OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11515*/             OPC_EmitMergeInputChains1_0,
/*11516*/             OPC_EmitConvertToTarget, 2,
/*11518*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::f64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f64 3074:iPTR, Int64Regs:i64:$src, (fpimm:f64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1043:f64 Int64Regs:i64:$src, (fpimm:f64):$b)
/*11526*/           0, // EndSwitchType
/*11527*/         /*Scope*/ 15, /*->11543*/
/*11528*/           OPC_CheckChild3Type, MVT::f32,
/*11530*/           OPC_CheckType, MVT::f32,
/*11532*/           OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11534*/           OPC_EmitMergeInputChains1_0,
/*11535*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3074:iPTR, Int64Regs:i64:$src, Float32Regs:f32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f32_cta_gen_anonymous_1052anonymous_1041:f32 Int64Regs:i64:$src, Float32Regs:f32:$b)
/*11543*/         /*Scope*/ 15, /*->11559*/
/*11544*/           OPC_CheckChild3Type, MVT::f64,
/*11546*/           OPC_CheckType, MVT::f64,
/*11548*/           OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11550*/           OPC_EmitMergeInputChains1_0,
/*11551*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::f64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f64 3074:iPTR, Int64Regs:i64:$src, Float64Regs:f64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f64_cta_gen_anonymous_1052anonymous_1041:f64 Int64Regs:i64:$src, Float64Regs:f64:$b)
/*11559*/         0, /*End of Scope*/
/*11560*/       0, /*End of Scope*/
/*11561*/     /*Scope*/ 40|128,1/*168*/, /*->11731*/
/*11563*/       OPC_CheckChild1Integer, 3|128,24/*3075*/, 
/*11566*/       OPC_RecordChild2, // #1 = $src
/*11567*/       OPC_Scope, 80, /*->11649*/ // 2 children in Scope
/*11569*/         OPC_CheckChild2Type, MVT::i32,
/*11571*/         OPC_RecordChild3, // #2 = $b
/*11572*/         OPC_Scope, 42, /*->11616*/ // 3 children in Scope
/*11574*/           OPC_MoveChild3,
/*11575*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*11578*/           OPC_SwitchType /*2 cases */, 16, MVT::f32,// ->11597
/*11581*/             OPC_MoveParent,
/*11582*/             OPC_CheckType, MVT::f32,
/*11584*/             OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11586*/             OPC_EmitMergeInputChains1_0,
/*11587*/             OPC_EmitConvertToTarget, 2,
/*11589*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3075:iPTR, Int32Regs:i32:$src, (fpimm:f32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1042:f32 Int32Regs:i32:$src, (fpimm:f32):$b)
/*11597*/           /*SwitchType*/ 16, MVT::f64,// ->11615
/*11599*/             OPC_MoveParent,
/*11600*/             OPC_CheckType, MVT::f64,
/*11602*/             OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11604*/             OPC_EmitMergeInputChains1_0,
/*11605*/             OPC_EmitConvertToTarget, 2,
/*11607*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1042), 0|OPFL_Chain,
                          MVT::f64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f64 3075:iPTR, Int32Regs:i32:$src, (fpimm:f64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1042:f64 Int32Regs:i32:$src, (fpimm:f64):$b)
/*11615*/           0, // EndSwitchType
/*11616*/         /*Scope*/ 15, /*->11632*/
/*11617*/           OPC_CheckChild3Type, MVT::f32,
/*11619*/           OPC_CheckType, MVT::f32,
/*11621*/           OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11623*/           OPC_EmitMergeInputChains1_0,
/*11624*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3075:iPTR, Int32Regs:i32:$src, Float32Regs:f32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1040:f32 Int32Regs:i32:$src, Float32Regs:f32:$b)
/*11632*/         /*Scope*/ 15, /*->11648*/
/*11633*/           OPC_CheckChild3Type, MVT::f64,
/*11635*/           OPC_CheckType, MVT::f64,
/*11637*/           OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11639*/           OPC_EmitMergeInputChains1_0,
/*11640*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1040), 0|OPFL_Chain,
                        MVT::f64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f64 3075:iPTR, Int32Regs:i32:$src, Float64Regs:f64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1040:f64 Int32Regs:i32:$src, Float64Regs:f64:$b)
/*11648*/         0, /*End of Scope*/
/*11649*/       /*Scope*/ 80, /*->11730*/
/*11650*/         OPC_CheckChild2Type, MVT::i64,
/*11652*/         OPC_RecordChild3, // #2 = $b
/*11653*/         OPC_Scope, 42, /*->11697*/ // 3 children in Scope
/*11655*/           OPC_MoveChild3,
/*11656*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*11659*/           OPC_SwitchType /*2 cases */, 16, MVT::f32,// ->11678
/*11662*/             OPC_MoveParent,
/*11663*/             OPC_CheckType, MVT::f32,
/*11665*/             OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11667*/             OPC_EmitMergeInputChains1_0,
/*11668*/             OPC_EmitConvertToTarget, 2,
/*11670*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::f32, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f32 3075:iPTR, Int64Regs:i64:$src, (fpimm:f32):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1043:f32 Int64Regs:i64:$src, (fpimm:f32):$b)
/*11678*/           /*SwitchType*/ 16, MVT::f64,// ->11696
/*11680*/             OPC_MoveParent,
/*11681*/             OPC_CheckType, MVT::f64,
/*11683*/             OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11685*/             OPC_EmitMergeInputChains1_0,
/*11686*/             OPC_EmitConvertToTarget, 2,
/*11688*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1043), 0|OPFL_Chain,
                          MVT::f64, 2/*#Ops*/, 1, 3, 
                      // Src: (intrinsic_w_chain:f64 3075:iPTR, Int64Regs:i64:$src, (fpimm:f64):$b) - Complexity = 11
                      // Dst: (INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1043:f64 Int64Regs:i64:$src, (fpimm:f64):$b)
/*11696*/           0, // EndSwitchType
/*11697*/         /*Scope*/ 15, /*->11713*/
/*11698*/           OPC_CheckChild3Type, MVT::f32,
/*11700*/           OPC_CheckType, MVT::f32,
/*11702*/           OPC_CheckPatternPredicate, 15, // (Subtarget->hasAtomAddF32()) && (Subtarget->hasAtomScope())
/*11704*/           OPC_EmitMergeInputChains1_0,
/*11705*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::f32, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f32 3075:iPTR, Int64Regs:i64:$src, Float32Regs:f32:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f32_sys_gen_anonymous_1052anonymous_1041:f32 Int64Regs:i64:$src, Float32Regs:f32:$b)
/*11713*/         /*Scope*/ 15, /*->11729*/
/*11714*/           OPC_CheckChild3Type, MVT::f64,
/*11716*/           OPC_CheckType, MVT::f64,
/*11718*/           OPC_CheckPatternPredicate, 16, // (Subtarget->hasAtomAddF64()) && (Subtarget->hasAtomScope())
/*11720*/           OPC_EmitMergeInputChains1_0,
/*11721*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1041), 0|OPFL_Chain,
                        MVT::f64, 2/*#Ops*/, 1, 2, 
                    // Src: (intrinsic_w_chain:f64 3075:iPTR, Int64Regs:i64:$src, Float64Regs:f64:$b) - Complexity = 9
                    // Dst: (INT_PTX_SATOM_ADD_f64_sys_gen_anonymous_1052anonymous_1041:f64 Int64Regs:i64:$src, Float64Regs:f64:$b)
/*11729*/         0, /*End of Scope*/
/*11730*/       0, /*End of Scope*/
/*11731*/     0, /*End of Scope*/
/*11732*/   /*SwitchOpcode*/ 41, TARGET_VAL(NVPTXISD::DeclareRetParam),// ->11776
/*11735*/     OPC_RecordNode, // #0 = 'DeclareRetParam' chained node
/*11736*/     OPC_CaptureGlueInput,
/*11737*/     OPC_RecordChild1, // #1 = $align
/*11738*/     OPC_MoveChild1,
/*11739*/     OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11742*/     OPC_CheckType, MVT::i32,
/*11744*/     OPC_MoveParent,
/*11745*/     OPC_RecordChild2, // #2 = $size
/*11746*/     OPC_MoveChild2,
/*11747*/     OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11750*/     OPC_CheckType, MVT::i32,
/*11752*/     OPC_MoveParent,
/*11753*/     OPC_RecordChild3, // #3 = $num
/*11754*/     OPC_MoveChild3,
/*11755*/     OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11758*/     OPC_CheckType, MVT::i32,
/*11760*/     OPC_MoveParent,
/*11761*/     OPC_EmitMergeInputChains1_0,
/*11762*/     OPC_EmitConvertToTarget, 1,
/*11764*/     OPC_EmitConvertToTarget, 2,
/*11766*/     OPC_EmitConvertToTarget, 3,
/*11768*/     OPC_MorphNodeTo0, TARGET_VAL(NVPTX::DeclareRetMemInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                  3/*#Ops*/, 4, 5, 6, 
              // Src: (DeclareRetParam (imm:i32):$align, (imm:i32):$size, (imm:i32):$num) - Complexity = 12
              // Dst: (DeclareRetMemInst (imm:i32):$align, (imm:i32):$size, (imm:i32):$num)
/*11776*/   /*SwitchOpcode*/ 41, TARGET_VAL(NVPTXISD::DeclareParam),// ->11820
/*11779*/     OPC_RecordNode, // #0 = 'DeclareParam' chained node
/*11780*/     OPC_CaptureGlueInput,
/*11781*/     OPC_RecordChild1, // #1 = $align
/*11782*/     OPC_MoveChild1,
/*11783*/     OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11786*/     OPC_CheckType, MVT::i32,
/*11788*/     OPC_MoveParent,
/*11789*/     OPC_RecordChild2, // #2 = $a
/*11790*/     OPC_MoveChild2,
/*11791*/     OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11794*/     OPC_CheckType, MVT::i32,
/*11796*/     OPC_MoveParent,
/*11797*/     OPC_RecordChild3, // #3 = $size
/*11798*/     OPC_MoveChild3,
/*11799*/     OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11802*/     OPC_CheckType, MVT::i32,
/*11804*/     OPC_MoveParent,
/*11805*/     OPC_EmitMergeInputChains1_0,
/*11806*/     OPC_EmitConvertToTarget, 1,
/*11808*/     OPC_EmitConvertToTarget, 2,
/*11810*/     OPC_EmitConvertToTarget, 3,
/*11812*/     OPC_MorphNodeTo0, TARGET_VAL(NVPTX::DeclareParamInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                  3/*#Ops*/, 4, 5, 6, 
              // Src: (DeclareParam (imm:i32):$align, (imm:i32):$a, (imm:i32):$size) - Complexity = 12
              // Dst: (DeclareParamInst (imm:i32):$align, (imm:i32):$a, (imm:i32):$size)
/*11820*/   /*SwitchOpcode*/ 101, TARGET_VAL(NVPTXISD::CallArg),// ->11924
/*11823*/     OPC_RecordNode, // #0 = 'CallArg' chained node
/*11824*/     OPC_CaptureGlueInput,
/*11825*/     OPC_Scope, 74, /*->11901*/ // 2 children in Scope
/*11827*/       OPC_CheckChild1Integer, 0, 
/*11829*/       OPC_CheckChild1Type, MVT::i32,
/*11831*/       OPC_RecordChild2, // #1 = $a
/*11832*/       OPC_Scope, 16, /*->11850*/ // 6 children in Scope
/*11834*/         OPC_MoveChild2,
/*11835*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11838*/         OPC_CheckType, MVT::i32,
/*11840*/         OPC_MoveParent,
/*11841*/         OPC_EmitMergeInputChains1_0,
/*11842*/         OPC_EmitConvertToTarget, 1,
/*11844*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgI32imm), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 2, 
                  // Src: (CallArg 0:i32, (imm:i32):$a) - Complexity = 11
                  // Dst: (CallArgI32imm (imm:i32):$a)
/*11850*/       /*Scope*/ 9, /*->11860*/
/*11851*/         OPC_CheckChild2Type, MVT::i64,
/*11853*/         OPC_EmitMergeInputChains1_0,
/*11854*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgI64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (CallArg 0:i32, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (CallArgI64 Int64Regs:i64:$a)
/*11860*/       /*Scope*/ 9, /*->11870*/
/*11861*/         OPC_CheckChild2Type, MVT::i32,
/*11863*/         OPC_EmitMergeInputChains1_0,
/*11864*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgI32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (CallArg 0:i32, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (CallArgI32 Int32Regs:i32:$a)
/*11870*/       /*Scope*/ 9, /*->11880*/
/*11871*/         OPC_CheckChild2Type, MVT::i16,
/*11873*/         OPC_EmitMergeInputChains1_0,
/*11874*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgI16), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (CallArg 0:i32, Int16Regs:i16:$a) - Complexity = 8
                  // Dst: (CallArgI16 Int16Regs:i16:$a)
/*11880*/       /*Scope*/ 9, /*->11890*/
/*11881*/         OPC_CheckChild2Type, MVT::f64,
/*11883*/         OPC_EmitMergeInputChains1_0,
/*11884*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgF64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (CallArg 0:i32, Float64Regs:f64:$a) - Complexity = 8
                  // Dst: (CallArgF64 Float64Regs:f64:$a)
/*11890*/       /*Scope*/ 9, /*->11900*/
/*11891*/         OPC_CheckChild2Type, MVT::f32,
/*11893*/         OPC_EmitMergeInputChains1_0,
/*11894*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgF32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (CallArg 0:i32, Float32Regs:f32:$a) - Complexity = 8
                  // Dst: (CallArgF32 Float32Regs:f32:$a)
/*11900*/       0, /*End of Scope*/
/*11901*/     /*Scope*/ 21, /*->11923*/
/*11902*/       OPC_CheckChild1Integer, 1, 
/*11904*/       OPC_CheckChild1Type, MVT::i32,
/*11906*/       OPC_RecordChild2, // #1 = $a
/*11907*/       OPC_MoveChild2,
/*11908*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11911*/       OPC_CheckType, MVT::i32,
/*11913*/       OPC_MoveParent,
/*11914*/       OPC_EmitMergeInputChains1_0,
/*11915*/       OPC_EmitConvertToTarget, 1,
/*11917*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgParam), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    1/*#Ops*/, 2, 
                // Src: (CallArg 1:i32, (imm:i32):$a) - Complexity = 11
                // Dst: (CallArgParam (imm:i32):$a)
/*11923*/     0, /*End of Scope*/
/*11924*/   /*SwitchOpcode*/ 101, TARGET_VAL(NVPTXISD::LastCallArg),// ->12028
/*11927*/     OPC_RecordNode, // #0 = 'LastCallArg' chained node
/*11928*/     OPC_CaptureGlueInput,
/*11929*/     OPC_Scope, 74, /*->12005*/ // 2 children in Scope
/*11931*/       OPC_CheckChild1Integer, 0, 
/*11933*/       OPC_CheckChild1Type, MVT::i32,
/*11935*/       OPC_RecordChild2, // #1 = $a
/*11936*/       OPC_Scope, 16, /*->11954*/ // 6 children in Scope
/*11938*/         OPC_MoveChild2,
/*11939*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*11942*/         OPC_CheckType, MVT::i32,
/*11944*/         OPC_MoveParent,
/*11945*/         OPC_EmitMergeInputChains1_0,
/*11946*/         OPC_EmitConvertToTarget, 1,
/*11948*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::LastCallArgI32imm), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 2, 
                  // Src: (LastCallArg 0:i32, (imm:i32):$a) - Complexity = 11
                  // Dst: (LastCallArgI32imm (imm:i32):$a)
/*11954*/       /*Scope*/ 9, /*->11964*/
/*11955*/         OPC_CheckChild2Type, MVT::i64,
/*11957*/         OPC_EmitMergeInputChains1_0,
/*11958*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::LastCallArgI64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (LastCallArg 0:i32, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (LastCallArgI64 Int64Regs:i64:$a)
/*11964*/       /*Scope*/ 9, /*->11974*/
/*11965*/         OPC_CheckChild2Type, MVT::i32,
/*11967*/         OPC_EmitMergeInputChains1_0,
/*11968*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::LastCallArgI32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (LastCallArg 0:i32, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (LastCallArgI32 Int32Regs:i32:$a)
/*11974*/       /*Scope*/ 9, /*->11984*/
/*11975*/         OPC_CheckChild2Type, MVT::i16,
/*11977*/         OPC_EmitMergeInputChains1_0,
/*11978*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::LastCallArgI16), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (LastCallArg 0:i32, Int16Regs:i16:$a) - Complexity = 8
                  // Dst: (LastCallArgI16 Int16Regs:i16:$a)
/*11984*/       /*Scope*/ 9, /*->11994*/
/*11985*/         OPC_CheckChild2Type, MVT::f64,
/*11987*/         OPC_EmitMergeInputChains1_0,
/*11988*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::LastCallArgF64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (LastCallArg 0:i32, Float64Regs:f64:$a) - Complexity = 8
                  // Dst: (LastCallArgF64 Float64Regs:f64:$a)
/*11994*/       /*Scope*/ 9, /*->12004*/
/*11995*/         OPC_CheckChild2Type, MVT::f32,
/*11997*/         OPC_EmitMergeInputChains1_0,
/*11998*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::LastCallArgF32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (LastCallArg 0:i32, Float32Regs:f32:$a) - Complexity = 8
                  // Dst: (LastCallArgF32 Float32Regs:f32:$a)
/*12004*/       0, /*End of Scope*/
/*12005*/     /*Scope*/ 21, /*->12027*/
/*12006*/       OPC_CheckChild1Integer, 1, 
/*12008*/       OPC_CheckChild1Type, MVT::i32,
/*12010*/       OPC_RecordChild2, // #1 = $a
/*12011*/       OPC_MoveChild2,
/*12012*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*12015*/       OPC_CheckType, MVT::i32,
/*12017*/       OPC_MoveParent,
/*12018*/       OPC_EmitMergeInputChains1_0,
/*12019*/       OPC_EmitConvertToTarget, 1,
/*12021*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::LastCallArgParam), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    1/*#Ops*/, 2, 
                // Src: (LastCallArg 1:i32, (imm:i32):$a) - Complexity = 11
                // Dst: (LastCallArgParam (imm:i32):$a)
/*12027*/     0, /*End of Scope*/
/*12028*/   /*SwitchOpcode*/ 96, TARGET_VAL(ISD::BRCOND),// ->12127
/*12031*/     OPC_RecordNode, // #0 = 'brcond' chained node
/*12032*/     OPC_Scope, 39, /*->12073*/ // 2 children in Scope
/*12034*/       OPC_MoveChild1,
/*12035*/       OPC_CheckOpcode, TARGET_VAL(ISD::SETCC),
/*12038*/       OPC_RecordChild0, // #1 = $a
/*12039*/       OPC_CheckChild0Type, MVT::i1,
/*12041*/       OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12052*/       OPC_MoveChild2,
/*12053*/       OPC_CheckCondCode, ISD::SETNE,
/*12055*/       OPC_MoveParent,
/*12056*/       OPC_CheckType, MVT::i1,
/*12058*/       OPC_MoveParent,
/*12059*/       OPC_RecordChild2, // #2 = $target
/*12060*/       OPC_MoveChild2,
/*12061*/       OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*12064*/       OPC_MoveParent,
/*12065*/       OPC_EmitMergeInputChains1_0,
/*12066*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CBranchOther), 0|OPFL_Chain,
                    2/*#Ops*/, 1, 2, 
                // Src: (brcond (setcc:i1 Int1Regs:i1:$a, -1:i1, SETNE:Other), (bb:Other):$target) - Complexity = 11
                // Dst: (CBranchOther Int1Regs:i1:$a, (bb:Other):$target)
/*12073*/     /*Scope*/ 52, /*->12126*/
/*12074*/       OPC_RecordChild1, // #1 = $a
/*12075*/       OPC_Scope, 16, /*->12093*/ // 2 children in Scope
/*12077*/         OPC_CheckChild1Type, MVT::i1,
/*12079*/         OPC_RecordChild2, // #2 = $target
/*12080*/         OPC_MoveChild2,
/*12081*/         OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*12084*/         OPC_MoveParent,
/*12085*/         OPC_EmitMergeInputChains1_0,
/*12086*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CBranch), 0|OPFL_Chain,
                      2/*#Ops*/, 1, 2, 
                  // Src: (brcond Int1Regs:i1:$a, (bb:Other):$target) - Complexity = 3
                  // Dst: (CBranch Int1Regs:i1:$a, (bb:Other):$target)
/*12093*/       /*Scope*/ 31, /*->12125*/
/*12094*/         OPC_CheckChild1Type, MVT::i32,
/*12096*/         OPC_RecordChild2, // #2 = $target
/*12097*/         OPC_MoveChild2,
/*12098*/         OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*12101*/         OPC_MoveParent,
/*12102*/         OPC_EmitMergeInputChains1_0,
/*12103*/         OPC_EmitInteger, MVT::i32, 0, 
/*12106*/         OPC_EmitInteger, MVT::i32, 1, 
/*12109*/         OPC_EmitNode1, TARGET_VAL(NVPTX::SETP_u32ri), 0,
                      MVT::i1, 3/*#Ops*/, 1, 3, 4,  // Results = #5
/*12118*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CBranch), 0|OPFL_Chain,
                      2/*#Ops*/, 5, 2, 
                  // Src: (brcond Int32Regs:i32:$a, (bb:Other):$target) - Complexity = 3
                  // Dst: (CBranch (SETP_u32ri:i1 Int32Regs:i32:$a, 0:i32, 1:i32), (bb:Other):$target)
/*12125*/       0, /*End of Scope*/
/*12126*/     0, /*End of Scope*/
/*12127*/   /*SwitchOpcode*/ 124|128,36/*4732*/, TARGET_VAL(ISD::INTRINSIC_VOID),// ->16863
/*12131*/     OPC_RecordNode, // #0 = 'intrinsic_void' chained node
/*12132*/     OPC_Scope, 18, /*->12152*/ // 219 children in Scope
/*12134*/       OPC_CheckChild1Integer, 27|128,24/*3099*/, 
/*12137*/       OPC_RecordChild2, // #1 = $i
/*12138*/       OPC_MoveChild2,
/*12139*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*12142*/       OPC_MoveParent,
/*12143*/       OPC_EmitMergeInputChains1_0,
/*12144*/       OPC_EmitConvertToTarget, 1,
/*12146*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_BAR_SYNC), 0|OPFL_Chain,
                    1/*#Ops*/, 2, 
                // Src: (intrinsic_void 3099:iPTR, (imm:i32):$i) - Complexity = 11
                // Dst: (INT_BAR_SYNC (imm:i32):$i)
/*12152*/     /*Scope*/ 9, /*->12162*/
/*12153*/       OPC_CheckChild1Integer, 30|128,24/*3102*/, 
/*12156*/       OPC_EmitMergeInputChains1_0,
/*12157*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_BARRIER0), 0|OPFL_Chain,
                    0/*#Ops*/, 
                // Src: (intrinsic_void 3102:iPTR) - Complexity = 8
                // Dst: (INT_BARRIER0)
/*12162*/     /*Scope*/ 11, /*->12174*/
/*12163*/       OPC_CheckChild1Integer, 29|128,24/*3101*/, 
/*12166*/       OPC_RecordChild2, // #1 = $src1
/*12167*/       OPC_EmitMergeInputChains1_0,
/*12168*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_BARRIERN), 0|OPFL_Chain,
                    1/*#Ops*/, 1, 
                // Src: (intrinsic_void 3101:iPTR, Int32Regs:i32:$src1) - Complexity = 8
                // Dst: (INT_BARRIERN Int32Regs:i32:$src1)
/*12174*/     /*Scope*/ 13, /*->12188*/
/*12175*/       OPC_CheckChild1Integer, 28|128,24/*3100*/, 
/*12178*/       OPC_RecordChild2, // #1 = $src1
/*12179*/       OPC_RecordChild3, // #2 = $src2
/*12180*/       OPC_EmitMergeInputChains1_0,
/*12181*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_BARRIER), 0|OPFL_Chain,
                    2/*#Ops*/, 1, 2, 
                // Src: (intrinsic_void 3100:iPTR, Int32Regs:i32:$src1, Int32Regs:i32:$src2) - Complexity = 8
                // Dst: (INT_BARRIER Int32Regs:i32:$src1, Int32Regs:i32:$src2)
/*12188*/     /*Scope*/ 9, /*->12198*/
/*12189*/       OPC_CheckChild1Integer, 51|128,25/*3251*/, 
/*12192*/       OPC_EmitMergeInputChains1_0,
/*12193*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_MEMBAR_CTA), 0|OPFL_Chain,
                    0/*#Ops*/, 
                // Src: (intrinsic_void 3251:iPTR) - Complexity = 8
                // Dst: (INT_MEMBAR_CTA)
/*12198*/     /*Scope*/ 9, /*->12208*/
/*12199*/       OPC_CheckChild1Integer, 52|128,25/*3252*/, 
/*12202*/       OPC_EmitMergeInputChains1_0,
/*12203*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_MEMBAR_GL), 0|OPFL_Chain,
                    0/*#Ops*/, 
                // Src: (intrinsic_void 3252:iPTR) - Complexity = 8
                // Dst: (INT_MEMBAR_GL)
/*12208*/     /*Scope*/ 9, /*->12218*/
/*12209*/       OPC_CheckChild1Integer, 53|128,25/*3253*/, 
/*12212*/       OPC_EmitMergeInputChains1_0,
/*12213*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_MEMBAR_SYS), 0|OPFL_Chain,
                    0/*#Ops*/, 
                // Src: (intrinsic_void 3253:iPTR) - Complexity = 8
                // Dst: (INT_MEMBAR_SYS)
/*12218*/     /*Scope*/ 26, /*->12245*/
/*12219*/       OPC_CheckChild1Integer, 42|128,24/*3114*/, 
/*12222*/       OPC_RecordChild2, // #1 = $a
/*12223*/       OPC_Scope, 9, /*->12234*/ // 2 children in Scope
/*12225*/         OPC_CheckChild2Type, MVT::i32,
/*12227*/         OPC_EmitMergeInputChains1_0,
/*12228*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_NVVM_COMPILER_WARN_32), 0|OPFL_Chain,
                      1/*#Ops*/, 1, 
                  // Src: (intrinsic_void 3114:iPTR, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (INT_NVVM_COMPILER_WARN_32 Int32Regs:i32:$a)
/*12234*/       /*Scope*/ 9, /*->12244*/
/*12235*/         OPC_CheckChild2Type, MVT::i64,
/*12237*/         OPC_EmitMergeInputChains1_0,
/*12238*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_NVVM_COMPILER_WARN_64), 0|OPFL_Chain,
                      1/*#Ops*/, 1, 
                  // Src: (intrinsic_void 3114:iPTR, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (INT_NVVM_COMPILER_WARN_64 Int64Regs:i64:$a)
/*12244*/       0, /*End of Scope*/
/*12245*/     /*Scope*/ 26, /*->12272*/
/*12246*/       OPC_CheckChild1Integer, 41|128,24/*3113*/, 
/*12249*/       OPC_RecordChild2, // #1 = $a
/*12250*/       OPC_Scope, 9, /*->12261*/ // 2 children in Scope
/*12252*/         OPC_CheckChild2Type, MVT::i32,
/*12254*/         OPC_EmitMergeInputChains1_0,
/*12255*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_NVVM_COMPILER_ERROR_32), 0|OPFL_Chain,
                      1/*#Ops*/, 1, 
                  // Src: (intrinsic_void 3113:iPTR, Int32Regs:i32:$a) - Complexity = 8
                  // Dst: (INT_NVVM_COMPILER_ERROR_32 Int32Regs:i32:$a)
/*12261*/       /*Scope*/ 9, /*->12271*/
/*12262*/         OPC_CheckChild2Type, MVT::i64,
/*12264*/         OPC_EmitMergeInputChains1_0,
/*12265*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::INT_NVVM_COMPILER_ERROR_64), 0|OPFL_Chain,
                      1/*#Ops*/, 1, 
                  // Src: (intrinsic_void 3113:iPTR, Int64Regs:i64:$a) - Complexity = 8
                  // Dst: (INT_NVVM_COMPILER_ERROR_64 Int64Regs:i64:$a)
/*12271*/       0, /*End of Scope*/
/*12272*/     /*Scope*/ 15, /*->12288*/
/*12273*/       OPC_CheckChild1Integer, 36|128,28/*3620*/, 
/*12276*/       OPC_RecordChild2, // #1 = $s
/*12277*/       OPC_RecordChild3, // #2 = $x
/*12278*/       OPC_RecordChild4, // #3 = $r
/*12279*/       OPC_EmitMergeInputChains1_0,
/*12280*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B8_CLAMP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3620:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*12288*/     /*Scope*/ 15, /*->12304*/
/*12289*/       OPC_CheckChild1Integer, 27|128,28/*3611*/, 
/*12292*/       OPC_RecordChild2, // #1 = $s
/*12293*/       OPC_RecordChild3, // #2 = $x
/*12294*/       OPC_RecordChild4, // #3 = $r
/*12295*/       OPC_EmitMergeInputChains1_0,
/*12296*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B16_CLAMP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3611:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*12304*/     /*Scope*/ 15, /*->12320*/
/*12305*/       OPC_CheckChild1Integer, 30|128,28/*3614*/, 
/*12308*/       OPC_RecordChild2, // #1 = $s
/*12309*/       OPC_RecordChild3, // #2 = $x
/*12310*/       OPC_RecordChild4, // #3 = $r
/*12311*/       OPC_EmitMergeInputChains1_0,
/*12312*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B32_CLAMP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3614:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*12320*/     /*Scope*/ 15, /*->12336*/
/*12321*/       OPC_CheckChild1Integer, 33|128,28/*3617*/, 
/*12324*/       OPC_RecordChild2, // #1 = $s
/*12325*/       OPC_RecordChild3, // #2 = $x
/*12326*/       OPC_RecordChild4, // #3 = $r
/*12327*/       OPC_EmitMergeInputChains1_0,
/*12328*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B64_CLAMP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3617:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r)
/*12336*/     /*Scope*/ 17, /*->12354*/
/*12337*/       OPC_CheckChild1Integer, 48|128,28/*3632*/, 
/*12340*/       OPC_RecordChild2, // #1 = $s
/*12341*/       OPC_RecordChild3, // #2 = $x
/*12342*/       OPC_RecordChild4, // #3 = $r
/*12343*/       OPC_RecordChild5, // #4 = $g
/*12344*/       OPC_EmitMergeInputChains1_0,
/*12345*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B8_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3632:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*12354*/     /*Scope*/ 17, /*->12372*/
/*12355*/       OPC_CheckChild1Integer, 39|128,28/*3623*/, 
/*12358*/       OPC_RecordChild2, // #1 = $s
/*12359*/       OPC_RecordChild3, // #2 = $x
/*12360*/       OPC_RecordChild4, // #3 = $r
/*12361*/       OPC_RecordChild5, // #4 = $g
/*12362*/       OPC_EmitMergeInputChains1_0,
/*12363*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B16_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3623:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*12372*/     /*Scope*/ 17, /*->12390*/
/*12373*/       OPC_CheckChild1Integer, 42|128,28/*3626*/, 
/*12376*/       OPC_RecordChild2, // #1 = $s
/*12377*/       OPC_RecordChild3, // #2 = $x
/*12378*/       OPC_RecordChild4, // #3 = $r
/*12379*/       OPC_RecordChild5, // #4 = $g
/*12380*/       OPC_EmitMergeInputChains1_0,
/*12381*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B32_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3626:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*12390*/     /*Scope*/ 17, /*->12408*/
/*12391*/       OPC_CheckChild1Integer, 45|128,28/*3629*/, 
/*12394*/       OPC_RecordChild2, // #1 = $s
/*12395*/       OPC_RecordChild3, // #2 = $x
/*12396*/       OPC_RecordChild4, // #3 = $r
/*12397*/       OPC_RecordChild5, // #4 = $g
/*12398*/       OPC_EmitMergeInputChains1_0,
/*12399*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B64_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3629:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*12408*/     /*Scope*/ 21, /*->12430*/
/*12409*/       OPC_CheckChild1Integer, 57|128,28/*3641*/, 
/*12412*/       OPC_RecordChild2, // #1 = $s
/*12413*/       OPC_RecordChild3, // #2 = $x
/*12414*/       OPC_RecordChild4, // #3 = $r
/*12415*/       OPC_RecordChild5, // #4 = $g
/*12416*/       OPC_RecordChild6, // #5 = $b
/*12417*/       OPC_RecordChild7, // #6 = $a
/*12418*/       OPC_EmitMergeInputChains1_0,
/*12419*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B8_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3641:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*12430*/     /*Scope*/ 21, /*->12452*/
/*12431*/       OPC_CheckChild1Integer, 51|128,28/*3635*/, 
/*12434*/       OPC_RecordChild2, // #1 = $s
/*12435*/       OPC_RecordChild3, // #2 = $x
/*12436*/       OPC_RecordChild4, // #3 = $r
/*12437*/       OPC_RecordChild5, // #4 = $g
/*12438*/       OPC_RecordChild6, // #5 = $b
/*12439*/       OPC_RecordChild7, // #6 = $a
/*12440*/       OPC_EmitMergeInputChains1_0,
/*12441*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B16_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3635:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*12452*/     /*Scope*/ 21, /*->12474*/
/*12453*/       OPC_CheckChild1Integer, 54|128,28/*3638*/, 
/*12456*/       OPC_RecordChild2, // #1 = $s
/*12457*/       OPC_RecordChild3, // #2 = $x
/*12458*/       OPC_RecordChild4, // #3 = $r
/*12459*/       OPC_RecordChild5, // #4 = $g
/*12460*/       OPC_RecordChild6, // #5 = $b
/*12461*/       OPC_RecordChild7, // #6 = $a
/*12462*/       OPC_EmitMergeInputChains1_0,
/*12463*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B32_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3638:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*12474*/     /*Scope*/ 17, /*->12492*/
/*12475*/       OPC_CheckChild1Integer, 3|128,28/*3587*/, 
/*12478*/       OPC_RecordChild2, // #1 = $s
/*12479*/       OPC_RecordChild3, // #2 = $l
/*12480*/       OPC_RecordChild4, // #3 = $x
/*12481*/       OPC_RecordChild5, // #4 = $r
/*12482*/       OPC_EmitMergeInputChains1_0,
/*12483*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B8_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3587:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*12492*/     /*Scope*/ 17, /*->12510*/
/*12493*/       OPC_CheckChild1Integer, 122|128,27/*3578*/, 
/*12496*/       OPC_RecordChild2, // #1 = $s
/*12497*/       OPC_RecordChild3, // #2 = $l
/*12498*/       OPC_RecordChild4, // #3 = $x
/*12499*/       OPC_RecordChild5, // #4 = $r
/*12500*/       OPC_EmitMergeInputChains1_0,
/*12501*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B16_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3578:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*12510*/     /*Scope*/ 17, /*->12528*/
/*12511*/       OPC_CheckChild1Integer, 125|128,27/*3581*/, 
/*12514*/       OPC_RecordChild2, // #1 = $s
/*12515*/       OPC_RecordChild3, // #2 = $l
/*12516*/       OPC_RecordChild4, // #3 = $x
/*12517*/       OPC_RecordChild5, // #4 = $r
/*12518*/       OPC_EmitMergeInputChains1_0,
/*12519*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B32_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3581:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*12528*/     /*Scope*/ 17, /*->12546*/
/*12529*/       OPC_CheckChild1Integer, 0|128,28/*3584*/, 
/*12532*/       OPC_RecordChild2, // #1 = $s
/*12533*/       OPC_RecordChild3, // #2 = $l
/*12534*/       OPC_RecordChild4, // #3 = $x
/*12535*/       OPC_RecordChild5, // #4 = $r
/*12536*/       OPC_EmitMergeInputChains1_0,
/*12537*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B64_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3584:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r)
/*12546*/     /*Scope*/ 19, /*->12566*/
/*12547*/       OPC_CheckChild1Integer, 15|128,28/*3599*/, 
/*12550*/       OPC_RecordChild2, // #1 = $s
/*12551*/       OPC_RecordChild3, // #2 = $l
/*12552*/       OPC_RecordChild4, // #3 = $x
/*12553*/       OPC_RecordChild5, // #4 = $r
/*12554*/       OPC_RecordChild6, // #5 = $g
/*12555*/       OPC_EmitMergeInputChains1_0,
/*12556*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B8_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3599:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*12566*/     /*Scope*/ 19, /*->12586*/
/*12567*/       OPC_CheckChild1Integer, 6|128,28/*3590*/, 
/*12570*/       OPC_RecordChild2, // #1 = $s
/*12571*/       OPC_RecordChild3, // #2 = $l
/*12572*/       OPC_RecordChild4, // #3 = $x
/*12573*/       OPC_RecordChild5, // #4 = $r
/*12574*/       OPC_RecordChild6, // #5 = $g
/*12575*/       OPC_EmitMergeInputChains1_0,
/*12576*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B16_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3590:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*12586*/     /*Scope*/ 19, /*->12606*/
/*12587*/       OPC_CheckChild1Integer, 9|128,28/*3593*/, 
/*12590*/       OPC_RecordChild2, // #1 = $s
/*12591*/       OPC_RecordChild3, // #2 = $l
/*12592*/       OPC_RecordChild4, // #3 = $x
/*12593*/       OPC_RecordChild5, // #4 = $r
/*12594*/       OPC_RecordChild6, // #5 = $g
/*12595*/       OPC_EmitMergeInputChains1_0,
/*12596*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B32_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3593:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*12606*/     /*Scope*/ 19, /*->12626*/
/*12607*/       OPC_CheckChild1Integer, 12|128,28/*3596*/, 
/*12610*/       OPC_RecordChild2, // #1 = $s
/*12611*/       OPC_RecordChild3, // #2 = $l
/*12612*/       OPC_RecordChild4, // #3 = $x
/*12613*/       OPC_RecordChild5, // #4 = $r
/*12614*/       OPC_RecordChild6, // #5 = $g
/*12615*/       OPC_EmitMergeInputChains1_0,
/*12616*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B64_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3596:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*12626*/     /*Scope*/ 26, /*->12653*/
/*12627*/       OPC_CheckChild1Integer, 24|128,28/*3608*/, 
/*12630*/       OPC_RecordChild2, // #1 = $s
/*12631*/       OPC_RecordChild3, // #2 = $l
/*12632*/       OPC_RecordChild4, // #3 = $x
/*12633*/       OPC_RecordChild5, // #4 = $r
/*12634*/       OPC_RecordChild6, // #5 = $g
/*12635*/       OPC_RecordChild7, // #6 = $b
/*12636*/       OPC_MoveChild, 8,
/*12638*/       OPC_RecordNode, // #7 = $a
/*12639*/       OPC_MoveParent,
/*12640*/       OPC_EmitMergeInputChains1_0,
/*12641*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B8_CLAMP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3608:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*12653*/     /*Scope*/ 26, /*->12680*/
/*12654*/       OPC_CheckChild1Integer, 18|128,28/*3602*/, 
/*12657*/       OPC_RecordChild2, // #1 = $s
/*12658*/       OPC_RecordChild3, // #2 = $l
/*12659*/       OPC_RecordChild4, // #3 = $x
/*12660*/       OPC_RecordChild5, // #4 = $r
/*12661*/       OPC_RecordChild6, // #5 = $g
/*12662*/       OPC_RecordChild7, // #6 = $b
/*12663*/       OPC_MoveChild, 8,
/*12665*/       OPC_RecordNode, // #7 = $a
/*12666*/       OPC_MoveParent,
/*12667*/       OPC_EmitMergeInputChains1_0,
/*12668*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B16_CLAMP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3602:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*12680*/     /*Scope*/ 26, /*->12707*/
/*12681*/       OPC_CheckChild1Integer, 21|128,28/*3605*/, 
/*12684*/       OPC_RecordChild2, // #1 = $s
/*12685*/       OPC_RecordChild3, // #2 = $l
/*12686*/       OPC_RecordChild4, // #3 = $x
/*12687*/       OPC_RecordChild5, // #4 = $r
/*12688*/       OPC_RecordChild6, // #5 = $g
/*12689*/       OPC_RecordChild7, // #6 = $b
/*12690*/       OPC_MoveChild, 8,
/*12692*/       OPC_RecordNode, // #7 = $a
/*12693*/       OPC_MoveParent,
/*12694*/       OPC_EmitMergeInputChains1_0,
/*12695*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B32_CLAMP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3605:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*12707*/     /*Scope*/ 17, /*->12725*/
/*12708*/       OPC_CheckChild1Integer, 102|128,28/*3686*/, 
/*12711*/       OPC_RecordChild2, // #1 = $s
/*12712*/       OPC_RecordChild3, // #2 = $x
/*12713*/       OPC_RecordChild4, // #3 = $y
/*12714*/       OPC_RecordChild5, // #4 = $r
/*12715*/       OPC_EmitMergeInputChains1_0,
/*12716*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B8_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3686:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*12725*/     /*Scope*/ 17, /*->12743*/
/*12726*/       OPC_CheckChild1Integer, 93|128,28/*3677*/, 
/*12729*/       OPC_RecordChild2, // #1 = $s
/*12730*/       OPC_RecordChild3, // #2 = $x
/*12731*/       OPC_RecordChild4, // #3 = $y
/*12732*/       OPC_RecordChild5, // #4 = $r
/*12733*/       OPC_EmitMergeInputChains1_0,
/*12734*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B16_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3677:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*12743*/     /*Scope*/ 17, /*->12761*/
/*12744*/       OPC_CheckChild1Integer, 96|128,28/*3680*/, 
/*12747*/       OPC_RecordChild2, // #1 = $s
/*12748*/       OPC_RecordChild3, // #2 = $x
/*12749*/       OPC_RecordChild4, // #3 = $y
/*12750*/       OPC_RecordChild5, // #4 = $r
/*12751*/       OPC_EmitMergeInputChains1_0,
/*12752*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B32_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3680:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*12761*/     /*Scope*/ 17, /*->12779*/
/*12762*/       OPC_CheckChild1Integer, 99|128,28/*3683*/, 
/*12765*/       OPC_RecordChild2, // #1 = $s
/*12766*/       OPC_RecordChild3, // #2 = $x
/*12767*/       OPC_RecordChild4, // #3 = $y
/*12768*/       OPC_RecordChild5, // #4 = $r
/*12769*/       OPC_EmitMergeInputChains1_0,
/*12770*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B64_CLAMP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3683:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r)
/*12779*/     /*Scope*/ 19, /*->12799*/
/*12780*/       OPC_CheckChild1Integer, 114|128,28/*3698*/, 
/*12783*/       OPC_RecordChild2, // #1 = $s
/*12784*/       OPC_RecordChild3, // #2 = $x
/*12785*/       OPC_RecordChild4, // #3 = $y
/*12786*/       OPC_RecordChild5, // #4 = $r
/*12787*/       OPC_RecordChild6, // #5 = $g
/*12788*/       OPC_EmitMergeInputChains1_0,
/*12789*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B8_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3698:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*12799*/     /*Scope*/ 19, /*->12819*/
/*12800*/       OPC_CheckChild1Integer, 105|128,28/*3689*/, 
/*12803*/       OPC_RecordChild2, // #1 = $s
/*12804*/       OPC_RecordChild3, // #2 = $x
/*12805*/       OPC_RecordChild4, // #3 = $y
/*12806*/       OPC_RecordChild5, // #4 = $r
/*12807*/       OPC_RecordChild6, // #5 = $g
/*12808*/       OPC_EmitMergeInputChains1_0,
/*12809*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B16_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3689:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*12819*/     /*Scope*/ 19, /*->12839*/
/*12820*/       OPC_CheckChild1Integer, 108|128,28/*3692*/, 
/*12823*/       OPC_RecordChild2, // #1 = $s
/*12824*/       OPC_RecordChild3, // #2 = $x
/*12825*/       OPC_RecordChild4, // #3 = $y
/*12826*/       OPC_RecordChild5, // #4 = $r
/*12827*/       OPC_RecordChild6, // #5 = $g
/*12828*/       OPC_EmitMergeInputChains1_0,
/*12829*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B32_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3692:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*12839*/     /*Scope*/ 19, /*->12859*/
/*12840*/       OPC_CheckChild1Integer, 111|128,28/*3695*/, 
/*12843*/       OPC_RecordChild2, // #1 = $s
/*12844*/       OPC_RecordChild3, // #2 = $x
/*12845*/       OPC_RecordChild4, // #3 = $y
/*12846*/       OPC_RecordChild5, // #4 = $r
/*12847*/       OPC_RecordChild6, // #5 = $g
/*12848*/       OPC_EmitMergeInputChains1_0,
/*12849*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B64_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3695:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*12859*/     /*Scope*/ 26, /*->12886*/
/*12860*/       OPC_CheckChild1Integer, 123|128,28/*3707*/, 
/*12863*/       OPC_RecordChild2, // #1 = $s
/*12864*/       OPC_RecordChild3, // #2 = $x
/*12865*/       OPC_RecordChild4, // #3 = $y
/*12866*/       OPC_RecordChild5, // #4 = $r
/*12867*/       OPC_RecordChild6, // #5 = $g
/*12868*/       OPC_RecordChild7, // #6 = $b
/*12869*/       OPC_MoveChild, 8,
/*12871*/       OPC_RecordNode, // #7 = $a
/*12872*/       OPC_MoveParent,
/*12873*/       OPC_EmitMergeInputChains1_0,
/*12874*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B8_CLAMP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3707:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*12886*/     /*Scope*/ 26, /*->12913*/
/*12887*/       OPC_CheckChild1Integer, 117|128,28/*3701*/, 
/*12890*/       OPC_RecordChild2, // #1 = $s
/*12891*/       OPC_RecordChild3, // #2 = $x
/*12892*/       OPC_RecordChild4, // #3 = $y
/*12893*/       OPC_RecordChild5, // #4 = $r
/*12894*/       OPC_RecordChild6, // #5 = $g
/*12895*/       OPC_RecordChild7, // #6 = $b
/*12896*/       OPC_MoveChild, 8,
/*12898*/       OPC_RecordNode, // #7 = $a
/*12899*/       OPC_MoveParent,
/*12900*/       OPC_EmitMergeInputChains1_0,
/*12901*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B16_CLAMP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3701:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*12913*/     /*Scope*/ 26, /*->12940*/
/*12914*/       OPC_CheckChild1Integer, 120|128,28/*3704*/, 
/*12917*/       OPC_RecordChild2, // #1 = $s
/*12918*/       OPC_RecordChild3, // #2 = $x
/*12919*/       OPC_RecordChild4, // #3 = $y
/*12920*/       OPC_RecordChild5, // #4 = $r
/*12921*/       OPC_RecordChild6, // #5 = $g
/*12922*/       OPC_RecordChild7, // #6 = $b
/*12923*/       OPC_MoveChild, 8,
/*12925*/       OPC_RecordNode, // #7 = $a
/*12926*/       OPC_MoveParent,
/*12927*/       OPC_EmitMergeInputChains1_0,
/*12928*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B32_CLAMP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3704:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*12940*/     /*Scope*/ 19, /*->12960*/
/*12941*/       OPC_CheckChild1Integer, 69|128,28/*3653*/, 
/*12944*/       OPC_RecordChild2, // #1 = $s
/*12945*/       OPC_RecordChild3, // #2 = $l
/*12946*/       OPC_RecordChild4, // #3 = $x
/*12947*/       OPC_RecordChild5, // #4 = $y
/*12948*/       OPC_RecordChild6, // #5 = $r
/*12949*/       OPC_EmitMergeInputChains1_0,
/*12950*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B8_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3653:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*12960*/     /*Scope*/ 19, /*->12980*/
/*12961*/       OPC_CheckChild1Integer, 60|128,28/*3644*/, 
/*12964*/       OPC_RecordChild2, // #1 = $s
/*12965*/       OPC_RecordChild3, // #2 = $l
/*12966*/       OPC_RecordChild4, // #3 = $x
/*12967*/       OPC_RecordChild5, // #4 = $y
/*12968*/       OPC_RecordChild6, // #5 = $r
/*12969*/       OPC_EmitMergeInputChains1_0,
/*12970*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B16_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3644:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*12980*/     /*Scope*/ 19, /*->13000*/
/*12981*/       OPC_CheckChild1Integer, 63|128,28/*3647*/, 
/*12984*/       OPC_RecordChild2, // #1 = $s
/*12985*/       OPC_RecordChild3, // #2 = $l
/*12986*/       OPC_RecordChild4, // #3 = $x
/*12987*/       OPC_RecordChild5, // #4 = $y
/*12988*/       OPC_RecordChild6, // #5 = $r
/*12989*/       OPC_EmitMergeInputChains1_0,
/*12990*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B32_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3647:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*13000*/     /*Scope*/ 19, /*->13020*/
/*13001*/       OPC_CheckChild1Integer, 66|128,28/*3650*/, 
/*13004*/       OPC_RecordChild2, // #1 = $s
/*13005*/       OPC_RecordChild3, // #2 = $l
/*13006*/       OPC_RecordChild4, // #3 = $x
/*13007*/       OPC_RecordChild5, // #4 = $y
/*13008*/       OPC_RecordChild6, // #5 = $r
/*13009*/       OPC_EmitMergeInputChains1_0,
/*13010*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B64_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3650:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r)
/*13020*/     /*Scope*/ 21, /*->13042*/
/*13021*/       OPC_CheckChild1Integer, 81|128,28/*3665*/, 
/*13024*/       OPC_RecordChild2, // #1 = $s
/*13025*/       OPC_RecordChild3, // #2 = $l
/*13026*/       OPC_RecordChild4, // #3 = $x
/*13027*/       OPC_RecordChild5, // #4 = $y
/*13028*/       OPC_RecordChild6, // #5 = $r
/*13029*/       OPC_RecordChild7, // #6 = $g
/*13030*/       OPC_EmitMergeInputChains1_0,
/*13031*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B8_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3665:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13042*/     /*Scope*/ 21, /*->13064*/
/*13043*/       OPC_CheckChild1Integer, 72|128,28/*3656*/, 
/*13046*/       OPC_RecordChild2, // #1 = $s
/*13047*/       OPC_RecordChild3, // #2 = $l
/*13048*/       OPC_RecordChild4, // #3 = $x
/*13049*/       OPC_RecordChild5, // #4 = $y
/*13050*/       OPC_RecordChild6, // #5 = $r
/*13051*/       OPC_RecordChild7, // #6 = $g
/*13052*/       OPC_EmitMergeInputChains1_0,
/*13053*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B16_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3656:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13064*/     /*Scope*/ 21, /*->13086*/
/*13065*/       OPC_CheckChild1Integer, 75|128,28/*3659*/, 
/*13068*/       OPC_RecordChild2, // #1 = $s
/*13069*/       OPC_RecordChild3, // #2 = $l
/*13070*/       OPC_RecordChild4, // #3 = $x
/*13071*/       OPC_RecordChild5, // #4 = $y
/*13072*/       OPC_RecordChild6, // #5 = $r
/*13073*/       OPC_RecordChild7, // #6 = $g
/*13074*/       OPC_EmitMergeInputChains1_0,
/*13075*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B32_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3659:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*13086*/     /*Scope*/ 21, /*->13108*/
/*13087*/       OPC_CheckChild1Integer, 78|128,28/*3662*/, 
/*13090*/       OPC_RecordChild2, // #1 = $s
/*13091*/       OPC_RecordChild3, // #2 = $l
/*13092*/       OPC_RecordChild4, // #3 = $x
/*13093*/       OPC_RecordChild5, // #4 = $y
/*13094*/       OPC_RecordChild6, // #5 = $r
/*13095*/       OPC_RecordChild7, // #6 = $g
/*13096*/       OPC_EmitMergeInputChains1_0,
/*13097*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B64_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3662:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*13108*/     /*Scope*/ 31, /*->13140*/
/*13109*/       OPC_CheckChild1Integer, 90|128,28/*3674*/, 
/*13112*/       OPC_RecordChild2, // #1 = $s
/*13113*/       OPC_RecordChild3, // #2 = $l
/*13114*/       OPC_RecordChild4, // #3 = $x
/*13115*/       OPC_RecordChild5, // #4 = $y
/*13116*/       OPC_RecordChild6, // #5 = $r
/*13117*/       OPC_RecordChild7, // #6 = $g
/*13118*/       OPC_MoveChild, 8,
/*13120*/       OPC_RecordNode, // #7 = $b
/*13121*/       OPC_MoveParent,
/*13122*/       OPC_MoveChild, 9,
/*13124*/       OPC_RecordNode, // #8 = $a
/*13125*/       OPC_MoveParent,
/*13126*/       OPC_EmitMergeInputChains1_0,
/*13127*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B8_CLAMP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3674:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13140*/     /*Scope*/ 31, /*->13172*/
/*13141*/       OPC_CheckChild1Integer, 84|128,28/*3668*/, 
/*13144*/       OPC_RecordChild2, // #1 = $s
/*13145*/       OPC_RecordChild3, // #2 = $l
/*13146*/       OPC_RecordChild4, // #3 = $x
/*13147*/       OPC_RecordChild5, // #4 = $y
/*13148*/       OPC_RecordChild6, // #5 = $r
/*13149*/       OPC_RecordChild7, // #6 = $g
/*13150*/       OPC_MoveChild, 8,
/*13152*/       OPC_RecordNode, // #7 = $b
/*13153*/       OPC_MoveParent,
/*13154*/       OPC_MoveChild, 9,
/*13156*/       OPC_RecordNode, // #8 = $a
/*13157*/       OPC_MoveParent,
/*13158*/       OPC_EmitMergeInputChains1_0,
/*13159*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B16_CLAMP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3668:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13172*/     /*Scope*/ 31, /*->13204*/
/*13173*/       OPC_CheckChild1Integer, 87|128,28/*3671*/, 
/*13176*/       OPC_RecordChild2, // #1 = $s
/*13177*/       OPC_RecordChild3, // #2 = $l
/*13178*/       OPC_RecordChild4, // #3 = $x
/*13179*/       OPC_RecordChild5, // #4 = $y
/*13180*/       OPC_RecordChild6, // #5 = $r
/*13181*/       OPC_RecordChild7, // #6 = $g
/*13182*/       OPC_MoveChild, 8,
/*13184*/       OPC_RecordNode, // #7 = $b
/*13185*/       OPC_MoveParent,
/*13186*/       OPC_MoveChild, 9,
/*13188*/       OPC_RecordNode, // #8 = $a
/*13189*/       OPC_MoveParent,
/*13190*/       OPC_EmitMergeInputChains1_0,
/*13191*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B32_CLAMP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3671:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*13204*/     /*Scope*/ 19, /*->13224*/
/*13205*/       OPC_CheckChild1Integer, 7|128,29/*3719*/, 
/*13208*/       OPC_RecordChild2, // #1 = $s
/*13209*/       OPC_RecordChild3, // #2 = $x
/*13210*/       OPC_RecordChild4, // #3 = $y
/*13211*/       OPC_RecordChild5, // #4 = $z
/*13212*/       OPC_RecordChild6, // #5 = $r
/*13213*/       OPC_EmitMergeInputChains1_0,
/*13214*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B8_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3719:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*13224*/     /*Scope*/ 19, /*->13244*/
/*13225*/       OPC_CheckChild1Integer, 126|128,28/*3710*/, 
/*13228*/       OPC_RecordChild2, // #1 = $s
/*13229*/       OPC_RecordChild3, // #2 = $x
/*13230*/       OPC_RecordChild4, // #3 = $y
/*13231*/       OPC_RecordChild5, // #4 = $z
/*13232*/       OPC_RecordChild6, // #5 = $r
/*13233*/       OPC_EmitMergeInputChains1_0,
/*13234*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B16_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3710:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*13244*/     /*Scope*/ 19, /*->13264*/
/*13245*/       OPC_CheckChild1Integer, 1|128,29/*3713*/, 
/*13248*/       OPC_RecordChild2, // #1 = $s
/*13249*/       OPC_RecordChild3, // #2 = $x
/*13250*/       OPC_RecordChild4, // #3 = $y
/*13251*/       OPC_RecordChild5, // #4 = $z
/*13252*/       OPC_RecordChild6, // #5 = $r
/*13253*/       OPC_EmitMergeInputChains1_0,
/*13254*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B32_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3713:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r)
/*13264*/     /*Scope*/ 19, /*->13284*/
/*13265*/       OPC_CheckChild1Integer, 4|128,29/*3716*/, 
/*13268*/       OPC_RecordChild2, // #1 = $s
/*13269*/       OPC_RecordChild3, // #2 = $x
/*13270*/       OPC_RecordChild4, // #3 = $y
/*13271*/       OPC_RecordChild5, // #4 = $z
/*13272*/       OPC_RecordChild6, // #5 = $r
/*13273*/       OPC_EmitMergeInputChains1_0,
/*13274*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B64_CLAMP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3716:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r)
/*13284*/     /*Scope*/ 21, /*->13306*/
/*13285*/       OPC_CheckChild1Integer, 19|128,29/*3731*/, 
/*13288*/       OPC_RecordChild2, // #1 = $s
/*13289*/       OPC_RecordChild3, // #2 = $x
/*13290*/       OPC_RecordChild4, // #3 = $y
/*13291*/       OPC_RecordChild5, // #4 = $z
/*13292*/       OPC_RecordChild6, // #5 = $r
/*13293*/       OPC_RecordChild7, // #6 = $g
/*13294*/       OPC_EmitMergeInputChains1_0,
/*13295*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B8_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3731:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13306*/     /*Scope*/ 21, /*->13328*/
/*13307*/       OPC_CheckChild1Integer, 10|128,29/*3722*/, 
/*13310*/       OPC_RecordChild2, // #1 = $s
/*13311*/       OPC_RecordChild3, // #2 = $x
/*13312*/       OPC_RecordChild4, // #3 = $y
/*13313*/       OPC_RecordChild5, // #4 = $z
/*13314*/       OPC_RecordChild6, // #5 = $r
/*13315*/       OPC_RecordChild7, // #6 = $g
/*13316*/       OPC_EmitMergeInputChains1_0,
/*13317*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B16_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3722:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13328*/     /*Scope*/ 21, /*->13350*/
/*13329*/       OPC_CheckChild1Integer, 13|128,29/*3725*/, 
/*13332*/       OPC_RecordChild2, // #1 = $s
/*13333*/       OPC_RecordChild3, // #2 = $x
/*13334*/       OPC_RecordChild4, // #3 = $y
/*13335*/       OPC_RecordChild5, // #4 = $z
/*13336*/       OPC_RecordChild6, // #5 = $r
/*13337*/       OPC_RecordChild7, // #6 = $g
/*13338*/       OPC_EmitMergeInputChains1_0,
/*13339*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B32_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3725:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*13350*/     /*Scope*/ 21, /*->13372*/
/*13351*/       OPC_CheckChild1Integer, 16|128,29/*3728*/, 
/*13354*/       OPC_RecordChild2, // #1 = $s
/*13355*/       OPC_RecordChild3, // #2 = $x
/*13356*/       OPC_RecordChild4, // #3 = $y
/*13357*/       OPC_RecordChild5, // #4 = $z
/*13358*/       OPC_RecordChild6, // #5 = $r
/*13359*/       OPC_RecordChild7, // #6 = $g
/*13360*/       OPC_EmitMergeInputChains1_0,
/*13361*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B64_CLAMP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3728:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B64_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*13372*/     /*Scope*/ 31, /*->13404*/
/*13373*/       OPC_CheckChild1Integer, 28|128,29/*3740*/, 
/*13376*/       OPC_RecordChild2, // #1 = $s
/*13377*/       OPC_RecordChild3, // #2 = $x
/*13378*/       OPC_RecordChild4, // #3 = $y
/*13379*/       OPC_RecordChild5, // #4 = $z
/*13380*/       OPC_RecordChild6, // #5 = $r
/*13381*/       OPC_RecordChild7, // #6 = $g
/*13382*/       OPC_MoveChild, 8,
/*13384*/       OPC_RecordNode, // #7 = $b
/*13385*/       OPC_MoveParent,
/*13386*/       OPC_MoveChild, 9,
/*13388*/       OPC_RecordNode, // #8 = $a
/*13389*/       OPC_MoveParent,
/*13390*/       OPC_EmitMergeInputChains1_0,
/*13391*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B8_CLAMP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3740:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B8_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13404*/     /*Scope*/ 31, /*->13436*/
/*13405*/       OPC_CheckChild1Integer, 22|128,29/*3734*/, 
/*13408*/       OPC_RecordChild2, // #1 = $s
/*13409*/       OPC_RecordChild3, // #2 = $x
/*13410*/       OPC_RecordChild4, // #3 = $y
/*13411*/       OPC_RecordChild5, // #4 = $z
/*13412*/       OPC_RecordChild6, // #5 = $r
/*13413*/       OPC_RecordChild7, // #6 = $g
/*13414*/       OPC_MoveChild, 8,
/*13416*/       OPC_RecordNode, // #7 = $b
/*13417*/       OPC_MoveParent,
/*13418*/       OPC_MoveChild, 9,
/*13420*/       OPC_RecordNode, // #8 = $a
/*13421*/       OPC_MoveParent,
/*13422*/       OPC_EmitMergeInputChains1_0,
/*13423*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B16_CLAMP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3734:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B16_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13436*/     /*Scope*/ 31, /*->13468*/
/*13437*/       OPC_CheckChild1Integer, 25|128,29/*3737*/, 
/*13440*/       OPC_RecordChild2, // #1 = $s
/*13441*/       OPC_RecordChild3, // #2 = $x
/*13442*/       OPC_RecordChild4, // #3 = $y
/*13443*/       OPC_RecordChild5, // #4 = $z
/*13444*/       OPC_RecordChild6, // #5 = $r
/*13445*/       OPC_RecordChild7, // #6 = $g
/*13446*/       OPC_MoveChild, 8,
/*13448*/       OPC_RecordNode, // #7 = $b
/*13449*/       OPC_MoveParent,
/*13450*/       OPC_MoveChild, 9,
/*13452*/       OPC_RecordNode, // #8 = $a
/*13453*/       OPC_MoveParent,
/*13454*/       OPC_EmitMergeInputChains1_0,
/*13455*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B32_CLAMP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3737:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B32_CLAMP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*13468*/     /*Scope*/ 15, /*->13484*/
/*13469*/       OPC_CheckChild1Integer, 37|128,28/*3621*/, 
/*13472*/       OPC_RecordChild2, // #1 = $s
/*13473*/       OPC_RecordChild3, // #2 = $x
/*13474*/       OPC_RecordChild4, // #3 = $r
/*13475*/       OPC_EmitMergeInputChains1_0,
/*13476*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B8_TRAP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3621:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*13484*/     /*Scope*/ 15, /*->13500*/
/*13485*/       OPC_CheckChild1Integer, 28|128,28/*3612*/, 
/*13488*/       OPC_RecordChild2, // #1 = $s
/*13489*/       OPC_RecordChild3, // #2 = $x
/*13490*/       OPC_RecordChild4, // #3 = $r
/*13491*/       OPC_EmitMergeInputChains1_0,
/*13492*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B16_TRAP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3612:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*13500*/     /*Scope*/ 15, /*->13516*/
/*13501*/       OPC_CheckChild1Integer, 31|128,28/*3615*/, 
/*13504*/       OPC_RecordChild2, // #1 = $s
/*13505*/       OPC_RecordChild3, // #2 = $x
/*13506*/       OPC_RecordChild4, // #3 = $r
/*13507*/       OPC_EmitMergeInputChains1_0,
/*13508*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B32_TRAP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3615:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*13516*/     /*Scope*/ 15, /*->13532*/
/*13517*/       OPC_CheckChild1Integer, 34|128,28/*3618*/, 
/*13520*/       OPC_RecordChild2, // #1 = $s
/*13521*/       OPC_RecordChild3, // #2 = $x
/*13522*/       OPC_RecordChild4, // #3 = $r
/*13523*/       OPC_EmitMergeInputChains1_0,
/*13524*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B64_TRAP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3618:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r)
/*13532*/     /*Scope*/ 17, /*->13550*/
/*13533*/       OPC_CheckChild1Integer, 49|128,28/*3633*/, 
/*13536*/       OPC_RecordChild2, // #1 = $s
/*13537*/       OPC_RecordChild3, // #2 = $x
/*13538*/       OPC_RecordChild4, // #3 = $r
/*13539*/       OPC_RecordChild5, // #4 = $g
/*13540*/       OPC_EmitMergeInputChains1_0,
/*13541*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B8_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3633:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13550*/     /*Scope*/ 17, /*->13568*/
/*13551*/       OPC_CheckChild1Integer, 40|128,28/*3624*/, 
/*13554*/       OPC_RecordChild2, // #1 = $s
/*13555*/       OPC_RecordChild3, // #2 = $x
/*13556*/       OPC_RecordChild4, // #3 = $r
/*13557*/       OPC_RecordChild5, // #4 = $g
/*13558*/       OPC_EmitMergeInputChains1_0,
/*13559*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B16_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3624:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13568*/     /*Scope*/ 17, /*->13586*/
/*13569*/       OPC_CheckChild1Integer, 43|128,28/*3627*/, 
/*13572*/       OPC_RecordChild2, // #1 = $s
/*13573*/       OPC_RecordChild3, // #2 = $x
/*13574*/       OPC_RecordChild4, // #3 = $r
/*13575*/       OPC_RecordChild5, // #4 = $g
/*13576*/       OPC_EmitMergeInputChains1_0,
/*13577*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B32_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3627:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*13586*/     /*Scope*/ 17, /*->13604*/
/*13587*/       OPC_CheckChild1Integer, 46|128,28/*3630*/, 
/*13590*/       OPC_RecordChild2, // #1 = $s
/*13591*/       OPC_RecordChild3, // #2 = $x
/*13592*/       OPC_RecordChild4, // #3 = $r
/*13593*/       OPC_RecordChild5, // #4 = $g
/*13594*/       OPC_EmitMergeInputChains1_0,
/*13595*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B64_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3630:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*13604*/     /*Scope*/ 21, /*->13626*/
/*13605*/       OPC_CheckChild1Integer, 58|128,28/*3642*/, 
/*13608*/       OPC_RecordChild2, // #1 = $s
/*13609*/       OPC_RecordChild3, // #2 = $x
/*13610*/       OPC_RecordChild4, // #3 = $r
/*13611*/       OPC_RecordChild5, // #4 = $g
/*13612*/       OPC_RecordChild6, // #5 = $b
/*13613*/       OPC_RecordChild7, // #6 = $a
/*13614*/       OPC_EmitMergeInputChains1_0,
/*13615*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B8_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3642:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13626*/     /*Scope*/ 21, /*->13648*/
/*13627*/       OPC_CheckChild1Integer, 52|128,28/*3636*/, 
/*13630*/       OPC_RecordChild2, // #1 = $s
/*13631*/       OPC_RecordChild3, // #2 = $x
/*13632*/       OPC_RecordChild4, // #3 = $r
/*13633*/       OPC_RecordChild5, // #4 = $g
/*13634*/       OPC_RecordChild6, // #5 = $b
/*13635*/       OPC_RecordChild7, // #6 = $a
/*13636*/       OPC_EmitMergeInputChains1_0,
/*13637*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B16_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3636:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13648*/     /*Scope*/ 21, /*->13670*/
/*13649*/       OPC_CheckChild1Integer, 55|128,28/*3639*/, 
/*13652*/       OPC_RecordChild2, // #1 = $s
/*13653*/       OPC_RecordChild3, // #2 = $x
/*13654*/       OPC_RecordChild4, // #3 = $r
/*13655*/       OPC_RecordChild5, // #4 = $g
/*13656*/       OPC_RecordChild6, // #5 = $b
/*13657*/       OPC_RecordChild7, // #6 = $a
/*13658*/       OPC_EmitMergeInputChains1_0,
/*13659*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B32_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3639:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*13670*/     /*Scope*/ 17, /*->13688*/
/*13671*/       OPC_CheckChild1Integer, 4|128,28/*3588*/, 
/*13674*/       OPC_RecordChild2, // #1 = $s
/*13675*/       OPC_RecordChild3, // #2 = $l
/*13676*/       OPC_RecordChild4, // #3 = $x
/*13677*/       OPC_RecordChild5, // #4 = $r
/*13678*/       OPC_EmitMergeInputChains1_0,
/*13679*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B8_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3588:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*13688*/     /*Scope*/ 17, /*->13706*/
/*13689*/       OPC_CheckChild1Integer, 123|128,27/*3579*/, 
/*13692*/       OPC_RecordChild2, // #1 = $s
/*13693*/       OPC_RecordChild3, // #2 = $l
/*13694*/       OPC_RecordChild4, // #3 = $x
/*13695*/       OPC_RecordChild5, // #4 = $r
/*13696*/       OPC_EmitMergeInputChains1_0,
/*13697*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B16_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3579:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*13706*/     /*Scope*/ 17, /*->13724*/
/*13707*/       OPC_CheckChild1Integer, 126|128,27/*3582*/, 
/*13710*/       OPC_RecordChild2, // #1 = $s
/*13711*/       OPC_RecordChild3, // #2 = $l
/*13712*/       OPC_RecordChild4, // #3 = $x
/*13713*/       OPC_RecordChild5, // #4 = $r
/*13714*/       OPC_EmitMergeInputChains1_0,
/*13715*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B32_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3582:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*13724*/     /*Scope*/ 17, /*->13742*/
/*13725*/       OPC_CheckChild1Integer, 1|128,28/*3585*/, 
/*13728*/       OPC_RecordChild2, // #1 = $s
/*13729*/       OPC_RecordChild3, // #2 = $l
/*13730*/       OPC_RecordChild4, // #3 = $x
/*13731*/       OPC_RecordChild5, // #4 = $r
/*13732*/       OPC_EmitMergeInputChains1_0,
/*13733*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B64_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3585:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r)
/*13742*/     /*Scope*/ 19, /*->13762*/
/*13743*/       OPC_CheckChild1Integer, 16|128,28/*3600*/, 
/*13746*/       OPC_RecordChild2, // #1 = $s
/*13747*/       OPC_RecordChild3, // #2 = $l
/*13748*/       OPC_RecordChild4, // #3 = $x
/*13749*/       OPC_RecordChild5, // #4 = $r
/*13750*/       OPC_RecordChild6, // #5 = $g
/*13751*/       OPC_EmitMergeInputChains1_0,
/*13752*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3600:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13762*/     /*Scope*/ 19, /*->13782*/
/*13763*/       OPC_CheckChild1Integer, 7|128,28/*3591*/, 
/*13766*/       OPC_RecordChild2, // #1 = $s
/*13767*/       OPC_RecordChild3, // #2 = $l
/*13768*/       OPC_RecordChild4, // #3 = $x
/*13769*/       OPC_RecordChild5, // #4 = $r
/*13770*/       OPC_RecordChild6, // #5 = $g
/*13771*/       OPC_EmitMergeInputChains1_0,
/*13772*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3591:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13782*/     /*Scope*/ 19, /*->13802*/
/*13783*/       OPC_CheckChild1Integer, 10|128,28/*3594*/, 
/*13786*/       OPC_RecordChild2, // #1 = $s
/*13787*/       OPC_RecordChild3, // #2 = $l
/*13788*/       OPC_RecordChild4, // #3 = $x
/*13789*/       OPC_RecordChild5, // #4 = $r
/*13790*/       OPC_RecordChild6, // #5 = $g
/*13791*/       OPC_EmitMergeInputChains1_0,
/*13792*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3594:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*13802*/     /*Scope*/ 19, /*->13822*/
/*13803*/       OPC_CheckChild1Integer, 13|128,28/*3597*/, 
/*13806*/       OPC_RecordChild2, // #1 = $s
/*13807*/       OPC_RecordChild3, // #2 = $l
/*13808*/       OPC_RecordChild4, // #3 = $x
/*13809*/       OPC_RecordChild5, // #4 = $r
/*13810*/       OPC_RecordChild6, // #5 = $g
/*13811*/       OPC_EmitMergeInputChains1_0,
/*13812*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B64_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3597:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*13822*/     /*Scope*/ 26, /*->13849*/
/*13823*/       OPC_CheckChild1Integer, 25|128,28/*3609*/, 
/*13826*/       OPC_RecordChild2, // #1 = $s
/*13827*/       OPC_RecordChild3, // #2 = $l
/*13828*/       OPC_RecordChild4, // #3 = $x
/*13829*/       OPC_RecordChild5, // #4 = $r
/*13830*/       OPC_RecordChild6, // #5 = $g
/*13831*/       OPC_RecordChild7, // #6 = $b
/*13832*/       OPC_MoveChild, 8,
/*13834*/       OPC_RecordNode, // #7 = $a
/*13835*/       OPC_MoveParent,
/*13836*/       OPC_EmitMergeInputChains1_0,
/*13837*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B8_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3609:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13849*/     /*Scope*/ 26, /*->13876*/
/*13850*/       OPC_CheckChild1Integer, 19|128,28/*3603*/, 
/*13853*/       OPC_RecordChild2, // #1 = $s
/*13854*/       OPC_RecordChild3, // #2 = $l
/*13855*/       OPC_RecordChild4, // #3 = $x
/*13856*/       OPC_RecordChild5, // #4 = $r
/*13857*/       OPC_RecordChild6, // #5 = $g
/*13858*/       OPC_RecordChild7, // #6 = $b
/*13859*/       OPC_MoveChild, 8,
/*13861*/       OPC_RecordNode, // #7 = $a
/*13862*/       OPC_MoveParent,
/*13863*/       OPC_EmitMergeInputChains1_0,
/*13864*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B16_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3603:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*13876*/     /*Scope*/ 26, /*->13903*/
/*13877*/       OPC_CheckChild1Integer, 22|128,28/*3606*/, 
/*13880*/       OPC_RecordChild2, // #1 = $s
/*13881*/       OPC_RecordChild3, // #2 = $l
/*13882*/       OPC_RecordChild4, // #3 = $x
/*13883*/       OPC_RecordChild5, // #4 = $r
/*13884*/       OPC_RecordChild6, // #5 = $g
/*13885*/       OPC_RecordChild7, // #6 = $b
/*13886*/       OPC_MoveChild, 8,
/*13888*/       OPC_RecordNode, // #7 = $a
/*13889*/       OPC_MoveParent,
/*13890*/       OPC_EmitMergeInputChains1_0,
/*13891*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B32_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3606:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*13903*/     /*Scope*/ 17, /*->13921*/
/*13904*/       OPC_CheckChild1Integer, 103|128,28/*3687*/, 
/*13907*/       OPC_RecordChild2, // #1 = $s
/*13908*/       OPC_RecordChild3, // #2 = $x
/*13909*/       OPC_RecordChild4, // #3 = $y
/*13910*/       OPC_RecordChild5, // #4 = $r
/*13911*/       OPC_EmitMergeInputChains1_0,
/*13912*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B8_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3687:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*13921*/     /*Scope*/ 17, /*->13939*/
/*13922*/       OPC_CheckChild1Integer, 94|128,28/*3678*/, 
/*13925*/       OPC_RecordChild2, // #1 = $s
/*13926*/       OPC_RecordChild3, // #2 = $x
/*13927*/       OPC_RecordChild4, // #3 = $y
/*13928*/       OPC_RecordChild5, // #4 = $r
/*13929*/       OPC_EmitMergeInputChains1_0,
/*13930*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B16_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3678:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*13939*/     /*Scope*/ 17, /*->13957*/
/*13940*/       OPC_CheckChild1Integer, 97|128,28/*3681*/, 
/*13943*/       OPC_RecordChild2, // #1 = $s
/*13944*/       OPC_RecordChild3, // #2 = $x
/*13945*/       OPC_RecordChild4, // #3 = $y
/*13946*/       OPC_RecordChild5, // #4 = $r
/*13947*/       OPC_EmitMergeInputChains1_0,
/*13948*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B32_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3681:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*13957*/     /*Scope*/ 17, /*->13975*/
/*13958*/       OPC_CheckChild1Integer, 100|128,28/*3684*/, 
/*13961*/       OPC_RecordChild2, // #1 = $s
/*13962*/       OPC_RecordChild3, // #2 = $x
/*13963*/       OPC_RecordChild4, // #3 = $y
/*13964*/       OPC_RecordChild5, // #4 = $r
/*13965*/       OPC_EmitMergeInputChains1_0,
/*13966*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B64_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3684:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r)
/*13975*/     /*Scope*/ 19, /*->13995*/
/*13976*/       OPC_CheckChild1Integer, 115|128,28/*3699*/, 
/*13979*/       OPC_RecordChild2, // #1 = $s
/*13980*/       OPC_RecordChild3, // #2 = $x
/*13981*/       OPC_RecordChild4, // #3 = $y
/*13982*/       OPC_RecordChild5, // #4 = $r
/*13983*/       OPC_RecordChild6, // #5 = $g
/*13984*/       OPC_EmitMergeInputChains1_0,
/*13985*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3699:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*13995*/     /*Scope*/ 19, /*->14015*/
/*13996*/       OPC_CheckChild1Integer, 106|128,28/*3690*/, 
/*13999*/       OPC_RecordChild2, // #1 = $s
/*14000*/       OPC_RecordChild3, // #2 = $x
/*14001*/       OPC_RecordChild4, // #3 = $y
/*14002*/       OPC_RecordChild5, // #4 = $r
/*14003*/       OPC_RecordChild6, // #5 = $g
/*14004*/       OPC_EmitMergeInputChains1_0,
/*14005*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3690:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14015*/     /*Scope*/ 19, /*->14035*/
/*14016*/       OPC_CheckChild1Integer, 109|128,28/*3693*/, 
/*14019*/       OPC_RecordChild2, // #1 = $s
/*14020*/       OPC_RecordChild3, // #2 = $x
/*14021*/       OPC_RecordChild4, // #3 = $y
/*14022*/       OPC_RecordChild5, // #4 = $r
/*14023*/       OPC_RecordChild6, // #5 = $g
/*14024*/       OPC_EmitMergeInputChains1_0,
/*14025*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3693:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*14035*/     /*Scope*/ 19, /*->14055*/
/*14036*/       OPC_CheckChild1Integer, 112|128,28/*3696*/, 
/*14039*/       OPC_RecordChild2, // #1 = $s
/*14040*/       OPC_RecordChild3, // #2 = $x
/*14041*/       OPC_RecordChild4, // #3 = $y
/*14042*/       OPC_RecordChild5, // #4 = $r
/*14043*/       OPC_RecordChild6, // #5 = $g
/*14044*/       OPC_EmitMergeInputChains1_0,
/*14045*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B64_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3696:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*14055*/     /*Scope*/ 26, /*->14082*/
/*14056*/       OPC_CheckChild1Integer, 124|128,28/*3708*/, 
/*14059*/       OPC_RecordChild2, // #1 = $s
/*14060*/       OPC_RecordChild3, // #2 = $x
/*14061*/       OPC_RecordChild4, // #3 = $y
/*14062*/       OPC_RecordChild5, // #4 = $r
/*14063*/       OPC_RecordChild6, // #5 = $g
/*14064*/       OPC_RecordChild7, // #6 = $b
/*14065*/       OPC_MoveChild, 8,
/*14067*/       OPC_RecordNode, // #7 = $a
/*14068*/       OPC_MoveParent,
/*14069*/       OPC_EmitMergeInputChains1_0,
/*14070*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B8_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3708:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14082*/     /*Scope*/ 26, /*->14109*/
/*14083*/       OPC_CheckChild1Integer, 118|128,28/*3702*/, 
/*14086*/       OPC_RecordChild2, // #1 = $s
/*14087*/       OPC_RecordChild3, // #2 = $x
/*14088*/       OPC_RecordChild4, // #3 = $y
/*14089*/       OPC_RecordChild5, // #4 = $r
/*14090*/       OPC_RecordChild6, // #5 = $g
/*14091*/       OPC_RecordChild7, // #6 = $b
/*14092*/       OPC_MoveChild, 8,
/*14094*/       OPC_RecordNode, // #7 = $a
/*14095*/       OPC_MoveParent,
/*14096*/       OPC_EmitMergeInputChains1_0,
/*14097*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B16_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3702:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14109*/     /*Scope*/ 26, /*->14136*/
/*14110*/       OPC_CheckChild1Integer, 121|128,28/*3705*/, 
/*14113*/       OPC_RecordChild2, // #1 = $s
/*14114*/       OPC_RecordChild3, // #2 = $x
/*14115*/       OPC_RecordChild4, // #3 = $y
/*14116*/       OPC_RecordChild5, // #4 = $r
/*14117*/       OPC_RecordChild6, // #5 = $g
/*14118*/       OPC_RecordChild7, // #6 = $b
/*14119*/       OPC_MoveChild, 8,
/*14121*/       OPC_RecordNode, // #7 = $a
/*14122*/       OPC_MoveParent,
/*14123*/       OPC_EmitMergeInputChains1_0,
/*14124*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B32_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3705:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*14136*/     /*Scope*/ 19, /*->14156*/
/*14137*/       OPC_CheckChild1Integer, 70|128,28/*3654*/, 
/*14140*/       OPC_RecordChild2, // #1 = $s
/*14141*/       OPC_RecordChild3, // #2 = $l
/*14142*/       OPC_RecordChild4, // #3 = $x
/*14143*/       OPC_RecordChild5, // #4 = $y
/*14144*/       OPC_RecordChild6, // #5 = $r
/*14145*/       OPC_EmitMergeInputChains1_0,
/*14146*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3654:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*14156*/     /*Scope*/ 19, /*->14176*/
/*14157*/       OPC_CheckChild1Integer, 61|128,28/*3645*/, 
/*14160*/       OPC_RecordChild2, // #1 = $s
/*14161*/       OPC_RecordChild3, // #2 = $l
/*14162*/       OPC_RecordChild4, // #3 = $x
/*14163*/       OPC_RecordChild5, // #4 = $y
/*14164*/       OPC_RecordChild6, // #5 = $r
/*14165*/       OPC_EmitMergeInputChains1_0,
/*14166*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3645:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*14176*/     /*Scope*/ 19, /*->14196*/
/*14177*/       OPC_CheckChild1Integer, 64|128,28/*3648*/, 
/*14180*/       OPC_RecordChild2, // #1 = $s
/*14181*/       OPC_RecordChild3, // #2 = $l
/*14182*/       OPC_RecordChild4, // #3 = $x
/*14183*/       OPC_RecordChild5, // #4 = $y
/*14184*/       OPC_RecordChild6, // #5 = $r
/*14185*/       OPC_EmitMergeInputChains1_0,
/*14186*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3648:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*14196*/     /*Scope*/ 19, /*->14216*/
/*14197*/       OPC_CheckChild1Integer, 67|128,28/*3651*/, 
/*14200*/       OPC_RecordChild2, // #1 = $s
/*14201*/       OPC_RecordChild3, // #2 = $l
/*14202*/       OPC_RecordChild4, // #3 = $x
/*14203*/       OPC_RecordChild5, // #4 = $y
/*14204*/       OPC_RecordChild6, // #5 = $r
/*14205*/       OPC_EmitMergeInputChains1_0,
/*14206*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B64_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3651:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r)
/*14216*/     /*Scope*/ 21, /*->14238*/
/*14217*/       OPC_CheckChild1Integer, 82|128,28/*3666*/, 
/*14220*/       OPC_RecordChild2, // #1 = $s
/*14221*/       OPC_RecordChild3, // #2 = $l
/*14222*/       OPC_RecordChild4, // #3 = $x
/*14223*/       OPC_RecordChild5, // #4 = $y
/*14224*/       OPC_RecordChild6, // #5 = $r
/*14225*/       OPC_RecordChild7, // #6 = $g
/*14226*/       OPC_EmitMergeInputChains1_0,
/*14227*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B8_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3666:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14238*/     /*Scope*/ 21, /*->14260*/
/*14239*/       OPC_CheckChild1Integer, 73|128,28/*3657*/, 
/*14242*/       OPC_RecordChild2, // #1 = $s
/*14243*/       OPC_RecordChild3, // #2 = $l
/*14244*/       OPC_RecordChild4, // #3 = $x
/*14245*/       OPC_RecordChild5, // #4 = $y
/*14246*/       OPC_RecordChild6, // #5 = $r
/*14247*/       OPC_RecordChild7, // #6 = $g
/*14248*/       OPC_EmitMergeInputChains1_0,
/*14249*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B16_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3657:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14260*/     /*Scope*/ 21, /*->14282*/
/*14261*/       OPC_CheckChild1Integer, 76|128,28/*3660*/, 
/*14264*/       OPC_RecordChild2, // #1 = $s
/*14265*/       OPC_RecordChild3, // #2 = $l
/*14266*/       OPC_RecordChild4, // #3 = $x
/*14267*/       OPC_RecordChild5, // #4 = $y
/*14268*/       OPC_RecordChild6, // #5 = $r
/*14269*/       OPC_RecordChild7, // #6 = $g
/*14270*/       OPC_EmitMergeInputChains1_0,
/*14271*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B32_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3660:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*14282*/     /*Scope*/ 21, /*->14304*/
/*14283*/       OPC_CheckChild1Integer, 79|128,28/*3663*/, 
/*14286*/       OPC_RecordChild2, // #1 = $s
/*14287*/       OPC_RecordChild3, // #2 = $l
/*14288*/       OPC_RecordChild4, // #3 = $x
/*14289*/       OPC_RecordChild5, // #4 = $y
/*14290*/       OPC_RecordChild6, // #5 = $r
/*14291*/       OPC_RecordChild7, // #6 = $g
/*14292*/       OPC_EmitMergeInputChains1_0,
/*14293*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B64_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3663:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*14304*/     /*Scope*/ 31, /*->14336*/
/*14305*/       OPC_CheckChild1Integer, 91|128,28/*3675*/, 
/*14308*/       OPC_RecordChild2, // #1 = $s
/*14309*/       OPC_RecordChild3, // #2 = $l
/*14310*/       OPC_RecordChild4, // #3 = $x
/*14311*/       OPC_RecordChild5, // #4 = $y
/*14312*/       OPC_RecordChild6, // #5 = $r
/*14313*/       OPC_RecordChild7, // #6 = $g
/*14314*/       OPC_MoveChild, 8,
/*14316*/       OPC_RecordNode, // #7 = $b
/*14317*/       OPC_MoveParent,
/*14318*/       OPC_MoveChild, 9,
/*14320*/       OPC_RecordNode, // #8 = $a
/*14321*/       OPC_MoveParent,
/*14322*/       OPC_EmitMergeInputChains1_0,
/*14323*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B8_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3675:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14336*/     /*Scope*/ 31, /*->14368*/
/*14337*/       OPC_CheckChild1Integer, 85|128,28/*3669*/, 
/*14340*/       OPC_RecordChild2, // #1 = $s
/*14341*/       OPC_RecordChild3, // #2 = $l
/*14342*/       OPC_RecordChild4, // #3 = $x
/*14343*/       OPC_RecordChild5, // #4 = $y
/*14344*/       OPC_RecordChild6, // #5 = $r
/*14345*/       OPC_RecordChild7, // #6 = $g
/*14346*/       OPC_MoveChild, 8,
/*14348*/       OPC_RecordNode, // #7 = $b
/*14349*/       OPC_MoveParent,
/*14350*/       OPC_MoveChild, 9,
/*14352*/       OPC_RecordNode, // #8 = $a
/*14353*/       OPC_MoveParent,
/*14354*/       OPC_EmitMergeInputChains1_0,
/*14355*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B16_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3669:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14368*/     /*Scope*/ 31, /*->14400*/
/*14369*/       OPC_CheckChild1Integer, 88|128,28/*3672*/, 
/*14372*/       OPC_RecordChild2, // #1 = $s
/*14373*/       OPC_RecordChild3, // #2 = $l
/*14374*/       OPC_RecordChild4, // #3 = $x
/*14375*/       OPC_RecordChild5, // #4 = $y
/*14376*/       OPC_RecordChild6, // #5 = $r
/*14377*/       OPC_RecordChild7, // #6 = $g
/*14378*/       OPC_MoveChild, 8,
/*14380*/       OPC_RecordNode, // #7 = $b
/*14381*/       OPC_MoveParent,
/*14382*/       OPC_MoveChild, 9,
/*14384*/       OPC_RecordNode, // #8 = $a
/*14385*/       OPC_MoveParent,
/*14386*/       OPC_EmitMergeInputChains1_0,
/*14387*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B32_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3672:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*14400*/     /*Scope*/ 19, /*->14420*/
/*14401*/       OPC_CheckChild1Integer, 8|128,29/*3720*/, 
/*14404*/       OPC_RecordChild2, // #1 = $s
/*14405*/       OPC_RecordChild3, // #2 = $x
/*14406*/       OPC_RecordChild4, // #3 = $y
/*14407*/       OPC_RecordChild5, // #4 = $z
/*14408*/       OPC_RecordChild6, // #5 = $r
/*14409*/       OPC_EmitMergeInputChains1_0,
/*14410*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3720:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*14420*/     /*Scope*/ 19, /*->14440*/
/*14421*/       OPC_CheckChild1Integer, 127|128,28/*3711*/, 
/*14424*/       OPC_RecordChild2, // #1 = $s
/*14425*/       OPC_RecordChild3, // #2 = $x
/*14426*/       OPC_RecordChild4, // #3 = $y
/*14427*/       OPC_RecordChild5, // #4 = $z
/*14428*/       OPC_RecordChild6, // #5 = $r
/*14429*/       OPC_EmitMergeInputChains1_0,
/*14430*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3711:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*14440*/     /*Scope*/ 19, /*->14460*/
/*14441*/       OPC_CheckChild1Integer, 2|128,29/*3714*/, 
/*14444*/       OPC_RecordChild2, // #1 = $s
/*14445*/       OPC_RecordChild3, // #2 = $x
/*14446*/       OPC_RecordChild4, // #3 = $y
/*14447*/       OPC_RecordChild5, // #4 = $z
/*14448*/       OPC_RecordChild6, // #5 = $r
/*14449*/       OPC_EmitMergeInputChains1_0,
/*14450*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3714:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r)
/*14460*/     /*Scope*/ 19, /*->14480*/
/*14461*/       OPC_CheckChild1Integer, 5|128,29/*3717*/, 
/*14464*/       OPC_RecordChild2, // #1 = $s
/*14465*/       OPC_RecordChild3, // #2 = $x
/*14466*/       OPC_RecordChild4, // #3 = $y
/*14467*/       OPC_RecordChild5, // #4 = $z
/*14468*/       OPC_RecordChild6, // #5 = $r
/*14469*/       OPC_EmitMergeInputChains1_0,
/*14470*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B64_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3717:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r)
/*14480*/     /*Scope*/ 21, /*->14502*/
/*14481*/       OPC_CheckChild1Integer, 20|128,29/*3732*/, 
/*14484*/       OPC_RecordChild2, // #1 = $s
/*14485*/       OPC_RecordChild3, // #2 = $x
/*14486*/       OPC_RecordChild4, // #3 = $y
/*14487*/       OPC_RecordChild5, // #4 = $z
/*14488*/       OPC_RecordChild6, // #5 = $r
/*14489*/       OPC_RecordChild7, // #6 = $g
/*14490*/       OPC_EmitMergeInputChains1_0,
/*14491*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B8_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3732:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14502*/     /*Scope*/ 21, /*->14524*/
/*14503*/       OPC_CheckChild1Integer, 11|128,29/*3723*/, 
/*14506*/       OPC_RecordChild2, // #1 = $s
/*14507*/       OPC_RecordChild3, // #2 = $x
/*14508*/       OPC_RecordChild4, // #3 = $y
/*14509*/       OPC_RecordChild5, // #4 = $z
/*14510*/       OPC_RecordChild6, // #5 = $r
/*14511*/       OPC_RecordChild7, // #6 = $g
/*14512*/       OPC_EmitMergeInputChains1_0,
/*14513*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B16_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3723:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14524*/     /*Scope*/ 21, /*->14546*/
/*14525*/       OPC_CheckChild1Integer, 14|128,29/*3726*/, 
/*14528*/       OPC_RecordChild2, // #1 = $s
/*14529*/       OPC_RecordChild3, // #2 = $x
/*14530*/       OPC_RecordChild4, // #3 = $y
/*14531*/       OPC_RecordChild5, // #4 = $z
/*14532*/       OPC_RecordChild6, // #5 = $r
/*14533*/       OPC_RecordChild7, // #6 = $g
/*14534*/       OPC_EmitMergeInputChains1_0,
/*14535*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B32_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3726:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*14546*/     /*Scope*/ 21, /*->14568*/
/*14547*/       OPC_CheckChild1Integer, 17|128,29/*3729*/, 
/*14550*/       OPC_RecordChild2, // #1 = $s
/*14551*/       OPC_RecordChild3, // #2 = $x
/*14552*/       OPC_RecordChild4, // #3 = $y
/*14553*/       OPC_RecordChild5, // #4 = $z
/*14554*/       OPC_RecordChild6, // #5 = $r
/*14555*/       OPC_RecordChild7, // #6 = $g
/*14556*/       OPC_EmitMergeInputChains1_0,
/*14557*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B64_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3729:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B64_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*14568*/     /*Scope*/ 31, /*->14600*/
/*14569*/       OPC_CheckChild1Integer, 29|128,29/*3741*/, 
/*14572*/       OPC_RecordChild2, // #1 = $s
/*14573*/       OPC_RecordChild3, // #2 = $x
/*14574*/       OPC_RecordChild4, // #3 = $y
/*14575*/       OPC_RecordChild5, // #4 = $z
/*14576*/       OPC_RecordChild6, // #5 = $r
/*14577*/       OPC_RecordChild7, // #6 = $g
/*14578*/       OPC_MoveChild, 8,
/*14580*/       OPC_RecordNode, // #7 = $b
/*14581*/       OPC_MoveParent,
/*14582*/       OPC_MoveChild, 9,
/*14584*/       OPC_RecordNode, // #8 = $a
/*14585*/       OPC_MoveParent,
/*14586*/       OPC_EmitMergeInputChains1_0,
/*14587*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B8_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3741:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14600*/     /*Scope*/ 31, /*->14632*/
/*14601*/       OPC_CheckChild1Integer, 23|128,29/*3735*/, 
/*14604*/       OPC_RecordChild2, // #1 = $s
/*14605*/       OPC_RecordChild3, // #2 = $x
/*14606*/       OPC_RecordChild4, // #3 = $y
/*14607*/       OPC_RecordChild5, // #4 = $z
/*14608*/       OPC_RecordChild6, // #5 = $r
/*14609*/       OPC_RecordChild7, // #6 = $g
/*14610*/       OPC_MoveChild, 8,
/*14612*/       OPC_RecordNode, // #7 = $b
/*14613*/       OPC_MoveParent,
/*14614*/       OPC_MoveChild, 9,
/*14616*/       OPC_RecordNode, // #8 = $a
/*14617*/       OPC_MoveParent,
/*14618*/       OPC_EmitMergeInputChains1_0,
/*14619*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B16_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3735:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14632*/     /*Scope*/ 31, /*->14664*/
/*14633*/       OPC_CheckChild1Integer, 26|128,29/*3738*/, 
/*14636*/       OPC_RecordChild2, // #1 = $s
/*14637*/       OPC_RecordChild3, // #2 = $x
/*14638*/       OPC_RecordChild4, // #3 = $y
/*14639*/       OPC_RecordChild5, // #4 = $z
/*14640*/       OPC_RecordChild6, // #5 = $r
/*14641*/       OPC_RecordChild7, // #6 = $g
/*14642*/       OPC_MoveChild, 8,
/*14644*/       OPC_RecordNode, // #7 = $b
/*14645*/       OPC_MoveParent,
/*14646*/       OPC_MoveChild, 9,
/*14648*/       OPC_RecordNode, // #8 = $a
/*14649*/       OPC_MoveParent,
/*14650*/       OPC_EmitMergeInputChains1_0,
/*14651*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B32_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3738:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*14664*/     /*Scope*/ 15, /*->14680*/
/*14665*/       OPC_CheckChild1Integer, 38|128,28/*3622*/, 
/*14668*/       OPC_RecordChild2, // #1 = $s
/*14669*/       OPC_RecordChild3, // #2 = $x
/*14670*/       OPC_RecordChild4, // #3 = $r
/*14671*/       OPC_EmitMergeInputChains1_0,
/*14672*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B8_ZERO), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3622:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*14680*/     /*Scope*/ 15, /*->14696*/
/*14681*/       OPC_CheckChild1Integer, 29|128,28/*3613*/, 
/*14684*/       OPC_RecordChild2, // #1 = $s
/*14685*/       OPC_RecordChild3, // #2 = $x
/*14686*/       OPC_RecordChild4, // #3 = $r
/*14687*/       OPC_EmitMergeInputChains1_0,
/*14688*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B16_ZERO), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3613:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*14696*/     /*Scope*/ 15, /*->14712*/
/*14697*/       OPC_CheckChild1Integer, 32|128,28/*3616*/, 
/*14700*/       OPC_RecordChild2, // #1 = $s
/*14701*/       OPC_RecordChild3, // #2 = $x
/*14702*/       OPC_RecordChild4, // #3 = $r
/*14703*/       OPC_EmitMergeInputChains1_0,
/*14704*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B32_ZERO), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3616:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*14712*/     /*Scope*/ 15, /*->14728*/
/*14713*/       OPC_CheckChild1Integer, 35|128,28/*3619*/, 
/*14716*/       OPC_RecordChild2, // #1 = $s
/*14717*/       OPC_RecordChild3, // #2 = $x
/*14718*/       OPC_RecordChild4, // #3 = $r
/*14719*/       OPC_EmitMergeInputChains1_0,
/*14720*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_B64_ZERO), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3619:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_1D_B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r)
/*14728*/     /*Scope*/ 17, /*->14746*/
/*14729*/       OPC_CheckChild1Integer, 50|128,28/*3634*/, 
/*14732*/       OPC_RecordChild2, // #1 = $s
/*14733*/       OPC_RecordChild3, // #2 = $x
/*14734*/       OPC_RecordChild4, // #3 = $r
/*14735*/       OPC_RecordChild5, // #4 = $g
/*14736*/       OPC_EmitMergeInputChains1_0,
/*14737*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B8_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3634:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14746*/     /*Scope*/ 17, /*->14764*/
/*14747*/       OPC_CheckChild1Integer, 41|128,28/*3625*/, 
/*14750*/       OPC_RecordChild2, // #1 = $s
/*14751*/       OPC_RecordChild3, // #2 = $x
/*14752*/       OPC_RecordChild4, // #3 = $r
/*14753*/       OPC_RecordChild5, // #4 = $g
/*14754*/       OPC_EmitMergeInputChains1_0,
/*14755*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B16_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3625:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14764*/     /*Scope*/ 17, /*->14782*/
/*14765*/       OPC_CheckChild1Integer, 44|128,28/*3628*/, 
/*14768*/       OPC_RecordChild2, // #1 = $s
/*14769*/       OPC_RecordChild3, // #2 = $x
/*14770*/       OPC_RecordChild4, // #3 = $r
/*14771*/       OPC_RecordChild5, // #4 = $g
/*14772*/       OPC_EmitMergeInputChains1_0,
/*14773*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B32_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3628:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*14782*/     /*Scope*/ 17, /*->14800*/
/*14783*/       OPC_CheckChild1Integer, 47|128,28/*3631*/, 
/*14786*/       OPC_RecordChild2, // #1 = $s
/*14787*/       OPC_RecordChild3, // #2 = $x
/*14788*/       OPC_RecordChild4, // #3 = $r
/*14789*/       OPC_RecordChild5, // #4 = $g
/*14790*/       OPC_EmitMergeInputChains1_0,
/*14791*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V2B64_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3631:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_1D_V2B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*14800*/     /*Scope*/ 21, /*->14822*/
/*14801*/       OPC_CheckChild1Integer, 59|128,28/*3643*/, 
/*14804*/       OPC_RecordChild2, // #1 = $s
/*14805*/       OPC_RecordChild3, // #2 = $x
/*14806*/       OPC_RecordChild4, // #3 = $r
/*14807*/       OPC_RecordChild5, // #4 = $g
/*14808*/       OPC_RecordChild6, // #5 = $b
/*14809*/       OPC_RecordChild7, // #6 = $a
/*14810*/       OPC_EmitMergeInputChains1_0,
/*14811*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B8_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3643:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14822*/     /*Scope*/ 21, /*->14844*/
/*14823*/       OPC_CheckChild1Integer, 53|128,28/*3637*/, 
/*14826*/       OPC_RecordChild2, // #1 = $s
/*14827*/       OPC_RecordChild3, // #2 = $x
/*14828*/       OPC_RecordChild4, // #3 = $r
/*14829*/       OPC_RecordChild5, // #4 = $g
/*14830*/       OPC_RecordChild6, // #5 = $b
/*14831*/       OPC_RecordChild7, // #6 = $a
/*14832*/       OPC_EmitMergeInputChains1_0,
/*14833*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B16_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3637:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*14844*/     /*Scope*/ 21, /*->14866*/
/*14845*/       OPC_CheckChild1Integer, 56|128,28/*3640*/, 
/*14848*/       OPC_RecordChild2, // #1 = $s
/*14849*/       OPC_RecordChild3, // #2 = $x
/*14850*/       OPC_RecordChild4, // #3 = $r
/*14851*/       OPC_RecordChild5, // #4 = $g
/*14852*/       OPC_RecordChild6, // #5 = $b
/*14853*/       OPC_RecordChild7, // #6 = $a
/*14854*/       OPC_EmitMergeInputChains1_0,
/*14855*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_V4B32_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3640:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_1D_V4B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*14866*/     /*Scope*/ 17, /*->14884*/
/*14867*/       OPC_CheckChild1Integer, 5|128,28/*3589*/, 
/*14870*/       OPC_RecordChild2, // #1 = $s
/*14871*/       OPC_RecordChild3, // #2 = $l
/*14872*/       OPC_RecordChild4, // #3 = $x
/*14873*/       OPC_RecordChild5, // #4 = $r
/*14874*/       OPC_EmitMergeInputChains1_0,
/*14875*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B8_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3589:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*14884*/     /*Scope*/ 17, /*->14902*/
/*14885*/       OPC_CheckChild1Integer, 124|128,27/*3580*/, 
/*14888*/       OPC_RecordChild2, // #1 = $s
/*14889*/       OPC_RecordChild3, // #2 = $l
/*14890*/       OPC_RecordChild4, // #3 = $x
/*14891*/       OPC_RecordChild5, // #4 = $r
/*14892*/       OPC_EmitMergeInputChains1_0,
/*14893*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B16_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3580:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*14902*/     /*Scope*/ 17, /*->14920*/
/*14903*/       OPC_CheckChild1Integer, 127|128,27/*3583*/, 
/*14906*/       OPC_RecordChild2, // #1 = $s
/*14907*/       OPC_RecordChild3, // #2 = $l
/*14908*/       OPC_RecordChild4, // #3 = $x
/*14909*/       OPC_RecordChild5, // #4 = $r
/*14910*/       OPC_EmitMergeInputChains1_0,
/*14911*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B32_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3583:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*14920*/     /*Scope*/ 17, /*->14938*/
/*14921*/       OPC_CheckChild1Integer, 2|128,28/*3586*/, 
/*14924*/       OPC_RecordChild2, // #1 = $s
/*14925*/       OPC_RecordChild3, // #2 = $l
/*14926*/       OPC_RecordChild4, // #3 = $x
/*14927*/       OPC_RecordChild5, // #4 = $r
/*14928*/       OPC_EmitMergeInputChains1_0,
/*14929*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_B64_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3586:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r)
/*14938*/     /*Scope*/ 19, /*->14958*/
/*14939*/       OPC_CheckChild1Integer, 17|128,28/*3601*/, 
/*14942*/       OPC_RecordChild2, // #1 = $s
/*14943*/       OPC_RecordChild3, // #2 = $l
/*14944*/       OPC_RecordChild4, // #3 = $x
/*14945*/       OPC_RecordChild5, // #4 = $r
/*14946*/       OPC_RecordChild6, // #5 = $g
/*14947*/       OPC_EmitMergeInputChains1_0,
/*14948*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B8_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3601:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14958*/     /*Scope*/ 19, /*->14978*/
/*14959*/       OPC_CheckChild1Integer, 8|128,28/*3592*/, 
/*14962*/       OPC_RecordChild2, // #1 = $s
/*14963*/       OPC_RecordChild3, // #2 = $l
/*14964*/       OPC_RecordChild4, // #3 = $x
/*14965*/       OPC_RecordChild5, // #4 = $r
/*14966*/       OPC_RecordChild6, // #5 = $g
/*14967*/       OPC_EmitMergeInputChains1_0,
/*14968*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B16_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3592:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*14978*/     /*Scope*/ 19, /*->14998*/
/*14979*/       OPC_CheckChild1Integer, 11|128,28/*3595*/, 
/*14982*/       OPC_RecordChild2, // #1 = $s
/*14983*/       OPC_RecordChild3, // #2 = $l
/*14984*/       OPC_RecordChild4, // #3 = $x
/*14985*/       OPC_RecordChild5, // #4 = $r
/*14986*/       OPC_RecordChild6, // #5 = $g
/*14987*/       OPC_EmitMergeInputChains1_0,
/*14988*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B32_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3595:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*14998*/     /*Scope*/ 19, /*->15018*/
/*14999*/       OPC_CheckChild1Integer, 14|128,28/*3598*/, 
/*15002*/       OPC_RecordChild2, // #1 = $s
/*15003*/       OPC_RecordChild3, // #2 = $l
/*15004*/       OPC_RecordChild4, // #3 = $x
/*15005*/       OPC_RecordChild5, // #4 = $r
/*15006*/       OPC_RecordChild6, // #5 = $g
/*15007*/       OPC_EmitMergeInputChains1_0,
/*15008*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V2B64_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3598:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V2B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*15018*/     /*Scope*/ 26, /*->15045*/
/*15019*/       OPC_CheckChild1Integer, 26|128,28/*3610*/, 
/*15022*/       OPC_RecordChild2, // #1 = $s
/*15023*/       OPC_RecordChild3, // #2 = $l
/*15024*/       OPC_RecordChild4, // #3 = $x
/*15025*/       OPC_RecordChild5, // #4 = $r
/*15026*/       OPC_RecordChild6, // #5 = $g
/*15027*/       OPC_RecordChild7, // #6 = $b
/*15028*/       OPC_MoveChild, 8,
/*15030*/       OPC_RecordNode, // #7 = $a
/*15031*/       OPC_MoveParent,
/*15032*/       OPC_EmitMergeInputChains1_0,
/*15033*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B8_ZERO), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3610:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15045*/     /*Scope*/ 26, /*->15072*/
/*15046*/       OPC_CheckChild1Integer, 20|128,28/*3604*/, 
/*15049*/       OPC_RecordChild2, // #1 = $s
/*15050*/       OPC_RecordChild3, // #2 = $l
/*15051*/       OPC_RecordChild4, // #3 = $x
/*15052*/       OPC_RecordChild5, // #4 = $r
/*15053*/       OPC_RecordChild6, // #5 = $g
/*15054*/       OPC_RecordChild7, // #6 = $b
/*15055*/       OPC_MoveChild, 8,
/*15057*/       OPC_RecordNode, // #7 = $a
/*15058*/       OPC_MoveParent,
/*15059*/       OPC_EmitMergeInputChains1_0,
/*15060*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B16_ZERO), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3604:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15072*/     /*Scope*/ 26, /*->15099*/
/*15073*/       OPC_CheckChild1Integer, 23|128,28/*3607*/, 
/*15076*/       OPC_RecordChild2, // #1 = $s
/*15077*/       OPC_RecordChild3, // #2 = $l
/*15078*/       OPC_RecordChild4, // #3 = $x
/*15079*/       OPC_RecordChild5, // #4 = $r
/*15080*/       OPC_RecordChild6, // #5 = $g
/*15081*/       OPC_RecordChild7, // #6 = $b
/*15082*/       OPC_MoveChild, 8,
/*15084*/       OPC_RecordNode, // #7 = $a
/*15085*/       OPC_MoveParent,
/*15086*/       OPC_EmitMergeInputChains1_0,
/*15087*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_1D_ARRAY_V4B32_ZERO), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3607:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_1D_ARRAY_V4B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*15099*/     /*Scope*/ 17, /*->15117*/
/*15100*/       OPC_CheckChild1Integer, 104|128,28/*3688*/, 
/*15103*/       OPC_RecordChild2, // #1 = $s
/*15104*/       OPC_RecordChild3, // #2 = $x
/*15105*/       OPC_RecordChild4, // #3 = $y
/*15106*/       OPC_RecordChild5, // #4 = $r
/*15107*/       OPC_EmitMergeInputChains1_0,
/*15108*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B8_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3688:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*15117*/     /*Scope*/ 17, /*->15135*/
/*15118*/       OPC_CheckChild1Integer, 95|128,28/*3679*/, 
/*15121*/       OPC_RecordChild2, // #1 = $s
/*15122*/       OPC_RecordChild3, // #2 = $x
/*15123*/       OPC_RecordChild4, // #3 = $y
/*15124*/       OPC_RecordChild5, // #4 = $r
/*15125*/       OPC_EmitMergeInputChains1_0,
/*15126*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B16_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3679:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*15135*/     /*Scope*/ 17, /*->15153*/
/*15136*/       OPC_CheckChild1Integer, 98|128,28/*3682*/, 
/*15139*/       OPC_RecordChild2, // #1 = $s
/*15140*/       OPC_RecordChild3, // #2 = $x
/*15141*/       OPC_RecordChild4, // #3 = $y
/*15142*/       OPC_RecordChild5, // #4 = $r
/*15143*/       OPC_EmitMergeInputChains1_0,
/*15144*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B32_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3682:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*15153*/     /*Scope*/ 17, /*->15171*/
/*15154*/       OPC_CheckChild1Integer, 101|128,28/*3685*/, 
/*15157*/       OPC_RecordChild2, // #1 = $s
/*15158*/       OPC_RecordChild3, // #2 = $x
/*15159*/       OPC_RecordChild4, // #3 = $y
/*15160*/       OPC_RecordChild5, // #4 = $r
/*15161*/       OPC_EmitMergeInputChains1_0,
/*15162*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_B64_ZERO), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3685:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_2D_B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r)
/*15171*/     /*Scope*/ 19, /*->15191*/
/*15172*/       OPC_CheckChild1Integer, 116|128,28/*3700*/, 
/*15175*/       OPC_RecordChild2, // #1 = $s
/*15176*/       OPC_RecordChild3, // #2 = $x
/*15177*/       OPC_RecordChild4, // #3 = $y
/*15178*/       OPC_RecordChild5, // #4 = $r
/*15179*/       OPC_RecordChild6, // #5 = $g
/*15180*/       OPC_EmitMergeInputChains1_0,
/*15181*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B8_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3700:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15191*/     /*Scope*/ 19, /*->15211*/
/*15192*/       OPC_CheckChild1Integer, 107|128,28/*3691*/, 
/*15195*/       OPC_RecordChild2, // #1 = $s
/*15196*/       OPC_RecordChild3, // #2 = $x
/*15197*/       OPC_RecordChild4, // #3 = $y
/*15198*/       OPC_RecordChild5, // #4 = $r
/*15199*/       OPC_RecordChild6, // #5 = $g
/*15200*/       OPC_EmitMergeInputChains1_0,
/*15201*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B16_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3691:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15211*/     /*Scope*/ 19, /*->15231*/
/*15212*/       OPC_CheckChild1Integer, 110|128,28/*3694*/, 
/*15215*/       OPC_RecordChild2, // #1 = $s
/*15216*/       OPC_RecordChild3, // #2 = $x
/*15217*/       OPC_RecordChild4, // #3 = $y
/*15218*/       OPC_RecordChild5, // #4 = $r
/*15219*/       OPC_RecordChild6, // #5 = $g
/*15220*/       OPC_EmitMergeInputChains1_0,
/*15221*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B32_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3694:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*15231*/     /*Scope*/ 19, /*->15251*/
/*15232*/       OPC_CheckChild1Integer, 113|128,28/*3697*/, 
/*15235*/       OPC_RecordChild2, // #1 = $s
/*15236*/       OPC_RecordChild3, // #2 = $x
/*15237*/       OPC_RecordChild4, // #3 = $y
/*15238*/       OPC_RecordChild5, // #4 = $r
/*15239*/       OPC_RecordChild6, // #5 = $g
/*15240*/       OPC_EmitMergeInputChains1_0,
/*15241*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V2B64_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3697:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_2D_V2B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*15251*/     /*Scope*/ 26, /*->15278*/
/*15252*/       OPC_CheckChild1Integer, 125|128,28/*3709*/, 
/*15255*/       OPC_RecordChild2, // #1 = $s
/*15256*/       OPC_RecordChild3, // #2 = $x
/*15257*/       OPC_RecordChild4, // #3 = $y
/*15258*/       OPC_RecordChild5, // #4 = $r
/*15259*/       OPC_RecordChild6, // #5 = $g
/*15260*/       OPC_RecordChild7, // #6 = $b
/*15261*/       OPC_MoveChild, 8,
/*15263*/       OPC_RecordNode, // #7 = $a
/*15264*/       OPC_MoveParent,
/*15265*/       OPC_EmitMergeInputChains1_0,
/*15266*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B8_ZERO), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3709:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15278*/     /*Scope*/ 26, /*->15305*/
/*15279*/       OPC_CheckChild1Integer, 119|128,28/*3703*/, 
/*15282*/       OPC_RecordChild2, // #1 = $s
/*15283*/       OPC_RecordChild3, // #2 = $x
/*15284*/       OPC_RecordChild4, // #3 = $y
/*15285*/       OPC_RecordChild5, // #4 = $r
/*15286*/       OPC_RecordChild6, // #5 = $g
/*15287*/       OPC_RecordChild7, // #6 = $b
/*15288*/       OPC_MoveChild, 8,
/*15290*/       OPC_RecordNode, // #7 = $a
/*15291*/       OPC_MoveParent,
/*15292*/       OPC_EmitMergeInputChains1_0,
/*15293*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B16_ZERO), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3703:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15305*/     /*Scope*/ 26, /*->15332*/
/*15306*/       OPC_CheckChild1Integer, 122|128,28/*3706*/, 
/*15309*/       OPC_RecordChild2, // #1 = $s
/*15310*/       OPC_RecordChild3, // #2 = $x
/*15311*/       OPC_RecordChild4, // #3 = $y
/*15312*/       OPC_RecordChild5, // #4 = $r
/*15313*/       OPC_RecordChild6, // #5 = $g
/*15314*/       OPC_RecordChild7, // #6 = $b
/*15315*/       OPC_MoveChild, 8,
/*15317*/       OPC_RecordNode, // #7 = $a
/*15318*/       OPC_MoveParent,
/*15319*/       OPC_EmitMergeInputChains1_0,
/*15320*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_V4B32_ZERO), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3706:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_2D_V4B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*15332*/     /*Scope*/ 19, /*->15352*/
/*15333*/       OPC_CheckChild1Integer, 71|128,28/*3655*/, 
/*15336*/       OPC_RecordChild2, // #1 = $s
/*15337*/       OPC_RecordChild3, // #2 = $l
/*15338*/       OPC_RecordChild4, // #3 = $x
/*15339*/       OPC_RecordChild5, // #4 = $y
/*15340*/       OPC_RecordChild6, // #5 = $r
/*15341*/       OPC_EmitMergeInputChains1_0,
/*15342*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B8_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3655:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*15352*/     /*Scope*/ 19, /*->15372*/
/*15353*/       OPC_CheckChild1Integer, 62|128,28/*3646*/, 
/*15356*/       OPC_RecordChild2, // #1 = $s
/*15357*/       OPC_RecordChild3, // #2 = $l
/*15358*/       OPC_RecordChild4, // #3 = $x
/*15359*/       OPC_RecordChild5, // #4 = $y
/*15360*/       OPC_RecordChild6, // #5 = $r
/*15361*/       OPC_EmitMergeInputChains1_0,
/*15362*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B16_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3646:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*15372*/     /*Scope*/ 19, /*->15392*/
/*15373*/       OPC_CheckChild1Integer, 65|128,28/*3649*/, 
/*15376*/       OPC_RecordChild2, // #1 = $s
/*15377*/       OPC_RecordChild3, // #2 = $l
/*15378*/       OPC_RecordChild4, // #3 = $x
/*15379*/       OPC_RecordChild5, // #4 = $y
/*15380*/       OPC_RecordChild6, // #5 = $r
/*15381*/       OPC_EmitMergeInputChains1_0,
/*15382*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B32_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3649:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*15392*/     /*Scope*/ 19, /*->15412*/
/*15393*/       OPC_CheckChild1Integer, 68|128,28/*3652*/, 
/*15396*/       OPC_RecordChild2, // #1 = $s
/*15397*/       OPC_RecordChild3, // #2 = $l
/*15398*/       OPC_RecordChild4, // #3 = $x
/*15399*/       OPC_RecordChild5, // #4 = $y
/*15400*/       OPC_RecordChild6, // #5 = $r
/*15401*/       OPC_EmitMergeInputChains1_0,
/*15402*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_B64_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3652:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r)
/*15412*/     /*Scope*/ 21, /*->15434*/
/*15413*/       OPC_CheckChild1Integer, 83|128,28/*3667*/, 
/*15416*/       OPC_RecordChild2, // #1 = $s
/*15417*/       OPC_RecordChild3, // #2 = $l
/*15418*/       OPC_RecordChild4, // #3 = $x
/*15419*/       OPC_RecordChild5, // #4 = $y
/*15420*/       OPC_RecordChild6, // #5 = $r
/*15421*/       OPC_RecordChild7, // #6 = $g
/*15422*/       OPC_EmitMergeInputChains1_0,
/*15423*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B8_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3667:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15434*/     /*Scope*/ 21, /*->15456*/
/*15435*/       OPC_CheckChild1Integer, 74|128,28/*3658*/, 
/*15438*/       OPC_RecordChild2, // #1 = $s
/*15439*/       OPC_RecordChild3, // #2 = $l
/*15440*/       OPC_RecordChild4, // #3 = $x
/*15441*/       OPC_RecordChild5, // #4 = $y
/*15442*/       OPC_RecordChild6, // #5 = $r
/*15443*/       OPC_RecordChild7, // #6 = $g
/*15444*/       OPC_EmitMergeInputChains1_0,
/*15445*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B16_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3658:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15456*/     /*Scope*/ 21, /*->15478*/
/*15457*/       OPC_CheckChild1Integer, 77|128,28/*3661*/, 
/*15460*/       OPC_RecordChild2, // #1 = $s
/*15461*/       OPC_RecordChild3, // #2 = $l
/*15462*/       OPC_RecordChild4, // #3 = $x
/*15463*/       OPC_RecordChild5, // #4 = $y
/*15464*/       OPC_RecordChild6, // #5 = $r
/*15465*/       OPC_RecordChild7, // #6 = $g
/*15466*/       OPC_EmitMergeInputChains1_0,
/*15467*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B32_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3661:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*15478*/     /*Scope*/ 21, /*->15500*/
/*15479*/       OPC_CheckChild1Integer, 80|128,28/*3664*/, 
/*15482*/       OPC_RecordChild2, // #1 = $s
/*15483*/       OPC_RecordChild3, // #2 = $l
/*15484*/       OPC_RecordChild4, // #3 = $x
/*15485*/       OPC_RecordChild5, // #4 = $y
/*15486*/       OPC_RecordChild6, // #5 = $r
/*15487*/       OPC_RecordChild7, // #6 = $g
/*15488*/       OPC_EmitMergeInputChains1_0,
/*15489*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V2B64_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3664:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V2B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*15500*/     /*Scope*/ 31, /*->15532*/
/*15501*/       OPC_CheckChild1Integer, 92|128,28/*3676*/, 
/*15504*/       OPC_RecordChild2, // #1 = $s
/*15505*/       OPC_RecordChild3, // #2 = $l
/*15506*/       OPC_RecordChild4, // #3 = $x
/*15507*/       OPC_RecordChild5, // #4 = $y
/*15508*/       OPC_RecordChild6, // #5 = $r
/*15509*/       OPC_RecordChild7, // #6 = $g
/*15510*/       OPC_MoveChild, 8,
/*15512*/       OPC_RecordNode, // #7 = $b
/*15513*/       OPC_MoveParent,
/*15514*/       OPC_MoveChild, 9,
/*15516*/       OPC_RecordNode, // #8 = $a
/*15517*/       OPC_MoveParent,
/*15518*/       OPC_EmitMergeInputChains1_0,
/*15519*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B8_ZERO), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3676:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15532*/     /*Scope*/ 31, /*->15564*/
/*15533*/       OPC_CheckChild1Integer, 86|128,28/*3670*/, 
/*15536*/       OPC_RecordChild2, // #1 = $s
/*15537*/       OPC_RecordChild3, // #2 = $l
/*15538*/       OPC_RecordChild4, // #3 = $x
/*15539*/       OPC_RecordChild5, // #4 = $y
/*15540*/       OPC_RecordChild6, // #5 = $r
/*15541*/       OPC_RecordChild7, // #6 = $g
/*15542*/       OPC_MoveChild, 8,
/*15544*/       OPC_RecordNode, // #7 = $b
/*15545*/       OPC_MoveParent,
/*15546*/       OPC_MoveChild, 9,
/*15548*/       OPC_RecordNode, // #8 = $a
/*15549*/       OPC_MoveParent,
/*15550*/       OPC_EmitMergeInputChains1_0,
/*15551*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B16_ZERO), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3670:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15564*/     /*Scope*/ 31, /*->15596*/
/*15565*/       OPC_CheckChild1Integer, 89|128,28/*3673*/, 
/*15568*/       OPC_RecordChild2, // #1 = $s
/*15569*/       OPC_RecordChild3, // #2 = $l
/*15570*/       OPC_RecordChild4, // #3 = $x
/*15571*/       OPC_RecordChild5, // #4 = $y
/*15572*/       OPC_RecordChild6, // #5 = $r
/*15573*/       OPC_RecordChild7, // #6 = $g
/*15574*/       OPC_MoveChild, 8,
/*15576*/       OPC_RecordNode, // #7 = $b
/*15577*/       OPC_MoveParent,
/*15578*/       OPC_MoveChild, 9,
/*15580*/       OPC_RecordNode, // #8 = $a
/*15581*/       OPC_MoveParent,
/*15582*/       OPC_EmitMergeInputChains1_0,
/*15583*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_2D_ARRAY_V4B32_ZERO), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3673:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_2D_ARRAY_V4B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*15596*/     /*Scope*/ 19, /*->15616*/
/*15597*/       OPC_CheckChild1Integer, 9|128,29/*3721*/, 
/*15600*/       OPC_RecordChild2, // #1 = $s
/*15601*/       OPC_RecordChild3, // #2 = $x
/*15602*/       OPC_RecordChild4, // #3 = $y
/*15603*/       OPC_RecordChild5, // #4 = $z
/*15604*/       OPC_RecordChild6, // #5 = $r
/*15605*/       OPC_EmitMergeInputChains1_0,
/*15606*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B8_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3721:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*15616*/     /*Scope*/ 19, /*->15636*/
/*15617*/       OPC_CheckChild1Integer, 0|128,29/*3712*/, 
/*15620*/       OPC_RecordChild2, // #1 = $s
/*15621*/       OPC_RecordChild3, // #2 = $x
/*15622*/       OPC_RecordChild4, // #3 = $y
/*15623*/       OPC_RecordChild5, // #4 = $z
/*15624*/       OPC_RecordChild6, // #5 = $r
/*15625*/       OPC_EmitMergeInputChains1_0,
/*15626*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B16_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3712:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*15636*/     /*Scope*/ 19, /*->15656*/
/*15637*/       OPC_CheckChild1Integer, 3|128,29/*3715*/, 
/*15640*/       OPC_RecordChild2, // #1 = $s
/*15641*/       OPC_RecordChild3, // #2 = $x
/*15642*/       OPC_RecordChild4, // #3 = $y
/*15643*/       OPC_RecordChild5, // #4 = $z
/*15644*/       OPC_RecordChild6, // #5 = $r
/*15645*/       OPC_EmitMergeInputChains1_0,
/*15646*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B32_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3715:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r)
/*15656*/     /*Scope*/ 19, /*->15676*/
/*15657*/       OPC_CheckChild1Integer, 6|128,29/*3718*/, 
/*15660*/       OPC_RecordChild2, // #1 = $s
/*15661*/       OPC_RecordChild3, // #2 = $x
/*15662*/       OPC_RecordChild4, // #3 = $y
/*15663*/       OPC_RecordChild5, // #4 = $z
/*15664*/       OPC_RecordChild6, // #5 = $r
/*15665*/       OPC_EmitMergeInputChains1_0,
/*15666*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_B64_ZERO), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3718:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r) - Complexity = 8
                // Dst: (SUST_B_3D_B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r)
/*15676*/     /*Scope*/ 21, /*->15698*/
/*15677*/       OPC_CheckChild1Integer, 21|128,29/*3733*/, 
/*15680*/       OPC_RecordChild2, // #1 = $s
/*15681*/       OPC_RecordChild3, // #2 = $x
/*15682*/       OPC_RecordChild4, // #3 = $y
/*15683*/       OPC_RecordChild5, // #4 = $z
/*15684*/       OPC_RecordChild6, // #5 = $r
/*15685*/       OPC_RecordChild7, // #6 = $g
/*15686*/       OPC_EmitMergeInputChains1_0,
/*15687*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B8_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3733:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15698*/     /*Scope*/ 21, /*->15720*/
/*15699*/       OPC_CheckChild1Integer, 12|128,29/*3724*/, 
/*15702*/       OPC_RecordChild2, // #1 = $s
/*15703*/       OPC_RecordChild3, // #2 = $x
/*15704*/       OPC_RecordChild4, // #3 = $y
/*15705*/       OPC_RecordChild5, // #4 = $z
/*15706*/       OPC_RecordChild6, // #5 = $r
/*15707*/       OPC_RecordChild7, // #6 = $g
/*15708*/       OPC_EmitMergeInputChains1_0,
/*15709*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B16_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3724:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15720*/     /*Scope*/ 21, /*->15742*/
/*15721*/       OPC_CheckChild1Integer, 15|128,29/*3727*/, 
/*15724*/       OPC_RecordChild2, // #1 = $s
/*15725*/       OPC_RecordChild3, // #2 = $x
/*15726*/       OPC_RecordChild4, // #3 = $y
/*15727*/       OPC_RecordChild5, // #4 = $z
/*15728*/       OPC_RecordChild6, // #5 = $r
/*15729*/       OPC_RecordChild7, // #6 = $g
/*15730*/       OPC_EmitMergeInputChains1_0,
/*15731*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B32_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3727:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*15742*/     /*Scope*/ 21, /*->15764*/
/*15743*/       OPC_CheckChild1Integer, 18|128,29/*3730*/, 
/*15746*/       OPC_RecordChild2, // #1 = $s
/*15747*/       OPC_RecordChild3, // #2 = $x
/*15748*/       OPC_RecordChild4, // #3 = $y
/*15749*/       OPC_RecordChild5, // #4 = $z
/*15750*/       OPC_RecordChild6, // #5 = $r
/*15751*/       OPC_RecordChild7, // #6 = $g
/*15752*/       OPC_EmitMergeInputChains1_0,
/*15753*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V2B64_ZERO), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3730:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r, Int64Regs:i64:$g) - Complexity = 8
                // Dst: (SUST_B_3D_V2B64_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int64Regs:i64:$r, Int64Regs:i64:$g)
/*15764*/     /*Scope*/ 31, /*->15796*/
/*15765*/       OPC_CheckChild1Integer, 30|128,29/*3742*/, 
/*15768*/       OPC_RecordChild2, // #1 = $s
/*15769*/       OPC_RecordChild3, // #2 = $x
/*15770*/       OPC_RecordChild4, // #3 = $y
/*15771*/       OPC_RecordChild5, // #4 = $z
/*15772*/       OPC_RecordChild6, // #5 = $r
/*15773*/       OPC_RecordChild7, // #6 = $g
/*15774*/       OPC_MoveChild, 8,
/*15776*/       OPC_RecordNode, // #7 = $b
/*15777*/       OPC_MoveParent,
/*15778*/       OPC_MoveChild, 9,
/*15780*/       OPC_RecordNode, // #8 = $a
/*15781*/       OPC_MoveParent,
/*15782*/       OPC_EmitMergeInputChains1_0,
/*15783*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B8_ZERO), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3742:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B8_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15796*/     /*Scope*/ 31, /*->15828*/
/*15797*/       OPC_CheckChild1Integer, 24|128,29/*3736*/, 
/*15800*/       OPC_RecordChild2, // #1 = $s
/*15801*/       OPC_RecordChild3, // #2 = $x
/*15802*/       OPC_RecordChild4, // #3 = $y
/*15803*/       OPC_RecordChild5, // #4 = $z
/*15804*/       OPC_RecordChild6, // #5 = $r
/*15805*/       OPC_RecordChild7, // #6 = $g
/*15806*/       OPC_MoveChild, 8,
/*15808*/       OPC_RecordNode, // #7 = $b
/*15809*/       OPC_MoveParent,
/*15810*/       OPC_MoveChild, 9,
/*15812*/       OPC_RecordNode, // #8 = $a
/*15813*/       OPC_MoveParent,
/*15814*/       OPC_EmitMergeInputChains1_0,
/*15815*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B16_ZERO), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3736:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B16_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15828*/     /*Scope*/ 31, /*->15860*/
/*15829*/       OPC_CheckChild1Integer, 27|128,29/*3739*/, 
/*15832*/       OPC_RecordChild2, // #1 = $s
/*15833*/       OPC_RecordChild3, // #2 = $x
/*15834*/       OPC_RecordChild4, // #3 = $y
/*15835*/       OPC_RecordChild5, // #4 = $z
/*15836*/       OPC_RecordChild6, // #5 = $r
/*15837*/       OPC_RecordChild7, // #6 = $g
/*15838*/       OPC_MoveChild, 8,
/*15840*/       OPC_RecordNode, // #7 = $b
/*15841*/       OPC_MoveParent,
/*15842*/       OPC_MoveChild, 9,
/*15844*/       OPC_RecordNode, // #8 = $a
/*15845*/       OPC_MoveParent,
/*15846*/       OPC_EmitMergeInputChains1_0,
/*15847*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_B_3D_V4B32_ZERO), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3739:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_B_3D_V4B32_ZERO Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*15860*/     /*Scope*/ 15, /*->15876*/
/*15861*/       OPC_CheckChild1Integer, 42|128,29/*3754*/, 
/*15864*/       OPC_RecordChild2, // #1 = $s
/*15865*/       OPC_RecordChild3, // #2 = $x
/*15866*/       OPC_RecordChild4, // #3 = $r
/*15867*/       OPC_EmitMergeInputChains1_0,
/*15868*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_B8_TRAP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3754:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_1D_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*15876*/     /*Scope*/ 15, /*->15892*/
/*15877*/       OPC_CheckChild1Integer, 40|128,29/*3752*/, 
/*15880*/       OPC_RecordChild2, // #1 = $s
/*15881*/       OPC_RecordChild3, // #2 = $x
/*15882*/       OPC_RecordChild4, // #3 = $r
/*15883*/       OPC_EmitMergeInputChains1_0,
/*15884*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_B16_TRAP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3752:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_1D_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*15892*/     /*Scope*/ 15, /*->15908*/
/*15893*/       OPC_CheckChild1Integer, 41|128,29/*3753*/, 
/*15896*/       OPC_RecordChild2, // #1 = $s
/*15897*/       OPC_RecordChild3, // #2 = $x
/*15898*/       OPC_RecordChild4, // #3 = $r
/*15899*/       OPC_EmitMergeInputChains1_0,
/*15900*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_B32_TRAP), 0|OPFL_Chain,
                    3/*#Ops*/, 1, 2, 3, 
                // Src: (intrinsic_void 3753:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_P_1D_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*15908*/     /*Scope*/ 17, /*->15926*/
/*15909*/       OPC_CheckChild1Integer, 45|128,29/*3757*/, 
/*15912*/       OPC_RecordChild2, // #1 = $s
/*15913*/       OPC_RecordChild3, // #2 = $x
/*15914*/       OPC_RecordChild4, // #3 = $r
/*15915*/       OPC_RecordChild5, // #4 = $g
/*15916*/       OPC_EmitMergeInputChains1_0,
/*15917*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_V2B8_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3757:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_1D_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15926*/     /*Scope*/ 17, /*->15944*/
/*15927*/       OPC_CheckChild1Integer, 43|128,29/*3755*/, 
/*15930*/       OPC_RecordChild2, // #1 = $s
/*15931*/       OPC_RecordChild3, // #2 = $x
/*15932*/       OPC_RecordChild4, // #3 = $r
/*15933*/       OPC_RecordChild5, // #4 = $g
/*15934*/       OPC_EmitMergeInputChains1_0,
/*15935*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_V2B16_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3755:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_1D_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*15944*/     /*Scope*/ 17, /*->15962*/
/*15945*/       OPC_CheckChild1Integer, 44|128,29/*3756*/, 
/*15948*/       OPC_RecordChild2, // #1 = $s
/*15949*/       OPC_RecordChild3, // #2 = $x
/*15950*/       OPC_RecordChild4, // #3 = $r
/*15951*/       OPC_RecordChild5, // #4 = $g
/*15952*/       OPC_EmitMergeInputChains1_0,
/*15953*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_V2B32_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3756:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_P_1D_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*15962*/     /*Scope*/ 21, /*->15984*/
/*15963*/       OPC_CheckChild1Integer, 48|128,29/*3760*/, 
/*15966*/       OPC_RecordChild2, // #1 = $s
/*15967*/       OPC_RecordChild3, // #2 = $x
/*15968*/       OPC_RecordChild4, // #3 = $r
/*15969*/       OPC_RecordChild5, // #4 = $g
/*15970*/       OPC_RecordChild6, // #5 = $b
/*15971*/       OPC_RecordChild7, // #6 = $a
/*15972*/       OPC_EmitMergeInputChains1_0,
/*15973*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_V4B8_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3760:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_1D_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*15984*/     /*Scope*/ 21, /*->16006*/
/*15985*/       OPC_CheckChild1Integer, 46|128,29/*3758*/, 
/*15988*/       OPC_RecordChild2, // #1 = $s
/*15989*/       OPC_RecordChild3, // #2 = $x
/*15990*/       OPC_RecordChild4, // #3 = $r
/*15991*/       OPC_RecordChild5, // #4 = $g
/*15992*/       OPC_RecordChild6, // #5 = $b
/*15993*/       OPC_RecordChild7, // #6 = $a
/*15994*/       OPC_EmitMergeInputChains1_0,
/*15995*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_V4B16_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3758:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_1D_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16006*/     /*Scope*/ 21, /*->16028*/
/*16007*/       OPC_CheckChild1Integer, 47|128,29/*3759*/, 
/*16010*/       OPC_RecordChild2, // #1 = $s
/*16011*/       OPC_RecordChild3, // #2 = $x
/*16012*/       OPC_RecordChild4, // #3 = $r
/*16013*/       OPC_RecordChild5, // #4 = $g
/*16014*/       OPC_RecordChild6, // #5 = $b
/*16015*/       OPC_RecordChild7, // #6 = $a
/*16016*/       OPC_EmitMergeInputChains1_0,
/*16017*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_V4B32_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3759:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_P_1D_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*16028*/     /*Scope*/ 17, /*->16046*/
/*16029*/       OPC_CheckChild1Integer, 33|128,29/*3745*/, 
/*16032*/       OPC_RecordChild2, // #1 = $s
/*16033*/       OPC_RecordChild3, // #2 = $l
/*16034*/       OPC_RecordChild4, // #3 = $x
/*16035*/       OPC_RecordChild5, // #4 = $r
/*16036*/       OPC_EmitMergeInputChains1_0,
/*16037*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_B8_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3745:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*16046*/     /*Scope*/ 17, /*->16064*/
/*16047*/       OPC_CheckChild1Integer, 31|128,29/*3743*/, 
/*16050*/       OPC_RecordChild2, // #1 = $s
/*16051*/       OPC_RecordChild3, // #2 = $l
/*16052*/       OPC_RecordChild4, // #3 = $x
/*16053*/       OPC_RecordChild5, // #4 = $r
/*16054*/       OPC_EmitMergeInputChains1_0,
/*16055*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_B16_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3743:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r)
/*16064*/     /*Scope*/ 17, /*->16082*/
/*16065*/       OPC_CheckChild1Integer, 32|128,29/*3744*/, 
/*16068*/       OPC_RecordChild2, // #1 = $s
/*16069*/       OPC_RecordChild3, // #2 = $l
/*16070*/       OPC_RecordChild4, // #3 = $x
/*16071*/       OPC_RecordChild5, // #4 = $r
/*16072*/       OPC_EmitMergeInputChains1_0,
/*16073*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_B32_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3744:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r)
/*16082*/     /*Scope*/ 19, /*->16102*/
/*16083*/       OPC_CheckChild1Integer, 36|128,29/*3748*/, 
/*16086*/       OPC_RecordChild2, // #1 = $s
/*16087*/       OPC_RecordChild3, // #2 = $l
/*16088*/       OPC_RecordChild4, // #3 = $x
/*16089*/       OPC_RecordChild5, // #4 = $r
/*16090*/       OPC_RecordChild6, // #5 = $g
/*16091*/       OPC_EmitMergeInputChains1_0,
/*16092*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_V2B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3748:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16102*/     /*Scope*/ 19, /*->16122*/
/*16103*/       OPC_CheckChild1Integer, 34|128,29/*3746*/, 
/*16106*/       OPC_RecordChild2, // #1 = $s
/*16107*/       OPC_RecordChild3, // #2 = $l
/*16108*/       OPC_RecordChild4, // #3 = $x
/*16109*/       OPC_RecordChild5, // #4 = $r
/*16110*/       OPC_RecordChild6, // #5 = $g
/*16111*/       OPC_EmitMergeInputChains1_0,
/*16112*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_V2B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3746:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16122*/     /*Scope*/ 19, /*->16142*/
/*16123*/       OPC_CheckChild1Integer, 35|128,29/*3747*/, 
/*16126*/       OPC_RecordChild2, // #1 = $s
/*16127*/       OPC_RecordChild3, // #2 = $l
/*16128*/       OPC_RecordChild4, // #3 = $x
/*16129*/       OPC_RecordChild5, // #4 = $r
/*16130*/       OPC_RecordChild6, // #5 = $g
/*16131*/       OPC_EmitMergeInputChains1_0,
/*16132*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_V2B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3747:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*16142*/     /*Scope*/ 26, /*->16169*/
/*16143*/       OPC_CheckChild1Integer, 39|128,29/*3751*/, 
/*16146*/       OPC_RecordChild2, // #1 = $s
/*16147*/       OPC_RecordChild3, // #2 = $l
/*16148*/       OPC_RecordChild4, // #3 = $x
/*16149*/       OPC_RecordChild5, // #4 = $r
/*16150*/       OPC_RecordChild6, // #5 = $g
/*16151*/       OPC_RecordChild7, // #6 = $b
/*16152*/       OPC_MoveChild, 8,
/*16154*/       OPC_RecordNode, // #7 = $a
/*16155*/       OPC_MoveParent,
/*16156*/       OPC_EmitMergeInputChains1_0,
/*16157*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_V4B8_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3751:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16169*/     /*Scope*/ 26, /*->16196*/
/*16170*/       OPC_CheckChild1Integer, 37|128,29/*3749*/, 
/*16173*/       OPC_RecordChild2, // #1 = $s
/*16174*/       OPC_RecordChild3, // #2 = $l
/*16175*/       OPC_RecordChild4, // #3 = $x
/*16176*/       OPC_RecordChild5, // #4 = $r
/*16177*/       OPC_RecordChild6, // #5 = $g
/*16178*/       OPC_RecordChild7, // #6 = $b
/*16179*/       OPC_MoveChild, 8,
/*16181*/       OPC_RecordNode, // #7 = $a
/*16182*/       OPC_MoveParent,
/*16183*/       OPC_EmitMergeInputChains1_0,
/*16184*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_V4B16_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3749:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16196*/     /*Scope*/ 26, /*->16223*/
/*16197*/       OPC_CheckChild1Integer, 38|128,29/*3750*/, 
/*16200*/       OPC_RecordChild2, // #1 = $s
/*16201*/       OPC_RecordChild3, // #2 = $l
/*16202*/       OPC_RecordChild4, // #3 = $x
/*16203*/       OPC_RecordChild5, // #4 = $r
/*16204*/       OPC_RecordChild6, // #5 = $g
/*16205*/       OPC_RecordChild7, // #6 = $b
/*16206*/       OPC_MoveChild, 8,
/*16208*/       OPC_RecordNode, // #7 = $a
/*16209*/       OPC_MoveParent,
/*16210*/       OPC_EmitMergeInputChains1_0,
/*16211*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_1D_ARRAY_V4B32_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3750:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_P_1D_ARRAY_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*16223*/     /*Scope*/ 17, /*->16241*/
/*16224*/       OPC_CheckChild1Integer, 60|128,29/*3772*/, 
/*16227*/       OPC_RecordChild2, // #1 = $s
/*16228*/       OPC_RecordChild3, // #2 = $x
/*16229*/       OPC_RecordChild4, // #3 = $y
/*16230*/       OPC_RecordChild5, // #4 = $r
/*16231*/       OPC_EmitMergeInputChains1_0,
/*16232*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_B8_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3772:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_2D_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*16241*/     /*Scope*/ 17, /*->16259*/
/*16242*/       OPC_CheckChild1Integer, 58|128,29/*3770*/, 
/*16245*/       OPC_RecordChild2, // #1 = $s
/*16246*/       OPC_RecordChild3, // #2 = $x
/*16247*/       OPC_RecordChild4, // #3 = $y
/*16248*/       OPC_RecordChild5, // #4 = $r
/*16249*/       OPC_EmitMergeInputChains1_0,
/*16250*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_B16_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3770:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_2D_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*16259*/     /*Scope*/ 17, /*->16277*/
/*16260*/       OPC_CheckChild1Integer, 59|128,29/*3771*/, 
/*16263*/       OPC_RecordChild2, // #1 = $s
/*16264*/       OPC_RecordChild3, // #2 = $x
/*16265*/       OPC_RecordChild4, // #3 = $y
/*16266*/       OPC_RecordChild5, // #4 = $r
/*16267*/       OPC_EmitMergeInputChains1_0,
/*16268*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_B32_TRAP), 0|OPFL_Chain,
                    4/*#Ops*/, 1, 2, 3, 4, 
                // Src: (intrinsic_void 3771:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_P_2D_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*16277*/     /*Scope*/ 19, /*->16297*/
/*16278*/       OPC_CheckChild1Integer, 63|128,29/*3775*/, 
/*16281*/       OPC_RecordChild2, // #1 = $s
/*16282*/       OPC_RecordChild3, // #2 = $x
/*16283*/       OPC_RecordChild4, // #3 = $y
/*16284*/       OPC_RecordChild5, // #4 = $r
/*16285*/       OPC_RecordChild6, // #5 = $g
/*16286*/       OPC_EmitMergeInputChains1_0,
/*16287*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_V2B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3775:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_2D_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16297*/     /*Scope*/ 19, /*->16317*/
/*16298*/       OPC_CheckChild1Integer, 61|128,29/*3773*/, 
/*16301*/       OPC_RecordChild2, // #1 = $s
/*16302*/       OPC_RecordChild3, // #2 = $x
/*16303*/       OPC_RecordChild4, // #3 = $y
/*16304*/       OPC_RecordChild5, // #4 = $r
/*16305*/       OPC_RecordChild6, // #5 = $g
/*16306*/       OPC_EmitMergeInputChains1_0,
/*16307*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_V2B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3773:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_2D_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16317*/     /*Scope*/ 19, /*->16337*/
/*16318*/       OPC_CheckChild1Integer, 62|128,29/*3774*/, 
/*16321*/       OPC_RecordChild2, // #1 = $s
/*16322*/       OPC_RecordChild3, // #2 = $x
/*16323*/       OPC_RecordChild4, // #3 = $y
/*16324*/       OPC_RecordChild5, // #4 = $r
/*16325*/       OPC_RecordChild6, // #5 = $g
/*16326*/       OPC_EmitMergeInputChains1_0,
/*16327*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_V2B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3774:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_P_2D_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*16337*/     /*Scope*/ 26, /*->16364*/
/*16338*/       OPC_CheckChild1Integer, 66|128,29/*3778*/, 
/*16341*/       OPC_RecordChild2, // #1 = $s
/*16342*/       OPC_RecordChild3, // #2 = $x
/*16343*/       OPC_RecordChild4, // #3 = $y
/*16344*/       OPC_RecordChild5, // #4 = $r
/*16345*/       OPC_RecordChild6, // #5 = $g
/*16346*/       OPC_RecordChild7, // #6 = $b
/*16347*/       OPC_MoveChild, 8,
/*16349*/       OPC_RecordNode, // #7 = $a
/*16350*/       OPC_MoveParent,
/*16351*/       OPC_EmitMergeInputChains1_0,
/*16352*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_V4B8_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3778:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_2D_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16364*/     /*Scope*/ 26, /*->16391*/
/*16365*/       OPC_CheckChild1Integer, 64|128,29/*3776*/, 
/*16368*/       OPC_RecordChild2, // #1 = $s
/*16369*/       OPC_RecordChild3, // #2 = $x
/*16370*/       OPC_RecordChild4, // #3 = $y
/*16371*/       OPC_RecordChild5, // #4 = $r
/*16372*/       OPC_RecordChild6, // #5 = $g
/*16373*/       OPC_RecordChild7, // #6 = $b
/*16374*/       OPC_MoveChild, 8,
/*16376*/       OPC_RecordNode, // #7 = $a
/*16377*/       OPC_MoveParent,
/*16378*/       OPC_EmitMergeInputChains1_0,
/*16379*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_V4B16_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3776:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_2D_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16391*/     /*Scope*/ 26, /*->16418*/
/*16392*/       OPC_CheckChild1Integer, 65|128,29/*3777*/, 
/*16395*/       OPC_RecordChild2, // #1 = $s
/*16396*/       OPC_RecordChild3, // #2 = $x
/*16397*/       OPC_RecordChild4, // #3 = $y
/*16398*/       OPC_RecordChild5, // #4 = $r
/*16399*/       OPC_RecordChild6, // #5 = $g
/*16400*/       OPC_RecordChild7, // #6 = $b
/*16401*/       OPC_MoveChild, 8,
/*16403*/       OPC_RecordNode, // #7 = $a
/*16404*/       OPC_MoveParent,
/*16405*/       OPC_EmitMergeInputChains1_0,
/*16406*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_V4B32_TRAP), 0|OPFL_Chain,
                    7/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 
                // Src: (intrinsic_void 3777:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_P_2D_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*16418*/     /*Scope*/ 19, /*->16438*/
/*16419*/       OPC_CheckChild1Integer, 51|128,29/*3763*/, 
/*16422*/       OPC_RecordChild2, // #1 = $s
/*16423*/       OPC_RecordChild3, // #2 = $l
/*16424*/       OPC_RecordChild4, // #3 = $x
/*16425*/       OPC_RecordChild5, // #4 = $y
/*16426*/       OPC_RecordChild6, // #5 = $r
/*16427*/       OPC_EmitMergeInputChains1_0,
/*16428*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3763:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*16438*/     /*Scope*/ 19, /*->16458*/
/*16439*/       OPC_CheckChild1Integer, 49|128,29/*3761*/, 
/*16442*/       OPC_RecordChild2, // #1 = $s
/*16443*/       OPC_RecordChild3, // #2 = $l
/*16444*/       OPC_RecordChild4, // #3 = $x
/*16445*/       OPC_RecordChild5, // #4 = $y
/*16446*/       OPC_RecordChild6, // #5 = $r
/*16447*/       OPC_EmitMergeInputChains1_0,
/*16448*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3761:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r)
/*16458*/     /*Scope*/ 19, /*->16478*/
/*16459*/       OPC_CheckChild1Integer, 50|128,29/*3762*/, 
/*16462*/       OPC_RecordChild2, // #1 = $s
/*16463*/       OPC_RecordChild3, // #2 = $l
/*16464*/       OPC_RecordChild4, // #3 = $x
/*16465*/       OPC_RecordChild5, // #4 = $y
/*16466*/       OPC_RecordChild6, // #5 = $r
/*16467*/       OPC_EmitMergeInputChains1_0,
/*16468*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3762:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r)
/*16478*/     /*Scope*/ 21, /*->16500*/
/*16479*/       OPC_CheckChild1Integer, 54|128,29/*3766*/, 
/*16482*/       OPC_RecordChild2, // #1 = $s
/*16483*/       OPC_RecordChild3, // #2 = $l
/*16484*/       OPC_RecordChild4, // #3 = $x
/*16485*/       OPC_RecordChild5, // #4 = $y
/*16486*/       OPC_RecordChild6, // #5 = $r
/*16487*/       OPC_RecordChild7, // #6 = $g
/*16488*/       OPC_EmitMergeInputChains1_0,
/*16489*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_V2B8_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3766:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16500*/     /*Scope*/ 21, /*->16522*/
/*16501*/       OPC_CheckChild1Integer, 52|128,29/*3764*/, 
/*16504*/       OPC_RecordChild2, // #1 = $s
/*16505*/       OPC_RecordChild3, // #2 = $l
/*16506*/       OPC_RecordChild4, // #3 = $x
/*16507*/       OPC_RecordChild5, // #4 = $y
/*16508*/       OPC_RecordChild6, // #5 = $r
/*16509*/       OPC_RecordChild7, // #6 = $g
/*16510*/       OPC_EmitMergeInputChains1_0,
/*16511*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_V2B16_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3764:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16522*/     /*Scope*/ 21, /*->16544*/
/*16523*/       OPC_CheckChild1Integer, 53|128,29/*3765*/, 
/*16526*/       OPC_RecordChild2, // #1 = $s
/*16527*/       OPC_RecordChild3, // #2 = $l
/*16528*/       OPC_RecordChild4, // #3 = $x
/*16529*/       OPC_RecordChild5, // #4 = $y
/*16530*/       OPC_RecordChild6, // #5 = $r
/*16531*/       OPC_RecordChild7, // #6 = $g
/*16532*/       OPC_EmitMergeInputChains1_0,
/*16533*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_V2B32_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3765:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*16544*/     /*Scope*/ 31, /*->16576*/
/*16545*/       OPC_CheckChild1Integer, 57|128,29/*3769*/, 
/*16548*/       OPC_RecordChild2, // #1 = $s
/*16549*/       OPC_RecordChild3, // #2 = $l
/*16550*/       OPC_RecordChild4, // #3 = $x
/*16551*/       OPC_RecordChild5, // #4 = $y
/*16552*/       OPC_RecordChild6, // #5 = $r
/*16553*/       OPC_RecordChild7, // #6 = $g
/*16554*/       OPC_MoveChild, 8,
/*16556*/       OPC_RecordNode, // #7 = $b
/*16557*/       OPC_MoveParent,
/*16558*/       OPC_MoveChild, 9,
/*16560*/       OPC_RecordNode, // #8 = $a
/*16561*/       OPC_MoveParent,
/*16562*/       OPC_EmitMergeInputChains1_0,
/*16563*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_V4B8_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3769:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16576*/     /*Scope*/ 31, /*->16608*/
/*16577*/       OPC_CheckChild1Integer, 55|128,29/*3767*/, 
/*16580*/       OPC_RecordChild2, // #1 = $s
/*16581*/       OPC_RecordChild3, // #2 = $l
/*16582*/       OPC_RecordChild4, // #3 = $x
/*16583*/       OPC_RecordChild5, // #4 = $y
/*16584*/       OPC_RecordChild6, // #5 = $r
/*16585*/       OPC_RecordChild7, // #6 = $g
/*16586*/       OPC_MoveChild, 8,
/*16588*/       OPC_RecordNode, // #7 = $b
/*16589*/       OPC_MoveParent,
/*16590*/       OPC_MoveChild, 9,
/*16592*/       OPC_RecordNode, // #8 = $a
/*16593*/       OPC_MoveParent,
/*16594*/       OPC_EmitMergeInputChains1_0,
/*16595*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_V4B16_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3767:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16608*/     /*Scope*/ 31, /*->16640*/
/*16609*/       OPC_CheckChild1Integer, 56|128,29/*3768*/, 
/*16612*/       OPC_RecordChild2, // #1 = $s
/*16613*/       OPC_RecordChild3, // #2 = $l
/*16614*/       OPC_RecordChild4, // #3 = $x
/*16615*/       OPC_RecordChild5, // #4 = $y
/*16616*/       OPC_RecordChild6, // #5 = $r
/*16617*/       OPC_RecordChild7, // #6 = $g
/*16618*/       OPC_MoveChild, 8,
/*16620*/       OPC_RecordNode, // #7 = $b
/*16621*/       OPC_MoveParent,
/*16622*/       OPC_MoveChild, 9,
/*16624*/       OPC_RecordNode, // #8 = $a
/*16625*/       OPC_MoveParent,
/*16626*/       OPC_EmitMergeInputChains1_0,
/*16627*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_2D_ARRAY_V4B32_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3768:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_P_2D_ARRAY_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$l, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*16640*/     /*Scope*/ 19, /*->16660*/
/*16641*/       OPC_CheckChild1Integer, 69|128,29/*3781*/, 
/*16644*/       OPC_RecordChild2, // #1 = $s
/*16645*/       OPC_RecordChild3, // #2 = $x
/*16646*/       OPC_RecordChild4, // #3 = $y
/*16647*/       OPC_RecordChild5, // #4 = $z
/*16648*/       OPC_RecordChild6, // #5 = $r
/*16649*/       OPC_EmitMergeInputChains1_0,
/*16650*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_B8_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3781:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_3D_B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*16660*/     /*Scope*/ 19, /*->16680*/
/*16661*/       OPC_CheckChild1Integer, 67|128,29/*3779*/, 
/*16664*/       OPC_RecordChild2, // #1 = $s
/*16665*/       OPC_RecordChild3, // #2 = $x
/*16666*/       OPC_RecordChild4, // #3 = $y
/*16667*/       OPC_RecordChild5, // #4 = $z
/*16668*/       OPC_RecordChild6, // #5 = $r
/*16669*/       OPC_EmitMergeInputChains1_0,
/*16670*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_B16_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3779:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r) - Complexity = 8
                // Dst: (SUST_P_3D_B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r)
/*16680*/     /*Scope*/ 19, /*->16700*/
/*16681*/       OPC_CheckChild1Integer, 68|128,29/*3780*/, 
/*16684*/       OPC_RecordChild2, // #1 = $s
/*16685*/       OPC_RecordChild3, // #2 = $x
/*16686*/       OPC_RecordChild4, // #3 = $y
/*16687*/       OPC_RecordChild5, // #4 = $z
/*16688*/       OPC_RecordChild6, // #5 = $r
/*16689*/       OPC_EmitMergeInputChains1_0,
/*16690*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_B32_TRAP), 0|OPFL_Chain,
                    5/*#Ops*/, 1, 2, 3, 4, 5, 
                // Src: (intrinsic_void 3780:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r) - Complexity = 8
                // Dst: (SUST_P_3D_B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r)
/*16700*/     /*Scope*/ 21, /*->16722*/
/*16701*/       OPC_CheckChild1Integer, 72|128,29/*3784*/, 
/*16704*/       OPC_RecordChild2, // #1 = $s
/*16705*/       OPC_RecordChild3, // #2 = $x
/*16706*/       OPC_RecordChild4, // #3 = $y
/*16707*/       OPC_RecordChild5, // #4 = $z
/*16708*/       OPC_RecordChild6, // #5 = $r
/*16709*/       OPC_RecordChild7, // #6 = $g
/*16710*/       OPC_EmitMergeInputChains1_0,
/*16711*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_V2B8_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3784:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_3D_V2B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16722*/     /*Scope*/ 21, /*->16744*/
/*16723*/       OPC_CheckChild1Integer, 70|128,29/*3782*/, 
/*16726*/       OPC_RecordChild2, // #1 = $s
/*16727*/       OPC_RecordChild3, // #2 = $x
/*16728*/       OPC_RecordChild4, // #3 = $y
/*16729*/       OPC_RecordChild5, // #4 = $z
/*16730*/       OPC_RecordChild6, // #5 = $r
/*16731*/       OPC_RecordChild7, // #6 = $g
/*16732*/       OPC_EmitMergeInputChains1_0,
/*16733*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_V2B16_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3782:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g) - Complexity = 8
                // Dst: (SUST_P_3D_V2B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g)
/*16744*/     /*Scope*/ 21, /*->16766*/
/*16745*/       OPC_CheckChild1Integer, 71|128,29/*3783*/, 
/*16748*/       OPC_RecordChild2, // #1 = $s
/*16749*/       OPC_RecordChild3, // #2 = $x
/*16750*/       OPC_RecordChild4, // #3 = $y
/*16751*/       OPC_RecordChild5, // #4 = $z
/*16752*/       OPC_RecordChild6, // #5 = $r
/*16753*/       OPC_RecordChild7, // #6 = $g
/*16754*/       OPC_EmitMergeInputChains1_0,
/*16755*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_V2B32_TRAP), 0|OPFL_Chain,
                    6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                // Src: (intrinsic_void 3783:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g) - Complexity = 8
                // Dst: (SUST_P_3D_V2B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g)
/*16766*/     /*Scope*/ 31, /*->16798*/
/*16767*/       OPC_CheckChild1Integer, 75|128,29/*3787*/, 
/*16770*/       OPC_RecordChild2, // #1 = $s
/*16771*/       OPC_RecordChild3, // #2 = $x
/*16772*/       OPC_RecordChild4, // #3 = $y
/*16773*/       OPC_RecordChild5, // #4 = $z
/*16774*/       OPC_RecordChild6, // #5 = $r
/*16775*/       OPC_RecordChild7, // #6 = $g
/*16776*/       OPC_MoveChild, 8,
/*16778*/       OPC_RecordNode, // #7 = $b
/*16779*/       OPC_MoveParent,
/*16780*/       OPC_MoveChild, 9,
/*16782*/       OPC_RecordNode, // #8 = $a
/*16783*/       OPC_MoveParent,
/*16784*/       OPC_EmitMergeInputChains1_0,
/*16785*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_V4B8_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3787:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_3D_V4B8_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16798*/     /*Scope*/ 31, /*->16830*/
/*16799*/       OPC_CheckChild1Integer, 73|128,29/*3785*/, 
/*16802*/       OPC_RecordChild2, // #1 = $s
/*16803*/       OPC_RecordChild3, // #2 = $x
/*16804*/       OPC_RecordChild4, // #3 = $y
/*16805*/       OPC_RecordChild5, // #4 = $z
/*16806*/       OPC_RecordChild6, // #5 = $r
/*16807*/       OPC_RecordChild7, // #6 = $g
/*16808*/       OPC_MoveChild, 8,
/*16810*/       OPC_RecordNode, // #7 = $b
/*16811*/       OPC_MoveParent,
/*16812*/       OPC_MoveChild, 9,
/*16814*/       OPC_RecordNode, // #8 = $a
/*16815*/       OPC_MoveParent,
/*16816*/       OPC_EmitMergeInputChains1_0,
/*16817*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_V4B16_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3785:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a) - Complexity = 8
                // Dst: (SUST_P_3D_V4B16_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int16Regs:i16:$r, Int16Regs:i16:$g, Int16Regs:i16:$b, Int16Regs:i16:$a)
/*16830*/     /*Scope*/ 31, /*->16862*/
/*16831*/       OPC_CheckChild1Integer, 74|128,29/*3786*/, 
/*16834*/       OPC_RecordChild2, // #1 = $s
/*16835*/       OPC_RecordChild3, // #2 = $x
/*16836*/       OPC_RecordChild4, // #3 = $y
/*16837*/       OPC_RecordChild5, // #4 = $z
/*16838*/       OPC_RecordChild6, // #5 = $r
/*16839*/       OPC_RecordChild7, // #6 = $g
/*16840*/       OPC_MoveChild, 8,
/*16842*/       OPC_RecordNode, // #7 = $b
/*16843*/       OPC_MoveParent,
/*16844*/       OPC_MoveChild, 9,
/*16846*/       OPC_RecordNode, // #8 = $a
/*16847*/       OPC_MoveParent,
/*16848*/       OPC_EmitMergeInputChains1_0,
/*16849*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::SUST_P_3D_V4B32_TRAP), 0|OPFL_Chain,
                    8/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 
                // Src: (intrinsic_void 3786:iPTR, Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a) - Complexity = 8
                // Dst: (SUST_P_3D_V4B32_TRAP Int64Regs:i64:$s, Int32Regs:i32:$x, Int32Regs:i32:$y, Int32Regs:i32:$z, Int32Regs:i32:$r, Int32Regs:i32:$g, Int32Regs:i32:$b, Int32Regs:i32:$a)
/*16862*/     0, /*End of Scope*/
/*16863*/   /*SwitchOpcode*/ 124|128,1/*252*/, TARGET_VAL(ISD::SHL),// ->17119
/*16867*/     OPC_Scope, 3|128,1/*131*/, /*->17001*/ // 2 children in Scope
/*16870*/       OPC_MoveChild0,
/*16871*/       OPC_SwitchOpcode /*2 cases */, 61, TARGET_VAL(ISD::SIGN_EXTEND),// ->16936
/*16875*/         OPC_RecordChild0, // #0 = $a
/*16876*/         OPC_Scope, 28, /*->16906*/ // 2 children in Scope
/*16878*/           OPC_CheckChild0Type, MVT::i32,
/*16880*/           OPC_MoveParent,
/*16881*/           OPC_RecordChild1, // #1 = $b
/*16882*/           OPC_MoveChild1,
/*16883*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*16886*/           OPC_CheckPredicate, 7, // Predicate_Int5Const
/*16888*/           OPC_CheckType, MVT::i32,
/*16890*/           OPC_MoveParent,
/*16891*/           OPC_CheckType, MVT::i64,
/*16893*/           OPC_CheckPatternPredicate, 17, // (doMulWide)
/*16895*/           OPC_EmitNodeXForm, 2, 1, // SHL2MUL32
/*16898*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDES64Imm), 0,
                        MVT::i64, 2/*#Ops*/, 0, 2, 
                    // Src: (shl:i64 (sext:i64 Int32Regs:i32:$a), (imm:i32)<<P:Predicate_Int5Const>>:$b) - Complexity = 10
                    // Dst: (MULWIDES64Imm:i64 Int32Regs:i32:$a, (SHL2MUL32:i32 node:i32:$b))
/*16906*/         /*Scope*/ 28, /*->16935*/
/*16907*/           OPC_CheckChild0Type, MVT::i16,
/*16909*/           OPC_MoveParent,
/*16910*/           OPC_RecordChild1, // #1 = $b
/*16911*/           OPC_MoveChild1,
/*16912*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*16915*/           OPC_CheckPredicate, 8, // Predicate_Int4Const
/*16917*/           OPC_CheckType, MVT::i16,
/*16919*/           OPC_MoveParent,
/*16920*/           OPC_CheckType, MVT::i32,
/*16922*/           OPC_CheckPatternPredicate, 17, // (doMulWide)
/*16924*/           OPC_EmitNodeXForm, 3, 1, // SHL2MUL16
/*16927*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDES32Imm), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (shl:i32 (sext:i32 Int16Regs:i16:$a), (imm:i16)<<P:Predicate_Int4Const>>:$b) - Complexity = 10
                    // Dst: (MULWIDES32Imm:i32 Int16Regs:i16:$a, (SHL2MUL16:i16 node:i16:$b))
/*16935*/         0, /*End of Scope*/
/*16936*/       /*SwitchOpcode*/ 61, TARGET_VAL(ISD::ZERO_EXTEND),// ->17000
/*16939*/         OPC_RecordChild0, // #0 = $a
/*16940*/         OPC_Scope, 28, /*->16970*/ // 2 children in Scope
/*16942*/           OPC_CheckChild0Type, MVT::i32,
/*16944*/           OPC_MoveParent,
/*16945*/           OPC_RecordChild1, // #1 = $b
/*16946*/           OPC_MoveChild1,
/*16947*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*16950*/           OPC_CheckPredicate, 7, // Predicate_Int5Const
/*16952*/           OPC_CheckType, MVT::i32,
/*16954*/           OPC_MoveParent,
/*16955*/           OPC_CheckType, MVT::i64,
/*16957*/           OPC_CheckPatternPredicate, 17, // (doMulWide)
/*16959*/           OPC_EmitNodeXForm, 2, 1, // SHL2MUL32
/*16962*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDEU64Imm), 0,
                        MVT::i64, 2/*#Ops*/, 0, 2, 
                    // Src: (shl:i64 (zext:i64 Int32Regs:i32:$a), (imm:i32)<<P:Predicate_Int5Const>>:$b) - Complexity = 10
                    // Dst: (MULWIDEU64Imm:i64 Int32Regs:i32:$a, (SHL2MUL32:i32 node:i32:$b))
/*16970*/         /*Scope*/ 28, /*->16999*/
/*16971*/           OPC_CheckChild0Type, MVT::i16,
/*16973*/           OPC_MoveParent,
/*16974*/           OPC_RecordChild1, // #1 = $b
/*16975*/           OPC_MoveChild1,
/*16976*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*16979*/           OPC_CheckPredicate, 8, // Predicate_Int4Const
/*16981*/           OPC_CheckType, MVT::i16,
/*16983*/           OPC_MoveParent,
/*16984*/           OPC_CheckType, MVT::i32,
/*16986*/           OPC_CheckPatternPredicate, 17, // (doMulWide)
/*16988*/           OPC_EmitNodeXForm, 3, 1, // SHL2MUL16
/*16991*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDEU32Imm), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (shl:i32 (zext:i32 Int16Regs:i16:$a), (imm:i16)<<P:Predicate_Int4Const>>:$b) - Complexity = 10
                    // Dst: (MULWIDEU32Imm:i32 Int16Regs:i16:$a, (SHL2MUL16:i16 node:i16:$b))
/*16999*/         0, /*End of Scope*/
/*17000*/       0, // EndSwitchOpcode
/*17001*/     /*Scope*/ 116, /*->17118*/
/*17002*/       OPC_RecordChild0, // #0 = $a
/*17003*/       OPC_Scope, 27, /*->17032*/ // 2 children in Scope
/*17005*/         OPC_MoveChild0,
/*17006*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17009*/         OPC_MoveParent,
/*17010*/         OPC_RecordChild1, // #1 = $b
/*17011*/         OPC_MoveChild1,
/*17012*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17015*/         OPC_CheckType, MVT::i32,
/*17017*/         OPC_MoveParent,
/*17018*/         OPC_CheckType, MVT::i32,
/*17020*/         OPC_EmitConvertToTarget, 0,
/*17022*/         OPC_EmitConvertToTarget, 1,
/*17024*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SHLi32ii), 0,
                      MVT::i32, 2/*#Ops*/, 2, 3, 
                  // Src: (shl:i32 (imm:i32):$a, (imm:i32):$b) - Complexity = 9
                  // Dst: (SHLi32ii:i32 (imm:i32):$a, (imm:i32):$b)
/*17032*/       /*Scope*/ 84, /*->17117*/
/*17033*/         OPC_RecordChild1, // #1 = $b
/*17034*/         OPC_Scope, 45, /*->17081*/ // 2 children in Scope
/*17036*/           OPC_MoveChild1,
/*17037*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17040*/           OPC_CheckType, MVT::i32,
/*17042*/           OPC_MoveParent,
/*17043*/           OPC_SwitchType /*3 cases */, 10, MVT::i64,// ->17056
/*17046*/             OPC_EmitConvertToTarget, 1,
/*17048*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SHLi64ri), 0,
                          MVT::i64, 2/*#Ops*/, 0, 2, 
                      // Src: (shl:i64 Int64Regs:i64:$a, (imm:i32):$b) - Complexity = 6
                      // Dst: (SHLi64ri:i64 Int64Regs:i64:$a, (imm:i32):$b)
/*17056*/           /*SwitchType*/ 10, MVT::i32,// ->17068
/*17058*/             OPC_EmitConvertToTarget, 1,
/*17060*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SHLi32ri), 0,
                          MVT::i32, 2/*#Ops*/, 0, 2, 
                      // Src: (shl:i32 Int32Regs:i32:$a, (imm:i32):$b) - Complexity = 6
                      // Dst: (SHLi32ri:i32 Int32Regs:i32:$a, (imm:i32):$b)
/*17068*/           /*SwitchType*/ 10, MVT::i16,// ->17080
/*17070*/             OPC_EmitConvertToTarget, 1,
/*17072*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SHLi16ri), 0,
                          MVT::i16, 2/*#Ops*/, 0, 2, 
                      // Src: (shl:i16 Int16Regs:i16:$a, (imm:i32):$b) - Complexity = 6
                      // Dst: (SHLi16ri:i16 Int16Regs:i16:$a, (imm:i32):$b)
/*17080*/           0, // EndSwitchType
/*17081*/         /*Scope*/ 34, /*->17116*/
/*17082*/           OPC_CheckChild1Type, MVT::i32,
/*17084*/           OPC_SwitchType /*3 cases */, 8, MVT::i64,// ->17095
/*17087*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SHLi64rr), 0,
                          MVT::i64, 2/*#Ops*/, 0, 1, 
                      // Src: (shl:i64 Int64Regs:i64:$a, Int32Regs:i32:$b) - Complexity = 3
                      // Dst: (SHLi64rr:i64 Int64Regs:i64:$a, Int32Regs:i32:$b)
/*17095*/           /*SwitchType*/ 8, MVT::i32,// ->17105
/*17097*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SHLi32rr), 0,
                          MVT::i32, 2/*#Ops*/, 0, 1, 
                      // Src: (shl:i32 Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                      // Dst: (SHLi32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*17105*/           /*SwitchType*/ 8, MVT::i16,// ->17115
/*17107*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SHLi16rr), 0,
                          MVT::i16, 2/*#Ops*/, 0, 1, 
                      // Src: (shl:i16 Int16Regs:i16:$a, Int32Regs:i32:$b) - Complexity = 3
                      // Dst: (SHLi16rr:i16 Int16Regs:i16:$a, Int32Regs:i32:$b)
/*17115*/           0, // EndSwitchType
/*17116*/         0, /*End of Scope*/
/*17117*/       0, /*End of Scope*/
/*17118*/     0, /*End of Scope*/
/*17119*/   /*SwitchOpcode*/ 45|128,2/*301*/, TARGET_VAL(ISD::MUL),// ->17424
/*17123*/     OPC_Scope, 87|128,1/*215*/, /*->17341*/ // 2 children in Scope
/*17126*/       OPC_MoveChild0,
/*17127*/       OPC_SwitchOpcode /*2 cases */, 103, TARGET_VAL(ISD::SIGN_EXTEND),// ->17234
/*17131*/         OPC_RecordChild0, // #0 = $a
/*17132*/         OPC_Scope, 49, /*->17183*/ // 2 children in Scope
/*17134*/           OPC_CheckChild0Type, MVT::i32,
/*17136*/           OPC_MoveParent,
/*17137*/           OPC_Scope, 22, /*->17161*/ // 2 children in Scope
/*17139*/             OPC_RecordChild1, // #1 = $b
/*17140*/             OPC_MoveChild1,
/*17141*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17144*/             OPC_CheckPredicate, 9, // Predicate_SInt32Const
/*17146*/             OPC_MoveParent,
/*17147*/             OPC_CheckType, MVT::i64,
/*17149*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17151*/             OPC_EmitConvertToTarget, 1,
/*17153*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDES64Imm64), 0,
                          MVT::i64, 2/*#Ops*/, 0, 2, 
                      // Src: (mul:i64 (sext:i64 Int32Regs:i32:$a), (imm:i64)<<P:Predicate_SInt32Const>>:$b) - Complexity = 10
                      // Dst: (MULWIDES64Imm64:i64 Int32Regs:i32:$a, (imm:i64)<<P:Predicate_SInt32Const>>:$b)
/*17161*/           /*Scope*/ 20, /*->17182*/
/*17162*/             OPC_MoveChild1,
/*17163*/             OPC_CheckOpcode, TARGET_VAL(ISD::SIGN_EXTEND),
/*17166*/             OPC_RecordChild0, // #1 = $b
/*17167*/             OPC_CheckChild0Type, MVT::i32,
/*17169*/             OPC_MoveParent,
/*17170*/             OPC_CheckType, MVT::i64,
/*17172*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17174*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDES64), 0,
                          MVT::i64, 2/*#Ops*/, 0, 1, 
                      // Src: (mul:i64 (sext:i64 Int32Regs:i32:$a), (sext:i64 Int32Regs:i32:$b)) - Complexity = 9
                      // Dst: (MULWIDES64:i64 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*17182*/           0, /*End of Scope*/
/*17183*/         /*Scope*/ 49, /*->17233*/
/*17184*/           OPC_CheckChild0Type, MVT::i16,
/*17186*/           OPC_MoveParent,
/*17187*/           OPC_Scope, 22, /*->17211*/ // 2 children in Scope
/*17189*/             OPC_RecordChild1, // #1 = $b
/*17190*/             OPC_MoveChild1,
/*17191*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17194*/             OPC_CheckPredicate, 10, // Predicate_SInt16Const
/*17196*/             OPC_MoveParent,
/*17197*/             OPC_CheckType, MVT::i32,
/*17199*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17201*/             OPC_EmitConvertToTarget, 1,
/*17203*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDES32Imm32), 0,
                          MVT::i32, 2/*#Ops*/, 0, 2, 
                      // Src: (mul:i32 (sext:i32 Int16Regs:i16:$a), (imm:i32)<<P:Predicate_SInt16Const>>:$b) - Complexity = 10
                      // Dst: (MULWIDES32Imm32:i32 Int16Regs:i16:$a, (imm:i32)<<P:Predicate_SInt16Const>>:$b)
/*17211*/           /*Scope*/ 20, /*->17232*/
/*17212*/             OPC_MoveChild1,
/*17213*/             OPC_CheckOpcode, TARGET_VAL(ISD::SIGN_EXTEND),
/*17216*/             OPC_RecordChild0, // #1 = $b
/*17217*/             OPC_CheckChild0Type, MVT::i16,
/*17219*/             OPC_MoveParent,
/*17220*/             OPC_CheckType, MVT::i32,
/*17222*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17224*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDES32), 0,
                          MVT::i32, 2/*#Ops*/, 0, 1, 
                      // Src: (mul:i32 (sext:i32 Int16Regs:i16:$a), (sext:i32 Int16Regs:i16:$b)) - Complexity = 9
                      // Dst: (MULWIDES32:i32 Int16Regs:i16:$a, Int16Regs:i16:$b)
/*17232*/           0, /*End of Scope*/
/*17233*/         0, /*End of Scope*/
/*17234*/       /*SwitchOpcode*/ 103, TARGET_VAL(ISD::ZERO_EXTEND),// ->17340
/*17237*/         OPC_RecordChild0, // #0 = $a
/*17238*/         OPC_Scope, 49, /*->17289*/ // 2 children in Scope
/*17240*/           OPC_CheckChild0Type, MVT::i32,
/*17242*/           OPC_MoveParent,
/*17243*/           OPC_Scope, 22, /*->17267*/ // 2 children in Scope
/*17245*/             OPC_RecordChild1, // #1 = $b
/*17246*/             OPC_MoveChild1,
/*17247*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17250*/             OPC_CheckPredicate, 11, // Predicate_UInt32Const
/*17252*/             OPC_MoveParent,
/*17253*/             OPC_CheckType, MVT::i64,
/*17255*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17257*/             OPC_EmitConvertToTarget, 1,
/*17259*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDEU64Imm64), 0,
                          MVT::i64, 2/*#Ops*/, 0, 2, 
                      // Src: (mul:i64 (zext:i64 Int32Regs:i32:$a), (imm:i64)<<P:Predicate_UInt32Const>>:$b) - Complexity = 10
                      // Dst: (MULWIDEU64Imm64:i64 Int32Regs:i32:$a, (imm:i64)<<P:Predicate_UInt32Const>>:$b)
/*17267*/           /*Scope*/ 20, /*->17288*/
/*17268*/             OPC_MoveChild1,
/*17269*/             OPC_CheckOpcode, TARGET_VAL(ISD::ZERO_EXTEND),
/*17272*/             OPC_RecordChild0, // #1 = $b
/*17273*/             OPC_CheckChild0Type, MVT::i32,
/*17275*/             OPC_MoveParent,
/*17276*/             OPC_CheckType, MVT::i64,
/*17278*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17280*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDEU64), 0,
                          MVT::i64, 2/*#Ops*/, 0, 1, 
                      // Src: (mul:i64 (zext:i64 Int32Regs:i32:$a), (zext:i64 Int32Regs:i32:$b)) - Complexity = 9
                      // Dst: (MULWIDEU64:i64 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*17288*/           0, /*End of Scope*/
/*17289*/         /*Scope*/ 49, /*->17339*/
/*17290*/           OPC_CheckChild0Type, MVT::i16,
/*17292*/           OPC_MoveParent,
/*17293*/           OPC_Scope, 22, /*->17317*/ // 2 children in Scope
/*17295*/             OPC_RecordChild1, // #1 = $b
/*17296*/             OPC_MoveChild1,
/*17297*/             OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17300*/             OPC_CheckPredicate, 12, // Predicate_UInt16Const
/*17302*/             OPC_MoveParent,
/*17303*/             OPC_CheckType, MVT::i32,
/*17305*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17307*/             OPC_EmitConvertToTarget, 1,
/*17309*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDEU32Imm32), 0,
                          MVT::i32, 2/*#Ops*/, 0, 2, 
                      // Src: (mul:i32 (zext:i32 Int16Regs:i16:$a), (imm:i32)<<P:Predicate_UInt16Const>>:$b) - Complexity = 10
                      // Dst: (MULWIDEU32Imm32:i32 Int16Regs:i16:$a, (imm:i32)<<P:Predicate_UInt16Const>>:$b)
/*17317*/           /*Scope*/ 20, /*->17338*/
/*17318*/             OPC_MoveChild1,
/*17319*/             OPC_CheckOpcode, TARGET_VAL(ISD::ZERO_EXTEND),
/*17322*/             OPC_RecordChild0, // #1 = $b
/*17323*/             OPC_CheckChild0Type, MVT::i16,
/*17325*/             OPC_MoveParent,
/*17326*/             OPC_CheckType, MVT::i32,
/*17328*/             OPC_CheckPatternPredicate, 17, // (doMulWide)
/*17330*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULWIDEU32), 0,
                          MVT::i32, 2/*#Ops*/, 0, 1, 
                      // Src: (mul:i32 (zext:i32 Int16Regs:i16:$a), (zext:i32 Int16Regs:i16:$b)) - Complexity = 9
                      // Dst: (MULWIDEU32:i32 Int16Regs:i16:$a, Int16Regs:i16:$b)
/*17338*/           0, /*End of Scope*/
/*17339*/         0, /*End of Scope*/
/*17340*/       0, // EndSwitchOpcode
/*17341*/     /*Scope*/ 81, /*->17423*/
/*17342*/       OPC_RecordChild0, // #0 = $a
/*17343*/       OPC_RecordChild1, // #1 = $b
/*17344*/       OPC_Scope, 43, /*->17389*/ // 4 children in Scope
/*17346*/         OPC_MoveChild1,
/*17347*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17350*/         OPC_MoveParent,
/*17351*/         OPC_SwitchType /*3 cases */, 10, MVT::i64,// ->17364
/*17354*/           OPC_EmitConvertToTarget, 1,
/*17356*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULTi64ri), 0,
                        MVT::i64, 2/*#Ops*/, 0, 2, 
                    // Src: (mul:i64 Int64Regs:i64:$a, (imm:i64):$b) - Complexity = 6
                    // Dst: (MULTi64ri:i64 Int64Regs:i64:$a, (imm:i64):$b)
/*17364*/         /*SwitchType*/ 10, MVT::i32,// ->17376
/*17366*/           OPC_EmitConvertToTarget, 1,
/*17368*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULTi32ri), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (mul:i32 Int32Regs:i32:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (MULTi32ri:i32 Int32Regs:i32:$a, (imm:i32):$b)
/*17376*/         /*SwitchType*/ 10, MVT::i16,// ->17388
/*17378*/           OPC_EmitConvertToTarget, 1,
/*17380*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULTi16ri), 0,
                        MVT::i16, 2/*#Ops*/, 0, 2, 
                    // Src: (mul:i16 Int16Regs:i16:$a, (imm:i16):$b) - Complexity = 6
                    // Dst: (MULTi16ri:i16 Int16Regs:i16:$a, (imm:i16):$b)
/*17388*/         0, // EndSwitchType
/*17389*/       /*Scope*/ 10, /*->17400*/
/*17390*/         OPC_CheckType, MVT::i64,
/*17392*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULTi64rr), 0,
                      MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (mul:i64 Int64Regs:i64:$a, Int64Regs:i64:$b) - Complexity = 3
                  // Dst: (MULTi64rr:i64 Int64Regs:i64:$a, Int64Regs:i64:$b)
/*17400*/       /*Scope*/ 10, /*->17411*/
/*17401*/         OPC_CheckType, MVT::i32,
/*17403*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULTi32rr), 0,
                      MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (mul:i32 Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                  // Dst: (MULTi32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*17411*/       /*Scope*/ 10, /*->17422*/
/*17412*/         OPC_CheckType, MVT::i16,
/*17414*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MULTi16rr), 0,
                      MVT::i16, 2/*#Ops*/, 0, 1, 
                  // Src: (mul:i16 Int16Regs:i16:$a, Int16Regs:i16:$b) - Complexity = 3
                  // Dst: (MULTi16rr:i16 Int16Regs:i16:$a, Int16Regs:i16:$b)
/*17422*/       0, /*End of Scope*/
/*17423*/     0, /*End of Scope*/
/*17424*/   /*SwitchOpcode*/ 113|128,11/*1521*/, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),// ->18949
/*17428*/     OPC_RecordMemRef,
/*17429*/     OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*17430*/     OPC_RecordChild1, // #1 = $addr
/*17431*/     OPC_Scope, 116|128,5/*756*/, /*->18190*/ // 2 children in Scope
/*17434*/       OPC_CheckChild1Type, MVT::i32,
/*17436*/       OPC_RecordChild2, // #2 = $b
/*17437*/       OPC_Scope, 76|128,1/*204*/, /*->17644*/ // 16 children in Scope
/*17440*/         OPC_MoveChild2,
/*17441*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17444*/         OPC_MoveParent,
/*17445*/         OPC_RecordChild3, // #3 = $c
/*17446*/         OPC_Scope, 45|128,1/*173*/, /*->17622*/ // 2 children in Scope
/*17449*/           OPC_MoveChild3,
/*17450*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17453*/           OPC_MoveParent,
/*17454*/           OPC_SwitchType /*2 cases */, 81, MVT::i32,// ->17538
/*17457*/             OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17459*/             OPC_Scope, 18, /*->17479*/ // 3 children in Scope
/*17461*/               OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*17463*/               OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*17465*/               OPC_EmitMergeInputChains1_0,
/*17466*/               OPC_EmitConvertToTarget, 2,
/*17468*/               OPC_EmitConvertToTarget, 3,
/*17470*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_G_32p32imm3:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)
/*17479*/             /*Scope*/ 18, /*->17498*/
/*17480*/               OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*17482*/               OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*17484*/               OPC_EmitMergeInputChains1_0,
/*17485*/               OPC_EmitConvertToTarget, 2,
/*17487*/               OPC_EmitConvertToTarget, 3,
/*17489*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_S_32p32imm3:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)
/*17498*/             /*Scope*/ 38, /*->17537*/
/*17499*/               OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*17501*/               OPC_Scope, 16, /*->17519*/ // 2 children in Scope
/*17503*/                 OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*17505*/                 OPC_EmitMergeInputChains1_0,
/*17506*/                 OPC_EmitConvertToTarget, 2,
/*17508*/                 OPC_EmitConvertToTarget, 3,
/*17510*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_32p32imm3:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)
/*17519*/               /*Scope*/ 16, /*->17536*/
/*17520*/                 OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*17522*/                 OPC_EmitMergeInputChains1_0,
/*17523*/                 OPC_EmitConvertToTarget, 2,
/*17525*/                 OPC_EmitConvertToTarget, 3,
/*17527*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp32imm3:i32 Int32Regs:i32:$addr, (imm:i32):$b, (imm:i32):$c)
/*17536*/               0, /*End of Scope*/
/*17537*/             0, /*End of Scope*/
/*17538*/           /*SwitchType*/ 81, MVT::i64,// ->17621
/*17540*/             OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*17542*/             OPC_Scope, 18, /*->17562*/ // 3 children in Scope
/*17544*/               OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*17546*/               OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*17548*/               OPC_EmitMergeInputChains1_0,
/*17549*/               OPC_EmitConvertToTarget, 2,
/*17551*/               OPC_EmitConvertToTarget, 3,
/*17553*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_G_64p32imm3:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)
/*17562*/             /*Scope*/ 18, /*->17581*/
/*17563*/               OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*17565*/               OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*17567*/               OPC_EmitMergeInputChains1_0,
/*17568*/               OPC_EmitConvertToTarget, 2,
/*17570*/               OPC_EmitConvertToTarget, 3,
/*17572*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_S_64p32imm3:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)
/*17581*/             /*Scope*/ 38, /*->17620*/
/*17582*/               OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*17584*/               OPC_Scope, 16, /*->17602*/ // 2 children in Scope
/*17586*/                 OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*17588*/                 OPC_EmitMergeInputChains1_0,
/*17589*/                 OPC_EmitConvertToTarget, 2,
/*17591*/                 OPC_EmitConvertToTarget, 3,
/*17593*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_64p32imm3:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)
/*17602*/               /*Scope*/ 16, /*->17619*/
/*17603*/                 OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*17605*/                 OPC_EmitMergeInputChains1_0,
/*17606*/                 OPC_EmitConvertToTarget, 2,
/*17608*/                 OPC_EmitConvertToTarget, 3,
/*17610*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp32imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp32imm3:i64 Int32Regs:i32:$addr, (imm:i64):$b, (imm:i64):$c)
/*17619*/               0, /*End of Scope*/
/*17620*/             0, /*End of Scope*/
/*17621*/           0, // EndSwitchType
/*17622*/         /*Scope*/ 20, /*->17643*/
/*17623*/           OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17625*/           OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*17627*/           OPC_CheckType, MVT::i32,
/*17629*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*17631*/           OPC_EmitMergeInputChains1_0,
/*17632*/           OPC_EmitConvertToTarget, 2,
/*17634*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                    // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 7
                    // Dst: (INT_PTX_ATOM_CAS_G_32p32imm1:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*17643*/         0, /*End of Scope*/
/*17644*/       /*Scope*/ 26, /*->17671*/
/*17645*/         OPC_RecordChild3, // #3 = $c
/*17646*/         OPC_MoveChild3,
/*17647*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17650*/         OPC_MoveParent,
/*17651*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17653*/         OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*17655*/         OPC_CheckType, MVT::i32,
/*17657*/         OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*17659*/         OPC_EmitMergeInputChains1_0,
/*17660*/         OPC_EmitConvertToTarget, 3,
/*17662*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_G_32p32imm2:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*17671*/       /*Scope*/ 26, /*->17698*/
/*17672*/         OPC_MoveChild2,
/*17673*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17676*/         OPC_MoveParent,
/*17677*/         OPC_RecordChild3, // #3 = $c
/*17678*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17680*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*17682*/         OPC_CheckType, MVT::i32,
/*17684*/         OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*17686*/         OPC_EmitMergeInputChains1_0,
/*17687*/         OPC_EmitConvertToTarget, 2,
/*17689*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_32p32imm1:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*17698*/       /*Scope*/ 26, /*->17725*/
/*17699*/         OPC_RecordChild3, // #3 = $c
/*17700*/         OPC_MoveChild3,
/*17701*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17704*/         OPC_MoveParent,
/*17705*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17707*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*17709*/         OPC_CheckType, MVT::i32,
/*17711*/         OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*17713*/         OPC_EmitMergeInputChains1_0,
/*17714*/         OPC_EmitConvertToTarget, 3,
/*17716*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_32p32imm2:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*17725*/       /*Scope*/ 26, /*->17752*/
/*17726*/         OPC_MoveChild2,
/*17727*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17730*/         OPC_MoveParent,
/*17731*/         OPC_RecordChild3, // #3 = $c
/*17732*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17734*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*17736*/         OPC_CheckType, MVT::i32,
/*17738*/         OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*17740*/         OPC_EmitMergeInputChains1_0,
/*17741*/         OPC_EmitConvertToTarget, 2,
/*17743*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32p32imm1:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*17752*/       /*Scope*/ 26, /*->17779*/
/*17753*/         OPC_RecordChild3, // #3 = $c
/*17754*/         OPC_MoveChild3,
/*17755*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17758*/         OPC_MoveParent,
/*17759*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17761*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*17763*/         OPC_CheckType, MVT::i32,
/*17765*/         OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*17767*/         OPC_EmitMergeInputChains1_0,
/*17768*/         OPC_EmitConvertToTarget, 3,
/*17770*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32p32imm2:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*17779*/       /*Scope*/ 26, /*->17806*/
/*17780*/         OPC_MoveChild2,
/*17781*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17784*/         OPC_MoveParent,
/*17785*/         OPC_RecordChild3, // #3 = $c
/*17786*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17788*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*17790*/         OPC_CheckType, MVT::i32,
/*17792*/         OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*17794*/         OPC_EmitMergeInputChains1_0,
/*17795*/         OPC_EmitConvertToTarget, 2,
/*17797*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp32imm1:i32 Int32Regs:i32:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*17806*/       /*Scope*/ 26, /*->17833*/
/*17807*/         OPC_RecordChild3, // #3 = $c
/*17808*/         OPC_MoveChild3,
/*17809*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17812*/         OPC_MoveParent,
/*17813*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*17815*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*17817*/         OPC_CheckType, MVT::i32,
/*17819*/         OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*17821*/         OPC_EmitMergeInputChains1_0,
/*17822*/         OPC_EmitConvertToTarget, 3,
/*17824*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp32imm2:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*17833*/       /*Scope*/ 26, /*->17860*/
/*17834*/         OPC_MoveChild2,
/*17835*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17838*/         OPC_MoveParent,
/*17839*/         OPC_RecordChild3, // #3 = $c
/*17840*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*17842*/         OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*17844*/         OPC_CheckType, MVT::i64,
/*17846*/         OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*17848*/         OPC_EmitMergeInputChains1_0,
/*17849*/         OPC_EmitConvertToTarget, 2,
/*17851*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_G_64p32imm1:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*17860*/       /*Scope*/ 26, /*->17887*/
/*17861*/         OPC_RecordChild3, // #3 = $c
/*17862*/         OPC_MoveChild3,
/*17863*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17866*/         OPC_MoveParent,
/*17867*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*17869*/         OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*17871*/         OPC_CheckType, MVT::i64,
/*17873*/         OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*17875*/         OPC_EmitMergeInputChains1_0,
/*17876*/         OPC_EmitConvertToTarget, 3,
/*17878*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_G_64p32imm2:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*17887*/       /*Scope*/ 26, /*->17914*/
/*17888*/         OPC_MoveChild2,
/*17889*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17892*/         OPC_MoveParent,
/*17893*/         OPC_RecordChild3, // #3 = $c
/*17894*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*17896*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*17898*/         OPC_CheckType, MVT::i64,
/*17900*/         OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*17902*/         OPC_EmitMergeInputChains1_0,
/*17903*/         OPC_EmitConvertToTarget, 2,
/*17905*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_64p32imm1:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*17914*/       /*Scope*/ 26, /*->17941*/
/*17915*/         OPC_RecordChild3, // #3 = $c
/*17916*/         OPC_MoveChild3,
/*17917*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17920*/         OPC_MoveParent,
/*17921*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*17923*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*17925*/         OPC_CheckType, MVT::i64,
/*17927*/         OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*17929*/         OPC_EmitMergeInputChains1_0,
/*17930*/         OPC_EmitConvertToTarget, 3,
/*17932*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_64p32imm2:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*17941*/       /*Scope*/ 26, /*->17968*/
/*17942*/         OPC_MoveChild2,
/*17943*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17946*/         OPC_MoveParent,
/*17947*/         OPC_RecordChild3, // #3 = $c
/*17948*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*17950*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*17952*/         OPC_CheckType, MVT::i64,
/*17954*/         OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*17956*/         OPC_EmitMergeInputChains1_0,
/*17957*/         OPC_EmitConvertToTarget, 2,
/*17959*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_64p32imm1:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*17968*/       /*Scope*/ 26, /*->17995*/
/*17969*/         OPC_RecordChild3, // #3 = $c
/*17970*/         OPC_MoveChild3,
/*17971*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*17974*/         OPC_MoveParent,
/*17975*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*17977*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*17979*/         OPC_CheckType, MVT::i64,
/*17981*/         OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*17983*/         OPC_EmitMergeInputChains1_0,
/*17984*/         OPC_EmitConvertToTarget, 3,
/*17986*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_64p32imm2:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*17995*/       /*Scope*/ 26, /*->18022*/
/*17996*/         OPC_MoveChild2,
/*17997*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18000*/         OPC_MoveParent,
/*18001*/         OPC_RecordChild3, // #3 = $c
/*18002*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18004*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18006*/         OPC_CheckType, MVT::i64,
/*18008*/         OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*18010*/         OPC_EmitMergeInputChains1_0,
/*18011*/         OPC_EmitConvertToTarget, 2,
/*18013*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp32imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp32imm1:i64 Int32Regs:i32:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*18022*/       /*Scope*/ 37|128,1/*165*/, /*->18189*/
/*18024*/         OPC_RecordChild3, // #3 = $c
/*18025*/         OPC_Scope, 25, /*->18052*/ // 3 children in Scope
/*18027*/           OPC_MoveChild3,
/*18028*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18031*/           OPC_MoveParent,
/*18032*/           OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18034*/           OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18036*/           OPC_CheckType, MVT::i64,
/*18038*/           OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*18040*/           OPC_EmitMergeInputChains1_0,
/*18041*/           OPC_EmitConvertToTarget, 3,
/*18043*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp32imm2), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                    // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                    // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp32imm2:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*18052*/         /*Scope*/ 67, /*->18120*/
/*18053*/           OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18055*/           OPC_CheckType, MVT::i32,
/*18057*/           OPC_Scope, 14, /*->18073*/ // 3 children in Scope
/*18059*/             OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*18061*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*18063*/             OPC_EmitMergeInputChains1_0,
/*18064*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18073*/           /*Scope*/ 14, /*->18088*/
/*18074*/             OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*18076*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*18078*/             OPC_EmitMergeInputChains1_0,
/*18079*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18088*/           /*Scope*/ 30, /*->18119*/
/*18089*/             OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*18091*/             OPC_Scope, 12, /*->18105*/ // 2 children in Scope
/*18093*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*18095*/               OPC_EmitMergeInputChains1_0,
/*18096*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18105*/             /*Scope*/ 12, /*->18118*/
/*18106*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*18108*/               OPC_EmitMergeInputChains1_0,
/*18109*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18118*/             0, /*End of Scope*/
/*18119*/           0, /*End of Scope*/
/*18120*/         /*Scope*/ 67, /*->18188*/
/*18121*/           OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18123*/           OPC_CheckType, MVT::i64,
/*18125*/           OPC_Scope, 14, /*->18141*/ // 3 children in Scope
/*18127*/             OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*18129*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*18131*/             OPC_EmitMergeInputChains1_0,
/*18132*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18141*/           /*Scope*/ 14, /*->18156*/
/*18142*/             OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*18144*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*18146*/             OPC_EmitMergeInputChains1_0,
/*18147*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18156*/           /*Scope*/ 30, /*->18187*/
/*18157*/             OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18159*/             OPC_Scope, 12, /*->18173*/ // 2 children in Scope
/*18161*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*18163*/               OPC_EmitMergeInputChains1_0,
/*18164*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18173*/             /*Scope*/ 12, /*->18186*/
/*18174*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*18176*/               OPC_EmitMergeInputChains1_0,
/*18177*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18186*/             0, /*End of Scope*/
/*18187*/           0, /*End of Scope*/
/*18188*/         0, /*End of Scope*/
/*18189*/       0, /*End of Scope*/
/*18190*/     /*Scope*/ 116|128,5/*756*/, /*->18948*/
/*18192*/       OPC_CheckChild1Type, MVT::i64,
/*18194*/       OPC_RecordChild2, // #2 = $b
/*18195*/       OPC_Scope, 76|128,1/*204*/, /*->18402*/ // 16 children in Scope
/*18198*/         OPC_MoveChild2,
/*18199*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18202*/         OPC_MoveParent,
/*18203*/         OPC_RecordChild3, // #3 = $c
/*18204*/         OPC_Scope, 45|128,1/*173*/, /*->18380*/ // 2 children in Scope
/*18207*/           OPC_MoveChild3,
/*18208*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18211*/           OPC_MoveParent,
/*18212*/           OPC_SwitchType /*2 cases */, 81, MVT::i32,// ->18296
/*18215*/             OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18217*/             OPC_Scope, 18, /*->18237*/ // 3 children in Scope
/*18219*/               OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*18221*/               OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*18223*/               OPC_EmitMergeInputChains1_0,
/*18224*/               OPC_EmitConvertToTarget, 2,
/*18226*/               OPC_EmitConvertToTarget, 3,
/*18228*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_G_32p64imm3:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)
/*18237*/             /*Scope*/ 18, /*->18256*/
/*18238*/               OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*18240*/               OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*18242*/               OPC_EmitMergeInputChains1_0,
/*18243*/               OPC_EmitConvertToTarget, 2,
/*18245*/               OPC_EmitConvertToTarget, 3,
/*18247*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_S_32p64imm3:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)
/*18256*/             /*Scope*/ 38, /*->18295*/
/*18257*/               OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*18259*/               OPC_Scope, 16, /*->18277*/ // 2 children in Scope
/*18261*/                 OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*18263*/                 OPC_EmitMergeInputChains1_0,
/*18264*/                 OPC_EmitConvertToTarget, 2,
/*18266*/                 OPC_EmitConvertToTarget, 3,
/*18268*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_32p64imm3:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)
/*18277*/               /*Scope*/ 16, /*->18294*/
/*18278*/                 OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*18280*/                 OPC_EmitMergeInputChains1_0,
/*18281*/                 OPC_EmitConvertToTarget, 2,
/*18283*/                 OPC_EmitConvertToTarget, 3,
/*18285*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i32, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp64imm3:i32 Int64Regs:i64:$addr, (imm:i32):$b, (imm:i32):$c)
/*18294*/               0, /*End of Scope*/
/*18295*/             0, /*End of Scope*/
/*18296*/           /*SwitchType*/ 81, MVT::i64,// ->18379
/*18298*/             OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18300*/             OPC_Scope, 18, /*->18320*/ // 3 children in Scope
/*18302*/               OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*18304*/               OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*18306*/               OPC_EmitMergeInputChains1_0,
/*18307*/               OPC_EmitConvertToTarget, 2,
/*18309*/               OPC_EmitConvertToTarget, 3,
/*18311*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_G_64p64imm3:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)
/*18320*/             /*Scope*/ 18, /*->18339*/
/*18321*/               OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*18323*/               OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*18325*/               OPC_EmitMergeInputChains1_0,
/*18326*/               OPC_EmitConvertToTarget, 2,
/*18328*/               OPC_EmitConvertToTarget, 3,
/*18330*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                        // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 10
                        // Dst: (INT_PTX_ATOM_CAS_S_64p64imm3:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)
/*18339*/             /*Scope*/ 38, /*->18378*/
/*18340*/               OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18342*/               OPC_Scope, 16, /*->18360*/ // 2 children in Scope
/*18344*/                 OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*18346*/                 OPC_EmitMergeInputChains1_0,
/*18347*/                 OPC_EmitConvertToTarget, 2,
/*18349*/                 OPC_EmitConvertToTarget, 3,
/*18351*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_64p64imm3:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)
/*18360*/               /*Scope*/ 16, /*->18377*/
/*18361*/                 OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*18363*/                 OPC_EmitMergeInputChains1_0,
/*18364*/                 OPC_EmitConvertToTarget, 2,
/*18366*/                 OPC_EmitConvertToTarget, 3,
/*18368*/                 OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp64imm3), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 1, 4, 5, 
                          // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 10
                          // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp64imm3:i64 Int64Regs:i64:$addr, (imm:i64):$b, (imm:i64):$c)
/*18377*/               0, /*End of Scope*/
/*18378*/             0, /*End of Scope*/
/*18379*/           0, // EndSwitchType
/*18380*/         /*Scope*/ 20, /*->18401*/
/*18381*/           OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18383*/           OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*18385*/           OPC_CheckType, MVT::i32,
/*18387*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*18389*/           OPC_EmitMergeInputChains1_0,
/*18390*/           OPC_EmitConvertToTarget, 2,
/*18392*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                    // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 7
                    // Dst: (INT_PTX_ATOM_CAS_G_32p64imm1:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*18401*/         0, /*End of Scope*/
/*18402*/       /*Scope*/ 26, /*->18429*/
/*18403*/         OPC_RecordChild3, // #3 = $c
/*18404*/         OPC_MoveChild3,
/*18405*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18408*/         OPC_MoveParent,
/*18409*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18411*/         OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*18413*/         OPC_CheckType, MVT::i32,
/*18415*/         OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*18417*/         OPC_EmitMergeInputChains1_0,
/*18418*/         OPC_EmitConvertToTarget, 3,
/*18420*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_G_32p64imm2:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*18429*/       /*Scope*/ 26, /*->18456*/
/*18430*/         OPC_MoveChild2,
/*18431*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18434*/         OPC_MoveParent,
/*18435*/         OPC_RecordChild3, // #3 = $c
/*18436*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18438*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*18440*/         OPC_CheckType, MVT::i32,
/*18442*/         OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*18444*/         OPC_EmitMergeInputChains1_0,
/*18445*/         OPC_EmitConvertToTarget, 2,
/*18447*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_32p64imm1:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*18456*/       /*Scope*/ 26, /*->18483*/
/*18457*/         OPC_RecordChild3, // #3 = $c
/*18458*/         OPC_MoveChild3,
/*18459*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18462*/         OPC_MoveParent,
/*18463*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18465*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*18467*/         OPC_CheckType, MVT::i32,
/*18469*/         OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*18471*/         OPC_EmitMergeInputChains1_0,
/*18472*/         OPC_EmitConvertToTarget, 3,
/*18474*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_32p64imm2:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*18483*/       /*Scope*/ 26, /*->18510*/
/*18484*/         OPC_MoveChild2,
/*18485*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18488*/         OPC_MoveParent,
/*18489*/         OPC_RecordChild3, // #3 = $c
/*18490*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18492*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*18494*/         OPC_CheckType, MVT::i32,
/*18496*/         OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*18498*/         OPC_EmitMergeInputChains1_0,
/*18499*/         OPC_EmitConvertToTarget, 2,
/*18501*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32p64imm1:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*18510*/       /*Scope*/ 26, /*->18537*/
/*18511*/         OPC_RecordChild3, // #3 = $c
/*18512*/         OPC_MoveChild3,
/*18513*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18516*/         OPC_MoveParent,
/*18517*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18519*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*18521*/         OPC_CheckType, MVT::i32,
/*18523*/         OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*18525*/         OPC_EmitMergeInputChains1_0,
/*18526*/         OPC_EmitConvertToTarget, 3,
/*18528*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32p64imm2:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*18537*/       /*Scope*/ 26, /*->18564*/
/*18538*/         OPC_MoveChild2,
/*18539*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18542*/         OPC_MoveParent,
/*18543*/         OPC_RecordChild3, // #3 = $c
/*18544*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18546*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*18548*/         OPC_CheckType, MVT::i32,
/*18550*/         OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*18552*/         OPC_EmitMergeInputChains1_0,
/*18553*/         OPC_EmitConvertToTarget, 2,
/*18555*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp64imm1:i32 Int64Regs:i64:$addr, (imm:i32):$b, Int32Regs:i32:$c)
/*18564*/       /*Scope*/ 26, /*->18591*/
/*18565*/         OPC_RecordChild3, // #3 = $c
/*18566*/         OPC_MoveChild3,
/*18567*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18570*/         OPC_MoveParent,
/*18571*/         OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18573*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*18575*/         OPC_CheckType, MVT::i32,
/*18577*/         OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*18579*/         OPC_EmitMergeInputChains1_0,
/*18580*/         OPC_EmitConvertToTarget, 3,
/*18582*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i32, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp64imm2:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, (imm:i32):$c)
/*18591*/       /*Scope*/ 26, /*->18618*/
/*18592*/         OPC_MoveChild2,
/*18593*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18596*/         OPC_MoveParent,
/*18597*/         OPC_RecordChild3, // #3 = $c
/*18598*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18600*/         OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*18602*/         OPC_CheckType, MVT::i64,
/*18604*/         OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*18606*/         OPC_EmitMergeInputChains1_0,
/*18607*/         OPC_EmitConvertToTarget, 2,
/*18609*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_G_64p64imm1:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*18618*/       /*Scope*/ 26, /*->18645*/
/*18619*/         OPC_RecordChild3, // #3 = $c
/*18620*/         OPC_MoveChild3,
/*18621*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18624*/         OPC_MoveParent,
/*18625*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18627*/         OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*18629*/         OPC_CheckType, MVT::i64,
/*18631*/         OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*18633*/         OPC_EmitMergeInputChains1_0,
/*18634*/         OPC_EmitConvertToTarget, 3,
/*18636*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_G_64p64imm2:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*18645*/       /*Scope*/ 26, /*->18672*/
/*18646*/         OPC_MoveChild2,
/*18647*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18650*/         OPC_MoveParent,
/*18651*/         OPC_RecordChild3, // #3 = $c
/*18652*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18654*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*18656*/         OPC_CheckType, MVT::i64,
/*18658*/         OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*18660*/         OPC_EmitMergeInputChains1_0,
/*18661*/         OPC_EmitConvertToTarget, 2,
/*18663*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_64p64imm1:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*18672*/       /*Scope*/ 26, /*->18699*/
/*18673*/         OPC_RecordChild3, // #3 = $c
/*18674*/         OPC_MoveChild3,
/*18675*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18678*/         OPC_MoveParent,
/*18679*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18681*/         OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*18683*/         OPC_CheckType, MVT::i64,
/*18685*/         OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*18687*/         OPC_EmitMergeInputChains1_0,
/*18688*/         OPC_EmitConvertToTarget, 3,
/*18690*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_S_64p64imm2:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*18699*/       /*Scope*/ 26, /*->18726*/
/*18700*/         OPC_MoveChild2,
/*18701*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18704*/         OPC_MoveParent,
/*18705*/         OPC_RecordChild3, // #3 = $c
/*18706*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18708*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18710*/         OPC_CheckType, MVT::i64,
/*18712*/         OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*18714*/         OPC_EmitMergeInputChains1_0,
/*18715*/         OPC_EmitConvertToTarget, 2,
/*18717*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_64p64imm1:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*18726*/       /*Scope*/ 26, /*->18753*/
/*18727*/         OPC_RecordChild3, // #3 = $c
/*18728*/         OPC_MoveChild3,
/*18729*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18732*/         OPC_MoveParent,
/*18733*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18735*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18737*/         OPC_CheckType, MVT::i64,
/*18739*/         OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*18741*/         OPC_EmitMergeInputChains1_0,
/*18742*/         OPC_EmitConvertToTarget, 3,
/*18744*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                  // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_64p64imm2:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*18753*/       /*Scope*/ 26, /*->18780*/
/*18754*/         OPC_MoveChild2,
/*18755*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18758*/         OPC_MoveParent,
/*18759*/         OPC_RecordChild3, // #3 = $c
/*18760*/         OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18762*/         OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18764*/         OPC_CheckType, MVT::i64,
/*18766*/         OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*18768*/         OPC_EmitMergeInputChains1_0,
/*18769*/         OPC_EmitConvertToTarget, 2,
/*18771*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp64imm1), 0|OPFL_Chain|OPFL_MemRefs,
                      MVT::i64, 3/*#Ops*/, 1, 4, 3, 
                  // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                  // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp64imm1:i64 Int64Regs:i64:$addr, (imm:i64):$b, Int64Regs:i64:$c)
/*18780*/       /*Scope*/ 37|128,1/*165*/, /*->18947*/
/*18782*/         OPC_RecordChild3, // #3 = $c
/*18783*/         OPC_Scope, 25, /*->18810*/ // 3 children in Scope
/*18785*/           OPC_MoveChild3,
/*18786*/           OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18789*/           OPC_MoveParent,
/*18790*/           OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18792*/           OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18794*/           OPC_CheckType, MVT::i64,
/*18796*/           OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*18798*/           OPC_EmitMergeInputChains1_0,
/*18799*/           OPC_EmitConvertToTarget, 3,
/*18801*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp64imm2), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 3/*#Ops*/, 1, 2, 4, 
                    // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 7
                    // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp64imm2:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, (imm:i64):$c)
/*18810*/         /*Scope*/ 67, /*->18878*/
/*18811*/           OPC_CheckPredicate, 13, // Predicate_atomic_cmp_swap_32
/*18813*/           OPC_CheckType, MVT::i32,
/*18815*/           OPC_Scope, 14, /*->18831*/ // 3 children in Scope
/*18817*/             OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_32_g
/*18819*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*18821*/             OPC_EmitMergeInputChains1_0,
/*18822*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_g>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18831*/           /*Scope*/ 14, /*->18846*/
/*18832*/             OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_32_s
/*18834*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*18836*/             OPC_EmitMergeInputChains1_0,
/*18837*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_s>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18846*/           /*Scope*/ 30, /*->18877*/
/*18847*/             OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_32_gen
/*18849*/             OPC_Scope, 12, /*->18863*/ // 2 children in Scope
/*18851*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*18853*/               OPC_EmitMergeInputChains1_0,
/*18854*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18863*/             /*Scope*/ 12, /*->18876*/
/*18864*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*18866*/               OPC_EmitMergeInputChains1_0,
/*18867*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*18876*/             0, /*End of Scope*/
/*18877*/           0, /*End of Scope*/
/*18878*/         /*Scope*/ 67, /*->18946*/
/*18879*/           OPC_CheckPredicate, 14, // Predicate_atomic_cmp_swap_64
/*18881*/           OPC_CheckType, MVT::i64,
/*18883*/           OPC_Scope, 14, /*->18899*/ // 3 children in Scope
/*18885*/             OPC_CheckPredicate, 4, // Predicate_atomic_cmp_swap_64_g
/*18887*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*18889*/             OPC_EmitMergeInputChains1_0,
/*18890*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_g>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18899*/           /*Scope*/ 14, /*->18914*/
/*18900*/             OPC_CheckPredicate, 5, // Predicate_atomic_cmp_swap_64_s
/*18902*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*18904*/             OPC_EmitMergeInputChains1_0,
/*18905*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_s>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_CAS_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18914*/           /*Scope*/ 30, /*->18945*/
/*18915*/             OPC_CheckPredicate, 6, // Predicate_atomic_cmp_swap_64_gen
/*18917*/             OPC_Scope, 12, /*->18931*/ // 2 children in Scope
/*18919*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*18921*/               OPC_EmitMergeInputChains1_0,
/*18922*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18931*/             /*Scope*/ 12, /*->18944*/
/*18932*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*18934*/               OPC_EmitMergeInputChains1_0,
/*18935*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_CAS_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (atomic_cmp_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_gen>> - Complexity = 4
                        // Dst: (INT_PTX_ATOM_CAS_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*18944*/             0, /*End of Scope*/
/*18945*/           0, /*End of Scope*/
/*18946*/         0, /*End of Scope*/
/*18947*/       0, /*End of Scope*/
/*18948*/     0, /*End of Scope*/
/*18949*/   /*SwitchOpcode*/ 92|128,1/*220*/, TARGET_VAL(NVPTXISD::IMAD),// ->19173
/*18953*/     OPC_RecordChild0, // #0 = $a
/*18954*/     OPC_RecordChild1, // #1 = $b
/*18955*/     OPC_Scope, 58, /*->19015*/ // 8 children in Scope
/*18957*/       OPC_MoveChild1,
/*18958*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18961*/       OPC_MoveParent,
/*18962*/       OPC_RecordChild2, // #2 = $c
/*18963*/       OPC_MoveChild2,
/*18964*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18967*/       OPC_MoveParent,
/*18968*/       OPC_SwitchType /*3 cases */, 13, MVT::i16,// ->18984
/*18971*/         OPC_EmitConvertToTarget, 1,
/*18973*/         OPC_EmitConvertToTarget, 2,
/*18975*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD16rii), 0,
                      MVT::i16, 3/*#Ops*/, 0, 3, 4, 
                  // Src: (imad:i16 Int16Regs:i16:$a, (imm:i16):$b, (imm:i16):$c) - Complexity = 9
                  // Dst: (MAD16rii:i16 Int16Regs:i16:$a, (imm:i16):$b, (imm:i16):$c)
/*18984*/       /*SwitchType*/ 13, MVT::i32,// ->18999
/*18986*/         OPC_EmitConvertToTarget, 1,
/*18988*/         OPC_EmitConvertToTarget, 2,
/*18990*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD32rii), 0,
                      MVT::i32, 3/*#Ops*/, 0, 3, 4, 
                  // Src: (imad:i32 Int32Regs:i32:$a, (imm:i32):$b, (imm:i32):$c) - Complexity = 9
                  // Dst: (MAD32rii:i32 Int32Regs:i32:$a, (imm:i32):$b, (imm:i32):$c)
/*18999*/       /*SwitchType*/ 13, MVT::i64,// ->19014
/*19001*/         OPC_EmitConvertToTarget, 1,
/*19003*/         OPC_EmitConvertToTarget, 2,
/*19005*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD64rii), 0,
                      MVT::i64, 3/*#Ops*/, 0, 3, 4, 
                  // Src: (imad:i64 Int64Regs:i64:$a, (imm:i64):$b, (imm:i64):$c) - Complexity = 9
                  // Dst: (MAD64rii:i64 Int64Regs:i64:$a, (imm:i64):$b, (imm:i64):$c)
/*19014*/       0, // EndSwitchType
/*19015*/     /*Scope*/ 19, /*->19035*/
/*19016*/       OPC_RecordChild2, // #2 = $c
/*19017*/       OPC_MoveChild2,
/*19018*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19021*/       OPC_MoveParent,
/*19022*/       OPC_CheckType, MVT::i16,
/*19024*/       OPC_EmitConvertToTarget, 2,
/*19026*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD16rri), 0,
                    MVT::i16, 3/*#Ops*/, 0, 1, 3, 
                // Src: (imad:i16 Int16Regs:i16:$a, Int16Regs:i16:$b, (imm:i16):$c) - Complexity = 6
                // Dst: (MAD16rri:i16 Int16Regs:i16:$a, Int16Regs:i16:$b, (imm:i16):$c)
/*19035*/     /*Scope*/ 19, /*->19055*/
/*19036*/       OPC_MoveChild1,
/*19037*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19040*/       OPC_MoveParent,
/*19041*/       OPC_RecordChild2, // #2 = $c
/*19042*/       OPC_CheckType, MVT::i16,
/*19044*/       OPC_EmitConvertToTarget, 1,
/*19046*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD16rir), 0,
                    MVT::i16, 3/*#Ops*/, 0, 3, 2, 
                // Src: (imad:i16 Int16Regs:i16:$a, (imm:i16):$b, Int16Regs:i16:$c) - Complexity = 6
                // Dst: (MAD16rir:i16 Int16Regs:i16:$a, (imm:i16):$b, Int16Regs:i16:$c)
/*19055*/     /*Scope*/ 19, /*->19075*/
/*19056*/       OPC_RecordChild2, // #2 = $c
/*19057*/       OPC_MoveChild2,
/*19058*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19061*/       OPC_MoveParent,
/*19062*/       OPC_CheckType, MVT::i32,
/*19064*/       OPC_EmitConvertToTarget, 2,
/*19066*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD32rri), 0,
                    MVT::i32, 3/*#Ops*/, 0, 1, 3, 
                // Src: (imad:i32 Int32Regs:i32:$a, Int32Regs:i32:$b, (imm:i32):$c) - Complexity = 6
                // Dst: (MAD32rri:i32 Int32Regs:i32:$a, Int32Regs:i32:$b, (imm:i32):$c)
/*19075*/     /*Scope*/ 19, /*->19095*/
/*19076*/       OPC_MoveChild1,
/*19077*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19080*/       OPC_MoveParent,
/*19081*/       OPC_RecordChild2, // #2 = $c
/*19082*/       OPC_CheckType, MVT::i32,
/*19084*/       OPC_EmitConvertToTarget, 1,
/*19086*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD32rir), 0,
                    MVT::i32, 3/*#Ops*/, 0, 3, 2, 
                // Src: (imad:i32 Int32Regs:i32:$a, (imm:i32):$b, Int32Regs:i32:$c) - Complexity = 6
                // Dst: (MAD32rir:i32 Int32Regs:i32:$a, (imm:i32):$b, Int32Regs:i32:$c)
/*19095*/     /*Scope*/ 19, /*->19115*/
/*19096*/       OPC_RecordChild2, // #2 = $c
/*19097*/       OPC_MoveChild2,
/*19098*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19101*/       OPC_MoveParent,
/*19102*/       OPC_CheckType, MVT::i64,
/*19104*/       OPC_EmitConvertToTarget, 2,
/*19106*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD64rri), 0,
                    MVT::i64, 3/*#Ops*/, 0, 1, 3, 
                // Src: (imad:i64 Int64Regs:i64:$a, Int64Regs:i64:$b, (imm:i64):$c) - Complexity = 6
                // Dst: (MAD64rri:i64 Int64Regs:i64:$a, Int64Regs:i64:$b, (imm:i64):$c)
/*19115*/     /*Scope*/ 19, /*->19135*/
/*19116*/       OPC_MoveChild1,
/*19117*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19120*/       OPC_MoveParent,
/*19121*/       OPC_RecordChild2, // #2 = $c
/*19122*/       OPC_CheckType, MVT::i64,
/*19124*/       OPC_EmitConvertToTarget, 1,
/*19126*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD64rir), 0,
                    MVT::i64, 3/*#Ops*/, 0, 3, 2, 
                // Src: (imad:i64 Int64Regs:i64:$a, (imm:i64):$b, Int64Regs:i64:$c) - Complexity = 6
                // Dst: (MAD64rir:i64 Int64Regs:i64:$a, (imm:i64):$b, Int64Regs:i64:$c)
/*19135*/     /*Scope*/ 36, /*->19172*/
/*19136*/       OPC_RecordChild2, // #2 = $c
/*19137*/       OPC_SwitchType /*3 cases */, 9, MVT::i16,// ->19149
/*19140*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD16rrr), 0,
                      MVT::i16, 3/*#Ops*/, 0, 1, 2, 
                  // Src: (imad:i16 Int16Regs:i16:$a, Int16Regs:i16:$b, Int16Regs:i16:$c) - Complexity = 3
                  // Dst: (MAD16rrr:i16 Int16Regs:i16:$a, Int16Regs:i16:$b, Int16Regs:i16:$c)
/*19149*/       /*SwitchType*/ 9, MVT::i32,// ->19160
/*19151*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD32rrr), 0,
                      MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                  // Src: (imad:i32 Int32Regs:i32:$a, Int32Regs:i32:$b, Int32Regs:i32:$c) - Complexity = 3
                  // Dst: (MAD32rrr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b, Int32Regs:i32:$c)
/*19160*/       /*SwitchType*/ 9, MVT::i64,// ->19171
/*19162*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::MAD64rrr), 0,
                      MVT::i64, 3/*#Ops*/, 0, 1, 2, 
                  // Src: (imad:i64 Int64Regs:i64:$a, Int64Regs:i64:$b, Int64Regs:i64:$c) - Complexity = 3
                  // Dst: (MAD64rrr:i64 Int64Regs:i64:$a, Int64Regs:i64:$b, Int64Regs:i64:$c)
/*19171*/       0, // EndSwitchType
/*19172*/     0, /*End of Scope*/
/*19173*/   /*SwitchOpcode*/ 116, TARGET_VAL(ISD::SRA),// ->19292
/*19176*/     OPC_RecordChild0, // #0 = $a
/*19177*/     OPC_Scope, 27, /*->19206*/ // 2 children in Scope
/*19179*/       OPC_MoveChild0,
/*19180*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19183*/       OPC_MoveParent,
/*19184*/       OPC_RecordChild1, // #1 = $b
/*19185*/       OPC_MoveChild1,
/*19186*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19189*/       OPC_CheckType, MVT::i32,
/*19191*/       OPC_MoveParent,
/*19192*/       OPC_CheckType, MVT::i32,
/*19194*/       OPC_EmitConvertToTarget, 0,
/*19196*/       OPC_EmitConvertToTarget, 1,
/*19198*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRAi32ii), 0,
                    MVT::i32, 2/*#Ops*/, 2, 3, 
                // Src: (sra:i32 (imm:i32):$a, (imm:i32):$b) - Complexity = 9
                // Dst: (SRAi32ii:i32 (imm:i32):$a, (imm:i32):$b)
/*19206*/     /*Scope*/ 84, /*->19291*/
/*19207*/       OPC_RecordChild1, // #1 = $b
/*19208*/       OPC_Scope, 45, /*->19255*/ // 2 children in Scope
/*19210*/         OPC_MoveChild1,
/*19211*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19214*/         OPC_CheckType, MVT::i32,
/*19216*/         OPC_MoveParent,
/*19217*/         OPC_SwitchType /*3 cases */, 10, MVT::i64,// ->19230
/*19220*/           OPC_EmitConvertToTarget, 1,
/*19222*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRAi64ri), 0,
                        MVT::i64, 2/*#Ops*/, 0, 2, 
                    // Src: (sra:i64 Int64Regs:i64:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (SRAi64ri:i64 Int64Regs:i64:$a, (imm:i32):$b)
/*19230*/         /*SwitchType*/ 10, MVT::i32,// ->19242
/*19232*/           OPC_EmitConvertToTarget, 1,
/*19234*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRAi32ri), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (sra:i32 Int32Regs:i32:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (SRAi32ri:i32 Int32Regs:i32:$a, (imm:i32):$b)
/*19242*/         /*SwitchType*/ 10, MVT::i16,// ->19254
/*19244*/           OPC_EmitConvertToTarget, 1,
/*19246*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRAi16ri), 0,
                        MVT::i16, 2/*#Ops*/, 0, 2, 
                    // Src: (sra:i16 Int16Regs:i16:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (SRAi16ri:i16 Int16Regs:i16:$a, (imm:i32):$b)
/*19254*/         0, // EndSwitchType
/*19255*/       /*Scope*/ 34, /*->19290*/
/*19256*/         OPC_CheckChild1Type, MVT::i32,
/*19258*/         OPC_SwitchType /*3 cases */, 8, MVT::i64,// ->19269
/*19261*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRAi64rr), 0,
                        MVT::i64, 2/*#Ops*/, 0, 1, 
                    // Src: (sra:i64 Int64Regs:i64:$a, Int32Regs:i32:$b) - Complexity = 3
                    // Dst: (SRAi64rr:i64 Int64Regs:i64:$a, Int32Regs:i32:$b)
/*19269*/         /*SwitchType*/ 8, MVT::i32,// ->19279
/*19271*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRAi32rr), 0,
                        MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (sra:i32 Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                    // Dst: (SRAi32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*19279*/         /*SwitchType*/ 8, MVT::i16,// ->19289
/*19281*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRAi16rr), 0,
                        MVT::i16, 2/*#Ops*/, 0, 1, 
                    // Src: (sra:i16 Int16Regs:i16:$a, Int32Regs:i32:$b) - Complexity = 3
                    // Dst: (SRAi16rr:i16 Int16Regs:i16:$a, Int32Regs:i32:$b)
/*19289*/         0, // EndSwitchType
/*19290*/       0, /*End of Scope*/
/*19291*/     0, /*End of Scope*/
/*19292*/   /*SwitchOpcode*/ 116, TARGET_VAL(ISD::SRL),// ->19411
/*19295*/     OPC_RecordChild0, // #0 = $a
/*19296*/     OPC_Scope, 27, /*->19325*/ // 2 children in Scope
/*19298*/       OPC_MoveChild0,
/*19299*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19302*/       OPC_MoveParent,
/*19303*/       OPC_RecordChild1, // #1 = $b
/*19304*/       OPC_MoveChild1,
/*19305*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19308*/       OPC_CheckType, MVT::i32,
/*19310*/       OPC_MoveParent,
/*19311*/       OPC_CheckType, MVT::i32,
/*19313*/       OPC_EmitConvertToTarget, 0,
/*19315*/       OPC_EmitConvertToTarget, 1,
/*19317*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRLi32ii), 0,
                    MVT::i32, 2/*#Ops*/, 2, 3, 
                // Src: (srl:i32 (imm:i32):$a, (imm:i32):$b) - Complexity = 9
                // Dst: (SRLi32ii:i32 (imm:i32):$a, (imm:i32):$b)
/*19325*/     /*Scope*/ 84, /*->19410*/
/*19326*/       OPC_RecordChild1, // #1 = $b
/*19327*/       OPC_Scope, 45, /*->19374*/ // 2 children in Scope
/*19329*/         OPC_MoveChild1,
/*19330*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19333*/         OPC_CheckType, MVT::i32,
/*19335*/         OPC_MoveParent,
/*19336*/         OPC_SwitchType /*3 cases */, 10, MVT::i64,// ->19349
/*19339*/           OPC_EmitConvertToTarget, 1,
/*19341*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRLi64ri), 0,
                        MVT::i64, 2/*#Ops*/, 0, 2, 
                    // Src: (srl:i64 Int64Regs:i64:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (SRLi64ri:i64 Int64Regs:i64:$a, (imm:i32):$b)
/*19349*/         /*SwitchType*/ 10, MVT::i32,// ->19361
/*19351*/           OPC_EmitConvertToTarget, 1,
/*19353*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRLi32ri), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (srl:i32 Int32Regs:i32:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (SRLi32ri:i32 Int32Regs:i32:$a, (imm:i32):$b)
/*19361*/         /*SwitchType*/ 10, MVT::i16,// ->19373
/*19363*/           OPC_EmitConvertToTarget, 1,
/*19365*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRLi16ri), 0,
                        MVT::i16, 2/*#Ops*/, 0, 2, 
                    // Src: (srl:i16 Int16Regs:i16:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (SRLi16ri:i16 Int16Regs:i16:$a, (imm:i32):$b)
/*19373*/         0, // EndSwitchType
/*19374*/       /*Scope*/ 34, /*->19409*/
/*19375*/         OPC_CheckChild1Type, MVT::i32,
/*19377*/         OPC_SwitchType /*3 cases */, 8, MVT::i64,// ->19388
/*19380*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRLi64rr), 0,
                        MVT::i64, 2/*#Ops*/, 0, 1, 
                    // Src: (srl:i64 Int64Regs:i64:$a, Int32Regs:i32:$b) - Complexity = 3
                    // Dst: (SRLi64rr:i64 Int64Regs:i64:$a, Int32Regs:i32:$b)
/*19388*/         /*SwitchType*/ 8, MVT::i32,// ->19398
/*19390*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRLi32rr), 0,
                        MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (srl:i32 Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                    // Dst: (SRLi32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*19398*/         /*SwitchType*/ 8, MVT::i16,// ->19408
/*19400*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SRLi16rr), 0,
                        MVT::i16, 2/*#Ops*/, 0, 1, 
                    // Src: (srl:i16 Int16Regs:i16:$a, Int32Regs:i32:$b) - Complexity = 3
                    // Dst: (SRLi16rr:i16 Int16Regs:i16:$a, Int32Regs:i32:$b)
/*19408*/         0, // EndSwitchType
/*19409*/       0, /*End of Scope*/
/*19410*/     0, /*End of Scope*/
/*19411*/   /*SwitchOpcode*/ 43|128,5/*683*/, TARGET_VAL(ISD::SELECT),// ->20098
/*19415*/     OPC_RecordChild0, // #0 = $p
/*19416*/     OPC_Scope, 64|128,3/*448*/, /*->19867*/ // 2 children in Scope
/*19419*/       OPC_CheckChild0Type, MVT::i1,
/*19421*/       OPC_RecordChild1, // #1 = $a
/*19422*/       OPC_Scope, 58, /*->19482*/ // 16 children in Scope
/*19424*/         OPC_MoveChild1,
/*19425*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19428*/         OPC_MoveParent,
/*19429*/         OPC_RecordChild2, // #2 = $b
/*19430*/         OPC_MoveChild2,
/*19431*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19434*/         OPC_MoveParent,
/*19435*/         OPC_SwitchType /*3 cases */, 13, MVT::i16,// ->19451
/*19438*/           OPC_EmitConvertToTarget, 1,
/*19440*/           OPC_EmitConvertToTarget, 2,
/*19442*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b16ii), 0,
                        MVT::i16, 3/*#Ops*/, 3, 4, 0, 
                    // Src: (select:i16 Int1Regs:i1:$p, (imm:i16):$a, (imm:i16):$b) - Complexity = 9
                    // Dst: (SELP_b16ii:i16 (imm:i16):$a, (imm:i16):$b, Int1Regs:i1:$p)
/*19451*/         /*SwitchType*/ 13, MVT::i32,// ->19466
/*19453*/           OPC_EmitConvertToTarget, 1,
/*19455*/           OPC_EmitConvertToTarget, 2,
/*19457*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b32ii), 0,
                        MVT::i32, 3/*#Ops*/, 3, 4, 0, 
                    // Src: (select:i32 Int1Regs:i1:$p, (imm:i32):$a, (imm:i32):$b) - Complexity = 9
                    // Dst: (SELP_b32ii:i32 (imm:i32):$a, (imm:i32):$b, Int1Regs:i1:$p)
/*19466*/         /*SwitchType*/ 13, MVT::i64,// ->19481
/*19468*/           OPC_EmitConvertToTarget, 1,
/*19470*/           OPC_EmitConvertToTarget, 2,
/*19472*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b64ii), 0,
                        MVT::i64, 3/*#Ops*/, 3, 4, 0, 
                    // Src: (select:i64 Int1Regs:i1:$p, (imm:i64):$a, (imm:i64):$b) - Complexity = 9
                    // Dst: (SELP_b64ii:i64 (imm:i64):$a, (imm:i64):$b, Int1Regs:i1:$p)
/*19481*/         0, // EndSwitchType
/*19482*/       /*Scope*/ 19, /*->19502*/
/*19483*/         OPC_RecordChild2, // #2 = $b
/*19484*/         OPC_MoveChild2,
/*19485*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19488*/         OPC_MoveParent,
/*19489*/         OPC_CheckType, MVT::i16,
/*19491*/         OPC_EmitConvertToTarget, 2,
/*19493*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b16ri), 0,
                      MVT::i16, 3/*#Ops*/, 1, 3, 0, 
                  // Src: (select:i16 Int1Regs:i1:$p, Int16Regs:i16:$a, (imm:i16):$b) - Complexity = 6
                  // Dst: (SELP_b16ri:i16 Int16Regs:i16:$a, (imm:i16):$b, Int1Regs:i1:$p)
/*19502*/       /*Scope*/ 19, /*->19522*/
/*19503*/         OPC_MoveChild1,
/*19504*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19507*/         OPC_MoveParent,
/*19508*/         OPC_RecordChild2, // #2 = $b
/*19509*/         OPC_CheckType, MVT::i16,
/*19511*/         OPC_EmitConvertToTarget, 1,
/*19513*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b16ir), 0,
                      MVT::i16, 3/*#Ops*/, 3, 2, 0, 
                  // Src: (select:i16 Int1Regs:i1:$p, (imm:i16):$a, Int16Regs:i16:$b) - Complexity = 6
                  // Dst: (SELP_b16ir:i16 (imm:i16):$a, Int16Regs:i16:$b, Int1Regs:i1:$p)
/*19522*/       /*Scope*/ 19, /*->19542*/
/*19523*/         OPC_RecordChild2, // #2 = $b
/*19524*/         OPC_MoveChild2,
/*19525*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19528*/         OPC_MoveParent,
/*19529*/         OPC_CheckType, MVT::i32,
/*19531*/         OPC_EmitConvertToTarget, 2,
/*19533*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b32ri), 0,
                      MVT::i32, 3/*#Ops*/, 1, 3, 0, 
                  // Src: (select:i32 Int1Regs:i1:$p, Int32Regs:i32:$a, (imm:i32):$b) - Complexity = 6
                  // Dst: (SELP_b32ri:i32 Int32Regs:i32:$a, (imm:i32):$b, Int1Regs:i1:$p)
/*19542*/       /*Scope*/ 19, /*->19562*/
/*19543*/         OPC_MoveChild1,
/*19544*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19547*/         OPC_MoveParent,
/*19548*/         OPC_RecordChild2, // #2 = $b
/*19549*/         OPC_CheckType, MVT::i32,
/*19551*/         OPC_EmitConvertToTarget, 1,
/*19553*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b32ir), 0,
                      MVT::i32, 3/*#Ops*/, 3, 2, 0, 
                  // Src: (select:i32 Int1Regs:i1:$p, (imm:i32):$a, Int32Regs:i32:$b) - Complexity = 6
                  // Dst: (SELP_b32ir:i32 (imm:i32):$a, Int32Regs:i32:$b, Int1Regs:i1:$p)
/*19562*/       /*Scope*/ 19, /*->19582*/
/*19563*/         OPC_RecordChild2, // #2 = $b
/*19564*/         OPC_MoveChild2,
/*19565*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19568*/         OPC_MoveParent,
/*19569*/         OPC_CheckType, MVT::i64,
/*19571*/         OPC_EmitConvertToTarget, 2,
/*19573*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b64ri), 0,
                      MVT::i64, 3/*#Ops*/, 1, 3, 0, 
                  // Src: (select:i64 Int1Regs:i1:$p, Int64Regs:i64:$a, (imm:i64):$b) - Complexity = 6
                  // Dst: (SELP_b64ri:i64 Int64Regs:i64:$a, (imm:i64):$b, Int1Regs:i1:$p)
/*19582*/       /*Scope*/ 19, /*->19602*/
/*19583*/         OPC_MoveChild1,
/*19584*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*19587*/         OPC_MoveParent,
/*19588*/         OPC_RecordChild2, // #2 = $b
/*19589*/         OPC_CheckType, MVT::i64,
/*19591*/         OPC_EmitConvertToTarget, 1,
/*19593*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b64ir), 0,
                      MVT::i64, 3/*#Ops*/, 3, 2, 0, 
                  // Src: (select:i64 Int1Regs:i1:$p, (imm:i64):$a, Int64Regs:i64:$b) - Complexity = 6
                  // Dst: (SELP_b64ir:i64 (imm:i64):$a, Int64Regs:i64:$b, Int1Regs:i1:$p)
/*19602*/       /*Scope*/ 36, /*->19639*/
/*19603*/         OPC_RecordChild2, // #2 = $b
/*19604*/         OPC_SwitchType /*3 cases */, 9, MVT::i16,// ->19616
/*19607*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b16rr), 0,
                        MVT::i16, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (select:i16 Int1Regs:i1:$p, Int16Regs:i16:$a, Int16Regs:i16:$b) - Complexity = 3
                    // Dst: (SELP_b16rr:i16 Int16Regs:i16:$a, Int16Regs:i16:$b, Int1Regs:i1:$p)
/*19616*/         /*SwitchType*/ 9, MVT::i32,// ->19627
/*19618*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b32rr), 0,
                        MVT::i32, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (select:i32 Int1Regs:i1:$p, Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                    // Dst: (SELP_b32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b, Int1Regs:i1:$p)
/*19627*/         /*SwitchType*/ 9, MVT::i64,// ->19638
/*19629*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b64rr), 0,
                        MVT::i64, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (select:i64 Int1Regs:i1:$p, Int64Regs:i64:$a, Int64Regs:i64:$b) - Complexity = 3
                    // Dst: (SELP_b64rr:i64 Int64Regs:i64:$a, Int64Regs:i64:$b, Int1Regs:i1:$p)
/*19638*/         0, // EndSwitchType
/*19639*/       /*Scope*/ 58, /*->19698*/
/*19640*/         OPC_MoveChild1,
/*19641*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19644*/         OPC_MoveParent,
/*19645*/         OPC_RecordChild2, // #2 = $b
/*19646*/         OPC_MoveChild2,
/*19647*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19650*/         OPC_MoveParent,
/*19651*/         OPC_SwitchType /*3 cases */, 13, MVT::f16,// ->19667
/*19654*/           OPC_EmitConvertToTarget, 1,
/*19656*/           OPC_EmitConvertToTarget, 2,
/*19658*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f16ii), 0,
                        MVT::f16, 3/*#Ops*/, 3, 4, 0, 
                    // Src: (select:f16 Int1Regs:i1:$p, (fpimm:f16):$a, (fpimm:f16):$b) - Complexity = 9
                    // Dst: (SELP_f16ii:f16 (fpimm:f16):$a, (fpimm:f16):$b, Int1Regs:i1:$p)
/*19667*/         /*SwitchType*/ 13, MVT::f32,// ->19682
/*19669*/           OPC_EmitConvertToTarget, 1,
/*19671*/           OPC_EmitConvertToTarget, 2,
/*19673*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f32ii), 0,
                        MVT::f32, 3/*#Ops*/, 3, 4, 0, 
                    // Src: (select:f32 Int1Regs:i1:$p, (fpimm:f32):$a, (fpimm:f32):$b) - Complexity = 9
                    // Dst: (SELP_f32ii:f32 (fpimm:f32):$a, (fpimm:f32):$b, Int1Regs:i1:$p)
/*19682*/         /*SwitchType*/ 13, MVT::f64,// ->19697
/*19684*/           OPC_EmitConvertToTarget, 1,
/*19686*/           OPC_EmitConvertToTarget, 2,
/*19688*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f64ii), 0,
                        MVT::f64, 3/*#Ops*/, 3, 4, 0, 
                    // Src: (select:f64 Int1Regs:i1:$p, (fpimm:f64):$a, (fpimm:f64):$b) - Complexity = 9
                    // Dst: (SELP_f64ii:f64 (fpimm:f64):$a, (fpimm:f64):$b, Int1Regs:i1:$p)
/*19697*/         0, // EndSwitchType
/*19698*/       /*Scope*/ 19, /*->19718*/
/*19699*/         OPC_RecordChild2, // #2 = $b
/*19700*/         OPC_MoveChild2,
/*19701*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19704*/         OPC_MoveParent,
/*19705*/         OPC_CheckType, MVT::f16,
/*19707*/         OPC_EmitConvertToTarget, 2,
/*19709*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f16ri), 0,
                      MVT::f16, 3/*#Ops*/, 1, 3, 0, 
                  // Src: (select:f16 Int1Regs:i1:$p, Float16Regs:f16:$a, (fpimm:f16):$b) - Complexity = 6
                  // Dst: (SELP_f16ri:f16 Float16Regs:f16:$a, (fpimm:f16):$b, Int1Regs:i1:$p)
/*19718*/       /*Scope*/ 19, /*->19738*/
/*19719*/         OPC_MoveChild1,
/*19720*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19723*/         OPC_MoveParent,
/*19724*/         OPC_RecordChild2, // #2 = $b
/*19725*/         OPC_CheckType, MVT::f16,
/*19727*/         OPC_EmitConvertToTarget, 1,
/*19729*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f16ir), 0,
                      MVT::f16, 3/*#Ops*/, 3, 2, 0, 
                  // Src: (select:f16 Int1Regs:i1:$p, (fpimm:f16):$a, Float16Regs:f16:$b) - Complexity = 6
                  // Dst: (SELP_f16ir:f16 (fpimm:f16):$a, Float16Regs:f16:$b, Int1Regs:i1:$p)
/*19738*/       /*Scope*/ 19, /*->19758*/
/*19739*/         OPC_RecordChild2, // #2 = $b
/*19740*/         OPC_MoveChild2,
/*19741*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19744*/         OPC_MoveParent,
/*19745*/         OPC_CheckType, MVT::f32,
/*19747*/         OPC_EmitConvertToTarget, 2,
/*19749*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f32ri), 0,
                      MVT::f32, 3/*#Ops*/, 1, 3, 0, 
                  // Src: (select:f32 Int1Regs:i1:$p, Float32Regs:f32:$a, (fpimm:f32):$b) - Complexity = 6
                  // Dst: (SELP_f32ri:f32 Float32Regs:f32:$a, (fpimm:f32):$b, Int1Regs:i1:$p)
/*19758*/       /*Scope*/ 19, /*->19778*/
/*19759*/         OPC_MoveChild1,
/*19760*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19763*/         OPC_MoveParent,
/*19764*/         OPC_RecordChild2, // #2 = $b
/*19765*/         OPC_CheckType, MVT::f32,
/*19767*/         OPC_EmitConvertToTarget, 1,
/*19769*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f32ir), 0,
                      MVT::f32, 3/*#Ops*/, 3, 2, 0, 
                  // Src: (select:f32 Int1Regs:i1:$p, (fpimm:f32):$a, Float32Regs:f32:$b) - Complexity = 6
                  // Dst: (SELP_f32ir:f32 (fpimm:f32):$a, Float32Regs:f32:$b, Int1Regs:i1:$p)
/*19778*/       /*Scope*/ 19, /*->19798*/
/*19779*/         OPC_RecordChild2, // #2 = $b
/*19780*/         OPC_MoveChild2,
/*19781*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19784*/         OPC_MoveParent,
/*19785*/         OPC_CheckType, MVT::f64,
/*19787*/         OPC_EmitConvertToTarget, 2,
/*19789*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f64ri), 0,
                      MVT::f64, 3/*#Ops*/, 1, 3, 0, 
                  // Src: (select:f64 Int1Regs:i1:$p, Float64Regs:f64:$a, (fpimm:f64):$b) - Complexity = 6
                  // Dst: (SELP_f64ri:f64 Float64Regs:f64:$a, (fpimm:f64):$b, Int1Regs:i1:$p)
/*19798*/       /*Scope*/ 19, /*->19818*/
/*19799*/         OPC_MoveChild1,
/*19800*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*19803*/         OPC_MoveParent,
/*19804*/         OPC_RecordChild2, // #2 = $b
/*19805*/         OPC_CheckType, MVT::f64,
/*19807*/         OPC_EmitConvertToTarget, 1,
/*19809*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f64ir), 0,
                      MVT::f64, 3/*#Ops*/, 3, 2, 0, 
                  // Src: (select:f64 Int1Regs:i1:$p, (fpimm:f64):$a, Float64Regs:f64:$b) - Complexity = 6
                  // Dst: (SELP_f64ir:f64 (fpimm:f64):$a, Float64Regs:f64:$b, Int1Regs:i1:$p)
/*19818*/       /*Scope*/ 47, /*->19866*/
/*19819*/         OPC_RecordChild2, // #2 = $b
/*19820*/         OPC_SwitchType /*4 cases */, 9, MVT::f16,// ->19832
/*19823*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f16rr), 0,
                        MVT::f16, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (select:f16 Int1Regs:i1:$p, Float16Regs:f16:$a, Float16Regs:f16:$b) - Complexity = 3
                    // Dst: (SELP_f16rr:f16 Float16Regs:f16:$a, Float16Regs:f16:$b, Int1Regs:i1:$p)
/*19832*/         /*SwitchType*/ 9, MVT::f32,// ->19843
/*19834*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f32rr), 0,
                        MVT::f32, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (select:f32 Int1Regs:i1:$p, Float32Regs:f32:$a, Float32Regs:f32:$b) - Complexity = 3
                    // Dst: (SELP_f32rr:f32 Float32Regs:f32:$a, Float32Regs:f32:$b, Int1Regs:i1:$p)
/*19843*/         /*SwitchType*/ 9, MVT::f64,// ->19854
/*19845*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f64rr), 0,
                        MVT::f64, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (select:f64 Int1Regs:i1:$p, Float64Regs:f64:$a, Float64Regs:f64:$b) - Complexity = 3
                    // Dst: (SELP_f64rr:f64 Float64Regs:f64:$a, Float64Regs:f64:$b, Int1Regs:i1:$p)
/*19854*/         /*SwitchType*/ 9, MVT::v2f16,// ->19865
/*19856*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f16x2rr), 0,
                        MVT::v2f16, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (select:v2f16 Int1Regs:i1:$p, Float16x2Regs:v2f16:$a, Float16x2Regs:v2f16:$b) - Complexity = 3
                    // Dst: (SELP_f16x2rr:v2f16 Float16x2Regs:v2f16:$a, Float16x2Regs:v2f16:$b, Int1Regs:i1:$p)
/*19865*/         0, // EndSwitchType
/*19866*/       0, /*End of Scope*/
/*19867*/     /*Scope*/ 100|128,1/*228*/, /*->20097*/
/*19869*/       OPC_CheckChild0Type, MVT::i32,
/*19871*/       OPC_RecordChild1, // #1 = $a
/*19872*/       OPC_RecordChild2, // #2 = $b
/*19873*/       OPC_SwitchType /*6 cases */, 35, MVT::i16,// ->19911
/*19876*/         OPC_EmitInteger, MVT::i32, 1, 
/*19879*/         OPC_EmitNode1, TARGET_VAL(NVPTX::ANDb32ri), 0,
                      MVT::i32, 2/*#Ops*/, 0, 3,  // Results = #4
/*19887*/         OPC_EmitInteger, MVT::i32, 1, 
/*19890*/         OPC_EmitInteger, MVT::i32, 0, 
/*19893*/         OPC_EmitNode1, TARGET_VAL(NVPTX::SETP_b32ri), 0,
                      MVT::i1, 3/*#Ops*/, 4, 5, 6,  // Results = #7
/*19902*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b16rr), 0,
                      MVT::i16, 3/*#Ops*/, 1, 2, 7, 
                  // Src: (select:i16 Int32Regs:i32:$pred, Int16Regs:i16:$a, Int16Regs:i16:$b) - Complexity = 3
                  // Dst: (SELP_b16rr:i16 Int16Regs:i16:$a, Int16Regs:i16:$b, (SETP_b32ri:i1 (ANDb32ri:i32 Int32Regs:i32:$pred, 1:i32), 1:i32, 0:i32))
/*19911*/       /*SwitchType*/ 35, MVT::i32,// ->19948
/*19913*/         OPC_EmitInteger, MVT::i32, 1, 
/*19916*/         OPC_EmitNode1, TARGET_VAL(NVPTX::ANDb32ri), 0,
                      MVT::i32, 2/*#Ops*/, 0, 3,  // Results = #4
/*19924*/         OPC_EmitInteger, MVT::i32, 1, 
/*19927*/         OPC_EmitInteger, MVT::i32, 0, 
/*19930*/         OPC_EmitNode1, TARGET_VAL(NVPTX::SETP_b32ri), 0,
                      MVT::i1, 3/*#Ops*/, 4, 5, 6,  // Results = #7
/*19939*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b32rr), 0,
                      MVT::i32, 3/*#Ops*/, 1, 2, 7, 
                  // Src: (select:i32 Int32Regs:i32:$pred, Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                  // Dst: (SELP_b32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b, (SETP_b32ri:i1 (ANDb32ri:i32 Int32Regs:i32:$pred, 1:i32), 1:i32, 0:i32))
/*19948*/       /*SwitchType*/ 35, MVT::i64,// ->19985
/*19950*/         OPC_EmitInteger, MVT::i32, 1, 
/*19953*/         OPC_EmitNode1, TARGET_VAL(NVPTX::ANDb32ri), 0,
                      MVT::i32, 2/*#Ops*/, 0, 3,  // Results = #4
/*19961*/         OPC_EmitInteger, MVT::i32, 1, 
/*19964*/         OPC_EmitInteger, MVT::i32, 0, 
/*19967*/         OPC_EmitNode1, TARGET_VAL(NVPTX::SETP_b32ri), 0,
                      MVT::i1, 3/*#Ops*/, 4, 5, 6,  // Results = #7
/*19976*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_b64rr), 0,
                      MVT::i64, 3/*#Ops*/, 1, 2, 7, 
                  // Src: (select:i64 Int32Regs:i32:$pred, Int64Regs:i64:$a, Int64Regs:i64:$b) - Complexity = 3
                  // Dst: (SELP_b64rr:i64 Int64Regs:i64:$a, Int64Regs:i64:$b, (SETP_b32ri:i1 (ANDb32ri:i32 Int32Regs:i32:$pred, 1:i32), 1:i32, 0:i32))
/*19985*/       /*SwitchType*/ 35, MVT::f16,// ->20022
/*19987*/         OPC_EmitInteger, MVT::i32, 1, 
/*19990*/         OPC_EmitNode1, TARGET_VAL(NVPTX::ANDb32ri), 0,
                      MVT::i32, 2/*#Ops*/, 0, 3,  // Results = #4
/*19998*/         OPC_EmitInteger, MVT::i32, 1, 
/*20001*/         OPC_EmitInteger, MVT::i32, 0, 
/*20004*/         OPC_EmitNode1, TARGET_VAL(NVPTX::SETP_b32ri), 0,
                      MVT::i1, 3/*#Ops*/, 4, 5, 6,  // Results = #7
/*20013*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f16rr), 0,
                      MVT::f16, 3/*#Ops*/, 1, 2, 7, 
                  // Src: (select:f16 Int32Regs:i32:$pred, Float16Regs:f16:$a, Float16Regs:f16:$b) - Complexity = 3
                  // Dst: (SELP_f16rr:f16 Float16Regs:f16:$a, Float16Regs:f16:$b, (SETP_b32ri:i1 (ANDb32ri:i32 Int32Regs:i32:$pred, 1:i32), 1:i32, 0:i32))
/*20022*/       /*SwitchType*/ 35, MVT::f32,// ->20059
/*20024*/         OPC_EmitInteger, MVT::i32, 1, 
/*20027*/         OPC_EmitNode1, TARGET_VAL(NVPTX::ANDb32ri), 0,
                      MVT::i32, 2/*#Ops*/, 0, 3,  // Results = #4
/*20035*/         OPC_EmitInteger, MVT::i32, 1, 
/*20038*/         OPC_EmitInteger, MVT::i32, 0, 
/*20041*/         OPC_EmitNode1, TARGET_VAL(NVPTX::SETP_b32ri), 0,
                      MVT::i1, 3/*#Ops*/, 4, 5, 6,  // Results = #7
/*20050*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f32rr), 0,
                      MVT::f32, 3/*#Ops*/, 1, 2, 7, 
                  // Src: (select:f32 Int32Regs:i32:$pred, Float32Regs:f32:$a, Float32Regs:f32:$b) - Complexity = 3
                  // Dst: (SELP_f32rr:f32 Float32Regs:f32:$a, Float32Regs:f32:$b, (SETP_b32ri:i1 (ANDb32ri:i32 Int32Regs:i32:$pred, 1:i32), 1:i32, 0:i32))
/*20059*/       /*SwitchType*/ 35, MVT::f64,// ->20096
/*20061*/         OPC_EmitInteger, MVT::i32, 1, 
/*20064*/         OPC_EmitNode1, TARGET_VAL(NVPTX::ANDb32ri), 0,
                      MVT::i32, 2/*#Ops*/, 0, 3,  // Results = #4
/*20072*/         OPC_EmitInteger, MVT::i32, 1, 
/*20075*/         OPC_EmitInteger, MVT::i32, 0, 
/*20078*/         OPC_EmitNode1, TARGET_VAL(NVPTX::SETP_b32ri), 0,
                      MVT::i1, 3/*#Ops*/, 4, 5, 6,  // Results = #7
/*20087*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SELP_f64rr), 0,
                      MVT::f64, 3/*#Ops*/, 1, 2, 7, 
                  // Src: (select:f64 Int32Regs:i32:$pred, Float64Regs:f64:$a, Float64Regs:f64:$b) - Complexity = 3
                  // Dst: (SELP_f64rr:f64 Float64Regs:f64:$a, Float64Regs:f64:$b, (SETP_b32ri:i1 (ANDb32ri:i32 Int32Regs:i32:$pred, 1:i32), 1:i32, 0:i32))
/*20096*/       0, // EndSwitchType
/*20097*/     0, /*End of Scope*/
/*20098*/   /*SwitchOpcode*/ 29, TARGET_VAL(ISD::FrameIndex),// ->20130
/*20101*/     OPC_RecordNode, // #0 = $addr
/*20102*/     OPC_SwitchType /*2 cases */, 11, MVT::i32,// ->20116
/*20105*/       OPC_CheckComplexPat, /*CP*/0, /*#*/0, // SelectADDRri:$addr #1 #2
/*20108*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::LEA_ADDRi), 0,
                    MVT::i32, 2/*#Ops*/, 1, 2, 
                // Src: ADDRri:i32:$addr - Complexity = 9
                // Dst: (LEA_ADDRi:i32 ADDRri:i32:$addr)
/*20116*/     /*SwitchType*/ 11, MVT::i64,// ->20129
/*20118*/       OPC_CheckComplexPat, /*CP*/1, /*#*/0, // SelectADDRri64:$addr #1 #2
/*20121*/       OPC_MorphNodeTo1, TARGET_VAL(NVPTX::LEA_ADDRi64), 0,
                    MVT::i64, 2/*#Ops*/, 1, 2, 
                // Src: ADDRri64:i64:$addr - Complexity = 9
                // Dst: (LEA_ADDRi64:i64 ADDRri64:i64:$addr)
/*20129*/     0, // EndSwitchType
/*20130*/   /*SwitchOpcode*/ 47, TARGET_VAL(NVPTXISD::CallVoid),// ->20180
/*20133*/     OPC_RecordNode, // #0 = 'CallVoid' chained node
/*20134*/     OPC_CaptureGlueInput,
/*20135*/     OPC_Scope, 18, /*->20155*/ // 2 children in Scope
/*20137*/       OPC_MoveChild1,
/*20138*/       OPC_CheckOpcode, TARGET_VAL(NVPTXISD::Wrapper),
/*20141*/       OPC_RecordChild0, // #1 = $addr
/*20142*/       OPC_MoveChild0,
/*20143*/       OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*20146*/       OPC_MoveParent,
/*20147*/       OPC_MoveParent,
/*20148*/       OPC_EmitMergeInputChains1_0,
/*20149*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallVoidInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    1/*#Ops*/, 1, 
                // Src: (CallVoid (Wrapper:iPTR (tglobaladdr:iPTR):$addr)) - Complexity = 9
                // Dst: (CallVoidInst (tglobaladdr:iPTR):$addr)
/*20155*/     /*Scope*/ 23, /*->20179*/
/*20156*/       OPC_RecordChild1, // #1 = $addr
/*20157*/       OPC_Scope, 9, /*->20168*/ // 2 children in Scope
/*20159*/         OPC_CheckChild1Type, MVT::i32,
/*20161*/         OPC_EmitMergeInputChains1_0,
/*20162*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallVoidInstReg), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (CallVoid Int32Regs:i32:$addr) - Complexity = 3
                  // Dst: (CallVoidInstReg Int32Regs:i32:$addr)
/*20168*/       /*Scope*/ 9, /*->20178*/
/*20169*/         OPC_CheckChild1Type, MVT::i64,
/*20171*/         OPC_EmitMergeInputChains1_0,
/*20172*/         OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallVoidInstReg64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                      1/*#Ops*/, 1, 
                  // Src: (CallVoid Int64Regs:i64:$addr) - Complexity = 3
                  // Dst: (CallVoidInstReg64 Int64Regs:i64:$addr)
/*20178*/       0, /*End of Scope*/
/*20179*/     0, /*End of Scope*/
/*20180*/   /*SwitchOpcode*/ 21, TARGET_VAL(ISD::CALLSEQ_START),// ->20204
/*20183*/     OPC_RecordNode, // #0 = 'callseq_start' chained node
/*20184*/     OPC_RecordChild1, // #1 = $amt1
/*20185*/     OPC_MoveChild1,
/*20186*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*20189*/     OPC_MoveParent,
/*20190*/     OPC_RecordChild2, // #2 = $amt2
/*20191*/     OPC_MoveChild2,
/*20192*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*20195*/     OPC_MoveParent,
/*20196*/     OPC_EmitMergeInputChains1_0,
/*20197*/     OPC_MorphNodeTo0, TARGET_VAL(NVPTX::Callseq_Start), 0|OPFL_Chain|OPFL_GlueOutput,
                  2/*#Ops*/, 1, 2, 
              // Src: (callseq_start (timm:i32):$amt1, (timm:i32):$amt2) - Complexity = 9
              // Dst: (Callseq_Start (timm:i32):$amt1, (timm:i32):$amt2)
/*20204*/   /*SwitchOpcode*/ 22, TARGET_VAL(ISD::CALLSEQ_END),// ->20229
/*20207*/     OPC_RecordNode, // #0 = 'callseq_end' chained node
/*20208*/     OPC_CaptureGlueInput,
/*20209*/     OPC_RecordChild1, // #1 = $amt1
/*20210*/     OPC_MoveChild1,
/*20211*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*20214*/     OPC_MoveParent,
/*20215*/     OPC_RecordChild2, // #2 = $amt2
/*20216*/     OPC_MoveChild2,
/*20217*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*20220*/     OPC_MoveParent,
/*20221*/     OPC_EmitMergeInputChains1_0,
/*20222*/     OPC_MorphNodeTo0, TARGET_VAL(NVPTX::Callseq_End), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                  2/*#Ops*/, 1, 2, 
              // Src: (callseq_end (timm:i32):$amt1, (timm:i32):$amt2) - Complexity = 9
              // Dst: (Callseq_End (timm:i32):$amt1, (timm:i32):$amt2)
/*20229*/   /*SwitchOpcode*/ 12|128,1/*140*/, TARGET_VAL(ISD::SUB),// ->20373
/*20233*/     OPC_Scope, 32, /*->20267*/ // 2 children in Scope
/*20235*/       OPC_CheckChild0Integer, 0, 
/*20237*/       OPC_RecordChild1, // #0 = $src
/*20238*/       OPC_SwitchType /*3 cases */, 7, MVT::i16,// ->20248
/*20241*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INEG16), 0,
                      MVT::i16, 1/*#Ops*/, 0, 
                  // Src: (sub:i16 0:i16, Int16Regs:i16:$src) - Complexity = 8
                  // Dst: (INEG16:i16 Int16Regs:i16:$src)
/*20248*/       /*SwitchType*/ 7, MVT::i32,// ->20257
/*20250*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INEG32), 0,
                      MVT::i32, 1/*#Ops*/, 0, 
                  // Src: (sub:i32 0:i32, Int32Regs:i32:$src) - Complexity = 8
                  // Dst: (INEG32:i32 Int32Regs:i32:$src)
/*20257*/       /*SwitchType*/ 7, MVT::i64,// ->20266
/*20259*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INEG64), 0,
                      MVT::i64, 1/*#Ops*/, 0, 
                  // Src: (sub:i64 0:i64, Int64Regs:i64:$src) - Complexity = 8
                  // Dst: (INEG64:i64 Int64Regs:i64:$src)
/*20266*/       0, // EndSwitchType
/*20267*/     /*Scope*/ 104, /*->20372*/
/*20268*/       OPC_RecordChild0, // #0 = $a
/*20269*/       OPC_RecordChild1, // #1 = $b
/*20270*/       OPC_Scope, 55, /*->20327*/ // 5 children in Scope
/*20272*/         OPC_MoveChild1,
/*20273*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*20276*/         OPC_MoveParent,
/*20277*/         OPC_SwitchType /*4 cases */, 10, MVT::i1,// ->20290
/*20280*/           OPC_EmitConvertToTarget, 1,
/*20282*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUB_i1_ri), 0,
                        MVT::i1, 2/*#Ops*/, 0, 2, 
                    // Src: (sub:i1 Int1Regs:i1:$a, (imm:i1):$b) - Complexity = 6
                    // Dst: (SUB_i1_ri:i1 Int1Regs:i1:$a, (imm:i1):$b)
/*20290*/         /*SwitchType*/ 10, MVT::i64,// ->20302
/*20292*/           OPC_EmitConvertToTarget, 1,
/*20294*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUBi64ri), 0,
                        MVT::i64, 2/*#Ops*/, 0, 2, 
                    // Src: (sub:i64 Int64Regs:i64:$a, (imm:i64):$b) - Complexity = 6
                    // Dst: (SUBi64ri:i64 Int64Regs:i64:$a, (imm:i64):$b)
/*20302*/         /*SwitchType*/ 10, MVT::i32,// ->20314
/*20304*/           OPC_EmitConvertToTarget, 1,
/*20306*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUBi32ri), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (sub:i32 Int32Regs:i32:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (SUBi32ri:i32 Int32Regs:i32:$a, (imm:i32):$b)
/*20314*/         /*SwitchType*/ 10, MVT::i16,// ->20326
/*20316*/           OPC_EmitConvertToTarget, 1,
/*20318*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUBi16ri), 0,
                        MVT::i16, 2/*#Ops*/, 0, 2, 
                    // Src: (sub:i16 Int16Regs:i16:$a, (imm:i16):$b) - Complexity = 6
                    // Dst: (SUBi16ri:i16 Int16Regs:i16:$a, (imm:i16):$b)
/*20326*/         0, // EndSwitchType
/*20327*/       /*Scope*/ 10, /*->20338*/
/*20328*/         OPC_CheckType, MVT::i1,
/*20330*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUB_i1_rr), 0,
                      MVT::i1, 2/*#Ops*/, 0, 1, 
                  // Src: (sub:i1 Int1Regs:i1:$a, Int1Regs:i1:$b) - Complexity = 3
                  // Dst: (SUB_i1_rr:i1 Int1Regs:i1:$a, Int1Regs:i1:$b)
/*20338*/       /*Scope*/ 10, /*->20349*/
/*20339*/         OPC_CheckType, MVT::i64,
/*20341*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUBi64rr), 0,
                      MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (sub:i64 Int64Regs:i64:$a, Int64Regs:i64:$b) - Complexity = 3
                  // Dst: (SUBi64rr:i64 Int64Regs:i64:$a, Int64Regs:i64:$b)
/*20349*/       /*Scope*/ 10, /*->20360*/
/*20350*/         OPC_CheckType, MVT::i32,
/*20352*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUBi32rr), 0,
                      MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (sub:i32 Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                  // Dst: (SUBi32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*20360*/       /*Scope*/ 10, /*->20371*/
/*20361*/         OPC_CheckType, MVT::i16,
/*20363*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::SUBi16rr), 0,
                      MVT::i16, 2/*#Ops*/, 0, 1, 
                  // Src: (sub:i16 Int16Regs:i16:$a, Int16Regs:i16:$b) - Complexity = 3
                  // Dst: (SUBi16rr:i16 Int16Regs:i16:$a, Int16Regs:i16:$b)
/*20371*/       0, /*End of Scope*/
/*20372*/     0, /*End of Scope*/
/*20373*/   /*SwitchOpcode*/ 29|128,1/*157*/, TARGET_VAL(ISD::XOR),// ->20534
/*20377*/     OPC_RecordChild0, // #0 = $src
/*20378*/     OPC_Scope, 49, /*->20429*/ // 2 children in Scope
/*20380*/       OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20391*/       OPC_SwitchType /*4 cases */, 7, MVT::i1,// ->20401
/*20394*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::NOT1), 0,
                      MVT::i1, 1/*#Ops*/, 0, 
                  // Src: (xor:i1 Int1Regs:i1:$src, -1:i1) - Complexity = 8
                  // Dst: (NOT1:i1 Int1Regs:i1:$src)
/*20401*/       /*SwitchType*/ 7, MVT::i16,// ->20410
/*20403*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::NOT16), 0,
                      MVT::i16, 1/*#Ops*/, 0, 
                  // Src: (xor:i16 Int16Regs:i16:$src, -1:i16) - Complexity = 8
                  // Dst: (NOT16:i16 Int16Regs:i16:$src)
/*20410*/       /*SwitchType*/ 7, MVT::i32,// ->20419
/*20412*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::NOT32), 0,
                      MVT::i32, 1/*#Ops*/, 0, 
                  // Src: (xor:i32 Int32Regs:i32:$src, -1:i32) - Complexity = 8
                  // Dst: (NOT32:i32 Int32Regs:i32:$src)
/*20419*/       /*SwitchType*/ 7, MVT::i64,// ->20428
/*20421*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::NOT64), 0,
                      MVT::i64, 1/*#Ops*/, 0, 
                  // Src: (xor:i64 Int64Regs:i64:$src, -1:i64) - Complexity = 8
                  // Dst: (NOT64:i64 Int64Regs:i64:$src)
/*20428*/       0, // EndSwitchType
/*20429*/     /*Scope*/ 103, /*->20533*/
/*20430*/       OPC_RecordChild1, // #1 = $b
/*20431*/       OPC_Scope, 55, /*->20488*/ // 5 children in Scope
/*20433*/         OPC_MoveChild1,
/*20434*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*20437*/         OPC_MoveParent,
/*20438*/         OPC_SwitchType /*4 cases */, 10, MVT::i1,// ->20451
/*20441*/           OPC_EmitConvertToTarget, 1,
/*20443*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb1ri), 0,
                        MVT::i1, 2/*#Ops*/, 0, 2, 
                    // Src: (xor:i1 Int1Regs:i1:$a, (imm:i1):$b) - Complexity = 6
                    // Dst: (XORb1ri:i1 Int1Regs:i1:$a, (imm:i1):$b)
/*20451*/         /*SwitchType*/ 10, MVT::i16,// ->20463
/*20453*/           OPC_EmitConvertToTarget, 1,
/*20455*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb16ri), 0,
                        MVT::i16, 2/*#Ops*/, 0, 2, 
                    // Src: (xor:i16 Int16Regs:i16:$a, (imm:i16):$b) - Complexity = 6
                    // Dst: (XORb16ri:i16 Int16Regs:i16:$a, (imm:i16):$b)
/*20463*/         /*SwitchType*/ 10, MVT::i32,// ->20475
/*20465*/           OPC_EmitConvertToTarget, 1,
/*20467*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb32ri), 0,
                        MVT::i32, 2/*#Ops*/, 0, 2, 
                    // Src: (xor:i32 Int32Regs:i32:$a, (imm:i32):$b) - Complexity = 6
                    // Dst: (XORb32ri:i32 Int32Regs:i32:$a, (imm:i32):$b)
/*20475*/         /*SwitchType*/ 10, MVT::i64,// ->20487
/*20477*/           OPC_EmitConvertToTarget, 1,
/*20479*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb64ri), 0,
                        MVT::i64, 2/*#Ops*/, 0, 2, 
                    // Src: (xor:i64 Int64Regs:i64:$a, (imm:i64):$b) - Complexity = 6
                    // Dst: (XORb64ri:i64 Int64Regs:i64:$a, (imm:i64):$b)
/*20487*/         0, // EndSwitchType
/*20488*/       /*Scope*/ 10, /*->20499*/
/*20489*/         OPC_CheckType, MVT::i1,
/*20491*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb1rr), 0,
                      MVT::i1, 2/*#Ops*/, 0, 1, 
                  // Src: (xor:i1 Int1Regs:i1:$a, Int1Regs:i1:$b) - Complexity = 3
                  // Dst: (XORb1rr:i1 Int1Regs:i1:$a, Int1Regs:i1:$b)
/*20499*/       /*Scope*/ 10, /*->20510*/
/*20500*/         OPC_CheckType, MVT::i16,
/*20502*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb16rr), 0,
                      MVT::i16, 2/*#Ops*/, 0, 1, 
                  // Src: (xor:i16 Int16Regs:i16:$a, Int16Regs:i16:$b) - Complexity = 3
                  // Dst: (XORb16rr:i16 Int16Regs:i16:$a, Int16Regs:i16:$b)
/*20510*/       /*Scope*/ 10, /*->20521*/
/*20511*/         OPC_CheckType, MVT::i32,
/*20513*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb32rr), 0,
                      MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (xor:i32 Int32Regs:i32:$a, Int32Regs:i32:$b) - Complexity = 3
                  // Dst: (XORb32rr:i32 Int32Regs:i32:$a, Int32Regs:i32:$b)
/*20521*/       /*Scope*/ 10, /*->20532*/
/*20522*/         OPC_CheckType, MVT::i64,
/*20524*/         OPC_MorphNodeTo1, TARGET_VAL(NVPTX::XORb64rr), 0,
                      MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (xor:i64 Int64Regs:i64:$a, Int64Regs:i64:$b) - Complexity = 3
                  // Dst: (XORb64rr:i64 Int64Regs:i64:$a, Int64Regs:i64:$b)
/*20532*/       0, /*End of Scope*/
/*20533*/     0, /*End of Scope*/
/*20534*/   /*SwitchOpcode*/ 103, TARGET_VAL(NVPTXISD::PrintCall),// ->20640
/*20537*/     OPC_RecordNode, // #0 = 'PrintCall' chained node
/*20538*/     OPC_CaptureGlueInput,
/*20539*/     OPC_Scope, 10, /*->20551*/ // 9 children in Scope
/*20541*/       OPC_CheckChild1Integer, 0, 
/*20543*/       OPC_CheckChild1Type, MVT::i32,
/*20545*/       OPC_EmitMergeInputChains1_0,
/*20546*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallNoRetInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 0:i32) - Complexity = 8
                // Dst: (CallPrintCallNoRetInst)
/*20551*/     /*Scope*/ 10, /*->20562*/
/*20552*/       OPC_CheckChild1Integer, 1, 
/*20554*/       OPC_CheckChild1Type, MVT::i32,
/*20556*/       OPC_EmitMergeInputChains1_0,
/*20557*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst1), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 1:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst1)
/*20562*/     /*Scope*/ 10, /*->20573*/
/*20563*/       OPC_CheckChild1Integer, 2, 
/*20565*/       OPC_CheckChild1Type, MVT::i32,
/*20567*/       OPC_EmitMergeInputChains1_0,
/*20568*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst2), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 2:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst2)
/*20573*/     /*Scope*/ 10, /*->20584*/
/*20574*/       OPC_CheckChild1Integer, 3, 
/*20576*/       OPC_CheckChild1Type, MVT::i32,
/*20578*/       OPC_EmitMergeInputChains1_0,
/*20579*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst3), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 3:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst3)
/*20584*/     /*Scope*/ 10, /*->20595*/
/*20585*/       OPC_CheckChild1Integer, 4, 
/*20587*/       OPC_CheckChild1Type, MVT::i32,
/*20589*/       OPC_EmitMergeInputChains1_0,
/*20590*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst4), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 4:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst4)
/*20595*/     /*Scope*/ 10, /*->20606*/
/*20596*/       OPC_CheckChild1Integer, 5, 
/*20598*/       OPC_CheckChild1Type, MVT::i32,
/*20600*/       OPC_EmitMergeInputChains1_0,
/*20601*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst5), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 5:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst5)
/*20606*/     /*Scope*/ 10, /*->20617*/
/*20607*/       OPC_CheckChild1Integer, 6, 
/*20609*/       OPC_CheckChild1Type, MVT::i32,
/*20611*/       OPC_EmitMergeInputChains1_0,
/*20612*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst6), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 6:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst6)
/*20617*/     /*Scope*/ 10, /*->20628*/
/*20618*/       OPC_CheckChild1Integer, 7, 
/*20620*/       OPC_CheckChild1Type, MVT::i32,
/*20622*/       OPC_EmitMergeInputChains1_0,
/*20623*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst7), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 7:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst7)
/*20628*/     /*Scope*/ 10, /*->20639*/
/*20629*/       OPC_CheckChild1Integer, 8, 
/*20631*/       OPC_CheckChild1Type, MVT::i32,
/*20633*/       OPC_EmitMergeInputChains1_0,
/*20634*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallPrintCallRetInst8), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCall 8:i32) - Complexity = 8
                // Dst: (CallPrintCallRetInst8)
/*20639*/     0, /*End of Scope*/
/*20640*/   /*SwitchOpcode*/ 103, TARGET_VAL(NVPTXISD::PrintCallUni),// ->20746
/*20643*/     OPC_RecordNode, // #0 = 'PrintCallUni' chained node
/*20644*/     OPC_CaptureGlueInput,
/*20645*/     OPC_Scope, 10, /*->20657*/ // 9 children in Scope
/*20647*/       OPC_CheckChild1Integer, 0, 
/*20649*/       OPC_CheckChild1Type, MVT::i32,
/*20651*/       OPC_EmitMergeInputChains1_0,
/*20652*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallNoRetInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 0:i32) - Complexity = 8
                // Dst: (CallUniPrintCallNoRetInst)
/*20657*/     /*Scope*/ 10, /*->20668*/
/*20658*/       OPC_CheckChild1Integer, 1, 
/*20660*/       OPC_CheckChild1Type, MVT::i32,
/*20662*/       OPC_EmitMergeInputChains1_0,
/*20663*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst1), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 1:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst1)
/*20668*/     /*Scope*/ 10, /*->20679*/
/*20669*/       OPC_CheckChild1Integer, 2, 
/*20671*/       OPC_CheckChild1Type, MVT::i32,
/*20673*/       OPC_EmitMergeInputChains1_0,
/*20674*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst2), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 2:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst2)
/*20679*/     /*Scope*/ 10, /*->20690*/
/*20680*/       OPC_CheckChild1Integer, 3, 
/*20682*/       OPC_CheckChild1Type, MVT::i32,
/*20684*/       OPC_EmitMergeInputChains1_0,
/*20685*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst3), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 3:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst3)
/*20690*/     /*Scope*/ 10, /*->20701*/
/*20691*/       OPC_CheckChild1Integer, 4, 
/*20693*/       OPC_CheckChild1Type, MVT::i32,
/*20695*/       OPC_EmitMergeInputChains1_0,
/*20696*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst4), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 4:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst4)
/*20701*/     /*Scope*/ 10, /*->20712*/
/*20702*/       OPC_CheckChild1Integer, 5, 
/*20704*/       OPC_CheckChild1Type, MVT::i32,
/*20706*/       OPC_EmitMergeInputChains1_0,
/*20707*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst5), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 5:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst5)
/*20712*/     /*Scope*/ 10, /*->20723*/
/*20713*/       OPC_CheckChild1Integer, 6, 
/*20715*/       OPC_CheckChild1Type, MVT::i32,
/*20717*/       OPC_EmitMergeInputChains1_0,
/*20718*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst6), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 6:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst6)
/*20723*/     /*Scope*/ 10, /*->20734*/
/*20724*/       OPC_CheckChild1Integer, 7, 
/*20726*/       OPC_CheckChild1Type, MVT::i32,
/*20728*/       OPC_EmitMergeInputChains1_0,
/*20729*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst7), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 7:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst7)
/*20734*/     /*Scope*/ 10, /*->20745*/
/*20735*/       OPC_CheckChild1Integer, 8, 
/*20737*/       OPC_CheckChild1Type, MVT::i32,
/*20739*/       OPC_EmitMergeInputChains1_0,
/*20740*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallUniPrintCallRetInst8), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintCallUni 8:i32) - Complexity = 8
                // Dst: (CallUniPrintCallRetInst8)
/*20745*/     0, /*End of Scope*/
/*20746*/   /*SwitchOpcode*/ 103, TARGET_VAL(NVPTXISD::PrintConvergentCall),// ->20852
/*20749*/     OPC_RecordNode, // #0 = 'PrintConvergentCall' chained node
/*20750*/     OPC_CaptureGlueInput,
/*20751*/     OPC_Scope, 10, /*->20763*/ // 9 children in Scope
/*20753*/       OPC_CheckChild1Integer, 0, 
/*20755*/       OPC_CheckChild1Type, MVT::i32,
/*20757*/       OPC_EmitMergeInputChains1_0,
/*20758*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallNoRetInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 0:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallNoRetInst)
/*20763*/     /*Scope*/ 10, /*->20774*/
/*20764*/       OPC_CheckChild1Integer, 1, 
/*20766*/       OPC_CheckChild1Type, MVT::i32,
/*20768*/       OPC_EmitMergeInputChains1_0,
/*20769*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst1), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 1:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst1)
/*20774*/     /*Scope*/ 10, /*->20785*/
/*20775*/       OPC_CheckChild1Integer, 2, 
/*20777*/       OPC_CheckChild1Type, MVT::i32,
/*20779*/       OPC_EmitMergeInputChains1_0,
/*20780*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst2), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 2:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst2)
/*20785*/     /*Scope*/ 10, /*->20796*/
/*20786*/       OPC_CheckChild1Integer, 3, 
/*20788*/       OPC_CheckChild1Type, MVT::i32,
/*20790*/       OPC_EmitMergeInputChains1_0,
/*20791*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst3), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 3:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst3)
/*20796*/     /*Scope*/ 10, /*->20807*/
/*20797*/       OPC_CheckChild1Integer, 4, 
/*20799*/       OPC_CheckChild1Type, MVT::i32,
/*20801*/       OPC_EmitMergeInputChains1_0,
/*20802*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst4), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 4:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst4)
/*20807*/     /*Scope*/ 10, /*->20818*/
/*20808*/       OPC_CheckChild1Integer, 5, 
/*20810*/       OPC_CheckChild1Type, MVT::i32,
/*20812*/       OPC_EmitMergeInputChains1_0,
/*20813*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst5), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 5:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst5)
/*20818*/     /*Scope*/ 10, /*->20829*/
/*20819*/       OPC_CheckChild1Integer, 6, 
/*20821*/       OPC_CheckChild1Type, MVT::i32,
/*20823*/       OPC_EmitMergeInputChains1_0,
/*20824*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst6), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 6:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst6)
/*20829*/     /*Scope*/ 10, /*->20840*/
/*20830*/       OPC_CheckChild1Integer, 7, 
/*20832*/       OPC_CheckChild1Type, MVT::i32,
/*20834*/       OPC_EmitMergeInputChains1_0,
/*20835*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst7), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 7:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst7)
/*20840*/     /*Scope*/ 10, /*->20851*/
/*20841*/       OPC_CheckChild1Integer, 8, 
/*20843*/       OPC_CheckChild1Type, MVT::i32,
/*20845*/       OPC_EmitMergeInputChains1_0,
/*20846*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallPrintCallRetInst8), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCall 8:i32) - Complexity = 8
                // Dst: (ConvergentCallPrintCallRetInst8)
/*20851*/     0, /*End of Scope*/
/*20852*/   /*SwitchOpcode*/ 103, TARGET_VAL(NVPTXISD::PrintConvergentCallUni),// ->20958
/*20855*/     OPC_RecordNode, // #0 = 'PrintConvergentCallUni' chained node
/*20856*/     OPC_CaptureGlueInput,
/*20857*/     OPC_Scope, 10, /*->20869*/ // 9 children in Scope
/*20859*/       OPC_CheckChild1Integer, 0, 
/*20861*/       OPC_CheckChild1Type, MVT::i32,
/*20863*/       OPC_EmitMergeInputChains1_0,
/*20864*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallNoRetInst), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 0:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallNoRetInst)
/*20869*/     /*Scope*/ 10, /*->20880*/
/*20870*/       OPC_CheckChild1Integer, 1, 
/*20872*/       OPC_CheckChild1Type, MVT::i32,
/*20874*/       OPC_EmitMergeInputChains1_0,
/*20875*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst1), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 1:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst1)
/*20880*/     /*Scope*/ 10, /*->20891*/
/*20881*/       OPC_CheckChild1Integer, 2, 
/*20883*/       OPC_CheckChild1Type, MVT::i32,
/*20885*/       OPC_EmitMergeInputChains1_0,
/*20886*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst2), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 2:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst2)
/*20891*/     /*Scope*/ 10, /*->20902*/
/*20892*/       OPC_CheckChild1Integer, 3, 
/*20894*/       OPC_CheckChild1Type, MVT::i32,
/*20896*/       OPC_EmitMergeInputChains1_0,
/*20897*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst3), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 3:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst3)
/*20902*/     /*Scope*/ 10, /*->20913*/
/*20903*/       OPC_CheckChild1Integer, 4, 
/*20905*/       OPC_CheckChild1Type, MVT::i32,
/*20907*/       OPC_EmitMergeInputChains1_0,
/*20908*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst4), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 4:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst4)
/*20913*/     /*Scope*/ 10, /*->20924*/
/*20914*/       OPC_CheckChild1Integer, 5, 
/*20916*/       OPC_CheckChild1Type, MVT::i32,
/*20918*/       OPC_EmitMergeInputChains1_0,
/*20919*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst5), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 5:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst5)
/*20924*/     /*Scope*/ 10, /*->20935*/
/*20925*/       OPC_CheckChild1Integer, 6, 
/*20927*/       OPC_CheckChild1Type, MVT::i32,
/*20929*/       OPC_EmitMergeInputChains1_0,
/*20930*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst6), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 6:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst6)
/*20935*/     /*Scope*/ 10, /*->20946*/
/*20936*/       OPC_CheckChild1Integer, 7, 
/*20938*/       OPC_CheckChild1Type, MVT::i32,
/*20940*/       OPC_EmitMergeInputChains1_0,
/*20941*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst7), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 7:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst7)
/*20946*/     /*Scope*/ 10, /*->20957*/
/*20947*/       OPC_CheckChild1Integer, 8, 
/*20949*/       OPC_CheckChild1Type, MVT::i32,
/*20951*/       OPC_EmitMergeInputChains1_0,
/*20952*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::ConvergentCallUniPrintCallRetInst8), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (PrintConvergentCallUni 8:i32) - Complexity = 8
                // Dst: (ConvergentCallUniPrintCallRetInst8)
/*20957*/     0, /*End of Scope*/
/*20958*/   /*SwitchOpcode*/ 26, TARGET_VAL(NVPTXISD::CallArgEnd),// ->20987
/*20961*/     OPC_RecordNode, // #0 = 'CallArgEnd' chained node
/*20962*/     OPC_CaptureGlueInput,
/*20963*/     OPC_Scope, 10, /*->20975*/ // 2 children in Scope
/*20965*/       OPC_CheckChild1Integer, 1, 
/*20967*/       OPC_CheckChild1Type, MVT::i32,
/*20969*/       OPC_EmitMergeInputChains1_0,
/*20970*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgEndInst1), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (CallArgEnd 1:i32) - Complexity = 8
                // Dst: (CallArgEndInst1)
/*20975*/     /*Scope*/ 10, /*->20986*/
/*20976*/       OPC_CheckChild1Integer, 0, 
/*20978*/       OPC_CheckChild1Type, MVT::i32,
/*20980*/       OPC_EmitMergeInputChains1_0,
/*20981*/       OPC_MorphNodeTo0, TARGET_VAL(NVPTX::CallArgEndInst0), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                    0/*#Ops*/, 
                // Src: (CallArgEnd 0:i32) - Complexity = 8
                // Dst: (CallArgEndInst0)
/*20986*/     0, /*End of Scope*/
/*20987*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),// ->21568
/*20991*/     OPC_RecordMemRef,
/*20992*/     OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*20993*/     OPC_RecordChild1, // #1 = $addr
/*20994*/     OPC_Scope, 28|128,2/*284*/, /*->21281*/ // 2 children in Scope
/*20997*/       OPC_CheckChild1Type, MVT::i32,
/*20999*/       OPC_RecordChild2, // #2 = $b
/*21000*/       OPC_Scope, 21|128,1/*149*/, /*->21152*/ // 3 children in Scope
/*21003*/         OPC_MoveChild2,
/*21004*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21007*/         OPC_MoveParent,
/*21008*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->21080
/*21011*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_add_32
/*21013*/           OPC_Scope, 15, /*->21030*/ // 3 children in Scope
/*21015*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_add_32_g
/*21017*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*21019*/             OPC_EmitMergeInputChains1_0,
/*21020*/             OPC_EmitConvertToTarget, 2,
/*21022*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21030*/           /*Scope*/ 15, /*->21046*/
/*21031*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_add_32_s
/*21033*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*21035*/             OPC_EmitMergeInputChains1_0,
/*21036*/             OPC_EmitConvertToTarget, 2,
/*21038*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21046*/           /*Scope*/ 32, /*->21079*/
/*21047*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_add_32_gen
/*21049*/             OPC_Scope, 13, /*->21064*/ // 2 children in Scope
/*21051*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*21053*/               OPC_EmitMergeInputChains1_0,
/*21054*/               OPC_EmitConvertToTarget, 2,
/*21056*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21064*/             /*Scope*/ 13, /*->21078*/
/*21065*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*21067*/               OPC_EmitMergeInputChains1_0,
/*21068*/               OPC_EmitConvertToTarget, 2,
/*21070*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21078*/             0, /*End of Scope*/
/*21079*/           0, /*End of Scope*/
/*21080*/         /*SwitchType*/ 69, MVT::i64,// ->21151
/*21082*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_add_64
/*21084*/           OPC_Scope, 15, /*->21101*/ // 3 children in Scope
/*21086*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_add_64_g
/*21088*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*21090*/             OPC_EmitMergeInputChains1_0,
/*21091*/             OPC_EmitConvertToTarget, 2,
/*21093*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21101*/           /*Scope*/ 15, /*->21117*/
/*21102*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_add_64_s
/*21104*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*21106*/             OPC_EmitMergeInputChains1_0,
/*21107*/             OPC_EmitConvertToTarget, 2,
/*21109*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21117*/           /*Scope*/ 32, /*->21150*/
/*21118*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_add_64_gen
/*21120*/             OPC_Scope, 13, /*->21135*/ // 2 children in Scope
/*21122*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*21124*/               OPC_EmitMergeInputChains1_0,
/*21125*/               OPC_EmitConvertToTarget, 2,
/*21127*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21135*/             /*Scope*/ 13, /*->21149*/
/*21136*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*21138*/               OPC_EmitMergeInputChains1_0,
/*21139*/               OPC_EmitConvertToTarget, 2,
/*21141*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21149*/             0, /*End of Scope*/
/*21150*/           0, /*End of Scope*/
/*21151*/         0, // EndSwitchType
/*21152*/       /*Scope*/ 63, /*->21216*/
/*21153*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_add_32
/*21155*/         OPC_CheckType, MVT::i32,
/*21157*/         OPC_Scope, 13, /*->21172*/ // 3 children in Scope
/*21159*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_add_32_g
/*21161*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*21163*/           OPC_EmitMergeInputChains1_0,
/*21164*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21172*/         /*Scope*/ 13, /*->21186*/
/*21173*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_add_32_s
/*21175*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*21177*/           OPC_EmitMergeInputChains1_0,
/*21178*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21186*/         /*Scope*/ 28, /*->21215*/
/*21187*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_add_32_gen
/*21189*/           OPC_Scope, 11, /*->21202*/ // 2 children in Scope
/*21191*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*21193*/             OPC_EmitMergeInputChains1_0,
/*21194*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21202*/           /*Scope*/ 11, /*->21214*/
/*21203*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*21205*/             OPC_EmitMergeInputChains1_0,
/*21206*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21214*/           0, /*End of Scope*/
/*21215*/         0, /*End of Scope*/
/*21216*/       /*Scope*/ 63, /*->21280*/
/*21217*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_add_64
/*21219*/         OPC_CheckType, MVT::i64,
/*21221*/         OPC_Scope, 13, /*->21236*/ // 3 children in Scope
/*21223*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_add_64_g
/*21225*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*21227*/           OPC_EmitMergeInputChains1_0,
/*21228*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21236*/         /*Scope*/ 13, /*->21250*/
/*21237*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_add_64_s
/*21239*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*21241*/           OPC_EmitMergeInputChains1_0,
/*21242*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21250*/         /*Scope*/ 28, /*->21279*/
/*21251*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_add_64_gen
/*21253*/           OPC_Scope, 11, /*->21266*/ // 2 children in Scope
/*21255*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*21257*/             OPC_EmitMergeInputChains1_0,
/*21258*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21266*/           /*Scope*/ 11, /*->21278*/
/*21267*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*21269*/             OPC_EmitMergeInputChains1_0,
/*21270*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21278*/           0, /*End of Scope*/
/*21279*/         0, /*End of Scope*/
/*21280*/       0, /*End of Scope*/
/*21281*/     /*Scope*/ 28|128,2/*284*/, /*->21567*/
/*21283*/       OPC_CheckChild1Type, MVT::i64,
/*21285*/       OPC_RecordChild2, // #2 = $b
/*21286*/       OPC_Scope, 21|128,1/*149*/, /*->21438*/ // 3 children in Scope
/*21289*/         OPC_MoveChild2,
/*21290*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21293*/         OPC_MoveParent,
/*21294*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->21366
/*21297*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_add_32
/*21299*/           OPC_Scope, 15, /*->21316*/ // 3 children in Scope
/*21301*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_add_32_g
/*21303*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*21305*/             OPC_EmitMergeInputChains1_0,
/*21306*/             OPC_EmitConvertToTarget, 2,
/*21308*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21316*/           /*Scope*/ 15, /*->21332*/
/*21317*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_add_32_s
/*21319*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*21321*/             OPC_EmitMergeInputChains1_0,
/*21322*/             OPC_EmitConvertToTarget, 2,
/*21324*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21332*/           /*Scope*/ 32, /*->21365*/
/*21333*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_add_32_gen
/*21335*/             OPC_Scope, 13, /*->21350*/ // 2 children in Scope
/*21337*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*21339*/               OPC_EmitMergeInputChains1_0,
/*21340*/               OPC_EmitConvertToTarget, 2,
/*21342*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21350*/             /*Scope*/ 13, /*->21364*/
/*21351*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*21353*/               OPC_EmitMergeInputChains1_0,
/*21354*/               OPC_EmitConvertToTarget, 2,
/*21356*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21364*/             0, /*End of Scope*/
/*21365*/           0, /*End of Scope*/
/*21366*/         /*SwitchType*/ 69, MVT::i64,// ->21437
/*21368*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_add_64
/*21370*/           OPC_Scope, 15, /*->21387*/ // 3 children in Scope
/*21372*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_add_64_g
/*21374*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*21376*/             OPC_EmitMergeInputChains1_0,
/*21377*/             OPC_EmitConvertToTarget, 2,
/*21379*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*21387*/           /*Scope*/ 15, /*->21403*/
/*21388*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_add_64_s
/*21390*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*21392*/             OPC_EmitMergeInputChains1_0,
/*21393*/             OPC_EmitConvertToTarget, 2,
/*21395*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_ADD_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*21403*/           /*Scope*/ 32, /*->21436*/
/*21404*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_add_64_gen
/*21406*/             OPC_Scope, 13, /*->21421*/ // 2 children in Scope
/*21408*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*21410*/               OPC_EmitMergeInputChains1_0,
/*21411*/               OPC_EmitConvertToTarget, 2,
/*21413*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*21421*/             /*Scope*/ 13, /*->21435*/
/*21422*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*21424*/               OPC_EmitMergeInputChains1_0,
/*21425*/               OPC_EmitConvertToTarget, 2,
/*21427*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_ADD_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*21435*/             0, /*End of Scope*/
/*21436*/           0, /*End of Scope*/
/*21437*/         0, // EndSwitchType
/*21438*/       /*Scope*/ 63, /*->21502*/
/*21439*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_add_32
/*21441*/         OPC_CheckType, MVT::i32,
/*21443*/         OPC_Scope, 13, /*->21458*/ // 3 children in Scope
/*21445*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_add_32_g
/*21447*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*21449*/           OPC_EmitMergeInputChains1_0,
/*21450*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*21458*/         /*Scope*/ 13, /*->21472*/
/*21459*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_add_32_s
/*21461*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*21463*/           OPC_EmitMergeInputChains1_0,
/*21464*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*21472*/         /*Scope*/ 28, /*->21501*/
/*21473*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_add_32_gen
/*21475*/           OPC_Scope, 11, /*->21488*/ // 2 children in Scope
/*21477*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*21479*/             OPC_EmitMergeInputChains1_0,
/*21480*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*21488*/           /*Scope*/ 11, /*->21500*/
/*21489*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*21491*/             OPC_EmitMergeInputChains1_0,
/*21492*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*21500*/           0, /*End of Scope*/
/*21501*/         0, /*End of Scope*/
/*21502*/       /*Scope*/ 63, /*->21566*/
/*21503*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_add_64
/*21505*/         OPC_CheckType, MVT::i64,
/*21507*/         OPC_Scope, 13, /*->21522*/ // 3 children in Scope
/*21509*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_add_64_g
/*21511*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*21513*/           OPC_EmitMergeInputChains1_0,
/*21514*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*21522*/         /*Scope*/ 13, /*->21536*/
/*21523*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_add_64_s
/*21525*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*21527*/           OPC_EmitMergeInputChains1_0,
/*21528*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_ADD_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*21536*/         /*Scope*/ 28, /*->21565*/
/*21537*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_add_64_gen
/*21539*/           OPC_Scope, 11, /*->21552*/ // 2 children in Scope
/*21541*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*21543*/             OPC_EmitMergeInputChains1_0,
/*21544*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*21552*/           /*Scope*/ 11, /*->21564*/
/*21553*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*21555*/             OPC_EmitMergeInputChains1_0,
/*21556*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_ADD_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_add:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_ADD_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*21564*/           0, /*End of Scope*/
/*21565*/         0, /*End of Scope*/
/*21566*/       0, /*End of Scope*/
/*21567*/     0, /*End of Scope*/
/*21568*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_SWAP),// ->22149
/*21572*/     OPC_RecordMemRef,
/*21573*/     OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*21574*/     OPC_RecordChild1, // #1 = $addr
/*21575*/     OPC_Scope, 28|128,2/*284*/, /*->21862*/ // 2 children in Scope
/*21578*/       OPC_CheckChild1Type, MVT::i32,
/*21580*/       OPC_RecordChild2, // #2 = $b
/*21581*/       OPC_Scope, 21|128,1/*149*/, /*->21733*/ // 3 children in Scope
/*21584*/         OPC_MoveChild2,
/*21585*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21588*/         OPC_MoveParent,
/*21589*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->21661
/*21592*/           OPC_CheckPredicate, 15, // Predicate_atomic_swap_32
/*21594*/           OPC_Scope, 15, /*->21611*/ // 3 children in Scope
/*21596*/             OPC_CheckPredicate, 4, // Predicate_atomic_swap_32_g
/*21598*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*21600*/             OPC_EmitMergeInputChains1_0,
/*21601*/             OPC_EmitConvertToTarget, 2,
/*21603*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21611*/           /*Scope*/ 15, /*->21627*/
/*21612*/             OPC_CheckPredicate, 5, // Predicate_atomic_swap_32_s
/*21614*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*21616*/             OPC_EmitMergeInputChains1_0,
/*21617*/             OPC_EmitConvertToTarget, 2,
/*21619*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21627*/           /*Scope*/ 32, /*->21660*/
/*21628*/             OPC_CheckPredicate, 6, // Predicate_atomic_swap_32_gen
/*21630*/             OPC_Scope, 13, /*->21645*/ // 2 children in Scope
/*21632*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*21634*/               OPC_EmitMergeInputChains1_0,
/*21635*/               OPC_EmitConvertToTarget, 2,
/*21637*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21645*/             /*Scope*/ 13, /*->21659*/
/*21646*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*21648*/               OPC_EmitMergeInputChains1_0,
/*21649*/               OPC_EmitConvertToTarget, 2,
/*21651*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*21659*/             0, /*End of Scope*/
/*21660*/           0, /*End of Scope*/
/*21661*/         /*SwitchType*/ 69, MVT::i64,// ->21732
/*21663*/           OPC_CheckPredicate, 16, // Predicate_atomic_swap_64
/*21665*/           OPC_Scope, 15, /*->21682*/ // 3 children in Scope
/*21667*/             OPC_CheckPredicate, 4, // Predicate_atomic_swap_64_g
/*21669*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*21671*/             OPC_EmitMergeInputChains1_0,
/*21672*/             OPC_EmitConvertToTarget, 2,
/*21674*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21682*/           /*Scope*/ 15, /*->21698*/
/*21683*/             OPC_CheckPredicate, 5, // Predicate_atomic_swap_64_s
/*21685*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*21687*/             OPC_EmitMergeInputChains1_0,
/*21688*/             OPC_EmitConvertToTarget, 2,
/*21690*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21698*/           /*Scope*/ 32, /*->21731*/
/*21699*/             OPC_CheckPredicate, 6, // Predicate_atomic_swap_64_gen
/*21701*/             OPC_Scope, 13, /*->21716*/ // 2 children in Scope
/*21703*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*21705*/               OPC_EmitMergeInputChains1_0,
/*21706*/               OPC_EmitConvertToTarget, 2,
/*21708*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21716*/             /*Scope*/ 13, /*->21730*/
/*21717*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*21719*/               OPC_EmitMergeInputChains1_0,
/*21720*/               OPC_EmitConvertToTarget, 2,
/*21722*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*21730*/             0, /*End of Scope*/
/*21731*/           0, /*End of Scope*/
/*21732*/         0, // EndSwitchType
/*21733*/       /*Scope*/ 63, /*->21797*/
/*21734*/         OPC_CheckPredicate, 15, // Predicate_atomic_swap_32
/*21736*/         OPC_CheckType, MVT::i32,
/*21738*/         OPC_Scope, 13, /*->21753*/ // 3 children in Scope
/*21740*/           OPC_CheckPredicate, 4, // Predicate_atomic_swap_32_g
/*21742*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*21744*/           OPC_EmitMergeInputChains1_0,
/*21745*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21753*/         /*Scope*/ 13, /*->21767*/
/*21754*/           OPC_CheckPredicate, 5, // Predicate_atomic_swap_32_s
/*21756*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*21758*/           OPC_EmitMergeInputChains1_0,
/*21759*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21767*/         /*Scope*/ 28, /*->21796*/
/*21768*/           OPC_CheckPredicate, 6, // Predicate_atomic_swap_32_gen
/*21770*/           OPC_Scope, 11, /*->21783*/ // 2 children in Scope
/*21772*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*21774*/             OPC_EmitMergeInputChains1_0,
/*21775*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21783*/           /*Scope*/ 11, /*->21795*/
/*21784*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*21786*/             OPC_EmitMergeInputChains1_0,
/*21787*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*21795*/           0, /*End of Scope*/
/*21796*/         0, /*End of Scope*/
/*21797*/       /*Scope*/ 63, /*->21861*/
/*21798*/         OPC_CheckPredicate, 16, // Predicate_atomic_swap_64
/*21800*/         OPC_CheckType, MVT::i64,
/*21802*/         OPC_Scope, 13, /*->21817*/ // 3 children in Scope
/*21804*/           OPC_CheckPredicate, 4, // Predicate_atomic_swap_64_g
/*21806*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*21808*/           OPC_EmitMergeInputChains1_0,
/*21809*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21817*/         /*Scope*/ 13, /*->21831*/
/*21818*/           OPC_CheckPredicate, 5, // Predicate_atomic_swap_64_s
/*21820*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*21822*/           OPC_EmitMergeInputChains1_0,
/*21823*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21831*/         /*Scope*/ 28, /*->21860*/
/*21832*/           OPC_CheckPredicate, 6, // Predicate_atomic_swap_64_gen
/*21834*/           OPC_Scope, 11, /*->21847*/ // 2 children in Scope
/*21836*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*21838*/             OPC_EmitMergeInputChains1_0,
/*21839*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21847*/           /*Scope*/ 11, /*->21859*/
/*21848*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*21850*/             OPC_EmitMergeInputChains1_0,
/*21851*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*21859*/           0, /*End of Scope*/
/*21860*/         0, /*End of Scope*/
/*21861*/       0, /*End of Scope*/
/*21862*/     /*Scope*/ 28|128,2/*284*/, /*->22148*/
/*21864*/       OPC_CheckChild1Type, MVT::i64,
/*21866*/       OPC_RecordChild2, // #2 = $b
/*21867*/       OPC_Scope, 21|128,1/*149*/, /*->22019*/ // 3 children in Scope
/*21870*/         OPC_MoveChild2,
/*21871*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21874*/         OPC_MoveParent,
/*21875*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->21947
/*21878*/           OPC_CheckPredicate, 15, // Predicate_atomic_swap_32
/*21880*/           OPC_Scope, 15, /*->21897*/ // 3 children in Scope
/*21882*/             OPC_CheckPredicate, 4, // Predicate_atomic_swap_32_g
/*21884*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*21886*/             OPC_EmitMergeInputChains1_0,
/*21887*/             OPC_EmitConvertToTarget, 2,
/*21889*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21897*/           /*Scope*/ 15, /*->21913*/
/*21898*/             OPC_CheckPredicate, 5, // Predicate_atomic_swap_32_s
/*21900*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*21902*/             OPC_EmitMergeInputChains1_0,
/*21903*/             OPC_EmitConvertToTarget, 2,
/*21905*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21913*/           /*Scope*/ 32, /*->21946*/
/*21914*/             OPC_CheckPredicate, 6, // Predicate_atomic_swap_32_gen
/*21916*/             OPC_Scope, 13, /*->21931*/ // 2 children in Scope
/*21918*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*21920*/               OPC_EmitMergeInputChains1_0,
/*21921*/               OPC_EmitConvertToTarget, 2,
/*21923*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21931*/             /*Scope*/ 13, /*->21945*/
/*21932*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*21934*/               OPC_EmitMergeInputChains1_0,
/*21935*/               OPC_EmitConvertToTarget, 2,
/*21937*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*21945*/             0, /*End of Scope*/
/*21946*/           0, /*End of Scope*/
/*21947*/         /*SwitchType*/ 69, MVT::i64,// ->22018
/*21949*/           OPC_CheckPredicate, 16, // Predicate_atomic_swap_64
/*21951*/           OPC_Scope, 15, /*->21968*/ // 3 children in Scope
/*21953*/             OPC_CheckPredicate, 4, // Predicate_atomic_swap_64_g
/*21955*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*21957*/             OPC_EmitMergeInputChains1_0,
/*21958*/             OPC_EmitConvertToTarget, 2,
/*21960*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*21968*/           /*Scope*/ 15, /*->21984*/
/*21969*/             OPC_CheckPredicate, 5, // Predicate_atomic_swap_64_s
/*21971*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*21973*/             OPC_EmitMergeInputChains1_0,
/*21974*/             OPC_EmitConvertToTarget, 2,
/*21976*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_SWAP_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*21984*/           /*Scope*/ 32, /*->22017*/
/*21985*/             OPC_CheckPredicate, 6, // Predicate_atomic_swap_64_gen
/*21987*/             OPC_Scope, 13, /*->22002*/ // 2 children in Scope
/*21989*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*21991*/               OPC_EmitMergeInputChains1_0,
/*21992*/               OPC_EmitConvertToTarget, 2,
/*21994*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*22002*/             /*Scope*/ 13, /*->22016*/
/*22003*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*22005*/               OPC_EmitMergeInputChains1_0,
/*22006*/               OPC_EmitConvertToTarget, 2,
/*22008*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_swap:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_SWAP_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*22016*/             0, /*End of Scope*/
/*22017*/           0, /*End of Scope*/
/*22018*/         0, // EndSwitchType
/*22019*/       /*Scope*/ 63, /*->22083*/
/*22020*/         OPC_CheckPredicate, 15, // Predicate_atomic_swap_32
/*22022*/         OPC_CheckType, MVT::i32,
/*22024*/         OPC_Scope, 13, /*->22039*/ // 3 children in Scope
/*22026*/           OPC_CheckPredicate, 4, // Predicate_atomic_swap_32_g
/*22028*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*22030*/           OPC_EmitMergeInputChains1_0,
/*22031*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22039*/         /*Scope*/ 13, /*->22053*/
/*22040*/           OPC_CheckPredicate, 5, // Predicate_atomic_swap_32_s
/*22042*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*22044*/           OPC_EmitMergeInputChains1_0,
/*22045*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22053*/         /*Scope*/ 28, /*->22082*/
/*22054*/           OPC_CheckPredicate, 6, // Predicate_atomic_swap_32_gen
/*22056*/           OPC_Scope, 11, /*->22069*/ // 2 children in Scope
/*22058*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*22060*/             OPC_EmitMergeInputChains1_0,
/*22061*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22069*/           /*Scope*/ 11, /*->22081*/
/*22070*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*22072*/             OPC_EmitMergeInputChains1_0,
/*22073*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22081*/           0, /*End of Scope*/
/*22082*/         0, /*End of Scope*/
/*22083*/       /*Scope*/ 63, /*->22147*/
/*22084*/         OPC_CheckPredicate, 16, // Predicate_atomic_swap_64
/*22086*/         OPC_CheckType, MVT::i64,
/*22088*/         OPC_Scope, 13, /*->22103*/ // 3 children in Scope
/*22090*/           OPC_CheckPredicate, 4, // Predicate_atomic_swap_64_g
/*22092*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*22094*/           OPC_EmitMergeInputChains1_0,
/*22095*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22103*/         /*Scope*/ 13, /*->22117*/
/*22104*/           OPC_CheckPredicate, 5, // Predicate_atomic_swap_64_s
/*22106*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*22108*/           OPC_EmitMergeInputChains1_0,
/*22109*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_SWAP_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22117*/         /*Scope*/ 28, /*->22146*/
/*22118*/           OPC_CheckPredicate, 6, // Predicate_atomic_swap_64_gen
/*22120*/           OPC_Scope, 11, /*->22133*/ // 2 children in Scope
/*22122*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*22124*/             OPC_EmitMergeInputChains1_0,
/*22125*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22133*/           /*Scope*/ 11, /*->22145*/
/*22134*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*22136*/             OPC_EmitMergeInputChains1_0,
/*22137*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_SWAP_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_swap:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_SWAP_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22145*/           0, /*End of Scope*/
/*22146*/         0, /*End of Scope*/
/*22147*/       0, /*End of Scope*/
/*22148*/     0, /*End of Scope*/
/*22149*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_LOAD_MAX),// ->22730
/*22153*/     OPC_RecordMemRef,
/*22154*/     OPC_RecordNode, // #0 = 'atomic_load_max' chained node
/*22155*/     OPC_RecordChild1, // #1 = $addr
/*22156*/     OPC_Scope, 28|128,2/*284*/, /*->22443*/ // 2 children in Scope
/*22159*/       OPC_CheckChild1Type, MVT::i32,
/*22161*/       OPC_RecordChild2, // #2 = $b
/*22162*/       OPC_Scope, 21|128,1/*149*/, /*->22314*/ // 3 children in Scope
/*22165*/         OPC_MoveChild2,
/*22166*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*22169*/         OPC_MoveParent,
/*22170*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->22242
/*22173*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_max_32
/*22175*/           OPC_Scope, 15, /*->22192*/ // 3 children in Scope
/*22177*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_max_32_g
/*22179*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*22181*/             OPC_EmitMergeInputChains1_0,
/*22182*/             OPC_EmitConvertToTarget, 2,
/*22184*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22192*/           /*Scope*/ 15, /*->22208*/
/*22193*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_max_32_s
/*22195*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*22197*/             OPC_EmitMergeInputChains1_0,
/*22198*/             OPC_EmitConvertToTarget, 2,
/*22200*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22208*/           /*Scope*/ 32, /*->22241*/
/*22209*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_max_32_gen
/*22211*/             OPC_Scope, 13, /*->22226*/ // 2 children in Scope
/*22213*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*22215*/               OPC_EmitMergeInputChains1_0,
/*22216*/               OPC_EmitConvertToTarget, 2,
/*22218*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22226*/             /*Scope*/ 13, /*->22240*/
/*22227*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*22229*/               OPC_EmitMergeInputChains1_0,
/*22230*/               OPC_EmitConvertToTarget, 2,
/*22232*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22240*/             0, /*End of Scope*/
/*22241*/           0, /*End of Scope*/
/*22242*/         /*SwitchType*/ 69, MVT::i64,// ->22313
/*22244*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_max_64
/*22246*/           OPC_Scope, 15, /*->22263*/ // 3 children in Scope
/*22248*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_max_64_g
/*22250*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*22252*/             OPC_EmitMergeInputChains1_0,
/*22253*/             OPC_EmitConvertToTarget, 2,
/*22255*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22263*/           /*Scope*/ 15, /*->22279*/
/*22264*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_max_64_s
/*22266*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*22268*/             OPC_EmitMergeInputChains1_0,
/*22269*/             OPC_EmitConvertToTarget, 2,
/*22271*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22279*/           /*Scope*/ 32, /*->22312*/
/*22280*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_max_64_gen
/*22282*/             OPC_Scope, 13, /*->22297*/ // 2 children in Scope
/*22284*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*22286*/               OPC_EmitMergeInputChains1_0,
/*22287*/               OPC_EmitConvertToTarget, 2,
/*22289*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22297*/             /*Scope*/ 13, /*->22311*/
/*22298*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*22300*/               OPC_EmitMergeInputChains1_0,
/*22301*/               OPC_EmitConvertToTarget, 2,
/*22303*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22311*/             0, /*End of Scope*/
/*22312*/           0, /*End of Scope*/
/*22313*/         0, // EndSwitchType
/*22314*/       /*Scope*/ 63, /*->22378*/
/*22315*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_max_32
/*22317*/         OPC_CheckType, MVT::i32,
/*22319*/         OPC_Scope, 13, /*->22334*/ // 3 children in Scope
/*22321*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_max_32_g
/*22323*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*22325*/           OPC_EmitMergeInputChains1_0,
/*22326*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22334*/         /*Scope*/ 13, /*->22348*/
/*22335*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_max_32_s
/*22337*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*22339*/           OPC_EmitMergeInputChains1_0,
/*22340*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22348*/         /*Scope*/ 28, /*->22377*/
/*22349*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_max_32_gen
/*22351*/           OPC_Scope, 11, /*->22364*/ // 2 children in Scope
/*22353*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*22355*/             OPC_EmitMergeInputChains1_0,
/*22356*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22364*/           /*Scope*/ 11, /*->22376*/
/*22365*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*22367*/             OPC_EmitMergeInputChains1_0,
/*22368*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22376*/           0, /*End of Scope*/
/*22377*/         0, /*End of Scope*/
/*22378*/       /*Scope*/ 63, /*->22442*/
/*22379*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_max_64
/*22381*/         OPC_CheckType, MVT::i64,
/*22383*/         OPC_Scope, 13, /*->22398*/ // 3 children in Scope
/*22385*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_max_64_g
/*22387*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*22389*/           OPC_EmitMergeInputChains1_0,
/*22390*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*22398*/         /*Scope*/ 13, /*->22412*/
/*22399*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_max_64_s
/*22401*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*22403*/           OPC_EmitMergeInputChains1_0,
/*22404*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*22412*/         /*Scope*/ 28, /*->22441*/
/*22413*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_max_64_gen
/*22415*/           OPC_Scope, 11, /*->22428*/ // 2 children in Scope
/*22417*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*22419*/             OPC_EmitMergeInputChains1_0,
/*22420*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*22428*/           /*Scope*/ 11, /*->22440*/
/*22429*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*22431*/             OPC_EmitMergeInputChains1_0,
/*22432*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*22440*/           0, /*End of Scope*/
/*22441*/         0, /*End of Scope*/
/*22442*/       0, /*End of Scope*/
/*22443*/     /*Scope*/ 28|128,2/*284*/, /*->22729*/
/*22445*/       OPC_CheckChild1Type, MVT::i64,
/*22447*/       OPC_RecordChild2, // #2 = $b
/*22448*/       OPC_Scope, 21|128,1/*149*/, /*->22600*/ // 3 children in Scope
/*22451*/         OPC_MoveChild2,
/*22452*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*22455*/         OPC_MoveParent,
/*22456*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->22528
/*22459*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_max_32
/*22461*/           OPC_Scope, 15, /*->22478*/ // 3 children in Scope
/*22463*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_max_32_g
/*22465*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*22467*/             OPC_EmitMergeInputChains1_0,
/*22468*/             OPC_EmitConvertToTarget, 2,
/*22470*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*22478*/           /*Scope*/ 15, /*->22494*/
/*22479*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_max_32_s
/*22481*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*22483*/             OPC_EmitMergeInputChains1_0,
/*22484*/             OPC_EmitConvertToTarget, 2,
/*22486*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*22494*/           /*Scope*/ 32, /*->22527*/
/*22495*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_max_32_gen
/*22497*/             OPC_Scope, 13, /*->22512*/ // 2 children in Scope
/*22499*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*22501*/               OPC_EmitMergeInputChains1_0,
/*22502*/               OPC_EmitConvertToTarget, 2,
/*22504*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*22512*/             /*Scope*/ 13, /*->22526*/
/*22513*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*22515*/               OPC_EmitMergeInputChains1_0,
/*22516*/               OPC_EmitConvertToTarget, 2,
/*22518*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*22526*/             0, /*End of Scope*/
/*22527*/           0, /*End of Scope*/
/*22528*/         /*SwitchType*/ 69, MVT::i64,// ->22599
/*22530*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_max_64
/*22532*/           OPC_Scope, 15, /*->22549*/ // 3 children in Scope
/*22534*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_max_64_g
/*22536*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*22538*/             OPC_EmitMergeInputChains1_0,
/*22539*/             OPC_EmitConvertToTarget, 2,
/*22541*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*22549*/           /*Scope*/ 15, /*->22565*/
/*22550*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_max_64_s
/*22552*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*22554*/             OPC_EmitMergeInputChains1_0,
/*22555*/             OPC_EmitConvertToTarget, 2,
/*22557*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*22565*/           /*Scope*/ 32, /*->22598*/
/*22566*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_max_64_gen
/*22568*/             OPC_Scope, 13, /*->22583*/ // 2 children in Scope
/*22570*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*22572*/               OPC_EmitMergeInputChains1_0,
/*22573*/               OPC_EmitConvertToTarget, 2,
/*22575*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*22583*/             /*Scope*/ 13, /*->22597*/
/*22584*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*22586*/               OPC_EmitMergeInputChains1_0,
/*22587*/               OPC_EmitConvertToTarget, 2,
/*22589*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*22597*/             0, /*End of Scope*/
/*22598*/           0, /*End of Scope*/
/*22599*/         0, // EndSwitchType
/*22600*/       /*Scope*/ 63, /*->22664*/
/*22601*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_max_32
/*22603*/         OPC_CheckType, MVT::i32,
/*22605*/         OPC_Scope, 13, /*->22620*/ // 3 children in Scope
/*22607*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_max_32_g
/*22609*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*22611*/           OPC_EmitMergeInputChains1_0,
/*22612*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22620*/         /*Scope*/ 13, /*->22634*/
/*22621*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_max_32_s
/*22623*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*22625*/           OPC_EmitMergeInputChains1_0,
/*22626*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22634*/         /*Scope*/ 28, /*->22663*/
/*22635*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_max_32_gen
/*22637*/           OPC_Scope, 11, /*->22650*/ // 2 children in Scope
/*22639*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*22641*/             OPC_EmitMergeInputChains1_0,
/*22642*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22650*/           /*Scope*/ 11, /*->22662*/
/*22651*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*22653*/             OPC_EmitMergeInputChains1_0,
/*22654*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*22662*/           0, /*End of Scope*/
/*22663*/         0, /*End of Scope*/
/*22664*/       /*Scope*/ 63, /*->22728*/
/*22665*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_max_64
/*22667*/         OPC_CheckType, MVT::i64,
/*22669*/         OPC_Scope, 13, /*->22684*/ // 3 children in Scope
/*22671*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_max_64_g
/*22673*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*22675*/           OPC_EmitMergeInputChains1_0,
/*22676*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22684*/         /*Scope*/ 13, /*->22698*/
/*22685*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_max_64_s
/*22687*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*22689*/           OPC_EmitMergeInputChains1_0,
/*22690*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MAX_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22698*/         /*Scope*/ 28, /*->22727*/
/*22699*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_max_64_gen
/*22701*/           OPC_Scope, 11, /*->22714*/ // 2 children in Scope
/*22703*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*22705*/             OPC_EmitMergeInputChains1_0,
/*22706*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22714*/           /*Scope*/ 11, /*->22726*/
/*22715*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*22717*/             OPC_EmitMergeInputChains1_0,
/*22718*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_max:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MAX_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*22726*/           0, /*End of Scope*/
/*22727*/         0, /*End of Scope*/
/*22728*/       0, /*End of Scope*/
/*22729*/     0, /*End of Scope*/
/*22730*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_LOAD_UMAX),// ->23311
/*22734*/     OPC_RecordMemRef,
/*22735*/     OPC_RecordNode, // #0 = 'atomic_load_umax' chained node
/*22736*/     OPC_RecordChild1, // #1 = $addr
/*22737*/     OPC_Scope, 28|128,2/*284*/, /*->23024*/ // 2 children in Scope
/*22740*/       OPC_CheckChild1Type, MVT::i32,
/*22742*/       OPC_RecordChild2, // #2 = $b
/*22743*/       OPC_Scope, 21|128,1/*149*/, /*->22895*/ // 3 children in Scope
/*22746*/         OPC_MoveChild2,
/*22747*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*22750*/         OPC_MoveParent,
/*22751*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->22823
/*22754*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_umax_32
/*22756*/           OPC_Scope, 15, /*->22773*/ // 3 children in Scope
/*22758*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_32_g
/*22760*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*22762*/             OPC_EmitMergeInputChains1_0,
/*22763*/             OPC_EmitConvertToTarget, 2,
/*22765*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22773*/           /*Scope*/ 15, /*->22789*/
/*22774*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_32_s
/*22776*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*22778*/             OPC_EmitMergeInputChains1_0,
/*22779*/             OPC_EmitConvertToTarget, 2,
/*22781*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22789*/           /*Scope*/ 32, /*->22822*/
/*22790*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_32_gen
/*22792*/             OPC_Scope, 13, /*->22807*/ // 2 children in Scope
/*22794*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*22796*/               OPC_EmitMergeInputChains1_0,
/*22797*/               OPC_EmitConvertToTarget, 2,
/*22799*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22807*/             /*Scope*/ 13, /*->22821*/
/*22808*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*22810*/               OPC_EmitMergeInputChains1_0,
/*22811*/               OPC_EmitConvertToTarget, 2,
/*22813*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*22821*/             0, /*End of Scope*/
/*22822*/           0, /*End of Scope*/
/*22823*/         /*SwitchType*/ 69, MVT::i64,// ->22894
/*22825*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_umax_64
/*22827*/           OPC_Scope, 15, /*->22844*/ // 3 children in Scope
/*22829*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_64_g
/*22831*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*22833*/             OPC_EmitMergeInputChains1_0,
/*22834*/             OPC_EmitConvertToTarget, 2,
/*22836*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22844*/           /*Scope*/ 15, /*->22860*/
/*22845*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_64_s
/*22847*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*22849*/             OPC_EmitMergeInputChains1_0,
/*22850*/             OPC_EmitConvertToTarget, 2,
/*22852*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22860*/           /*Scope*/ 32, /*->22893*/
/*22861*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_64_gen
/*22863*/             OPC_Scope, 13, /*->22878*/ // 2 children in Scope
/*22865*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*22867*/               OPC_EmitMergeInputChains1_0,
/*22868*/               OPC_EmitConvertToTarget, 2,
/*22870*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22878*/             /*Scope*/ 13, /*->22892*/
/*22879*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*22881*/               OPC_EmitMergeInputChains1_0,
/*22882*/               OPC_EmitConvertToTarget, 2,
/*22884*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*22892*/             0, /*End of Scope*/
/*22893*/           0, /*End of Scope*/
/*22894*/         0, // EndSwitchType
/*22895*/       /*Scope*/ 63, /*->22959*/
/*22896*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_umax_32
/*22898*/         OPC_CheckType, MVT::i32,
/*22900*/         OPC_Scope, 13, /*->22915*/ // 3 children in Scope
/*22902*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_32_g
/*22904*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*22906*/           OPC_EmitMergeInputChains1_0,
/*22907*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22915*/         /*Scope*/ 13, /*->22929*/
/*22916*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_32_s
/*22918*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*22920*/           OPC_EmitMergeInputChains1_0,
/*22921*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22929*/         /*Scope*/ 28, /*->22958*/
/*22930*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_32_gen
/*22932*/           OPC_Scope, 11, /*->22945*/ // 2 children in Scope
/*22934*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*22936*/             OPC_EmitMergeInputChains1_0,
/*22937*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22945*/           /*Scope*/ 11, /*->22957*/
/*22946*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*22948*/             OPC_EmitMergeInputChains1_0,
/*22949*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*22957*/           0, /*End of Scope*/
/*22958*/         0, /*End of Scope*/
/*22959*/       /*Scope*/ 63, /*->23023*/
/*22960*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_umax_64
/*22962*/         OPC_CheckType, MVT::i64,
/*22964*/         OPC_Scope, 13, /*->22979*/ // 3 children in Scope
/*22966*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_64_g
/*22968*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*22970*/           OPC_EmitMergeInputChains1_0,
/*22971*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*22979*/         /*Scope*/ 13, /*->22993*/
/*22980*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_64_s
/*22982*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*22984*/           OPC_EmitMergeInputChains1_0,
/*22985*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*22993*/         /*Scope*/ 28, /*->23022*/
/*22994*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_64_gen
/*22996*/           OPC_Scope, 11, /*->23009*/ // 2 children in Scope
/*22998*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*23000*/             OPC_EmitMergeInputChains1_0,
/*23001*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*23009*/           /*Scope*/ 11, /*->23021*/
/*23010*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*23012*/             OPC_EmitMergeInputChains1_0,
/*23013*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*23021*/           0, /*End of Scope*/
/*23022*/         0, /*End of Scope*/
/*23023*/       0, /*End of Scope*/
/*23024*/     /*Scope*/ 28|128,2/*284*/, /*->23310*/
/*23026*/       OPC_CheckChild1Type, MVT::i64,
/*23028*/       OPC_RecordChild2, // #2 = $b
/*23029*/       OPC_Scope, 21|128,1/*149*/, /*->23181*/ // 3 children in Scope
/*23032*/         OPC_MoveChild2,
/*23033*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*23036*/         OPC_MoveParent,
/*23037*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->23109
/*23040*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_umax_32
/*23042*/           OPC_Scope, 15, /*->23059*/ // 3 children in Scope
/*23044*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_32_g
/*23046*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*23048*/             OPC_EmitMergeInputChains1_0,
/*23049*/             OPC_EmitConvertToTarget, 2,
/*23051*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23059*/           /*Scope*/ 15, /*->23075*/
/*23060*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_32_s
/*23062*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*23064*/             OPC_EmitMergeInputChains1_0,
/*23065*/             OPC_EmitConvertToTarget, 2,
/*23067*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23075*/           /*Scope*/ 32, /*->23108*/
/*23076*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_32_gen
/*23078*/             OPC_Scope, 13, /*->23093*/ // 2 children in Scope
/*23080*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*23082*/               OPC_EmitMergeInputChains1_0,
/*23083*/               OPC_EmitConvertToTarget, 2,
/*23085*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23093*/             /*Scope*/ 13, /*->23107*/
/*23094*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*23096*/               OPC_EmitMergeInputChains1_0,
/*23097*/               OPC_EmitConvertToTarget, 2,
/*23099*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23107*/             0, /*End of Scope*/
/*23108*/           0, /*End of Scope*/
/*23109*/         /*SwitchType*/ 69, MVT::i64,// ->23180
/*23111*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_umax_64
/*23113*/           OPC_Scope, 15, /*->23130*/ // 3 children in Scope
/*23115*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_64_g
/*23117*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*23119*/             OPC_EmitMergeInputChains1_0,
/*23120*/             OPC_EmitConvertToTarget, 2,
/*23122*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23130*/           /*Scope*/ 15, /*->23146*/
/*23131*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_64_s
/*23133*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*23135*/             OPC_EmitMergeInputChains1_0,
/*23136*/             OPC_EmitConvertToTarget, 2,
/*23138*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23146*/           /*Scope*/ 32, /*->23179*/
/*23147*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_64_gen
/*23149*/             OPC_Scope, 13, /*->23164*/ // 2 children in Scope
/*23151*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*23153*/               OPC_EmitMergeInputChains1_0,
/*23154*/               OPC_EmitConvertToTarget, 2,
/*23156*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23164*/             /*Scope*/ 13, /*->23178*/
/*23165*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*23167*/               OPC_EmitMergeInputChains1_0,
/*23168*/               OPC_EmitConvertToTarget, 2,
/*23170*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23178*/             0, /*End of Scope*/
/*23179*/           0, /*End of Scope*/
/*23180*/         0, // EndSwitchType
/*23181*/       /*Scope*/ 63, /*->23245*/
/*23182*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_umax_32
/*23184*/         OPC_CheckType, MVT::i32,
/*23186*/         OPC_Scope, 13, /*->23201*/ // 3 children in Scope
/*23188*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_32_g
/*23190*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*23192*/           OPC_EmitMergeInputChains1_0,
/*23193*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23201*/         /*Scope*/ 13, /*->23215*/
/*23202*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_32_s
/*23204*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*23206*/           OPC_EmitMergeInputChains1_0,
/*23207*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23215*/         /*Scope*/ 28, /*->23244*/
/*23216*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_32_gen
/*23218*/           OPC_Scope, 11, /*->23231*/ // 2 children in Scope
/*23220*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*23222*/             OPC_EmitMergeInputChains1_0,
/*23223*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23231*/           /*Scope*/ 11, /*->23243*/
/*23232*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*23234*/             OPC_EmitMergeInputChains1_0,
/*23235*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23243*/           0, /*End of Scope*/
/*23244*/         0, /*End of Scope*/
/*23245*/       /*Scope*/ 63, /*->23309*/
/*23246*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_umax_64
/*23248*/         OPC_CheckType, MVT::i64,
/*23250*/         OPC_Scope, 13, /*->23265*/ // 3 children in Scope
/*23252*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umax_64_g
/*23254*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*23256*/           OPC_EmitMergeInputChains1_0,
/*23257*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23265*/         /*Scope*/ 13, /*->23279*/
/*23266*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umax_64_s
/*23268*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*23270*/           OPC_EmitMergeInputChains1_0,
/*23271*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMAX_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23279*/         /*Scope*/ 28, /*->23308*/
/*23280*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umax_64_gen
/*23282*/           OPC_Scope, 11, /*->23295*/ // 2 children in Scope
/*23284*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*23286*/             OPC_EmitMergeInputChains1_0,
/*23287*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23295*/           /*Scope*/ 11, /*->23307*/
/*23296*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*23298*/             OPC_EmitMergeInputChains1_0,
/*23299*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umax:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMAX_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23307*/           0, /*End of Scope*/
/*23308*/         0, /*End of Scope*/
/*23309*/       0, /*End of Scope*/
/*23310*/     0, /*End of Scope*/
/*23311*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_LOAD_MIN),// ->23892
/*23315*/     OPC_RecordMemRef,
/*23316*/     OPC_RecordNode, // #0 = 'atomic_load_min' chained node
/*23317*/     OPC_RecordChild1, // #1 = $addr
/*23318*/     OPC_Scope, 28|128,2/*284*/, /*->23605*/ // 2 children in Scope
/*23321*/       OPC_CheckChild1Type, MVT::i32,
/*23323*/       OPC_RecordChild2, // #2 = $b
/*23324*/       OPC_Scope, 21|128,1/*149*/, /*->23476*/ // 3 children in Scope
/*23327*/         OPC_MoveChild2,
/*23328*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*23331*/         OPC_MoveParent,
/*23332*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->23404
/*23335*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_min_32
/*23337*/           OPC_Scope, 15, /*->23354*/ // 3 children in Scope
/*23339*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_min_32_g
/*23341*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*23343*/             OPC_EmitMergeInputChains1_0,
/*23344*/             OPC_EmitConvertToTarget, 2,
/*23346*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23354*/           /*Scope*/ 15, /*->23370*/
/*23355*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_min_32_s
/*23357*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*23359*/             OPC_EmitMergeInputChains1_0,
/*23360*/             OPC_EmitConvertToTarget, 2,
/*23362*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23370*/           /*Scope*/ 32, /*->23403*/
/*23371*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_min_32_gen
/*23373*/             OPC_Scope, 13, /*->23388*/ // 2 children in Scope
/*23375*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*23377*/               OPC_EmitMergeInputChains1_0,
/*23378*/               OPC_EmitConvertToTarget, 2,
/*23380*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23388*/             /*Scope*/ 13, /*->23402*/
/*23389*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*23391*/               OPC_EmitMergeInputChains1_0,
/*23392*/               OPC_EmitConvertToTarget, 2,
/*23394*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23402*/             0, /*End of Scope*/
/*23403*/           0, /*End of Scope*/
/*23404*/         /*SwitchType*/ 69, MVT::i64,// ->23475
/*23406*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_min_64
/*23408*/           OPC_Scope, 15, /*->23425*/ // 3 children in Scope
/*23410*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_min_64_g
/*23412*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*23414*/             OPC_EmitMergeInputChains1_0,
/*23415*/             OPC_EmitConvertToTarget, 2,
/*23417*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*23425*/           /*Scope*/ 15, /*->23441*/
/*23426*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_min_64_s
/*23428*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*23430*/             OPC_EmitMergeInputChains1_0,
/*23431*/             OPC_EmitConvertToTarget, 2,
/*23433*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*23441*/           /*Scope*/ 32, /*->23474*/
/*23442*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_min_64_gen
/*23444*/             OPC_Scope, 13, /*->23459*/ // 2 children in Scope
/*23446*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*23448*/               OPC_EmitMergeInputChains1_0,
/*23449*/               OPC_EmitConvertToTarget, 2,
/*23451*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*23459*/             /*Scope*/ 13, /*->23473*/
/*23460*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*23462*/               OPC_EmitMergeInputChains1_0,
/*23463*/               OPC_EmitConvertToTarget, 2,
/*23465*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*23473*/             0, /*End of Scope*/
/*23474*/           0, /*End of Scope*/
/*23475*/         0, // EndSwitchType
/*23476*/       /*Scope*/ 63, /*->23540*/
/*23477*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_min_32
/*23479*/         OPC_CheckType, MVT::i32,
/*23481*/         OPC_Scope, 13, /*->23496*/ // 3 children in Scope
/*23483*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_min_32_g
/*23485*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*23487*/           OPC_EmitMergeInputChains1_0,
/*23488*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*23496*/         /*Scope*/ 13, /*->23510*/
/*23497*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_min_32_s
/*23499*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*23501*/           OPC_EmitMergeInputChains1_0,
/*23502*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*23510*/         /*Scope*/ 28, /*->23539*/
/*23511*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_min_32_gen
/*23513*/           OPC_Scope, 11, /*->23526*/ // 2 children in Scope
/*23515*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*23517*/             OPC_EmitMergeInputChains1_0,
/*23518*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*23526*/           /*Scope*/ 11, /*->23538*/
/*23527*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*23529*/             OPC_EmitMergeInputChains1_0,
/*23530*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*23538*/           0, /*End of Scope*/
/*23539*/         0, /*End of Scope*/
/*23540*/       /*Scope*/ 63, /*->23604*/
/*23541*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_min_64
/*23543*/         OPC_CheckType, MVT::i64,
/*23545*/         OPC_Scope, 13, /*->23560*/ // 3 children in Scope
/*23547*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_min_64_g
/*23549*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*23551*/           OPC_EmitMergeInputChains1_0,
/*23552*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*23560*/         /*Scope*/ 13, /*->23574*/
/*23561*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_min_64_s
/*23563*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*23565*/           OPC_EmitMergeInputChains1_0,
/*23566*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*23574*/         /*Scope*/ 28, /*->23603*/
/*23575*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_min_64_gen
/*23577*/           OPC_Scope, 11, /*->23590*/ // 2 children in Scope
/*23579*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*23581*/             OPC_EmitMergeInputChains1_0,
/*23582*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*23590*/           /*Scope*/ 11, /*->23602*/
/*23591*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*23593*/             OPC_EmitMergeInputChains1_0,
/*23594*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*23602*/           0, /*End of Scope*/
/*23603*/         0, /*End of Scope*/
/*23604*/       0, /*End of Scope*/
/*23605*/     /*Scope*/ 28|128,2/*284*/, /*->23891*/
/*23607*/       OPC_CheckChild1Type, MVT::i64,
/*23609*/       OPC_RecordChild2, // #2 = $b
/*23610*/       OPC_Scope, 21|128,1/*149*/, /*->23762*/ // 3 children in Scope
/*23613*/         OPC_MoveChild2,
/*23614*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*23617*/         OPC_MoveParent,
/*23618*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->23690
/*23621*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_min_32
/*23623*/           OPC_Scope, 15, /*->23640*/ // 3 children in Scope
/*23625*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_min_32_g
/*23627*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*23629*/             OPC_EmitMergeInputChains1_0,
/*23630*/             OPC_EmitConvertToTarget, 2,
/*23632*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23640*/           /*Scope*/ 15, /*->23656*/
/*23641*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_min_32_s
/*23643*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*23645*/             OPC_EmitMergeInputChains1_0,
/*23646*/             OPC_EmitConvertToTarget, 2,
/*23648*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23656*/           /*Scope*/ 32, /*->23689*/
/*23657*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_min_32_gen
/*23659*/             OPC_Scope, 13, /*->23674*/ // 2 children in Scope
/*23661*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*23663*/               OPC_EmitMergeInputChains1_0,
/*23664*/               OPC_EmitConvertToTarget, 2,
/*23666*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23674*/             /*Scope*/ 13, /*->23688*/
/*23675*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*23677*/               OPC_EmitMergeInputChains1_0,
/*23678*/               OPC_EmitConvertToTarget, 2,
/*23680*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*23688*/             0, /*End of Scope*/
/*23689*/           0, /*End of Scope*/
/*23690*/         /*SwitchType*/ 69, MVT::i64,// ->23761
/*23692*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_min_64
/*23694*/           OPC_Scope, 15, /*->23711*/ // 3 children in Scope
/*23696*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_min_64_g
/*23698*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*23700*/             OPC_EmitMergeInputChains1_0,
/*23701*/             OPC_EmitConvertToTarget, 2,
/*23703*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23711*/           /*Scope*/ 15, /*->23727*/
/*23712*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_min_64_s
/*23714*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*23716*/             OPC_EmitMergeInputChains1_0,
/*23717*/             OPC_EmitConvertToTarget, 2,
/*23719*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23727*/           /*Scope*/ 32, /*->23760*/
/*23728*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_min_64_gen
/*23730*/             OPC_Scope, 13, /*->23745*/ // 2 children in Scope
/*23732*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*23734*/               OPC_EmitMergeInputChains1_0,
/*23735*/               OPC_EmitConvertToTarget, 2,
/*23737*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23745*/             /*Scope*/ 13, /*->23759*/
/*23746*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*23748*/               OPC_EmitMergeInputChains1_0,
/*23749*/               OPC_EmitConvertToTarget, 2,
/*23751*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*23759*/             0, /*End of Scope*/
/*23760*/           0, /*End of Scope*/
/*23761*/         0, // EndSwitchType
/*23762*/       /*Scope*/ 63, /*->23826*/
/*23763*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_min_32
/*23765*/         OPC_CheckType, MVT::i32,
/*23767*/         OPC_Scope, 13, /*->23782*/ // 3 children in Scope
/*23769*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_min_32_g
/*23771*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*23773*/           OPC_EmitMergeInputChains1_0,
/*23774*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23782*/         /*Scope*/ 13, /*->23796*/
/*23783*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_min_32_s
/*23785*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*23787*/           OPC_EmitMergeInputChains1_0,
/*23788*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23796*/         /*Scope*/ 28, /*->23825*/
/*23797*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_min_32_gen
/*23799*/           OPC_Scope, 11, /*->23812*/ // 2 children in Scope
/*23801*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*23803*/             OPC_EmitMergeInputChains1_0,
/*23804*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23812*/           /*Scope*/ 11, /*->23824*/
/*23813*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*23815*/             OPC_EmitMergeInputChains1_0,
/*23816*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*23824*/           0, /*End of Scope*/
/*23825*/         0, /*End of Scope*/
/*23826*/       /*Scope*/ 63, /*->23890*/
/*23827*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_min_64
/*23829*/         OPC_CheckType, MVT::i64,
/*23831*/         OPC_Scope, 13, /*->23846*/ // 3 children in Scope
/*23833*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_min_64_g
/*23835*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*23837*/           OPC_EmitMergeInputChains1_0,
/*23838*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23846*/         /*Scope*/ 13, /*->23860*/
/*23847*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_min_64_s
/*23849*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*23851*/           OPC_EmitMergeInputChains1_0,
/*23852*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_MIN_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23860*/         /*Scope*/ 28, /*->23889*/
/*23861*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_min_64_gen
/*23863*/           OPC_Scope, 11, /*->23876*/ // 2 children in Scope
/*23865*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*23867*/             OPC_EmitMergeInputChains1_0,
/*23868*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23876*/           /*Scope*/ 11, /*->23888*/
/*23877*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*23879*/             OPC_EmitMergeInputChains1_0,
/*23880*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_min:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_MIN_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*23888*/           0, /*End of Scope*/
/*23889*/         0, /*End of Scope*/
/*23890*/       0, /*End of Scope*/
/*23891*/     0, /*End of Scope*/
/*23892*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_LOAD_UMIN),// ->24473
/*23896*/     OPC_RecordMemRef,
/*23897*/     OPC_RecordNode, // #0 = 'atomic_load_umin' chained node
/*23898*/     OPC_RecordChild1, // #1 = $addr
/*23899*/     OPC_Scope, 28|128,2/*284*/, /*->24186*/ // 2 children in Scope
/*23902*/       OPC_CheckChild1Type, MVT::i32,
/*23904*/       OPC_RecordChild2, // #2 = $b
/*23905*/       OPC_Scope, 21|128,1/*149*/, /*->24057*/ // 3 children in Scope
/*23908*/         OPC_MoveChild2,
/*23909*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*23912*/         OPC_MoveParent,
/*23913*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->23985
/*23916*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_umin_32
/*23918*/           OPC_Scope, 15, /*->23935*/ // 3 children in Scope
/*23920*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_32_g
/*23922*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*23924*/             OPC_EmitMergeInputChains1_0,
/*23925*/             OPC_EmitConvertToTarget, 2,
/*23927*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23935*/           /*Scope*/ 15, /*->23951*/
/*23936*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_32_s
/*23938*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*23940*/             OPC_EmitMergeInputChains1_0,
/*23941*/             OPC_EmitConvertToTarget, 2,
/*23943*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23951*/           /*Scope*/ 32, /*->23984*/
/*23952*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_32_gen
/*23954*/             OPC_Scope, 13, /*->23969*/ // 2 children in Scope
/*23956*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*23958*/               OPC_EmitMergeInputChains1_0,
/*23959*/               OPC_EmitConvertToTarget, 2,
/*23961*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23969*/             /*Scope*/ 13, /*->23983*/
/*23970*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*23972*/               OPC_EmitMergeInputChains1_0,
/*23973*/               OPC_EmitConvertToTarget, 2,
/*23975*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*23983*/             0, /*End of Scope*/
/*23984*/           0, /*End of Scope*/
/*23985*/         /*SwitchType*/ 69, MVT::i64,// ->24056
/*23987*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_umin_64
/*23989*/           OPC_Scope, 15, /*->24006*/ // 3 children in Scope
/*23991*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_64_g
/*23993*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*23995*/             OPC_EmitMergeInputChains1_0,
/*23996*/             OPC_EmitConvertToTarget, 2,
/*23998*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24006*/           /*Scope*/ 15, /*->24022*/
/*24007*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_64_s
/*24009*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*24011*/             OPC_EmitMergeInputChains1_0,
/*24012*/             OPC_EmitConvertToTarget, 2,
/*24014*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24022*/           /*Scope*/ 32, /*->24055*/
/*24023*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_64_gen
/*24025*/             OPC_Scope, 13, /*->24040*/ // 2 children in Scope
/*24027*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*24029*/               OPC_EmitMergeInputChains1_0,
/*24030*/               OPC_EmitConvertToTarget, 2,
/*24032*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24040*/             /*Scope*/ 13, /*->24054*/
/*24041*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*24043*/               OPC_EmitMergeInputChains1_0,
/*24044*/               OPC_EmitConvertToTarget, 2,
/*24046*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24054*/             0, /*End of Scope*/
/*24055*/           0, /*End of Scope*/
/*24056*/         0, // EndSwitchType
/*24057*/       /*Scope*/ 63, /*->24121*/
/*24058*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_umin_32
/*24060*/         OPC_CheckType, MVT::i32,
/*24062*/         OPC_Scope, 13, /*->24077*/ // 3 children in Scope
/*24064*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_32_g
/*24066*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*24068*/           OPC_EmitMergeInputChains1_0,
/*24069*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24077*/         /*Scope*/ 13, /*->24091*/
/*24078*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_32_s
/*24080*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*24082*/           OPC_EmitMergeInputChains1_0,
/*24083*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24091*/         /*Scope*/ 28, /*->24120*/
/*24092*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_32_gen
/*24094*/           OPC_Scope, 11, /*->24107*/ // 2 children in Scope
/*24096*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*24098*/             OPC_EmitMergeInputChains1_0,
/*24099*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24107*/           /*Scope*/ 11, /*->24119*/
/*24108*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*24110*/             OPC_EmitMergeInputChains1_0,
/*24111*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24119*/           0, /*End of Scope*/
/*24120*/         0, /*End of Scope*/
/*24121*/       /*Scope*/ 63, /*->24185*/
/*24122*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_umin_64
/*24124*/         OPC_CheckType, MVT::i64,
/*24126*/         OPC_Scope, 13, /*->24141*/ // 3 children in Scope
/*24128*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_64_g
/*24130*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*24132*/           OPC_EmitMergeInputChains1_0,
/*24133*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24141*/         /*Scope*/ 13, /*->24155*/
/*24142*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_64_s
/*24144*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*24146*/           OPC_EmitMergeInputChains1_0,
/*24147*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24155*/         /*Scope*/ 28, /*->24184*/
/*24156*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_64_gen
/*24158*/           OPC_Scope, 11, /*->24171*/ // 2 children in Scope
/*24160*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*24162*/             OPC_EmitMergeInputChains1_0,
/*24163*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24171*/           /*Scope*/ 11, /*->24183*/
/*24172*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*24174*/             OPC_EmitMergeInputChains1_0,
/*24175*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24183*/           0, /*End of Scope*/
/*24184*/         0, /*End of Scope*/
/*24185*/       0, /*End of Scope*/
/*24186*/     /*Scope*/ 28|128,2/*284*/, /*->24472*/
/*24188*/       OPC_CheckChild1Type, MVT::i64,
/*24190*/       OPC_RecordChild2, // #2 = $b
/*24191*/       OPC_Scope, 21|128,1/*149*/, /*->24343*/ // 3 children in Scope
/*24194*/         OPC_MoveChild2,
/*24195*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24198*/         OPC_MoveParent,
/*24199*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->24271
/*24202*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_umin_32
/*24204*/           OPC_Scope, 15, /*->24221*/ // 3 children in Scope
/*24206*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_32_g
/*24208*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*24210*/             OPC_EmitMergeInputChains1_0,
/*24211*/             OPC_EmitConvertToTarget, 2,
/*24213*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24221*/           /*Scope*/ 15, /*->24237*/
/*24222*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_32_s
/*24224*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*24226*/             OPC_EmitMergeInputChains1_0,
/*24227*/             OPC_EmitConvertToTarget, 2,
/*24229*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24237*/           /*Scope*/ 32, /*->24270*/
/*24238*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_32_gen
/*24240*/             OPC_Scope, 13, /*->24255*/ // 2 children in Scope
/*24242*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*24244*/               OPC_EmitMergeInputChains1_0,
/*24245*/               OPC_EmitConvertToTarget, 2,
/*24247*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24255*/             /*Scope*/ 13, /*->24269*/
/*24256*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*24258*/               OPC_EmitMergeInputChains1_0,
/*24259*/               OPC_EmitConvertToTarget, 2,
/*24261*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24269*/             0, /*End of Scope*/
/*24270*/           0, /*End of Scope*/
/*24271*/         /*SwitchType*/ 69, MVT::i64,// ->24342
/*24273*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_umin_64
/*24275*/           OPC_Scope, 15, /*->24292*/ // 3 children in Scope
/*24277*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_64_g
/*24279*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*24281*/             OPC_EmitMergeInputChains1_0,
/*24282*/             OPC_EmitConvertToTarget, 2,
/*24284*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24292*/           /*Scope*/ 15, /*->24308*/
/*24293*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_64_s
/*24295*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*24297*/             OPC_EmitMergeInputChains1_0,
/*24298*/             OPC_EmitConvertToTarget, 2,
/*24300*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24308*/           /*Scope*/ 32, /*->24341*/
/*24309*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_64_gen
/*24311*/             OPC_Scope, 13, /*->24326*/ // 2 children in Scope
/*24313*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*24315*/               OPC_EmitMergeInputChains1_0,
/*24316*/               OPC_EmitConvertToTarget, 2,
/*24318*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24326*/             /*Scope*/ 13, /*->24340*/
/*24327*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*24329*/               OPC_EmitMergeInputChains1_0,
/*24330*/               OPC_EmitConvertToTarget, 2,
/*24332*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24340*/             0, /*End of Scope*/
/*24341*/           0, /*End of Scope*/
/*24342*/         0, // EndSwitchType
/*24343*/       /*Scope*/ 63, /*->24407*/
/*24344*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_umin_32
/*24346*/         OPC_CheckType, MVT::i32,
/*24348*/         OPC_Scope, 13, /*->24363*/ // 3 children in Scope
/*24350*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_32_g
/*24352*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*24354*/           OPC_EmitMergeInputChains1_0,
/*24355*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24363*/         /*Scope*/ 13, /*->24377*/
/*24364*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_32_s
/*24366*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*24368*/           OPC_EmitMergeInputChains1_0,
/*24369*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24377*/         /*Scope*/ 28, /*->24406*/
/*24378*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_32_gen
/*24380*/           OPC_Scope, 11, /*->24393*/ // 2 children in Scope
/*24382*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*24384*/             OPC_EmitMergeInputChains1_0,
/*24385*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24393*/           /*Scope*/ 11, /*->24405*/
/*24394*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*24396*/             OPC_EmitMergeInputChains1_0,
/*24397*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24405*/           0, /*End of Scope*/
/*24406*/         0, /*End of Scope*/
/*24407*/       /*Scope*/ 63, /*->24471*/
/*24408*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_umin_64
/*24410*/         OPC_CheckType, MVT::i64,
/*24412*/         OPC_Scope, 13, /*->24427*/ // 3 children in Scope
/*24414*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_umin_64_g
/*24416*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*24418*/           OPC_EmitMergeInputChains1_0,
/*24419*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*24427*/         /*Scope*/ 13, /*->24441*/
/*24428*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_umin_64_s
/*24430*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*24432*/           OPC_EmitMergeInputChains1_0,
/*24433*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_LOAD_UMIN_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*24441*/         /*Scope*/ 28, /*->24470*/
/*24442*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_umin_64_gen
/*24444*/           OPC_Scope, 11, /*->24457*/ // 2 children in Scope
/*24446*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*24448*/             OPC_EmitMergeInputChains1_0,
/*24449*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*24457*/           /*Scope*/ 11, /*->24469*/
/*24458*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*24460*/             OPC_EmitMergeInputChains1_0,
/*24461*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_umin:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_LOAD_UMIN_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*24469*/           0, /*End of Scope*/
/*24470*/         0, /*End of Scope*/
/*24471*/       0, /*End of Scope*/
/*24472*/     0, /*End of Scope*/
/*24473*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_LOAD_AND),// ->25054
/*24477*/     OPC_RecordMemRef,
/*24478*/     OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*24479*/     OPC_RecordChild1, // #1 = $addr
/*24480*/     OPC_Scope, 28|128,2/*284*/, /*->24767*/ // 2 children in Scope
/*24483*/       OPC_CheckChild1Type, MVT::i32,
/*24485*/       OPC_RecordChild2, // #2 = $b
/*24486*/       OPC_Scope, 21|128,1/*149*/, /*->24638*/ // 3 children in Scope
/*24489*/         OPC_MoveChild2,
/*24490*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24493*/         OPC_MoveParent,
/*24494*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->24566
/*24497*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_and_32
/*24499*/           OPC_Scope, 15, /*->24516*/ // 3 children in Scope
/*24501*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_and_32_g
/*24503*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*24505*/             OPC_EmitMergeInputChains1_0,
/*24506*/             OPC_EmitConvertToTarget, 2,
/*24508*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*24516*/           /*Scope*/ 15, /*->24532*/
/*24517*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_and_32_s
/*24519*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*24521*/             OPC_EmitMergeInputChains1_0,
/*24522*/             OPC_EmitConvertToTarget, 2,
/*24524*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*24532*/           /*Scope*/ 32, /*->24565*/
/*24533*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_and_32_gen
/*24535*/             OPC_Scope, 13, /*->24550*/ // 2 children in Scope
/*24537*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*24539*/               OPC_EmitMergeInputChains1_0,
/*24540*/               OPC_EmitConvertToTarget, 2,
/*24542*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*24550*/             /*Scope*/ 13, /*->24564*/
/*24551*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*24553*/               OPC_EmitMergeInputChains1_0,
/*24554*/               OPC_EmitConvertToTarget, 2,
/*24556*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*24564*/             0, /*End of Scope*/
/*24565*/           0, /*End of Scope*/
/*24566*/         /*SwitchType*/ 69, MVT::i64,// ->24637
/*24568*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_and_64
/*24570*/           OPC_Scope, 15, /*->24587*/ // 3 children in Scope
/*24572*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_and_64_g
/*24574*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*24576*/             OPC_EmitMergeInputChains1_0,
/*24577*/             OPC_EmitConvertToTarget, 2,
/*24579*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24587*/           /*Scope*/ 15, /*->24603*/
/*24588*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_and_64_s
/*24590*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*24592*/             OPC_EmitMergeInputChains1_0,
/*24593*/             OPC_EmitConvertToTarget, 2,
/*24595*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24603*/           /*Scope*/ 32, /*->24636*/
/*24604*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_and_64_gen
/*24606*/             OPC_Scope, 13, /*->24621*/ // 2 children in Scope
/*24608*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*24610*/               OPC_EmitMergeInputChains1_0,
/*24611*/               OPC_EmitConvertToTarget, 2,
/*24613*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24621*/             /*Scope*/ 13, /*->24635*/
/*24622*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*24624*/               OPC_EmitMergeInputChains1_0,
/*24625*/               OPC_EmitConvertToTarget, 2,
/*24627*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*24635*/             0, /*End of Scope*/
/*24636*/           0, /*End of Scope*/
/*24637*/         0, // EndSwitchType
/*24638*/       /*Scope*/ 63, /*->24702*/
/*24639*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_and_32
/*24641*/         OPC_CheckType, MVT::i32,
/*24643*/         OPC_Scope, 13, /*->24658*/ // 3 children in Scope
/*24645*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_and_32_g
/*24647*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*24649*/           OPC_EmitMergeInputChains1_0,
/*24650*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24658*/         /*Scope*/ 13, /*->24672*/
/*24659*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_and_32_s
/*24661*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*24663*/           OPC_EmitMergeInputChains1_0,
/*24664*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24672*/         /*Scope*/ 28, /*->24701*/
/*24673*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_and_32_gen
/*24675*/           OPC_Scope, 11, /*->24688*/ // 2 children in Scope
/*24677*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*24679*/             OPC_EmitMergeInputChains1_0,
/*24680*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24688*/           /*Scope*/ 11, /*->24700*/
/*24689*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*24691*/             OPC_EmitMergeInputChains1_0,
/*24692*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*24700*/           0, /*End of Scope*/
/*24701*/         0, /*End of Scope*/
/*24702*/       /*Scope*/ 63, /*->24766*/
/*24703*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_and_64
/*24705*/         OPC_CheckType, MVT::i64,
/*24707*/         OPC_Scope, 13, /*->24722*/ // 3 children in Scope
/*24709*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_and_64_g
/*24711*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*24713*/           OPC_EmitMergeInputChains1_0,
/*24714*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24722*/         /*Scope*/ 13, /*->24736*/
/*24723*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_and_64_s
/*24725*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*24727*/           OPC_EmitMergeInputChains1_0,
/*24728*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24736*/         /*Scope*/ 28, /*->24765*/
/*24737*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_and_64_gen
/*24739*/           OPC_Scope, 11, /*->24752*/ // 2 children in Scope
/*24741*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*24743*/             OPC_EmitMergeInputChains1_0,
/*24744*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24752*/           /*Scope*/ 11, /*->24764*/
/*24753*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*24755*/             OPC_EmitMergeInputChains1_0,
/*24756*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*24764*/           0, /*End of Scope*/
/*24765*/         0, /*End of Scope*/
/*24766*/       0, /*End of Scope*/
/*24767*/     /*Scope*/ 28|128,2/*284*/, /*->25053*/
/*24769*/       OPC_CheckChild1Type, MVT::i64,
/*24771*/       OPC_RecordChild2, // #2 = $b
/*24772*/       OPC_Scope, 21|128,1/*149*/, /*->24924*/ // 3 children in Scope
/*24775*/         OPC_MoveChild2,
/*24776*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24779*/         OPC_MoveParent,
/*24780*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->24852
/*24783*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_and_32
/*24785*/           OPC_Scope, 15, /*->24802*/ // 3 children in Scope
/*24787*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_and_32_g
/*24789*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*24791*/             OPC_EmitMergeInputChains1_0,
/*24792*/             OPC_EmitConvertToTarget, 2,
/*24794*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24802*/           /*Scope*/ 15, /*->24818*/
/*24803*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_and_32_s
/*24805*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*24807*/             OPC_EmitMergeInputChains1_0,
/*24808*/             OPC_EmitConvertToTarget, 2,
/*24810*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24818*/           /*Scope*/ 32, /*->24851*/
/*24819*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_and_32_gen
/*24821*/             OPC_Scope, 13, /*->24836*/ // 2 children in Scope
/*24823*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*24825*/               OPC_EmitMergeInputChains1_0,
/*24826*/               OPC_EmitConvertToTarget, 2,
/*24828*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24836*/             /*Scope*/ 13, /*->24850*/
/*24837*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*24839*/               OPC_EmitMergeInputChains1_0,
/*24840*/               OPC_EmitConvertToTarget, 2,
/*24842*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*24850*/             0, /*End of Scope*/
/*24851*/           0, /*End of Scope*/
/*24852*/         /*SwitchType*/ 69, MVT::i64,// ->24923
/*24854*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_and_64
/*24856*/           OPC_Scope, 15, /*->24873*/ // 3 children in Scope
/*24858*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_and_64_g
/*24860*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*24862*/             OPC_EmitMergeInputChains1_0,
/*24863*/             OPC_EmitConvertToTarget, 2,
/*24865*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24873*/           /*Scope*/ 15, /*->24889*/
/*24874*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_and_64_s
/*24876*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*24878*/             OPC_EmitMergeInputChains1_0,
/*24879*/             OPC_EmitConvertToTarget, 2,
/*24881*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_AND_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24889*/           /*Scope*/ 32, /*->24922*/
/*24890*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_and_64_gen
/*24892*/             OPC_Scope, 13, /*->24907*/ // 2 children in Scope
/*24894*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*24896*/               OPC_EmitMergeInputChains1_0,
/*24897*/               OPC_EmitConvertToTarget, 2,
/*24899*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24907*/             /*Scope*/ 13, /*->24921*/
/*24908*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*24910*/               OPC_EmitMergeInputChains1_0,
/*24911*/               OPC_EmitConvertToTarget, 2,
/*24913*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_AND_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*24921*/             0, /*End of Scope*/
/*24922*/           0, /*End of Scope*/
/*24923*/         0, // EndSwitchType
/*24924*/       /*Scope*/ 63, /*->24988*/
/*24925*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_and_32
/*24927*/         OPC_CheckType, MVT::i32,
/*24929*/         OPC_Scope, 13, /*->24944*/ // 3 children in Scope
/*24931*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_and_32_g
/*24933*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*24935*/           OPC_EmitMergeInputChains1_0,
/*24936*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24944*/         /*Scope*/ 13, /*->24958*/
/*24945*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_and_32_s
/*24947*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*24949*/           OPC_EmitMergeInputChains1_0,
/*24950*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_S_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24958*/         /*Scope*/ 28, /*->24987*/
/*24959*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_and_32_gen
/*24961*/           OPC_Scope, 11, /*->24974*/ // 2 children in Scope
/*24963*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*24965*/             OPC_EmitMergeInputChains1_0,
/*24966*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24974*/           /*Scope*/ 11, /*->24986*/
/*24975*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*24977*/             OPC_EmitMergeInputChains1_0,
/*24978*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_32_USE_Gp64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*24986*/           0, /*End of Scope*/
/*24987*/         0, /*End of Scope*/
/*24988*/       /*Scope*/ 63, /*->25052*/
/*24989*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_and_64
/*24991*/         OPC_CheckType, MVT::i64,
/*24993*/         OPC_Scope, 13, /*->25008*/ // 3 children in Scope
/*24995*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_and_64_g
/*24997*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*24999*/           OPC_EmitMergeInputChains1_0,
/*25000*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_G_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_G_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*25008*/         /*Scope*/ 13, /*->25022*/
/*25009*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_and_64_s
/*25011*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*25013*/           OPC_EmitMergeInputChains1_0,
/*25014*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_S_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_AND_S_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*25022*/         /*Scope*/ 28, /*->25051*/
/*25023*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_and_64_gen
/*25025*/           OPC_Scope, 11, /*->25038*/ // 2 children in Scope
/*25027*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*25029*/             OPC_EmitMergeInputChains1_0,
/*25030*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_64p64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*25038*/           /*Scope*/ 11, /*->25050*/
/*25039*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*25041*/             OPC_EmitMergeInputChains1_0,
/*25042*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_AND_GEN_64_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_and:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_AND_GEN_64_USE_Gp64reg:i64 Int64Regs:i64:$addr, Int64Regs:i64:$b)
/*25050*/           0, /*End of Scope*/
/*25051*/         0, /*End of Scope*/
/*25052*/       0, /*End of Scope*/
/*25053*/     0, /*End of Scope*/
/*25054*/   /*SwitchOpcode*/ 65|128,4/*577*/, TARGET_VAL(ISD::ATOMIC_LOAD_OR),// ->25635
/*25058*/     OPC_RecordMemRef,
/*25059*/     OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*25060*/     OPC_RecordChild1, // #1 = $addr
/*25061*/     OPC_Scope, 28|128,2/*284*/, /*->25348*/ // 2 children in Scope
/*25064*/       OPC_CheckChild1Type, MVT::i32,
/*25066*/       OPC_RecordChild2, // #2 = $b
/*25067*/       OPC_Scope, 21|128,1/*149*/, /*->25219*/ // 3 children in Scope
/*25070*/         OPC_MoveChild2,
/*25071*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*25074*/         OPC_MoveParent,
/*25075*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->25147
/*25078*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_or_32
/*25080*/           OPC_Scope, 15, /*->25097*/ // 3 children in Scope
/*25082*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_or_32_g
/*25084*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*25086*/             OPC_EmitMergeInputChains1_0,
/*25087*/             OPC_EmitConvertToTarget, 2,
/*25089*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_G_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_G_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*25097*/           /*Scope*/ 32, /*->25130*/
/*25098*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_or_32_gen
/*25100*/             OPC_Scope, 13, /*->25115*/ // 2 children in Scope
/*25102*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*25104*/               OPC_EmitMergeInputChains1_0,
/*25105*/               OPC_EmitConvertToTarget, 2,
/*25107*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*25115*/             /*Scope*/ 13, /*->25129*/
/*25116*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*25118*/               OPC_EmitMergeInputChains1_0,
/*25119*/               OPC_EmitConvertToTarget, 2,
/*25121*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_32_USE_Gp32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*25129*/             0, /*End of Scope*/
/*25130*/           /*Scope*/ 15, /*->25146*/
/*25131*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_or_32_s
/*25133*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*25135*/             OPC_EmitMergeInputChains1_0,
/*25136*/             OPC_EmitConvertToTarget, 2,
/*25138*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_S_32p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_S_32p32imm:i32 Int32Regs:i32:$addr, (imm:i32):$b)
/*25146*/           0, /*End of Scope*/
/*25147*/         /*SwitchType*/ 69, MVT::i64,// ->25218
/*25149*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_or_64
/*25151*/           OPC_Scope, 15, /*->25168*/ // 3 children in Scope
/*25153*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_or_64_g
/*25155*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*25157*/             OPC_EmitMergeInputChains1_0,
/*25158*/             OPC_EmitConvertToTarget, 2,
/*25160*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_G_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_G_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*25168*/           /*Scope*/ 32, /*->25201*/
/*25169*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_or_64_gen
/*25171*/             OPC_Scope, 13, /*->25186*/ // 2 children in Scope
/*25173*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*25175*/               OPC_EmitMergeInputChains1_0,
/*25176*/               OPC_EmitConvertToTarget, 2,
/*25178*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*25186*/             /*Scope*/ 13, /*->25200*/
/*25187*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*25189*/               OPC_EmitMergeInputChains1_0,
/*25190*/               OPC_EmitConvertToTarget, 2,
/*25192*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_64_USE_Gp32imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_64_USE_Gp32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*25200*/             0, /*End of Scope*/
/*25201*/           /*Scope*/ 15, /*->25217*/
/*25202*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_or_64_s
/*25204*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*25206*/             OPC_EmitMergeInputChains1_0,
/*25207*/             OPC_EmitConvertToTarget, 2,
/*25209*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_S_64p32imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_S_64p32imm:i64 Int32Regs:i32:$addr, (imm:i64):$b)
/*25217*/           0, /*End of Scope*/
/*25218*/         0, // EndSwitchType
/*25219*/       /*Scope*/ 63, /*->25283*/
/*25220*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_or_32
/*25222*/         OPC_CheckType, MVT::i32,
/*25224*/         OPC_Scope, 13, /*->25239*/ // 3 children in Scope
/*25226*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_or_32_g
/*25228*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*25230*/           OPC_EmitMergeInputChains1_0,
/*25231*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_G_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_OR_G_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*25239*/         /*Scope*/ 28, /*->25268*/
/*25240*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_or_32_gen
/*25242*/           OPC_Scope, 11, /*->25255*/ // 2 children in Scope
/*25244*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*25246*/             OPC_EmitMergeInputChains1_0,
/*25247*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_OR_GEN_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*25255*/           /*Scope*/ 11, /*->25267*/
/*25256*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*25258*/             OPC_EmitMergeInputChains1_0,
/*25259*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_OR_GEN_32_USE_Gp32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*25267*/           0, /*End of Scope*/
/*25268*/         /*Scope*/ 13, /*->25282*/
/*25269*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_or_32_s
/*25271*/           OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*25273*/           OPC_EmitMergeInputChains1_0,
/*25274*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_S_32p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_or:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_OR_S_32p32reg:i32 Int32Regs:i32:$addr, Int32Regs:i32:$b)
/*25282*/         0, /*End of Scope*/
/*25283*/       /*Scope*/ 63, /*->25347*/
/*25284*/         OPC_CheckPredicate, 16, // Predicate_atomic_load_or_64
/*25286*/         OPC_CheckType, MVT::i64,
/*25288*/         OPC_Scope, 13, /*->25303*/ // 3 children in Scope
/*25290*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_or_64_g
/*25292*/           OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*25294*/           OPC_EmitMergeInputChains1_0,
/*25295*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_G_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_OR_G_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*25303*/         /*Scope*/ 28, /*->25332*/
/*25304*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_or_64_gen
/*25306*/           OPC_Scope, 11, /*->25319*/ // 2 children in Scope
/*25308*/             OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*25310*/             OPC_EmitMergeInputChains1_0,
/*25311*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_OR_GEN_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*25319*/           /*Scope*/ 11, /*->25331*/
/*25320*/             OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*25322*/             OPC_EmitMergeInputChains1_0,
/*25323*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_64_USE_Gp32reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_OR_GEN_64_USE_Gp32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*25331*/           0, /*End of Scope*/
/*25332*/         /*Scope*/ 13, /*->25346*/
/*25333*/           OPC_CheckPredicate, 5, // Predicate_atomic_load_or_64_s
/*25335*/           OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*25337*/           OPC_EmitMergeInputChains1_0,
/*25338*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_S_64p32reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i64, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_or:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_s>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_OR_S_64p32reg:i64 Int32Regs:i32:$addr, Int64Regs:i64:$b)
/*25346*/         0, /*End of Scope*/
/*25347*/       0, /*End of Scope*/
/*25348*/     /*Scope*/ 28|128,2/*284*/, /*->25634*/
/*25350*/       OPC_CheckChild1Type, MVT::i64,
/*25352*/       OPC_RecordChild2, // #2 = $b
/*25353*/       OPC_Scope, 21|128,1/*149*/, /*->25505*/ // 3 children in Scope
/*25356*/         OPC_MoveChild2,
/*25357*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*25360*/         OPC_MoveParent,
/*25361*/         OPC_SwitchType /*2 cases */, 69, MVT::i32,// ->25433
/*25364*/           OPC_CheckPredicate, 15, // Predicate_atomic_load_or_32
/*25366*/           OPC_Scope, 15, /*->25383*/ // 3 children in Scope
/*25368*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_or_32_g
/*25370*/             OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*25372*/             OPC_EmitMergeInputChains1_0,
/*25373*/             OPC_EmitConvertToTarget, 2,
/*25375*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_G_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_G_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*25383*/           /*Scope*/ 32, /*->25416*/
/*25384*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_or_32_gen
/*25386*/             OPC_Scope, 13, /*->25401*/ // 2 children in Scope
/*25388*/               OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*25390*/               OPC_EmitMergeInputChains1_0,
/*25391*/               OPC_EmitConvertToTarget, 2,
/*25393*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*25401*/             /*Scope*/ 13, /*->25415*/
/*25402*/               OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*25404*/               OPC_EmitMergeInputChains1_0,
/*25405*/               OPC_EmitConvertToTarget, 2,
/*25407*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i32, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_32_USE_Gp64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*25415*/             0, /*End of Scope*/
/*25416*/           /*Scope*/ 15, /*->25432*/
/*25417*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_or_32_s
/*25419*/             OPC_CheckPatternPredicate, 9, // (Subtarget->hasAtomRedS32())
/*25421*/             OPC_EmitMergeInputChains1_0,
/*25422*/             OPC_EmitConvertToTarget, 2,
/*25424*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_S_32p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i32 Int64Regs:i64:$addr, (imm:i32):$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_S_32p64imm:i32 Int64Regs:i64:$addr, (imm:i32):$b)
/*25432*/           0, /*End of Scope*/
/*25433*/         /*SwitchType*/ 69, MVT::i64,// ->25504
/*25435*/           OPC_CheckPredicate, 16, // Predicate_atomic_load_or_64
/*25437*/           OPC_Scope, 15, /*->25454*/ // 3 children in Scope
/*25439*/             OPC_CheckPredicate, 4, // Predicate_atomic_load_or_64_g
/*25441*/             OPC_CheckPatternPredicate, 18, // (Subtarget->hasAtomRedG64())
/*25443*/             OPC_EmitMergeInputChains1_0,
/*25444*/             OPC_EmitConvertToTarget, 2,
/*25446*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_G_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_g>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_G_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*25454*/           /*Scope*/ 32, /*->25487*/
/*25455*/             OPC_CheckPredicate, 6, // Predicate_atomic_load_or_64_gen
/*25457*/             OPC_Scope, 13, /*->25472*/ // 2 children in Scope
/*25459*/               OPC_CheckPatternPredicate, 20, // (Subtarget->hasAtomRedGen64())
/*25461*/               OPC_EmitMergeInputChains1_0,
/*25462*/               OPC_EmitConvertToTarget, 2,
/*25464*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*25472*/             /*Scope*/ 13, /*->25486*/
/*25473*/               OPC_CheckPatternPredicate, 21, // (!Subtarget->hasAtomRedGen64() && Subtarget->hasAtomRedG64())
/*25475*/               OPC_EmitMergeInputChains1_0,
/*25476*/               OPC_EmitConvertToTarget, 2,
/*25478*/               OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_64_USE_Gp64imm), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 2/*#Ops*/, 1, 3, 
                        // Src: (atomic_load_or:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_gen>> - Complexity = 7
                        // Dst: (INT_PTX_ATOM_OR_GEN_64_USE_Gp64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*25486*/             0, /*End of Scope*/
/*25487*/           /*Scope*/ 15, /*->25503*/
/*25488*/             OPC_CheckPredicate, 5, // Predicate_atomic_load_or_64_s
/*25490*/             OPC_CheckPatternPredicate, 19, // (Subtarget->hasAtomRedS64())
/*25492*/             OPC_EmitMergeInputChains1_0,
/*25493*/             OPC_EmitConvertToTarget, 2,
/*25495*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_S_64p64imm), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 2/*#Ops*/, 1, 3, 
                      // Src: (atomic_load_or:i64 Int64Regs:i64:$addr, (imm:i64):$b)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_s>> - Complexity = 7
                      // Dst: (INT_PTX_ATOM_OR_S_64p64imm:i64 Int64Regs:i64:$addr, (imm:i64):$b)
/*25503*/           0, /*End of Scope*/
/*25504*/         0, // EndSwitchType
/*25505*/       /*Scope*/ 63, /*->25569*/
/*25506*/         OPC_CheckPredicate, 15, // Predicate_atomic_load_or_32
/*25508*/         OPC_CheckType, MVT::i32,
/*25510*/         OPC_Scope, 13, /*->25525*/ // 3 children in Scope
/*25512*/           OPC_CheckPredicate, 4, // Predicate_atomic_load_or_32_g
/*25514*/           OPC_CheckPatternPredicate, 8, // (Subtarget->hasAtomRedG32())
/*25516*/           OPC_EmitMergeInputChains1_0,
/*25517*/           OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_G_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 2/*#Ops*/, 1, 2, 
                    // Src: (atomic_load_or:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_g>> - Complexity = 4
                    // Dst: (INT_PTX_ATOM_OR_G_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*25525*/         /*Scope*/ 28, /*->25554*/
/*25526*/           OPC_CheckPredicate, 6, // Predicate_atomic_load_or_32_gen
/*25528*/           OPC_Scope, 11, /*->25541*/ // 2 children in Scope
/*25530*/             OPC_CheckPatternPredicate, 10, // (Subtarget->hasAtomRedGen32())
/*25532*/             OPC_EmitMergeInputChains1_0,
/*25533*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32p64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_or:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_OR_GEN_32p64reg:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)
/*25541*/           /*Scope*/ 11, /*->25553*/
/*25542*/             OPC_CheckPatternPredicate, 11, // (!Subtarget->hasAtomRedGen32() && Subtarget->hasAtomRedG32())
/*25544*/             OPC_EmitMergeInputChains1_0,
/*25545*/             OPC_MorphNodeTo1, TARGET_VAL(NVPTX::INT_PTX_ATOM_OR_GEN_32_USE_Gp64reg), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (atomic_load_or:i32 Int64Regs:i64:$addr, Int32Regs:i32:$b)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_gen>> - Complexity = 4
                      // Dst: (INT_PTX_ATOM_OR_GEN_32_USE_Gp64reg