/* keymap.c generated by valac 0.26.2, the Vala compiler
 * generated from keymap.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <config.h>


#define KKC_TYPE_KEYMAP_COMMAND_ENTRY (kkc_keymap_command_entry_get_type ())
typedef struct _KkcKeymapCommandEntry KkcKeymapCommandEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_KEYMAP_ENTRY (kkc_keymap_entry_get_type ())

#define KKC_TYPE_KEY_EVENT (kkc_key_event_get_type ())
#define KKC_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEvent))
#define KKC_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))
#define KKC_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT))
#define KKC_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT))
#define KKC_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))

typedef struct _KkcKeyEvent KkcKeyEvent;
typedef struct _KkcKeyEventClass KkcKeyEventClass;
typedef struct _KkcKeymapEntry KkcKeymapEntry;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_TYPE_KEYMAP (kkc_keymap_get_type ())
#define KKC_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEYMAP, KkcKeymap))
#define KKC_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEYMAP, KkcKeymapClass))
#define KKC_IS_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEYMAP))
#define KKC_IS_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEYMAP))
#define KKC_KEYMAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEYMAP, KkcKeymapClass))

typedef struct _KkcKeymap KkcKeymap;
typedef struct _KkcKeymapClass KkcKeymapClass;
typedef struct _KkcKeymapPrivate KkcKeymapPrivate;

#define KKC_TYPE_MODIFIER_TYPE (kkc_modifier_type_get_type ())

struct _KkcKeymapCommandEntry {
	gchar* name;
	gchar* label;
};

struct _KkcKeymapEntry {
	KkcKeyEvent* key;
	gchar* command;
};

struct _KkcKeymap {
	GObject parent_instance;
	KkcKeymapPrivate * priv;
};

struct _KkcKeymapClass {
	GObjectClass parent_class;
};

struct _KkcKeymapPrivate {
	KkcKeymap* _parent;
	GeeMap* map_entries;
};

typedef enum  {
	KKC_MODIFIER_TYPE_NONE = 0,
	KKC_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	KKC_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	KKC_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	KKC_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	KKC_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	KKC_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	KKC_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	KKC_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	KKC_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	KKC_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	KKC_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	KKC_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	KKC_MODIFIER_TYPE_META_MASK = 1 << 28,
	KKC_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} KkcModifierType;


static gpointer kkc_keymap_parent_class = NULL;
static GeeMap* kkc_keymap__CommandTable;
static GeeMap* kkc_keymap__CommandTable = NULL;

GType kkc_keymap_command_entry_get_type (void) G_GNUC_CONST;
KkcKeymapCommandEntry* kkc_keymap_command_entry_dup (const KkcKeymapCommandEntry* self);
void kkc_keymap_command_entry_free (KkcKeymapCommandEntry* self);
void kkc_keymap_command_entry_copy (const KkcKeymapCommandEntry* self, KkcKeymapCommandEntry* dest);
void kkc_keymap_command_entry_destroy (KkcKeymapCommandEntry* self);
GType kkc_keymap_entry_get_type (void) G_GNUC_CONST;
GType kkc_key_event_get_type (void) G_GNUC_CONST;
KkcKeymapEntry* kkc_keymap_entry_dup (const KkcKeymapEntry* self);
void kkc_keymap_entry_free (KkcKeymapEntry* self);
void kkc_keymap_entry_copy (const KkcKeymapEntry* self, KkcKeymapEntry* dest);
void kkc_keymap_entry_destroy (KkcKeymapEntry* self);
GType kkc_keymap_get_type (void) G_GNUC_CONST;
#define KKC_KEYMAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_KEYMAP, KkcKeymapPrivate))
enum  {
	KKC_KEYMAP_DUMMY_PROPERTY,
	KKC_KEYMAP_PARENT
};
static guint kkc_keymap_key_hash (KkcKeyEvent* a);
static guint _kkc_keymap_key_hash_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean kkc_keymap_key_equal (KkcKeyEvent* a, KkcKeyEvent* b);
static gboolean _kkc_keymap_key_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gchar** kkc_keymap_commands (int* result_length1);
gchar* kkc_keymap_get_command_label (const gchar* command);
guint kkc_key_event_get_keyval (KkcKeyEvent* self);
GType kkc_modifier_type_get_type (void) G_GNUC_CONST;
KkcModifierType kkc_key_event_get_modifiers (KkcKeyEvent* self);
KkcKeymapEntry* kkc_keymap_entries (KkcKeymap* self, int* result_length1);
KkcKeymap* kkc_keymap_get_parent (KkcKeymap* self);
static KkcKeymapEntry* kkc_keymap_map_entries_to_array (KkcKeymap* self, GeeMap* map_entries, int* result_length1);
KkcKeymapEntry* kkc_keymap_local_entries (KkcKeymap* self, int* result_length1);
static void _vala_array_add2 (KkcKeymapEntry** array, int* length, int* size, const KkcKeymapEntry* value);
static void _vala_KkcKeymapEntry_array_free (KkcKeymapEntry* array, gint array_length);
void kkc_keymap_set (KkcKeymap* self, KkcKeyEvent* key, const gchar* command);
gchar* kkc_keymap_lookup_key (KkcKeymap* self, KkcKeyEvent* key);
KkcKeyEvent* kkc_keymap_where_is (KkcKeymap* self, const gchar* command);
KkcKeymap* kkc_keymap_new (void);
KkcKeymap* kkc_keymap_construct (GType object_type);
void kkc_keymap_set_parent (KkcKeymap* self, KkcKeymap* value);
static void kkc_keymap_finalize (GObject* obj);
static void _vala_kkc_keymap_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_keymap_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const KkcKeymapCommandEntry KKC_KEYMAP_Commands[28] = {{"abort", "Abort"}, {"first-segment", "First Segment"}, {"last-segment", "Last Segment"}, {"commit", "Commit"}, {"complete", "Complete"}, {"delete", "Delete"}, {"delete-forward", "Delete Next Character"}, {"quote", "Quoted Insert"}, {"register", "Register Word"}, {"next-candidate", "Next Candidate"}, {"previous-candidate", "Previous Candidate"}, {"purge-candidate", "Purge Candidate"}, {"next-segment", "Next Segment"}, {"previous-segment", "Previous Segment"}, {"expand-segment", "Expand Segment"}, {"shrink-segment", "Shrink Segment"}, {"set-input-mode-hiragana", "Switch to Hiragana Input Mode"}, {"set-input-mode-katakana", "Switch to Katakana Input Mode"}, {"set-input-mode-hankaku-katakana", "Switch to Hankaku Katakana Input Mode"}, {"set-input-mode-latin", "Switch to Latin Input Mode"}, {"set-input-mode-wide-latin", "Switch to Wide Latin Input Mode"}, {"set-input-mode-direct", "Switch to Direct Input Mode"}, {"convert-hiragana", "Convert to Hiragana"}, {"convert-katakana", "Convert to Katakana"}, {"convert-hankaku-katakana", "Convert to Hankaku Katakana"}, {"convert-latin", "Convert to Latin"}, {"convert-wide-latin", "Convert to Wide Latin"}, {"original-candidate", "Original Candidate"}};

void kkc_keymap_command_entry_copy (const KkcKeymapCommandEntry* self, KkcKeymapCommandEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).label;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp3_;
}


void kkc_keymap_command_entry_destroy (KkcKeymapCommandEntry* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).label);
}


KkcKeymapCommandEntry* kkc_keymap_command_entry_dup (const KkcKeymapCommandEntry* self) {
	KkcKeymapCommandEntry* dup;
	dup = g_new0 (KkcKeymapCommandEntry, 1);
	kkc_keymap_command_entry_copy (self, dup);
	return dup;
}


void kkc_keymap_command_entry_free (KkcKeymapCommandEntry* self) {
	kkc_keymap_command_entry_destroy (self);
	g_free (self);
}


GType kkc_keymap_command_entry_get_type (void) {
	static volatile gsize kkc_keymap_command_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_keymap_command_entry_type_id__volatile)) {
		GType kkc_keymap_command_entry_type_id;
		kkc_keymap_command_entry_type_id = g_boxed_type_register_static ("KkcKeymapCommandEntry", (GBoxedCopyFunc) kkc_keymap_command_entry_dup, (GBoxedFreeFunc) kkc_keymap_command_entry_free);
		g_once_init_leave (&kkc_keymap_command_entry_type_id__volatile, kkc_keymap_command_entry_type_id);
	}
	return kkc_keymap_command_entry_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void kkc_keymap_entry_copy (const KkcKeymapEntry* self, KkcKeymapEntry* dest) {
	KkcKeyEvent* _tmp0_ = NULL;
	KkcKeyEvent* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = (*self).key;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).key);
	(*dest).key = _tmp1_;
	_tmp2_ = (*self).command;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).command);
	(*dest).command = _tmp3_;
}


void kkc_keymap_entry_destroy (KkcKeymapEntry* self) {
	_g_object_unref0 ((*self).key);
	_g_free0 ((*self).command);
}


KkcKeymapEntry* kkc_keymap_entry_dup (const KkcKeymapEntry* self) {
	KkcKeymapEntry* dup;
	dup = g_new0 (KkcKeymapEntry, 1);
	kkc_keymap_entry_copy (self, dup);
	return dup;
}


void kkc_keymap_entry_free (KkcKeymapEntry* self) {
	kkc_keymap_entry_destroy (self);
	g_free (self);
}


GType kkc_keymap_entry_get_type (void) {
	static volatile gsize kkc_keymap_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_keymap_entry_type_id__volatile)) {
		GType kkc_keymap_entry_type_id;
		kkc_keymap_entry_type_id = g_boxed_type_register_static ("KkcKeymapEntry", (GBoxedCopyFunc) kkc_keymap_entry_dup, (GBoxedFreeFunc) kkc_keymap_entry_free);
		g_once_init_leave (&kkc_keymap_entry_type_id__volatile, kkc_keymap_entry_type_id);
	}
	return kkc_keymap_entry_type_id__volatile;
}


static guint _kkc_keymap_key_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = kkc_keymap_key_hash ((KkcKeyEvent*) v);
	return result;
}


static gboolean _kkc_keymap_key_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = kkc_keymap_key_equal ((KkcKeyEvent*) a, (KkcKeyEvent*) b);
	return result;
}


/**
         * List commands usable in keymap.
         *
         * @return array of commands
         */
gchar** kkc_keymap_commands (int* result_length1) {
	gchar** result = NULL;
	GeeMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gpointer* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	_tmp0_ = kkc_keymap__CommandTable;
	_tmp1_ = gee_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array ((GeeCollection*) _tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


/**
         * Return a label for a command
         *
         * @param command command
         * @return label
         */
gchar* kkc_keymap_get_command_label (const gchar* command) {
	gchar* result = NULL;
	gchar* label = NULL;
	GeeMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = kkc_keymap__CommandTable;
	_tmp1_ = command;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	label = (gchar*) _tmp2_;
	_tmp3_ = label;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = label;
		_tmp5_ = g_dgettext (GETTEXT_PACKAGE, _tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (label);
		label = _tmp6_;
	}
	result = label;
	return result;
}


static gboolean kkc_keymap_key_equal (KkcKeyEvent* a, KkcKeyEvent* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	KkcKeyEvent* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	KkcKeyEvent* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = a;
	_tmp2_ = kkc_key_event_get_keyval (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = kkc_key_event_get_keyval (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp3_ == _tmp6_) {
		KkcKeyEvent* _tmp7_ = NULL;
		KkcModifierType _tmp8_ = 0;
		KkcModifierType _tmp9_ = 0;
		KkcKeyEvent* _tmp10_ = NULL;
		KkcModifierType _tmp11_ = 0;
		KkcModifierType _tmp12_ = 0;
		_tmp7_ = a;
		_tmp8_ = kkc_key_event_get_modifiers (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = b;
		_tmp11_ = kkc_key_event_get_modifiers (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp9_ == _tmp12_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static guint kkc_keymap_key_hash (KkcKeyEvent* a) {
	guint result = 0U;
	GHashFunc _tmp0_ = NULL;
	KkcKeyEvent* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	guint _tmp5_ = 0U;
	GHashFunc _tmp6_ = NULL;
	KkcKeyEvent* _tmp7_ = NULL;
	KkcModifierType _tmp8_ = 0;
	KkcModifierType _tmp9_ = 0;
	gint _tmp10_ = 0;
	guint _tmp11_ = 0U;
	g_return_val_if_fail (a != NULL, 0U);
	_tmp0_ = g_int_hash;
	_tmp1_ = a;
	_tmp2_ = kkc_key_event_get_keyval (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (gint) _tmp3_;
	_tmp5_ = _tmp0_ (&_tmp4_);
	_tmp6_ = g_int_hash;
	_tmp7_ = a;
	_tmp8_ = kkc_key_event_get_modifiers (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = (gint) _tmp9_;
	_tmp11_ = _tmp6_ (&_tmp10_);
	result = _tmp5_ + _tmp11_;
	return result;
}


/**
         * Return all the keymap entries including parent's.
         *
         * @return array of KeymapEntry
         */
KkcKeymapEntry* kkc_keymap_entries (KkcKeymap* self, int* result_length1) {
	KkcKeymapEntry* result = NULL;
	GeeHashMap* _map_entries = NULL;
	GeeHashMap* _tmp0_ = NULL;
	KkcKeymap* _tmp1_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GeeMap* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	KkcKeymapEntry* _tmp9_ = NULL;
	KkcKeymapEntry* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (KKC_TYPE_KEY_EVENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _kkc_keymap_key_hash_gee_hash_data_func, NULL, NULL, _kkc_keymap_key_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	_map_entries = _tmp0_;
	_tmp1_ = self->priv->_parent;
	if (_tmp1_ != NULL) {
		GeeHashMap* _tmp2_ = NULL;
		KkcKeymap* _tmp3_ = NULL;
		GeeMap* _tmp4_ = NULL;
		_tmp2_ = _map_entries;
		_tmp3_ = self->priv->_parent;
		_tmp4_ = _tmp3_->priv->map_entries;
		gee_map_set_all ((GeeMap*) _tmp2_, _tmp4_);
	}
	_tmp5_ = _map_entries;
	_tmp6_ = self->priv->map_entries;
	gee_map_set_all ((GeeMap*) _tmp5_, _tmp6_);
	_tmp7_ = _map_entries;
	_tmp9_ = kkc_keymap_map_entries_to_array (self, (GeeMap*) _tmp7_, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_object_unref0 (_map_entries);
	return result;
}


/**
         * Return keymap entries not including parent's.
         *
         * @return array of KeymapEntry
         */
KkcKeymapEntry* kkc_keymap_local_entries (KkcKeymap* self, int* result_length1) {
	KkcKeymapEntry* result = NULL;
	GeeMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	KkcKeymapEntry* _tmp2_ = NULL;
	KkcKeymapEntry* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->map_entries;
	_tmp2_ = kkc_keymap_map_entries_to_array (self, _tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static void _vala_array_add2 (KkcKeymapEntry** array, int* length, int* size, const KkcKeymapEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (KkcKeymapEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_KkcKeymapEntry_array_free (KkcKeymapEntry* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			kkc_keymap_entry_destroy (&array[i]);
		}
	}
	g_free (array);
}


static KkcKeymapEntry* kkc_keymap_map_entries_to_array (KkcKeymap* self, GeeMap* map_entries, int* result_length1) {
	KkcKeymapEntry* result = NULL;
	KkcKeymapEntry* _result_ = NULL;
	KkcKeymapEntry* _tmp0_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp1_ = NULL;
	GeeMapIterator* _tmp2_ = NULL;
	KkcKeymapEntry* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (map_entries != NULL, NULL);
	_tmp0_ = g_new0 (KkcKeymapEntry, 0);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = map_entries;
	_tmp2_ = gee_map_map_iterator (_tmp1_);
	iter = _tmp2_;
	while (TRUE) {
		GeeMapIterator* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		KkcKeyEvent* key = NULL;
		GeeMapIterator* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		gchar* command = NULL;
		GeeMapIterator* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		KkcKeymapEntry entry = {0};
		KkcKeyEvent* _tmp9_ = NULL;
		KkcKeyEvent* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		KkcKeymapEntry _tmp13_ = {0};
		KkcKeymapEntry* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		KkcKeymapEntry _tmp15_ = {0};
		KkcKeymapEntry _tmp16_ = {0};
		_tmp3_ = iter;
		_tmp4_ = gee_map_iterator_next (_tmp3_);
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = iter;
		_tmp6_ = gee_map_iterator_get_key (_tmp5_);
		key = (KkcKeyEvent*) _tmp6_;
		_tmp7_ = iter;
		_tmp8_ = gee_map_iterator_get_value (_tmp7_);
		command = (gchar*) _tmp8_;
		_tmp9_ = key;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_tmp11_ = command;
		_tmp12_ = g_strdup (_tmp11_);
		_g_object_unref0 (_tmp13_.key);
		_tmp13_.key = _tmp10_;
		_g_free0 (_tmp13_.command);
		_tmp13_.command = _tmp12_;
		entry = _tmp13_;
		_tmp14_ = _result_;
		_tmp14__length1 = _result__length1;
		_tmp15_ = entry;
		kkc_keymap_entry_copy (&_tmp15_, &_tmp16_);
		_vala_array_add2 (&_result_, &_result__length1, &__result__size_, &_tmp16_);
		kkc_keymap_entry_destroy (&entry);
		_g_free0 (command);
		_g_object_unref0 (key);
	}
	_tmp17_ = _result_;
	_tmp17__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	_g_object_unref0 (iter);
	return result;
}


/**
         * Bind a key event to a command.
         *
         * @param key key event
         * @param command command or `null` to unset
         */
void kkc_keymap_set (KkcKeymap* self, KkcKeyEvent* key, const gchar* command) {
	GeeMap* _tmp0_ = NULL;
	KkcKeyEvent* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->map_entries;
	_tmp1_ = key;
	_tmp2_ = command;
	gee_map_set (_tmp0_, _tmp1_, _tmp2_);
}


/**
         * Lookup a command bound to a key event.
         *
         * @param key key event
         * @return command or `null`
         */
gchar* kkc_keymap_lookup_key (KkcKeymap* self, KkcKeyEvent* key) {
	gchar* result = NULL;
	GeeMap* _tmp0_ = NULL;
	KkcKeyEvent* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	KkcKeymap* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->map_entries;
	_tmp1_ = key;
	_tmp2_ = gee_map_has_key (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GeeMap* _tmp3_ = NULL;
		KkcKeyEvent* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		_tmp3_ = self->priv->map_entries;
		_tmp4_ = key;
		_tmp5_ = gee_map_get (_tmp3_, _tmp4_);
		result = (gchar*) _tmp5_;
		return result;
	}
	_tmp6_ = self->priv->_parent;
	if (_tmp6_ != NULL) {
		KkcKeymap* _tmp7_ = NULL;
		KkcKeyEvent* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp7_ = self->priv->_parent;
		_tmp8_ = key;
		_tmp9_ = kkc_keymap_lookup_key (_tmp7_, _tmp8_);
		result = _tmp9_;
		return result;
	}
	result = NULL;
	return result;
}


/**
         * Lookup a key event to which a command is bound.
         *
         * @param command command
         * @return a key event or `null`
         */
KkcKeyEvent* kkc_keymap_where_is (KkcKeymap* self, const gchar* command) {
	KkcKeyEvent* result = NULL;
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	KkcKeymap* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = self->priv->map_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_map_iterator_get_value (_tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_tmp7_ = command;
		_tmp8_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
		_g_free0 (_tmp6_);
		if (_tmp8_) {
			GeeMapIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			_tmp9_ = iter;
			_tmp10_ = gee_map_iterator_get_key (_tmp9_);
			result = (KkcKeyEvent*) _tmp10_;
			_g_object_unref0 (iter);
			return result;
		}
	}
	_tmp11_ = self->priv->_parent;
	if (_tmp11_ != NULL) {
		KkcKeymap* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		KkcKeyEvent* _tmp14_ = NULL;
		_tmp12_ = self->priv->_parent;
		_tmp13_ = command;
		_tmp14_ = kkc_keymap_where_is (_tmp12_, _tmp13_);
		result = _tmp14_;
		_g_object_unref0 (iter);
		return result;
	}
	result = NULL;
	_g_object_unref0 (iter);
	return result;
}


KkcKeymap* kkc_keymap_construct (GType object_type) {
	KkcKeymap * self = NULL;
	self = (KkcKeymap*) g_object_new (object_type, NULL);
	return self;
}


KkcKeymap* kkc_keymap_new (void) {
	return kkc_keymap_construct (KKC_TYPE_KEYMAP);
}


KkcKeymap* kkc_keymap_get_parent (KkcKeymap* self) {
	KkcKeymap* result;
	KkcKeymap* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}


void kkc_keymap_set_parent (KkcKeymap* self, KkcKeymap* value) {
	KkcKeymap* _tmp0_ = NULL;
	KkcKeymap* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_parent);
	self->priv->_parent = _tmp1_;
	g_object_notify ((GObject *) self, "parent");
}


static void kkc_keymap_class_init (KkcKeymapClass * klass) {
	GeeHashMap* _tmp0_ = NULL;
	kkc_keymap_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcKeymapPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_keymap_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_keymap_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_keymap_finalize;
	/**
	         * Parent keymap.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEYMAP_PARENT, g_param_spec_object ("parent", "parent", "parent", KKC_TYPE_KEYMAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	kkc_keymap__CommandTable = (GeeMap*) _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				GeeMap* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				KkcKeymapCommandEntry _tmp6_ = {0};
				const gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				KkcKeymapCommandEntry _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < G_N_ELEMENTS (KKC_KEYMAP_Commands))) {
					break;
				}
				_tmp4_ = kkc_keymap__CommandTable;
				_tmp5_ = i;
				_tmp6_ = KKC_KEYMAP_Commands[_tmp5_];
				_tmp7_ = _tmp6_.name;
				_tmp8_ = i;
				_tmp9_ = KKC_KEYMAP_Commands[_tmp8_];
				_tmp10_ = _tmp9_.label;
				gee_map_set (_tmp4_, _tmp7_, _tmp10_);
			}
		}
	}
}


static void kkc_keymap_instance_init (KkcKeymap * self) {
	GeeHashMap* _tmp0_ = NULL;
	self->priv = KKC_KEYMAP_GET_PRIVATE (self);
	self->priv->_parent = NULL;
	_tmp0_ = gee_hash_map_new (KKC_TYPE_KEY_EVENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _kkc_keymap_key_hash_gee_hash_data_func, NULL, NULL, _kkc_keymap_key_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->map_entries = (GeeMap*) _tmp0_;
}


static void kkc_keymap_finalize (GObject* obj) {
	KkcKeymap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_KEYMAP, KkcKeymap);
	_g_object_unref0 (self->priv->_parent);
	_g_object_unref0 (self->priv->map_entries);
	G_OBJECT_CLASS (kkc_keymap_parent_class)->finalize (obj);
}


/**
     * Object representing a keymap.
     */
GType kkc_keymap_get_type (void) {
	static volatile gsize kkc_keymap_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_keymap_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcKeymapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_keymap_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcKeymap), 0, (GInstanceInitFunc) kkc_keymap_instance_init, NULL };
		GType kkc_keymap_type_id;
		kkc_keymap_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcKeymap", &g_define_type_info, 0);
		g_once_init_leave (&kkc_keymap_type_id__volatile, kkc_keymap_type_id);
	}
	return kkc_keymap_type_id__volatile;
}


static void _vala_kkc_keymap_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcKeymap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_KEYMAP, KkcKeymap);
	switch (property_id) {
		case KKC_KEYMAP_PARENT:
		g_value_set_object (value, kkc_keymap_get_parent (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_keymap_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcKeymap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_KEYMAP, KkcKeymap);
	switch (property_id) {
		case KKC_KEYMAP_PARENT:
		kkc_keymap_set_parent (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



