/* gterminal.c generated by valac 0.34.7, the Vala compiler
 * generated from gterminal.vala, do not modify */

/*
 * Copyright © 2014 Christian Persch
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "terminal-client-utils.h"
#include <gio/gunixfdlist.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include "terminal-profiles-list.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/wait.h>
#include "terminal-settings-list.h"
#include <locale.h>


#define GTERMINAL_TYPE_OUTPUT (gterminal_output_get_type ())
typedef struct _GTerminalOutput GTerminalOutput;
#define _g_option_group_free0(var) ((var == NULL) ? NULL : (var = (g_option_group_free (var), NULL)))

#define GTERMINAL_TYPE_GLOBAL_OPTIONS (gterminal_global_options_get_type ())
typedef struct _GTerminalGlobalOptions GTerminalGlobalOptions;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GTERMINAL_TYPE_OPEN_OPTIONS (gterminal_open_options_get_type ())
typedef struct _GTerminalOpenOptions GTerminalOpenOptions;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define GTERMINAL_TYPE_SERVER (gterminal_server_get_type ())
#define GTERMINAL_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTERMINAL_TYPE_SERVER, GTerminalServer))
#define GTERMINAL_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTERMINAL_TYPE_SERVER))
#define GTERMINAL_SERVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTERMINAL_TYPE_SERVER, GTerminalServerIface))

typedef struct _GTerminalServer GTerminalServer;
typedef struct _GTerminalServerIface GTerminalServerIface;

#define GTERMINAL_TYPE_SERVER_PROXY (gterminal_server_proxy_get_type ())
typedef GDBusProxy GTerminalServerProxy;
typedef GDBusProxyClass GTerminalServerProxyClass;

#define GTERMINAL_TYPE_RECEIVER (gterminal_receiver_get_type ())
#define GTERMINAL_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTERMINAL_TYPE_RECEIVER, GTerminalReceiver))
#define GTERMINAL_IS_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTERMINAL_TYPE_RECEIVER))
#define GTERMINAL_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTERMINAL_TYPE_RECEIVER, GTerminalReceiverIface))

typedef struct _GTerminalReceiver GTerminalReceiver;
typedef struct _GTerminalReceiverIface GTerminalReceiverIface;

#define GTERMINAL_TYPE_RECEIVER_PROXY (gterminal_receiver_proxy_get_type ())
typedef GDBusProxy GTerminalReceiverProxy;
typedef GDBusProxyClass GTerminalReceiverProxyClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define GTERMINAL_TYPE_VERB (gterminal_verb_get_type ())
typedef struct _GTerminalVerb GTerminalVerb;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_key_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_key_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GTerminalOutput {
};

struct _GTerminalGlobalOptions {
};

struct _GTerminalOpenOptions {
};

struct _GTerminalServerIface {
	GTypeInterface parent_iface;
};

struct _GTerminalReceiverIface {
	GTypeInterface parent_iface;
};

typedef gint (*GTerminalVerbFunc) (gchar** args, int args_length1, void* user_data, GError** error);
struct _GTerminalVerb {
	gchar* verb;
	GTerminalVerbFunc func;
	gpointer func_target;
};

struct _Block1Data {
	int _ref_count_;
	gint status;
	GMainLoop* loop;
};


extern gboolean gterminal_output_quiet;
gboolean gterminal_output_quiet = FALSE;
extern gboolean gterminal_output_verbose;
gboolean gterminal_output_verbose = FALSE;
extern gchar* gterminal_global_options_app_id;
gchar* gterminal_global_options_app_id = NULL;
extern gboolean gterminal_global_options_complete;
gboolean gterminal_global_options_complete = FALSE;
extern gchar** gterminal_open_options_pass_fds;
gchar** gterminal_open_options_pass_fds = NULL;
extern gboolean gterminal_open_options_pass_stdin;
gboolean gterminal_open_options_pass_stdin = FALSE;
extern gboolean gterminal_open_options_pass_stdout;
gboolean gterminal_open_options_pass_stdout = FALSE;
extern gboolean gterminal_open_options_pass_stderr;
gboolean gterminal_open_options_pass_stderr = FALSE;
extern PassFdElement* gterminal_open_options_fd_array;
extern gint gterminal_open_options_fd_array_length1;
PassFdElement* gterminal_open_options_fd_array = NULL;
gint gterminal_open_options_fd_array_length1 = 0;
extern GUnixFDList* gterminal_open_options_fd_list;
GUnixFDList* gterminal_open_options_fd_list = NULL;
extern gchar* gterminal_open_options_geometry;
gchar* gterminal_open_options_geometry = NULL;
extern gchar* gterminal_open_options_role;
gchar* gterminal_open_options_role = NULL;
extern gboolean gterminal_open_options_show_menubar;
gboolean gterminal_open_options_show_menubar = TRUE;
extern gboolean gterminal_open_options_show_menubar_set;
gboolean gterminal_open_options_show_menubar_set = FALSE;
extern gboolean gterminal_open_options_maximise;
gboolean gterminal_open_options_maximise = FALSE;
extern gboolean gterminal_open_options_fullscreen;
gboolean gterminal_open_options_fullscreen = FALSE;
extern gchar* gterminal_open_options_working_directory;
gchar* gterminal_open_options_working_directory = NULL;
extern gchar* gterminal_open_options_profile;
gchar* gterminal_open_options_profile = NULL;
extern gdouble gterminal_open_options_zoom;
gdouble gterminal_open_options_zoom = 1.0;
extern gboolean gterminal_open_options_wait_for_remote;
gboolean gterminal_open_options_wait_for_remote = FALSE;
extern gchar** gterminal_open_options_argv_pre;
gchar** gterminal_open_options_argv_pre = NULL;
extern gchar** gterminal_open_options_argv_post;
gchar** gterminal_open_options_argv_post = NULL;
extern gchar* gterminal_open_options_display_name;
gchar* gterminal_open_options_display_name = NULL;
extern gchar* gterminal_open_options_startup_id;
gchar* gterminal_open_options_startup_id = NULL;

GType gterminal_output_get_type (void) G_GNUC_CONST;
GTerminalOutput* gterminal_output_dup (const GTerminalOutput* self);
void gterminal_output_free (GTerminalOutput* self);
void gterminal_output_set_quiet (gboolean value);
GOptionGroup* gterminal_output_get_option_group (GTerminalOutput *self);
void gterminal_output_print (const gchar* format, ...);
void gterminal_output_printerr (const gchar* format, ...);
void gterminal_output_info (const gchar* format, ...);
GType gterminal_global_options_get_type (void) G_GNUC_CONST;
GTerminalGlobalOptions* gterminal_global_options_dup (const GTerminalGlobalOptions* self);
void gterminal_global_options_free (GTerminalGlobalOptions* self);
static gboolean gterminal_global_options_option_app_id (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error);
gchar* gterminal_global_options_get_app_id (void);
gboolean gterminal_global_options_get_complete (void);
GOptionGroup* gterminal_global_options_get_option_group (void);
GType gterminal_open_options_get_type (void) G_GNUC_CONST;
GTerminalOpenOptions* gterminal_open_options_dup (const GTerminalOpenOptions* self);
void gterminal_open_options_free (GTerminalOpenOptions* self);
static gboolean gterminal_open_options_option_profile (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error);
static gboolean gterminal_open_options_option_zoom (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error);
static gboolean gterminal_open_options_post_parse (GOptionContext* context, GOptionGroup* group, void* unused_user_data, GError** error);
static void _vala_array_add1 (PassFdElement** array, int* length, int* size, PassFdElement value);
static PassFdElement* _vala_array_dup1 (PassFdElement* self, int length);
GOptionGroup* gterminal_open_options_get_exec_option_group (void);
GOptionGroup* gterminal_open_options_get_window_option_group (void);
GOptionGroup* gterminal_open_options_get_terminal_option_group (void);
GOptionGroup* gterminal_open_options_get_processing_option_group (void);
void gterminal_open_options_parse_argv (gchar** argv, int argv_length1, GError** error);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
GType gterminal_server_get_type (void) G_GNUC_CONST;
GType gterminal_server_proxy_get_type (void) G_GNUC_CONST;
guint gterminal_server_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define GTERMINAL_SERVER_SERVICE_NAME "org.gnome.Terminal"
#define GTERMINAL_SERVER_INTERFACE_NAME "org.gnome.Terminal.Factory0"
#define GTERMINAL_SERVER_OBJECT_PATH "/org/gnome/Terminal/Factory0"
static void gterminal_server_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void gterminal_server_proxy_gterminal_server_interface_init (GTerminalServerIface* iface);
static void gterminal_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gterminal_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gterminal_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _gterminal_server_unregister_object (gpointer user_data);
GType gterminal_receiver_get_type (void) G_GNUC_CONST;
GType gterminal_receiver_proxy_get_type (void) G_GNUC_CONST;
guint gterminal_receiver_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define GTERMINAL_RECEIVER_INTERFACE_NAME "org.gnome.Terminal.Terminal0"
static void gterminal_receiver_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_gterminal_receiver_child_exited (GTerminalReceiver* self, GVariant* parameters);
static void gterminal_receiver_proxy_gterminal_receiver_interface_init (GTerminalReceiverIface* iface);
static void gterminal_receiver_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gterminal_receiver_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gterminal_receiver_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_gterminal_receiver_child_exited (GObject* _sender, gint exit_code, gpointer* _data);
static void _gterminal_receiver_unregister_object (gpointer user_data);
GTerminalServer* gterminal_get_server (GError** error);
GTerminalReceiver* gterminal_create_terminal (GError** error);
gint gterminal_mangle_exit_code (gint status);
GType gterminal_verb_get_type (void) G_GNUC_CONST;
GTerminalVerb* gterminal_verb_dup (const GTerminalVerb* self);
void gterminal_verb_free (GTerminalVerb* self);
void gterminal_verb_copy (const GTerminalVerb* self, GTerminalVerb* dest);
void gterminal_verb_destroy (GTerminalVerb* self);
void gterminal_verb_init (GTerminalVerb *self, const gchar* verb, GTerminalVerbFunc func, void* func_target);
gint gterminal_apply_map (GTerminalVerb* commands, int commands_length1, gchar** argv, int argv_length1, GError** error);
gint gterminal_run (GTerminalReceiver* receiver);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_, gint s);
static void ___lambda4__gterminal_receiver_child_exited (GTerminalReceiver* _sender, gint exit_code, gpointer self);
gint gterminal_open (gchar** argv, int argv_length1, GError** error);
gint gterminal_help (gchar** argv, int argv_length1, GError** error);
gint gterminal_profile__list (gchar** argv, int argv_length1, GError** error);
gint gterminal_profile_get (gchar** argv, int argv_length1, GError** error);
gint gterminal_profile_set (gchar** argv, int argv_length1, GError** error);
gint gterminal_profile (gchar** argv, int argv_length1, GError** error);
static gint _gterminal_profile__list_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profile_get_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profile_set_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static void _vala_GTerminalVerb_array_free (GTerminalVerb* array, gint array_length);
gint gterminal_profiles_list (gchar** argv, int argv_length1, GError** error);
gint gterminal_profiles_get_default (gchar** argv, int argv_length1, GError** error);
gint gterminal_profiles_set_default (gchar** argv, int argv_length1, GError** error);
gint gterminal_profiles_add (gchar** argv, int argv_length1, GError** error);
gint gterminal_profiles_clone (gchar** argv, int argv_length1, GError** error);
gint gterminal_profiles_remove (gchar** argv, int argv_length1, GError** error);
gint gterminal_profiles (gchar** argv, int argv_length1, GError** error);
static gint _gterminal_profiles_add_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profiles_clone_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profiles_get_default_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profiles_list_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profiles_remove_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profiles_set_default_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
gint gterminal_main (gchar** argv, int argv_length1);
static gint _gterminal_help_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_open_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profile_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_profiles_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry GTERMINAL_OUTPUT_entries[3] = {{"quiet", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_output_quiet, "Suppress output", NULL}, {"verbose", 'v', (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_output_verbose, "Verbose output", NULL}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_GLOBAL_OPTIONS_entries[3] = {{"app-id", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_CALLBACK, (void*) gterminal_global_options_option_app_id, "Server application ID", "ID"}, {"complete", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_global_options_complete, "Show completions", NULL}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_exec_entries[5] = {{"stdin", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_open_options_pass_stdin, "Forward stdin", NULL}, {"stdout", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_open_options_pass_stdout, "Forward stdout", NULL}, {"stderr", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_open_options_pass_stderr, "Forward stderr", NULL}, {"fd", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &gterminal_open_options_pass_fds, "Forward file descriptor", "FD"}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_window_entries[5] = {{"maximise", (gchar) 0, 0, G_OPTION_ARG_NONE, &gterminal_open_options_maximise, "Maximise the window", NULL}, {"fullscreen", (gchar) 0, 0, G_OPTION_ARG_NONE, &gterminal_open_options_fullscreen, "Full-screen the window", NULL}, {"geometry", (gchar) 0, 0, G_OPTION_ARG_STRING, &gterminal_open_options_geometry, "Set the window size; for example: 80x24, or 80x24+200+200 (COLSxROWS+X" \
"+Y)", "GEOMETRY"}, {"role", (gchar) 0, 0, G_OPTION_ARG_STRING, &gterminal_open_options_role, "Set the window role", "ROLE"}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_terminal_entries[4] = {{"profile", (gchar) 0, 0, G_OPTION_ARG_CALLBACK, (void*) gterminal_open_options_option_profile, "Use the given profile instead of the default profile", "UUID"}, {"cwd", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &gterminal_open_options_working_directory, "Set the working directory", "DIRNAME"}, {"zoom", (gchar) 0, 0, G_OPTION_ARG_CALLBACK, (void*) gterminal_open_options_option_zoom, "Set the terminal’s zoom factor (1.0 = normal size)", "ZOOM"}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_processing_entries[2] = {{"wait", (gchar) 0, 0, G_OPTION_ARG_NONE, &gterminal_open_options_wait_for_remote, "Wait until the child exits", NULL}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GDBusMethodInfo * const _gterminal_server_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _gterminal_server_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gterminal_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gterminal_server_dbus_interface_info = {-1, "org.gnome.Terminal.Factory0", (GDBusMethodInfo **) (&_gterminal_server_dbus_method_info), (GDBusSignalInfo **) (&_gterminal_server_dbus_signal_info), (GDBusPropertyInfo **) (&_gterminal_server_dbus_property_info)};
static const GDBusInterfaceVTable _gterminal_server_dbus_interface_vtable = {gterminal_server_dbus_interface_method_call, gterminal_server_dbus_interface_get_property, gterminal_server_dbus_interface_set_property};
static const GDBusMethodInfo * const _gterminal_receiver_dbus_method_info[] = {NULL};
static const GDBusArgInfo _gterminal_receiver_dbus_arg_info_child_exited_exit_code = {-1, "exit_code", "i"};
static const GDBusArgInfo * const _gterminal_receiver_dbus_arg_info_child_exited[] = {&_gterminal_receiver_dbus_arg_info_child_exited_exit_code, NULL};
static const GDBusSignalInfo _gterminal_receiver_dbus_signal_info_child_exited = {-1, "ChildExited", (GDBusArgInfo **) (&_gterminal_receiver_dbus_arg_info_child_exited)};
static const GDBusSignalInfo * const _gterminal_receiver_dbus_signal_info[] = {&_gterminal_receiver_dbus_signal_info_child_exited, NULL};
static const GDBusPropertyInfo * const _gterminal_receiver_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gterminal_receiver_dbus_interface_info = {-1, "org.gnome.Terminal.Terminal0", (GDBusMethodInfo **) (&_gterminal_receiver_dbus_method_info), (GDBusSignalInfo **) (&_gterminal_receiver_dbus_signal_info), (GDBusPropertyInfo **) (&_gterminal_receiver_dbus_property_info)};
static const GDBusInterfaceVTable _gterminal_receiver_dbus_interface_vtable = {gterminal_receiver_dbus_interface_method_call, gterminal_receiver_dbus_interface_get_property, gterminal_receiver_dbus_interface_set_property};

void gterminal_output_set_quiet (gboolean value) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = value;
	gterminal_output_quiet = _tmp0_;
}


GOptionGroup* gterminal_output_get_option_group (GTerminalOutput *self) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("output", "Output options:", "Show output options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OUTPUT_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


void gterminal_output_print (const gchar* format, ...) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (format != NULL);
	_tmp0_ = gterminal_output_quiet;
	if (!_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		va_list _tmp3_ = {0};
		_tmp1_ = stdout;
		_tmp2_ = format;
		va_start (_tmp3_, format);
		vfprintf (_tmp1_, _tmp2_, _tmp3_);
		va_end (_tmp3_);
	}
}


void gterminal_output_printerr (const gchar* format, ...) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (format != NULL);
	_tmp0_ = gterminal_output_quiet;
	if (!_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		va_list _tmp3_ = {0};
		_tmp1_ = stderr;
		_tmp2_ = format;
		va_start (_tmp3_, format);
		vfprintf (_tmp1_, _tmp2_, _tmp3_);
		va_end (_tmp3_);
	}
}


void gterminal_output_info (const gchar* format, ...) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (format != NULL);
	_tmp0_ = gterminal_output_verbose;
	if (_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		va_list _tmp3_ = {0};
		_tmp1_ = stderr;
		_tmp2_ = format;
		va_start (_tmp3_, format);
		vfprintf (_tmp1_, _tmp2_, _tmp3_);
		va_end (_tmp3_);
	}
}


GTerminalOutput* gterminal_output_dup (const GTerminalOutput* self) {
	GTerminalOutput* dup;
	dup = g_new0 (GTerminalOutput, 1);
	memcpy (dup, self, sizeof (GTerminalOutput));
	return dup;
}


void gterminal_output_free (GTerminalOutput* self) {
	g_free (self);
}


GType gterminal_output_get_type (void) {
	static volatile gsize gterminal_output_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_output_type_id__volatile)) {
		GType gterminal_output_type_id;
		gterminal_output_type_id = g_boxed_type_register_static ("GTerminalOutput", (GBoxedCopyFunc) gterminal_output_dup, (GBoxedFreeFunc) gterminal_output_free);
		g_once_init_leave (&gterminal_output_type_id__volatile, gterminal_output_type_id);
	}
	return gterminal_output_type_id__volatile;
}


static gboolean gterminal_global_options_option_app_id (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = value;
	_tmp1_ = g_application_id_is_valid (_tmp0_);
	if (!_tmp1_) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = _ ("“%s” is not a valid application ID");
		_tmp3_ = value;
		_tmp4_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp2_, _tmp3_);
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == G_OPTION_ERROR) {
			gboolean _tmp5_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp5_;
		} else {
			gboolean _tmp6_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp6_;
		}
	}
	_tmp7_ = value;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (gterminal_global_options_app_id);
	gterminal_global_options_app_id = _tmp8_;
	result = TRUE;
	return result;
}


gchar* gterminal_global_options_get_app_id (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp1_ = gterminal_global_options_app_id;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = gterminal_global_options_app_id;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "org.gnome.Terminal";
	}
	_tmp3_ = g_strdup (_tmp0_);
	result = _tmp3_;
	return result;
}


gboolean gterminal_global_options_get_complete (void) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = gterminal_global_options_complete;
	result = _tmp0_;
	return result;
}


GOptionGroup* gterminal_global_options_get_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("global", "Global options:", "Show global options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_GLOBAL_OPTIONS_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


GTerminalGlobalOptions* gterminal_global_options_dup (const GTerminalGlobalOptions* self) {
	GTerminalGlobalOptions* dup;
	dup = g_new0 (GTerminalGlobalOptions, 1);
	memcpy (dup, self, sizeof (GTerminalGlobalOptions));
	return dup;
}


void gterminal_global_options_free (GTerminalGlobalOptions* self) {
	g_free (self);
}


GType gterminal_global_options_get_type (void) {
	static volatile gsize gterminal_global_options_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_global_options_type_id__volatile)) {
		GType gterminal_global_options_type_id;
		gterminal_global_options_type_id = g_boxed_type_register_static ("GTerminalGlobalOptions", (GBoxedCopyFunc) gterminal_global_options_dup, (GBoxedFreeFunc) gterminal_global_options_free);
		g_once_init_leave (&gterminal_global_options_type_id__volatile, gterminal_global_options_type_id);
	}
	return gterminal_global_options_type_id__volatile;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static void _vala_array_add1 (PassFdElement** array, int* length, int* size, PassFdElement value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PassFdElement, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static PassFdElement* _vala_array_dup1 (PassFdElement* self, int length) {
	return g_memdup (self, length * sizeof (PassFdElement));
}


static gboolean gterminal_open_options_post_parse (GOptionContext* context, GOptionGroup* group, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	GUnixFDList* _tmp15_ = NULL;
	PassFdElement* arr = NULL;
	PassFdElement* _tmp16_ = NULL;
	gint arr_length1 = 0;
	gint _arr_size_ = 0;
	PassFdElement* _tmp78_ = NULL;
	gint _tmp78__length1 = 0;
	PassFdElement* _tmp79_ = NULL;
	gint _tmp79__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	_tmp2_ = gterminal_open_options_pass_stdin;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = gterminal_open_options_pass_stdout;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = gterminal_open_options_pass_stderr;
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		GError* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp6_ = gterminal_open_options_pass_stdin;
		if (_tmp6_) {
			const gchar* _tmp7_ = NULL;
			_tmp7_ = _ ("FD passing of stdin is not supported");
			_tmp5_ = _tmp7_;
		} else {
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp9_ = gterminal_open_options_pass_stdout;
			if (_tmp9_) {
				const gchar* _tmp10_ = NULL;
				_tmp10_ = _ ("FD passing of stdout is not supported");
				_tmp8_ = _tmp10_;
			} else {
				const gchar* _tmp11_ = NULL;
				_tmp11_ = _ ("FD passing of stderr is not supported");
				_tmp8_ = _tmp11_;
			}
			_tmp5_ = _tmp8_;
		}
		_tmp12_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp5_);
		_inner_error_ = _tmp12_;
		g_propagate_error (error, _inner_error_);
		return _tmp13_;
	}
	_tmp14_ = gterminal_open_options_pass_fds;
	_tmp14__length1 = _vala_array_length (gterminal_open_options_pass_fds);
	if (_tmp14_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp15_ = g_unix_fd_list_new ();
	_g_object_unref0 (gterminal_open_options_fd_list);
	gterminal_open_options_fd_list = _tmp15_;
	_tmp16_ = g_new0 (PassFdElement, 0);
	arr = _tmp16_;
	arr_length1 = 0;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				guint _tmp19_ = 0U;
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				gint64 v = 0LL;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				guint _tmp25_ = 0U;
				const gchar* _tmp26_ = NULL;
				gint64 _tmp27_ = 0LL;
				gboolean _tmp28_ = FALSE;
				gint fd = 0;
				gint64 _tmp38_ = 0LL;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				gint _tmp41_ = 0;
				gint idx = 0;
				GUnixFDList* _tmp66_ = NULL;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				PassFdElement e = {0};
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
				PassFdElement _tmp72_ = {0};
				PassFdElement* _tmp73_ = NULL;
				gint _tmp73__length1 = 0;
				PassFdElement _tmp74_ = {0};
				gboolean _tmp75_ = FALSE;
				gint _tmp76_ = 0;
				if (!_tmp17_) {
					guint _tmp18_ = 0U;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = gterminal_open_options_pass_fds;
				_tmp20__length1 = _vala_array_length (gterminal_open_options_pass_fds);
				if (!(_tmp19_ < ((guint) _tmp20__length1))) {
					break;
				}
				_tmp24_ = gterminal_open_options_pass_fds;
				_tmp24__length1 = _vala_array_length (gterminal_open_options_pass_fds);
				_tmp25_ = i;
				_tmp26_ = _tmp24_[_tmp25_];
				_tmp28_ = int64_try_parse (_tmp26_, &_tmp27_);
				v = _tmp27_;
				if (!_tmp28_) {
					_tmp23_ = TRUE;
				} else {
					gint64 _tmp29_ = 0LL;
					_tmp29_ = v;
					_tmp23_ = _tmp29_ == ((gint64) -1);
				}
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					gint64 _tmp30_ = 0LL;
					_tmp30_ = v;
					_tmp22_ = _tmp30_ < ((gint64) G_MININT);
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					gint64 _tmp31_ = 0LL;
					_tmp31_ = v;
					_tmp21_ = _tmp31_ > ((gint64) G_MAXINT);
				}
				if (_tmp21_) {
					const gchar* _tmp32_ = NULL;
					gchar** _tmp33_ = NULL;
					gint _tmp33__length1 = 0;
					guint _tmp34_ = 0U;
					const gchar* _tmp35_ = NULL;
					GError* _tmp36_ = NULL;
					gboolean _tmp37_ = FALSE;
					_tmp32_ = _ ("Invalid argument “%s” to --fd option");
					_tmp33_ = gterminal_open_options_pass_fds;
					_tmp33__length1 = _vala_array_length (gterminal_open_options_pass_fds);
					_tmp34_ = i;
					_tmp35_ = _tmp33_[_tmp34_];
					_tmp36_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp32_, _tmp35_);
					_inner_error_ = _tmp36_;
					g_propagate_error (error, _inner_error_);
					arr = (g_free (arr), NULL);
					return _tmp37_;
				}
				_tmp38_ = v;
				fd = (gint) _tmp38_;
				_tmp41_ = fd;
				if (_tmp41_ == STDIN_FILENO) {
					_tmp40_ = TRUE;
				} else {
					gint _tmp42_ = 0;
					_tmp42_ = fd;
					_tmp40_ = _tmp42_ == STDOUT_FILENO;
				}
				if (_tmp40_) {
					_tmp39_ = TRUE;
				} else {
					gint _tmp43_ = 0;
					_tmp43_ = fd;
					_tmp39_ = _tmp43_ == STDERR_FILENO;
				}
				if (_tmp39_) {
					const gchar* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					GError* _tmp51_ = NULL;
					gboolean _tmp52_ = FALSE;
					_tmp45_ = fd;
					if (_tmp45_ == STDIN_FILENO) {
						const gchar* _tmp46_ = NULL;
						_tmp46_ = _ ("FD passing of stdin is not supported");
						_tmp44_ = _tmp46_;
					} else {
						const gchar* _tmp47_ = NULL;
						gint _tmp48_ = 0;
						_tmp48_ = fd;
						if (_tmp48_ == STDOUT_FILENO) {
							const gchar* _tmp49_ = NULL;
							_tmp49_ = _ ("FD passing of stdout is not supported");
							_tmp47_ = _tmp49_;
						} else {
							const gchar* _tmp50_ = NULL;
							_tmp50_ = _ ("FD passing of stderr is not supported");
							_tmp47_ = _tmp50_;
						}
						_tmp44_ = _tmp47_;
					}
					_tmp51_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp44_);
					_inner_error_ = _tmp51_;
					g_propagate_error (error, _inner_error_);
					arr = (g_free (arr), NULL);
					return _tmp52_;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp53_ = FALSE;
						_tmp53_ = TRUE;
						while (TRUE) {
							guint _tmp55_ = 0U;
							PassFdElement* _tmp56_ = NULL;
							gint _tmp56__length1 = 0;
							PassFdElement* _tmp57_ = NULL;
							gint _tmp57__length1 = 0;
							guint _tmp58_ = 0U;
							PassFdElement _tmp59_ = {0};
							gint _tmp60_ = 0;
							gint _tmp61_ = 0;
							if (!_tmp53_) {
								guint _tmp54_ = 0U;
								_tmp54_ = j;
								j = _tmp54_ + 1;
							}
							_tmp53_ = FALSE;
							_tmp55_ = j;
							_tmp56_ = arr;
							_tmp56__length1 = arr_length1;
							if (!(_tmp55_ < ((guint) _tmp56__length1))) {
								break;
							}
							_tmp57_ = arr;
							_tmp57__length1 = arr_length1;
							_tmp58_ = j;
							_tmp59_ = _tmp57_[_tmp58_];
							_tmp60_ = _tmp59_.fd;
							_tmp61_ = fd;
							if (_tmp60_ == _tmp61_) {
								const gchar* _tmp62_ = NULL;
								gint _tmp63_ = 0;
								GError* _tmp64_ = NULL;
								gboolean _tmp65_ = FALSE;
								_tmp62_ = _ ("Cannot pass FD %d twice");
								_tmp63_ = fd;
								_tmp64_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp62_, _tmp63_);
								_inner_error_ = _tmp64_;
								g_propagate_error (error, _inner_error_);
								arr = (g_free (arr), NULL);
								return _tmp65_;
							}
						}
					}
				}
				_tmp66_ = gterminal_open_options_fd_list;
				_tmp67_ = fd;
				_tmp68_ = g_unix_fd_list_append (_tmp66_, _tmp67_, &_inner_error_);
				idx = _tmp68_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp69_ = FALSE;
					g_propagate_error (error, _inner_error_);
					arr = (g_free (arr), NULL);
					return _tmp69_;
				}
				_tmp70_ = idx;
				_tmp71_ = fd;
				_tmp72_.index = _tmp70_;
				_tmp72_.fd = _tmp71_;
				e = _tmp72_;
				_tmp73_ = arr;
				_tmp73__length1 = arr_length1;
				_tmp74_ = e;
				_vala_array_add1 (&arr, &arr_length1, &_arr_size_, _tmp74_);
				_tmp76_ = fd;
				if (_tmp76_ == STDOUT_FILENO) {
					_tmp75_ = TRUE;
				} else {
					gint _tmp77_ = 0;
					_tmp77_ = fd;
					_tmp75_ = _tmp77_ == STDERR_FILENO;
				}
				if (_tmp75_) {
					gterminal_output_set_quiet (TRUE);
				}
			}
		}
	}
	_tmp78_ = arr;
	_tmp78__length1 = arr_length1;
	_tmp79_ = (_tmp78_ != NULL) ? _vala_array_dup1 (_tmp78_, _tmp78__length1) : ((gpointer) _tmp78_);
	_tmp79__length1 = _tmp78__length1;
	gterminal_open_options_fd_array = (g_free (gterminal_open_options_fd_array), NULL);
	gterminal_open_options_fd_array = _tmp79_;
	gterminal_open_options_fd_array_length1 = _tmp79__length1;
	result = TRUE;
	arr = (g_free (arr), NULL);
	return result;
}


GOptionGroup* gterminal_open_options_get_exec_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("exec", "Exec options:", "Show exec options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_exec_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	g_option_group_set_parse_hooks (group, NULL, (GOptionParseFunc) gterminal_open_options_post_parse);
	result = group;
	return result;
}


GOptionGroup* gterminal_open_options_get_window_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("window", "Window options:", "Show window options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_window_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


static gboolean gterminal_open_options_option_profile (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	TerminalSettingsList* profiles = NULL;
	TerminalSettingsList* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = gterminal_open_options_profile;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp1_ = _ ("May only use option %s once");
		_tmp2_ = option_name;
		_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp1_, _tmp2_);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		return _tmp4_;
	}
	_tmp5_ = terminal_profiles_list_new ();
	profiles = _tmp5_;
	_tmp7_ = value;
	_tmp8_ = terminal_profiles_list_dup_uuid (profiles, _tmp7_, &_inner_error_);
	_tmp6_ = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (profiles);
		return _tmp9_;
	}
	_tmp10_ = _tmp6_;
	_tmp6_ = NULL;
	_g_free0 (gterminal_open_options_profile);
	gterminal_open_options_profile = _tmp10_;
	result = TRUE;
	_g_free0 (_tmp6_);
	_g_object_unref0 (profiles);
	return result;
}


static gboolean double_try_parse (const gchar* str, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtod (_tmp0_, &_tmp1_);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean gterminal_open_options_option_zoom (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	gdouble v = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp14_ = 0.0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = value;
	_tmp2_ = double_try_parse (_tmp0_, &_tmp1_);
	v = _tmp1_;
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = _ ("“%s” is not a valid zoom factor");
		_tmp4_ = value;
		_tmp5_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp3_, _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		return _tmp6_;
	}
	_tmp8_ = v;
	if (_tmp8_ < 0.25) {
		_tmp7_ = TRUE;
	} else {
		gdouble _tmp9_ = 0.0;
		_tmp9_ = v;
		_tmp7_ = _tmp9_ > 4.0;
	}
	if (_tmp7_) {
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = _ ("Zoom value “%s” is outside allowed range");
		_tmp11_ = value;
		_tmp12_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp10_, _tmp11_);
		_inner_error_ = _tmp12_;
		g_propagate_error (error, _inner_error_);
		return _tmp13_;
	}
	_tmp14_ = v;
	gterminal_open_options_zoom = _tmp14_;
	result = TRUE;
	return result;
}


GOptionGroup* gterminal_open_options_get_terminal_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("terminal", "Terminal options:", "Show terminal options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_terminal_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


GOptionGroup* gterminal_open_options_get_processing_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("processing", "Processing options:", "Show processing options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_processing_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void gterminal_open_options_parse_argv (gchar** argv, int argv_length1, GError** error) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean found_dashdash = FALSE;
	gboolean _tmp19_ = FALSE;
	GOptionContext* context = NULL;
	GOptionContext* _tmp22_ = NULL;
	GOptionGroup* _tmp23_ = NULL;
	GOptionGroup* _tmp24_ = NULL;
	GOptionGroup* _tmp25_ = NULL;
	GOptionGroup* _tmp26_ = NULL;
	GOptionGroup* _tmp27_ = NULL;
	GOptionGroup* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp31_ = NULL;
	GdkDisplay* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_getenv ("DESKTOP_STARTUP_ID");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (gterminal_open_options_startup_id);
	gterminal_open_options_startup_id = _tmp1_;
	found_dashdash = FALSE;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint _tmp4_ = 0U;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				guint _tmp7_ = 0U;
				const gchar* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				guint _tmp13_ = 0U;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				if (!_tmp2_) {
					guint _tmp3_ = 0U;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = argv;
				_tmp5__length1 = argv_length1;
				if (!(_tmp4_ < ((guint) _tmp5__length1))) {
					break;
				}
				_tmp6_ = argv;
				_tmp6__length1 = argv_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (g_strcmp0 (_tmp8_, "--") != 0) {
					continue;
				}
				_tmp9_ = i;
				if (_tmp9_ > ((guint) 0)) {
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					guint _tmp11_ = 0U;
					gchar** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					_tmp10_ = argv;
					_tmp10__length1 = argv_length1;
					_tmp11_ = i;
					_tmp12_ = ((_tmp10_ + 0) != NULL) ? _vala_array_dup2 (_tmp10_ + 0, ((gint) _tmp11_) - 0) : ((gpointer) (_tmp10_ + 0));
					_tmp12__length1 = ((gint) _tmp11_) - 0;
					gterminal_open_options_argv_pre = (_vala_array_free (gterminal_open_options_argv_pre, _vala_array_length (gterminal_open_options_argv_pre), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_pre = _tmp12_;
				} else {
					gterminal_open_options_argv_pre = (_vala_array_free (gterminal_open_options_argv_pre, _vala_array_length (gterminal_open_options_argv_pre), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_pre = NULL;
				}
				_tmp13_ = i;
				_tmp14_ = argv;
				_tmp14__length1 = argv_length1;
				if ((_tmp13_ + 1) < ((guint) _tmp14__length1)) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					guint _tmp16_ = 0U;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					_tmp15_ = argv;
					_tmp15__length1 = argv_length1;
					_tmp16_ = i;
					_tmp17_ = argv;
					_tmp17__length1 = argv_length1;
					_tmp18_ = ((_tmp15_ + ((gint) (_tmp16_ + 1))) != NULL) ? _vala_array_dup3 (_tmp15_ + ((gint) (_tmp16_ + 1)), _tmp17__length1 - ((gint) (_tmp16_ + 1))) : ((gpointer) (_tmp15_ + ((gint) (_tmp16_ + 1))));
					_tmp18__length1 = _tmp17__length1 - ((gint) (_tmp16_ + 1));
					gterminal_open_options_argv_post = (_vala_array_free (gterminal_open_options_argv_post, _vala_array_length (gterminal_open_options_argv_post), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_post = _tmp18_;
				} else {
					gterminal_open_options_argv_post = (_vala_array_free (gterminal_open_options_argv_post, _vala_array_length (gterminal_open_options_argv_post), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_post = NULL;
				}
				found_dashdash = TRUE;
				break;
			}
		}
	}
	_tmp19_ = found_dashdash;
	if (!_tmp19_) {
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		_tmp20_ = argv;
		_tmp20__length1 = argv_length1;
		_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup4 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
		_tmp21__length1 = _tmp20__length1;
		gterminal_open_options_argv_pre = (_vala_array_free (gterminal_open_options_argv_pre, _vala_array_length (gterminal_open_options_argv_pre), (GDestroyNotify) g_free), NULL);
		gterminal_open_options_argv_pre = _tmp21_;
		gterminal_open_options_argv_post = (_vala_array_free (gterminal_open_options_argv_post, _vala_array_length (gterminal_open_options_argv_post), (GDestroyNotify) g_free), NULL);
		gterminal_open_options_argv_post = NULL;
	}
	_tmp22_ = g_option_context_new ("— terminal client");
	context = _tmp22_;
	g_option_context_set_translation_domain (context, GETTEXT_PACKAGE);
	_tmp23_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp23_);
	_tmp24_ = gterminal_global_options_get_option_group ();
	g_option_context_add_group (context, _tmp24_);
	_tmp25_ = gterminal_open_options_get_window_option_group ();
	g_option_context_add_group (context, _tmp25_);
	_tmp26_ = gterminal_open_options_get_terminal_option_group ();
	g_option_context_add_group (context, _tmp26_);
	_tmp27_ = gterminal_open_options_get_exec_option_group ();
	g_option_context_add_group (context, _tmp27_);
	_tmp28_ = gterminal_open_options_get_processing_option_group ();
	g_option_context_add_group (context, _tmp28_);
	g_option_context_parse_strv (context, &gterminal_open_options_argv_pre, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (context);
		return;
	}
	_tmp29_ = gterminal_open_options_working_directory;
	if (_tmp29_ == NULL) {
		gchar* _tmp30_ = NULL;
		_tmp30_ = g_get_current_dir ();
		_g_free0 (gterminal_open_options_working_directory);
		gterminal_open_options_working_directory = _tmp30_;
	}
	_tmp31_ = gterminal_open_options_startup_id;
	if (_tmp31_ == NULL) {
		gchar* _tmp32_ = NULL;
		_tmp32_ = terminal_client_get_fallback_startup_id ();
		_g_free0 (gterminal_open_options_startup_id);
		gterminal_open_options_startup_id = _tmp32_;
	}
	_tmp33_ = gdk_display_get_default ();
	_tmp34_ = gdk_display_get_name (_tmp33_);
	_tmp35_ = g_strdup (_tmp34_);
	_g_free0 (gterminal_open_options_display_name);
	gterminal_open_options_display_name = _tmp35_;
	_g_option_context_free0 (context);
}


GTerminalOpenOptions* gterminal_open_options_dup (const GTerminalOpenOptions* self) {
	GTerminalOpenOptions* dup;
	dup = g_new0 (GTerminalOpenOptions, 1);
	memcpy (dup, self, sizeof (GTerminalOpenOptions));
	return dup;
}


void gterminal_open_options_free (GTerminalOpenOptions* self) {
	g_free (self);
}


GType gterminal_open_options_get_type (void) {
	static volatile gsize gterminal_open_options_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_open_options_type_id__volatile)) {
		GType gterminal_open_options_type_id;
		gterminal_open_options_type_id = g_boxed_type_register_static ("GTerminalOpenOptions", (GBoxedCopyFunc) gterminal_open_options_dup, (GBoxedFreeFunc) gterminal_open_options_free);
		g_once_init_leave (&gterminal_open_options_type_id__volatile, gterminal_open_options_type_id);
	}
	return gterminal_open_options_type_id__volatile;
}


static void gterminal_server_base_init (GTerminalServerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gterminal_server_get_type (void) {
	static volatile gsize gterminal_server_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GTerminalServerIface), (GBaseInitFunc) gterminal_server_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gterminal_server_type_id;
		gterminal_server_type_id = g_type_register_static (G_TYPE_INTERFACE, "GTerminalServer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gterminal_server_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (gterminal_server_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gterminal_server_proxy_get_type);
		g_type_set_qdata (gterminal_server_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Terminal.Factory0");
		g_type_set_qdata (gterminal_server_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gterminal_server_dbus_interface_info));
		g_type_set_qdata (gterminal_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gterminal_server_register_object);
		g_once_init_leave (&gterminal_server_type_id__volatile, gterminal_server_type_id);
	}
	return gterminal_server_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GTerminalServerProxy, gterminal_server_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GTERMINAL_TYPE_SERVER, gterminal_server_proxy_gterminal_server_interface_init) )
static void gterminal_server_proxy_class_init (GTerminalServerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gterminal_server_proxy_g_signal;
}


static void gterminal_server_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void gterminal_server_proxy_init (GTerminalServerProxy* self) {
}


static void gterminal_server_proxy_gterminal_server_interface_init (GTerminalServerIface* iface) {
}


static void gterminal_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* gterminal_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gterminal_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint gterminal_server_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gterminal_server_dbus_interface_info), &_gterminal_server_dbus_interface_vtable, data, _gterminal_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _gterminal_server_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void gterminal_receiver_base_init (GTerminalReceiverIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("child_exited", GTERMINAL_TYPE_RECEIVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	}
}


GType gterminal_receiver_get_type (void) {
	static volatile gsize gterminal_receiver_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_receiver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GTerminalReceiverIface), (GBaseInitFunc) gterminal_receiver_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gterminal_receiver_type_id;
		gterminal_receiver_type_id = g_type_register_static (G_TYPE_INTERFACE, "GTerminalReceiver", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gterminal_receiver_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (gterminal_receiver_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gterminal_receiver_proxy_get_type);
		g_type_set_qdata (gterminal_receiver_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Terminal.Terminal0");
		g_type_set_qdata (gterminal_receiver_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gterminal_receiver_dbus_interface_info));
		g_type_set_qdata (gterminal_receiver_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gterminal_receiver_register_object);
		g_once_init_leave (&gterminal_receiver_type_id__volatile, gterminal_receiver_type_id);
	}
	return gterminal_receiver_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GTerminalReceiverProxy, gterminal_receiver_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GTERMINAL_TYPE_RECEIVER, gterminal_receiver_proxy_gterminal_receiver_interface_init) )
static void gterminal_receiver_proxy_class_init (GTerminalReceiverProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gterminal_receiver_proxy_g_signal;
}


static void _dbus_handle_gterminal_receiver_child_exited (GTerminalReceiver* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gint exit_code = 0;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	exit_code = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "child-exited", exit_code);
}


static void gterminal_receiver_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "ChildExited") == 0) {
		_dbus_handle_gterminal_receiver_child_exited ((GTerminalReceiver*) proxy, parameters);
	}
}


static void gterminal_receiver_proxy_init (GTerminalReceiverProxy* self) {
}


static void gterminal_receiver_proxy_gterminal_receiver_interface_init (GTerminalReceiverIface* iface) {
}


static void gterminal_receiver_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* gterminal_receiver_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gterminal_receiver_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_gterminal_receiver_child_exited (GObject* _sender, gint exit_code, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (exit_code));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Terminal.Terminal0", "ChildExited", _arguments, NULL);
}


guint gterminal_receiver_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gterminal_receiver_dbus_interface_info), &_gterminal_receiver_dbus_interface_vtable, data, _gterminal_receiver_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "child-exited", (GCallback) _dbus_gterminal_receiver_child_exited, data);
	return result;
}


static void _gterminal_receiver_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gterminal_receiver_child_exited, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


GTerminalServer* gterminal_get_server (GError** error) {
	GTerminalServer* result = NULL;
	GTerminalServer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GTerminalServer* _tmp3_ = NULL;
	GTerminalServer* _tmp4_ = NULL;
	GTerminalServer* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp1_ = gterminal_global_options_get_app_id ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_initable_new (GTERMINAL_TYPE_SERVER_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", _tmp2_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GTERMINAL_SERVER_OBJECT_PATH, "g-interface-name", "org.gnome.Terminal.Factory0", "g-interface-info", g_type_get_qdata (GTERMINAL_TYPE_SERVER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	_tmp4_ = (GTerminalServer*) _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}


GTerminalReceiver* gterminal_create_terminal (GError** error) {
	GTerminalReceiver* result = NULL;
	GTerminalServer* server = NULL;
	GTerminalServer* _tmp0_ = NULL;
	gchar* encoding = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp3_ = NULL;
	GVariantBuilder* _tmp4_ = NULL;
	GVariantBuilder* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GVariant* path = NULL;
	GTerminalServer* _tmp19_ = NULL;
	GVariantBuilder* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	gchar* obj_path = NULL;
	GVariant* _tmp25_ = NULL;
	GTerminalReceiver* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GTerminalReceiver* _tmp30_ = NULL;
	GTerminalReceiver* _tmp31_ = NULL;
	GTerminalReceiver* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = gterminal_get_server (&_inner_error_);
	server = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	g_get_charset (&_tmp1_);
	_g_free0 (encoding);
	_tmp2_ = g_strdup (_tmp1_);
	encoding = _tmp2_;
	_tmp3_ = G_VARIANT_TYPE_VARDICT;
	_tmp4_ = g_variant_builder_new (_tmp3_);
	builder = _tmp4_;
	_tmp5_ = builder;
	_tmp6_ = gterminal_open_options_display_name;
	_tmp7_ = gterminal_open_options_startup_id;
	_tmp8_ = gterminal_open_options_geometry;
	_tmp9_ = gterminal_open_options_role;
	_tmp10_ = gterminal_open_options_profile;
	_tmp11_ = encoding;
	_tmp12_ = gterminal_open_options_maximise;
	_tmp13_ = gterminal_open_options_fullscreen;
	terminal_client_append_create_instance_options (_tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, NULL, TRUE, _tmp12_, _tmp13_);
	_tmp14_ = gterminal_open_options_show_menubar_set;
	if (_tmp14_) {
		GVariantBuilder* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		GVariant* _tmp17_ = NULL;
		GVariant* _tmp18_ = NULL;
		_tmp15_ = builder;
		_tmp16_ = gterminal_open_options_show_menubar;
		_tmp17_ = g_variant_new_boolean (_tmp16_);
		g_variant_ref_sink (_tmp17_);
		_tmp18_ = _tmp17_;
		g_variant_builder_add (_tmp15_, "{sv}", "show-menubar", _tmp18_, NULL);
		_g_variant_unref0 (_tmp18_);
	}
	_tmp19_ = server;
	_tmp20_ = builder;
	_tmp21_ = g_variant_new ("(a{sv})", _tmp20_, NULL);
	g_variant_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_dbus_proxy_call_sync ((GDBusProxy*) _tmp19_, "CreateInstance", _tmp22_, G_DBUS_CALL_FLAGS_NO_AUTO_START, -1, NULL, &_inner_error_);
	_tmp24_ = _tmp23_;
	_g_variant_unref0 (_tmp22_);
	path = _tmp24_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_variant_builder_unref0 (builder);
		_g_free0 (encoding);
		_g_object_unref0 (server);
		return NULL;
	}
	_tmp25_ = path;
	g_variant_get (_tmp25_, "(o)", &obj_path, NULL);
	_tmp27_ = gterminal_global_options_get_app_id ();
	_tmp28_ = _tmp27_;
	_tmp29_ = obj_path;
	_tmp30_ = g_initable_new (GTERMINAL_TYPE_RECEIVER_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _tmp28_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp29_, "g-interface-name", "org.gnome.Terminal.Terminal0", "g-interface-info", g_type_get_qdata (GTERMINAL_TYPE_RECEIVER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	_tmp31_ = (GTerminalReceiver*) _tmp30_;
	_g_free0 (_tmp28_);
	_tmp26_ = _tmp31_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (obj_path);
		_g_variant_unref0 (path);
		_g_variant_builder_unref0 (builder);
		_g_free0 (encoding);
		_g_object_unref0 (server);
		return NULL;
	}
	_tmp32_ = _tmp26_;
	_tmp26_ = NULL;
	result = _tmp32_;
	_g_object_unref0 (_tmp26_);
	_g_free0 (obj_path);
	_g_variant_unref0 (path);
	_g_variant_builder_unref0 (builder);
	_g_free0 (encoding);
	_g_object_unref0 (server);
	return result;
}


gint gterminal_mangle_exit_code (gint status) {
	gint result = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = status;
	_tmp1_ = WIFEXITED (_tmp0_);
	if (_tmp1_) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp2_ = status;
		_tmp3_ = WEXITSTATUS (_tmp2_);
		_tmp4_ = CLAMP (_tmp3_, 0, 127);
		result = _tmp4_;
		return result;
	} else {
		gint _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = status;
		_tmp6_ = WIFSIGNALED (_tmp5_);
		if (_tmp6_) {
			gint _tmp7_ = 0;
			int _tmp8_ = 0;
			_tmp7_ = status;
			_tmp8_ = WTERMSIG (_tmp7_);
			result = 128 + ((gint) _tmp8_);
			return result;
		} else {
			result = 127;
			return result;
		}
	}
}


void gterminal_verb_init (GTerminalVerb *self, const gchar* verb, GTerminalVerbFunc func, void* func_target) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GTerminalVerbFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	g_return_if_fail (verb != NULL);
	memset (self, 0, sizeof (GTerminalVerb));
	_tmp0_ = verb;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).verb);
	(*self).verb = _tmp1_;
	_tmp2_ = func;
	_tmp2__target = func_target;
	(*self).func = _tmp2_;
	(*self).func_target = _tmp2__target;
}


void gterminal_verb_copy (const GTerminalVerb* self, GTerminalVerb* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GTerminalVerbFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	_tmp0_ = (*self).verb;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).verb);
	(*dest).verb = _tmp1_;
	_tmp2_ = (*self).func;
	_tmp2__target = (*self).func_target;
	(*dest).func = _tmp2_;
	(*dest).func_target = _tmp2__target;
}


void gterminal_verb_destroy (GTerminalVerb* self) {
	_g_free0 ((*self).verb);
}


GTerminalVerb* gterminal_verb_dup (const GTerminalVerb* self) {
	GTerminalVerb* dup;
	dup = g_new0 (GTerminalVerb, 1);
	gterminal_verb_copy (self, dup);
	return dup;
}


void gterminal_verb_free (GTerminalVerb* self) {
	gterminal_verb_destroy (self);
	g_free (self);
}


GType gterminal_verb_get_type (void) {
	static volatile gsize gterminal_verb_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_verb_type_id__volatile)) {
		GType gterminal_verb_type_id;
		gterminal_verb_type_id = g_boxed_type_register_static ("GTerminalVerb", (GBoxedCopyFunc) gterminal_verb_dup, (GBoxedFreeFunc) gterminal_verb_free);
		g_once_init_leave (&gterminal_verb_type_id__volatile, gterminal_verb_type_id);
	}
	return gterminal_verb_type_id__volatile;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gint gterminal_apply_map (GTerminalVerb* commands, int commands_length1, gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gboolean _tmp25_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp1_ = gterminal_global_options_get_complete ();
	if (!_tmp1_) {
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = argv;
		_tmp2__length1 = argv_length1;
		_tmp0_ = _tmp2__length1 == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp3_ = _ ("Missing argument");
		_tmp4_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		return _tmp5_;
	}
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	if (_tmp6__length1 != 0) {
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					guint _tmp9_ = 0U;
					GTerminalVerb* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					GTerminalVerb* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					guint _tmp12_ = 0U;
					GTerminalVerb _tmp13_ = {0};
					const gchar* _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					if (!_tmp7_) {
						guint _tmp8_ = 0U;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = i;
					_tmp10_ = commands;
					_tmp10__length1 = commands_length1;
					if (!(_tmp9_ < ((guint) _tmp10__length1))) {
						break;
					}
					_tmp11_ = commands;
					_tmp11__length1 = commands_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					_tmp14_ = _tmp13_.verb;
					_tmp15_ = argv;
					_tmp15__length1 = argv_length1;
					_tmp16_ = _tmp15_[0];
					if (g_strcmp0 (_tmp14_, _tmp16_) == 0) {
						gint _tmp17_ = 0;
						GTerminalVerb* _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						guint _tmp19_ = 0U;
						GTerminalVerb _tmp20_ = {0};
						GTerminalVerbFunc _tmp21_ = NULL;
						void* _tmp21__target = NULL;
						gchar** _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						gint _tmp23_ = 0;
						_tmp18_ = commands;
						_tmp18__length1 = commands_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp21_ = _tmp20_.func;
						_tmp21__target = _tmp20_.func_target;
						_tmp22_ = argv;
						_tmp22__length1 = argv_length1;
						_tmp23_ = _tmp21_ (_tmp22_, _tmp22__length1, _tmp21__target, &_inner_error_);
						_tmp17_ = _tmp23_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							gint _tmp24_ = 0;
							g_propagate_error (error, _inner_error_);
							return _tmp24_;
						}
						result = _tmp17_;
						return result;
					}
				}
			}
		}
	}
	_tmp25_ = gterminal_global_options_get_complete ();
	if (_tmp25_) {
		const gchar* _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar* prefix = NULL;
		gchar* _tmp30_ = NULL;
		_tmp27_ = argv;
		_tmp27__length1 = argv_length1;
		if (_tmp27__length1 > 0) {
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			const gchar* _tmp29_ = NULL;
			_tmp28_ = argv;
			_tmp28__length1 = argv_length1;
			_tmp29_ = _tmp28_[0];
			_tmp26_ = _tmp29_;
		} else {
			_tmp26_ = NULL;
		}
		_tmp30_ = g_strdup (_tmp26_);
		prefix = _tmp30_;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp31_ = FALSE;
				_tmp31_ = TRUE;
				while (TRUE) {
					guint _tmp33_ = 0U;
					GTerminalVerb* _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					GTerminalVerb* _tmp35_ = NULL;
					gint _tmp35__length1 = 0;
					guint _tmp36_ = 0U;
					GTerminalVerb _tmp37_ = {0};
					const gchar* _tmp38_ = NULL;
					gchar _tmp39_ = '\0';
					gboolean _tmp40_ = FALSE;
					const gchar* _tmp41_ = NULL;
					if (!_tmp31_) {
						guint _tmp32_ = 0U;
						_tmp32_ = i;
						i = _tmp32_ + 1;
					}
					_tmp31_ = FALSE;
					_tmp33_ = i;
					_tmp34_ = commands;
					_tmp34__length1 = commands_length1;
					if (!(_tmp33_ < ((guint) _tmp34__length1))) {
						break;
					}
					_tmp35_ = commands;
					_tmp35__length1 = commands_length1;
					_tmp36_ = i;
					_tmp37_ = _tmp35_[_tmp36_];
					_tmp38_ = _tmp37_.verb;
					_tmp39_ = string_get (_tmp38_, (glong) 0);
					if (_tmp39_ == '_') {
						continue;
					}
					_tmp41_ = prefix;
					if (_tmp41_ == NULL) {
						_tmp40_ = TRUE;
					} else {
						GTerminalVerb* _tmp42_ = NULL;
						gint _tmp42__length1 = 0;
						guint _tmp43_ = 0U;
						GTerminalVerb _tmp44_ = {0};
						const gchar* _tmp45_ = NULL;
						const gchar* _tmp46_ = NULL;
						gboolean _tmp47_ = FALSE;
						_tmp42_ = commands;
						_tmp42__length1 = commands_length1;
						_tmp43_ = i;
						_tmp44_ = _tmp42_[_tmp43_];
						_tmp45_ = _tmp44_.verb;
						_tmp46_ = prefix;
						_tmp47_ = g_str_has_prefix (_tmp45_, _tmp46_);
						_tmp40_ = _tmp47_;
					}
					if (_tmp40_) {
						GTerminalVerb* _tmp48_ = NULL;
						gint _tmp48__length1 = 0;
						guint _tmp49_ = 0U;
						GTerminalVerb _tmp50_ = {0};
						const gchar* _tmp51_ = NULL;
						_tmp48_ = commands;
						_tmp48__length1 = commands_length1;
						_tmp49_ = i;
						_tmp50_ = _tmp48_[_tmp49_];
						_tmp51_ = _tmp50_.verb;
						gterminal_output_print ("%s\n", _tmp51_);
					}
				}
			}
		}
		_g_free0 (prefix);
	} else {
		const gchar* _tmp52_ = NULL;
		gchar** _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		const gchar* _tmp54_ = NULL;
		GError* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		_tmp52_ = _ ("Unknown command “%s”");
		_tmp53_ = argv;
		_tmp53__length1 = argv_length1;
		_tmp54_ = _tmp53_[0];
		_tmp55_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, _tmp52_, _tmp54_);
		_inner_error_ = _tmp55_;
		g_propagate_error (error, _inner_error_);
		return _tmp56_;
	}
	result = EXIT_SUCCESS;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda4_ (Block1Data* _data1_, gint s) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	_tmp0_ = g_main_loop_is_running (_data1_->loop);
	if (_tmp0_) {
		g_main_loop_quit (_data1_->loop);
	}
	_tmp1_ = s;
	_data1_->status = _tmp1_;
}


static void ___lambda4__gterminal_receiver_child_exited (GTerminalReceiver* _sender, gint exit_code, gpointer self) {
	__lambda4_ (self, exit_code);
}


gint gterminal_run (GTerminalReceiver* receiver) {
	gint result = 0;
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	gulong id = 0UL;
	GTerminalReceiver* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GTerminalReceiver* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	g_return_val_if_fail (receiver != NULL, 0);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->status = 0;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data1_->loop = _tmp0_;
	_tmp1_ = receiver;
	_tmp2_ = g_signal_connect_data (_tmp1_, "child-exited", (GCallback) ___lambda4__gterminal_receiver_child_exited, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	id = _tmp2_;
	g_main_loop_run (_data1_->loop);
	_tmp3_ = receiver;
	g_signal_handler_disconnect ((GObject*) _tmp3_, id);
	_tmp4_ = gterminal_mangle_exit_code (_data1_->status);
	result = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


gint gterminal_open (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp18_ = NULL;
	GVariantBuilder* _tmp19_ = NULL;
	GVariantBuilder* _tmp20_ = NULL;
	const GVariantType* _tmp21_ = NULL;
	GVariantBuilder* _tmp27_ = NULL;
	GVariantBuilder* _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_ = NULL;
	GTerminalReceiver* receiver = NULL;
	GTerminalReceiver* _tmp32_ = NULL;
	GTerminalReceiver* _tmp34_ = NULL;
	GVariantBuilder* _tmp35_ = NULL;
	GVariant* _tmp36_ = NULL;
	GVariant* _tmp37_ = NULL;
	GUnixFDList* _tmp38_ = NULL;
	GVariant* _tmp39_ = NULL;
	GVariant* _tmp40_ = NULL;
	gboolean _tmp42_ = FALSE;
	GTerminalReceiver* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	gterminal_open_options_parse_argv (_tmp0_, _tmp0__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp1_ = 0;
		g_propagate_error (error, _inner_error_);
		return _tmp1_;
	}
	_tmp3_ = argv;
	_tmp3__length1 = argv_length1;
	_tmp4_ = _tmp3_[0];
	if (g_strcmp0 (_tmp4_, "run") == 0) {
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp5_ = gterminal_open_options_argv_post;
		_tmp5__length1 = _vala_array_length (gterminal_open_options_argv_post);
		_tmp2_ = _tmp5_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp6_ = _ ("“%s” needs the command to run as arguments after “--”");
		_tmp7_ = argv;
		_tmp7__length1 = argv_length1;
		_tmp8_ = _tmp7_[0];
		_tmp9_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp6_, _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		return _tmp10_;
	} else {
		gboolean _tmp11_ = FALSE;
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
		_tmp12_ = argv;
		_tmp12__length1 = argv_length1;
		_tmp13_ = _tmp12_[0];
		if (g_strcmp0 (_tmp13_, "shell") == 0) {
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			_tmp14_ = gterminal_open_options_argv_post;
			_tmp14__length1 = _vala_array_length (gterminal_open_options_argv_post);
			_tmp11_ = _tmp14_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			const gchar* _tmp15_ = NULL;
			GError* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			_tmp15_ = _ ("Extraneous arguments after “--”");
			_tmp16_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp15_);
			_inner_error_ = _tmp16_;
			g_propagate_error (error, _inner_error_);
			return _tmp17_;
		}
	}
	_tmp18_ = G_VARIANT_TYPE_TUPLE;
	_tmp19_ = g_variant_builder_new (_tmp18_);
	builder = _tmp19_;
	_tmp20_ = builder;
	_tmp21_ = G_VARIANT_TYPE_VARDICT;
	g_variant_builder_open (_tmp20_, _tmp21_);
	{
		GVariantBuilder* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		PassFdElement* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		const gchar* _tmp26_ = NULL;
		_tmp22_ = builder;
		_tmp23_ = gterminal_open_options_working_directory;
		_tmp24_ = gterminal_open_options_fd_array;
		_tmp24__length1 = gterminal_open_options_fd_array_length1;
		_tmp25_ = argv;
		_tmp25__length1 = argv_length1;
		_tmp26_ = _tmp25_[0];
		terminal_client_append_exec_options (_tmp22_, _tmp23_, _tmp24_, _tmp24__length1, g_strcmp0 (_tmp26_, "shell") == 0);
	}
	_tmp27_ = builder;
	g_variant_builder_close (_tmp27_);
	_tmp28_ = builder;
	_tmp29_ = gterminal_open_options_argv_post;
	_tmp29__length1 = _vala_array_length (gterminal_open_options_argv_post);
	_tmp30_ = g_variant_new_bytestring_array (_tmp29_, _tmp29__length1);
	g_variant_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	g_variant_builder_add_value (_tmp28_, _tmp31_);
	_g_variant_unref0 (_tmp31_);
	_tmp32_ = gterminal_create_terminal (&_inner_error_);
	receiver = _tmp32_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp33_ = 0;
		g_propagate_error (error, _inner_error_);
		_g_variant_builder_unref0 (builder);
		return _tmp33_;
	}
	_tmp34_ = receiver;
	_tmp35_ = builder;
	_tmp36_ = g_variant_builder_end (_tmp35_);
	g_variant_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	_tmp38_ = gterminal_open_options_fd_list;
	_tmp39_ = g_dbus_proxy_call_with_unix_fd_list_sync ((GDBusProxy*) _tmp34_, "Exec", _tmp37_, G_DBUS_CALL_FLAGS_NO_AUTO_START, -1, _tmp38_, NULL, NULL, &_inner_error_);
	_tmp40_ = _tmp39_;
	_g_variant_unref0 (_tmp40_);
	_g_variant_unref0 (_tmp37_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp41_ = 0;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (receiver);
		_g_variant_builder_unref0 (builder);
		return _tmp41_;
	}
	_tmp42_ = gterminal_open_options_wait_for_remote;
	if (!_tmp42_) {
		result = EXIT_SUCCESS;
		_g_object_unref0 (receiver);
		_g_variant_builder_unref0 (builder);
		return result;
	}
	_tmp43_ = receiver;
	_tmp44_ = gterminal_run (_tmp43_);
	result = _tmp44_;
	_g_object_unref0 (receiver);
	_g_variant_builder_unref0 (builder);
	return result;
}


gint gterminal_help (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	result = EXIT_SUCCESS;
	return result;
}


gint gterminal_profile__list (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp0_ = NULL;
	GSettings* def = NULL;
	TerminalSettingsList* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	gchar** keys = NULL;
	GSettings* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = terminal_profiles_list_new ();
	service = _tmp0_;
	_tmp1_ = service;
	_tmp2_ = terminal_settings_list_ref_default_child (_tmp1_);
	def = _tmp2_;
	_tmp3_ = def;
	if (_tmp3_ == NULL) {
		GError* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "");
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (def);
		_g_object_unref0 (service);
		return _tmp5_;
	}
	_tmp6_ = def;
	_tmp8_ = _tmp7_ = g_settings_list_keys (_tmp6_);
	keys = _tmp8_;
	keys_length1 = _vala_array_length (_tmp7_);
	_keys_size_ = keys_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				guint _tmp11_ = 0U;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				guint _tmp14_ = 0U;
				const gchar* _tmp15_ = NULL;
				if (!_tmp9_) {
					guint _tmp10_ = 0U;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = keys;
				_tmp12__length1 = keys_length1;
				if (!(_tmp11_ < ((guint) _tmp12__length1))) {
					break;
				}
				_tmp13_ = keys;
				_tmp13__length1 = keys_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				gterminal_output_print ("%s\n", _tmp15_);
			}
		}
	}
	result = EXIT_SUCCESS;
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (def);
	_g_object_unref0 (service);
	return result;
}


gint gterminal_profile_get (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* uuid = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* key = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp15_ = NULL;
	GSettings* profile = NULL;
	TerminalSettingsList* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	GSettings* _tmp19_ = NULL;
	GSettings* _tmp23_ = NULL;
	GSettingsSchema* _tmp24_ = NULL;
	GSettingsSchema* _tmp25_ = NULL;
	GSettingsSchema* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	GSettings* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GVariant* _tmp35_ = NULL;
	GVariant* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	if (_tmp0__length1 < 3) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = _ ("Missing argument");
		_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return _tmp3_;
	}
	_tmp4_ = argv;
	_tmp4__length1 = argv_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	uuid = _tmp6_;
	_tmp7_ = argv;
	_tmp7__length1 = argv_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = g_strdup (_tmp8_);
	key = _tmp9_;
	_tmp10_ = uuid;
	_tmp11_ = terminal_settings_list_valid_uuid (_tmp10_);
	if (!_tmp11_) {
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		_tmp12_ = uuid;
		_tmp13_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "\"%s\" is not a valid profile UUID", _tmp12_);
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (key);
		_g_free0 (uuid);
		return _tmp14_;
	}
	_tmp15_ = terminal_profiles_list_new ();
	service = _tmp15_;
	_tmp16_ = service;
	_tmp17_ = uuid;
	_tmp18_ = terminal_settings_list_ref_child (_tmp16_, _tmp17_);
	profile = _tmp18_;
	_tmp19_ = profile;
	if (_tmp19_ == NULL) {
		const gchar* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp20_ = uuid;
		_tmp21_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "No profile with UUID \"%s\" exists", _tmp20_);
		_inner_error_ = _tmp21_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (profile);
		_g_object_unref0 (service);
		_g_free0 (key);
		_g_free0 (uuid);
		return _tmp22_;
	}
	_tmp23_ = profile;
	g_object_get (_tmp23_, "settings-schema", &_tmp24_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp27_ = key;
	_tmp28_ = g_settings_schema_has_key (_tmp26_, _tmp27_);
	_tmp29_ = !_tmp28_;
	_g_settings_schema_unref0 (_tmp26_);
	if (_tmp29_) {
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		_tmp30_ = key;
		_tmp31_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "\"%s\" is not a valid profile key name", _tmp30_);
		_inner_error_ = _tmp31_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (profile);
		_g_object_unref0 (service);
		_g_free0 (key);
		_g_free0 (uuid);
		return _tmp32_;
	}
	_tmp33_ = profile;
	_tmp34_ = key;
	_tmp35_ = g_settings_get_value (_tmp33_, _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_variant_print (_tmp36_, TRUE);
	_tmp38_ = _tmp37_;
	gterminal_output_print ("%s\n", _tmp38_);
	_g_free0 (_tmp38_);
	_g_variant_unref0 (_tmp36_);
	result = EXIT_SUCCESS;
	_g_object_unref0 (profile);
	_g_object_unref0 (service);
	_g_free0 (key);
	_g_free0 (uuid);
	return result;
}


gint gterminal_profile_set (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* uuid = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* key = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* value = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp18_ = NULL;
	GSettings* profile = NULL;
	TerminalSettingsList* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GSettings* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	GSettingsSchema* schema = NULL;
	GSettings* _tmp26_ = NULL;
	GSettingsSchema* _tmp27_ = NULL;
	GSettingsSchema* _tmp28_ = NULL;
	GSettingsSchema* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GVariant* v = NULL;
	GSettingsSchema* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GSettingsSchemaKey* _tmp37_ = NULL;
	GSettingsSchemaKey* _tmp38_ = NULL;
	const GVariantType* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GVariant* _tmp41_ = NULL;
	GVariant* _tmp42_ = NULL;
	GSettings* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	GVariant* _tmp46_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	if (_tmp0__length1 < 4) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = _ ("Missing argument");
		_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return _tmp3_;
	}
	_tmp4_ = argv;
	_tmp4__length1 = argv_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	uuid = _tmp6_;
	_tmp7_ = argv;
	_tmp7__length1 = argv_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = g_strdup (_tmp8_);
	key = _tmp9_;
	_tmp10_ = argv;
	_tmp10__length1 = argv_length1;
	_tmp11_ = _tmp10_[3];
	_tmp12_ = g_strdup (_tmp11_);
	value = _tmp12_;
	_tmp13_ = uuid;
	_tmp14_ = terminal_settings_list_valid_uuid (_tmp13_);
	if (!_tmp14_) {
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp15_ = uuid;
		_tmp16_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "\"%s\" is not a valid profile UUID", _tmp15_);
		_inner_error_ = _tmp16_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (value);
		_g_free0 (key);
		_g_free0 (uuid);
		return _tmp17_;
	}
	_tmp18_ = terminal_profiles_list_new ();
	service = _tmp18_;
	_tmp19_ = service;
	_tmp20_ = uuid;
	_tmp21_ = terminal_settings_list_ref_child (_tmp19_, _tmp20_);
	profile = _tmp21_;
	_tmp22_ = profile;
	if (_tmp22_ == NULL) {
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		_tmp23_ = uuid;
		_tmp24_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "No profile with UUID \"%s\" exists", _tmp23_);
		_inner_error_ = _tmp24_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (profile);
		_g_object_unref0 (service);
		_g_free0 (value);
		_g_free0 (key);
		_g_free0 (uuid);
		return _tmp25_;
	}
	_tmp26_ = profile;
	g_object_get (_tmp26_, "settings-schema", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	schema = _tmp28_;
	_tmp29_ = schema;
	_tmp30_ = key;
	_tmp31_ = g_settings_schema_has_key (_tmp29_, _tmp30_);
	if (!_tmp31_) {
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		_tmp32_ = key;
		_tmp33_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "\"%s\" is not a valid profile key name", _tmp32_);
		_inner_error_ = _tmp33_;
		g_propagate_error (error, _inner_error_);
		_g_settings_schema_unref0 (schema);
		_g_object_unref0 (profile);
		_g_object_unref0 (service);
		_g_free0 (value);
		_g_free0 (key);
		_g_free0 (uuid);
		return _tmp34_;
	}
	_tmp35_ = schema;
	_tmp36_ = key;
	_tmp37_ = g_settings_schema_get_key (_tmp35_, _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_settings_schema_key_get_value_type (_tmp38_);
	_tmp40_ = value;
	_tmp41_ = g_variant_parse (_tmp39_, _tmp40_, NULL, NULL, &_inner_error_);
	_tmp42_ = _tmp41_;
	_g_settings_schema_key_unref0 (_tmp38_);
	v = _tmp42_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp43_ = 0;
		g_propagate_error (error, _inner_error_);
		_g_settings_schema_unref0 (schema);
		_g_object_unref0 (profile);
		_g_object_unref0 (service);
		_g_free0 (value);
		_g_free0 (key);
		_g_free0 (uuid);
		return _tmp43_;
	}
	_tmp44_ = profile;
	_tmp45_ = key;
	_tmp46_ = v;
	g_settings_set_value (_tmp44_, _tmp45_, _tmp46_);
	g_settings_sync ();
	result = EXIT_SUCCESS;
	_g_variant_unref0 (v);
	_g_settings_schema_unref0 (schema);
	_g_object_unref0 (profile);
	_g_object_unref0 (service);
	_g_free0 (value);
	_g_free0 (key);
	_g_free0 (uuid);
	return result;
}


static gint _gterminal_profile__list_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profile__list (args, args_length1, error);
	return result;
}


static gint _gterminal_profile_get_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profile_get (args, args_length1, error);
	return result;
}


static gint _gterminal_profile_set_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profile_set (args, args_length1, error);
	return result;
}


static void _vala_GTerminalVerb_array_free (GTerminalVerb* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gterminal_verb_destroy (&array[i]);
		}
	}
	g_free (array);
}


gint gterminal_profile (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	GTerminalVerb* map = NULL;
	GTerminalVerb _tmp0_ = {0};
	GTerminalVerb _tmp1_ = {0};
	GTerminalVerb _tmp2_ = {0};
	GTerminalVerb* _tmp3_ = NULL;
	gint map_length1 = 0;
	gint _map_size_ = 0;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	gterminal_verb_init (&_tmp0_, "_list", _gterminal_profile__list_gterminal_verb_func, NULL);
	gterminal_verb_init (&_tmp1_, "get", _gterminal_profile_get_gterminal_verb_func, NULL);
	gterminal_verb_init (&_tmp2_, "set", _gterminal_profile_set_gterminal_verb_func, NULL);
	_tmp3_ = g_new0 (GTerminalVerb, 3);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	map = _tmp3_;
	map_length1 = 3;
	_map_size_ = map_length1;
	_tmp5_ = argv;
	_tmp5__length1 = argv_length1;
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_tmp7_ = gterminal_apply_map (map, map_length1, _tmp5_ + 1, _tmp6__length1 - 1, &_inner_error_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp8_ = 0;
		g_propagate_error (error, _inner_error_);
		map = (_vala_GTerminalVerb_array_free (map, map_length1), NULL);
		return _tmp8_;
	}
	result = _tmp4_;
	map = (_vala_GTerminalVerb_array_free (map, map_length1), NULL);
	return result;
}


gint gterminal_profiles_list (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp0_ = NULL;
	gchar** profiles = NULL;
	TerminalSettingsList* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint profiles_length1 = 0;
	gint _profiles_size_ = 0;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* prefix = NULL;
	gchar* _tmp8_ = NULL;
	_tmp0_ = terminal_profiles_list_new ();
	service = _tmp0_;
	_tmp1_ = service;
	_tmp3_ = _tmp2_ = terminal_settings_list_dupv_children (_tmp1_);
	profiles = _tmp3_;
	profiles_length1 = _vala_array_length (_tmp2_);
	_profiles_size_ = profiles_length1;
	_tmp5_ = argv;
	_tmp5__length1 = argv_length1;
	if (_tmp5__length1 > 1) {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = argv;
		_tmp6__length1 = argv_length1;
		_tmp7_ = _tmp6_[1];
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp8_ = g_strdup (_tmp4_);
	prefix = _tmp8_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				guint _tmp11_ = 0U;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_ = NULL;
				if (!_tmp9_) {
					guint _tmp10_ = 0U;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = profiles;
				_tmp12__length1 = profiles_length1;
				if (!(_tmp11_ < ((guint) _tmp12__length1))) {
					break;
				}
				_tmp14_ = prefix;
				if (_tmp14_ == NULL) {
					_tmp13_ = TRUE;
				} else {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					guint _tmp16_ = 0U;
					const gchar* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gboolean _tmp19_ = FALSE;
					_tmp15_ = profiles;
					_tmp15__length1 = profiles_length1;
					_tmp16_ = i;
					_tmp17_ = _tmp15_[_tmp16_];
					_tmp18_ = prefix;
					_tmp19_ = g_str_has_prefix (_tmp17_, _tmp18_);
					_tmp13_ = _tmp19_;
				}
				if (_tmp13_) {
					gchar** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					guint _tmp21_ = 0U;
					const gchar* _tmp22_ = NULL;
					_tmp20_ = profiles;
					_tmp20__length1 = profiles_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_];
					gterminal_output_print ("%s\n", _tmp22_);
				}
			}
		}
	}
	result = EXIT_SUCCESS;
	_g_free0 (prefix);
	profiles = (_vala_array_free (profiles, profiles_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (service);
	return result;
}


gint gterminal_profiles_get_default (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = terminal_profiles_list_new ();
	service = _tmp0_;
	_tmp1_ = terminal_settings_list_dup_default_child (service);
	_tmp2_ = _tmp1_;
	gterminal_output_print ("%s\n", _tmp2_);
	_g_free0 (_tmp2_);
	result = EXIT_SUCCESS;
	_g_object_unref0 (service);
	return result;
}


gint gterminal_profiles_set_default (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* uuid = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp12_ = NULL;
	TerminalSettingsList* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	if (_tmp0__length1 < 2) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = _ ("Missing argument");
		_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return _tmp3_;
	}
	_tmp4_ = argv;
	_tmp4__length1 = argv_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	uuid = _tmp6_;
	_tmp7_ = uuid;
	_tmp8_ = terminal_settings_list_valid_uuid (_tmp7_);
	if (!_tmp8_) {
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp9_ = uuid;
		_tmp10_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "\"%s\" is not a valid profile UUID", _tmp9_);
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (uuid);
		return _tmp11_;
	}
	_tmp12_ = terminal_profiles_list_new ();
	service = _tmp12_;
	_tmp13_ = service;
	_tmp14_ = uuid;
	terminal_settings_list_set_default_child (_tmp13_, _tmp14_);
	g_settings_sync ();
	result = EXIT_SUCCESS;
	_g_object_unref0 (service);
	_g_free0 (uuid);
	return result;
}


gint gterminal_profiles_add (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp0_ = NULL;
	gchar* new_uuid = NULL;
	TerminalSettingsList* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = terminal_profiles_list_new ();
	service = _tmp0_;
	_tmp1_ = service;
	_tmp2_ = terminal_settings_list_add_child (_tmp1_);
	new_uuid = _tmp2_;
	_tmp3_ = new_uuid;
	if (_tmp3_ == NULL) {
		GError* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Failed to create new profile");
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (new_uuid);
		_g_object_unref0 (service);
		return _tmp5_;
	}
	_tmp6_ = new_uuid;
	gterminal_output_print ("%s\n", _tmp6_);
	g_settings_sync ();
	result = EXIT_SUCCESS;
	_g_free0 (new_uuid);
	_g_object_unref0 (service);
	return result;
}


gint gterminal_profiles_clone (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* uuid = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp12_ = NULL;
	TerminalSettingsList* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gchar* new_uuid = NULL;
	TerminalSettingsList* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	if (_tmp0__length1 < 2) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = _ ("Missing argument");
		_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return _tmp3_;
	}
	_tmp4_ = argv;
	_tmp4__length1 = argv_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	uuid = _tmp6_;
	_tmp7_ = uuid;
	_tmp8_ = terminal_settings_list_valid_uuid (_tmp7_);
	if (!_tmp8_) {
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp9_ = uuid;
		_tmp10_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "\"%s\" is not a valid profile UUID", _tmp9_);
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (uuid);
		return _tmp11_;
	}
	_tmp12_ = terminal_profiles_list_new ();
	service = _tmp12_;
	_tmp13_ = service;
	_tmp14_ = uuid;
	_tmp15_ = terminal_settings_list_has_child (_tmp13_, _tmp14_);
	if (!_tmp15_) {
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		_tmp16_ = uuid;
		_tmp17_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "No profile with UUID \"%s\" exists", _tmp16_);
		_inner_error_ = _tmp17_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (service);
		_g_free0 (uuid);
		return _tmp18_;
	}
	_tmp19_ = service;
	_tmp20_ = uuid;
	_tmp21_ = terminal_settings_list_clone_child (_tmp19_, _tmp20_);
	new_uuid = _tmp21_;
	_tmp22_ = new_uuid;
	if (_tmp22_ == NULL) {
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		_tmp23_ = uuid;
		_tmp24_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Failed to clone profile \"%s\"", _tmp23_);
		_inner_error_ = _tmp24_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (new_uuid);
		_g_object_unref0 (service);
		_g_free0 (uuid);
		return _tmp25_;
	}
	_tmp26_ = new_uuid;
	gterminal_output_print ("%s\n", _tmp26_);
	g_settings_sync ();
	result = EXIT_SUCCESS;
	_g_free0 (new_uuid);
	_g_object_unref0 (service);
	_g_free0 (uuid);
	return result;
}


gint gterminal_profiles_remove (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* uuid = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	TerminalSettingsList* service = NULL;
	TerminalSettingsList* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	if (_tmp0__length1 < 2) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = _ ("Missing argument");
		_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return _tmp3_;
	}
	_tmp4_ = argv;
	_tmp4__length1 = argv_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	uuid = _tmp6_;
	_tmp7_ = uuid;
	_tmp8_ = terminal_settings_list_valid_uuid (_tmp7_);
	if (!_tmp8_) {
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp9_ = uuid;
		_tmp10_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "\"%s\" is not a valid profile UUID", _tmp9_);
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (uuid);
		return _tmp11_;
	}
	_tmp12_ = terminal_profiles_list_new ();
	service = _tmp12_;
	_tmp13_ = uuid;
	_tmp14_ = terminal_settings_list_has_child (service, _tmp13_);
	if (!_tmp14_) {
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp15_ = uuid;
		_tmp16_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "No profile with UUID \"%s\" exists", _tmp15_);
		_inner_error_ = _tmp16_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (service);
		_g_free0 (uuid);
		return _tmp17_;
	}
	_tmp18_ = uuid;
	terminal_settings_list_remove_child (service, _tmp18_);
	g_settings_sync ();
	result = EXIT_SUCCESS;
	_g_object_unref0 (service);
	_g_free0 (uuid);
	return result;
}


static gint _gterminal_profiles_add_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profiles_add (args, args_length1, error);
	return result;
}


static gint _gterminal_profiles_clone_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profiles_clone (args, args_length1, error);
	return result;
}


static gint _gterminal_profiles_get_default_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profiles_get_default (args, args_length1, error);
	return result;
}


static gint _gterminal_profiles_list_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profiles_list (args, args_length1, error);
	return result;
}


static gint _gterminal_profiles_remove_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profiles_remove (args, args_length1, error);
	return result;
}


static gint _gterminal_profiles_set_default_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profiles_set_default (args, args_length1, error);
	return result;
}


gint gterminal_profiles (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	GTerminalVerb* map = NULL;
	GTerminalVerb _tmp0_ = {0};
	GTerminalVerb _tmp1_ = {0};
	GTerminalVerb _tmp2_ = {0};
	GTerminalVerb _tmp3_ = {0};
	GTerminalVerb _tmp4_ = {0};
	GTerminalVerb _tmp5_ = {0};
	GTerminalVerb* _tmp6_ = NULL;
	gint map_length1 = 0;
	gint _map_size_ = 0;
	gint _tmp7_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
	gterminal_verb_init (&_tmp0_, "add", _gterminal_profiles_add_gterminal_verb_func, NULL);
	gterminal_verb_init (&_tmp1_, "clone", _gterminal_profiles_clone_gterminal_verb_func, NULL);
	gterminal_verb_init (&_tmp2_, "get-default", _gterminal_profiles_get_default_gterminal_verb_func, NULL);
	gterminal_verb_init (&_tmp3_, "list", _gterminal_profiles_list_gterminal_verb_func, NULL);
	gterminal_verb_init (&_tmp4_, "remove", _gterminal_profiles_remove_gterminal_verb_func, NULL);
	gterminal_verb_init (&_tmp5_, "set-default", _gterminal_profiles_set_default_gterminal_verb_func, NULL);
	_tmp6_ = g_new0 (GTerminalVerb, 6);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	map = _tmp6_;
	map_length1 = 6;
	_map_size_ = map_length1;
	_tmp8_ = argv;
	_tmp8__length1 = argv_length1;
	_tmp9_ = argv;
	_tmp9__length1 = argv_length1;
	_tmp10_ = gterminal_apply_map (map, map_length1, _tmp8_ + 1, _tmp9__length1 - 1, &_inner_error_);
	_tmp7_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp11_ = 0;
		g_propagate_error (error, _inner_error_);
		map = (_vala_GTerminalVerb_array_free (map, map_length1), NULL);
		return _tmp11_;
	}
	result = _tmp7_;
	map = (_vala_GTerminalVerb_array_free (map, map_length1), NULL);
	return result;
}


static gint _gterminal_help_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_help (args, args_length1, error);
	return result;
}


static gint _gterminal_open_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_open (args, args_length1, error);
	return result;
}


static gint _gterminal_profile_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profile (args, args_length1, error);
	return result;
}


static gint _gterminal_profiles_gterminal_verb_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_profiles (args, args_length1, error);
	return result;
}


gint gterminal_main (gchar** argv, int argv_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint status = 0;
	GError * _inner_error_ = NULL;
	g_set_prgname ("gterminal");
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("GTerminal");
	g_set_application_name (_tmp0_);
	{
		GTerminalVerb* map = NULL;
		GTerminalVerb _tmp1_ = {0};
		GTerminalVerb _tmp2_ = {0};
		GTerminalVerb _tmp3_ = {0};
		GTerminalVerb _tmp4_ = {0};
		GTerminalVerb _tmp5_ = {0};
		GTerminalVerb* _tmp6_ = NULL;
		gint map_length1 = 0;
		gint _map_size_ = 0;
		gint _tmp7_ = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint _tmp10_ = 0;
		gterminal_verb_init (&_tmp1_, "help", _gterminal_help_gterminal_verb_func, NULL);
		gterminal_verb_init (&_tmp2_, "open", _gterminal_open_gterminal_verb_func, NULL);
		gterminal_verb_init (&_tmp3_, "shell", _gterminal_open_gterminal_verb_func, NULL);
		gterminal_verb_init (&_tmp4_, "profile", _gterminal_profile_gterminal_verb_func, NULL);
		gterminal_verb_init (&_tmp5_, "profiles", _gterminal_profiles_gterminal_verb_func, NULL);
		_tmp6_ = g_new0 (GTerminalVerb, 5);
		_tmp6_[0] = _tmp1_;
		_tmp6_[1] = _tmp2_;
		_tmp6_[2] = _tmp3_;
		_tmp6_[3] = _tmp4_;
		_tmp6_[4] = _tmp5_;
		map = _tmp6_;
		map_length1 = 5;
		_map_size_ = map_length1;
		_tmp8_ = argv;
		_tmp8__length1 = argv_length1;
		_tmp9_ = argv;
		_tmp9__length1 = argv_length1;
		_tmp10_ = gterminal_apply_map (map, map_length1, _tmp8_ + 1, _tmp9__length1 - 1, &_inner_error_);
		_tmp7_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			map = (_vala_GTerminalVerb_array_free (map, map_length1), NULL);
			goto __catch0_g_error;
		}
		status = _tmp7_;
		map = (_vala_GTerminalVerb_array_free (map, map_length1), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		g_dbus_error_strip_remote_error (_tmp11_);
		_tmp12_ = _ ("Error processing arguments: %s\n");
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_printerr (_tmp12_, _tmp14_);
		status = EXIT_FAILURE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp15_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp15_;
	}
	result = status;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return gterminal_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



