/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.artifex.gsviewer.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import com.artifex.gsviewer.Settings;

/**
 * The settings dialog
 *
 * @author Ethan Vrhel
 */
public class SettingsDialog extends javax.swing.JDialog {

	private static final long serialVersionUID = 1L;

	/**
	 * Creates new form SettingsDialog
	 */
	public SettingsDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
		setLocationRelativeTo(parent);

		scrollSensitivitySlider.addMouseListener(new MouseAdapter() {

			@Override
			public void mouseReleased(MouseEvent e) {
				scrollSensitvityField
						.setText(new StringBuilder().append(scrollSensitivitySlider.getValue()).toString());
			}
		});

		init();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */

	// <editor-fold defaultstate="collapsed" desc="Generated Code">
	private void initComponents() {

		scrollSensitivityLabel = new javax.swing.JLabel();
		antialiasingCheckbox = new javax.swing.JCheckBox();
		cancelButton = new javax.swing.JButton();
		applyButton = new javax.swing.JButton();
		okButton = new javax.swing.JButton();
		preloadRangeLabel = new javax.swing.JLabel();
		scrollSensitivitySlider = new javax.swing.JSlider();
		scrollSensitvityField = new javax.swing.JTextField();
		preloadRangeSpinner = new javax.swing.JSpinner();

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		setTitle("Settings");
		setModalityType(java.awt.Dialog.ModalityType.APPLICATION_MODAL);
		setResizable(false);

		scrollSensitivityLabel.setText("Scroll Sensitivity");

		antialiasingCheckbox.setText("Antialiasing");
		antialiasingCheckbox.setHideActionText(true);
		antialiasingCheckbox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
		antialiasingCheckbox.setMargin(new java.awt.Insets(0, 0, 0, 0));

		cancelButton.setText("Cancel");
		cancelButton.addActionListener(new java.awt.event.ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				cancelButtonActionPerformed(evt);
			}
		});

		applyButton.setText("Apply");
		applyButton.addActionListener(new java.awt.event.ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				applyButtonActionPerformed(evt);
			}
		});

		okButton.setText("OK");
		okButton.addActionListener(new java.awt.event.ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				okButtonActionPerformed(evt);
			}
		});

		preloadRangeLabel.setText("Preload Range");

		scrollSensitivitySlider.setMaximum(200);
		scrollSensitivitySlider.setMinimum(1);
		scrollSensitivitySlider.setToolTipText("The number of pixels to scroll");

		scrollSensitvityField.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyPressed(java.awt.event.KeyEvent evt) {
				scrollSensitvityFieldKeyPressed(evt);
			}
		});

		preloadRangeSpinner.setToolTipText("The range for loading out of view pages");

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout
				.createSequentialGroup().addContainerGap()
				.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout
						.createSequentialGroup()
						.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(scrollSensitivityLabel).addComponent(preloadRangeLabel)
								.addComponent(antialiasingCheckbox, javax.swing.GroupLayout.PREFERRED_SIZE, 79,
										javax.swing.GroupLayout.PREFERRED_SIZE))
						.addGap(43, 43, 43)
						.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addGroup(layout.createSequentialGroup()
										.addComponent(scrollSensitivitySlider, javax.swing.GroupLayout.PREFERRED_SIZE,
												126, javax.swing.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(scrollSensitvityField, javax.swing.GroupLayout.DEFAULT_SIZE, 69,
												Short.MAX_VALUE))
								.addGroup(layout.createSequentialGroup()
										.addComponent(preloadRangeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 40,
												javax.swing.GroupLayout.PREFERRED_SIZE)
										.addGap(0, 0, Short.MAX_VALUE))))
						.addGroup(
								layout.createSequentialGroup().addComponent(cancelButton)
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED,
												javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
										.addComponent(applyButton)
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 51,
												javax.swing.GroupLayout.PREFERRED_SIZE)
										.addGap(3, 3, 3)))
				.addContainerGap()));
		layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout
				.createSequentialGroup().addContainerGap()
				.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
						.addGroup(layout.createSequentialGroup().addComponent(scrollSensitivityLabel)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
								.addComponent(preloadRangeLabel)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
								.addComponent(antialiasingCheckbox)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
								.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
										.addComponent(cancelButton).addComponent(applyButton).addComponent(okButton)))
						.addGroup(layout.createSequentialGroup().addGroup(layout
								.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(scrollSensitivitySlider, javax.swing.GroupLayout.PREFERRED_SIZE,
										javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
								.addComponent(scrollSensitvityField, javax.swing.GroupLayout.Alignment.TRAILING,
										javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE,
										javax.swing.GroupLayout.PREFERRED_SIZE))
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
								.addComponent(preloadRangeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE,
										javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
				.addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)));

		pack();
	}// </editor-fold>

	private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {
		apply();
		dispose();
	}

	private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {
		apply();
	}

	private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {
		dispose();
	}

	private void scrollSensitvityFieldKeyPressed(java.awt.event.KeyEvent evt) {
		try {
			int val = Integer.parseInt(scrollSensitvityField.getText());
			val = Math.max(Math.min(val, 200), 1);
			scrollSensitivitySlider.setValue(val);
		} catch (NumberFormatException e) {
		}
	}

	// Variables declaration - do not modify
	private javax.swing.JCheckBox antialiasingCheckbox;
	private javax.swing.JButton applyButton;
	private javax.swing.JButton cancelButton;
	private javax.swing.JButton okButton;
	private javax.swing.JLabel preloadRangeLabel;
	private javax.swing.JSpinner preloadRangeSpinner;
	private javax.swing.JLabel scrollSensitivityLabel;
	private javax.swing.JSlider scrollSensitivitySlider;
	private javax.swing.JTextField scrollSensitvityField;
	// End of variables declaration

	private void init() {
		Settings settings = Settings.SETTINGS;
		int scrollSens = settings.getSetting("scrollSens");
		int preloadRange = settings.getSetting("preloadRange");
		boolean antialiasing = settings.getSetting("antialiasing");

		scrollSensitvityField.setText(new StringBuilder().append(scrollSens).toString());
		scrollSensitivitySlider.setValue(scrollSens);

		preloadRangeSpinner.setValue(preloadRange);

		antialiasingCheckbox.setSelected(antialiasing);
	}

	private void apply() {
		Settings settings = Settings.SETTINGS;
		Integer scrollSens = settings.getSetting("scrollSens");
		Integer preloadRange = settings.getSetting("preloadRange");
		Boolean antialiasing = settings.getSetting("antialiasing");

		try {
			scrollSens = Integer.parseInt(scrollSensitvityField.getText());
		} catch (NumberFormatException e) {
		}

		try {
			int set = (Integer) preloadRangeSpinner.getValue();
			preloadRange = set >= 0 ? set : 0;
		} catch (ClassCastException e) {
		}

		antialiasing = antialiasingCheckbox.isSelected();

		settings.setSetting("scrollSens", scrollSens);
		settings.setSetting("preloadRange", preloadRange);
		settings.setSetting("antialiasing", antialiasing);
	}
}
