#ifndef PRINTINFO_H
#define PRINTINFO_H

#include <stdio.h>
#include <inttypes.h>

#include "process_int.h"

#define DATE_FORMAT "%5.4d-%2.2d-%2.2d"
#define TIME_FORMAT "%2.2d:%2.2d:%2.2d"

std::string datetime_to_string(int64_t date, int time);
std::string date_to_string(int64_t date);
std::string time_to_string(int time);

const char *comptype_to_name(int comptype);

void print_filetype(CdoStreamID p_streamID, int vlistID);
void print_grid_info(int vlistID);
void print_zaxis_info(int vlistID);
void print_subtype_info(int vlistID);
void print_timesteps(CdoStreamID streamID, int taxisID, int verbose);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
