/*
 * Copyright (C) 2015 Masahiro Yamada <yamada.masahiro@socionext.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/platform_device.h>

#include "pinctrl-uniphier.h"

#define DRIVER_NAME "proxstream2-pinctrl"

static const struct pinctrl_pin_desc proxstream2_pins[] = {
	UNIPHIER_PINCTRL_PIN(0, "ED0", UNIPHIER_PIN_IECTRL_NONE,
			     0, UNIPHIER_PIN_DRV_4_8,
			     0, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(1, "ED1", UNIPHIER_PIN_IECTRL_NONE,
			     1, UNIPHIER_PIN_DRV_4_8,
			     1, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(2, "ED2", UNIPHIER_PIN_IECTRL_NONE,
			     2, UNIPHIER_PIN_DRV_4_8,
			     2, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(3, "ED3", UNIPHIER_PIN_IECTRL_NONE,
			     3, UNIPHIER_PIN_DRV_4_8,
			     3, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(4, "ED4", UNIPHIER_PIN_IECTRL_NONE,
			     4, UNIPHIER_PIN_DRV_4_8,
			     4, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(5, "ED5", UNIPHIER_PIN_IECTRL_NONE,
			     5, UNIPHIER_PIN_DRV_4_8,
			     5, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(6, "ED6", UNIPHIER_PIN_IECTRL_NONE,
			     6, UNIPHIER_PIN_DRV_4_8,
			     6, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(7, "ED7", UNIPHIER_PIN_IECTRL_NONE,
			     7, UNIPHIER_PIN_DRV_4_8,
			     7, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(8, "XERWE0", UNIPHIER_PIN_IECTRL_NONE,
			     8, UNIPHIER_PIN_DRV_4_8,
			     8, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(9, "XERWE1", UNIPHIER_PIN_IECTRL_NONE,
			     9, UNIPHIER_PIN_DRV_4_8,
			     9, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(10, "ERXW", UNIPHIER_PIN_IECTRL_NONE,
			     10, UNIPHIER_PIN_DRV_4_8,
			     10, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(11, "ES0", UNIPHIER_PIN_IECTRL_NONE,
			     11, UNIPHIER_PIN_DRV_4_8,
			     11, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(12, "ES1", UNIPHIER_PIN_IECTRL_NONE,
			     12, UNIPHIER_PIN_DRV_4_8,
			     12, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(13, "ES2", UNIPHIER_PIN_IECTRL_NONE,
			     13, UNIPHIER_PIN_DRV_4_8,
			     13, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(14, "XECS1", UNIPHIER_PIN_IECTRL_NONE,
			     14, UNIPHIER_PIN_DRV_4_8,
			     14, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(15, "SMTRST0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     15, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(16, "SMTCMD0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     16, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(17, "SMTD0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     17, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(18, "SMTSEL0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     18, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(19, "SMTCLK0CG", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     19, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(20, "SMTDET0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     20, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(21, "SMTRST1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     21, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(22, "SMTCMD1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     22, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(23, "SMTD1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     23, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(24, "SMTSEL1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     24, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(25, "SMTCLK1CG", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     25, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(26, "SMTDET1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     26, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(27, "XIRQ18", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     27, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(28, "XIRQ19", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     28, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(29, "XIRQ20", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     29, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(30, "XNFRE", UNIPHIER_PIN_IECTRL_NONE,
			     30, UNIPHIER_PIN_DRV_4_8,
			     30, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(31, "XNFWE", UNIPHIER_PIN_IECTRL_NONE,
			     31, UNIPHIER_PIN_DRV_4_8,
			     31, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(32, "NFALE", UNIPHIER_PIN_IECTRL_NONE,
			     32, UNIPHIER_PIN_DRV_4_8,
			     32, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(33, "NFCLE", UNIPHIER_PIN_IECTRL_NONE,
			     33, UNIPHIER_PIN_DRV_4_8,
			     33, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(34, "XNFWP", UNIPHIER_PIN_IECTRL_NONE,
			     34, UNIPHIER_PIN_DRV_4_8,
			     34, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(35, "XNFCE0", UNIPHIER_PIN_IECTRL_NONE,
			     35, UNIPHIER_PIN_DRV_4_8,
			     35, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(36, "NFRYBY0", UNIPHIER_PIN_IECTRL_NONE,
			     36, UNIPHIER_PIN_DRV_4_8,
			     36, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(37, "XNFCE1", UNIPHIER_PIN_IECTRL_NONE,
			     37, UNIPHIER_PIN_DRV_4_8,
			     37, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(38, "NFRYBY1", UNIPHIER_PIN_IECTRL_NONE,
			     38, UNIPHIER_PIN_DRV_4_8,
			     38, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(39, "NFD0", UNIPHIER_PIN_IECTRL_NONE,
			     39, UNIPHIER_PIN_DRV_4_8,
			     39, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(40, "NFD1", UNIPHIER_PIN_IECTRL_NONE,
			     40, UNIPHIER_PIN_DRV_4_8,
			     40, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(41, "NFD2", UNIPHIER_PIN_IECTRL_NONE,
			     41, UNIPHIER_PIN_DRV_4_8,
			     41, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(42, "NFD3", UNIPHIER_PIN_IECTRL_NONE,
			     42, UNIPHIER_PIN_DRV_4_8,
			     42, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(43, "NFD4", UNIPHIER_PIN_IECTRL_NONE,
			     43, UNIPHIER_PIN_DRV_4_8,
			     43, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(44, "NFD5", UNIPHIER_PIN_IECTRL_NONE,
			     44, UNIPHIER_PIN_DRV_4_8,
			     44, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(45, "NFD6", UNIPHIER_PIN_IECTRL_NONE,
			     45, UNIPHIER_PIN_DRV_4_8,
			     45, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(46, "NFD7", UNIPHIER_PIN_IECTRL_NONE,
			     46, UNIPHIER_PIN_DRV_4_8,
			     46, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(47, "SDCLK", UNIPHIER_PIN_IECTRL_NONE,
			     0, UNIPHIER_PIN_DRV_8_12_16_20,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(48, "SDCMD", UNIPHIER_PIN_IECTRL_NONE,
			     4, UNIPHIER_PIN_DRV_8_12_16_20,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(49, "SDDAT0", UNIPHIER_PIN_IECTRL_NONE,
			     8, UNIPHIER_PIN_DRV_8_12_16_20,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(50, "SDDAT1", UNIPHIER_PIN_IECTRL_NONE,
			     12, UNIPHIER_PIN_DRV_8_12_16_20,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(51, "SDDAT2", UNIPHIER_PIN_IECTRL_NONE,
			     16, UNIPHIER_PIN_DRV_8_12_16_20,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(52, "SDDAT3", UNIPHIER_PIN_IECTRL_NONE,
			     20, UNIPHIER_PIN_DRV_8_12_16_20,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(53, "SDCD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     53, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(54, "SDWP", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     54, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(55, "SDVOLC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     55, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(56, "USB0VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     56, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(57, "USB0OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     57, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(58, "USB1VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     58, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(59, "USB1OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     59, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(60, "USB2VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     60, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(61, "USB2OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     61, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(62, "USB3VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     62, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(63, "USB3OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     63, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(64, "CH0CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     64, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(65, "CH0PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     65, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(66, "CH0VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     66, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(67, "CH0DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     67, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(68, "CH1CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     68, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(69, "CH1PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     69, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(70, "CH1VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     70, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(71, "CH1DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     71, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(72, "XIRQ9", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     72, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(73, "XIRQ10", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     73, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(74, "XIRQ16", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     74, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(75, "CH4CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     75, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(76, "CH4PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     76, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(77, "CH4VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     77, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(78, "CH4DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     78, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(79, "CH5CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     79, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(80, "CH5PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     80, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(81, "CH5VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     81, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(82, "CH5DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     82, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(83, "CH6CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     83, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(84, "CH6PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     84, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(85, "CH6VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     85, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(86, "CH6DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     86, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(87, "STS0CLKO", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     87, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(88, "STS0SYNCO", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     88, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(89, "STS0VALO", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     89, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(90, "STS0DATAO", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     90, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(91, "XIRQ17", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     91, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(92, "PORT163", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     92, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(93, "PORT165", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     93, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(94, "PORT166", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     94, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(95, "PORT132", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     95, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(96, "PORT133", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     96, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(97, "AO2IEC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     97, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(98, "AI2ADCCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     98, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(99, "AI2BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     99, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(100, "AI2LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     100, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(101, "AI2D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     101, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(102, "AI2D1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     102, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(103, "AI2D2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     103, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(104, "AI2D3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     104, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(105, "AO3DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     105, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(106, "AO3BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     106, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(107, "AO3LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     107, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(108, "AO3DMIX", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     108, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(109, "SDA0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     109, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(110, "SCL0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     110, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(111, "SDA1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     111, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(112, "SCL1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     112, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(113, "TXD2", 0,
			     113, UNIPHIER_PIN_DRV_4_8,
			     113, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(114, "RXD2", 0,
			     114, UNIPHIER_PIN_DRV_4_8,
			     114, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(115, "TXD1", 0,
			     115, UNIPHIER_PIN_DRV_4_8,
			     115, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(116, "RXD1", 0,
			     116, UNIPHIER_PIN_DRV_4_8,
			     116, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(117, "PORT190", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     117, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(118, "VI1HSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     118, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(119, "VI1VSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     119, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(120, "VI1DE", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     120, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(121, "XIRQ3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     121, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(122, "XIRQ4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     122, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(123, "VI1G2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     123, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(124, "VI1G3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     124, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(125, "VI1G4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     125, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(126, "VI1G5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     126, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(127, "VI1G6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     127, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(128, "VI1G7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     128, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(129, "VI1G8", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     129, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(130, "VI1G9", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     130, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(131, "VI1CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     131, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(132, "PORT05", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     132, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(133, "PORT06", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     133, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(134, "VI1R2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     134, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(135, "VI1R3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     135, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(136, "VI1R4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     136, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(137, "VI1R5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     137, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(138, "VI1R6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     138, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(139, "VI1R7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     139, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(140, "VI1R8", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     140, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(141, "VI1R9", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     141, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(142, "LPST", UNIPHIER_PIN_IECTRL_NONE,
			     142, UNIPHIER_PIN_DRV_4_8,
			     142, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(143, "MDC", 0,
			     143, UNIPHIER_PIN_DRV_4_8,
			     143, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(144, "MDIO", 0,
			     144, UNIPHIER_PIN_DRV_4_8,
			     144, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(145, "MDIO_INTL", 0,
			     145, UNIPHIER_PIN_DRV_4_8,
			     145, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(146, "PHYRSTL", 0,
			     146, UNIPHIER_PIN_DRV_4_8,
			     146, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(147, "RGMII_RXCLK", 0,
			     147, UNIPHIER_PIN_DRV_4_8,
			     147, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(148, "RGMII_RXD0", 0,
			     148, UNIPHIER_PIN_DRV_4_8,
			     148, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(149, "RGMII_RXD1", 0,
			     149, UNIPHIER_PIN_DRV_4_8,
			     149, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(150, "RGMII_RXD2", 0,
			     150, UNIPHIER_PIN_DRV_4_8,
			     150, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(151, "RGMII_RXD3", 0,
			     151, UNIPHIER_PIN_DRV_4_8,
			     151, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(152, "RGMII_RXCTL", 0,
			     152, UNIPHIER_PIN_DRV_4_8,
			     152, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(153, "RGMII_TXCLK", 0,
			     153, UNIPHIER_PIN_DRV_4_8,
			     153, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(154, "RGMII_TXD0", 0,
			     154, UNIPHIER_PIN_DRV_4_8,
			     154, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(155, "RGMII_TXD1", 0,
			     155, UNIPHIER_PIN_DRV_4_8,
			     155, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(156, "RGMII_TXD2", 0,
			     156, UNIPHIER_PIN_DRV_4_8,
			     156, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(157, "RGMII_TXD3", 0,
			     157, UNIPHIER_PIN_DRV_4_8,
			     157, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(158, "RGMII_TXCTL", 0,
			     158, UNIPHIER_PIN_DRV_4_8,
			     158, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(159, "SDA3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     159, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(160, "SCL3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     160, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(161, "AI1ADCCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     161, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(162, "AI1BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     162, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(163, "CH2CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     163, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(164, "CH2PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     164, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(165, "CH2VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     165, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(166, "CH2DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     166, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(167, "CH3CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     167, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(168, "CH3PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     168, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(169, "CH3VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     169, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(170, "CH3DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     170, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(171, "SDA2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     171, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(172, "SCL2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     172, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(173, "AI1LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     173, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(174, "AI1D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     174, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(175, "AO2LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     175, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(176, "AO2D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     176, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(177, "AO2DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     177, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(178, "AO2BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     178, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(179, "PORT222", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     179, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(180, "PORT223", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     180, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(181, "PORT224", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     181, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(182, "PORT225", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     182, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(183, "PORT226", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     183, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(184, "PORT227", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     184, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(185, "PORT230", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     185, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(186, "FANPWM", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     186, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(187, "HRDDCSDA0", 0,
			     187, UNIPHIER_PIN_DRV_4_8,
			     187, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(188, "HRDDCSCL0", 0,
			     188, UNIPHIER_PIN_DRV_4_8,
			     188, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(189, "HRDDCSDA1", 0,
			     189, UNIPHIER_PIN_DRV_4_8,
			     189, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(190, "HRDDCSCL1", 0,
			     190, UNIPHIER_PIN_DRV_4_8,
			     190, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(191, "HTDDCSDA0", 0,
			     191, UNIPHIER_PIN_DRV_4_8,
			     191, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(192, "HTDDCSCL0", 0,
			     192, UNIPHIER_PIN_DRV_4_8,
			     192, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(193, "HTDDCSDA1", 0,
			     193, UNIPHIER_PIN_DRV_4_8,
			     193, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(194, "HTDDCSCL1", 0,
			     194, UNIPHIER_PIN_DRV_4_8,
			     194, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(195, "PORT241", 0,
			     195, UNIPHIER_PIN_DRV_4_8,
			     195, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(196, "PORT242", 0,
			     196, UNIPHIER_PIN_DRV_4_8,
			     196, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(197, "PORT243", 0,
			     197, UNIPHIER_PIN_DRV_4_8,
			     197, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(198, "MVSYNC", 0,
			     198, UNIPHIER_PIN_DRV_4_8,
			     198, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(199, "SPISYNC0", UNIPHIER_PIN_IECTRL_NONE,
			     199, UNIPHIER_PIN_DRV_4_8,
			     199, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(200, "SPISCLK0", UNIPHIER_PIN_IECTRL_NONE,
			     200, UNIPHIER_PIN_DRV_4_8,
			     200, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(201, "SPITXD0", UNIPHIER_PIN_IECTRL_NONE,
			     201, UNIPHIER_PIN_DRV_4_8,
			     201, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(202, "SPIRXD0", UNIPHIER_PIN_IECTRL_NONE,
			     202, UNIPHIER_PIN_DRV_4_8,
			     202, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(203, "CK54EXI", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     203, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(204, "AEXCKA1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     204, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(205, "AEXCKA2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     205, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(206, "CK27EXI", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_8,
			     206, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(207, "STCDIN", 0,
			     207, UNIPHIER_PIN_DRV_4_8,
			     207, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(208, "PHSYNI", 0,
			     208, UNIPHIER_PIN_DRV_4_8,
			     208, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(209, "PVSYNI", 0,
			     209, UNIPHIER_PIN_DRV_4_8,
			     209, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(210, "MVSYN", UNIPHIER_PIN_IECTRL_NONE,
			     210, UNIPHIER_PIN_DRV_4_8,
			     210, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(211, "STCV", UNIPHIER_PIN_IECTRL_NONE,
			     211, UNIPHIER_PIN_DRV_4_8,
			     211, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(212, "PORT262", UNIPHIER_PIN_IECTRL_NONE,
			     212, UNIPHIER_PIN_DRV_4_8,
			     212, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(213, "USB0VBUS_IRQ", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_4,
			     213, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(214, "USB1VBUS_IRQ", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED_4,
			     214, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(215, "PORT265", UNIPHIER_PIN_IECTRL_NONE,
			     215, UNIPHIER_PIN_DRV_4_8,
			     215, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(216, "CK25O", 0,
			     216, UNIPHIER_PIN_DRV_4_8,
			     216, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(217, "TXD0", 0,
			     217, UNIPHIER_PIN_DRV_4_8,
			     217, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(218, "RXD0", 0,
			     218, UNIPHIER_PIN_DRV_4_8,
			     218, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(219, "TXD3", 0,
			     219, UNIPHIER_PIN_DRV_4_8,
			     219, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(220, "RXD3", 0,
			     220, UNIPHIER_PIN_DRV_4_8,
			     220, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(221, "PORT273", 0,
			     221, UNIPHIER_PIN_DRV_4_8,
			     221, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(222, "STCDOUTC", 0,
			     222, UNIPHIER_PIN_DRV_4_8,
			     222, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(223, "PORT274", 0,
			     223, UNIPHIER_PIN_DRV_4_8,
			     223, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(224, "PORT275", 0,
			     224, UNIPHIER_PIN_DRV_4_8,
			     224, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(225, "PORT276", 0,
			     225, UNIPHIER_PIN_DRV_4_8,
			     225, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(226, "PORT277", 0,
			     226, UNIPHIER_PIN_DRV_4_8,
			     226, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(227, "PORT280", 0,
			     227, UNIPHIER_PIN_DRV_4_8,
			     227, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(228, "PORT281", 0,
			     228, UNIPHIER_PIN_DRV_4_8,
			     228, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(229, "PORT282", 0,
			     229, UNIPHIER_PIN_DRV_4_8,
			     229, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(230, "PORT283", 0,
			     230, UNIPHIER_PIN_DRV_4_8,
			     230, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(231, "PORT284", 0,
			     231, UNIPHIER_PIN_DRV_4_8,
			     231, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(232, "PORT285", 0,
			     232, UNIPHIER_PIN_DRV_4_8,
			     232, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(233, "T0HPD", 0,
			     233, UNIPHIER_PIN_DRV_4_8,
			     233, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(234, "T1HPD", 0,
			     234, UNIPHIER_PIN_DRV_4_8,
			     234, UNIPHIER_PIN_PULL_DOWN),
};

static const unsigned emmc_pins[] = {36, 37, 38, 39, 40, 41, 42};
static const unsigned emmc_muxvals[] = {9, 9, 9, 9, 9, 9, 9};
static const unsigned emmc_dat8_pins[] = {43, 44, 45, 46};
static const unsigned emmc_dat8_muxvals[] = {9, 9, 9, 9};
static const unsigned i2c0_pins[] = {109, 110};
static const unsigned i2c0_muxvals[] = {8, 8};
static const unsigned i2c1_pins[] = {111, 112};
static const unsigned i2c1_muxvals[] = {8, 8};
static const unsigned i2c2_pins[] = {171, 172};
static const unsigned i2c2_muxvals[] = {8, 8};
static const unsigned i2c3_pins[] = {159, 160};
static const unsigned i2c3_muxvals[] = {8, 8};
static const unsigned i2c5_pins[] = {183, 184};
static const unsigned i2c5_muxvals[] = {11, 11};
static const unsigned i2c6_pins[] = {185, 186};
static const unsigned i2c6_muxvals[] = {11, 11};
static const unsigned nand_pins[] = {30, 31, 32, 33, 34, 35, 36, 39, 40, 41,
				     42, 43, 44, 45, 46};
static const unsigned nand_muxvals[] = {8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
					8, 8};
static const unsigned nand_cs1_pins[] = {37, 38};
static const unsigned nand_cs1_muxvals[] = {8, 8};
static const unsigned sd_pins[] = {47, 48, 49, 50, 51, 52, 53, 54, 55};
static const unsigned sd_muxvals[] = {8, 8, 8, 8, 8, 8, 8, 8, 8};
static const unsigned uart0_pins[] = {217, 218};
static const unsigned uart0_muxvals[] = {8, 8};
static const unsigned uart0b_pins[] = {179, 180};
static const unsigned uart0b_muxvals[] = {10, 10};
static const unsigned uart1_pins[] = {115, 116};
static const unsigned uart1_muxvals[] = {8, 8};
static const unsigned uart2_pins[] = {113, 114};
static const unsigned uart2_muxvals[] = {8, 8};
static const unsigned uart3_pins[] = {219, 220};
static const unsigned uart3_muxvals[] = {8, 8};
static const unsigned uart3b_pins[] = {181, 182};
static const unsigned uart3b_muxvals[] = {10, 10};
static const unsigned usb0_pins[] = {56, 57};
static const unsigned usb0_muxvals[] = {8, 8};
static const unsigned usb1_pins[] = {58, 59};
static const unsigned usb1_muxvals[] = {8, 8};
static const unsigned usb2_pins[] = {60, 61};
static const unsigned usb2_muxvals[] = {8, 8};
static const unsigned usb3_pins[] = {62, 63};
static const unsigned usb3_muxvals[] = {8, 8};
static const unsigned port_range0_pins[] = {
	127, 128, 129, 130, 131, 132, 133, 134,		/* PORT0x */
	135, 136, 137, 138, 139, 140, 141, 142,		/* PORT1x */
	0, 1, 2, 3, 4, 5, 6, 7,				/* PORT2x */
	8, 9, 10, 11, 12, 13, 14, 15,			/* PORT3x */
	16, 17, 18, 19, 21, 22, 23, 24,			/* PORT4x */
	25, 30, 31, 32, 33, 34, 35, 36,			/* PORT5x */
	37, 38, 39, 40, 41, 42, 43, 44,			/* PORT6x */
	45, 46, 47, 48, 49, 50, 51, 52,			/* PORT7x */
	53, 54, 55, 56, 57, 58, 59, 60,			/* PORT8x */
	61, 62, 63, 64, 65, 66, 67, 68,			/* PORT9x */
	69, 70, 71, 76, 77, 78, 79, 80,			/* PORT10x */
};
static const unsigned port_range0_muxvals[] = {
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT0x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT1x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT2x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT3x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT4x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT5x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT6x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT7x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT8x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT9x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT10x */
};
static const unsigned port_range1_pins[] = {
	81, 82, 83, 84, 85, 86, 87, 88,			/* PORT12x */
	89, 90, 95, 96, 97, 98, 99, 100,		/* PORT13x */
	101, 102, 103, 104, 105, 106, 107, 108,		/* PORT14x */
	118, 119, 120, 121, 122, 123, 124, 125,		/* PORT15x */
	126, 72, 73, 92, 177, 93, 94, 176,		/* PORT16x */
	74, 91, 27, 28, 29, 75, 20, 26,			/* PORT17x */
	109, 110, 111, 112, 113, 114, 115, 116,		/* PORT18x */
	117, 143, 144, 145, 146, 147, 148, 149,		/* PORT19x */
	150, 151, 152, 153, 154, 155, 156, 157,		/* PORT20x */
	158, 159, 160, 161, 162, 163, 164, 165,		/* PORT21x */
	166, 178, 179, 180, 181, 182, 183, 184,		/* PORT22x */
	185, 187, 188, 189, 190, 191, 192, 193,		/* PORT23x */
	194, 195, 196, 197, 198, 199, 200, 201,		/* PORT24x */
	202, 203, 204, 205, 206, 207, 208, 209,		/* PORT25x */
	210, 211, 212, 213, 214, 215, 216, 217,		/* PORT26x */
	218, 219, 220, 221, 223, 224, 225, 226,		/* PORT27x */
	227, 228, 229, 230, 231, 232, 233, 234,		/* PORT28x */
};
static const unsigned port_range1_muxvals[] = {
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT12x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT13x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT14x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT15x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT16x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT17x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT18x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT19x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT20x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT21x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT22x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT23x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT24x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT25x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT26x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT27x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT28x */
};
static const unsigned xirq_pins[] = {
	118, 119, 120, 121, 122, 123, 124, 125,		/* XIRQ0-7 */
	126, 72, 73, 92, 177, 93, 94, 176,		/* XIRQ8-15 */
	74, 91, 27, 28, 29, 75, 20, 26,			/* XIRQ16-23 */
};
static const unsigned xirq_muxvals[] = {
	14, 14, 14, 14, 14, 14, 14, 14,			/* XIRQ0-7 */
	14, 14, 14, 14, 14, 14, 14, 14,			/* XIRQ8-15 */
	14, 14, 14, 14, 14, 14, 14, 14,			/* XIRQ16-23 */
};

static const struct uniphier_pinctrl_group proxstream2_groups[] = {
	UNIPHIER_PINCTRL_GROUP(emmc),
	UNIPHIER_PINCTRL_GROUP(emmc_dat8),
	UNIPHIER_PINCTRL_GROUP(i2c0),
	UNIPHIER_PINCTRL_GROUP(i2c1),
	UNIPHIER_PINCTRL_GROUP(i2c2),
	UNIPHIER_PINCTRL_GROUP(i2c3),
	UNIPHIER_PINCTRL_GROUP(i2c5),
	UNIPHIER_PINCTRL_GROUP(i2c6),
	UNIPHIER_PINCTRL_GROUP(nand),
	UNIPHIER_PINCTRL_GROUP(nand_cs1),
	UNIPHIER_PINCTRL_GROUP(sd),
	UNIPHIER_PINCTRL_GROUP(uart0),
	UNIPHIER_PINCTRL_GROUP(uart0b),
	UNIPHIER_PINCTRL_GROUP(uart1),
	UNIPHIER_PINCTRL_GROUP(uart2),
	UNIPHIER_PINCTRL_GROUP(uart3),
	UNIPHIER_PINCTRL_GROUP(uart3b),
	UNIPHIER_PINCTRL_GROUP(usb0),
	UNIPHIER_PINCTRL_GROUP(usb1),
	UNIPHIER_PINCTRL_GROUP(usb2),
	UNIPHIER_PINCTRL_GROUP(usb3),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_PORT(port_range0),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_PORT(port_range1),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_IRQ(xirq),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port00, port_range0, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port01, port_range0, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port02, port_range0, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port03, port_range0, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port04, port_range0, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port05, port_range0, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port06, port_range0, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port07, port_range0, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port10, port_range0, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port11, port_range0, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port12, port_range0, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port13, port_range0, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port14, port_range0, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port15, port_range0, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port16, port_range0, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port17, port_range0, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port20, port_range0, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port21, port_range0, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port22, port_range0, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port23, port_range0, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port24, port_range0, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port25, port_range0, 21),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port26, port_range0, 22),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port27, port_range0, 23),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port30, port_range0, 24),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port31, port_range0, 25),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port32, port_range0, 26),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port33, port_range0, 27),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port34, port_range0, 28),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port35, port_range0, 29),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port36, port_range0, 30),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port37, port_range0, 31),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port40, port_range0, 32),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port41, port_range0, 33),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port42, port_range0, 34),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port43, port_range0, 35),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port44, port_range0, 36),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port45, port_range0, 37),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port46, port_range0, 38),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port47, port_range0, 39),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port50, port_range0, 40),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port51, port_range0, 41),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port52, port_range0, 42),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port53, port_range0, 43),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port54, port_range0, 44),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port55, port_range0, 45),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port56, port_range0, 46),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port57, port_range0, 47),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port60, port_range0, 48),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port61, port_range0, 49),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port62, port_range0, 50),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port63, port_range0, 51),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port64, port_range0, 52),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port65, port_range0, 53),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port66, port_range0, 54),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port67, port_range0, 55),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port70, port_range0, 56),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port71, port_range0, 57),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port72, port_range0, 58),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port73, port_range0, 59),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port74, port_range0, 60),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port75, port_range0, 61),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port76, port_range0, 62),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port77, port_range0, 63),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port80, port_range0, 64),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port81, port_range0, 65),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port82, port_range0, 66),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port83, port_range0, 67),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port84, port_range0, 68),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port85, port_range0, 69),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port86, port_range0, 70),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port87, port_range0, 71),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port90, port_range0, 72),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port91, port_range0, 73),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port92, port_range0, 74),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port93, port_range0, 75),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port94, port_range0, 76),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port95, port_range0, 77),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port96, port_range0, 78),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port97, port_range0, 79),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port100, port_range0, 80),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port101, port_range0, 81),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port102, port_range0, 82),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port103, port_range0, 83),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port104, port_range0, 84),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port105, port_range0, 85),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port106, port_range0, 86),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port107, port_range0, 87),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port120, port_range1, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port121, port_range1, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port122, port_range1, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port123, port_range1, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port124, port_range1, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port125, port_range1, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port126, port_range1, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port127, port_range1, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port130, port_range1, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port131, port_range1, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port132, port_range1, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port133, port_range1, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port134, port_range1, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port135, port_range1, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port136, port_range1, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port137, port_range1, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port140, port_range1, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port141, port_range1, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port142, port_range1, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port143, port_range1, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port144, port_range1, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port145, port_range1, 21),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port146, port_range1, 22),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port147, port_range1, 23),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port150, port_range1, 24),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port151, port_range1, 25),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port152, port_range1, 26),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port153, port_range1, 27),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port154, port_range1, 28),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port155, port_range1, 29),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port156, port_range1, 30),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port157, port_range1, 31),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port160, port_range1, 32),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port161, port_range1, 33),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port162, port_range1, 34),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port163, port_range1, 35),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port164, port_range1, 36),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port165, port_range1, 37),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port166, port_range1, 38),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port167, port_range1, 39),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port170, port_range1, 40),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port171, port_range1, 41),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port172, port_range1, 42),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port173, port_range1, 43),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port174, port_range1, 44),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port175, port_range1, 45),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port176, port_range1, 46),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port177, port_range1, 47),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port180, port_range1, 48),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port181, port_range1, 49),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port182, port_range1, 50),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port183, port_range1, 51),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port184, port_range1, 52),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port185, port_range1, 53),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port186, port_range1, 54),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port187, port_range1, 55),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port190, port_range1, 56),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port191, port_range1, 57),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port192, port_range1, 58),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port193, port_range1, 59),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port194, port_range1, 60),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port195, port_range1, 61),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port196, port_range1, 62),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port197, port_range1, 63),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port200, port_range1, 64),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port201, port_range1, 65),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port202, port_range1, 66),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port203, port_range1, 67),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port204, port_range1, 68),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port205, port_range1, 69),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port206, port_range1, 70),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port207, port_range1, 71),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port210, port_range1, 72),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port211, port_range1, 73),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port212, port_range1, 74),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port213, port_range1, 75),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port214, port_range1, 76),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port215, port_range1, 77),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port216, port_range1, 78),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port217, port_range1, 79),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port220, port_range1, 80),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port221, port_range1, 81),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port222, port_range1, 82),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port223, port_range1, 83),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port224, port_range1, 84),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port225, port_range1, 85),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port226, port_range1, 86),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port227, port_range1, 87),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port230, port_range1, 88),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port231, port_range1, 89),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port232, port_range1, 90),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port233, port_range1, 91),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port234, port_range1, 92),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port235, port_range1, 93),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port236, port_range1, 94),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port237, port_range1, 95),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port240, port_range1, 96),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port241, port_range1, 97),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port242, port_range1, 98),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port243, port_range1, 99),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port244, port_range1, 100),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port245, port_range1, 101),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port246, port_range1, 102),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port247, port_range1, 103),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port250, port_range1, 104),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port251, port_range1, 105),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port252, port_range1, 106),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port253, port_range1, 107),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port254, port_range1, 108),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port255, port_range1, 109),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port256, port_range1, 110),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port257, port_range1, 111),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port260, port_range1, 112),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port261, port_range1, 113),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port262, port_range1, 114),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port263, port_range1, 115),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port264, port_range1, 116),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port265, port_range1, 117),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port266, port_range1, 118),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port267, port_range1, 119),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port270, port_range1, 120),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port271, port_range1, 121),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port272, port_range1, 122),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port273, port_range1, 123),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port274, port_range1, 124),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port275, port_range1, 125),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port276, port_range1, 126),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port277, port_range1, 127),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port280, port_range1, 128),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port281, port_range1, 129),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port282, port_range1, 130),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port283, port_range1, 131),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port284, port_range1, 132),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port285, port_range1, 133),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port286, port_range1, 134),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port287, port_range1, 135),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq0, xirq, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq1, xirq, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq2, xirq, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq3, xirq, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq4, xirq, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq5, xirq, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq6, xirq, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq7, xirq, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq8, xirq, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq9, xirq, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq10, xirq, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq11, xirq, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq12, xirq, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq13, xirq, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq14, xirq, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq15, xirq, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq16, xirq, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq17, xirq, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq18, xirq, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq19, xirq, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq20, xirq, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq21, xirq, 21),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq22, xirq, 22),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq23, xirq, 23),
};

static const char * const emmc_groups[] = {"emmc", "emmc_dat8"};
static const char * const i2c0_groups[] = {"i2c0"};
static const char * const i2c1_groups[] = {"i2c1"};
static const char * const i2c2_groups[] = {"i2c2"};
static const char * const i2c3_groups[] = {"i2c3"};
static const char * const i2c5_groups[] = {"i2c5"};
static const char * const i2c6_groups[] = {"i2c6"};
static const char * const nand_groups[] = {"nand", "nand_cs1"};
static const char * const sd_groups[] = {"sd"};
static const char * const uart0_groups[] = {"uart0", "uart0b"};
static const char * const uart1_groups[] = {"uart1"};
static const char * const uart2_groups[] = {"uart2"};
static const char * const uart3_groups[] = {"uart3", "uart3b"};
static const char * const usb0_groups[] = {"usb0"};
static const char * const usb1_groups[] = {"usb1"};
static const char * const usb2_groups[] = {"usb2"};
static const char * const usb3_groups[] = {"usb3"};
static const char * const port_groups[] = {
	"port00",  "port01",  "port02",  "port03",
	"port04",  "port05",  "port06",  "port07",
	"port10",  "port11",  "port12",  "port13",
	"port14",  "port15",  "port16",  "port17",
	"port20",  "port21",  "port22",  "port23",
	"port24",  "port25",  "port26",  "port27",
	"port30",  "port31",  "port32",  "port33",
	"port34",  "port35",  "port36",  "port37",
	"port40",  "port41",  "port42",  "port43",
	"port44",  "port45",  "port46",  "port47",
	"port50",  "port51",  "port52",  "port53",
	"port54",  "port55",  "port56",  "port57",
	"port60",  "port61",  "port62",  "port63",
	"port64",  "port65",  "port66",  "port67",
	"port70",  "port71",  "port72",  "port73",
	"port74",  "port75",  "port76",  "port77",
	"port80",  "port81",  "port82",  "port83",
	"port84",  "port85",  "port86",  "port87",
	"port90",  "port91",  "port92",  "port93",
	"port94",  "port95",  "port96",  "port97",
	"port100", "port101", "port102", "port103",
	"port104", "port105", "port106", "port107",
	/* port110-117 missing */
	"port120", "port121", "port122", "port123",
	"port124", "port125", "port126", "port127",
	"port130", "port131", "port132", "port133",
	"port134", "port135", "port136", "port137",
	"port140", "port141", "port142", "port143",
	"port144", "port145", "port146", "port147",
	"port150", "port151", "port152", "port153",
	"port154", "port155", "port156", "port157",
	"port160", "port161", "port162", "port163",
	"port164", "port165", "port166", "port167",
	"port170", "port171", "port172", "port173",
	"port174", "port175", "port176", "port177",
	"port180", "port181", "port182", "port183",
	"port184", "port185", "port186", "port187",
	"port190", "port191", "port192", "port193",
	"port194", "port195", "port196", "port197",
	"port200", "port201", "port202", "port203",
	"port204", "port205", "port206", "port207",
	"port210", "port211", "port212", "port213",
	"port214", "port215", "port216", "port217",
	"port220", "port221", "port222", "port223",
	"port224", "port225", "port226", "port227",
	"port230", "port231", "port232", "port233",
	"port234", "port235", "port236", "port237",
	"port240", "port241", "port242", "port243",
	"port244", "port245", "port246", "port247",
	"port250", "port251", "port252", "port253",
	"port254", "port255", "port256", "port257",
	"port260", "port261", "port262", "port263",
	"port264", "port265", "port266", "port267",
	"port270", "port271", "port272", "port273",
	"port274", "port275", "port276", "port277",
	"port280", "port281", "port282", "port283",
	"port284", "port285", "port286", "port287",
};
static const char * const xirq_groups[] = {
	"xirq0",  "xirq1",  "xirq2",  "xirq3",
	"xirq4",  "xirq5",  "xirq6",  "xirq7",
	"xirq8",  "xirq9",  "xirq10", "xirq11",
	"xirq12", "xirq13", "xirq14", "xirq15",
	"xirq16", "xirq17", "xirq18", "xirq19",
	"xirq20", "xirq21", "xirq22", "xirq23",
};

static const struct uniphier_pinmux_function proxstream2_functions[] = {
	UNIPHIER_PINMUX_FUNCTION(emmc),
	UNIPHIER_PINMUX_FUNCTION(i2c0),
	UNIPHIER_PINMUX_FUNCTION(i2c1),
	UNIPHIER_PINMUX_FUNCTION(i2c2),
	UNIPHIER_PINMUX_FUNCTION(i2c3),
	UNIPHIER_PINMUX_FUNCTION(i2c5),
	UNIPHIER_PINMUX_FUNCTION(i2c6),
	UNIPHIER_PINMUX_FUNCTION(nand),
	UNIPHIER_PINMUX_FUNCTION(sd),
	UNIPHIER_PINMUX_FUNCTION(uart0),
	UNIPHIER_PINMUX_FUNCTION(uart1),
	UNIPHIER_PINMUX_FUNCTION(uart2),
	UNIPHIER_PINMUX_FUNCTION(uart3),
	UNIPHIER_PINMUX_FUNCTION(usb0),
	UNIPHIER_PINMUX_FUNCTION(usb1),
	UNIPHIER_PINMUX_FUNCTION(usb2),
	UNIPHIER_PINMUX_FUNCTION(usb3),
	UNIPHIER_PINMUX_FUNCTION(port),
	UNIPHIER_PINMUX_FUNCTION(xirq),
};

static struct uniphier_pinctrl_socdata proxstream2_pindata = {
	.groups = proxstream2_groups,
	.groups_count = ARRAY_SIZE(proxstream2_groups),
	.functions = proxstream2_functions,
	.functions_count = ARRAY_SIZE(proxstream2_functions),
	.mux_bits = 8,
	.reg_stride = 4,
	.load_pinctrl = false,
};

static struct pinctrl_desc proxstream2_pinctrl_desc = {
	.name = DRIVER_NAME,
	.pins = proxstream2_pins,
	.npins = ARRAY_SIZE(proxstream2_pins),
	.owner = THIS_MODULE,
};

static int proxstream2_pinctrl_probe(struct platform_device *pdev)
{
	return uniphier_pinctrl_probe(pdev, &proxstream2_pinctrl_desc,
				      &proxstream2_pindata);
}

static const struct of_device_id proxstream2_pinctrl_match[] = {
	{ .compatible = "socionext,proxstream2-pinctrl" },
	{ /* sentinel */ }
};
MODULE_DEVICE_TABLE(of, proxstream2_pinctrl_match);

static struct platform_driver proxstream2_pinctrl_driver = {
	.probe = proxstream2_pinctrl_probe,
	.driver = {
		.name = DRIVER_NAME,
		.of_match_table = proxstream2_pinctrl_match,
	},
};
module_platform_driver(proxstream2_pinctrl_driver);

MODULE_AUTHOR("Masahiro Yamada <yamada.masahiro@socionext.com>");
MODULE_DESCRIPTION("UniPhier ProXstream2 pinctrl driver");
MODULE_LICENSE("GPL");
