/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2003 Ralf Baechle
 */
#ifndef _ASM_ASMMACRO_H
#define _ASM_ASMMACRO_H
 
#include <linux/config.h>
#include <asm/hazards.h>
 
#ifdef CONFIG_MIPS32
#include <asm/asmmacro-32.h>
#endif
#ifdef CONFIG_MIPS64
#include <asm/asmmacro-64.h>
#endif

	.macro	local_irq_enable reg=t0
	mfc0	\reg, CP0_STATUS
	ori	\reg, \reg, 1
	mtc0	\reg, CP0_STATUS
	irq_enable_hazard
	.endm

	.macro	local_irq_disable reg=t0
	mfc0	\reg, CP0_STATUS
	ori	\reg, \reg, 1
	xori	\reg, \reg, 1
	mtc0	\reg, CP0_STATUS
	irq_disable_hazard
	.endm

#ifdef CONFIG_CPU_SB1
	.macro	fpu_enable_hazard
	.set	push
	.set	noreorder
	.set	mips2
	SSNOP
	bnezl	$0, .+4
	 SSNOP
	.set	pop
	.endm
#else
	.macro	fpu_enable_hazard
	.endm
#endif

#endif /* _ASM_ASMMACRO_H */
