/*
 * linux/arch/arm/lib/getconstants.c
 *
 * Copyright (C) 1995, 1996 Russell King
 */

#include <linux/mm.h>
#include <asm/pgtable.h>
#include <stdio.h>
#include <linux/unistd.h>

void printdef(char *def, int no)
{
	printf("#define %s\t%d\n", def, no);
}

#include "getconstants.h"

int main()
{
	printf("/*\n *  contants.h generated by getconstants\n * DO NOT EDIT!\n */\n");

	printf("#define _current\t_%s\n", "current_set");

#ifdef _PAGE_PRESENT
	printdef("PAGE_PRESENT",	_PAGE_PRESENT);
#endif
#ifdef _PAGE_RW
	printdef("PAGE_RW",		_PAGE_RW);
#endif
#ifdef _PAGE_USER
	printdef("PAGE_USER",		_PAGE_USER);
#endif
#ifdef _PAGE_ACCESSED
	printdef("PAGE_ACCESSED",	_PAGE_ACCESSED);
#endif
#ifdef _PAGE_DIRTY
	printdef("PAGE_DIRTY",		_PAGE_DIRTY);
#endif
#ifdef _PAGE_READONLY
	printdef("PAGE_READONLY",	_PAGE_READONLY);
#endif
#ifdef _PAGE_NOT_USER
	printdef("PAGE_NOT_USER",	_PAGE_NOT_USER);
#endif
#ifdef _PAGE_OLD
	printdef("PAGE_OLD",		_PAGE_OLD);
#endif
#ifdef _PAGE_CLEAN
	printdef("PAGE_CLEAN",		_PAGE_CLEAN);
#endif
	printdef("TSS_MEMMAP",		(int)tss_memmap);
	printdef("TSS_SAVE",		(int)tss_save);
#ifdef __HAS_tss_memcmap
	printdef("TSS_MEMCMAP",		(int)tss_memcmap);
#endif
#ifdef __HAS_addr_limit
	printdef("ADDR_LIMIT",		(int)addr_limit);
#endif
#ifdef __HAS_kernel_domain
	printdef("KERNEL_DOMAIN",	kernel_domain);
#endif
#ifdef __HAS_user_domain
	printdef("USER_DOMAIN",		user_domain);
#endif
	printdef("TSS_FPESAVE",		(int)tss_fpesave);
	printdef("MM",			(int)mm);
	printdef("PGD",			(int)pgd);

	printf("#define KSWI_BASE	0x900000\n");
	printf("#define KSWI_SYS_BASE	0x9F0000\n");
	printf("#define SYS_ERROR0	0x9F0000\n");
	return 0;
}
