/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui.typesafe;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public final class TypeSafeTextDocumentFilter
extends DocumentFilter {
    public static final int DEFAULT_MAXCHARS = 4096;
    private static final boolean DEFAULT_UPPERCASE = false;
    private static final boolean DEFAULT_LOWERCASE = false;
    private static final String DEFAULT_VALIDCHARS = "";
    private static final String DEFAULT_INVALIDCHARS = "";
    private static final String DEFAULT_REPLACABLECHARS = "";
    private static final String DEFAULT_REPLACEDCHARS = "";
    private boolean m_upperCase = false;
    private boolean m_lowerCase = false;
    private int m_maxChars = 4096;
    private String m_validChars = "";
    private String m_invalidChars = "";
    private String m_replacableChars = "";
    private String m_replacedChars = "";

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
        this.replace(fb, offset, 0, text, attrs);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        this.replace(fb, offset, length, "", null);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        int i;
        if (text == null) {
            text = "";
        }
        Document doc = fb.getDocument();
        int currentLength = doc.getLength();
        String currentContent = doc.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = before + text + after;
        if (newValue.length() > this.m_maxChars) {
            throw new BadLocationException("MaxChars limit exceeded", newValue.length());
        }
        if (this.m_validChars.length() > 0) {
            for (i = 0; i < text.length(); ++i) {
                if (this.m_validChars.indexOf(text.charAt(i)) != -1) continue;
                throw new BadLocationException("Invalid character", i);
            }
        }
        if (this.m_invalidChars.length() > 0) {
            for (i = 0; i < text.length(); ++i) {
                if (this.m_invalidChars.indexOf(text.charAt(i)) == -1) continue;
                throw new BadLocationException("Invalid character", i);
            }
        }
        if (this.m_replacableChars.length() > 0 && this.m_replacedChars.length() > 0 && this.m_replacableChars.length() == this.m_replacedChars.length()) {
            char[] data = text.toCharArray();
            block2: for (int i2 = 0; i2 < data.length; ++i2) {
                for (int j = 0; j < this.m_replacableChars.length(); ++j) {
                    if (data[i2] != this.m_replacableChars.charAt(j)) continue;
                    data[i2] = this.m_replacedChars.charAt(j);
                    continue block2;
                }
            }
            text = String.copyValueOf(data);
        }
        text = this.m_upperCase ? text.toUpperCase() : text;
        text = this.m_lowerCase ? text.toLowerCase() : text;
        fb.replace(offset, length, text, attrs);
    }

    public boolean getUpperCase() {
        return this.m_upperCase;
    }

    public void setUpperCase(boolean f) {
        this.m_upperCase = f;
    }

    public boolean getLowerCase() {
        return this.m_lowerCase;
    }

    public void setLowerCase(boolean f) {
        this.m_lowerCase = f;
    }

    public int getMaxChars() {
        return this.m_maxChars;
    }

    public void setMaxChars(int num) {
        if (num <= 0) {
            System.err.println("TypeSafeTextDocumentFilter: invalid maxChars(" + num + "), reverting to default(" + 4096 + ")");
            this.m_maxChars = 4096;
        } else {
            this.m_maxChars = num;
        }
    }

    public String getValidChars() {
        return this.m_validChars;
    }

    public void setValidChars(String all) {
        this.m_validChars = all == null ? "" : all;
    }

    public String getInvalidChars() {
        return this.m_invalidChars;
    }

    public void setInvalidChars(String all) {
        this.m_invalidChars = all == null ? "" : all;
    }

    public String getReplacableChars() {
        return this.m_replacableChars;
    }

    public void setReplacableChars(String all) {
        this.m_replacableChars = all == null ? "" : all;
    }

    public String getReplacedChars() {
        return this.m_replacedChars;
    }

    public void setReplacedChars(String all) {
        this.m_replacedChars = all == null ? "" : all;
    }
}

