/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;

public abstract class AOffset
implements Serializable {
    private static final long serialVersionUID = -4143271285905723425L;
    protected static final Log LOG = LogFactory.getLog((String)AOffset.class.getName());
    protected SoftReference<Map<Integer, AIterator>> skipIterators;

    public abstract AIterator getIterator();

    public AIterator getIterator(int row) {
        Map<Integer, AIterator> sk;
        AIterator it;
        if (this.skipIterators != null && (it = (AIterator)(sk = this.skipIterators.get()).getOrDefault(row, null)) != null) {
            return it.clone();
        }
        AIterator it2 = this.getIterator();
        it2.skipTo(row);
        this.cacheIterator(it2.clone(), row);
        return it2;
    }

    public void cacheIterator(AIterator it, int row) {
        if (this.skipIterators != null) {
            Map<Integer, AIterator> sk = this.skipIterators.get();
            sk.put(row, it);
        } else {
            HashMap<Integer, AIterator> nsk = new HashMap<Integer, AIterator>();
            nsk.put(row, it.clone());
            this.skipIterators = new SoftReference(nsk);
        }
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract long getInMemorySize();

    public abstract long getExactSizeOnDisk();

    public abstract int getSize();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        AIterator i = this.getIterator();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(i.valueAndIncrement());
        while (i.hasNext()) {
            sb.append(", " + i.valueAndIncrement());
        }
        sb.append("]");
        return sb.toString();
    }
}

