/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import java.io.IOException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.sysml.api.mlcontext.MLContextException;

public class ProjectInfo {
    SortedMap<String, String> properties = null;
    static ProjectInfo projectInfo = null;

    public static ProjectInfo getProjectInfo() {
        if (projectInfo == null) {
            projectInfo = new ProjectInfo();
        }
        return projectInfo;
    }

    private ProjectInfo() {
        ZipFile systemMlJar = null;
        try {
            String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            systemMlJar = new JarFile(path);
            Manifest manifest = ((JarFile)systemMlJar).getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            this.properties = new TreeMap<String, String>();
            for (Object key : mainAttributes.keySet()) {
                String value = mainAttributes.getValue((Attributes.Name)key);
                this.properties.put(key.toString(), value);
            }
        }
        catch (Exception e) {
            throw new MLContextException("Error trying to read from manifest in SystemML jar file", e);
        }
        finally {
            if (systemMlJar != null) {
                try {
                    systemMlJar.close();
                }
                catch (IOException e) {
                    throw new MLContextException("Error closing SystemML jar file", e);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<String> keySet = this.properties.keySet();
        for (String key : keySet) {
            sb.append(key + ": " + (String)this.properties.get(key) + "\n");
        }
        return sb.toString();
    }

    public String property(String key) {
        return (String)this.properties.get(key);
    }

    public String version() {
        return this.property("Version");
    }

    public String buildTime() {
        return this.property("Build-Time");
    }

    public String minimumRecommendedSparkVersion() {
        return this.property("Minimum-Recommended-Spark-Version");
    }

    public SortedMap<String, String> properties() {
        return this.properties;
    }
}

