/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.provider.producer.ProducerMeta;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.provider.pojo.RpcSchema;
import org.apache.servicecomb.provider.pojo.schema.PojoProducerMeta;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class PojoProducers
implements BeanPostProcessor {
    private final List<ProducerMeta> producerMetas = new ArrayList<ProducerMeta>();

    public synchronized void registerPojoProducer(PojoProducerMeta pojoProducer) {
        this.producerMetas.add(pojoProducer);
    }

    public List<ProducerMeta> getProducerMetas() {
        return this.producerMetas;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.processProvider(beanName, bean);
        return bean;
    }

    protected void processProvider(String beanName, Object bean) {
        Class beanCls = BeanUtils.getImplClassFromBean((Object)bean);
        if (beanCls == null) {
            return;
        }
        RpcSchema rpcSchema = beanCls.getAnnotation(RpcSchema.class);
        if (rpcSchema == null) {
            return;
        }
        String schemaId = rpcSchema.schemaId();
        if (StringUtils.isEmpty((CharSequence)schemaId)) {
            Class<?>[] intfs = beanCls.getInterfaces();
            if (intfs.length == 1) {
                schemaId = intfs[0].getName();
            } else {
                throw new Error("Must be schemaId or implements only one interface");
            }
        }
        PojoProducerMeta pojoProducerMeta = new PojoProducerMeta();
        pojoProducerMeta.setSchemaId(schemaId);
        pojoProducerMeta.setSchemaInterface(rpcSchema.schemaInterface());
        pojoProducerMeta.setInstance(bean);
        this.registerPojoProducer(pojoProducerMeta);
    }
}

