/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.spring.cloud.zuul.tracing;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.ZuulFilterResult;
import com.netflix.zuul.context.RequestContext;
import java.lang.invoke.MethodHandles;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TracePreZuulFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Tracer tracer;
    private final HttpClientHandler<RequestContext, HttpServletResponse> clientHandler;
    private final TraceContext.Injector<RequestContext> injector;

    TracePreZuulFilter(HttpTracing tracing, HttpClientHandler<RequestContext, HttpServletResponse> clientHandler) {
        this.tracer = tracing.tracing().tracer();
        this.injector = tracing.tracing().propagation().injector((requestContext, name, value) -> requestContext.getZuulRequestHeaders().put(name, value));
        this.clientHandler = clientHandler;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        return null;
    }

    public ZuulFilterResult runFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        Span span = this.clientHandler.handleSend(this.injector, (Object)ctx);
        this.saveHeadersAsInvocationContext(ctx, span);
        Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
        log.debug("Generated tracing span {} for {}", (Object)span, (Object)ctx.getRequest().getMethod());
        ctx.getRequest().setAttribute(Tracer.SpanInScope.class.getName(), (Object)scope);
        ZuulFilterResult result = super.runFilter();
        log.debug("Result of Zuul filter is [{}]", (Object)result.getStatus());
        if (ExecutionStatus.SUCCESS != result.getStatus()) {
            log.debug("The result of Zuul filter execution was not successful thus will close the current span {}", (Object)span);
            this.clientHandler.handleReceive((Object)ctx.getResponse(), result.getException(), span);
            scope.close();
        }
        return result;
    }

    private void saveHeadersAsInvocationContext(RequestContext ctx, Span span) {
        try {
            ctx.addZuulRequestHeader("x-cse-context", JsonUtils.writeValueAsString((Object)ctx.getZuulRequestHeaders()));
        }
        catch (JsonProcessingException e) {
            this.clientHandler.handleReceive((Object)ctx.getResponse(), (Throwable)e, span);
            throw new IllegalStateException("Unable to write request headers as json to x-cse-context", e);
        }
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return Integer.MAX_VALUE;
    }
}

