/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static KeyStore createKeyStore(String storename, String storetype, char[] storevalue) {
        InputStream is = null;
        try {
            KeyStore keystore = KeyStore.getInstance(storetype);
            is = new FileInputStream(storename);
            keystore.load(is, storevalue);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad key store or value." + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    KeyStoreUtil.ignore();
                }
            }
        }
    }

    public static CRL[] createCRL(String crlfile) {
        InputStream is = null;
        try {
            CRL[] crls;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlfile);
            Collection<? extends CRL> c = cf.generateCRLs(is);
            CRL[] cRLArray = crls = c.toArray(new CRL[c.size()]);
            return cRLArray;
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("bad cert file.");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("crl file not found.");
        }
        catch (CRLException e) {
            throw new IllegalArgumentException("bad crl file.");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    KeyStoreUtil.ignore();
                }
            }
        }
    }

    public static KeyManager[] createKeyManagers(KeyStore keystore, char[] keyvalue) {
        try {
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(keystore, keyvalue);
            return kmfactory.getKeyManagers();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad key store." + e.getMessage());
        }
    }

    public static TrustManager[] createTrustManagers(KeyStore keystore) {
        try {
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init(keystore);
            TrustManager[] trustmanagers = tmfactory.getTrustManagers();
            return trustmanagers;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad trust store." + e.getMessage());
        }
    }

    private static void ignore() {
    }
}

