/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.cdi;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ExecutableValidator;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.BValExtension;
import org.apache.bval.jsr.util.ClassHelper;
import org.apache.bval.jsr.util.Proxies;

@Interceptor
@BValBinding
@Priority(value=4800)
public class BValInterceptor
implements Serializable {
    private volatile transient Map<Method, Boolean> methodConfiguration = new ConcurrentHashMap<Method, Boolean>();
    private volatile transient Set<ExecutableType> classConfiguration;
    private volatile transient Boolean constructorValidated;
    @Inject
    private Validator validator;
    @Inject
    private BValExtension globalConfiguration;
    private volatile transient ExecutableValidator executableValidator;

    @AroundConstruct
    public Object construct(InvocationContext context) throws Exception {
        Constructor constructor = context.getConstructor();
        Class targetClass = constructor.getDeclaringClass();
        if (!this.isConstructorValidated(targetClass, constructor)) {
            return context.proceed();
        }
        ConstructorDescriptor constraints = this.validator.getConstraintsForClass(targetClass).getConstraintsForConstructor((Class[])constructor.getParameterTypes());
        if (constraints == null) {
            return context.proceed();
        }
        this.initExecutableValidator();
        Set violations = this.executableValidator.validateConstructorParameters(constructor, context.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        Object result = context.proceed();
        Set violations2 = this.executableValidator.validateConstructorReturnValue(constructor, context.getTarget(), new Class[0]);
        if (!violations2.isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        return result;
    }

    @AroundInvoke
    public Object invoke(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        Class<?> targetClass = Proxies.classFor(context.getTarget().getClass());
        if (!this.isMethodValidated(targetClass, method)) {
            return context.proceed();
        }
        MethodDescriptor constraintsForMethod = this.validator.getConstraintsForClass(targetClass).getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes());
        if (constraintsForMethod == null) {
            return context.proceed();
        }
        this.initExecutableValidator();
        Set violations = this.executableValidator.validateParameters(context.getTarget(), method, context.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        Object result = context.proceed();
        Set violations2 = this.executableValidator.validateReturnValue(context.getTarget(), method, result, new Class[0]);
        if (!violations2.isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConstructorValidated(Class<?> targetClass, Constructor<?> constructor) throws NoSuchMethodException {
        this.initClassConfig(targetClass);
        if (this.constructorValidated == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.constructorValidated == null) {
                    List<ExecutableType> types;
                    ValidateOnExecution annotation;
                    AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(constructor.getDeclaringClass());
                    AnnotatedConstructor annotatedConstructor = null;
                    for (AnnotatedConstructor ac : annotatedType.getConstructors()) {
                        if (!constructor.equals(ac.getJavaMember())) continue;
                        annotatedConstructor = ac;
                        break;
                    }
                    ValidateOnExecution validateOnExecution = annotation = annotatedConstructor != null ? (ValidateOnExecution)annotatedConstructor.getAnnotation(ValidateOnExecution.class) : targetClass.getConstructor(constructor.getParameterTypes()).getAnnotation(ValidateOnExecution.class);
                    this.constructorValidated = annotation == null ? Boolean.valueOf(this.classConfiguration.contains(ExecutableType.CONSTRUCTORS)) : Boolean.valueOf((types = Arrays.asList(annotation.type())).contains(ExecutableType.CONSTRUCTORS) || types.contains(ExecutableType.IMPLICIT) || types.contains(ExecutableType.ALL));
                }
            }
        }
        return this.constructorValidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMethodValidated(Class<?> targetClass, Method method) throws NoSuchMethodException {
        Boolean methodConfig;
        this.initClassConfig(targetClass);
        if (this.methodConfiguration == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.methodConfiguration == null) {
                    this.methodConfiguration = new ConcurrentHashMap<Method, Boolean>();
                }
            }
        }
        if ((methodConfig = this.methodConfiguration.get(method)) == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                methodConfig = this.methodConfiguration.get(method);
                if (methodConfig == null) {
                    List<Class<?>> classHierarchy = ClassHelper.fillFullClassHierarchyAsList(new LinkedList(), targetClass);
                    Collections.reverse(classHierarchy);
                    ValidateOnExecution validateOnExecution = null;
                    ValidateOnExecution validateOnExecutionType = null;
                    for (Class<?> c : classHierarchy) {
                        AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(c);
                        AnnotatedMethod annotatedMethod = null;
                        for (AnnotatedMethod m : annotatedType.getMethods()) {
                            if (!m.getJavaMember().getName().equals(method.getName()) || !((Object)Arrays.asList(method.getGenericParameterTypes())).equals(Arrays.asList(m.getJavaMember().getGenericParameterTypes()))) continue;
                            annotatedMethod = m;
                            break;
                        }
                        try {
                            ValidateOnExecution mvat;
                            ValidateOnExecution vat;
                            if (annotatedMethod == null) continue;
                            if (validateOnExecutionType == null && (vat = (ValidateOnExecution)annotatedType.getAnnotation(ValidateOnExecution.class)) != null) {
                                validateOnExecutionType = vat;
                            }
                            if ((mvat = (ValidateOnExecution)annotatedMethod.getAnnotation(ValidateOnExecution.class)) == null) continue;
                            validateOnExecution = mvat;
                        }
                        catch (Throwable h) {}
                    }
                    boolean classMeta = false;
                    if (validateOnExecution == null) {
                        validateOnExecution = validateOnExecutionType;
                        boolean bl = classMeta = validateOnExecution != null;
                    }
                    if (validateOnExecution == null) {
                        methodConfig = BValInterceptor.doValidMethod(method, this.classConfiguration);
                    } else {
                        EnumSet<ExecutableType> config = EnumSet.noneOf(ExecutableType.class);
                        for (ExecutableType type : validateOnExecution.type()) {
                            if (ExecutableType.NONE == type) continue;
                            if (ExecutableType.ALL == type) {
                                config.add(ExecutableType.NON_GETTER_METHODS);
                                config.add(ExecutableType.GETTER_METHODS);
                                break;
                            }
                            if (ExecutableType.IMPLICIT == type) {
                                config.add(ExecutableType.NON_GETTER_METHODS);
                                if (classMeta) continue;
                                config.add(ExecutableType.GETTER_METHODS);
                                continue;
                            }
                            config.add(type);
                        }
                        methodConfig = BValInterceptor.doValidMethod(method, config);
                    }
                }
                this.methodConfiguration.put(method, methodConfig);
            }
        }
        return methodConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClassConfig(Class<?> targetClass) {
        if (this.classConfiguration == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.classConfiguration == null) {
                    this.classConfiguration = EnumSet.noneOf(ExecutableType.class);
                    AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(targetClass);
                    ValidateOnExecution annotation = (ValidateOnExecution)annotatedType.getAnnotation(ValidateOnExecution.class);
                    if (annotation == null) {
                        this.classConfiguration.addAll(this.globalConfiguration.getGlobalExecutableTypes());
                    } else {
                        for (ExecutableType type : annotation.type()) {
                            if (ExecutableType.NONE == type) continue;
                            if (ExecutableType.ALL == type) {
                                this.classConfiguration.add(ExecutableType.CONSTRUCTORS);
                                this.classConfiguration.add(ExecutableType.NON_GETTER_METHODS);
                                this.classConfiguration.add(ExecutableType.GETTER_METHODS);
                                break;
                            }
                            if (ExecutableType.IMPLICIT == type) {
                                this.classConfiguration.add(ExecutableType.CONSTRUCTORS);
                                this.classConfiguration.add(ExecutableType.NON_GETTER_METHODS);
                                continue;
                            }
                            this.classConfiguration.add(type);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExecutableValidator() {
        if (this.executableValidator == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.executableValidator == null) {
                    this.executableValidator = this.validator.forExecutables();
                }
            }
        }
    }

    private static boolean doValidMethod(Method method, Set<ExecutableType> config) {
        return BValInterceptor.isGetter(method) ? config.contains(ExecutableType.GETTER_METHODS) : config.contains(ExecutableType.NON_GETTER_METHODS);
    }

    private static boolean isGetter(Method method) {
        String name = method.getName();
        return method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType()) && (name.startsWith("get") || name.startsWith("is") && Boolean.TYPE.equals(method.getReturnType()));
    }
}

