/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.meta.Members;

public class MetamodelHelper {
    public static final char DASH = '-';
    public static final char UNDERSCORE = '_';

    public static List<Attribute<?, ?>> getAttributesInOrder(Class<?> cls, Metamodel model) {
        return MetamodelHelper.getAttributesInOrder(model.managedType(cls));
    }

    public static List<Attribute<?, ?>> getAttributesInOrder(ClassMetaData meta, Metamodel model) {
        return MetamodelHelper.getAttributesInOrder(meta.getDescribedType(), model);
    }

    public static List<Attribute<?, ?>> getAttributesInOrder(ManagedType<?> type) {
        ArrayList list = new ArrayList(type.getAttributes());
        Collections.sort(list, new AttributeComparator());
        return list;
    }

    public static boolean isId(Attribute<?, ?> a) {
        if (a instanceof SingularAttribute) {
            return ((SingularAttribute)a).isId();
        }
        return false;
    }

    public static boolean isVersion(Attribute<?, ?> a) {
        if (a instanceof SingularAttribute) {
            return ((SingularAttribute)a).isVersion();
        }
        return false;
    }

    public static boolean isEnum(Attribute<?, ?> a) {
        if (a instanceof Members.Member) {
            int type = ((Members.Member)a).fmd.getDeclaredTypeCode();
            return type == 32;
        }
        return false;
    }

    public static boolean isLob(Attribute<?, ?> a) {
        if (a instanceof Members.Member) {
            int type = ((Members.Member)a).fmd.getDeclaredTypeCode();
            return type == 31 || type == 30;
        }
        return false;
    }

    public static AttributeCategory getAttributeCategory(Attribute<?, ?> attr) {
        if (MetamodelHelper.isId(attr)) {
            return AttributeCategory.ID;
        }
        if (MetamodelHelper.isVersion(attr)) {
            return AttributeCategory.VERSION;
        }
        if (MetamodelHelper.isLob(attr)) {
            return AttributeCategory.LOB;
        }
        if (MetamodelHelper.isEnum(attr)) {
            return AttributeCategory.ENUM;
        }
        switch (attr.getPersistentAttributeType()) {
            case BASIC: {
                return AttributeCategory.BASIC;
            }
            case EMBEDDED: {
                return AttributeCategory.EMBEDDED;
            }
            case ONE_TO_ONE: {
                return AttributeCategory.ONE_TO_ONE;
            }
            case MANY_TO_ONE: {
                return AttributeCategory.MANY_TO_ONE;
            }
            case ONE_TO_MANY: 
            case ELEMENT_COLLECTION: {
                return AttributeCategory.ONE_TO_MANY;
            }
            case MANY_TO_MANY: {
                return AttributeCategory.MANY_TO_MANY;
            }
        }
        throw new RuntimeException(attr.toString());
    }

    public static String getTagByAttributeType(Attribute<?, ?> attr) {
        return MetamodelHelper.getAttributeCategory(attr).name().replace('_', '-').toLowerCase();
    }

    public static String getAttributeTypeName(Attribute<?, ?> attr) {
        StringBuilder name = new StringBuilder(attr.getJavaType().getSimpleName());
        switch (attr.getPersistentAttributeType()) {
            case ONE_TO_MANY: 
            case ELEMENT_COLLECTION: {
                name.append("&lt;").append(((PluralAttribute)attr).getBindableJavaType().getSimpleName()).append("&gt;");
                break;
            }
            case MANY_TO_MANY: {
                name.append("&lt;").append(((MapAttribute)attr).getKeyJavaType().getSimpleName()).append(',').append(((MapAttribute)attr).getBindableJavaType().getSimpleName()).append("&gt;");
                break;
            }
        }
        return name.toString();
    }

    public static class AttributeComparator
    implements Comparator<Attribute<?, ?>> {
        @Override
        public int compare(Attribute<?, ?> a1, Attribute<?, ?> a2) {
            AttributeCategory t2;
            AttributeCategory t1 = MetamodelHelper.getAttributeCategory(a1);
            if (t1.equals((Object)(t2 = MetamodelHelper.getAttributeCategory(a2)))) {
                return a1.getName().compareTo(a2.getName());
            }
            return t1.compareTo(t2);
        }
    }

    public static enum AttributeCategory {
        ID,
        VERSION,
        BASIC,
        ENUM,
        EMBEDDED,
        LOB,
        ONE_TO_ONE,
        MANY_TO_ONE,
        ONE_TO_MANY,
        ELEMENT_COLLECTION,
        MANY_TO_MANY;

    }
}

