/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.FlushModeType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.LockModeType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.QueryHint;
import javax.persistence.SequenceGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.BeanLifecycleCallbacks;
import org.apache.openjpa.event.LifecycleCallbacks;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.MethodLifecycleCallbacks;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.DelegatingMetaDataFactory;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.LifecycleMetaData;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataModes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.DataStoreId;
import org.apache.openjpa.persistence.Dependent;
import org.apache.openjpa.persistence.DetachedState;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.ElementType;
import org.apache.openjpa.persistence.ExternalValues;
import org.apache.openjpa.persistence.Externalizer;
import org.apache.openjpa.persistence.Factory;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.InverseLogical;
import org.apache.openjpa.persistence.KeyDependent;
import org.apache.openjpa.persistence.KeyType;
import org.apache.openjpa.persistence.LRS;
import org.apache.openjpa.persistence.LoadFetchGroup;
import org.apache.openjpa.persistence.ManagedInterface;
import org.apache.openjpa.persistence.MetaDataParsers;
import org.apache.openjpa.persistence.MetaDataTag;
import org.apache.openjpa.persistence.PersistenceMetaDataDefaults;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.persistence.Persistent;
import org.apache.openjpa.persistence.PersistentCollection;
import org.apache.openjpa.persistence.PersistentMap;
import org.apache.openjpa.persistence.ReadOnly;
import org.apache.openjpa.persistence.Type;
import org.apache.openjpa.persistence.UpdateAction;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public class AnnotationPersistenceMetaDataParser
implements MetaDataModes {
    private static final Localizer _loc = Localizer.forPackage(AnnotationPersistenceMetaDataParser.class);
    private static final Map<Class<?>, MetaDataTag> _tags = new HashMap();
    private final OpenJPAConfiguration _conf;
    private final Log _log;
    private MetaDataRepository _repos = null;
    private ClassLoader _envLoader = null;
    private boolean _override = false;
    private int _mode = 0;
    private final Map<Package, Integer> _pkgs = new HashMap<Package, Integer>();
    protected Class<?> _cls = null;
    protected Stack<Class<?>> _stack = new Stack();
    private File _file = null;

    public AnnotationPersistenceMetaDataParser(OpenJPAConfiguration conf) {
        this._conf = conf;
        this._log = conf.getLog("openjpa.MetaData");
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public Log getLog() {
        return this._log;
    }

    public MetaDataRepository getRepository() {
        if (this._repos == null) {
            MetaDataRepository repos = this._conf.newMetaDataRepositoryInstance();
            MetaDataFactory mdf = repos.getMetaDataFactory();
            if (mdf instanceof DelegatingMetaDataFactory) {
                mdf = ((DelegatingMetaDataFactory)mdf).getInnermostDelegate();
            }
            if (mdf instanceof PersistenceMetaDataFactory) {
                ((PersistenceMetaDataFactory)mdf).setAnnotationParser(this);
            }
            this._repos = repos;
        }
        return this._repos;
    }

    public void setRepository(MetaDataRepository repos) {
        this._repos = repos;
    }

    public ClassLoader getEnvClassLoader() {
        return this._envLoader;
    }

    public void setEnvClassLoader(ClassLoader loader) {
        this._envLoader = loader;
    }

    public boolean getMappingOverride() {
        return this._override;
    }

    public void setMappingOverride(boolean override) {
        this._override = override;
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int mode, boolean on) {
        this._mode = mode == 0 ? 0 : (on ? (this._mode |= mode) : (this._mode &= ~mode));
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    protected boolean isMetaDataMode() {
        return (this._mode & 1) != 0;
    }

    protected boolean isQueryMode() {
        return (this._mode & 4) != 0;
    }

    protected boolean isMappingMode() {
        return (this._mode & 2) != 0;
    }

    protected boolean isMappingOverrideMode() {
        return this.isMappingMode() || this._override && this.isMetaDataMode();
    }

    public void clear() {
        this._stack.clear();
        this._cls = null;
        this._file = null;
        this._pkgs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Class<?> cls) {
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("parse-class", cls.getName()));
        }
        this._cls = cls;
        this._stack.push(cls);
        try {
            this.parsePackageAnnotations();
            ClassMetaData meta = this.parseClassAnnotations();
            this.updateSourceMode(meta);
            this._stack.pop();
        }
        catch (Throwable throwable) {
            this._stack.pop();
            this._cls = this._stack.isEmpty() ? null : this._stack.peek();
            this._file = null;
            throw throwable;
        }
        this._cls = this._stack.isEmpty() ? null : this._stack.peek();
        this._file = null;
    }

    private void updateSourceMode(ClassMetaData meta) {
        if (this._cls.getPackage() != null) {
            this.addSourceMode(this._cls.getPackage(), this._mode);
        }
        if (meta != null) {
            meta.setSourceMode(this._mode, true);
        }
    }

    private void parsePackageAnnotations() {
        Package pkg = this._cls.getPackage();
        if (pkg == null) {
            return;
        }
        int pkgMode = this.getSourceMode(pkg);
        if (pkgMode == 0 && this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("parse-package", this._cls.getName()));
        }
        if ((pkgMode & this._mode) == this._mode) {
            return;
        }
        block7: for (Annotation anno : pkg.getDeclaredAnnotations()) {
            MetaDataTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownPackageAnnotation(pkg, anno);
                continue;
            }
            switch (tag) {
                case NATIVE_QUERIES: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedNativeQueries(pkg, ((NamedNativeQueries)anno).value());
                    continue block7;
                }
                case NATIVE_QUERY: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedNativeQueries(pkg, (NamedNativeQuery)anno);
                    continue block7;
                }
                case QUERIES: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedQueries(pkg, ((NamedQueries)anno).value());
                    continue block7;
                }
                case QUERY: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedQueries(pkg, (NamedQuery)anno);
                    continue block7;
                }
                case SEQ_GENERATOR: {
                    if (!this.isMappingOverrideMode() || (pkgMode & 2) != 0) continue block7;
                    this.parseSequenceGenerator(pkg, (SequenceGenerator)anno);
                    continue block7;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", pkg, ((Object)anno).toString()));
                }
            }
        }
        if (this.isMappingOverrideMode() && (pkgMode & 2) == 0) {
            this.parsePackageMappingAnnotations(pkg);
        }
    }

    protected void parsePackageMappingAnnotations(Package pkg) {
    }

    protected boolean handleUnknownPackageAnnotation(Package pkg, Annotation anno) {
        return false;
    }

    private int getSourceMode(Package pkg) {
        Number num = this._pkgs.get(pkg);
        return num == null ? 0 : num.intValue();
    }

    private void addSourceMode(Package pkg, int mode) {
        Integer num = this._pkgs.get(pkg);
        num = num == null ? Integer.valueOf(mode) : Integer.valueOf(num | mode);
        this._pkgs.put(pkg, num);
    }

    private ClassMetaData parseClassAnnotations() {
        ClassMetaData meta;
        ClassMetaData m = this.getRepository().getCachedMetaData(this._cls);
        if (!(m != null || AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(this._cls, Entity.class)).booleanValue() || AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(this._cls, Embeddable.class)).booleanValue() || AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(this._cls, MappedSuperclass.class)).booleanValue())) {
            return null;
        }
        ClassMetaData classMetaData = meta = m == null ? this.getMetaData() : m;
        if (meta == null) {
            return null;
        }
        Entity entity = this._cls.getAnnotation(Entity.class);
        MappedSuperclass mapped = this._cls.getAnnotation(MappedSuperclass.class);
        Embeddable embeddable = this._cls.getAnnotation(Embeddable.class);
        if (this.isMetaDataMode()) {
            meta.setAbstract(mapped != null);
            if (embeddable != null) {
                meta.setEmbeddable();
            }
            if (entity == null) {
                meta.setEmbeddedOnly(true);
            } else {
                meta.setEmbeddedOnly(false);
                if (!StringUtils.isEmpty((String)entity.name())) {
                    meta.setTypeAlias(entity.name());
                }
            }
        }
        FetchGroup[] fgs = null;
        DetachedState detached = null;
        Collection<LifecycleCallbacks>[] listeners = null;
        block20: for (Annotation annotation : this._cls.getDeclaredAnnotations()) {
            MetaDataTag tag = _tags.get(annotation.annotationType());
            if (tag == null) {
                this.handleUnknownClassAnnotation(meta, annotation);
                continue;
            }
            switch (tag) {
                case ENTITY_LISTENERS: {
                    if (!this.isMetaDataMode()) continue block20;
                    listeners = this.parseEntityListeners(meta, (EntityListeners)annotation);
                    continue block20;
                }
                case EXCLUDE_DEFAULT_LISTENERS: {
                    if (!this.isMetaDataMode()) continue block20;
                    meta.getLifecycleMetaData().setIgnoreSystemListeners(true);
                    continue block20;
                }
                case EXCLUDE_SUPERCLASS_LISTENERS: {
                    if (!this.isMetaDataMode()) continue block20;
                    meta.getLifecycleMetaData().setIgnoreSuperclassCallbacks(2);
                    continue block20;
                }
                case FLUSH_MODE: {
                    if (!this.isMetaDataMode()) continue block20;
                    this.warnFlushMode(meta);
                    continue block20;
                }
                case ID_CLASS: {
                    if (!this.isMetaDataMode()) continue block20;
                    meta.setObjectIdType(((IdClass)annotation).value(), true);
                    continue block20;
                }
                case NATIVE_QUERIES: {
                    if (!this.isQueryMode() || (meta.getSourceMode() & 4) != 0) continue block20;
                    this.parseNamedNativeQueries(this._cls, ((NamedNativeQueries)annotation).value());
                    continue block20;
                }
                case NATIVE_QUERY: {
                    if (!this.isQueryMode() || (meta.getSourceMode() & 4) != 0) continue block20;
                    this.parseNamedNativeQueries(this._cls, (NamedNativeQuery)annotation);
                    continue block20;
                }
                case QUERIES: {
                    if (!this.isQueryMode() || (meta.getSourceMode() & 4) != 0) continue block20;
                    this.parseNamedQueries(this._cls, ((NamedQueries)annotation).value());
                    continue block20;
                }
                case QUERY: {
                    if (!this.isQueryMode() || (meta.getSourceMode() & 4) != 0) continue block20;
                    this.parseNamedQueries(this._cls, (NamedQuery)annotation);
                    continue block20;
                }
                case SEQ_GENERATOR: {
                    if (!this.isMappingOverrideMode()) continue block20;
                    this.parseSequenceGenerator(this._cls, (SequenceGenerator)annotation);
                    continue block20;
                }
                case DATA_CACHE: {
                    if (!this.isMetaDataMode()) continue block20;
                    this.parseDataCache(meta, (DataCache)annotation);
                    continue block20;
                }
                case DATASTORE_ID: {
                    if (!this.isMetaDataMode()) continue block20;
                    this.parseDataStoreId(meta, (DataStoreId)annotation);
                    continue block20;
                }
                case DETACHED_STATE: {
                    detached = (DetachedState)annotation;
                    continue block20;
                }
                case FETCH_GROUP: {
                    if (!this.isMetaDataMode()) continue block20;
                    fgs = new FetchGroup[]{(FetchGroup)annotation};
                    continue block20;
                }
                case FETCH_GROUPS: {
                    if (!this.isMetaDataMode()) continue block20;
                    fgs = ((FetchGroups)annotation).value();
                    continue block20;
                }
                case MANAGED_INTERFACE: {
                    if (!this.isMetaDataMode()) continue block20;
                    this.parseManagedInterface(meta, (ManagedInterface)annotation);
                    continue block20;
                }
                case ACCESS: {
                    if (!this.isMetaDataMode()) continue block20;
                    this.parseAccess(meta, (Access)annotation);
                    continue block20;
                }
                case CACHEABLE: {
                    if (!this.isMetaDataMode()) continue block20;
                    this.parseCache(meta, (Cacheable)annotation);
                    continue block20;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", this._cls, ((Object)annotation).toString()));
                }
            }
        }
        if (this.isMetaDataMode()) {
            this.parseDetachedState(meta, detached);
            int[] highs = null;
            if (listeners != null) {
                highs = new int[listeners.length];
                for (int i = 0; i < listeners.length; ++i) {
                    if (listeners[i] == null) continue;
                    highs[i] = listeners[i].size();
                }
            }
            this.recordCallbacks(meta, AnnotationPersistenceMetaDataParser.parseCallbackMethods(this._cls, listeners, false, false, this.getRepository()), highs, false);
            if (this._cls.getSuperclass() != null && !Object.class.equals(this._cls.getSuperclass())) {
                this.recordCallbacks(meta, AnnotationPersistenceMetaDataParser.parseCallbackMethods(this._cls.getSuperclass(), null, true, false, this.getRepository()), null, true);
            }
        }
        for (FieldMetaData fieldMetaData : meta.getDeclaredFields()) {
            if (fieldMetaData.getManagement() != 3) continue;
            this.parseMemberAnnotations(fieldMetaData);
        }
        if (fgs != null) {
            AnnotationPersistenceMetaDataParser.parseFetchGroups(meta, fgs);
        }
        if (this.isMappingOverrideMode()) {
            this.parseClassMappingAnnotations(meta);
            for (FieldMetaData fieldMetaData : meta.getDeclaredFields()) {
                if (fieldMetaData.getManagement() != 3) continue;
                this.parseMemberMappingAnnotations(fieldMetaData);
            }
        }
        return meta;
    }

    private void parseAccess(ClassMetaData meta, Access access) {
        if (access != null) {
            meta.setAccessType(AccessCode.EXPLICIT | (access.value() == AccessType.FIELD ? AccessCode.FIELD : AccessCode.PROPERTY));
        }
    }

    protected void parseClassMappingAnnotations(ClassMetaData meta) {
    }

    protected boolean handleUnknownClassAnnotation(ClassMetaData meta, Annotation anno) {
        return false;
    }

    private ClassMetaData getMetaData() {
        ClassMetaData meta = this.getRepository().getCachedMetaData(this._cls);
        if (meta != null && (this.isMetaDataMode() && (meta.getSourceMode() & 1) != 0 || this.isMappingMode() && (meta.getSourceMode() & 2) != 0)) {
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("dup-metadata", this._cls.getName()));
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace(String.format("MetaData originally obtained from file: %s under mode :%d with scope %s, and type :%d", meta.getSourceName(), meta.getSourceMode(), meta.getSourceScope(), meta.getSourceType()));
            }
            return null;
        }
        if (meta == null) {
            meta = this.getRepository().addMetaData(this._cls, this.getAccessCode(this._cls));
            meta.setEnvClassLoader(this._envLoader);
            meta.setSourceMode(0);
            meta.setSource(this.getSourceFile(), 1, this.getSourceFile() == null ? "" : this.getSourceFile().getPath());
        }
        return meta;
    }

    private int getAccessCode(Class<?> cls) {
        int accessCode = AccessCode.UNKNOWN;
        Access access = AccessController.doPrivileged(J2DoPrivHelper.getAnnotationAction(cls, Access.class));
        if (access != null) {
            accessCode |= AccessCode.EXPLICIT | (access.value() == AccessType.FIELD ? AccessCode.FIELD : AccessCode.PROPERTY);
        }
        return accessCode;
    }

    protected File getSourceFile() {
        if (this._file != null) {
            return this._file;
        }
        Class<?> cls = this._cls;
        while (cls.getEnclosingClass() != null) {
            cls = cls.getEnclosingClass();
        }
        String rsrc = StringUtils.replace((String)cls.getName(), (String)".", (String)"/");
        ClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(cls));
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getSystemClassLoaderAction());
        }
        if (loader == null) {
            return null;
        }
        URL url = AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(loader, rsrc + ".java"));
        if (url == null && (url = AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(loader, rsrc + ".class"))) == null) {
            return null;
        }
        try {
            this._file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        return this._file;
    }

    private void parseDataStoreId(ClassMetaData meta, DataStoreId id) {
        AnnotationPersistenceMetaDataParser.parseDataStoreId(meta, id.strategy(), id.generator());
    }

    static void parseDataStoreId(ClassMetaData meta, GenerationType strategy, String generator) {
        meta.setIdentityType(1);
        int strat = AnnotationPersistenceMetaDataParser.getGeneratedValueStrategy(meta, strategy, generator);
        if (strat != -1) {
            meta.setIdentityStrategy(strat);
        } else {
            switch (strategy) {
                case TABLE: 
                case SEQUENCE: {
                    if (StringUtils.isEmpty((String)generator)) {
                        meta.setIdentitySequenceName("system");
                        break;
                    }
                    meta.setIdentitySequenceName(generator);
                    break;
                }
                case AUTO: {
                    meta.setIdentityStrategy(1);
                    break;
                }
                case IDENTITY: {
                    meta.setIdentityStrategy(3);
                    break;
                }
                default: {
                    throw new UnsupportedException(strategy.toString());
                }
            }
        }
    }

    private void warnFlushMode(Object context) {
        if (this._log.isWarnEnabled()) {
            this._log.warn(_loc.get("unsupported", "FlushMode", context));
        }
    }

    private void parseDataCache(ClassMetaData meta, DataCache cache) {
        AnnotationPersistenceMetaDataParser.parseDataCache(meta, cache.enabled(), cache.name(), cache.timeout());
    }

    static void parseDataCache(ClassMetaData meta, boolean enabled, String name, int timeout) {
        String cacheName;
        if (timeout != Integer.MIN_VALUE) {
            meta.setDataCacheTimeout(timeout);
        }
        if (StringUtils.isEmpty((String)(cacheName = name))) {
            cacheName = "default";
        }
        meta.setDataCacheName(enabled ? cacheName : null);
    }

    private void parseManagedInterface(ClassMetaData meta, ManagedInterface iface) {
        meta.setManagedInterface(true);
    }

    private void parseDetachedState(ClassMetaData meta, DetachedState detached) {
        if (detached != null) {
            if (!detached.enabled()) {
                meta.setDetachedState(null);
            } else if (StringUtils.isEmpty((String)detached.fieldName())) {
                meta.setDetachedState("`syn");
            } else {
                meta.setDetachedState(detached.fieldName());
            }
        } else {
            Field[] fields = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction(meta.getDescribedType()));
            for (int i = 0; i < fields.length; ++i) {
                if (!AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(fields[i], DetachedState.class)).booleanValue()) continue;
                meta.setDetachedState(fields[i].getName());
            }
        }
    }

    private Collection<LifecycleCallbacks>[] parseEntityListeners(ClassMetaData meta, EntityListeners listeners) {
        Class[] classes = listeners.value();
        ArrayList<Class> listenerColl = null;
        Collection<LifecycleCallbacks>[] parsed = null;
        for (Class cls : classes) {
            if (!this._conf.getCallbackOptionsInstance().getAllowsDuplicateListener()) {
                if (listenerColl == null) {
                    listenerColl = new ArrayList<Class>();
                }
                if (listenerColl.contains(cls)) continue;
                listenerColl.add(cls);
            }
            parsed = AnnotationPersistenceMetaDataParser.parseCallbackMethods(cls, parsed, true, true, this.getRepository());
        }
        return parsed;
    }

    public static Collection<LifecycleCallbacks>[] parseCallbackMethods(Class<?> cls, Collection<LifecycleCallbacks>[] callbacks, boolean sups, boolean listener, MetaDataRepository repos) {
        if (cls == null) {
            throw new IllegalArgumentException("cls cannot be null");
        }
        TreeSet<Method> methods = new TreeSet<Method>(MethodComparator.getInstance());
        Class<?> sup = cls;
        HashSet<MethodKey> seen = new HashSet<MethodKey>();
        do {
            for (Method m : AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction(sup))) {
                MethodKey key;
                int mods = m.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || Object.class.equals(m.getDeclaringClass()) || seen.contains(key = new MethodKey(m))) continue;
                methods.add(m);
                seen.add(key);
            }
            sup = sup.getSuperclass();
        } while (sups && !Object.class.equals(sup));
        OpenJPAConfiguration conf = repos.getConfiguration();
        for (Method m : methods) {
            for (Annotation anno : AccessController.doPrivileged(J2DoPrivHelper.getDeclaredAnnotationsAction(m))) {
                int[] events;
                MetaDataTag tag = _tags.get(anno.annotationType());
                if (tag == null || (events = MetaDataParsers.getEventTypes(tag, conf)) == null) continue;
                if (callbacks == null) {
                    callbacks = new Collection[LifecycleEvent.ALL_EVENTS.length];
                }
                for (int i = 0; i < events.length; ++i) {
                    int e = events[i];
                    if (callbacks[e] == null) {
                        callbacks[e] = new ArrayList<LifecycleCallbacks>(3);
                    }
                    MetaDataParsers.validateMethodsForSameCallback(cls, callbacks[e], m, tag, conf, repos.getLog());
                    if (listener) {
                        callbacks[e].add(new BeanLifecycleCallbacks(cls, m, false));
                        continue;
                    }
                    callbacks[e].add(new MethodLifecycleCallbacks(m, false));
                }
            }
        }
        return callbacks;
    }

    private void recordCallbacks(ClassMetaData cls, Collection<LifecycleCallbacks>[] callbacks, int[] highs, boolean superClass) {
        if (callbacks == null) {
            return;
        }
        LifecycleMetaData meta = cls.getLifecycleMetaData();
        for (int event : LifecycleEvent.ALL_EVENTS) {
            if (callbacks[event] == null) continue;
            LifecycleCallbacks[] array = callbacks[event].toArray(new LifecycleCallbacks[callbacks[event].size()]);
            if (superClass) {
                meta.setNonPCSuperclassCallbacks(event, array, highs == null ? 0 : highs[event]);
                continue;
            }
            meta.setDeclaredCallbacks(event, array, highs == null ? 0 : highs[event]);
        }
    }

    static void parseFetchGroups(ClassMetaData meta, FetchGroup ... groups) {
        FetchGroupImpl[] fetchGroupImpls = new FetchGroupImpl[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            FetchAttribute[] fetchAttributes = groups[i].attributes();
            FetchAttributeImpl[] fetchAttributeImpls = null;
            if (fetchAttributes != null && fetchAttributes.length > 0) {
                fetchAttributeImpls = new FetchAttributeImpl[fetchAttributes.length];
                for (int j = 0; j < fetchAttributes.length; ++j) {
                    fetchAttributeImpls[j] = new FetchAttributeImpl(fetchAttributes[j].name(), fetchAttributes[j].recursionDepth());
                }
            }
            fetchGroupImpls[i] = new FetchGroupImpl(groups[i].name(), groups[i].postLoad());
            if (fetchAttributeImpls != null) {
                fetchGroupImpls[i].setAttributes(fetchAttributeImpls);
            }
            if (groups[i].fetchGroups() == null) continue;
            fetchGroupImpls[i].setFetchGroups(groups[i].fetchGroups());
        }
        AnnotationPersistenceMetaDataParser.parseFetchGroups(meta, fetchGroupImpls);
    }

    static void parseFetchGroups(ClassMetaData meta, FetchGroupImpl ... groups) {
        org.apache.openjpa.meta.FetchGroup fg;
        for (FetchGroupImpl group : groups) {
            if (StringUtils.isEmpty((String)group.name())) {
                throw new MetaDataException(_loc.get("unnamed-fg", meta));
            }
            fg = meta.addDeclaredFetchGroup(group.name());
            if (group.postLoad()) {
                fg.setPostLoad(true);
            }
            for (String s : group.fetchGroups()) {
                fg.addDeclaredInclude(s);
            }
        }
        for (FetchGroupImpl group : groups) {
            String[] includedFetchGropNames;
            fg = meta.getFetchGroup(group.name());
            for (String includedFectchGroupName : includedFetchGropNames = fg.getDeclaredIncludes()) {
                org.apache.openjpa.meta.FetchGroup child = meta.getFetchGroup(includedFectchGroupName);
                if (child == null) {
                    throw new UserException(_loc.get("missing-included-fg", meta.getDescribedType().getName(), fg.getName(), includedFectchGroupName));
                }
                child.addContainedBy(fg);
            }
        }
        for (FetchGroupImpl group : groups) {
            fg = meta.getFetchGroup(group.name());
            for (FetchAttributeImpl attr : group.attributes()) {
                AnnotationPersistenceMetaDataParser.parseFetchAttribute(meta, fg, attr);
            }
        }
    }

    private static void parseFetchAttribute(ClassMetaData meta, org.apache.openjpa.meta.FetchGroup fg, FetchAttributeImpl attr) {
        FieldMetaData field = meta.getDeclaredField(attr.name());
        if (field == null || field.getManagement() != 3) {
            throw new MetaDataException(_loc.get("bad-fg-field", fg.getName(), meta, attr.name()));
        }
        field.setInFetchGroup(fg.getName(), true);
        Set<String> parentFetchGroups = fg.getContainedBy();
        for (String parentFetchGroup : parentFetchGroups) {
            field.setInFetchGroup(parentFetchGroup.toString(), true);
        }
        if (attr.recursionDepth() != Integer.MIN_VALUE) {
            fg.setRecursionDepth(field, attr.recursionDepth());
        }
    }

    private void parseMemberAnnotations(FieldMetaData fmd) {
        Member member = this.getRepository().getMetaDataFactory().getDefaults().getBackingMember(fmd);
        PersistenceStrategy pstrat = PersistenceMetaDataDefaults.getPersistenceStrategy(fmd, member);
        if (pstrat == null) {
            return;
        }
        fmd.setExplicit(true);
        AnnotatedElement el = (AnnotatedElement)((Object)member);
        boolean lob = AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(el, Lob.class));
        if (this.isMetaDataMode()) {
            switch (pstrat) {
                case BASIC: {
                    this.parseBasic(fmd, el.getAnnotation(Basic.class), lob);
                    break;
                }
                case MANY_ONE: {
                    this.parseManyToOne(fmd, el.getAnnotation(ManyToOne.class));
                    break;
                }
                case ONE_ONE: {
                    this.parseOneToOne(fmd, el.getAnnotation(OneToOne.class));
                    break;
                }
                case EMBEDDED: {
                    this.parseEmbedded(fmd, el.getAnnotation(Embedded.class));
                    break;
                }
                case ONE_MANY: {
                    this.parseOneToMany(fmd, el.getAnnotation(OneToMany.class));
                    break;
                }
                case MANY_MANY: {
                    this.parseManyToMany(fmd, el.getAnnotation(ManyToMany.class));
                    break;
                }
                case PERS: {
                    this.parsePersistent(fmd, el.getAnnotation(Persistent.class));
                    break;
                }
                case PERS_COLL: {
                    this.parsePersistentCollection(fmd, el.getAnnotation(PersistentCollection.class));
                    break;
                }
                case ELEM_COLL: {
                    this.parseElementCollection(fmd, el.getAnnotation(ElementCollection.class));
                    break;
                }
                case PERS_MAP: {
                    this.parsePersistentMap(fmd, el.getAnnotation(PersistentMap.class));
                    break;
                }
                case TRANSIENT: {
                    break;
                }
                default: {
                    throw new InternalException();
                }
            }
        }
        if (this.isMappingOverrideMode() && lob) {
            this.parseLobMapping(fmd);
        }
        block38: for (Annotation anno : el.getDeclaredAnnotations()) {
            MetaDataTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownMemberAnnotation(fmd, anno);
                continue;
            }
            switch (tag) {
                case ACCESS: {
                    this.parseAccess(fmd, (Access)anno);
                    continue block38;
                }
                case FLUSH_MODE: {
                    if (!this.isMetaDataMode()) continue block38;
                    this.warnFlushMode(fmd);
                    continue block38;
                }
                case GENERATED_VALUE: {
                    if (!this.isMappingOverrideMode()) continue block38;
                    this.parseGeneratedValue(fmd, (GeneratedValue)anno);
                    continue block38;
                }
                case ID: 
                case EMBEDDED_ID: {
                    fmd.setPrimaryKey(true);
                    continue block38;
                }
                case MAPPED_BY_ID: {
                    this.parseMapsId(fmd, (MapsId)anno);
                    continue block38;
                }
                case MAP_KEY: {
                    if (!this.isMappingOverrideMode()) continue block38;
                    this.parseMapKey(fmd, (MapKey)anno);
                    continue block38;
                }
                case MAP_KEY_CLASS: {
                    if (!this.isMappingOverrideMode()) continue block38;
                    this.parseMapKeyClass(fmd, (MapKeyClass)anno);
                    continue block38;
                }
                case ORDER_BY: {
                    this.parseOrderBy(fmd, el.getAnnotation(OrderBy.class));
                    continue block38;
                }
                case SEQ_GENERATOR: {
                    if (!this.isMappingOverrideMode()) continue block38;
                    this.parseSequenceGenerator(el, (SequenceGenerator)anno);
                    continue block38;
                }
                case VERSION: {
                    fmd.setVersion(true);
                    continue block38;
                }
                case DEPENDENT: {
                    if (!this.isMetaDataMode() || !((Dependent)anno).value()) continue block38;
                    fmd.setCascadeDelete(2);
                    continue block38;
                }
                case ELEM_DEPENDENT: {
                    if (!this.isMetaDataMode() || !((ElementDependent)anno).value()) continue block38;
                    fmd.getElement().setCascadeDelete(2);
                    continue block38;
                }
                case ELEM_TYPE: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.getElement().setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(((ElementType)anno).value()));
                    continue block38;
                }
                case EXTERNAL_VALS: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.setExternalValues(Strings.join((Object[])((ExternalValues)anno).value(), (String)","));
                    continue block38;
                }
                case EXTERNALIZER: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.setExternalizer(((Externalizer)anno).value());
                    continue block38;
                }
                case FACTORY: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.setFactory(((Factory)anno).value());
                    continue block38;
                }
                case INVERSE_LOGICAL: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.setInverse(((InverseLogical)anno).value());
                    continue block38;
                }
                case KEY_DEPENDENT: {
                    if (!this.isMetaDataMode() || !((KeyDependent)anno).value()) continue block38;
                    fmd.getKey().setCascadeDelete(2);
                    continue block38;
                }
                case KEY_TYPE: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.getKey().setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(((KeyType)anno).value()));
                    continue block38;
                }
                case LOAD_FETCH_GROUP: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.setLoadFetchGroup(((LoadFetchGroup)anno).value());
                    continue block38;
                }
                case LRS: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.setLRS(((LRS)anno).value());
                    continue block38;
                }
                case READ_ONLY: {
                    if (!this.isMetaDataMode()) continue block38;
                    this.parseReadOnly(fmd, (ReadOnly)anno);
                    continue block38;
                }
                case TYPE: {
                    if (!this.isMetaDataMode()) continue block38;
                    fmd.setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(((Type)anno).value()));
                    continue block38;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", fmd, ((Object)anno).toString()));
                }
            }
        }
    }

    protected void parseMemberMappingAnnotations(FieldMetaData fmd) {
    }

    private void parseCache(ClassMetaData meta, Cacheable cacheable) {
        meta.setCacheEnabled(cacheable.value());
    }

    protected boolean handleUnknownMemberAnnotation(FieldMetaData fmd, Annotation anno) {
        return false;
    }

    public static Class<?> toOverrideType(Class<?> cls) {
        return cls == Entity.class ? PersistenceCapable.class : cls;
    }

    private void parseReadOnly(FieldMetaData fmd, ReadOnly ro) {
        if (ro.value() == UpdateAction.RESTRICT) {
            fmd.setUpdateStrategy(2);
        } else if (ro.value() == UpdateAction.IGNORE) {
            fmd.setUpdateStrategy(1);
        } else {
            throw new InternalException();
        }
    }

    private void parseGeneratedValue(FieldMetaData fmd, GeneratedValue gen) {
        GenerationType strategy = gen.strategy();
        String generator = gen.generator();
        AnnotationPersistenceMetaDataParser.parseGeneratedValue(fmd, strategy, generator);
    }

    static void parseGeneratedValue(FieldMetaData fmd, GenerationType strategy, String generator) {
        int strat = AnnotationPersistenceMetaDataParser.getGeneratedValueStrategy(fmd, strategy, generator);
        if (strat != -1) {
            fmd.setValueStrategy(strat);
        } else {
            switch (strategy) {
                case TABLE: 
                case SEQUENCE: {
                    if (StringUtils.isEmpty((String)generator)) {
                        fmd.setValueSequenceName("system");
                        break;
                    }
                    fmd.setValueSequenceName(generator);
                    break;
                }
                case AUTO: {
                    fmd.setValueSequenceName("system");
                    break;
                }
                case IDENTITY: {
                    fmd.setValueStrategy(3);
                    break;
                }
                default: {
                    throw new UnsupportedException(strategy.toString());
                }
            }
        }
    }

    private static int getGeneratedValueStrategy(Object context, GenerationType strategy, String generator) {
        if (strategy != GenerationType.AUTO || StringUtils.isEmpty((String)generator)) {
            return -1;
        }
        if ("uuid-hex".equals(generator)) {
            return 6;
        }
        if ("uuid-string".equals(generator)) {
            return 5;
        }
        if ("uuid-type4-hex".equals(generator)) {
            return 8;
        }
        if ("uuid-type4-string".equals(generator)) {
            return 7;
        }
        throw new MetaDataException(_loc.get("generator-bad-strategy", context, generator));
    }

    private void parseBasic(FieldMetaData fmd, Basic anno, boolean lob) {
        Class type = fmd.getDeclaredType();
        if (lob && type != String.class && type != char[].class && type != Character[].class && type != byte[].class && type != Byte[].class) {
            fmd.setSerialized(true);
        } else if (!lob) {
            switch (fmd.getDeclaredTypeCode()) {
                case 8: {
                    if (Enum.class.isAssignableFrom(type)) break;
                }
                case 12: 
                case 13: 
                case 15: 
                case 27: {
                    if (Serializable.class.isAssignableFrom(type)) {
                        fmd.setSerialized(true);
                        break;
                    }
                    throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "Basic"));
                }
                case 11: {
                    if (type == char[].class || type == Character[].class || type == byte[].class || type == Byte[].class) break;
                    if (Serializable.class.isAssignableFrom(type.getComponentType())) {
                        fmd.setSerialized(true);
                        break;
                    }
                    throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "Basic"));
                }
            }
        }
        if (anno == null) {
            return;
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
    }

    private void parseManyToOne(FieldMetaData fmd, ManyToOne anno) {
        if (!JavaTypes.maybePC(fmd.getValue())) {
            throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "ManyToOne"));
        }
        if (anno.fetch() == FetchType.EAGER) {
            fmd.setInDefaultFetchGroup(true);
        }
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.setTypeOverride(anno.targetEntity());
        }
        this.setCascades(fmd, anno.cascade());
        fmd.setAssociationType(3);
    }

    private void parseOneToOne(FieldMetaData fmd, OneToOne anno) {
        if (!JavaTypes.maybePC(fmd.getValue())) {
            throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "OneToOne"));
        }
        if (anno.fetch() == FetchType.EAGER) {
            fmd.setInDefaultFetchGroup(true);
        }
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
        if (this.isMappingOverrideMode() && !StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.setTypeOverride(anno.targetEntity());
        }
        this.setCascades(fmd, anno.cascade());
        this.setOrphanRemoval(fmd, anno.orphanRemoval());
        fmd.setAssociationType(1);
    }

    private void parseEmbedded(FieldMetaData fmd, Embedded anno) {
        if (!JavaTypes.maybePC(fmd.getValue())) {
            throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "Embedded"));
        }
        fmd.setInDefaultFetchGroup(true);
        fmd.setEmbedded(true);
        if (fmd.getEmbeddedMetaData() == null) {
            fmd.addEmbeddedMetaData(this.getAccessCode(fmd.getDeclaredType()));
        }
    }

    private void parseOneToMany(FieldMetaData fmd, OneToMany anno) {
        switch (fmd.getDeclaredTypeCode()) {
            case 11: 
            case 12: 
            case 13: {
                if (JavaTypes.maybePC(fmd.getElement())) break;
            }
            default: {
                throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "OneToMany"));
            }
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (this.isMappingOverrideMode() && !StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.targetEntity());
        }
        this.setCascades(fmd.getElement(), anno.cascade());
        this.setOrphanRemoval(fmd.getElement(), anno.orphanRemoval());
        fmd.setAssociationType(2);
    }

    private void parseManyToMany(FieldMetaData fmd, ManyToMany anno) {
        switch (fmd.getDeclaredTypeCode()) {
            case 11: 
            case 12: 
            case 13: {
                if (fmd.getDeclaredType() == Properties.class || JavaTypes.maybePC(fmd.getElement())) break;
            }
            default: {
                throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "ManyToMany"));
            }
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (this.isMappingOverrideMode() && !StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.targetEntity());
        }
        this.setCascades(fmd.getElement(), anno.cascade());
        fmd.setAssociationType(4);
    }

    private void parseMapKey(FieldMetaData fmd, MapKey anno) {
        String name = anno.name();
        if (StringUtils.isEmpty((String)name)) {
            fmd.getKey().setValueMappedBy("`pk`");
        } else {
            fmd.getKey().setValueMappedBy(name);
        }
    }

    private void parseMapKeyClass(FieldMetaData fmd, MapKeyClass anno) {
        if (anno.value() == Void.TYPE) {
            throw new IllegalArgumentException("The value of the MapClassClass cannot be null");
        }
        fmd.getKey().setDeclaredType(anno.value());
    }

    private void parseMapsId(FieldMetaData fmd, MapsId anno) {
        String value = anno.value();
        if (value != null) {
            fmd.setMappedByIdValue(value);
        } else {
            fmd.setMappedByIdValue("");
        }
    }

    protected void parseLobMapping(FieldMetaData fmd) {
    }

    private void parseOrderBy(FieldMetaData fmd, OrderBy anno) {
        String dec = anno.value();
        if (fmd.isElementCollection() && fmd.getElement().getEmbeddedMetaData() != null && (dec.length() == 0 || dec.equals("ASC") || dec.equals("DESC"))) {
            throw new MetaDataException(_loc.get("invalid-orderBy", fmd));
        }
        if (dec.length() == 0 || dec.equals("ASC")) {
            dec = "#element asc";
        } else if (dec.equals("DESC")) {
            dec = "#element desc";
        }
        fmd.setOrderDeclaration(dec);
    }

    private void parsePersistent(FieldMetaData fmd, Persistent anno) {
        switch (fmd.getDeclaredTypeCode()) {
            case 11: {
                if (fmd.getDeclaredType() == byte[].class || fmd.getDeclaredType() == Byte[].class || fmd.getDeclaredType() == char[].class || fmd.getDeclaredType() == Character[].class) break;
            }
            case 12: 
            case 13: {
                throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "Persistent"));
            }
        }
        if (!StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
        this.setCascades(fmd, anno.cascade());
        if (anno.embedded()) {
            if (!JavaTypes.maybePC(fmd.getValue())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "Persistent(embedded=true)"));
            }
            fmd.setEmbedded(true);
            if (fmd.getEmbeddedMetaData() == null) {
                fmd.addEmbeddedMetaData(this.getAccessCode(fmd.getDeclaredType()));
            }
        }
    }

    private void parsePersistentCollection(FieldMetaData fmd, PersistentCollection anno) {
        if (fmd.getDeclaredTypeCode() != 11 && fmd.getDeclaredTypeCode() != 12) {
            throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "PersistentCollection"));
        }
        fmd.setPersistentCollection(true);
        if (!StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (anno.elementType() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.elementType());
        }
        this.setCascades(fmd.getElement(), anno.elementCascade());
        if (anno.elementEmbedded()) {
            if (!JavaTypes.maybePC(fmd.getElement())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "PersistentCollection(embeddedElement=true)"));
            }
            fmd.getElement().setEmbedded(true);
            if (fmd.getElement().getEmbeddedMetaData() == null) {
                fmd.getElement().addEmbeddedMetaData(this.getAccessCode(fmd.getElement().getDeclaredType()));
            }
        }
    }

    private void parseElementCollection(FieldMetaData fmd, ElementCollection anno) {
        if (fmd.getDeclaredTypeCode() != 12 && fmd.getDeclaredTypeCode() != 13) {
            throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "ElementCollection"));
        }
        if (anno.targetClass() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.targetClass());
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        fmd.setElementCollection(true);
        ValueMetaData elem = fmd.getElement();
        boolean isEnum = elem.getDeclaredType().isEnum();
        if (!isEnum && JavaTypes.maybePC(elem)) {
            elem.setEmbedded(true);
            if (elem.getEmbeddedMetaData() == null) {
                elem.addEmbeddedMetaData(this.getAccessCode(elem.getDeclaredType()));
            }
        }
    }

    private void parsePersistentMap(FieldMetaData fmd, PersistentMap anno) {
        if (fmd.getDeclaredTypeCode() != 13) {
            throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "PersistentMap"));
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (anno.keyType() != Void.TYPE) {
            fmd.getKey().setDeclaredType(anno.keyType());
        }
        if (anno.elementType() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.elementType());
        }
        this.setCascades(fmd.getKey(), anno.keyCascade());
        this.setCascades(fmd.getElement(), anno.elementCascade());
        if (anno.keyEmbedded()) {
            if (!JavaTypes.maybePC(fmd.getKey())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "PersistentMap(embeddedKey=true)"));
            }
            fmd.getKey().setEmbedded(true);
            if (fmd.getKey().getEmbeddedMetaData() == null) {
                fmd.getKey().addEmbeddedMetaData(this.getAccessCode(fmd.getKey().getDeclaredType()));
            }
        }
        if (anno.elementEmbedded()) {
            if (!JavaTypes.maybePC(fmd.getElement())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", fmd, "PersistentMap(embeddedValue=true)"));
            }
            fmd.getElement().setEmbedded(true);
            if (fmd.getElement().getEmbeddedMetaData() == null) {
                fmd.getElement().addEmbeddedMetaData(this.getAccessCode(fmd.getElement().getDeclaredType()));
            }
        }
    }

    private void setCascades(ValueMetaData vmd, CascadeType[] cascades) {
        for (CascadeType cascade : cascades) {
            if (cascade == CascadeType.ALL || cascade == CascadeType.REMOVE) {
                vmd.setCascadeDelete(1);
            }
            if (cascade == CascadeType.ALL || cascade == CascadeType.PERSIST) {
                vmd.setCascadePersist(1);
            }
            if (cascade == CascadeType.ALL || cascade == CascadeType.MERGE) {
                vmd.setCascadeAttach(1);
            }
            if (cascade == CascadeType.ALL || cascade == CascadeType.DETACH) {
                vmd.setCascadeDetach(1);
            }
            if (cascade != CascadeType.ALL && cascade != CascadeType.REFRESH) continue;
            vmd.setCascadeRefresh(1);
        }
    }

    private void setOrphanRemoval(ValueMetaData vmd, boolean orphanRemoval) {
        if (orphanRemoval) {
            vmd.setCascadeDelete(2);
        }
    }

    private void parseSequenceGenerator(AnnotatedElement el, SequenceGenerator gen) {
        String props;
        String clsName;
        SequenceMetaData meta;
        String name = gen.name();
        if (StringUtils.isEmpty((String)name)) {
            throw new MetaDataException(_loc.get("no-seq-name", el));
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("parse-sequence", name));
        }
        if ((meta = this.getRepository().getCachedSequenceMetaData(name)) != null) {
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("dup-sequence", name, el));
            }
            return;
        }
        meta = this.getRepository().addSequenceMetaData(name);
        String seq = gen.sequenceName();
        if (seq.indexOf(40) == -1) {
            seq = this.normalizeSequenceName(seq);
        }
        int initial = gen.initialValue();
        int allocate = gen.allocationSize();
        String schema = this.normalizeSchemaName(gen.schema());
        String catalog = this.normalizeCatalogName(gen.catalog());
        if (initial == 0) {
            initial = 1;
        }
        if (StringUtils.isEmpty((String)seq)) {
            clsName = "native";
            props = null;
        } else if (seq.indexOf(40) != -1) {
            clsName = Configurations.getClassName(seq);
            props = Configurations.getProperties(seq);
            seq = null;
        } else {
            clsName = "native";
            props = null;
        }
        meta.setSequencePlugin(Configurations.getPlugin(clsName, props));
        meta.setSequence(seq);
        meta.setInitialValue(initial);
        meta.setAllocate(allocate);
        meta.setSchema(schema);
        meta.setCatalog(catalog);
        meta.setSource(this.getSourceFile(), el instanceof Class ? el : null, 1);
    }

    private void parseNamedQueries(AnnotatedElement el, NamedQuery ... queries) {
        for (NamedQuery query : queries) {
            QueryMetaData meta;
            if (StringUtils.isEmpty((String)query.name())) {
                throw new MetaDataException(_loc.get("no-query-name", el));
            }
            if (StringUtils.isEmpty((String)query.query())) {
                throw new MetaDataException(_loc.get("no-query-string", query.name(), el));
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("parse-query", query.name()));
            }
            if ((meta = this.getRepository().searchQueryMetaDataByName(query.name())) != null) {
                Class definingType = meta.getDefiningType();
                if (definingType != null && definingType == this._cls || !this._log.isWarnEnabled()) continue;
                this._log.warn(_loc.get("dup-query", query.name(), el, definingType));
                continue;
            }
            meta = this.getRepository().addQueryMetaData(this._cls, query.name());
            meta.setLanguage("javax.persistence.JPQL");
            meta.setQueryString(query.query());
            for (QueryHint hint : query.hints()) {
                meta.addHint(hint.name(), hint.value());
            }
            LockModeType lmt = this.processNamedQueryLockModeType(query);
            if (lmt != null && lmt != LockModeType.NONE) {
                meta.addHint("openjpa.FetchPlan.ReadLockMode", lmt);
            }
            meta.setSource(this.getSourceFile(), el instanceof Class ? el : null, 1, this.getSourceFile() == null ? "" : this.getSourceFile().getPath());
            if (this.isMetaDataMode()) {
                meta.setSourceMode(1);
                continue;
            }
            if (this.isMappingMode()) {
                meta.setSourceMode(2);
                continue;
            }
            meta.setSourceMode(4);
        }
    }

    private LockModeType processNamedQueryLockModeType(NamedQuery query) {
        LockModeType lmt = query.lockMode();
        if (query.lockMode() != null) {
            String lm = this._conf.getLockManager();
            boolean optimistic = this._conf.getOptimistic();
            if (lm != null && (lm = lm.toLowerCase()).contains("pessimistic") && lmt == LockModeType.NONE && !optimistic) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn(_loc.get("override-named-query-lock-mode", new String[]{"annotation", query.name(), this._cls.getName()}));
                }
                lmt = LockModeType.READ;
            }
        }
        return lmt;
    }

    private void parseNamedNativeQueries(AnnotatedElement el, NamedNativeQuery ... queries) {
        for (NamedNativeQuery query : queries) {
            QueryMetaData meta;
            if (StringUtils.isEmpty((String)query.name())) {
                throw new MetaDataException(_loc.get("no-native-query-name", el));
            }
            if (StringUtils.isEmpty((String)query.query())) {
                throw new MetaDataException(_loc.get("no-native-query-string", query.name(), el));
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("parse-native-query", query.name()));
            }
            if ((meta = this.getRepository().searchQueryMetaDataByName(query.name())) != null) {
                Class defType = meta.getDefiningType();
                if (defType == this._cls || !this._log.isWarnEnabled()) continue;
                this._log.warn(_loc.get("dup-query", query.name(), el, defType));
                continue;
            }
            meta = this.getRepository().addQueryMetaData(null, query.name());
            meta.setLanguage("openjpa.SQL");
            meta.setQueryString(query.query());
            Class res = query.resultClass();
            if (ImplHelper.isManagedType(this.getConfiguration(), res)) {
                meta.setCandidateType(res);
            } else if (!Void.TYPE.equals(res)) {
                meta.setResultType(res);
            }
            if (!StringUtils.isEmpty((String)query.resultSetMapping())) {
                meta.setResultSetMappingName(query.resultSetMapping());
            }
            for (QueryHint hint : query.hints()) {
                meta.addHint(hint.name(), hint.value());
            }
            meta.setSource(this.getSourceFile(), el instanceof Class ? el : null, 1, this.getSourceFile() == null ? "" : this.getSourceFile().getPath());
            if (this.isMetaDataMode()) {
                meta.setSourceMode(1);
                continue;
            }
            if (this.isMappingMode()) {
                meta.setSourceMode(2);
                continue;
            }
            meta.setSourceMode(4);
        }
    }

    private void parseAccess(FieldMetaData meta, Access access) {
        if (access != null) {
            meta.setAccessType(AccessCode.EXPLICIT | (access.value() == AccessType.FIELD ? AccessCode.FIELD : AccessCode.PROPERTY));
        }
    }

    protected String normalizeSequenceName(String seqName) {
        return seqName;
    }

    protected String normalizeSchemaName(String schName) {
        return schName;
    }

    protected String normalizeCatalogName(String catName) {
        return catName;
    }

    static {
        _tags.put(Access.class, MetaDataTag.ACCESS);
        _tags.put(Cacheable.class, MetaDataTag.CACHEABLE);
        _tags.put(EmbeddedId.class, MetaDataTag.EMBEDDED_ID);
        _tags.put(EntityListeners.class, MetaDataTag.ENTITY_LISTENERS);
        _tags.put(ExcludeDefaultListeners.class, MetaDataTag.EXCLUDE_DEFAULT_LISTENERS);
        _tags.put(ExcludeSuperclassListeners.class, MetaDataTag.EXCLUDE_SUPERCLASS_LISTENERS);
        _tags.put(FlushModeType.class, MetaDataTag.FLUSH_MODE);
        _tags.put(GeneratedValue.class, MetaDataTag.GENERATED_VALUE);
        _tags.put(Id.class, MetaDataTag.ID);
        _tags.put(IdClass.class, MetaDataTag.ID_CLASS);
        _tags.put(MapKey.class, MetaDataTag.MAP_KEY);
        _tags.put(MapKeyClass.class, MetaDataTag.MAP_KEY_CLASS);
        _tags.put(MapsId.class, MetaDataTag.MAPPED_BY_ID);
        _tags.put(NamedNativeQueries.class, MetaDataTag.NATIVE_QUERIES);
        _tags.put(NamedNativeQuery.class, MetaDataTag.NATIVE_QUERY);
        _tags.put(NamedQueries.class, MetaDataTag.QUERIES);
        _tags.put(NamedQuery.class, MetaDataTag.QUERY);
        _tags.put(OrderBy.class, MetaDataTag.ORDER_BY);
        _tags.put(PostLoad.class, MetaDataTag.POST_LOAD);
        _tags.put(PostPersist.class, MetaDataTag.POST_PERSIST);
        _tags.put(PostRemove.class, MetaDataTag.POST_REMOVE);
        _tags.put(PostUpdate.class, MetaDataTag.POST_UPDATE);
        _tags.put(PrePersist.class, MetaDataTag.PRE_PERSIST);
        _tags.put(PreRemove.class, MetaDataTag.PRE_REMOVE);
        _tags.put(PreUpdate.class, MetaDataTag.PRE_UPDATE);
        _tags.put(SequenceGenerator.class, MetaDataTag.SEQ_GENERATOR);
        _tags.put(Version.class, MetaDataTag.VERSION);
        _tags.put(DataCache.class, MetaDataTag.DATA_CACHE);
        _tags.put(DataStoreId.class, MetaDataTag.DATASTORE_ID);
        _tags.put(Dependent.class, MetaDataTag.DEPENDENT);
        _tags.put(DetachedState.class, MetaDataTag.DETACHED_STATE);
        _tags.put(ElementDependent.class, MetaDataTag.ELEM_DEPENDENT);
        _tags.put(ElementType.class, MetaDataTag.ELEM_TYPE);
        _tags.put(ExternalValues.class, MetaDataTag.EXTERNAL_VALS);
        _tags.put(Externalizer.class, MetaDataTag.EXTERNALIZER);
        _tags.put(Factory.class, MetaDataTag.FACTORY);
        _tags.put(FetchGroup.class, MetaDataTag.FETCH_GROUP);
        _tags.put(FetchGroups.class, MetaDataTag.FETCH_GROUPS);
        _tags.put(InverseLogical.class, MetaDataTag.INVERSE_LOGICAL);
        _tags.put(KeyDependent.class, MetaDataTag.KEY_DEPENDENT);
        _tags.put(KeyType.class, MetaDataTag.KEY_TYPE);
        _tags.put(LoadFetchGroup.class, MetaDataTag.LOAD_FETCH_GROUP);
        _tags.put(LRS.class, MetaDataTag.LRS);
        _tags.put(ManagedInterface.class, MetaDataTag.MANAGED_INTERFACE);
        _tags.put(ReadOnly.class, MetaDataTag.READ_ONLY);
        _tags.put(Type.class, MetaDataTag.TYPE);
    }

    static class FetchAttributeImpl {
        private String name = "";
        private int recursionDepth = Integer.MIN_VALUE;

        public FetchAttributeImpl(String name, int recursionDepth) {
            this.name = name;
            this.recursionDepth = recursionDepth;
        }

        public String name() {
            return this.name;
        }

        public int recursionDepth() {
            return this.recursionDepth;
        }
    }

    static class FetchGroupImpl {
        private String name = "";
        private boolean postLoad = false;
        private FetchAttributeImpl[] attributes = new FetchAttributeImpl[0];
        private String[] fetchGroups = new String[0];

        FetchGroupImpl(String name, boolean postLoad) {
            this.name = name;
            this.postLoad = postLoad;
        }

        public String name() {
            return this.name;
        }

        public boolean postLoad() {
            return this.postLoad;
        }

        public FetchAttributeImpl[] attributes() {
            return this.attributes;
        }

        public String[] fetchGroups() {
            return this.fetchGroups;
        }

        public void setAttributes(FetchAttributeImpl[] attributes) {
            this.attributes = attributes;
        }

        public void setFetchGroups(String[] fetchGroups) {
            this.fetchGroups = fetchGroups;
        }
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private static MethodComparator INSTANCE = null;

        private MethodComparator() {
        }

        public static MethodComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new MethodComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(Method m1, Method m2) {
            Class<?> c2;
            Class<?> c1 = m1.getDeclaringClass();
            if (!c1.equals(c2 = m2.getDeclaringClass())) {
                if (c1.isAssignableFrom(c2)) {
                    return -1;
                }
                return 1;
            }
            int compare = m1.getName().compareTo(m2.getName());
            if (compare == 0) {
                return m1.hashCode() - m2.hashCode();
            }
            return compare;
        }
    }

    private static class MethodKey {
        private final Method _method;

        public MethodKey(Method m) {
            this._method = m;
        }

        public int hashCode() {
            int code = 552 + this._method.getName().hashCode();
            for (Class<?> param : this._method.getParameterTypes()) {
                code = 46 * code + param.hashCode();
            }
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            Method other = ((MethodKey)o)._method;
            if (!this._method.getName().equals(other.getName())) {
                return false;
            }
            return Arrays.equals(this._method.getParameterTypes(), other.getParameterTypes());
        }
    }
}

