/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.base.Strings;
import java.util.Optional;
import org.apache.james.transport.mailets.redirect.InitParameters;
import org.apache.james.transport.mailets.redirect.InitParametersSerializer;
import org.apache.james.transport.mailets.redirect.LoadedOnceInitParameters;
import org.apache.james.transport.mailets.redirect.TypeCode;
import org.apache.mailet.base.GenericMailet;

public class NotifyMailetInitParameters
implements InitParameters {
    private final GenericMailet mailet;

    public static InitParameters from(GenericMailet mailet) {
        NotifyMailetInitParameters initParameters = new NotifyMailetInitParameters(mailet);
        if (initParameters.isStatic()) {
            return LoadedOnceInitParameters.from(initParameters);
        }
        return initParameters;
    }

    private NotifyMailetInitParameters(GenericMailet mailet) {
        this.mailet = mailet;
    }

    @Override
    public boolean getPassThrough() {
        return this.mailet.getInitParameter("passThrough", true);
    }

    @Override
    public boolean getFakeDomainCheck() {
        return this.mailet.getInitParameter("fakeDomainCheck", false);
    }

    @Override
    public TypeCode getInLineType() {
        return TypeCode.from(this.mailet.getInitParameter("inline", "none"));
    }

    @Override
    public TypeCode getAttachmentType() {
        return TypeCode.from(this.mailet.getInitParameter("attachment", "message"));
    }

    @Override
    public String getMessage() {
        return this.mailet.getInitParameter("notice", this.mailet.getInitParameter("message", "We were unable to deliver the attached message because of an error in the mail server."));
    }

    @Override
    public String getSubject() {
        return null;
    }

    @Override
    public String getSubjectPrefix() {
        return this.mailet.getInitParameter("prefix", "Re:");
    }

    @Override
    public boolean isAttachError() {
        return this.mailet.getInitParameter("attachError", false);
    }

    @Override
    public boolean isReply() {
        return true;
    }

    @Override
    public Optional<String> getRecipients() {
        return this.mailet.getInitParameterAsOptional("recipients");
    }

    @Override
    public Optional<String> getTo() {
        return this.mailet.getInitParameterAsOptional("to");
    }

    @Override
    public Optional<String> getReversePath() {
        return this.mailet.getInitParameterAsOptional("reversePath");
    }

    @Override
    public Optional<String> getSender() {
        return this.mailet.getInitParameterAsOptional("sender");
    }

    @Override
    public Optional<String> getReplyTo() {
        String recipients = this.mailet.getInitParameter("replyTo", this.mailet.getInitParameter("replyto"));
        if (Strings.isNullOrEmpty((String)recipients)) {
            return Optional.empty();
        }
        return Optional.of(recipients);
    }

    @Override
    public boolean isDebug() {
        return this.mailet.getInitParameter("debug", false);
    }

    @Override
    public boolean isStatic() {
        return this.mailet.getInitParameter("static", false);
    }

    @Override
    public String asString() {
        return InitParametersSerializer.serialize(this);
    }
}

