/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import jakarta.mail.MessagingException;
import org.apache.james.mailbox.model.MailboxConstants;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIntoAction
implements MailAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIntoAction.class);

    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionFileInto) {
            ActionFileInto fileIntoAction = (ActionFileInto)action;
            this.execute(fileIntoAction, mail, context);
        }
    }

    public void execute(ActionFileInto anAction, Mail aMail, ActionContext context) throws MessagingException {
        String destinationMailbox = this.getDestinationMailbox(anAction);
        String mailbox = destinationMailbox.replace(MailboxConstants.FOLDER_DELIMITER, '/');
        String url = "mailbox://" + context.getRecipient().asString() + mailbox;
        context.post(url, aMail);
        LOGGER.debug("Filed Message ID: {} into destination: \"{}\"", (Object)aMail.getMessage().getMessageID(), (Object)destinationMailbox);
    }

    private String getDestinationMailbox(ActionFileInto anAction) {
        if (anAction.getDestination().isEmpty() || anAction.getDestination().charAt(0) != MailboxConstants.FOLDER_DELIMITER) {
            return MailboxConstants.FOLDER_DELIMITER + anAction.getDestination();
        }
        return anAction.getDestination();
    }
}

