/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.QuotaDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.apache.james.webadmin.jackson.QuotaModule;
import org.apache.james.webadmin.service.GlobalQuotaService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.apache.james.webadmin.validation.QuotaDTOValidator;
import org.apache.james.webadmin.validation.Quotas;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class GlobalQuotaRoutes
implements Routes {
    public static final String QUOTA_ENDPOINT = "/quota";
    private static final String COUNT_ENDPOINT = "/quota/count";
    private static final String SIZE_ENDPOINT = "/quota/size";
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<QuotaDTO> jsonExtractor;
    private final QuotaDTOValidator quotaDTOValidator;
    private final GlobalQuotaService globalQuotaService;
    private Service service;

    @Inject
    public GlobalQuotaRoutes(GlobalQuotaService globalQuotaService, JsonTransformer jsonTransformer) {
        this.globalQuotaService = globalQuotaService;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(QuotaDTO.class, new Module[]{new QuotaModule().asJacksonModule()});
        this.quotaDTOValidator = new QuotaDTOValidator();
    }

    public String getBasePath() {
        return QUOTA_ENDPOINT;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetQuotaCount();
        this.defineDeleteQuotaCount();
        this.defineUpdateQuotaCount();
        this.defineGetQuotaSize();
        this.defineDeleteQuotaSize();
        this.defineUpdateQuotaSize();
        this.defineGetQuota();
        this.defineUpdateQuota();
    }

    public void defineUpdateQuota() {
        this.service.put(QUOTA_ENDPOINT, (request, response) -> {
            try {
                QuotaDTO quotaDTO = (QuotaDTO)this.jsonExtractor.parse(request.body());
                ValidatedQuotaDTO validatedQuotaDTO = this.quotaDTOValidator.validatedQuotaDTO(quotaDTO);
                this.globalQuotaService.defineQuota(validatedQuotaDTO);
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalArgumentException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Quota should be positive or unlimited (-1)").cause((Exception)e).haltError();
            }
        });
    }

    public void defineGetQuota() {
        this.service.get(QUOTA_ENDPOINT, (request, response) -> this.globalQuotaService.getQuota(), (ResponseTransformer)this.jsonTransformer);
    }

    public void defineDeleteQuotaSize() {
        this.service.delete(SIZE_ENDPOINT, (request, response) -> {
            this.globalQuotaService.deleteMaxSizeQuota();
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineUpdateQuotaSize() {
        this.service.put(SIZE_ENDPOINT, (request, response) -> {
            QuotaSizeLimit quotaSize = Quotas.quotaSize(request.body());
            this.globalQuotaService.defineMaxSizeQuota(quotaSize);
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineGetQuotaSize() {
        this.service.get(SIZE_ENDPOINT, this::getQuotaSize, (ResponseTransformer)this.jsonTransformer);
    }

    private QuotaSizeLimit getQuotaSize(Request request, Response response) throws MailboxException {
        Optional<QuotaSizeLimit> maxSizeQuota = this.globalQuotaService.getMaxSizeQuota();
        if (maxSizeQuota.isPresent()) {
            return maxSizeQuota.get();
        }
        response.status(204);
        return null;
    }

    public void defineDeleteQuotaCount() {
        this.service.delete(COUNT_ENDPOINT, (request, response) -> {
            this.globalQuotaService.deleteMaxCountQuota();
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineUpdateQuotaCount() {
        this.service.put(COUNT_ENDPOINT, (request, response) -> {
            QuotaCountLimit quotaRequest = Quotas.quotaCount(request.body());
            this.globalQuotaService.defineMaxCountQuota(quotaRequest);
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineGetQuotaCount() {
        this.service.get(COUNT_ENDPOINT, this::getQuotaCount, (ResponseTransformer)this.jsonTransformer);
    }

    private QuotaCountLimit getQuotaCount(Request request, Response response) throws MailboxException {
        Optional<QuotaCountLimit> maxCountQuota = this.globalQuotaService.getMaxCountQuota();
        if (maxCountQuota.isPresent()) {
            return maxCountQuota.get();
        }
        response.status(204);
        return null;
    }
}

