/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.composite;

import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.config.composite.CompositeDriverConfig;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CompositeDriverConfigLoader
implements DriverConfigLoader {
    private final DriverConfigLoader primaryConfigLoader;
    private final DriverConfigLoader fallbackConfigLoader;

    public CompositeDriverConfigLoader(@NonNull DriverConfigLoader primaryConfigLoader, @NonNull DriverConfigLoader fallbackConfigLoader) {
        this.primaryConfigLoader = Objects.requireNonNull(primaryConfigLoader);
        this.fallbackConfigLoader = Objects.requireNonNull(fallbackConfigLoader);
    }

    @Override
    @NonNull
    public DriverConfig getInitialConfig() {
        DriverConfig primaryConfig = this.primaryConfigLoader.getInitialConfig();
        DriverConfig fallbackConfig = this.fallbackConfigLoader.getInitialConfig();
        return new CompositeDriverConfig(primaryConfig, fallbackConfig);
    }

    @Override
    public void onDriverInit(@NonNull DriverContext context) {
        this.fallbackConfigLoader.onDriverInit(context);
        this.primaryConfigLoader.onDriverInit(context);
    }

    @Override
    @NonNull
    public CompletionStage<Boolean> reload() {
        if (!this.primaryConfigLoader.supportsReloading() && !this.fallbackConfigLoader.supportsReloading()) {
            return CompletableFutures.failedFuture(new UnsupportedOperationException("Reloading is not supported (this is a composite config, and neither the primary nor the fallback are reloadable)"));
        }
        if (!this.primaryConfigLoader.supportsReloading()) {
            return this.fallbackConfigLoader.reload();
        }
        if (!this.fallbackConfigLoader.supportsReloading()) {
            return this.primaryConfigLoader.reload();
        }
        CompletionStage<Boolean> primaryFuture = this.primaryConfigLoader.reload();
        CompletionStage<Boolean> fallbackFuture = this.fallbackConfigLoader.reload();
        CompletableFuture<Boolean> compositeFuture = new CompletableFuture<Boolean>();
        primaryFuture.whenComplete((primaryChanged, primaryError) -> fallbackFuture.whenComplete((fallbackChanged, fallbackError) -> {
            if (primaryError == null && fallbackError == null) {
                compositeFuture.complete(primaryChanged != false || fallbackChanged != false);
            } else if (fallbackError == null) {
                compositeFuture.completeExceptionally((Throwable)primaryError);
            } else if (primaryError == null) {
                compositeFuture.completeExceptionally((Throwable)fallbackError);
            } else {
                primaryError.addSuppressed((Throwable)fallbackError);
                compositeFuture.completeExceptionally((Throwable)primaryError);
            }
        }));
        return compositeFuture;
    }

    @Override
    public boolean supportsReloading() {
        return this.primaryConfigLoader.supportsReloading() || this.fallbackConfigLoader.supportsReloading();
    }

    @Override
    public void close() {
        this.primaryConfigLoader.close();
        this.fallbackConfigLoader.close();
    }
}

