/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.postgres.model;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.sieve.postgres.model.PostgresSieveScriptId;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;

public class PostgresSieveScript {
    private final PostgresSieveScriptId id;
    private final String username;
    private final String scriptName;
    private final String scriptContent;
    private final long scriptSize;
    private final boolean isActive;
    private final OffsetDateTime activationDateTime;

    public static Builder builder() {
        return new Builder();
    }

    private PostgresSieveScript(PostgresSieveScriptId id, String username, String scriptName, String scriptContent, long scriptSize, boolean isActive, OffsetDateTime activationDateTime) {
        this.id = id;
        this.username = username;
        this.scriptName = scriptName;
        this.scriptContent = scriptContent;
        this.scriptSize = scriptSize;
        this.isActive = isActive;
        this.activationDateTime = activationDateTime;
    }

    public PostgresSieveScriptId getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public long getScriptSize() {
        return this.scriptSize;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public OffsetDateTime getActivationDateTime() {
        return this.activationDateTime;
    }

    public ScriptSummary toScriptSummary() {
        return new ScriptSummary(new ScriptName(this.scriptName), this.isActive, this.scriptSize);
    }

    public final boolean equals(Object o) {
        if (o instanceof PostgresSieveScript) {
            PostgresSieveScript that = (PostgresSieveScript)o;
            return Objects.equals(this.scriptSize, that.scriptSize) && Objects.equals(this.isActive, that.isActive) && Objects.equals(this.username, that.username) && Objects.equals(this.scriptName, that.scriptName) && Objects.equals(this.scriptContent, that.scriptContent) && Objects.equals(this.activationDateTime, that.activationDateTime);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.username, this.scriptName);
    }

    public static class Builder {
        private String username;
        private String scriptName;
        private String scriptContent;
        private long scriptSize;
        private boolean isActive;
        private OffsetDateTime activationDateTime;
        private PostgresSieveScriptId id;

        public Builder username(String username) {
            Preconditions.checkNotNull((Object)username);
            this.username = username;
            return this;
        }

        public Builder scriptName(String scriptName) {
            Preconditions.checkNotNull((Object)scriptName);
            this.scriptName = scriptName;
            return this;
        }

        public Builder scriptContent(String scriptContent) {
            this.scriptContent = scriptContent;
            return this;
        }

        public Builder scriptSize(long scriptSize) {
            this.scriptSize = scriptSize;
            return this;
        }

        public Builder id(PostgresSieveScriptId id) {
            this.id = id;
            return this;
        }

        public Builder isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder activationDateTime(OffsetDateTime offsetDateTime) {
            this.activationDateTime = offsetDateTime;
            return this;
        }

        public PostgresSieveScript build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.username), (Object)"'username' is mandatory");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.scriptName), (Object)"'scriptName' is mandatory");
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"'id' is mandatory");
            return new PostgresSieveScript(this.id, this.username, this.scriptName, this.scriptContent, this.scriptSize, this.isActive, this.activationDateTime);
        }
    }
}

