/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.process;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public interface ImapSession
extends CommandDetectionSession {
    public static final String MDC_KEY = "bound_MDC";
    public static final String MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY = "org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY";

    public SessionId sessionId();

    default public void executeSafely(Runnable runnable) {
        runnable.run();
    }

    default public ImapProcessor.Responder threadSafe(ImapProcessor.Responder responder) {
        return responder;
    }

    public Mono<Void> logout();

    default public void cancelOngoingProcessing() {
    }

    default public boolean backpressureNeeded(Runnable restoreBackpressure) {
        return false;
    }

    public ImapSessionState getState();

    public void authenticated();

    public Mono<Void> selected(SelectedMailbox var1);

    public Mono<Void> deselect();

    public SelectedMailbox getSelected();

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public boolean startTLS(Runnable var1);

    public boolean isTLSActive();

    public boolean supportStartTLS();

    public Optional<SSLSession> getSSLSession();

    public boolean isCompressionActive();

    public boolean isCompressionSupported();

    public boolean startCompression(Runnable var1);

    public void pushLineHandler(ImapLineHandler var1);

    public void popLineHandler();

    public boolean isSSLRequired();

    public boolean isPlainAuthEnabled();

    public boolean supportsOAuth();

    default public void withMDC(Runnable runnable) {
        try (Closeable c = this.mdc().build();){
            runnable.run();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public MDCBuilder mdc() {
        Object object = this.getAttribute(MDC_KEY);
        if (object instanceof MDCBuilder) {
            MDCBuilder mdcBuilder = (MDCBuilder)object;
            return mdcBuilder;
        }
        return MDCBuilder.create();
    }

    public InetSocketAddress getRemoteAddress();

    public Optional<OidcSASLConfiguration> oidcSaslConfiguration();

    default public void setMailboxSession(MailboxSession mailboxSession) {
        this.setAttribute(MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY, mailboxSession);
    }

    default public MailboxSession getMailboxSession() {
        return (MailboxSession)this.getAttribute(MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY);
    }

    default public Username getUserName() {
        return Optional.ofNullable(this.getMailboxSession()).map(MailboxSession::getUser).orElse(null);
    }

    default public boolean isPlainAuthDisallowed() {
        return !this.isPlainAuthEnabled() || this.isAuthenticatingNonEncryptedWhenRequiredSSL();
    }

    default public boolean isAuthenticatingNonEncryptedWhenRequiredSSL() {
        return this.isSSLRequired() && !this.isTLSActive();
    }

    public void schedule(Runnable var1, Duration var2);

    public static class SessionId {
        private static final RandomStringGenerator RANDOM_STRING_GENERATOR = new RandomStringGenerator.Builder().withinRange(97, 122).build();
        private static final int LENGTH = 12;
        private final String value;

        public static SessionId generate() {
            return new SessionId("SID-" + RANDOM_STRING_GENERATOR.generate(12));
        }

        private SessionId(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof SessionId) {
                SessionId sessionId = (SessionId)o;
                return Objects.equals(this.value, sessionId.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.asString();
        }
    }
}

