/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxFlagInconsistenciesService;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class SolveMailboxFlagInconsistencyTask
implements Task {
    public static final String TYPE = "solve-mailbox-flag-inconsistencies";
    public static final TaskType TASK_TYPE = TaskType.of((String)"solve-mailbox-flag-inconsistencies");
    private final SolveMailboxFlagInconsistenciesService.Context context = new SolveMailboxFlagInconsistenciesService.Context();
    private final SolveMailboxFlagInconsistenciesService service;
    private final SolveMailboxFlagInconsistenciesService.TargetFlag targetFlag;

    public SolveMailboxFlagInconsistencyTask(SolveMailboxFlagInconsistenciesService service, String targetFlag) {
        this(service, Optional.ofNullable(SolveMailboxFlagInconsistenciesService.TargetFlag.from(targetFlag)).orElseThrow(() -> new IllegalArgumentException("Invalid target flag: " + targetFlag)));
    }

    public SolveMailboxFlagInconsistencyTask(SolveMailboxFlagInconsistenciesService service, SolveMailboxFlagInconsistenciesService.TargetFlag targetFlag) {
        this.service = service;
        this.targetFlag = targetFlag;
    }

    public Task.Result run() throws InterruptedException {
        return (Task.Result)this.service.fixInconsistencies(this.context, this.targetFlag).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        SolveMailboxFlagInconsistenciesService.Context.Snapshot snapshot = this.context.snapshot();
        return Optional.of(new Details(Clock.systemUTC().instant(), snapshot.processedMailboxEntries(), (ImmutableList<String>)ImmutableList.copyOf(snapshot.errors().stream().map(CassandraId::serialize).toList()), this.targetFlag.name()));
    }

    public String targetFlag() {
        return this.targetFlag.name();
    }

    public record Details(Instant timestamp, long processedMailboxEntries, ImmutableList<String> errors, String targetFlag) implements TaskExecutionDetails.AdditionalInformation
    {
    }
}

