/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.vault.dto.query.CriterionDTO;
import org.apache.james.vault.dto.query.QueryDTO;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.search.Combinator;
import org.apache.james.vault.search.Criterion;
import org.apache.james.vault.search.CriterionFactory;
import org.apache.james.vault.search.FieldName;
import org.apache.james.vault.search.Operator;
import org.apache.james.vault.search.Query;

public class QueryTranslator {
    private final ImmutableTable<FieldName, Operator, Function<String, Criterion<?>>> criterionRegistry;

    public static FieldName getField(String fieldNameString) throws QueryTranslatorException {
        return Stream.of(FieldName.values()).filter(fieldName -> fieldName.getValue().equals(fieldNameString)).findFirst().orElseThrow(() -> new QueryTranslatorException("fieldName: '" + fieldNameString + "' is not supported"));
    }

    static Operator getOperator(String operator) throws QueryTranslatorException {
        return Stream.of(Operator.values()).filter(operatorString -> operatorString.getValue().equals(operator)).findFirst().orElseThrow(() -> new QueryTranslatorException("operator: '" + operator + "' is not supported"));
    }

    @Inject
    @VisibleForTesting
    public QueryTranslator(MailboxId.Factory mailboxIdFactory) {
        this.criterionRegistry = this.withMailboxIdCriterionParser(mailboxIdFactory);
    }

    private ImmutableTable<FieldName, Operator, Function<String, Criterion<?>>> withMailboxIdCriterionParser(MailboxId.Factory mailboxIdFactor) {
        FieldValueParser.MailboxIdValueParser mailboxIdParser = new FieldValueParser.MailboxIdValueParser(mailboxIdFactor);
        return this.defaultRegistryBuilder().put((Object)FieldName.ORIGIN_MAILBOXES, (Object)Operator.CONTAINS, testedValue -> CriterionFactory.containsOriginMailbox(mailboxIdParser.parse((String)testedValue))).build();
    }

    private ImmutableTable.Builder<FieldName, Operator, Function<String, Criterion<?>>> defaultRegistryBuilder() {
        return ImmutableTable.builder().put((Object)FieldName.DELETION_DATE, (Object)Operator.BEFORE_OR_EQUALS, testedValue -> CriterionFactory.deletionDate().beforeOrEquals(FieldValueParser.ZONED_DATE_TIME_PARSER.parse((String)testedValue))).put((Object)FieldName.DELETION_DATE, (Object)Operator.AFTER_OR_EQUALS, testedValue -> CriterionFactory.deletionDate().afterOrEquals(FieldValueParser.ZONED_DATE_TIME_PARSER.parse((String)testedValue))).put((Object)FieldName.DELIVERY_DATE, (Object)Operator.BEFORE_OR_EQUALS, testedValue -> CriterionFactory.deliveryDate().beforeOrEquals(FieldValueParser.ZONED_DATE_TIME_PARSER.parse((String)testedValue))).put((Object)FieldName.DELIVERY_DATE, (Object)Operator.AFTER_OR_EQUALS, testedValue -> CriterionFactory.deliveryDate().afterOrEquals(FieldValueParser.ZONED_DATE_TIME_PARSER.parse((String)testedValue))).put((Object)FieldName.RECIPIENTS, (Object)Operator.CONTAINS, testedValue -> CriterionFactory.containsRecipient(FieldValueParser.MAIL_ADDRESS_PARSER.parse((String)testedValue))).put((Object)FieldName.SENDER, (Object)Operator.EQUALS, testedValue -> CriterionFactory.hasSender(FieldValueParser.MAIL_ADDRESS_PARSER.parse((String)testedValue))).put((Object)FieldName.HAS_ATTACHMENT, (Object)Operator.EQUALS, testedValue -> CriterionFactory.hasAttachment(FieldValueParser.BOOLEAN_PARSER.parse((String)testedValue))).put((Object)FieldName.SUBJECT, (Object)Operator.EQUALS, testedValue -> CriterionFactory.subject().equals(FieldValueParser.STRING_PARSER.parse((String)testedValue))).put((Object)FieldName.SUBJECT, (Object)Operator.EQUALS_IGNORE_CASE, testedValue -> CriterionFactory.subject().equalsIgnoreCase(FieldValueParser.STRING_PARSER.parse((String)testedValue))).put((Object)FieldName.SUBJECT, (Object)Operator.CONTAINS, testedValue -> CriterionFactory.subject().contains(FieldValueParser.STRING_PARSER.parse((String)testedValue))).put((Object)FieldName.SUBJECT, (Object)Operator.CONTAINS_IGNORE_CASE, testedValue -> CriterionFactory.subject().containsIgnoreCase(FieldValueParser.STRING_PARSER.parse((String)testedValue)));
    }

    private Criterion<?> translate(CriterionDTO dto) throws QueryTranslatorException {
        return Optional.ofNullable(this.getCriterionParser(dto)).map(criterionGeneratingFunction -> (Criterion)criterionGeneratingFunction.apply(dto.getValue())).orElseThrow(() -> new QueryTranslatorException("pair of fieldName: '" + dto.getFieldName() + "' and operator: '" + dto.getOperator() + "' is not supported"));
    }

    private Function<String, Criterion<?>> getCriterionParser(CriterionDTO dto) {
        return this.getCriterionParser(QueryTranslator.getField(dto.getFieldName()), QueryTranslator.getOperator(dto.getOperator()));
    }

    private Function<String, Criterion<?>> getCriterionParser(FieldName fieldName, Operator operator) {
        return (Function)this.criterionRegistry.get((Object)fieldName, (Object)operator);
    }

    public Query translate(QueryElement queryElement) throws QueryTranslatorException {
        if (queryElement instanceof QueryDTO) {
            return this.translate((QueryDTO)queryElement);
        }
        if (queryElement instanceof CriterionDTO) {
            return Query.of(this.translate((CriterionDTO)queryElement));
        }
        throw new IllegalArgumentException("cannot resolve query type: " + queryElement.getClass().getName());
    }

    public QueryDTO toDTO(Query query) throws QueryTranslatorException {
        List queryElements = (List)query.getCriteria().stream().map(this::toDTO).collect(ImmutableList.toImmutableList());
        return new QueryDTO(Combinator.AND.getValue(), queryElements);
    }

    private CriterionDTO toDTO(Criterion<?> criterion) {
        FieldName fieldName = criterion.getField().fieldName();
        Operator operator = criterion.getValueMatcher().operator();
        Object value = criterion.getValueMatcher().expectedValue();
        FieldValueSerializer fieldValueSerializer = FieldValueSerializer.getSerializerForValue(value).orElseThrow(() -> new IllegalArgumentException("Value of type " + value.getClass().getSimpleName() + "' is not handled by the combinaison of operator : " + operator.name() + " and field :" + fieldName.name()));
        CriterionDTO result = new CriterionDTO(fieldName.getValue(), operator.getValue(), fieldValueSerializer.serialize(value));
        return result;
    }

    Query translate(QueryDTO queryDTO) throws QueryTranslatorException {
        Preconditions.checkArgument((boolean)this.combinatorIsValid(queryDTO.getCombinator()), (String)"combinator '%s' is not yet handled", (Object)queryDTO.getCombinator());
        Preconditions.checkArgument((boolean)queryDTO.getCriteria().stream().allMatch(this::isCriterion), (Object)"nested query structure is not yet handled");
        return Query.and((List)queryDTO.getCriteria().stream().map(queryElement -> (CriterionDTO)queryElement).map(Throwing.function(this::translate)).collect(ImmutableList.toImmutableList()));
    }

    private boolean combinatorIsValid(String combinator) {
        return Combinator.AND.getValue().equals(combinator) || Objects.isNull(combinator);
    }

    private boolean isCriterion(QueryElement queryElement) {
        return queryElement instanceof CriterionDTO;
    }

    static interface FieldValueSerializer<T> {
        public static final FieldValueSerializer<MailboxId> MAILBOX_ID_SERIALIZER = MailboxId::serialize;
        public static final FieldValueSerializer<ZonedDateTime> ZONED_DATE_TIME_SERIALIZER = ZonedDateTime::toString;
        public static final FieldValueSerializer<String> STRING_SERIALIZER = input -> input;
        public static final FieldValueSerializer<Boolean> BOOLEAN_SERIALIZER = Object::toString;
        public static final FieldValueSerializer<MailAddress> MAIL_ADDRESS_SERIALIZER = MailAddress::asString;

        public static Optional<FieldValueSerializer> getSerializerForValue(Object value) {
            if (value instanceof MailboxId) {
                return Optional.of(MAILBOX_ID_SERIALIZER);
            }
            if (value instanceof ZonedDateTime) {
                return Optional.of(ZONED_DATE_TIME_SERIALIZER);
            }
            if (value instanceof String) {
                return Optional.of(STRING_SERIALIZER);
            }
            if (value instanceof Boolean) {
                return Optional.of(BOOLEAN_SERIALIZER);
            }
            if (value instanceof MailAddress) {
                return Optional.of(MAIL_ADDRESS_SERIALIZER);
            }
            return Optional.empty();
        }

        public String serialize(T var1);
    }

    static interface FieldValueParser<T> {
        public static final FieldValueParser<ZonedDateTime> ZONED_DATE_TIME_PARSER = ZonedDateTime::parse;
        public static final FieldValueParser<String> STRING_PARSER = input -> input;
        public static final FieldValueParser<Boolean> BOOLEAN_PARSER = Boolean::valueOf;
        public static final FieldValueParser<MailAddress> MAIL_ADDRESS_PARSER = FieldValueParser::parseMailAddress;

        public static MailAddress parseMailAddress(String mailAddressString) throws QueryTranslatorException {
            try {
                return new MailAddress(mailAddressString);
            }
            catch (AddressException e) {
                throw new QueryTranslatorException("mailAddress(" + mailAddressString + ") parsing got error: " + e.getMessage());
            }
        }

        public T parse(String var1);

        public static class MailboxIdValueParser
        implements FieldValueParser<MailboxId> {
            final MailboxId.Factory mailboxIdFactory;

            MailboxIdValueParser(MailboxId.Factory mailboxIdFactory) {
                this.mailboxIdFactory = mailboxIdFactory;
            }

            @Override
            public MailboxId parse(String mailboxIdString) {
                return this.mailboxIdFactory.fromString(mailboxIdString);
            }
        }
    }

    public static class QueryTranslatorException
    extends RuntimeException {
        QueryTranslatorException(String message) {
            super(message);
        }
    }
}

