/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.shard.RemoveCorruptedShardDataCommand;

public class RemoveCorruptedLuceneSegmentsAction {
    public Tuple<RemoveCorruptedShardDataCommand.CleanStatus, String> getCleanStatus(Directory indexDirectory, Lock writeLock, PrintStream printStream, boolean verbose) throws IOException {
        boolean markedCorrupted = RemoveCorruptedShardDataCommand.isCorruptMarkerFileIsPresent(indexDirectory);
        try (CheckIndex checker = new CheckIndex(indexDirectory, writeLock);){
            checker.setChecksumsOnly(true);
            checker.setInfoStream(printStream, verbose);
            CheckIndex.Status status = checker.checkIndex(null);
            if (status.missingSegments) {
                Tuple tuple = Tuple.tuple((Object)((Object)RemoveCorruptedShardDataCommand.CleanStatus.UNRECOVERABLE), (Object)"Index is unrecoverable - there are missing segments");
                return tuple;
            }
            Tuple tuple = status.clean ? Tuple.tuple((Object)((Object)(markedCorrupted ? RemoveCorruptedShardDataCommand.CleanStatus.CLEAN_WITH_CORRUPTED_MARKER : RemoveCorruptedShardDataCommand.CleanStatus.CLEAN)), null) : Tuple.tuple((Object)((Object)RemoveCorruptedShardDataCommand.CleanStatus.CORRUPTED), (Object)("Corrupted Lucene index segments found - " + status.totLoseDocCount + " documents will be lost."));
            return tuple;
        }
    }

    public void execute(Terminal terminal, Directory indexDirectory, Lock writeLock, PrintStream printStream, boolean verbose) throws IOException {
        block7: {
            try (CheckIndex checker = new CheckIndex(indexDirectory, writeLock);){
                checker.setChecksumsOnly(true);
                checker.setInfoStream(printStream, verbose);
                CheckIndex.Status status = checker.checkIndex(null);
                if (!status.missingSegments) {
                    if (!status.clean) {
                        terminal.println("Writing...");
                        checker.exorciseIndex(status);
                        terminal.println("OK");
                        terminal.println("Wrote new segments file \"" + status.segmentsFileName + "\"");
                    }
                    break block7;
                }
                throw new ElasticsearchException("Index is unrecoverable - there are missing segments", new Object[0]);
            }
        }
    }
}

