/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.components.CassandraTable;
import org.apache.james.backends.cassandra.components.CassandraType;
import org.apache.james.backends.cassandra.init.CassandraTableManager;
import org.apache.james.backends.cassandra.init.CassandraTypesCreator;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;

@Singleton
public class SessionWithInitializedTablesFactory
implements Provider<Session> {
    private final CassandraModule module;
    private final Session session;

    @Inject
    public SessionWithInitializedTablesFactory(KeyspaceConfiguration keyspaceConfiguration, Cluster cluster, CassandraModule module) {
        this.module = module;
        this.session = this.createSession(cluster, keyspaceConfiguration.getKeyspace());
    }

    private Session createSession(Cluster cluster, String keyspace) {
        Session session = cluster.connect(keyspace);
        try {
            if (this.allOperationsAreFullyPerformed(session, this.module)) {
                new CassandraSchemaVersionDAO(session).updateVersion(CassandraSchemaVersionManager.MAX_VERSION).block();
            }
            return session;
        }
        catch (Exception e) {
            session.close();
            throw e;
        }
    }

    private boolean allOperationsAreFullyPerformed(Session session, CassandraModule module) {
        Stream<Boolean> operations = Stream.of(this.createTypes(session, module), this.createTables(session, module));
        return operations.allMatch(updated -> updated);
    }

    private boolean createTypes(Session session, CassandraModule module) {
        return new CassandraTypesCreator(module, session).initializeTypes() == CassandraType.InitializationStatus.FULL;
    }

    private boolean createTables(Session session, CassandraModule module) {
        return new CassandraTableManager(module, session).initializeTables() == CassandraTable.InitializationStatus.FULL;
    }

    public Session get() {
        return this.session;
    }

    @PreDestroy
    public synchronized void destroy() {
        this.session.close();
    }
}

