/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;

public final class DeleteRoleMappingRequest
implements Validatable {
    private final String name;
    private final RefreshPolicy refreshPolicy;

    public DeleteRoleMappingRequest(String name, @Nullable RefreshPolicy refreshPolicy) {
        if (!Strings.hasText((String)name)) {
            throw new IllegalArgumentException("role-mapping name is required");
        }
        this.name = name;
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public String getName() {
        return this.name;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.refreshPolicy});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteRoleMappingRequest other = (DeleteRoleMappingRequest)obj;
        return this.refreshPolicy == other.refreshPolicy && Objects.equals(this.name, other.name);
    }
}

