/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.datastream;

import org.apache.ratis.conf.Parameters;
import org.apache.ratis.datastream.DataStreamFactory;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ReflectionUtils;

public interface DataStreamType {
    public static DataStreamType valueOf(String dataStreamType) {
        try {
            return SupportedDataStreamType.valueOfIgnoreCase(dataStreamType);
        }
        catch (Throwable t) {
            Throwable fromSupportedRpcType = t;
            try {
                return ReflectionUtils.newInstance(ReflectionUtils.getClass(dataStreamType, DataStreamType.class));
            }
            catch (Throwable t2) {
                String classname = JavaUtils.getClassSimpleName(DataStreamType.class);
                IllegalArgumentException iae = new IllegalArgumentException("Invalid " + classname + ": \"" + dataStreamType + "\"  cannot be used as a user-defined " + classname + " and it is not a " + JavaUtils.getClassSimpleName(SupportedDataStreamType.class) + ".");
                iae.addSuppressed(t2);
                iae.addSuppressed(fromSupportedRpcType);
                throw iae;
            }
        }
    }

    public String name();

    public DataStreamFactory newClientFactory(Parameters var1);

    public DataStreamFactory newServerFactory(Parameters var1);

    public static interface Get {
        public DataStreamType getDataStreamType();
    }
}

