/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Block;
import org.apache.baremaps.openstreetmap.model.DataBlock;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.HeaderBlock;
import org.apache.baremaps.stream.StreamException;

public class BlockEntitiesHandler
implements Consumer<Block> {
    private final Consumer<Entity> consumer;

    public BlockEntitiesHandler(Consumer<Entity> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void accept(Block block) {
        if (block instanceof HeaderBlock) {
            HeaderBlock headerBlock = (HeaderBlock)block;
            this.consumer.accept(headerBlock.getHeader());
            this.consumer.accept(headerBlock.getBound());
        } else if (block instanceof DataBlock) {
            DataBlock dataBlock = (DataBlock)block;
            dataBlock.getDenseNodes().forEach(this.consumer);
            dataBlock.getNodes().forEach(this.consumer);
            dataBlock.getWays().forEach(this.consumer);
            dataBlock.getRelations().forEach(this.consumer);
        } else {
            throw new StreamException("Unknown block type.");
        }
    }
}

