/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.error.code.generators;

import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import org.apache.ignite3.internal.error.code.generators.GenericGenerator;
import org.apache.ignite3.internal.error.code.processor.ErrorCodeGroupDescriptor;

public class CsharpGenerator
extends GenericGenerator {
    private static final String SuffixToChop = "Err";

    public CsharpGenerator(ProcessingEnvironment processingEnvironment, String outFilePath) {
        super(processingEnvironment, outFilePath);
    }

    private static String transfromErrorCodeName(String name) {
        String transformed = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name);
        if (transformed.endsWith(SuffixToChop)) {
            return transformed.substring(0, transformed.length() - SuffixToChop.length());
        }
        return transformed;
    }

    @Override
    void generateFile(List<ErrorCodeGroupDescriptor> descriptors) throws IOException {
        this.line("// <auto-generated/>");
        this.line("namespace Apache.Ignite");
        this.line("{");
        this.line("    using System;");
        this.line();
        this.generateClass(descriptors);
        this.line("}");
    }

    private void generateClass(List<ErrorCodeGroupDescriptor> descriptors) throws IOException {
        this.line("    public static partial class ErrorGroups");
        this.line("    {");
        this.line("        /// <summary>");
        this.line("        /// Gets the group name by code.");
        this.line("        /// </summary>");
        this.line("        /// <param name=\"groupCode\">Group code.</param>");
        this.line("        /// <returns>Group name.</returns>");
        this.line("        public static string GetGroupName(int groupCode) => groupCode switch");
        this.line("        {");
        for (ErrorCodeGroupDescriptor descriptor : descriptors) {
            this.line("            " + descriptor.className + ".GroupCode => " + descriptor.className + ".GroupName,");
        }
        this.line();
        this.line("            _ => UnknownGroupName");
        this.line("        };");
        this.line();
        this.line("        /// <summary>");
        this.line("        /// Gets the group error prefix by code.");
        this.line("        /// </summary>");
        this.line("        /// <param name=\"groupCode\">Group code.</param>");
        this.line("        /// <returns>Group error prefix.</returns>");
        this.line("        public static string GetErrorPrefix(int groupCode) => groupCode switch");
        this.line("        {");
        for (ErrorCodeGroupDescriptor descriptor : descriptors) {
            this.line("            " + descriptor.className + ".GroupCode => " + descriptor.className + ".ErrorPrefix,");
        }
        this.line();
        this.line("            _ => UnknownGroupName");
        this.line("        };");
        for (ErrorCodeGroupDescriptor descriptor : descriptors) {
            this.generateErrorGroupClass(descriptor);
        }
        this.line("    }");
    }

    private void generateErrorGroupClass(ErrorCodeGroupDescriptor descriptor) throws IOException {
        this.line();
        this.line("        /// <summary> " + descriptor.className + " errors. </summary>");
        this.line("        public static class " + descriptor.className);
        this.line("        {");
        this.line("            /// <summary> " + descriptor.className + " group code. </summary>");
        this.line("            public const short GroupCode = " + descriptor.groupCode + ";");
        this.line();
        this.line("            /// <summary> " + descriptor.className + " group name. </summary>");
        this.line("            public const String GroupName = \"" + descriptor.groupName + "\";");
        this.line();
        this.line("            /// <summary> " + descriptor.className + " error prefix. </summary>");
        this.line("            public const String ErrorPrefix = \"" + descriptor.errorPrefix + "\";");
        this.line();
        for (int i = 0; i < descriptor.errorCodes.size(); ++i) {
            this.generateErrorCode(descriptor.errorCodes.get((int)i).name, descriptor.errorCodes.get((int)i).code);
            if (i == descriptor.errorCodes.size() - 1) continue;
            this.line();
        }
        for (ErrorCodeGroupDescriptor.DeprecatedAlias deprecatedAlias : descriptor.deprecatedAliases) {
            this.generateDeprecatedAlias(deprecatedAlias);
        }
        this.line("        }");
    }

    private void generateErrorCode(String name, int code) throws IOException {
        this.line(String.format("            /// <summary> %s error. </summary>", CsharpGenerator.transfromErrorCodeName(name)));
        this.line(String.format("            public const int %s = (GroupCode << %d) | (%d & 0xFFFF);", CsharpGenerator.transfromErrorCodeName(name), 16, code));
    }

    private void generateDeprecatedAlias(ErrorCodeGroupDescriptor.DeprecatedAlias deprecatedAlias) throws IOException {
        String transformedAlias = CsharpGenerator.transfromErrorCodeName(deprecatedAlias.alias);
        String transformedTarget = CsharpGenerator.transfromErrorCodeName(deprecatedAlias.target);
        this.line();
        this.line(String.format("            /// <summary> %s is obsolete. Use %s instead. </summary>", transformedAlias, transformedTarget));
        this.line("            [Obsolete]");
        this.line(String.format("            public const int %s = %s;", transformedAlias, transformedTarget));
    }
}

