/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.storage.NewSystemViewEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class NewSystemViewEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class NewSystemViewEntrySerializerV2
    implements CatalogObjectSerializer<NewSystemViewEntry> {
        NewSystemViewEntrySerializerV2() {
        }

        @Override
        public NewSystemViewEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogSystemViewDescriptor descriptor = input.readEntry(CatalogSystemViewDescriptor.class);
            return new NewSystemViewEntry(descriptor);
        }

        @Override
        public void writeTo(NewSystemViewEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(entry.descriptor());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class NewSystemViewEntrySerializerV1
    implements CatalogObjectSerializer<NewSystemViewEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public NewSystemViewEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public NewSystemViewEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SYSTEM_VIEW.id());
            CatalogSystemViewDescriptor descriptor = (CatalogSystemViewDescriptor)serializer.readFrom(input);
            return new NewSystemViewEntry(descriptor);
        }

        @Override
        public void writeTo(NewSystemViewEntry entry, CatalogObjectDataOutput output) throws IOException {
            this.serializers.get(1, entry.descriptor().typeId()).writeTo(entry.descriptor(), output);
        }
    }
}

