/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.sql;

import java.util.List;
import org.apache.ignite3.internal.catalog.sql.QueryContext;
import org.apache.ignite3.internal.catalog.sql.QueryPart;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.table.QualifiedName;

class Name
extends QueryPart {
    private final List<String> names;
    private final QualifiedName qualifiedName;

    static Name simple(String name) {
        return new Name(List.of(name));
    }

    static Name qualified(QualifiedName qualifiedName) {
        return new Name(qualifiedName);
    }

    private Name(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
        this.names = null;
    }

    private Name(List<String> names) {
        for (String name : names) {
            if (name != null && !name.isEmpty()) continue;
            throw new IllegalArgumentException("Name parts can not be null or empty: " + names);
        }
        this.qualifiedName = null;
        this.names = names;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (this.qualifiedName != null) {
            ctx.sql(this.qualifiedName.toCanonicalForm());
        } else {
            assert (this.names != null) : "Names must be specified";
            String separator = "";
            for (String name : this.names) {
                if (name.startsWith("\"")) {
                    ctx.sql(separator).sql(name);
                } else {
                    String upperCase = name.toUpperCase();
                    if (IgniteNameUtils.isValidNormalizedIdentifier(upperCase)) {
                        ctx.sql(separator).sql(upperCase);
                    } else {
                        ctx.sql(separator).sql(IgniteNameUtils.quoteIfNeeded(name));
                    }
                }
                separator = ".";
            }
        }
    }
}

