/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class DiscoveryDataBag {
    private static final UUID DEFAULT_KEY = null;
    private UUID joiningNodeId;
    private Set<Integer> cmnDataInitializedCmps;
    private Map<Integer, Serializable> joiningNodeData = new HashMap<Integer, Serializable>();
    private Map<Integer, Serializable> commonData = new HashMap<Integer, Serializable>();
    private Map<UUID, Map<Integer, Serializable>> nodeSpecificData = new LinkedHashMap<UUID, Map<Integer, Serializable>>();
    private JoiningNodeDiscoveryDataImpl newJoinerData;
    private GridDiscoveryDataImpl gridData;
    private final boolean isJoiningNodeClient;

    public DiscoveryDataBag(UUID joiningNodeId, boolean isJoiningNodeClient) {
        this.joiningNodeId = joiningNodeId;
        this.isJoiningNodeClient = isJoiningNodeClient;
    }

    public DiscoveryDataBag(UUID joiningNodeId, Set<Integer> cmnDataInitializedCmps, boolean isJoiningNodeClient) {
        this.joiningNodeId = joiningNodeId;
        this.cmnDataInitializedCmps = cmnDataInitializedCmps;
        this.isJoiningNodeClient = isJoiningNodeClient;
    }

    public UUID joiningNodeId() {
        return this.joiningNodeId;
    }

    public boolean isJoiningNodeClient() {
        return this.isJoiningNodeClient;
    }

    public GridDiscoveryData gridDiscoveryData(int cmpId) {
        if (this.gridData == null) {
            this.gridData = new GridDiscoveryDataImpl();
        }
        this.gridData.componentId(cmpId);
        return this.gridData;
    }

    public JoiningNodeDiscoveryData newJoinerDiscoveryData(int cmpId) {
        if (this.newJoinerData == null) {
            this.newJoinerData = new JoiningNodeDiscoveryDataImpl();
        }
        this.newJoinerData.setComponentId(cmpId);
        return this.newJoinerData;
    }

    public void addJoiningNodeData(Integer cmpId, Serializable data) {
        this.joiningNodeData.put(cmpId, data);
    }

    public void addGridCommonData(Integer cmpId, Serializable data) {
        this.commonData.put(cmpId, data);
    }

    public void addNodeSpecificData(Integer cmpId, Serializable data) {
        if (!this.nodeSpecificData.containsKey(DEFAULT_KEY)) {
            this.nodeSpecificData.put(DEFAULT_KEY, new HashMap());
        }
        this.nodeSpecificData.get(DEFAULT_KEY).put(cmpId, data);
    }

    public boolean commonDataCollectedFor(Integer cmpId) {
        assert (this.cmnDataInitializedCmps != null);
        return this.cmnDataInitializedCmps.contains(cmpId);
    }

    public void joiningNodeData(Map<Integer, Serializable> joinNodeData) {
        this.joiningNodeData.putAll(joinNodeData);
    }

    public void commonData(Map<Integer, Serializable> cmnData) {
        this.commonData.putAll(cmnData);
    }

    public void nodeSpecificData(Map<UUID, Map<Integer, Serializable>> nodeSpecData) {
        this.nodeSpecificData.putAll(nodeSpecData);
    }

    public Map<Integer, Serializable> joiningNodeData() {
        return this.joiningNodeData;
    }

    public Map<Integer, Serializable> commonData() {
        return this.commonData;
    }

    @Nullable
    public Map<Integer, Serializable> localNodeSpecificData() {
        return this.nodeSpecificData.get(DEFAULT_KEY);
    }

    public String toString() {
        return S.toString(DiscoveryDataBag.class, this);
    }

    private final class GridDiscoveryDataImpl
    implements GridDiscoveryData {
        private int cmpId;
        private Map<UUID, Serializable> nodeSpecificData;

        private GridDiscoveryDataImpl() {
            this.nodeSpecificData = new LinkedHashMap<UUID, Serializable>(DiscoveryDataBag.this.nodeSpecificData.size());
        }

        @Override
        public UUID joiningNodeId() {
            return DiscoveryDataBag.this.joiningNodeId;
        }

        @Override
        @Nullable
        public Serializable commonData() {
            if (DiscoveryDataBag.this.commonData != null) {
                return DiscoveryDataBag.this.commonData.get(this.cmpId);
            }
            return null;
        }

        @Override
        public Map<UUID, Serializable> nodeSpecificData() {
            return this.nodeSpecificData;
        }

        private void componentId(int cmpId) {
            this.cmpId = cmpId;
            this.reinitNodeSpecData(cmpId);
        }

        private void reinitNodeSpecData(int cmpId) {
            this.nodeSpecificData.clear();
            for (Map.Entry<UUID, Map<Integer, Serializable>> e : DiscoveryDataBag.this.nodeSpecificData.entrySet()) {
                if (e.getValue() == null || !e.getValue().containsKey(cmpId)) continue;
                this.nodeSpecificData.put(e.getKey(), e.getValue().get(cmpId));
            }
        }
    }

    private final class JoiningNodeDiscoveryDataImpl
    implements JoiningNodeDiscoveryData {
        private int cmpId;

        private JoiningNodeDiscoveryDataImpl() {
        }

        @Override
        public UUID joiningNodeId() {
            return DiscoveryDataBag.this.joiningNodeId;
        }

        @Override
        public boolean hasJoiningNodeData() {
            return DiscoveryDataBag.this.joiningNodeData.containsKey(this.cmpId);
        }

        @Override
        @Nullable
        public Serializable joiningNodeData() {
            return DiscoveryDataBag.this.joiningNodeData.get(this.cmpId);
        }

        private void setComponentId(int cmpId) {
            this.cmpId = cmpId;
        }
    }

    public static interface GridDiscoveryData {
        public UUID joiningNodeId();

        public Serializable commonData();

        public Map<UUID, Serializable> nodeSpecificData();
    }

    public static interface JoiningNodeDiscoveryData {
        public UUID joiningNodeId();

        public boolean hasJoiningNodeData();

        public Serializable joiningNodeData();
    }
}

