/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.CircularStringBuilder;
import org.apache.ignite.internal.util.tostring.SBLimitedLength;

class SBLengthLimit {
    private static final int MAX_TO_STR_LEN = IgniteSystemProperties.getInteger("IGNITE_TO_STRING_MAX_LENGTH", 10000);
    private static final int TAIL_LEN = MAX_TO_STR_LEN / 10 * 2;
    private static final int HEAD_LEN = MAX_TO_STR_LEN - TAIL_LEN;
    private int len;

    SBLengthLimit() {
    }

    int length() {
        return this.len;
    }

    void reset() {
        this.len = 0;
    }

    void onWrite(SBLimitedLength sb, int writtenLen) {
        this.len += writtenLen;
        if (this.overflowed(sb) && (sb.getTail() == null || sb.getTail().length() == 0)) {
            CircularStringBuilder tail = this.getTail();
            int newSbLen = Math.min(sb.length(), HEAD_LEN + 1);
            tail.append(sb.impl().substring(newSbLen));
            sb.setTail(tail);
            sb.setLength(newSbLen);
        }
    }

    CircularStringBuilder getTail() {
        return new CircularStringBuilder(TAIL_LEN);
    }

    boolean overflowed(SBLimitedLength sb) {
        return sb.impl().length() > HEAD_LEN;
    }
}

