/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class DiscoveryDataClusterState
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final ClusterState state;
    private final long lastStateChangeTime;
    @Nullable
    private final BaselineTopology baselineTopology;
    private final UUID transitionReqId;
    private final ClusterState prevClusterState;
    @GridToStringInclude
    private final AffinityTopologyVersion transitionTopVer;
    @GridToStringExclude
    private final Set<UUID> transitionNodes;
    private volatile transient ClusterState transitionRes;
    private transient DiscoveryDataClusterState prevState;
    private volatile transient Exception transitionError;
    private volatile transient boolean locBaselineAutoAdjustment;

    static DiscoveryDataClusterState createState(ClusterState state, @Nullable BaselineTopology baselineTopology) {
        return new DiscoveryDataClusterState(null, state, baselineTopology, null, null, null, null);
    }

    static DiscoveryDataClusterState createTransitionState(ClusterState state, DiscoveryDataClusterState prevState, @Nullable BaselineTopology baselineTopology, UUID transitionReqId, AffinityTopologyVersion transitionTopVer, Set<UUID> transitionNodes) {
        assert (transitionReqId != null);
        assert (transitionTopVer != null);
        assert (!F.isEmpty(transitionNodes)) : transitionNodes;
        assert (prevState != null);
        return new DiscoveryDataClusterState(prevState, state, baselineTopology, transitionReqId, transitionTopVer, transitionNodes, prevState.state);
    }

    private DiscoveryDataClusterState(DiscoveryDataClusterState prevState, ClusterState state, @Nullable BaselineTopology baselineTopology, @Nullable UUID transitionReqId, @Nullable AffinityTopologyVersion transitionTopVer, @Nullable Set<UUID> transitionNodes, @Nullable ClusterState prevClusterState) {
        assert (state != null);
        this.prevState = prevState;
        this.state = state;
        this.lastStateChangeTime = U.currentTimeMillis();
        this.baselineTopology = baselineTopology;
        this.transitionReqId = transitionReqId;
        this.transitionTopVer = transitionTopVer;
        this.transitionNodes = transitionNodes;
        this.prevClusterState = prevClusterState;
    }

    public ClusterState lastState() {
        if (this.transition()) {
            return this.prevClusterState;
        }
        return this.state;
    }

    @Nullable
    public ClusterState transitionResult() {
        return this.transitionRes;
    }

    public void setTransitionResult(UUID reqId, ClusterState state) {
        if (reqId.equals(this.transitionReqId)) {
            this.transitionRes = state;
        }
    }

    public UUID transitionRequestId() {
        return this.transitionReqId;
    }

    public boolean transition() {
        return this.transitionReqId != null;
    }

    public boolean previouslyActive() {
        if (this.prevState != null) {
            return this.prevState.state != ClusterState.INACTIVE;
        }
        return this.state == ClusterState.INACTIVE;
    }

    public AffinityTopologyVersion transitionTopologyVersion() {
        return this.transitionTopVer;
    }

    @Deprecated
    public boolean active() {
        return this.state.active();
    }

    public ClusterState state() {
        return this.state;
    }

    public long lastStateChangeTime() {
        return this.lastStateChangeTime;
    }

    @Nullable
    public BaselineTopology baselineTopology() {
        return this.baselineTopology;
    }

    @Nullable
    public BaselineTopology previousBaselineTopology() {
        return this.prevState != null ? this.prevState.baselineTopology() : null;
    }

    public boolean baselineChanged() {
        BaselineTopology prevBLT = this.previousBaselineTopology();
        BaselineTopology curBLT = this.baselineTopology();
        if (prevBLT == null && curBLT != null) {
            return true;
        }
        if (prevBLT != null && curBLT != null) {
            return !prevBLT.equals(curBLT);
        }
        return false;
    }

    public boolean hasBaselineTopology() {
        return this.baselineTopology != null;
    }

    public Set<UUID> transitionNodes() {
        return this.transitionNodes;
    }

    @Nullable
    public Exception transitionError() {
        return this.transitionError;
    }

    public void transitionError(Exception ex) {
        this.transitionError = ex;
    }

    public boolean localBaselineAutoAdjustment() {
        return this.locBaselineAutoAdjustment;
    }

    public void localBaselineAutoAdjustment(boolean adjusted) {
        this.locBaselineAutoAdjustment = adjusted;
    }

    public DiscoveryDataClusterState finish(boolean success) {
        if (success) {
            return DiscoveryDataClusterState.createState(this.state, this.baselineTopology);
        }
        return this.prevState != null ? this.prevState : DiscoveryDataClusterState.createState(ClusterState.INACTIVE, null);
    }

    public String toString() {
        return S.toString(DiscoveryDataClusterState.class, this);
    }
}

